<?php

namespace ip_limit;

/**
 * IP 地址省份查询类
 * 参考 ngx_ip_data.h 文件格式实现
 */
class IpLocationQuery
{
    /**
     * IP 地址范围数据
     * 格式：[起始IP整数, 结束IP整数, 省份简写]
     */
    private $ipData = [
        [ 0x01000100, 0x010003FF, "FJ" ],  // 1.0.1.0-1.0.3.255, FJ
        [ 0x01000800, 0x01000FFF, "GD" ],  // 1.0.8.0-1.0.15.255, GD
        [ 0x01002000, 0x01003FFF, "GD" ],  // 1.0.32.0-1.0.63.255, GD
        [ 0x01010000, 0x010100FF, "FJ" ],  // 1.1.0.0-1.1.0.255, FJ
        [ 0x01010200, 0x010107FF, "FJ" ],  // 1.1.2.0-1.1.7.255, FJ
        [ 0x01010800, 0x01013FFF, "GD" ],  // 1.1.8.0-1.1.63.255, GD
        [ 0x01020000, 0x010201FF, "FJ" ],  // 1.2.0.0-1.2.1.255, FJ
        [ 0x01020200, 0x010202FF, "BJ" ],  // 1.2.2.0-1.2.2.255, BJ
        [ 0x01020400, 0x010205FF, "BJ" ],  // 1.2.4.0-1.2.5.255, BJ
        [ 0x01020600, 0x010207FF, "FJ" ],  // 1.2.6.0-1.2.7.255, FJ
        [ 0x01020800, 0x010208FF, "BJ" ],  // 1.2.8.0-1.2.8.255, BJ
        [ 0x01020900, 0x01027FFF, "GD" ],  // 1.2.9.0-1.2.127.255, GD
        [ 0x01030000, 0x0103FFFF, "GD" ],  // 1.3.0.0-1.3.255.255, GD
        [ 0x01040100, 0x010403FF, "FJ" ],  // 1.4.1.0-1.4.3.255, FJ
        [ 0x01040400, 0x010404FF, "BJ" ],  // 1.4.4.0-1.4.4.255, BJ
        [ 0x01040500, 0x010407FF, "FJ" ],  // 1.4.5.0-1.4.7.255, FJ
        [ 0x01040800, 0x01047FFF, "GD" ],  // 1.4.8.0-1.4.127.255, GD
        [ 0x01080000, 0x0108FFFF, "BJ" ],  // 1.8.0.0-1.8.255.255, BJ
        [ 0x010A0000, 0x010A07FF, "GD" ],  // 1.10.0.0-1.10.7.255, GD
        [ 0x010A0800, 0x010A09FF, "FJ" ],  // 1.10.8.0-1.10.9.255, FJ
        [ 0x010A0B00, 0x010A0FFF, "FJ" ],  // 1.10.11.0-1.10.15.255, FJ
        [ 0x010A1000, 0x010A7FFF, "GD" ],  // 1.10.16.0-1.10.127.255, GD
        [ 0x010C0000, 0x010C09FF, "BJ" ],  // 1.12.0.0-1.12.9.255, BJ
        [ 0x010C0A00, 0x010C0CFF, "GD" ],  // 1.12.10.0-1.12.12.255, GD
        [ 0x010C0D00, 0x010C23FF, "BJ" ],  // 1.12.13.0-1.12.35.255, BJ
        [ 0x010C2400, 0x010CFFFF, "GD" ],  // 1.12.36.0-1.12.255.255, GD
        [ 0x010D0000, 0x010D96FF, "JS" ],  // 1.13.0.0-1.13.150.255, JS
        [ 0x010D9700, 0x010D97FF, "CQ" ],  // 1.13.151.0-1.13.151.255, CQ
        [ 0x010D9800, 0x010DFFFF, "JS" ],  // 1.13.152.0-1.13.255.255, JS
        [ 0x010E0000, 0x010E7FFF, "SC" ],  // 1.14.0.0-1.14.127.255, SC
        [ 0x010E8000, 0x010EFFFF, "GD" ],  // 1.14.128.0-1.14.255.255, GD
        [ 0x010F0000, 0x010FFFFF, "SH" ],  // 1.15.0.0-1.15.255.255, SH
        [ 0x01180000, 0x011FFFFF, "NM" ],  // 1.24.0.0-1.31.255.255, NM
        [ 0x012D0000, 0x012DFFFF, "BJ" ],  // 1.45.0.0-1.45.255.255, BJ
        [ 0x01300000, 0x0131FFFF, "GZ" ],  // 1.48.0.0-1.49.255.255, GZ
        [ 0x01320000, 0x013263FF, "NX" ],  // 1.50.0.0-1.50.99.255, NX
        [ 0x01326400, 0x013264FF, "JS" ],  // 1.50.100.0-1.50.100.255, JS
        [ 0x01326500, 0x0132FFFF, "NX" ],  // 1.50.101.0-1.50.255.255, NX
        [ 0x01330000, 0x01330FFF, "SD" ],  // 1.51.0.0-1.51.15.255, SD
        [ 0x01331000, 0x01333FFF, "JS" ],  // 1.51.16.0-1.51.63.255, JS
        [ 0x01334000, 0x01336FFF, "SD" ],  // 1.51.64.0-1.51.111.255, SD
        [ 0x01337000, 0x01337FFF, "AH" ],  // 1.51.112.0-1.51.127.255, AH
        [ 0x01338000, 0x0133FFFF, "SD" ],  // 1.51.128.0-1.51.255.255, SD
        [ 0x01380000, 0x013F46FF, "HL" ],  // 1.56.0.0-1.63.70.255, HL
        [ 0x013F4700, 0x013F48FF, "NM" ],  // 1.63.71.0-1.63.72.255, NM
        [ 0x013F4900, 0x013FFFFF, "HL" ],  // 1.63.73.0-1.63.255.255, HL
        [ 0x01440000, 0x0147FFFF, "SX" ],  // 1.68.0.0-1.71.255.255, SX
        [ 0x01500000, 0x0157FFFF, "SN" ],  // 1.80.0.0-1.87.255.255, SN
        [ 0x01580000, 0x0158A1FF, "BJ" ],  // 1.88.0.0-1.88.161.255, BJ
        [ 0x0158A200, 0x0158A3FF, "HE" ],  // 1.88.162.0-1.88.163.255, HE
        [ 0x0158A400, 0x01591FFF, "BJ" ],  // 1.88.164.0-1.89.31.255, BJ
        [ 0x01592000, 0x015921FF, "HE" ],  // 1.89.32.0-1.89.33.255, HE
        [ 0x01592200, 0x015A4FFF, "BJ" ],  // 1.89.34.0-1.90.79.255, BJ
        [ 0x015A5000, 0x015A50FF, "HE" ],  // 1.90.80.0-1.90.80.255, HE
        [ 0x015A5100, 0x015A7BFF, "BJ" ],  // 1.90.81.0-1.90.123.255, BJ
        [ 0x015A7C00, 0x015A7DFF, "HE" ],  // 1.90.124.0-1.90.125.255, HE
        [ 0x015A7E00, 0x015BFFFF, "BJ" ],  // 1.90.126.0-1.91.255.255, BJ
        [ 0x015C0000, 0x015C0FFF, "GD" ],  // 1.92.0.0-1.92.15.255, GD
        [ 0x015C1000, 0x015DFFFF, "BJ" ],  // 1.92.16.0-1.93.255.255, BJ
        [ 0x015E0000, 0x015E7FFF, "SH" ],  // 1.94.0.0-1.94.127.255, SH
        [ 0x015E8000, 0x015FFFFF, "BJ" ],  // 1.94.128.0-1.95.255.255, BJ
        [ 0x01740000, 0x0175FFFF, "SH" ],  // 1.116.0.0-1.117.255.255, SH
        [ 0x01770000, 0x0177FFFF, "BJ" ],  // 1.119.0.0-1.119.255.255, BJ
        [ 0x01B40000, 0x01B7FFFF, "NM" ],  // 1.180.0.0-1.183.255.255, NM
        [ 0x01B80000, 0x01B8FFFF, "GD" ],  // 1.184.0.0-1.184.255.255, GD
        [ 0x01B90000, 0x01B95FFF, "GX" ],  // 1.185.0.0-1.185.95.255, GX
        [ 0x01B96000, 0x01B9BFFF, "GD" ],  // 1.185.96.0-1.185.191.255, GD
        [ 0x01B9C000, 0x01B9FFFF, "GX" ],  // 1.185.192.0-1.185.255.255, GX
        [ 0x01BC0000, 0x01BFFFFF, "HL" ],  // 1.188.0.0-1.191.255.255, HL
        [ 0x01C00000, 0x01C7FFFF, "HA" ],  // 1.192.0.0-1.199.255.255, HA
        [ 0x01CA0000, 0x01CBFFFF, "BJ" ],  // 1.202.0.0-1.203.255.255, BJ
        [ 0x01CC0000, 0x01CFFFFF, "GZ" ],  // 1.204.0.0-1.207.255.255, GZ
        [ 0x052AC000, 0x052AC0FF, "BJ" ],  // 5.42.192.0-5.42.192.255, BJ
        [ 0x05B4F400, 0x05B4F7FF, "SH" ],  // 5.180.244.0-5.180.247.255, SH
        [ 0x05B5E300, 0x05B5E3FF, "SH" ],  // 5.181.227.0-5.181.227.255, SH
        [ 0x08800000, 0x08801FFF, "SH" ],  // 8.128.0.0-8.128.31.255, SH
        [ 0x08802000, 0x0880FFFF, "BJ" ],  // 8.128.32.0-8.128.255.255, BJ
        [ 0x08810000, 0x0881FFFF, "GD" ],  // 8.129.0.0-8.129.255.255, GD
        [ 0x08820000, 0x0883FFFF, "BJ" ],  // 8.130.0.0-8.131.255.255, BJ
        [ 0x08840000, 0x0885FFFF, "SH" ],  // 8.132.0.0-8.133.255.255, SH
        [ 0x08860000, 0x0887FFFF, "GD" ],  // 8.134.0.0-8.135.255.255, GD
        [ 0x08880000, 0x0888FFFF, "ZJ" ],  // 8.136.0.0-8.136.255.255, ZJ
        [ 0x08890000, 0x0889FFFF, "SC" ],  // 8.137.0.0-8.137.255.255, SC
        [ 0x088A0000, 0x088AFFFF, "GD" ],  // 8.138.0.0-8.138.255.255, GD
        [ 0x088B0000, 0x088BFFFF, "ZJ" ],  // 8.139.0.0-8.139.255.255, ZJ
        [ 0x088C0000, 0x089FFFFF, "BJ" ],  // 8.140.0.0-8.159.255.255, BJ
        [ 0x08A00000, 0x08A01FFF, "GD" ],  // 8.160.0.0-8.160.31.255, GD
        [ 0x08A02000, 0x08BFFFFF, "SC" ],  // 8.160.32.0-8.191.255.255, SC
        [ 0x0D68B850, 0x0D68B85F, "BJ" ],  // 13.104.184.80-13.104.184.95, BJ
        [ 0x0E000000, 0x0E0007FF, "GD" ],  // 14.0.0.0-14.0.7.255, GD
        [ 0x0E000C00, 0x0E000FFF, "FJ" ],  // 14.0.12.0-14.0.15.255, FJ
        [ 0x0E010000, 0x0E0103FF, "FJ" ],  // 14.1.0.0-14.1.3.255, FJ
        [ 0x0E011800, 0x0E011BFF, "LN" ],  // 14.1.24.0-14.1.27.255, LN
        [ 0x0E016000, 0x0E0162FF, "GX" ],  // 14.1.96.0-14.1.98.255, GX
        [ 0x0E016C00, 0x0E016FFF, "SH" ],  // 14.1.108.0-14.1.111.255, SH
        [ 0x0E100000, 0x0E1FFFFF, "GD" ],  // 14.16.0.0-14.31.255.255, GD
        [ 0x0E668000, 0x0E6683FF, "FJ" ],  // 14.102.128.0-14.102.131.255, FJ
        [ 0x0E669C00, 0x0E669FFF, "SH" ],  // 14.102.156.0-14.102.159.255, SH
        [ 0x0E66B400, 0x0E66B7FF, "BJ" ],  // 14.102.180.0-14.102.183.255, BJ
        [ 0x0E670000, 0x0E67FFFF, "GD" ],  // 14.103.0.0-14.103.255.255, GD
        [ 0x0E680000, 0x0E6E89FF, "CQ" ],  // 14.104.0.0-14.110.137.255, CQ
        [ 0x0E6E8A00, 0x0E6E8AFF, "SN" ],  // 14.110.138.0-14.110.138.255, SN
        [ 0x0E6E8B00, 0x0E6FFFFF, "CQ" ],  // 14.110.139.0-14.111.255.255, CQ
        [ 0x0E700000, 0x0E7FFFFF, "GD" ],  // 14.112.0.0-14.127.255.255, GD
        [ 0x0E820000, 0x0E83FFFF, "BJ" ],  // 14.130.0.0-14.131.255.255, BJ
        [ 0x0E860000, 0x0E87FFFF, "NX" ],  // 14.134.0.0-14.135.255.255, NX
        [ 0x0E900000, 0x0E9FFFFF, "GD" ],  // 14.144.0.0-14.159.255.255, GD
        [ 0x0EC03C00, 0x0EC03FFF, "BJ" ],  // 14.192.60.0-14.192.63.255, BJ
        [ 0x0EC04C00, 0x0EC04FFF, "FJ" ],  // 14.192.76.0-14.192.79.255, FJ
        [ 0x0EC40000, 0x0EC4FFFF, "SC" ],  // 14.196.0.0-14.196.255.255, SC
        [ 0x0EC50000, 0x0EC57FFF, "GD" ],  // 14.197.0.0-14.197.127.255, GD
        [ 0x0EC58000, 0x0EC58FFF, "SN" ],  // 14.197.128.0-14.197.143.255, SN
        [ 0x0EC59000, 0x0EC593FF, "GX" ],  // 14.197.144.0-14.197.147.255, GX
        [ 0x0EC59400, 0x0EC595FF, "BJ" ],  // 14.197.148.0-14.197.149.255, BJ
        [ 0x0EC59600, 0x0EC59FFF, "HE" ],  // 14.197.150.0-14.197.159.255, HE
        [ 0x0EC5A000, 0x0EC5AFFF, "GD" ],  // 14.197.160.0-14.197.175.255, GD
        [ 0x0EC5B000, 0x0EC5BBFF, "BJ" ],  // 14.197.176.0-14.197.187.255, BJ
        [ 0x0EC5BC00, 0x0EC5C3FF, "ZJ" ],  // 14.197.188.0-14.197.195.255, ZJ
        [ 0x0EC5C400, 0x0EC5EFFF, "BJ" ],  // 14.197.196.0-14.197.239.255, BJ
        [ 0x0EC5F000, 0x0EC5F2FF, "SN" ],  // 14.197.240.0-14.197.242.255, SN
        [ 0x0EC5F300, 0x0EC5FFFF, "BJ" ],  // 14.197.243.0-14.197.255.255, BJ
        [ 0x0ECC0000, 0x0ECDFFFF, "YN" ],  // 14.204.0.0-14.205.255.255, YN
        [ 0x0ED00000, 0x0EDFFFFF, "GD" ],  // 14.208.0.0-14.223.255.255, GD
        [ 0x0FE62900, 0x0FE629FF, "BJ" ],  // 15.230.41.0-15.230.41.255, BJ
        [ 0x0FE63100, 0x0FE631FF, "BJ" ],  // 15.230.49.0-15.230.49.255, BJ
        [ 0x0FE68D00, 0x0FE68DFF, "BJ" ],  // 15.230.141.0-15.230.141.255, BJ
        [ 0x0FF805E4, 0x0FF805E7, "BJ" ],  // 15.248.5.228-15.248.5.231, BJ
        [ 0x11510200, 0x115105FF, "SH" ],  // 17.81.2.0-17.81.5.255, SH
        [ 0x11510700, 0x115107FF, "HA" ],  // 17.81.7.0-17.81.7.255, HA
        [ 0x11510800, 0x115111FF, "GD" ],  // 17.81.8.0-17.81.17.255, GD
        [ 0x11511200, 0x115115FF, "SH" ],  // 17.81.18.0-17.81.21.255, SH
        [ 0x11511600, 0x115119FF, "HA" ],  // 17.81.22.0-17.81.25.255, HA
        [ 0x11511A00, 0x11511AFF, "ZJ" ],  // 17.81.26.0-17.81.26.255, ZJ
        [ 0x11511B00, 0x11511BFF, "GD" ],  // 17.81.27.0-17.81.27.255, GD
        [ 0x11511C00, 0x11511FFF, "JS" ],  // 17.81.28.0-17.81.31.255, JS
        [ 0x11512000, 0x115120FF, "SC" ],  // 17.81.32.0-17.81.32.255, SC
        [ 0x11512100, 0x115121FF, "SH" ],  // 17.81.33.0-17.81.33.255, SH
        [ 0x11512200, 0x115122FF, "SX" ],  // 17.81.34.0-17.81.34.255, SX
        [ 0x11512300, 0x115124FF, "JS" ],  // 17.81.35.0-17.81.36.255, JS
        [ 0x11512500, 0x115125FF, "CQ" ],  // 17.81.37.0-17.81.37.255, CQ
        [ 0x11512600, 0x115126FF, "JS" ],  // 17.81.38.0-17.81.38.255, JS
        [ 0x11512800, 0x115129FF, "GD" ],  // 17.81.40.0-17.81.41.255, GD
        [ 0x11512A00, 0x11512AFF, "CQ" ],  // 17.81.42.0-17.81.42.255, CQ
        [ 0x11512B00, 0x11512BFF, "SH" ],  // 17.81.43.0-17.81.43.255, SH
        [ 0x11512C00, 0x11512CFF, "SC" ],  // 17.81.44.0-17.81.44.255, SC
        [ 0x11512D00, 0x11512EFF, "GD" ],  // 17.81.45.0-17.81.46.255, GD
        [ 0x11512F00, 0x115130FF, "SH" ],  // 17.81.47.0-17.81.48.255, SH
        [ 0x11513100, 0x115131FF, "JS" ],  // 17.81.49.0-17.81.49.255, JS
        [ 0x11513200, 0x115132FF, "SD" ],  // 17.81.50.0-17.81.50.255, SD
        [ 0x11513300, 0x115133FF, "ZJ" ],  // 17.81.51.0-17.81.51.255, ZJ
        [ 0x11513400, 0x115134FF, "JS" ],  // 17.81.52.0-17.81.52.255, JS
        [ 0x11513500, 0x115135FF, "SC" ],  // 17.81.53.0-17.81.53.255, SC
        [ 0x11513600, 0x115136FF, "JS" ],  // 17.81.54.0-17.81.54.255, JS
        [ 0x11513700, 0x115137FF, "GD" ],  // 17.81.55.0-17.81.55.255, GD
        [ 0x11513800, 0x115138FF, "HN" ],  // 17.81.56.0-17.81.56.255, HN
        [ 0x11513900, 0x115139FF, "GD" ],  // 17.81.57.0-17.81.57.255, GD
        [ 0x11513A00, 0x11513AFF, "ZJ" ],  // 17.81.58.0-17.81.58.255, ZJ
        [ 0x11513B00, 0x11513BFF, "JX" ],  // 17.81.59.0-17.81.59.255, JX
        [ 0x11513E00, 0x11513FFF, "JS" ],  // 17.81.62.0-17.81.63.255, JS
        [ 0x11514000, 0x115140FF, "SC" ],  // 17.81.64.0-17.81.64.255, SC
        [ 0x11514100, 0x115144FF, "GD" ],  // 17.81.65.0-17.81.68.255, GD
        [ 0x11514500, 0x115145FF, "SX" ],  // 17.81.69.0-17.81.69.255, SX
        [ 0x11514700, 0x115148FF, "JS" ],  // 17.81.71.0-17.81.72.255, JS
        [ 0x11514900, 0x115149FF, "GD" ],  // 17.81.73.0-17.81.73.255, GD
        [ 0x11514B00, 0x11514BFF, "JS" ],  // 17.81.75.0-17.81.75.255, JS
        [ 0x11514C00, 0x11514CFF, "ZJ" ],  // 17.81.76.0-17.81.76.255, ZJ
        [ 0x11514D00, 0x11514DFF, "SX" ],  // 17.81.77.0-17.81.77.255, SX
        [ 0x11514E00, 0x115153FF, "JS" ],  // 17.81.78.0-17.81.83.255, JS
        [ 0x11515500, 0x115155FF, "YN" ],  // 17.81.85.0-17.81.85.255, YN
        [ 0x11515600, 0x115156FF, "JS" ],  // 17.81.86.0-17.81.86.255, JS
        [ 0x11515700, 0x115157FF, "GD" ],  // 17.81.87.0-17.81.87.255, GD
        [ 0x11515800, 0x115159FF, "JS" ],  // 17.81.88.0-17.81.89.255, JS
        [ 0x11515E00, 0x11515EFF, "SH" ],  // 17.81.94.0-17.81.94.255, SH
        [ 0x11515F00, 0x11515FFF, "SD" ],  // 17.81.95.0-17.81.95.255, SD
        [ 0x11516000, 0x115162FF, "ZJ" ],  // 17.81.96.0-17.81.98.255, ZJ
        [ 0x11516300, 0x115163FF, "BJ" ],  // 17.81.99.0-17.81.99.255, BJ
        [ 0x11516400, 0x115164FF, "GD" ],  // 17.81.100.0-17.81.100.255, GD
        [ 0x11516C00, 0x11516CFF, "JX" ],  // 17.81.108.0-17.81.108.255, JX
        [ 0x11518000, 0x115180FF, "SH" ],  // 17.81.128.0-17.81.128.255, SH
        [ 0x11518100, 0x115181FF, "HA" ],  // 17.81.129.0-17.81.129.255, HA
        [ 0x11518200, 0x115182FF, "GD" ],  // 17.81.130.0-17.81.130.255, GD
        [ 0x11518300, 0x115183FF, "SH" ],  // 17.81.131.0-17.81.131.255, SH
        [ 0x11518400, 0x115184FF, "HA" ],  // 17.81.132.0-17.81.132.255, HA
        [ 0x11518500, 0x115185FF, "JS" ],  // 17.81.133.0-17.81.133.255, JS
        [ 0x11518600, 0x115186FF, "SH" ],  // 17.81.134.0-17.81.134.255, SH
        [ 0x11518700, 0x115187FF, "JS" ],  // 17.81.135.0-17.81.135.255, JS
        [ 0x11518800, 0x115188FF, "GD" ],  // 17.81.136.0-17.81.136.255, GD
        [ 0x11518900, 0x115189FF, "SH" ],  // 17.81.137.0-17.81.137.255, SH
        [ 0x11518A00, 0x11518AFF, "SX" ],  // 17.81.138.0-17.81.138.255, SX
        [ 0x11518B00, 0x11518BFF, "JS" ],  // 17.81.139.0-17.81.139.255, JS
        [ 0x11518C00, 0x11518CFF, "SC" ],  // 17.81.140.0-17.81.140.255, SC
        [ 0x11518D00, 0x11518DFF, "SH" ],  // 17.81.141.0-17.81.141.255, SH
        [ 0x11518E00, 0x11518EFF, "GD" ],  // 17.81.142.0-17.81.142.255, GD
        [ 0x11518F00, 0x11518FFF, "CQ" ],  // 17.81.143.0-17.81.143.255, CQ
        [ 0x11519000, 0x115190FF, "JS" ],  // 17.81.144.0-17.81.144.255, JS
        [ 0x11519200, 0x115192FF, "GD" ],  // 17.81.146.0-17.81.146.255, GD
        [ 0x11519300, 0x115193FF, "SH" ],  // 17.81.147.0-17.81.147.255, SH
        [ 0x11519400, 0x115194FF, "CQ" ],  // 17.81.148.0-17.81.148.255, CQ
        [ 0x11519500, 0x115195FF, "GD" ],  // 17.81.149.0-17.81.149.255, GD
        [ 0x11519600, 0x115196FF, "SH" ],  // 17.81.150.0-17.81.150.255, SH
        [ 0x11519700, 0x115197FF, "JS" ],  // 17.81.151.0-17.81.151.255, JS
        [ 0x11519800, 0x115198FF, "SD" ],  // 17.81.152.0-17.81.152.255, SD
        [ 0x11519900, 0x115199FF, "ZJ" ],  // 17.81.153.0-17.81.153.255, ZJ
        [ 0x11519A00, 0x11519AFF, "JS" ],  // 17.81.154.0-17.81.154.255, JS
        [ 0x11519B00, 0x11519BFF, "SC" ],  // 17.81.155.0-17.81.155.255, SC
        [ 0x11519C00, 0x11519CFF, "JS" ],  // 17.81.156.0-17.81.156.255, JS
        [ 0x11519D00, 0x11519DFF, "GD" ],  // 17.81.157.0-17.81.157.255, GD
        [ 0x11519E00, 0x11519EFF, "HN" ],  // 17.81.158.0-17.81.158.255, HN
        [ 0x11519F00, 0x11519FFF, "GD" ],  // 17.81.159.0-17.81.159.255, GD
        [ 0x1151A100, 0x1151A1FF, "JX" ],  // 17.81.161.0-17.81.161.255, JX
        [ 0x1151A400, 0x1151A4FF, "GD" ],  // 17.81.164.0-17.81.164.255, GD
        [ 0x1151A600, 0x1151A6FF, "GD" ],  // 17.81.166.0-17.81.166.255, GD
        [ 0x1151A700, 0x1151A7FF, "JS" ],  // 17.81.167.0-17.81.167.255, JS
        [ 0x1151A800, 0x1151A8FF, "SC" ],  // 17.81.168.0-17.81.168.255, SC
        [ 0x1151A900, 0x1151ACFF, "GD" ],  // 17.81.169.0-17.81.172.255, GD
        [ 0x1151AE00, 0x1151AFFF, "JS" ],  // 17.81.174.0-17.81.175.255, JS
        [ 0x1151B200, 0x1151B2FF, "JS" ],  // 17.81.178.0-17.81.178.255, JS
        [ 0x1151B300, 0x1151B3FF, "ZJ" ],  // 17.81.179.0-17.81.179.255, ZJ
        [ 0x1151B400, 0x1151B5FF, "JS" ],  // 17.81.180.0-17.81.181.255, JS
        [ 0x1151B700, 0x1151B7FF, "YN" ],  // 17.81.183.0-17.81.183.255, YN
        [ 0x1151B800, 0x1151B8FF, "JS" ],  // 17.81.184.0-17.81.184.255, JS
        [ 0x1151B900, 0x1151B9FF, "GD" ],  // 17.81.185.0-17.81.185.255, GD
        [ 0x1151BA00, 0x1151BBFF, "JS" ],  // 17.81.186.0-17.81.187.255, JS
        [ 0x1151BC00, 0x1151BCFF, "SH" ],  // 17.81.188.0-17.81.188.255, SH
        [ 0x1151BD00, 0x1151BDFF, "SD" ],  // 17.81.189.0-17.81.189.255, SD
        [ 0x1151C000, 0x1151C3FF, "SH" ],  // 17.81.192.0-17.81.195.255, SH
        [ 0x1151C400, 0x1151C6FF, "JS" ],  // 17.81.196.0-17.81.198.255, JS
        [ 0x1151C800, 0x1151CAFF, "GD" ],  // 17.81.200.0-17.81.202.255, GD
        [ 0x1151CC00, 0x1151CF7F, "GD" ],  // 17.81.204.0-17.81.207.127, GD
        [ 0x1151D000, 0x1151D2FF, "SH" ],  // 17.81.208.0-17.81.210.255, SH
        [ 0x1151D400, 0x1151D6FF, "HA" ],  // 17.81.212.0-17.81.214.255, HA
        [ 0x1151DA00, 0x1151DBFF, "JS" ],  // 17.81.218.0-17.81.219.255, JS
        [ 0x1151DE00, 0x1151DEFF, "SC" ],  // 17.81.222.0-17.81.222.255, SC
        [ 0x1151DF00, 0x1151DFFF, "SH" ],  // 17.81.223.0-17.81.223.255, SH
        [ 0x1151E100, 0x1151E1FF, "JS" ],  // 17.81.225.0-17.81.225.255, JS
        [ 0x1151E200, 0x1151E3FF, "ZJ" ],  // 17.81.226.0-17.81.227.255, ZJ
        [ 0x1151E400, 0x1151E4FF, "BJ" ],  // 17.81.228.0-17.81.228.255, BJ
        [ 0x1151E800, 0x1151E87F, "JS" ],  // 17.81.232.0-17.81.232.127, JS
        [ 0x1155A480, 0x1155A4FF, "SH" ],  // 17.85.164.128-17.85.164.255, SH
        [ 0x1155C000, 0x1155C7FF, "SH" ],  // 17.85.192.0-17.85.199.255, SH
        [ 0x1155C800, 0x1155CFFF, "TJ" ],  // 17.85.200.0-17.85.207.255, TJ
        [ 0x11570000, 0x115707FF, "BJ" ],  // 17.87.0.0-17.87.7.255, BJ
        [ 0x11570900, 0x115727FF, "BJ" ],  // 17.87.9.0-17.87.39.255, BJ
        [ 0x11573800, 0x11573FFF, "SC" ],  // 17.87.56.0-17.87.63.255, SC
        [ 0x11577000, 0x115777FF, "BJ" ],  // 17.87.112.0-17.87.119.255, BJ
        [ 0x1157F200, 0x1157F2BF, "GZ" ],  // 17.87.242.0-17.87.242.191, GZ
        [ 0x1157F300, 0x1157F3BF, "NM" ],  // 17.87.243.0-17.87.243.191, NM
        [ 0x11586C00, 0x11586DFF, "SH" ],  // 17.88.108.0-17.88.109.255, SH
        [ 0x1158CE00, 0x1158CEFF, "GD" ],  // 17.88.206.0-17.88.206.255, GD
        [ 0x115D0800, 0x115D0FFF, "LN" ],  // 17.93.8.0-17.93.15.255, LN
        [ 0x115D1800, 0x115D1FFF, "LN" ],  // 17.93.24.0-17.93.31.255, LN
        [ 0x115D3000, 0x115D37FF, "BJ" ],  // 17.93.48.0-17.93.55.255, BJ
        [ 0x115D3800, 0x115D3FFF, "FJ" ],  // 17.93.56.0-17.93.63.255, FJ
        [ 0x115D4000, 0x115D47FF, "GX" ],  // 17.93.64.0-17.93.71.255, GX
        [ 0x115D4800, 0x115D4FFF, "SH" ],  // 17.93.72.0-17.93.79.255, SH
        [ 0x115D6000, 0x115D67FF, "TJ" ],  // 17.93.96.0-17.93.103.255, TJ
        [ 0x115D6800, 0x115D6FFF, "JS" ],  // 17.93.104.0-17.93.111.255, JS
        [ 0x115D7000, 0x115D77FF, "FJ" ],  // 17.93.112.0-17.93.119.255, FJ
        [ 0x115D7800, 0x115D7FFF, "GD" ],  // 17.93.120.0-17.93.127.255, GD
        [ 0x115D8800, 0x115D8FFF, "YN" ],  // 17.93.136.0-17.93.143.255, YN
        [ 0x115D9800, 0x115D9FFF, "ZJ" ],  // 17.93.152.0-17.93.159.255, ZJ
        [ 0x115DC800, 0x115DCFFF, "SH" ],  // 17.93.200.0-17.93.207.255, SH
        [ 0x115DD000, 0x115DDFFF, "JS" ],  // 17.93.208.0-17.93.223.255, JS
        [ 0x115DE000, 0x115DE3FF, "ZJ" ],  // 17.93.224.0-17.93.227.255, ZJ
        [ 0x115DE800, 0x115DEFFF, "SH" ],  // 17.93.232.0-17.93.239.255, SH
        [ 0x115E0300, 0x115E0301, "TJ" ],  // 17.94.3.0-17.94.3.1, TJ
        [ 0x115E1000, 0x115E17FF, "BJ" ],  // 17.94.16.0-17.94.23.255, BJ
        [ 0x115E1800, 0x115E1FFF, "SH" ],  // 17.94.24.0-17.94.31.255, SH
        [ 0x115E2000, 0x115E27FF, "BJ" ],  // 17.94.32.0-17.94.39.255, BJ
        [ 0x115E2800, 0x115E3FFF, "SH" ],  // 17.94.40.0-17.94.63.255, SH
        [ 0x115E4000, 0x115E4FFF, "BJ" ],  // 17.94.64.0-17.94.79.255, BJ
        [ 0x115E5000, 0x115E57FF, "GD" ],  // 17.94.80.0-17.94.87.255, GD
        [ 0x115E5800, 0x115E5FFF, "SC" ],  // 17.94.88.0-17.94.95.255, SC
        [ 0x115E6000, 0x115E67FF, "ZJ" ],  // 17.94.96.0-17.94.103.255, ZJ
        [ 0x115E6800, 0x115E7FFF, "CQ" ],  // 17.94.104.0-17.94.127.255, CQ
        [ 0x115E8000, 0x115E87FF, "JS" ],  // 17.94.128.0-17.94.135.255, JS
        [ 0x115E8800, 0x115E8FFF, "TJ" ],  // 17.94.136.0-17.94.143.255, TJ
        [ 0x115E9000, 0x115E97FF, "ZJ" ],  // 17.94.144.0-17.94.151.255, ZJ
        [ 0x115E9800, 0x115E9FFF, "LN" ],  // 17.94.152.0-17.94.159.255, LN
        [ 0x115EA000, 0x115EAFFF, "SD" ],  // 17.94.160.0-17.94.175.255, SD
        [ 0x115EB000, 0x115EB7FF, "HN" ],  // 17.94.176.0-17.94.183.255, HN
        [ 0x115EB800, 0x115EBFFF, "HA" ],  // 17.94.184.0-17.94.191.255, HA
        [ 0x115EC000, 0x115EC7FF, "JS" ],  // 17.94.192.0-17.94.199.255, JS
        [ 0x115EC800, 0x115ECFFF, "GD" ],  // 17.94.200.0-17.94.207.255, GD
        [ 0x115ED000, 0x115ED7FF, "TJ" ],  // 17.94.208.0-17.94.215.255, TJ
        [ 0x115ED800, 0x115EDFFF, "SC" ],  // 17.94.216.0-17.94.223.255, SC
        [ 0x115EE000, 0x115EE7FF, "SH" ],  // 17.94.224.0-17.94.231.255, SH
        [ 0x115EE800, 0x115EEFFF, "HB" ],  // 17.94.232.0-17.94.239.255, HB
        [ 0x115EF000, 0x115EF7FF, "LN" ],  // 17.94.240.0-17.94.247.255, LN
        [ 0x117F8000, 0x117F81FF, "GD" ],  // 17.127.128.0-17.127.129.255, GD
        [ 0x117F8200, 0x117F82FF, "SH" ],  // 17.127.130.0-17.127.130.255, SH
        [ 0x11EBA000, 0x11EBA7FF, "TJ" ],  // 17.235.160.0-17.235.167.255, TJ
        [ 0x11EBA800, 0x11EBAFFF, "SH" ],  // 17.235.168.0-17.235.175.255, SH
        [ 0x1B008000, 0x1B0083FF, "TJ" ],  // 27.0.128.0-27.0.131.255, TJ
        [ 0x1B008400, 0x1B0087FF, "FJ" ],  // 27.0.132.0-27.0.135.255, FJ
        [ 0x1B00A000, 0x1B00A7FF, "BJ" ],  // 27.0.160.0-27.0.167.255, BJ
        [ 0x1B00BC00, 0x1B00BFFF, "BJ" ],  // 27.0.188.0-27.0.191.255, BJ
        [ 0x1B00CC00, 0x1B00D7FF, "JS" ],  // 27.0.204.0-27.0.215.255, JS
        [ 0x1B080000, 0x1B0FFFFF, "CQ" ],  // 27.8.0.0-27.15.255.255, CQ
        [ 0x1B100000, 0x1B1FFFFF, "HB" ],  // 27.16.0.0-27.31.255.255, HB
        [ 0x1B22E800, 0x1B22EFFF, "GD" ],  // 27.34.232.0-27.34.239.255, GD
        [ 0x1B240000, 0x1B2FFFFF, "GD" ],  // 27.36.0.0-27.47.255.255, GD
        [ 0x1B322800, 0x1B322FFF, "GD" ],  // 27.50.40.0-27.50.47.255, GD
        [ 0x1B328000, 0x1B32FFFF, "HA" ],  // 27.50.128.0-27.50.255.255, HA
        [ 0x1B364800, 0x1B364FFF, "GD" ],  // 27.54.72.0-27.54.79.255, GD
        [ 0x1B369800, 0x1B369FFF, "GD" ],  // 27.54.152.0-27.54.159.255, GD
        [ 0x1B36C000, 0x1B36FFFF, "AH" ],  // 27.54.192.0-27.54.255.255, AH
        [ 0x1B62D000, 0x1B62DFFF, "BJ" ],  // 27.98.208.0-27.98.223.255, BJ
        [ 0x1B62E000, 0x1B62FFFF, "XZ" ],  // 27.98.224.0-27.98.255.255, XZ
        [ 0x1B638000, 0x1B63FFFF, "BJ" ],  // 27.99.128.0-27.99.255.255, BJ
        [ 0x1B670000, 0x1B67FFFF, "GD" ],  // 27.103.0.0-27.103.255.255, GD
        [ 0x1B6A8000, 0x1B6ABFFF, "GD" ],  // 27.106.128.0-27.106.191.255, GD
        [ 0x1B6ACC00, 0x1B6ACFFF, "BJ" ],  // 27.106.204.0-27.106.207.255, BJ
        [ 0x1B6D2000, 0x1B6D3FFF, "BJ" ],  // 27.109.32.0-27.109.63.255, BJ
        [ 0x1B6D7C00, 0x1B6D7FFF, "SH" ],  // 27.109.124.0-27.109.127.255, SH
        [ 0x1B700000, 0x1B703FFF, "TJ" ],  // 27.112.0.0-27.112.63.255, TJ
        [ 0x1B705000, 0x1B705FFF, "BJ" ],  // 27.112.80.0-27.112.95.255, BJ
        [ 0x1B707000, 0x1B7077FF, "BJ" ],  // 27.112.112.0-27.112.119.255, BJ
        [ 0x1B718000, 0x1B71BFFF, "SH" ],  // 27.113.128.0-27.113.191.255, SH
        [ 0x1B730000, 0x1B737FFF, "SH" ],  // 27.115.0.0-27.115.127.255, SH
        [ 0x1B742C00, 0x1B742FFF, "BJ" ],  // 27.116.44.0-27.116.47.255, BJ
        [ 0x1B794800, 0x1B794FFF, "GD" ],  // 27.121.72.0-27.121.79.255, GD
        [ 0x1B797800, 0x1B797FFF, "GD" ],  // 27.121.120.0-27.121.127.255, GD
        [ 0x1B7BE400, 0x1B7BE4FF, "FJ" ],  // 27.123.228.0-27.123.228.255, FJ
        [ 0x1B800000, 0x1B81FFFF, "HE" ],  // 27.128.0.0-27.129.255.255, HE
        [ 0x1B83DC00, 0x1B83DFFF, "BJ" ],  // 27.131.220.0-27.131.223.255, BJ
        [ 0x1B900000, 0x1B90FFFF, "CQ" ],  // 27.144.0.0-27.144.255.255, CQ
        [ 0x1B940000, 0x1B9FFFFF, "FJ" ],  // 27.148.0.0-27.159.255.255, FJ
        [ 0x1BB80000, 0x1BBFFFFF, "HE" ],  // 27.184.0.0-27.191.255.255, HE
        [ 0x1BC00000, 0x1BDFFFFF, "SD" ],  // 27.192.0.0-27.223.255.255, SD
        [ 0x1BE00000, 0x1BE3FFFF, "GS" ],  // 27.224.0.0-27.227.255.255, GS
        [ 0x1F394100, 0x1F3941FF, "BJ" ],  // 31.57.65.0-31.57.65.255, BJ
        [ 0x24000000, 0x240003FF, "FJ" ],  // 36.0.0.0-36.0.3.255, FJ
        [ 0x24000800, 0x24000FFF, "SH" ],  // 36.0.8.0-36.0.15.255, SH
        [ 0x24001000, 0x24003FFF, "GD" ],  // 36.0.16.0-36.0.63.255, GD
        [ 0x24004000, 0x2400FFFF, "BJ" ],  // 36.0.64.0-36.0.255.255, BJ
        [ 0x24010000, 0x2401FFFF, "HI" ],  // 36.1.0.0-36.1.255.255, HI
        [ 0x24040000, 0x2407FFFF, "AH" ],  // 36.4.0.0-36.7.255.255, AH
        [ 0x24100000, 0x241FFFFF, "ZJ" ],  // 36.16.0.0-36.31.255.255, ZJ
        [ 0x24200000, 0x2423FFFF, "AH" ],  // 36.32.0.0-36.35.255.255, AH
        [ 0x24240000, 0x24251FFF, "GD" ],  // 36.36.0.0-36.37.31.255, GD
        [ 0x24252400, 0x242525FF, "FJ" ],  // 36.37.36.0-36.37.37.255, FJ
        [ 0x24252700, 0x242527FF, "FJ" ],  // 36.37.39.0-36.37.39.255, FJ
        [ 0x24252800, 0x24253FFF, "GD" ],  // 36.37.40.0-36.37.63.255, GD
        [ 0x24280000, 0x242FFFFF, "SN" ],  // 36.40.0.0-36.47.255.255, SN
        [ 0x24300000, 0x2431FFFF, "JL" ],  // 36.48.0.0-36.49.255.255, JL
        [ 0x2432E200, 0x2432E3FF, "HN" ],  // 36.50.226.0-36.50.227.255, HN
        [ 0x2432FE00, 0x2432FFFF, "SH" ],  // 36.50.254.0-36.50.255.255, SH
        [ 0x24330000, 0x2433FFFF, "BJ" ],  // 36.51.0.0-36.51.255.255, BJ
        [ 0x24380000, 0x243FFFFF, "AH" ],  // 36.56.0.0-36.63.255.255, AH
        [ 0x24600000, 0x2460FFFF, "XJ" ],  // 36.96.0.0-36.96.255.255, XJ
        [ 0x24610000, 0x2461FFFF, "JL" ],  // 36.97.0.0-36.97.255.255, JL
        [ 0x24620000, 0x2462FFFF, "HE" ],  // 36.98.0.0-36.98.255.255, HE
        [ 0x24630000, 0x2463FFFF, "HA" ],  // 36.99.0.0-36.99.255.255, HA
        [ 0x24640000, 0x2464FFFF, "QH" ],  // 36.100.0.0-36.100.255.255, QH
        [ 0x24650000, 0x2465FFFF, "HI" ],  // 36.101.0.0-36.101.255.255, HI
        [ 0x24660000, 0x2466FFFF, "NM" ],  // 36.102.0.0-36.102.255.255, NM
        [ 0x24670000, 0x2467FFFF, "NX" ],  // 36.103.0.0-36.103.255.255, NX
        [ 0x24680000, 0x2468FFFF, "JL" ],  // 36.104.0.0-36.104.255.255, JL
        [ 0x24690000, 0x2469FFFF, "XJ" ],  // 36.105.0.0-36.105.255.255, XJ
        [ 0x246A0000, 0x246AFFFF, "TJ" ],  // 36.106.0.0-36.106.255.255, TJ
        [ 0x246B0000, 0x246DFFFF, "XJ" ],  // 36.107.0.0-36.109.255.255, XJ
        [ 0x246E0000, 0x246EFFFF, "BJ" ],  // 36.110.0.0-36.110.255.255, BJ
        [ 0x246F0000, 0x246F1FFF, "SH" ],  // 36.111.0.0-36.111.31.255, SH
        [ 0x246F2000, 0x246F3FFF, "GD" ],  // 36.111.32.0-36.111.63.255, GD
        [ 0x246F4000, 0x246F4FFF, "SC" ],  // 36.111.64.0-36.111.79.255, SC
        [ 0x246F5000, 0x246F58FF, "BJ" ],  // 36.111.80.0-36.111.88.255, BJ
        [ 0x246F5900, 0x246F5FFF, "HI" ],  // 36.111.89.0-36.111.95.255, HI
        [ 0x246F6000, 0x246F6FFF, "FJ" ],  // 36.111.96.0-36.111.111.255, FJ
        [ 0x246F7000, 0x246F7FFF, "HI" ],  // 36.111.112.0-36.111.127.255, HI
        [ 0x246F8000, 0x246F9BFF, "NM" ],  // 36.111.128.0-36.111.155.255, NM
        [ 0x246F9C00, 0x246F9FFF, "SN" ],  // 36.111.156.0-36.111.159.255, SN
        [ 0x246FA000, 0x246FBFFF, "GZ" ],  // 36.111.160.0-36.111.191.255, GZ
        [ 0x246FC000, 0x246FC7FF, "JS" ],  // 36.111.192.0-36.111.199.255, JS
        [ 0x246FC800, 0x246FCFFF, "HN" ],  // 36.111.200.0-36.111.207.255, HN
        [ 0x246FD000, 0x246FFFFF, "HI" ],  // 36.111.208.0-36.111.255.255, HI
        [ 0x24700000, 0x2470FFFF, "BJ" ],  // 36.112.0.0-36.112.255.255, BJ
        [ 0x24710000, 0x2471D7FF, "JS" ],  // 36.113.0.0-36.113.215.255, JS
        [ 0x2471D800, 0x2471DFFF, "SC" ],  // 36.113.216.0-36.113.223.255, SC
        [ 0x2471E000, 0x2471FFFF, "JS" ],  // 36.113.224.0-36.113.255.255, JS
        [ 0x24720000, 0x2472FFFF, "GZ" ],  // 36.114.0.0-36.114.255.255, GZ
        [ 0x24730000, 0x247FFFFF, "ZJ" ],  // 36.115.0.0-36.127.255.255, ZJ
        [ 0x24800000, 0x24847FFF, "LN" ],  // 36.128.0.0-36.132.127.255, LN
        [ 0x24848000, 0x2484FFFF, "HL" ],  // 36.132.128.0-36.132.255.255, HL
        [ 0x24850000, 0x24850BFF, "GD" ],  // 36.133.0.0-36.133.11.255, GD
        [ 0x24850C00, 0x248517FF, "HN" ],  // 36.133.12.0-36.133.23.255, HN
        [ 0x24851800, 0x248523FF, "JS" ],  // 36.133.24.0-36.133.35.255, JS
        [ 0x24852400, 0x24852FFF, "HA" ],  // 36.133.36.0-36.133.47.255, HA
        [ 0x24853000, 0x24853BFF, "BJ" ],  // 36.133.48.0-36.133.59.255, BJ
        [ 0x24853C00, 0x248547FF, "SC" ],  // 36.133.60.0-36.133.71.255, SC
        [ 0x24854800, 0x248553FF, "SH" ],  // 36.133.72.0-36.133.83.255, SH
        [ 0x24855400, 0x24855FFF, "ZJ" ],  // 36.133.84.0-36.133.95.255, ZJ
        [ 0x24856000, 0x24856BFF, "SN" ],  // 36.133.96.0-36.133.107.255, SN
        [ 0x24856C00, 0x248577FF, "CQ" ],  // 36.133.108.0-36.133.119.255, CQ
        [ 0x24857800, 0x248583FF, "SD" ],  // 36.133.120.0-36.133.131.255, SD
        [ 0x24858400, 0x24858FFF, "JS" ],  // 36.133.132.0-36.133.143.255, JS
        [ 0x24859000, 0x248597FF, "GD" ],  // 36.133.144.0-36.133.151.255, GD
        [ 0x24859800, 0x24859FFF, "HN" ],  // 36.133.152.0-36.133.159.255, HN
        [ 0x2485A000, 0x2485AFFF, "JS" ],  // 36.133.160.0-36.133.175.255, JS
        [ 0x2485B000, 0x2485BFFF, "GD" ],  // 36.133.176.0-36.133.191.255, GD
        [ 0x2485C000, 0x2485C7FF, "BJ" ],  // 36.133.192.0-36.133.199.255, BJ
        [ 0x2485C800, 0x2485CFFF, "SC" ],  // 36.133.200.0-36.133.207.255, SC
        [ 0x2485D000, 0x2485DFFF, "HA" ],  // 36.133.208.0-36.133.223.255, HA
        [ 0x2485E000, 0x2485E7FF, "GD" ],  // 36.133.224.0-36.133.231.255, GD
        [ 0x2485E800, 0x2485EFFF, "CQ" ],  // 36.133.232.0-36.133.239.255, CQ
        [ 0x2485F000, 0x2485F7FF, "BJ" ],  // 36.133.240.0-36.133.247.255, BJ
        [ 0x2485F800, 0x2485FFFF, "SN" ],  // 36.133.248.0-36.133.255.255, SN
        [ 0x24860000, 0x24860FFF, "ZJ" ],  // 36.134.0.0-36.134.15.255, ZJ
        [ 0x24861000, 0x248617FF, "JS" ],  // 36.134.16.0-36.134.23.255, JS
        [ 0x24861800, 0x24861FFF, "CQ" ],  // 36.134.24.0-36.134.31.255, CQ
        [ 0x24862000, 0x248627FF, "SH" ],  // 36.134.32.0-36.134.39.255, SH
        [ 0x24862800, 0x24862FFF, "SD" ],  // 36.134.40.0-36.134.47.255, SD
        [ 0x24863000, 0x24863FFF, "ZJ" ],  // 36.134.48.0-36.134.63.255, ZJ
        [ 0x24864000, 0x248641FF, "TJ" ],  // 36.134.64.0-36.134.65.255, TJ
        [ 0x24864200, 0x248643FF, "JL" ],  // 36.134.66.0-36.134.67.255, JL
        [ 0x24864400, 0x248645FF, "LN" ],  // 36.134.68.0-36.134.69.255, LN
        [ 0x24864600, 0x248647FF, "FJ" ],  // 36.134.70.0-36.134.71.255, FJ
        [ 0x24864800, 0x248649FF, "GS" ],  // 36.134.72.0-36.134.73.255, GS
        [ 0x24864A00, 0x24864BFF, "YN" ],  // 36.134.74.0-36.134.75.255, YN
        [ 0x24864C00, 0x24864DFF, "SX" ],  // 36.134.76.0-36.134.77.255, SX
        [ 0x24864E00, 0x24864FFF, "HB" ],  // 36.134.78.0-36.134.79.255, HB
        [ 0x24865000, 0x248651FF, "JX" ],  // 36.134.80.0-36.134.81.255, JX
        [ 0x24865200, 0x248653FF, "HE" ],  // 36.134.82.0-36.134.83.255, HE
        [ 0x24865400, 0x248655FF, "AH" ],  // 36.134.84.0-36.134.85.255, AH
        [ 0x24865600, 0x248657FF, "GX" ],  // 36.134.86.0-36.134.87.255, GX
        [ 0x24865800, 0x248659FF, "NM" ],  // 36.134.88.0-36.134.89.255, NM
        [ 0x24865A00, 0x24865BFF, "GZ" ],  // 36.134.90.0-36.134.91.255, GZ
        [ 0x24865C00, 0x24865CFF, "NM" ],  // 36.134.92.0-36.134.92.255, NM
        [ 0x24865D00, 0x24865DFF, "GZ" ],  // 36.134.93.0-36.134.93.255, GZ
        [ 0x24865E00, 0x24865EFF, "ZJ" ],  // 36.134.94.0-36.134.94.255, ZJ
        [ 0x24865F00, 0x24865FFF, "CQ" ],  // 36.134.95.0-36.134.95.255, CQ
        [ 0x24866000, 0x24866FFF, "JS" ],  // 36.134.96.0-36.134.111.255, JS
        [ 0x24867000, 0x248677FF, "SH" ],  // 36.134.112.0-36.134.119.255, SH
        [ 0x24867800, 0x24868FFF, "BJ" ],  // 36.134.120.0-36.134.143.255, BJ
        [ 0x24869000, 0x24869FFF, "JS" ],  // 36.134.144.0-36.134.159.255, JS
        [ 0x2486A000, 0x2486AFFF, "HA" ],  // 36.134.160.0-36.134.175.255, HA
        [ 0x2486B000, 0x2486BFFF, "GD" ],  // 36.134.176.0-36.134.191.255, GD
        [ 0x2486C000, 0x2486C3FF, "SC" ],  // 36.134.192.0-36.134.195.255, SC
        [ 0x2486C400, 0x2486C5FF, "FJ" ],  // 36.134.196.0-36.134.197.255, FJ
        [ 0x2486C600, 0x2486C7FF, "ZJ" ],  // 36.134.198.0-36.134.199.255, ZJ
        [ 0x2486C800, 0x2486C8FF, "LN" ],  // 36.134.200.0-36.134.200.255, LN
        [ 0x2486C900, 0x2486C9FF, "FJ" ],  // 36.134.201.0-36.134.201.255, FJ
        [ 0x2486CA00, 0x2486CAFF, "YN" ],  // 36.134.202.0-36.134.202.255, YN
        [ 0x2486CB00, 0x2486D0FF, "SD" ],  // 36.134.203.0-36.134.208.255, SD
        [ 0x2486D100, 0x2486D4FF, "SN" ],  // 36.134.209.0-36.134.212.255, SN
        [ 0x2486D500, 0x2486D8FF, "HN" ],  // 36.134.213.0-36.134.216.255, HN
        [ 0x2486D900, 0x2486D9FF, "LN" ],  // 36.134.217.0-36.134.217.255, LN
        [ 0x2486DA00, 0x2486DBFF, "HA" ],  // 36.134.218.0-36.134.219.255, HA
        [ 0x2486DC00, 0x2486DCFF, "HB" ],  // 36.134.220.0-36.134.220.255, HB
        [ 0x2486DD00, 0x2486DDFF, "BJ" ],  // 36.134.221.0-36.134.221.255, BJ
        [ 0x2486DE00, 0x2486DEFF, "LN" ],  // 36.134.222.0-36.134.222.255, LN
        [ 0x2486DF00, 0x2486DFFF, "BJ" ],  // 36.134.223.0-36.134.223.255, BJ
        [ 0x2486E000, 0x2486E6FF, "GD" ],  // 36.134.224.0-36.134.230.255, GD
        [ 0x2486E700, 0x2487FFFF, "JL" ],  // 36.134.231.0-36.135.255.255, JL
        [ 0x24880000, 0x24887FFF, "GX" ],  // 36.136.0.0-36.136.127.255, GX
        [ 0x24888000, 0x2488FFFF, "JL" ],  // 36.136.128.0-36.136.255.255, JL
        [ 0x24890000, 0x248903FF, "SN" ],  // 36.137.0.0-36.137.3.255, SN
        [ 0x24890400, 0x248905FF, "LN" ],  // 36.137.4.0-36.137.5.255, LN
        [ 0x24890600, 0x248907FF, "GD" ],  // 36.137.6.0-36.137.7.255, GD
        [ 0x24890800, 0x24890BFF, "SC" ],  // 36.137.8.0-36.137.11.255, SC
        [ 0x24890C00, 0x24890DFF, "SX" ],  // 36.137.12.0-36.137.13.255, SX
        [ 0x24890E00, 0x24890FFF, "GD" ],  // 36.137.14.0-36.137.15.255, GD
        [ 0x24891000, 0x248913FF, "SH" ],  // 36.137.16.0-36.137.19.255, SH
        [ 0x24891400, 0x248915FF, "YN" ],  // 36.137.20.0-36.137.21.255, YN
        [ 0x24891600, 0x248917FF, "FJ" ],  // 36.137.22.0-36.137.23.255, FJ
        [ 0x24891800, 0x24891DFF, "HN" ],  // 36.137.24.0-36.137.29.255, HN
        [ 0x24891E00, 0x248923FF, "SD" ],  // 36.137.30.0-36.137.35.255, SD
        [ 0x24892400, 0x248925FF, "GX" ],  // 36.137.36.0-36.137.37.255, GX
        [ 0x24892600, 0x248927FF, "AH" ],  // 36.137.38.0-36.137.39.255, AH
        [ 0x24892800, 0x24892DFF, "GZ" ],  // 36.137.40.0-36.137.45.255, GZ
        [ 0x24892E00, 0x24892FFF, "TJ" ],  // 36.137.46.0-36.137.47.255, TJ
        [ 0x24893000, 0x248931FF, "JL" ],  // 36.137.48.0-36.137.49.255, JL
        [ 0x24893200, 0x248933FF, "GS" ],  // 36.137.50.0-36.137.51.255, GS
        [ 0x24893400, 0x248939FF, "JS" ],  // 36.137.52.0-36.137.57.255, JS
        [ 0x24893A00, 0x24893BFF, "JX" ],  // 36.137.58.0-36.137.59.255, JX
        [ 0x24893C00, 0x248941FF, "HA" ],  // 36.137.60.0-36.137.65.255, HA
        [ 0x24894200, 0x248947FF, "ZJ" ],  // 36.137.66.0-36.137.71.255, ZJ
        [ 0x24894800, 0x24894BFF, "JS" ],  // 36.137.72.0-36.137.75.255, JS
        [ 0x24894C00, 0x24894DFF, "LN" ],  // 36.137.76.0-36.137.77.255, LN
        [ 0x24894E00, 0x248953FF, "NM" ],  // 36.137.78.0-36.137.83.255, NM
        [ 0x24895400, 0x248957FF, "HN" ],  // 36.137.84.0-36.137.87.255, HN
        [ 0x24895800, 0x248959FF, "HE" ],  // 36.137.88.0-36.137.89.255, HE
        [ 0x24895A00, 0x24895BFF, "NM" ],  // 36.137.90.0-36.137.91.255, NM
        [ 0x24895C00, 0x24895DFF, "YN" ],  // 36.137.92.0-36.137.93.255, YN
        [ 0x24895E00, 0x248961FF, "LN" ],  // 36.137.94.0-36.137.97.255, LN
        [ 0x24896200, 0x248963FF, "SN" ],  // 36.137.98.0-36.137.99.255, SN
        [ 0x24896400, 0x248967FF, "HA" ],  // 36.137.100.0-36.137.103.255, HA
        [ 0x24896800, 0x24896FFF, "JS" ],  // 36.137.104.0-36.137.111.255, JS
        [ 0x24897000, 0x248971FF, "SN" ],  // 36.137.112.0-36.137.113.255, SN
        [ 0x24897200, 0x248975FF, "ZJ" ],  // 36.137.114.0-36.137.117.255, ZJ
        [ 0x24897600, 0x248977FF, "FJ" ],  // 36.137.118.0-36.137.119.255, FJ
        [ 0x24897800, 0x24897BFF, "JS" ],  // 36.137.120.0-36.137.123.255, JS
        [ 0x24897C00, 0x24897DFF, "SC" ],  // 36.137.124.0-36.137.125.255, SC
        [ 0x24897E00, 0x24897FFF, "NM" ],  // 36.137.126.0-36.137.127.255, NM
        [ 0x24898000, 0x24898FFF, "SC" ],  // 36.137.128.0-36.137.143.255, SC
        [ 0x24899000, 0x248999FF, "HN" ],  // 36.137.144.0-36.137.153.255, HN
        [ 0x24899A00, 0x24899BFF, "NM" ],  // 36.137.154.0-36.137.155.255, NM
        [ 0x24899C00, 0x24899DFF, "GZ" ],  // 36.137.156.0-36.137.157.255, GZ
        [ 0x24899E00, 0x2489A3FF, "HA" ],  // 36.137.158.0-36.137.163.255, HA
        [ 0x2489A400, 0x2489A9FF, "SD" ],  // 36.137.164.0-36.137.169.255, SD
        [ 0x2489AA00, 0x2489AFFF, "SN" ],  // 36.137.170.0-36.137.175.255, SN
        [ 0x2489B000, 0x2489B7FF, "SH" ],  // 36.137.176.0-36.137.183.255, SH
        [ 0x2489B800, 0x2489BDFF, "ZJ" ],  // 36.137.184.0-36.137.189.255, ZJ
        [ 0x2489BE00, 0x2489C3FF, "JS" ],  // 36.137.190.0-36.137.195.255, JS
        [ 0x2489C400, 0x2489C7FF, "GD" ],  // 36.137.196.0-36.137.199.255, GD
        [ 0x2489C800, 0x2489CBFF, "BJ" ],  // 36.137.200.0-36.137.203.255, BJ
        [ 0x2489CC00, 0x2489CFFF, "CQ" ],  // 36.137.204.0-36.137.207.255, CQ
        [ 0x2489D000, 0x2489D3FF, "NM" ],  // 36.137.208.0-36.137.211.255, NM
        [ 0x2489D400, 0x2489D5FF, "ZJ" ],  // 36.137.212.0-36.137.213.255, ZJ
        [ 0x2489D600, 0x2489DFFF, "JS" ],  // 36.137.214.0-36.137.223.255, JS
        [ 0x2489E000, 0x2489E3FF, "GD" ],  // 36.137.224.0-36.137.227.255, GD
        [ 0x2489E400, 0x2489E7FF, "HA" ],  // 36.137.228.0-36.137.231.255, HA
        [ 0x2489E800, 0x2489EDFF, "ZJ" ],  // 36.137.232.0-36.137.237.255, ZJ
        [ 0x2489EE00, 0x2489EFFF, "NM" ],  // 36.137.238.0-36.137.239.255, NM
        [ 0x2489F000, 0x2489F3FF, "BJ" ],  // 36.137.240.0-36.137.243.255, BJ
        [ 0x2489F400, 0x2489F7FF, "SD" ],  // 36.137.244.0-36.137.247.255, SD
        [ 0x2489F800, 0x2489FBFF, "GZ" ],  // 36.137.248.0-36.137.251.255, GZ
        [ 0x2489FC00, 0x2489FFFF, "HA" ],  // 36.137.252.0-36.137.255.255, HA
        [ 0x248A0000, 0x248A07FF, "GD" ],  // 36.138.0.0-36.138.7.255, GD
        [ 0x248A0800, 0x248A0FFF, "HA" ],  // 36.138.8.0-36.138.15.255, HA
        [ 0x248A1000, 0x248A17FF, "SD" ],  // 36.138.16.0-36.138.23.255, SD
        [ 0x248A1800, 0x248A1FFF, "SN" ],  // 36.138.24.0-36.138.31.255, SN
        [ 0x248A2000, 0x248A27FF, "CQ" ],  // 36.138.32.0-36.138.39.255, CQ
        [ 0x248A2800, 0x248A3FFF, "GZ" ],  // 36.138.40.0-36.138.63.255, GZ
        [ 0x248A4000, 0x248A43FF, "BJ" ],  // 36.138.64.0-36.138.67.255, BJ
        [ 0x248A4400, 0x248A44FF, "AH" ],  // 36.138.68.0-36.138.68.255, AH
        [ 0x248A4500, 0x248A59FF, "HN" ],  // 36.138.69.0-36.138.89.255, HN
        [ 0x248A5A00, 0x248A5FFF, "SH" ],  // 36.138.90.0-36.138.95.255, SH
        [ 0x248A6000, 0x248A6FFF, "ZJ" ],  // 36.138.96.0-36.138.111.255, ZJ
        [ 0x248A7000, 0x248A75FF, "HN" ],  // 36.138.112.0-36.138.117.255, HN
        [ 0x248A7600, 0x248A77FF, "JS" ],  // 36.138.118.0-36.138.119.255, JS
        [ 0x248A7800, 0x248A7FFF, "GD" ],  // 36.138.120.0-36.138.127.255, GD
        [ 0x248A8000, 0x248A81FF, "HL" ],  // 36.138.128.0-36.138.129.255, HL
        [ 0x248A8200, 0x248A87FF, "ZJ" ],  // 36.138.130.0-36.138.135.255, ZJ
        [ 0x248A8800, 0x248A8BFF, "LN" ],  // 36.138.136.0-36.138.139.255, LN
        [ 0x248A8C00, 0x248A9BFF, "JS" ],  // 36.138.140.0-36.138.155.255, JS
        [ 0x248A9C00, 0x248AA3FF, "NM" ],  // 36.138.156.0-36.138.163.255, NM
        [ 0x248AA400, 0x248AABFF, "BJ" ],  // 36.138.164.0-36.138.171.255, BJ
        [ 0x248AAC00, 0x248AB3FF, "SH" ],  // 36.138.172.0-36.138.179.255, SH
        [ 0x248AB400, 0x248ABFFF, "BJ" ],  // 36.138.180.0-36.138.191.255, BJ
        [ 0x248AC000, 0x248AE3FF, "JS" ],  // 36.138.192.0-36.138.227.255, JS
        [ 0x248AE400, 0x248AEBFF, "SC" ],  // 36.138.228.0-36.138.235.255, SC
        [ 0x248AEC00, 0x248AFFFF, "JS" ],  // 36.138.236.0-36.138.255.255, JS
        [ 0x248B0000, 0x248B7FFF, "GD" ],  // 36.139.0.0-36.139.127.255, GD
        [ 0x248B8000, 0x248BA5FF, "BJ" ],  // 36.139.128.0-36.139.165.255, BJ
        [ 0x248BA600, 0x248BA6FF, "HB" ],  // 36.139.166.0-36.139.166.255, HB
        [ 0x248BA700, 0x248BBFFF, "ZJ" ],  // 36.139.167.0-36.139.191.255, ZJ
        [ 0x248BC000, 0x248BFFFF, "SC" ],  // 36.139.192.0-36.139.255.255, SC
        [ 0x248C0000, 0x248C1FFF, "TJ" ],  // 36.140.0.0-36.140.31.255, TJ
        [ 0x248C2000, 0x248C2DFF, "GD" ],  // 36.140.32.0-36.140.45.255, GD
        [ 0x248C2E00, 0x248C2EFF, "NM" ],  // 36.140.46.0-36.140.46.255, NM
        [ 0x248C2F00, 0x248C2FFF, "GZ" ],  // 36.140.47.0-36.140.47.255, GZ
        [ 0x248C3000, 0x248C37FF, "HB" ],  // 36.140.48.0-36.140.55.255, HB
        [ 0x248C3800, 0x248C3AFF, "JS" ],  // 36.140.56.0-36.140.58.255, JS
        [ 0x248C3B00, 0x248C3BFF, "HB" ],  // 36.140.59.0-36.140.59.255, HB
        [ 0x248C3C00, 0x248C3EFF, "SD" ],  // 36.140.60.0-36.140.62.255, SD
        [ 0x248C3F00, 0x248C3FFF, "HB" ],  // 36.140.63.0-36.140.63.255, HB
        [ 0x248C4000, 0x248C43FF, "GD" ],  // 36.140.64.0-36.140.67.255, GD
        [ 0x248C4400, 0x248C46FF, "HB" ],  // 36.140.68.0-36.140.70.255, HB
        [ 0x248C4700, 0x248C47FF, "AH" ],  // 36.140.71.0-36.140.71.255, AH
        [ 0x248C4800, 0x248C4FFF, "HB" ],  // 36.140.72.0-36.140.79.255, HB
        [ 0x248C5000, 0x248C57FF, "GD" ],  // 36.140.80.0-36.140.87.255, GD
        [ 0x248C5800, 0x248C5BFF, "HB" ],  // 36.140.88.0-36.140.91.255, HB
        [ 0x248C5C00, 0x248C5FFF, "GD" ],  // 36.140.92.0-36.140.95.255, GD
        [ 0x248C6000, 0x248C7FFF, "ZJ" ],  // 36.140.96.0-36.140.127.255, ZJ
        [ 0x248C8000, 0x248CFFFF, "BJ" ],  // 36.140.128.0-36.140.255.255, BJ
        [ 0x248D0000, 0x248DFFFF, "GD" ],  // 36.141.0.0-36.141.255.255, GD
        [ 0x248E0000, 0x248E01FF, "SC" ],  // 36.142.0.0-36.142.1.255, SC
        [ 0x248E0200, 0x248EFFFF, "GS" ],  // 36.142.2.0-36.142.255.255, GS
        [ 0x248F0000, 0x2492FFFF, "HE" ],  // 36.143.0.0-36.146.255.255, HE
        [ 0x24930000, 0x24937FFF, "YN" ],  // 36.147.0.0-36.147.127.255, YN
        [ 0x24938000, 0x2493FFFF, "BJ" ],  // 36.147.128.0-36.147.255.255, BJ
        [ 0x24940000, 0x2494FFFF, "HN" ],  // 36.148.0.0-36.148.255.255, HN
        [ 0x24950000, 0x249CFFFF, "JS" ],  // 36.149.0.0-36.156.255.255, JS
        [ 0x249D0000, 0x249EFFFF, "HN" ],  // 36.157.0.0-36.158.255.255, HN
        [ 0x249F0000, 0x249F7FFF, "GX" ],  // 36.159.0.0-36.159.127.255, GX
        [ 0x249F8000, 0x249FFFFF, "AH" ],  // 36.159.128.0-36.159.255.255, AH
        [ 0x24A00000, 0x24A0FFFF, "HL" ],  // 36.160.0.0-36.160.255.255, HL
        [ 0x24A10000, 0x24A1FFFF, "AH" ],  // 36.161.0.0-36.161.255.255, AH
        [ 0x24A20000, 0x24A2FFFF, "XZ" ],  // 36.162.0.0-36.162.255.255, XZ
        [ 0x24A30000, 0x24A37FFF, "JS" ],  // 36.163.0.0-36.163.127.255, JS
        [ 0x24A38000, 0x24A3FFFF, "SN" ],  // 36.163.128.0-36.163.255.255, SN
        [ 0x24A40000, 0x24A9FFFF, "HB" ],  // 36.164.0.0-36.169.255.255, HB
        [ 0x24AA0000, 0x24B5FFFF, "SC" ],  // 36.170.0.0-36.181.255.255, SC
        [ 0x24B60000, 0x24BDFFFF, "XJ" ],  // 36.182.0.0-36.189.255.255, XJ
        [ 0x24BE0000, 0x24C008FF, "BJ" ],  // 36.190.0.0-36.192.8.255, BJ
        [ 0x24C00900, 0x24C00BFF, "TJ" ],  // 36.192.9.0-36.192.11.255, TJ
        [ 0x24C00C00, 0x24C01BFF, "HE" ],  // 36.192.12.0-36.192.27.255, HE
        [ 0x24C01C00, 0x24C023FF, "SX" ],  // 36.192.28.0-36.192.35.255, SX
        [ 0x24C02400, 0x24C02BFF, "NM" ],  // 36.192.36.0-36.192.43.255, NM
        [ 0x24C02C00, 0x24C04BFF, "LN" ],  // 36.192.44.0-36.192.75.255, LN
        [ 0x24C04C00, 0x24C05BFF, "JL" ],  // 36.192.76.0-36.192.91.255, JL
        [ 0x24C05C00, 0x24C06BFF, "HL" ],  // 36.192.92.0-36.192.107.255, HL
        [ 0x24C06C00, 0x24C072FF, "SH" ],  // 36.192.108.0-36.192.114.255, SH
        [ 0x24C07300, 0x24C08AFF, "JS" ],  // 36.192.115.0-36.192.138.255, JS
        [ 0x24C08B00, 0x24C09CFF, "ZJ" ],  // 36.192.139.0-36.192.156.255, ZJ
        [ 0x24C09D00, 0x24C0AAFF, "AH" ],  // 36.192.157.0-36.192.170.255, AH
        [ 0x24C0AB00, 0x24C0C2FF, "FJ" ],  // 36.192.171.0-36.192.194.255, FJ
        [ 0x24C0C300, 0x24C0CBFF, "JX" ],  // 36.192.195.0-36.192.203.255, JX
        [ 0x24C0CC00, 0x24C0DEFF, "SD" ],  // 36.192.204.0-36.192.222.255, SD
        [ 0x24C0DF00, 0x24C0F2FF, "HA" ],  // 36.192.223.0-36.192.242.255, HA
        [ 0x24C0F300, 0x24C108FF, "HB" ],  // 36.192.243.0-36.193.8.255, HB
        [ 0x24C10900, 0x24C121FF, "HN" ],  // 36.193.9.0-36.193.33.255, HN
        [ 0x24C12200, 0x24C13FFF, "GD" ],  // 36.193.34.0-36.193.63.255, GD
        [ 0x24C14000, 0x24C14BFF, "GX" ],  // 36.193.64.0-36.193.75.255, GX
        [ 0x24C14C00, 0x24C14DFF, "HI" ],  // 36.193.76.0-36.193.77.255, HI
        [ 0x24C14E00, 0x24C153FF, "CQ" ],  // 36.193.78.0-36.193.83.255, CQ
        [ 0x24C15400, 0x24C161FF, "SC" ],  // 36.193.84.0-36.193.97.255, SC
        [ 0x24C16200, 0x24C166FF, "GZ" ],  // 36.193.98.0-36.193.102.255, GZ
        [ 0x24C16700, 0x24C16DFF, "YN" ],  // 36.193.103.0-36.193.109.255, YN
        [ 0x24C16E00, 0x24C179FF, "SN" ],  // 36.193.110.0-36.193.121.255, SN
        [ 0x24C17A00, 0x24C17DFF, "GS" ],  // 36.193.122.0-36.193.125.255, GS
        [ 0x24C17E00, 0x24C17FFF, "QH" ],  // 36.193.126.0-36.193.127.255, QH
        [ 0x24C18000, 0x24C181FF, "NX" ],  // 36.193.128.0-36.193.129.255, NX
        [ 0x24C18200, 0x24C188FF, "XJ" ],  // 36.193.130.0-36.193.136.255, XJ
        [ 0x24C18900, 0x24DFFFFF, "JS" ],  // 36.193.137.0-36.223.255.255, JS
        [ 0x24F80000, 0x24FBFFFF, "FJ" ],  // 36.248.0.0-36.251.255.255, FJ
        [ 0x24FE0000, 0x24FEFFFF, "BJ" ],  // 36.254.0.0-36.254.255.255, BJ
        [ 0x24FF7400, 0x24FF77FF, "ZJ" ],  // 36.255.116.0-36.255.119.255, ZJ
        [ 0x24FF8000, 0x24FF83FF, "SH" ],  // 36.255.128.0-36.255.131.255, SH
        [ 0x24FFA400, 0x24FFA7FF, "GD" ],  // 36.255.164.0-36.255.167.255, GD
        [ 0x24FFAC00, 0x24FFB3FF, "SH" ],  // 36.255.172.0-36.255.179.255, SH
        [ 0x262F3C00, 0x262F3FFF, "BJ" ],  // 38.47.60.0-38.47.63.255, BJ
        [ 0x262F8000, 0x262F9BFF, "BJ" ],  // 38.47.128.0-38.47.155.255, BJ
        [ 0x262F9E00, 0x262F9FFF, "BJ" ],  // 38.47.158.0-38.47.159.255, BJ
        [ 0x27000000, 0x270000FF, "FJ" ],  // 39.0.0.0-39.0.0.255, FJ
        [ 0x27000200, 0x270007FF, "FJ" ],  // 39.0.2.0-39.0.7.255, FJ
        [ 0x27000800, 0x2700FFFF, "GD" ],  // 39.0.8.0-39.0.255.255, GD
        [ 0x27400000, 0x2751B8FF, "SD" ],  // 39.64.0.0-39.81.184.255, SD
        [ 0x2751B900, 0x2751D7FF, "GD" ],  // 39.81.185.0-39.81.215.255, GD
        [ 0x2751D800, 0x275FFFFF, "SD" ],  // 39.81.216.0-39.95.255.255, SD
        [ 0x27600000, 0x27625FFF, "BJ" ],  // 39.96.0.0-39.98.95.255, BJ
        [ 0x27626000, 0x276260FF, "HE" ],  // 39.98.96.0-39.98.96.255, HE
        [ 0x27626100, 0x2762BFFF, "BJ" ],  // 39.98.97.0-39.98.191.255, BJ
        [ 0x2762C000, 0x2762FFFF, "HE" ],  // 39.98.192.0-39.98.255.255, HE
        [ 0x27630000, 0x27637FFF, "NM" ],  // 39.99.0.0-39.99.127.255, NM
        [ 0x27638000, 0x2763FFFF, "BJ" ],  // 39.99.128.0-39.99.255.255, BJ
        [ 0x27640000, 0x2764B4FF, "HE" ],  // 39.100.0.0-39.100.180.255, HE
        [ 0x2764B500, 0x2764B6FF, "BJ" ],  // 39.100.181.0-39.100.182.255, BJ
        [ 0x2764B700, 0x2764BFFF, "HE" ],  // 39.100.183.0-39.100.191.255, HE
        [ 0x2764C000, 0x276504FF, "BJ" ],  // 39.100.192.0-39.101.4.255, BJ
        [ 0x27650500, 0x2765057F, "NM" ],  // 39.101.5.0-39.101.5.127, NM
        [ 0x27650580, 0x27681CFF, "BJ" ],  // 39.101.5.128-39.104.28.255, BJ
        [ 0x27681D00, 0x27681DFF, "NM" ],  // 39.104.29.0-39.104.29.255, NM
        [ 0x27681E00, 0x276855FF, "BJ" ],  // 39.104.30.0-39.104.85.255, BJ
        [ 0x27685600, 0x2768FFFF, "NM" ],  // 39.104.86.0-39.104.255.255, NM
        [ 0x27690000, 0x276BFFFF, "BJ" ],  // 39.105.0.0-39.107.255.255, BJ
        [ 0x276C0000, 0x276CFFFF, "GD" ],  // 39.108.0.0-39.108.255.255, GD
        [ 0x27800000, 0x2782FFFF, "YN" ],  // 39.128.0.0-39.130.255.255, YN
        [ 0x27830000, 0x2785FFFF, "BJ" ],  // 39.131.0.0-39.133.255.255, BJ
        [ 0x27860000, 0x278607FF, "CQ" ],  // 39.134.0.0-39.134.7.255, CQ
        [ 0x27860800, 0x278610FF, "HN" ],  // 39.134.8.0-39.134.16.255, HN
        [ 0x27861100, 0x278619FF, "SN" ],  // 39.134.17.0-39.134.25.255, SN
        [ 0x27861A00, 0x27861FFF, "SX" ],  // 39.134.26.0-39.134.31.255, SX
        [ 0x27862000, 0x278629FF, "GS" ],  // 39.134.32.0-39.134.41.255, GS
        [ 0x27862A00, 0x278631FF, "GD" ],  // 39.134.42.0-39.134.49.255, GD
        [ 0x27863200, 0x27863DFF, "LN" ],  // 39.134.50.0-39.134.61.255, LN
        [ 0x27863E00, 0x278644FF, "HL" ],  // 39.134.62.0-39.134.68.255, HL
        [ 0x27864500, 0x278655FF, "JS" ],  // 39.134.69.0-39.134.85.255, JS
        [ 0x27865600, 0x27865CFF, "SH" ],  // 39.134.86.0-39.134.92.255, SH
        [ 0x27865D00, 0x27865FFF, "NX" ],  // 39.134.93.0-39.134.95.255, NX
        [ 0x27866000, 0x278667FF, "FJ" ],  // 39.134.96.0-39.134.103.255, FJ
        [ 0x27866800, 0x278671FF, "YN" ],  // 39.134.104.0-39.134.113.255, YN
        [ 0x27867200, 0x278677FF, "JX" ],  // 39.134.114.0-39.134.119.255, JX
        [ 0x27867800, 0x278687FF, "AH" ],  // 39.134.120.0-39.134.135.255, AH
        [ 0x27868800, 0x27868BFF, "HI" ],  // 39.134.136.0-39.134.139.255, HI
        [ 0x27868C00, 0x27868EFF, "TJ" ],  // 39.134.140.0-39.134.142.255, TJ
        [ 0x27868F00, 0x278699FF, "SD" ],  // 39.134.143.0-39.134.153.255, SD
        [ 0x27869A00, 0x27869FFF, "QH" ],  // 39.134.154.0-39.134.159.255, QH
        [ 0x2786A000, 0x2786A7FF, "JL" ],  // 39.134.160.0-39.134.167.255, JL
        [ 0x2786A800, 0x2786AFFF, "NM" ],  // 39.134.168.0-39.134.175.255, NM
        [ 0x2786B000, 0x2786BAFF, "ZJ" ],  // 39.134.176.0-39.134.186.255, ZJ
        [ 0x2786BB00, 0x2786C3FF, "HE" ],  // 39.134.187.0-39.134.195.255, HE
        [ 0x2786C400, 0x2786D1FF, "SC" ],  // 39.134.196.0-39.134.209.255, SC
        [ 0x2786D200, 0x2786EBFF, "HA" ],  // 39.134.210.0-39.134.235.255, HA
        [ 0x2786EC00, 0x2786EFFF, "XJ" ],  // 39.134.236.0-39.134.239.255, XJ
        [ 0x2786F000, 0x2786FFFF, "HN" ],  // 39.134.240.0-39.134.255.255, HN
        [ 0x27870000, 0x278702FF, "SH" ],  // 39.135.0.0-39.135.2.255, SH
        [ 0x27870300, 0x278703FF, "BJ" ],  // 39.135.3.0-39.135.3.255, BJ
        [ 0x27870400, 0x278705FF, "HN" ],  // 39.135.4.0-39.135.5.255, HN
        [ 0x27870600, 0x278707FF, "XZ" ],  // 39.135.6.0-39.135.7.255, XZ
        [ 0x27870800, 0x278713FF, "GZ" ],  // 39.135.8.0-39.135.19.255, GZ
        [ 0x27871400, 0x27871FFF, "HB" ],  // 39.135.20.0-39.135.31.255, HB
        [ 0x27872000, 0x27872FFF, "GX" ],  // 39.135.32.0-39.135.47.255, GX
        [ 0x27873000, 0x2787377F, "FJ" ],  // 39.135.48.0-39.135.55.127, FJ
        [ 0x27873780, 0x278738FF, "XZ" ],  // 39.135.55.128-39.135.56.255, XZ
        [ 0x27873900, 0x278739FF, "JL" ],  // 39.135.57.0-39.135.57.255, JL
        [ 0x27873A00, 0x278743FF, "GD" ],  // 39.135.58.0-39.135.67.255, GD
        [ 0x27874400, 0x278747FF, "HE" ],  // 39.135.68.0-39.135.71.255, HE
        [ 0x27874800, 0x27874BFF, "CQ" ],  // 39.135.72.0-39.135.75.255, CQ
        [ 0x27874C00, 0x27874CFF, "SN" ],  // 39.135.76.0-39.135.76.255, SN
        [ 0x27874D00, 0x27874FDF, "GS" ],  // 39.135.77.0-39.135.79.223, GS
        [ 0x27874FE0, 0x27874FFF, "SN" ],  // 39.135.79.224-39.135.79.255, SN
        [ 0x27875000, 0x278754FF, "GS" ],  // 39.135.80.0-39.135.84.255, GS
        [ 0x27875500, 0x27875AFF, "SN" ],  // 39.135.85.0-39.135.90.255, SN
        [ 0x27875B00, 0x27875DFF, "XZ" ],  // 39.135.91.0-39.135.93.255, XZ
        [ 0x27875E00, 0x278760FF, "XJ" ],  // 39.135.94.0-39.135.96.255, XJ
        [ 0x27876100, 0x278766FF, "ZJ" ],  // 39.135.97.0-39.135.102.255, ZJ
        [ 0x27876700, 0x2787673F, "SD" ],  // 39.135.103.0-39.135.103.63, SD
        [ 0x27876740, 0x27876777, "LN" ],  // 39.135.103.64-39.135.103.119, LN
        [ 0x27876778, 0x2787687F, "SD" ],  // 39.135.103.120-39.135.104.127, SD
        [ 0x27876880, 0x278768FF, "LN" ],  // 39.135.104.128-39.135.104.255, LN
        [ 0x27876900, 0x2787693F, "SD" ],  // 39.135.105.0-39.135.105.63, SD
        [ 0x27876940, 0x278769FF, "LN" ],  // 39.135.105.64-39.135.105.255, LN
        [ 0x27876A00, 0x27876A3F, "SD" ],  // 39.135.106.0-39.135.106.63, SD
        [ 0x27876A40, 0x27876AFF, "LN" ],  // 39.135.106.64-39.135.106.255, LN
        [ 0x27876B00, 0x27876B7F, "SD" ],  // 39.135.107.0-39.135.107.127, SD
        [ 0x27876B80, 0x27876BAF, "LN" ],  // 39.135.107.128-39.135.107.175, LN
        [ 0x27876BB0, 0x27876BBF, "SD" ],  // 39.135.107.176-39.135.107.191, SD
        [ 0x27876BC0, 0x27876CFF, "LN" ],  // 39.135.107.192-39.135.108.255, LN
        [ 0x27876D00, 0x27876D5F, "SD" ],  // 39.135.109.0-39.135.109.95, SD
        [ 0x27876D60, 0x27876DFF, "LN" ],  // 39.135.109.96-39.135.109.255, LN
        [ 0x27876E00, 0x27876E7F, "SD" ],  // 39.135.110.0-39.135.110.127, SD
        [ 0x27876E80, 0x27876E8F, "LN" ],  // 39.135.110.128-39.135.110.143, LN
        [ 0x27876E90, 0x27876E9F, "SD" ],  // 39.135.110.144-39.135.110.159, SD
        [ 0x27876EA0, 0x27876EDF, "LN" ],  // 39.135.110.160-39.135.110.223, LN
        [ 0x27876EE0, 0x27876EFF, "SD" ],  // 39.135.110.224-39.135.110.255, SD
        [ 0x27876F00, 0x278774FF, "LN" ],  // 39.135.111.0-39.135.116.255, LN
        [ 0x27877500, 0x27877DFF, "SH" ],  // 39.135.117.0-39.135.125.255, SH
        [ 0x27877E00, 0x2787815F, "LN" ],  // 39.135.126.0-39.135.129.95, LN
        [ 0x27878160, 0x2787817F, "HL" ],  // 39.135.129.96-39.135.129.127, HL
        [ 0x27878180, 0x278781BF, "LN" ],  // 39.135.129.128-39.135.129.191, LN
        [ 0x278781C0, 0x2787877F, "HL" ],  // 39.135.129.192-39.135.135.127, HL
        [ 0x27878780, 0x278787FF, "JX" ],  // 39.135.135.128-39.135.135.255, JX
        [ 0x27878800, 0x2787897F, "HL" ],  // 39.135.136.0-39.135.137.127, HL
        [ 0x27878980, 0x278796FF, "JX" ],  // 39.135.137.128-39.135.150.255, JX
        [ 0x27879700, 0x27879C7F, "HB" ],  // 39.135.151.0-39.135.156.127, HB
        [ 0x27879C80, 0x27879CBF, "SD" ],  // 39.135.156.128-39.135.156.191, SD
        [ 0x27879CC0, 0x27879CFF, "HB" ],  // 39.135.156.192-39.135.156.255, HB
        [ 0x27879D00, 0x2787A6FF, "SD" ],  // 39.135.157.0-39.135.166.255, SD
        [ 0x2787A700, 0x2787AA7F, "HA" ],  // 39.135.167.0-39.135.170.127, HA
        [ 0x2787AA80, 0x2787AAFF, "SD" ],  // 39.135.170.128-39.135.170.255, SD
        [ 0x2787AB00, 0x2787AB7F, "HA" ],  // 39.135.171.0-39.135.171.127, HA
        [ 0x2787AB80, 0x2787ABFF, "SD" ],  // 39.135.171.128-39.135.171.255, SD
        [ 0x2787AC00, 0x2787ADFF, "HA" ],  // 39.135.172.0-39.135.173.255, HA
        [ 0x2787AE00, 0x2787AFFF, "SD" ],  // 39.135.174.0-39.135.175.255, SD
        [ 0x2787B000, 0x2787B0FF, "HA" ],  // 39.135.176.0-39.135.176.255, HA
        [ 0x2787B100, 0x2787B2FF, "SD" ],  // 39.135.177.0-39.135.178.255, SD
        [ 0x2787B300, 0x2787B4FF, "HA" ],  // 39.135.179.0-39.135.180.255, HA
        [ 0x2787B500, 0x2787B7FF, "SD" ],  // 39.135.181.0-39.135.183.255, SD
        [ 0x2787B800, 0x2787B9FF, "HA" ],  // 39.135.184.0-39.135.185.255, HA
        [ 0x2787BA00, 0x2787BAFF, "SD" ],  // 39.135.186.0-39.135.186.255, SD
        [ 0x2787BB00, 0x2787BFFF, "SX" ],  // 39.135.187.0-39.135.191.255, SX
        [ 0x2787C000, 0x2787C4FF, "HI" ],  // 39.135.192.0-39.135.196.255, HI
        [ 0x2787C500, 0x2787C53F, "SC" ],  // 39.135.197.0-39.135.197.63, SC
        [ 0x2787C540, 0x2787C5FF, "SD" ],  // 39.135.197.64-39.135.197.255, SD
        [ 0x2787C600, 0x2787C63F, "SC" ],  // 39.135.198.0-39.135.198.63, SC
        [ 0x2787C640, 0x2787C6FF, "SD" ],  // 39.135.198.64-39.135.198.255, SD
        [ 0x2787C700, 0x2787C73F, "SC" ],  // 39.135.199.0-39.135.199.63, SC
        [ 0x2787C740, 0x2787C7FF, "SD" ],  // 39.135.199.64-39.135.199.255, SD
        [ 0x2787C800, 0x2787C83F, "SC" ],  // 39.135.200.0-39.135.200.63, SC
        [ 0x2787C840, 0x2787C8FF, "SD" ],  // 39.135.200.64-39.135.200.255, SD
        [ 0x2787C900, 0x2787C93F, "SC" ],  // 39.135.201.0-39.135.201.63, SC
        [ 0x2787C940, 0x2787C9FF, "SD" ],  // 39.135.201.64-39.135.201.255, SD
        [ 0x2787CA00, 0x2787CA3F, "SC" ],  // 39.135.202.0-39.135.202.63, SC
        [ 0x2787CA40, 0x2787CAFF, "SD" ],  // 39.135.202.64-39.135.202.255, SD
        [ 0x2787CB00, 0x2787CB3F, "SC" ],  // 39.135.203.0-39.135.203.63, SC
        [ 0x2787CB40, 0x2787CBFF, "SD" ],  // 39.135.203.64-39.135.203.255, SD
        [ 0x2787CC00, 0x2787D9FF, "SC" ],  // 39.135.204.0-39.135.217.255, SC
        [ 0x2787DA00, 0x2787DDFF, "SH" ],  // 39.135.218.0-39.135.221.255, SH
        [ 0x2787DE00, 0x2787DFFF, "FJ" ],  // 39.135.222.0-39.135.223.255, FJ
        [ 0x2787E000, 0x2787EDFF, "SD" ],  // 39.135.224.0-39.135.237.255, SD
        [ 0x2787EE00, 0x2787F2FF, "BJ" ],  // 39.135.238.0-39.135.242.255, BJ
        [ 0x2787F300, 0x2787F4FF, "AH" ],  // 39.135.243.0-39.135.244.255, AH
        [ 0x2787F500, 0x2787FAFF, "HB" ],  // 39.135.245.0-39.135.250.255, HB
        [ 0x2787FB00, 0x278807FF, "SH" ],  // 39.135.251.0-39.136.7.255, SH
        [ 0x27880800, 0x278810FF, "GZ" ],  // 39.136.8.0-39.136.16.255, GZ
        [ 0x27881100, 0x27881FFF, "SD" ],  // 39.136.17.0-39.136.31.255, SD
        [ 0x27882000, 0x278827FF, "NM" ],  // 39.136.32.0-39.136.39.255, NM
        [ 0x27882800, 0x27888EFF, "HI" ],  // 39.136.40.0-39.136.142.255, HI
        [ 0x27888F00, 0x27888FFF, "HL" ],  // 39.136.143.0-39.136.143.255, HL
        [ 0x27889000, 0x2788FFFF, "HI" ],  // 39.136.144.0-39.136.255.255, HI
        [ 0x27890000, 0x278909FF, "LN" ],  // 39.137.0.0-39.137.9.255, LN
        [ 0x27890A00, 0x278911FF, "SN" ],  // 39.137.10.0-39.137.17.255, SN
        [ 0x27891200, 0x278916FF, "SX" ],  // 39.137.18.0-39.137.22.255, SX
        [ 0x27891700, 0x27891BFF, "GS" ],  // 39.137.23.0-39.137.27.255, GS
        [ 0x27891C00, 0x278922FF, "GD" ],  // 39.137.28.0-39.137.34.255, GD
        [ 0x27892300, 0x278925FF, "SH" ],  // 39.137.35.0-39.137.37.255, SH
        [ 0x27892600, 0x278927FF, "CQ" ],  // 39.137.38.0-39.137.39.255, CQ
        [ 0x27892800, 0x278929FF, "BJ" ],  // 39.137.40.0-39.137.41.255, BJ
        [ 0x27892A00, 0x27892AFF, "NX" ],  // 39.137.42.0-39.137.42.255, NX
        [ 0x27892B00, 0x27892FFF, "FJ" ],  // 39.137.43.0-39.137.47.255, FJ
        [ 0x27893000, 0x278933FF, "JX" ],  // 39.137.48.0-39.137.51.255, JX
        [ 0x27893400, 0x278939FF, "YN" ],  // 39.137.52.0-39.137.57.255, YN
        [ 0x27893A00, 0x27893C7F, "AH" ],  // 39.137.58.0-39.137.60.127, AH
        [ 0x27893C80, 0x27893FFF, "HI" ],  // 39.137.60.128-39.137.63.255, HI
        [ 0x27894000, 0x278943FF, "BJ" ],  // 39.137.64.0-39.137.67.255, BJ
        [ 0x27894400, 0x278946FF, "TJ" ],  // 39.137.68.0-39.137.70.255, TJ
        [ 0x27894700, 0x2789473F, "BJ" ],  // 39.137.71.0-39.137.71.63, BJ
        [ 0x27894740, 0x2789477F, "SH" ],  // 39.137.71.64-39.137.71.127, SH
        [ 0x27894780, 0x278947BF, "GD" ],  // 39.137.71.128-39.137.71.191, GD
        [ 0x278947C0, 0x278947FF, "ZJ" ],  // 39.137.71.192-39.137.71.255, ZJ
        [ 0x27894800, 0x27894BFF, "QH" ],  // 39.137.72.0-39.137.75.255, QH
        [ 0x27894C00, 0x278952FF, "SD" ],  // 39.137.76.0-39.137.82.255, SD
        [ 0x27895300, 0x278957FF, "JL" ],  // 39.137.83.0-39.137.87.255, JL
        [ 0x27895800, 0x27895CFF, "NM" ],  // 39.137.88.0-39.137.92.255, NM
        [ 0x27895D00, 0x27895DFF, "XZ" ],  // 39.137.93.0-39.137.93.255, XZ
        [ 0x27895E00, 0x27895EFF, "ZJ" ],  // 39.137.94.0-39.137.94.255, ZJ
        [ 0x27895F00, 0x278963FF, "HE" ],  // 39.137.95.0-39.137.99.255, HE
        [ 0x27896400, 0x27896FFF, "SC" ],  // 39.137.100.0-39.137.111.255, SC
        [ 0x27897000, 0x278977FF, "ZJ" ],  // 39.137.112.0-39.137.119.255, ZJ
        [ 0x27897800, 0x27897BFF, "HA" ],  // 39.137.120.0-39.137.123.255, HA
        [ 0x27897C00, 0x27897EFF, "XJ" ],  // 39.137.124.0-39.137.126.255, XJ
        [ 0x27897F00, 0x278983FF, "GZ" ],  // 39.137.127.0-39.137.131.255, GZ
        [ 0x27898400, 0x2789863F, "HB" ],  // 39.137.132.0-39.137.134.63, HB
        [ 0x27898640, 0x278986FF, "GX" ],  // 39.137.134.64-39.137.134.255, GX
        [ 0x27898700, 0x2789883F, "HB" ],  // 39.137.135.0-39.137.136.63, HB
        [ 0x27898840, 0x2789885F, "GX" ],  // 39.137.136.64-39.137.136.95, GX
        [ 0x27898860, 0x2789895F, "HB" ],  // 39.137.136.96-39.137.137.95, HB
        [ 0x27898960, 0x27898DFF, "GX" ],  // 39.137.137.96-39.137.141.255, GX
        [ 0x27898E00, 0x27898FFF, "XZ" ],  // 39.137.142.0-39.137.143.255, XZ
        [ 0x27899000, 0x2789901F, "FJ" ],  // 39.137.144.0-39.137.144.31, FJ
        [ 0x27899020, 0x2789903F, "SC" ],  // 39.137.144.32-39.137.144.63, SC
        [ 0x27899040, 0x278990FF, "HA" ],  // 39.137.144.64-39.137.144.255, HA
        [ 0x27899100, 0x278991FF, "HE" ],  // 39.137.145.0-39.137.145.255, HE
        [ 0x27899200, 0x2789A3FF, "HA" ],  // 39.137.146.0-39.137.163.255, HA
        [ 0x2789A400, 0x2789A4FF, "HE" ],  // 39.137.164.0-39.137.164.255, HE
        [ 0x2789A500, 0x2789A7FF, "GS" ],  // 39.137.165.0-39.137.167.255, GS
        [ 0x2789A800, 0x2789ABFF, "XJ" ],  // 39.137.168.0-39.137.171.255, XJ
        [ 0x2789AC00, 0x2789ACFF, "BJ" ],  // 39.137.172.0-39.137.172.255, BJ
        [ 0x2789AD00, 0x2789ADFF, "HI" ],  // 39.137.173.0-39.137.173.255, HI
        [ 0x2789AE00, 0x278A03FF, "BJ" ],  // 39.137.174.0-39.138.3.255, BJ
        [ 0x278A0400, 0x278A04FF, "ZJ" ],  // 39.138.4.0-39.138.4.255, ZJ
        [ 0x278A0500, 0x278A05FF, "GD" ],  // 39.138.5.0-39.138.5.255, GD
        [ 0x278A0600, 0x278A06FF, "SC" ],  // 39.138.6.0-39.138.6.255, SC
        [ 0x278A0700, 0x278A1FFF, "BJ" ],  // 39.138.7.0-39.138.31.255, BJ
        [ 0x278A2000, 0x278A27FF, "HE" ],  // 39.138.32.0-39.138.39.255, HE
        [ 0x278A2800, 0x278A29FF, "ZJ" ],  // 39.138.40.0-39.138.41.255, ZJ
        [ 0x278A2A00, 0x278A2DFF, "GD" ],  // 39.138.42.0-39.138.45.255, GD
        [ 0x278A2E00, 0x278A2FFF, "CQ" ],  // 39.138.46.0-39.138.47.255, CQ
        [ 0x278A3000, 0x278A3FFF, "SC" ],  // 39.138.48.0-39.138.63.255, SC
        [ 0x278A4000, 0x278EFFFF, "BJ" ],  // 39.138.64.0-39.142.255.255, BJ
        [ 0x278F0000, 0x278F01FF, "JS" ],  // 39.143.0.0-39.143.1.255, JS
        [ 0x278F0200, 0x278F0AFF, "BJ" ],  // 39.143.2.0-39.143.10.255, BJ
        [ 0x278F0B00, 0x278F0CFF, "SH" ],  // 39.143.11.0-39.143.12.255, SH
        [ 0x278F0D00, 0x278F0DFF, "GD" ],  // 39.143.13.0-39.143.13.255, GD
        [ 0x278F0E00, 0x278F13FF, "HB" ],  // 39.143.14.0-39.143.19.255, HB
        [ 0x278F1400, 0x278F14FF, "JS" ],  // 39.143.20.0-39.143.20.255, JS
        [ 0x278F1500, 0x278F15FF, "BJ" ],  // 39.143.21.0-39.143.21.255, BJ
        [ 0x278F1600, 0x278FFFFF, "SH" ],  // 39.143.22.0-39.143.255.255, SH
        [ 0x27900000, 0x279000FF, "SD" ],  // 39.144.0.0-39.144.0.255, SD
        [ 0x27900100, 0x279002FF, "BJ" ],  // 39.144.1.0-39.144.2.255, BJ
        [ 0x27900300, 0x279009FF, "GD" ],  // 39.144.3.0-39.144.9.255, GD
        [ 0x27900A00, 0x27900CFF, "BJ" ],  // 39.144.10.0-39.144.12.255, BJ
        [ 0x27900D00, 0x279010FF, "GD" ],  // 39.144.13.0-39.144.16.255, GD
        [ 0x27901100, 0x279012FF, "BJ" ],  // 39.144.17.0-39.144.18.255, BJ
        [ 0x27901300, 0x279013FF, "ZJ" ],  // 39.144.19.0-39.144.19.255, ZJ
        [ 0x27901400, 0x279014FF, "CQ" ],  // 39.144.20.0-39.144.20.255, CQ
        [ 0x27901500, 0x27901DFF, "HA" ],  // 39.144.21.0-39.144.29.255, HA
        [ 0x27901E00, 0x279021FF, "XJ" ],  // 39.144.30.0-39.144.33.255, XJ
        [ 0x27902200, 0x279026FF, "AH" ],  // 39.144.34.0-39.144.38.255, AH
        [ 0x27902700, 0x279028FF, "SH" ],  // 39.144.39.0-39.144.40.255, SH
        [ 0x27902900, 0x27902AFF, "GZ" ],  // 39.144.41.0-39.144.42.255, GZ
        [ 0x27902B00, 0x279030FF, "SH" ],  // 39.144.43.0-39.144.48.255, SH
        [ 0x27903100, 0x279034FF, "HE" ],  // 39.144.49.0-39.144.52.255, HE
        [ 0x27903500, 0x27903CFF, "LN" ],  // 39.144.53.0-39.144.60.255, LN
        [ 0x27903D00, 0x279044FF, "GX" ],  // 39.144.61.0-39.144.68.255, GX
        [ 0x27904500, 0x279048FF, "HI" ],  // 39.144.69.0-39.144.72.255, HI
        [ 0x27904900, 0x27904DFF, "NX" ],  // 39.144.73.0-39.144.77.255, NX
        [ 0x27904E00, 0x279050FF, "BJ" ],  // 39.144.78.0-39.144.80.255, BJ
        [ 0x27905100, 0x279053FF, "TJ" ],  // 39.144.81.0-39.144.83.255, TJ
        [ 0x27905400, 0x27905BFF, "HE" ],  // 39.144.84.0-39.144.91.255, HE
        [ 0x27905C00, 0x27905EFF, "NM" ],  // 39.144.92.0-39.144.94.255, NM
        [ 0x27905F00, 0x279063FF, "SX" ],  // 39.144.95.0-39.144.99.255, SX
        [ 0x27906400, 0x279066FF, "JL" ],  // 39.144.100.0-39.144.102.255, JL
        [ 0x27906700, 0x27906BFF, "SH" ],  // 39.144.103.0-39.144.107.255, SH
        [ 0x27906C00, 0x279073FF, "SD" ],  // 39.144.108.0-39.144.115.255, SD
        [ 0x27907400, 0x279078FF, "BJ" ],  // 39.144.116.0-39.144.120.255, BJ
        [ 0x27907900, 0x279082FF, "ZJ" ],  // 39.144.121.0-39.144.130.255, ZJ
        [ 0x27908300, 0x279084FF, "BJ" ],  // 39.144.131.0-39.144.132.255, BJ
        [ 0x27908500, 0x279088FF, "GX" ],  // 39.144.133.0-39.144.136.255, GX
        [ 0x27908900, 0x279090FF, "SC" ],  // 39.144.137.0-39.144.144.255, SC
        [ 0x27909100, 0x279096FF, "YN" ],  // 39.144.145.0-39.144.150.255, YN
        [ 0x27909700, 0x27909EFF, "JS" ],  // 39.144.151.0-39.144.158.255, JS
        [ 0x27909F00, 0x2790A3FF, "AH" ],  // 39.144.159.0-39.144.163.255, AH
        [ 0x2790A400, 0x2790A7FF, "BJ" ],  // 39.144.164.0-39.144.167.255, BJ
        [ 0x2790A800, 0x2790AEFF, "JX" ],  // 39.144.168.0-39.144.174.255, JX
        [ 0x2790AF00, 0x2790B0FF, "BJ" ],  // 39.144.175.0-39.144.176.255, BJ
        [ 0x2790B100, 0x2790BDFF, "HA" ],  // 39.144.177.0-39.144.189.255, HA
        [ 0x2790BE00, 0x2790C3FF, "HN" ],  // 39.144.190.0-39.144.195.255, HN
        [ 0x2790C400, 0x2790D1FF, "XJ" ],  // 39.144.196.0-39.144.209.255, XJ
        [ 0x2790D200, 0x2790D5FF, "GS" ],  // 39.144.210.0-39.144.213.255, GS
        [ 0x2790D600, 0x2790D6FF, "BJ" ],  // 39.144.214.0-39.144.214.255, BJ
        [ 0x2790D700, 0x2790D8FF, "QH" ],  // 39.144.215.0-39.144.216.255, QH
        [ 0x2790D900, 0x2790D9FF, "BJ" ],  // 39.144.217.0-39.144.217.255, BJ
        [ 0x2790DA00, 0x2790DEFF, "CQ" ],  // 39.144.218.0-39.144.222.255, CQ
        [ 0x2790DF00, 0x2790E2FF, "BJ" ],  // 39.144.223.0-39.144.226.255, BJ
        [ 0x2790E300, 0x2790E8FF, "GZ" ],  // 39.144.227.0-39.144.232.255, GZ
        [ 0x2790E900, 0x2790F3FF, "AH" ],  // 39.144.233.0-39.144.243.255, AH
        [ 0x2790F400, 0x2790F5FF, "SH" ],  // 39.144.244.0-39.144.245.255, SH
        [ 0x2790F600, 0x2790F7FF, "JL" ],  // 39.144.246.0-39.144.247.255, JL
        [ 0x2790F800, 0x2790FFFF, "FJ" ],  // 39.144.248.0-39.144.255.255, FJ
        [ 0x27910000, 0x279301FF, "AH" ],  // 39.145.0.0-39.147.1.255, AH
        [ 0x27930200, 0x2793FFFF, "BJ" ],  // 39.147.2.0-39.147.255.255, BJ
        [ 0x27940000, 0x2794CEFF, "HA" ],  // 39.148.0.0-39.148.206.255, HA
        [ 0x2794CF00, 0x2794CFFF, "GD" ],  // 39.148.207.0-39.148.207.255, GD
        [ 0x2794D000, 0x2797FFFF, "HA" ],  // 39.148.208.0-39.151.255.255, HA
        [ 0x27980000, 0x27997FFF, "LN" ],  // 39.152.0.0-39.153.127.255, LN
        [ 0x27998000, 0x279B7FFF, "NM" ],  // 39.153.128.0-39.155.127.255, NM
        [ 0x279B8000, 0x279DFFFF, "BJ" ],  // 39.155.128.0-39.157.255.255, BJ
        [ 0x279E0000, 0x27A1FFFF, "JX" ],  // 39.158.0.0-39.161.255.255, JX
        [ 0x27A20000, 0x27A5FFFF, "HA" ],  // 39.162.0.0-39.165.255.255, HA
        [ 0x27A60000, 0x27A9FFFF, "JX" ],  // 39.166.0.0-39.169.255.255, JX
        [ 0x27AA0000, 0x27AFFFFF, "ZJ" ],  // 39.170.0.0-39.175.255.255, ZJ
        [ 0x27B00000, 0x27B3FFFF, "JX" ],  // 39.176.0.0-39.179.255.255, JX
        [ 0x27B40000, 0x27BFFFFF, "ZJ" ],  // 39.180.0.0-39.191.255.255, ZJ
        [ 0x28480000, 0x28485FFF, "BJ" ],  // 40.72.0.0-40.72.95.255, BJ
        [ 0x28486000, 0x28486FFF, "SH" ],  // 40.72.96.0-40.72.111.255, SH
        [ 0x28487000, 0x28487FFF, "BJ" ],  // 40.72.112.0-40.72.127.255, BJ
        [ 0x28488000, 0x2848FEFF, "SH" ],  // 40.72.128.0-40.72.254.255, SH
        [ 0x2848FF00, 0x28493FFF, "BJ" ],  // 40.72.255.0-40.73.63.255, BJ
        [ 0x28494000, 0x28497FFF, "SH" ],  // 40.73.64.0-40.73.127.255, SH
        [ 0x28498000, 0x284993FF, "BJ" ],  // 40.73.128.0-40.73.147.255, BJ
        [ 0x28499400, 0x284994FF, "SH" ],  // 40.73.148.0-40.73.148.255, SH
        [ 0x28499500, 0x284997FF, "BJ" ],  // 40.73.149.0-40.73.151.255, BJ
        [ 0x28499800, 0x28499BFF, "SH" ],  // 40.73.152.0-40.73.155.255, SH
        [ 0x28499C00, 0x28499FFF, "BJ" ],  // 40.73.156.0-40.73.159.255, BJ
        [ 0x2849A000, 0x2849AFFF, "SH" ],  // 40.73.160.0-40.73.175.255, SH
        [ 0x2849B000, 0x2849C3FF, "BJ" ],  // 40.73.176.0-40.73.195.255, BJ
        [ 0x2849C400, 0x2849C4FF, "SH" ],  // 40.73.196.0-40.73.196.255, SH
        [ 0x2849C500, 0x2849CBFF, "BJ" ],  // 40.73.197.0-40.73.203.255, BJ
        [ 0x2849CC00, 0x2849CC03, "SH" ],  // 40.73.204.0-40.73.204.3, SH
        [ 0x2849CC04, 0x2849E0FF, "BJ" ],  // 40.73.204.4-40.73.224.255, BJ
        [ 0x2849E100, 0x2849E2FF, "SH" ],  // 40.73.225.0-40.73.226.255, SH
        [ 0x2849E300, 0x2849E7FF, "BJ" ],  // 40.73.227.0-40.73.231.255, BJ
        [ 0x2849E800, 0x2849EBFF, "SH" ],  // 40.73.232.0-40.73.235.255, SH
        [ 0x2849EC00, 0x2849EFFF, "BJ" ],  // 40.73.236.0-40.73.239.255, BJ
        [ 0x2849F000, 0x2849F1FF, "SH" ],  // 40.73.240.0-40.73.241.255, SH
        [ 0x2849F200, 0x2849F3FF, "BJ" ],  // 40.73.242.0-40.73.243.255, BJ
        [ 0x2849F400, 0x2849FBFF, "SH" ],  // 40.73.244.0-40.73.251.255, SH
        [ 0x2849FC00, 0x2849FFFF, "BJ" ],  // 40.73.252.0-40.73.255.255, BJ
        [ 0x284D8870, 0x284D887F, "BJ" ],  // 40.77.136.112-40.77.136.127, BJ
        [ 0x284DECE0, 0x284DECFF, "BJ" ],  // 40.77.236.224-40.77.236.255, BJ
        [ 0x284DFE40, 0x284DFE5F, "BJ" ],  // 40.77.254.64-40.77.254.95, BJ
        [ 0x287D8000, 0x287DFFFF, "BJ" ],  // 40.125.128.0-40.125.255.255, BJ
        [ 0x287E4000, 0x287E7FFF, "SH" ],  // 40.126.64.0-40.126.127.255, SH
        [ 0x28A20000, 0x28A21FFF, "HE" ],  // 40.162.0.0-40.162.31.255, HE
        [ 0x28A22000, 0x28A23FFF, "JS" ],  // 40.162.32.0-40.162.63.255, JS
        [ 0x28A24000, 0x28A25FFF, "HE" ],  // 40.162.64.0-40.162.95.255, HE
        [ 0x28A26000, 0x28A27FFF, "JS" ],  // 40.162.96.0-40.162.127.255, JS
        [ 0x28A28000, 0x28A29FFF, "BJ" ],  // 40.162.128.0-40.162.159.255, BJ
        [ 0x28A2A000, 0x28A2BFFF, "SH" ],  // 40.162.160.0-40.162.191.255, SH
        [ 0x28A2C000, 0x28A2DFFF, "HE" ],  // 40.162.192.0-40.162.223.255, HE
        [ 0x28A2E000, 0x28A2FFFF, "SH" ],  // 40.162.224.0-40.162.255.255, SH
        [ 0x2A000000, 0x2A0003FF, "FJ" ],  // 42.0.0.0-42.0.3.255, FJ
        [ 0x2A000800, 0x2A0017FF, "GD" ],  // 42.0.8.0-42.0.23.255, GD
        [ 0x2A001800, 0x2A001BFF, "FJ" ],  // 42.0.24.0-42.0.27.255, FJ
        [ 0x2A002000, 0x2A003FFF, "GD" ],  // 42.0.32.0-42.0.63.255, GD
        [ 0x2A008000, 0x2A00FFFF, "ZJ" ],  // 42.0.128.0-42.0.255.255, ZJ
        [ 0x2A010000, 0x2A0137FF, "GD" ],  // 42.1.0.0-42.1.55.255, GD
        [ 0x2A013800, 0x2A013BFF, "FJ" ],  // 42.1.56.0-42.1.59.255, FJ
        [ 0x2A018000, 0x2A01FFFF, "HA" ],  // 42.1.128.0-42.1.255.255, HA
        [ 0x2A040000, 0x2A07FFFF, "LN" ],  // 42.4.0.0-42.7.255.255, LN
        [ 0x2A300000, 0x2A31FFFF, "HN" ],  // 42.48.0.0-42.49.255.255, HN
        [ 0x2A320000, 0x2A32FFFF, "CQ" ],  // 42.50.0.0-42.50.255.255, CQ
        [ 0x2A330000, 0x2A33FFFF, "HA" ],  // 42.51.0.0-42.51.255.255, HA
        [ 0x2A340000, 0x2A3BFFFF, "LN" ],  // 42.52.0.0-42.59.255.255, LN
        [ 0x2A3E0000, 0x2A3E7FFF, "BJ" ],  // 42.62.0.0-42.62.127.255, BJ
        [ 0x2A3E8000, 0x2A3EAFFF, "GD" ],  // 42.62.128.0-42.62.175.255, GD
        [ 0x2A3EB400, 0x2A3EB7FF, "FJ" ],  // 42.62.180.0-42.62.183.255, FJ
        [ 0x2A3EB800, 0x2A3EBFFF, "GD" ],  // 42.62.184.0-42.62.191.255, GD
        [ 0x2A3F0000, 0x2A3FFFFF, "NX" ],  // 42.63.0.0-42.63.255.255, NX
        [ 0x2A500000, 0x2A51FFFF, "TJ" ],  // 42.80.0.0-42.81.255.255, TJ
        [ 0x2A534000, 0x2A534BFF, "GD" ],  // 42.83.64.0-42.83.75.255, GD
        [ 0x2A534C00, 0x2A534CFF, "BJ" ],  // 42.83.76.0-42.83.76.255, BJ
        [ 0x2A534D00, 0x2A534DFF, "GD" ],  // 42.83.77.0-42.83.77.255, GD
        [ 0x2A534E00, 0x2A534EFF, "BJ" ],  // 42.83.78.0-42.83.78.255, BJ
        [ 0x2A534F00, 0x2A534FFF, "GD" ],  // 42.83.79.0-42.83.79.255, GD
        [ 0x2A535000, 0x2A5353FF, "FJ" ],  // 42.83.80.0-42.83.83.255, FJ
        [ 0x2A535800, 0x2A537FFF, "GD" ],  // 42.83.88.0-42.83.127.255, GD
        [ 0x2A538000, 0x2A53C7FF, "BJ" ],  // 42.83.128.0-42.83.199.255, BJ
        [ 0x2A53C800, 0x2A53C8FF, "SH" ],  // 42.83.200.0-42.83.200.255, SH
        [ 0x2A53C900, 0x2A53FFFF, "BJ" ],  // 42.83.201.0-42.83.255.255, BJ
        [ 0x2A540000, 0x2A57FFFF, "LN" ],  // 42.84.0.0-42.87.255.255, LN
        [ 0x2A580000, 0x2A5FFFFF, "GS" ],  // 42.88.0.0-42.95.255.255, GS
        [ 0x2A604000, 0x2A6067FF, "GD" ],  // 42.96.64.0-42.96.103.255, GD
        [ 0x2A606C00, 0x2A606FFF, "FJ" ],  // 42.96.108.0-42.96.111.255, FJ
        [ 0x2A607000, 0x2A607FFF, "GD" ],  // 42.96.112.0-42.96.127.255, GD
        [ 0x2A608000, 0x2A60FFFF, "SD" ],  // 42.96.128.0-42.96.255.255, SD
        [ 0x2A610000, 0x2A61FFFF, "JL" ],  // 42.97.0.0-42.97.255.255, JL
        [ 0x2A630000, 0x2A630FFF, "BJ" ],  // 42.99.0.0-42.99.15.255, BJ
        [ 0x2A631000, 0x2A6315FF, "SH" ],  // 42.99.16.0-42.99.21.255, SH
        [ 0x2A631600, 0x2A633FFF, "BJ" ],  // 42.99.22.0-42.99.63.255, BJ
        [ 0x2A634000, 0x2A636FFF, "GD" ],  // 42.99.64.0-42.99.111.255, GD
        [ 0x2A637000, 0x2A6373FF, "FJ" ],  // 42.99.112.0-42.99.115.255, FJ
        [ 0x2A637800, 0x2A637FFF, "GD" ],  // 42.99.120.0-42.99.127.255, GD
        [ 0x2A640000, 0x2A67FFFF, "HL" ],  // 42.100.0.0-42.103.255.255, HL
        [ 0x2A780000, 0x2A7857FF, "ZJ" ],  // 42.120.0.0-42.120.87.255, ZJ
        [ 0x2A785800, 0x2A7858FF, "SD" ],  // 42.120.88.0-42.120.88.255, SD
        [ 0x2A785900, 0x2A78A2FF, "ZJ" ],  // 42.120.89.0-42.120.162.255, ZJ
        [ 0x2A78A300, 0x2A78A3FF, "SD" ],  // 42.120.163.0-42.120.163.255, SD
        [ 0x2A78A400, 0x2A78DBFF, "ZJ" ],  // 42.120.164.0-42.120.219.255, ZJ
        [ 0x2A78DC00, 0x2A78DDFF, "SD" ],  // 42.120.220.0-42.120.221.255, SD
        [ 0x2A78DE00, 0x2A78E7FF, "ZJ" ],  // 42.120.222.0-42.120.231.255, ZJ
        [ 0x2A78E800, 0x2A78E9FF, "SD" ],  // 42.120.232.0-42.120.233.255, SD
        [ 0x2A78EA00, 0x2A78EFFF, "ZJ" ],  // 42.120.234.0-42.120.239.255, ZJ
        [ 0x2A78F000, 0x2A78F01F, "GD" ],  // 42.120.240.0-42.120.240.31, GD
        [ 0x2A78F020, 0x2A78F0C7, "ZJ" ],  // 42.120.240.32-42.120.240.199, ZJ
        [ 0x2A78F0C8, 0x2A78F20F, "SH" ],  // 42.120.240.200-42.120.242.15, SH
        [ 0x2A78F210, 0x2A78F273, "ZJ" ],  // 42.120.242.16-42.120.242.115, ZJ
        [ 0x2A78F274, 0x2A78F275, "GD" ],  // 42.120.242.116-42.120.242.117, GD
        [ 0x2A78F276, 0x2A78F2A3, "ZJ" ],  // 42.120.242.118-42.120.242.163, ZJ
        [ 0x2A78F2A4, 0x2A78F33F, "GD" ],  // 42.120.242.164-42.120.243.63, GD
        [ 0x2A78F340, 0x2A78F43F, "ZJ" ],  // 42.120.243.64-42.120.244.63, ZJ
        [ 0x2A78F440, 0x2A78F463, "SD" ],  // 42.120.244.64-42.120.244.99, SD
        [ 0x2A78F464, 0x2A78F473, "ZJ" ],  // 42.120.244.100-42.120.244.115, ZJ
        [ 0x2A78F474, 0x2A78F49B, "SD" ],  // 42.120.244.116-42.120.244.155, SD
        [ 0x2A78F49C, 0x2A78F4F9, "ZJ" ],  // 42.120.244.156-42.120.244.249, ZJ
        [ 0x2A78F4FA, 0x2A78F5BF, "SD" ],  // 42.120.244.250-42.120.245.191, SD
        [ 0x2A78F5C0, 0x2A78F5F7, "ZJ" ],  // 42.120.245.192-42.120.245.247, ZJ
        [ 0x2A78F5F8, 0x2A78F5FF, "SH" ],  // 42.120.245.248-42.120.245.255, SH
        [ 0x2A78F600, 0x2A78F6BD, "ZJ" ],  // 42.120.246.0-42.120.246.189, ZJ
        [ 0x2A78F6BE, 0x2A78F6BF, "SD" ],  // 42.120.246.190-42.120.246.191, SD
        [ 0x2A78F6C0, 0x2A78F6C1, "ZJ" ],  // 42.120.246.192-42.120.246.193, ZJ
        [ 0x2A78F6C2, 0x2A78F6C3, "SD" ],  // 42.120.246.194-42.120.246.195, SD
        [ 0x2A78F6C4, 0x2A78F6C5, "ZJ" ],  // 42.120.246.196-42.120.246.197, ZJ
        [ 0x2A78F6C6, 0x2A78F6C7, "SD" ],  // 42.120.246.198-42.120.246.199, SD
        [ 0x2A78F6C8, 0x2A78F6C9, "ZJ" ],  // 42.120.246.200-42.120.246.201, ZJ
        [ 0x2A78F6CA, 0x2A78F6D9, "SD" ],  // 42.120.246.202-42.120.246.217, SD
        [ 0x2A78F6DA, 0x2A78F7FF, "GD" ],  // 42.120.246.218-42.120.247.255, GD
        [ 0x2A78F800, 0x2A78F8FF, "SD" ],  // 42.120.248.0-42.120.248.255, SD
        [ 0x2A78F900, 0x2A78F9FF, "ZJ" ],  // 42.120.249.0-42.120.249.255, ZJ
        [ 0x2A78FA00, 0x2A78FAFF, "SD" ],  // 42.120.250.0-42.120.250.255, SD
        [ 0x2A78FB00, 0x2A78FCFF, "ZJ" ],  // 42.120.251.0-42.120.252.255, ZJ
        [ 0x2A78FD00, 0x2A78FD0F, "GD" ],  // 42.120.253.0-42.120.253.15, GD
        [ 0x2A78FD10, 0x2A78FD17, "SD" ],  // 42.120.253.16-42.120.253.23, SD
        [ 0x2A78FD18, 0x2A79FFFF, "ZJ" ],  // 42.120.253.24-42.121.255.255, ZJ
        [ 0x2A7A0000, 0x2A7AFFFF, "TJ" ],  // 42.122.0.0-42.122.255.255, TJ
        [ 0x2A7B0000, 0x2A7B1FFF, "GD" ],  // 42.123.0.0-42.123.31.255, GD
        [ 0x2A7B2400, 0x2A7B27FF, "FJ" ],  // 42.123.36.0-42.123.39.255, FJ
        [ 0x2A7B2800, 0x2A7B3FFF, "GD" ],  // 42.123.40.0-42.123.63.255, GD
        [ 0x2A7B4000, 0x2A7B5FFF, "NM" ],  // 42.123.64.0-42.123.95.255, NM
        [ 0x2A7B6000, 0x2A7B7FFF, "GZ" ],  // 42.123.96.0-42.123.127.255, GZ
        [ 0x2A7B8000, 0x2A7BFFFF, "CQ" ],  // 42.123.128.0-42.123.255.255, CQ
        [ 0x2A800000, 0x2A8FFFFF, "BJ" ],  // 42.128.0.0-42.143.255.255, BJ
        [ 0x2A9C0000, 0x2A9C1FFF, "GD" ],  // 42.156.0.0-42.156.31.255, GD
        [ 0x2A9C2400, 0x2A9C27FF, "FJ" ],  // 42.156.36.0-42.156.39.255, FJ
        [ 0x2A9C2800, 0x2A9C7FFF, "GD" ],  // 42.156.40.0-42.156.127.255, GD
        [ 0x2A9C8000, 0x2A9CCEFF, "ZJ" ],  // 42.156.128.0-42.156.206.255, ZJ
        [ 0x2A9CCF00, 0x2A9CCFFF, "SD" ],  // 42.156.207.0-42.156.207.255, SD
        [ 0x2A9CD000, 0x2A9CDFFF, "ZJ" ],  // 42.156.208.0-42.156.223.255, ZJ
        [ 0x2A9CE000, 0x2A9CE1FF, "SD" ],  // 42.156.224.0-42.156.225.255, SD
        [ 0x2A9CE200, 0x2A9CE3FF, "ZJ" ],  // 42.156.226.0-42.156.227.255, ZJ
        [ 0x2A9CE400, 0x2A9CE4FF, "SD" ],  // 42.156.228.0-42.156.228.255, SD
        [ 0x2A9CE500, 0x2A9CFFFF, "ZJ" ],  // 42.156.229.0-42.156.255.255, ZJ
        [ 0x2A9D0000, 0x2A9D0BFF, "AH" ],  // 42.157.0.0-42.157.11.255, AH
        [ 0x2A9D0C00, 0x2A9D0DFF, "FJ" ],  // 42.157.12.0-42.157.13.255, FJ
        [ 0x2A9D0E00, 0x2A9D7FFF, "AH" ],  // 42.157.14.0-42.157.127.255, AH
        [ 0x2A9D8000, 0x2A9D8FFF, "GD" ],  // 42.157.128.0-42.157.143.255, GD
        [ 0x2A9D9000, 0x2A9D9FFF, "AH" ],  // 42.157.144.0-42.157.159.255, AH
        [ 0x2A9DA000, 0x2A9DBFFF, "JS" ],  // 42.157.160.0-42.157.191.255, JS
        [ 0x2A9DC000, 0x2A9DC7FF, "GD" ],  // 42.157.192.0-42.157.199.255, GD
        [ 0x2A9DC800, 0x2A9DFFFF, "AH" ],  // 42.157.200.0-42.157.255.255, AH
        [ 0x2A9E0000, 0x2A9F7FFF, "BJ" ],  // 42.158.0.0-42.159.127.255, BJ
        [ 0x2A9F8000, 0x2A9FFFFF, "SH" ],  // 42.159.128.0-42.159.255.255, SH
        [ 0x2AA00000, 0x2AAFFFFF, "BJ" ],  // 42.160.0.0-42.175.255.255, BJ
        [ 0x2AB00000, 0x2AB7FFFF, "LN" ],  // 42.176.0.0-42.183.255.255, LN
        [ 0x2AB80000, 0x2AB9FFFF, "HL" ],  // 42.184.0.0-42.185.255.255, HL
        [ 0x2ABA0000, 0x2ABAFFFF, "ZJ" ],  // 42.186.0.0-42.186.255.255, ZJ
        [ 0x2ABB0000, 0x2ABB77FF, "GD" ],  // 42.187.0.0-42.187.119.255, GD
        [ 0x2ABB7800, 0x2ABB7BFF, "NM" ],  // 42.187.120.0-42.187.123.255, NM
        [ 0x2ABB8000, 0x2ABB81FF, "TJ" ],  // 42.187.128.0-42.187.129.255, TJ
        [ 0x2ABB8200, 0x2ABB83FF, "JS" ],  // 42.187.130.0-42.187.131.255, JS
        [ 0x2ABB8400, 0x2ABBFFFF, "TJ" ],  // 42.187.132.0-42.187.255.255, TJ
        [ 0x2AC00000, 0x2AC0FFFF, "SH" ],  // 42.192.0.0-42.192.255.255, SH
        [ 0x2AC10000, 0x2AC13FFF, "SC" ],  // 42.193.0.0-42.193.63.255, SC
        [ 0x2AC14000, 0x2AC15FFF, "SH" ],  // 42.193.64.0-42.193.95.255, SH
        [ 0x2AC16000, 0x2AC17FFF, "BJ" ],  // 42.193.96.0-42.193.127.255, BJ
        [ 0x2AC18000, 0x2AC207FF, "GD" ],  // 42.193.128.0-42.194.7.255, GD
        [ 0x2AC20800, 0x2AC20BFF, "SD" ],  // 42.194.8.0-42.194.11.255, SD
        [ 0x2AC20C00, 0x2AC20FFF, "BJ" ],  // 42.194.12.0-42.194.15.255, BJ
        [ 0x2AC21000, 0x2AC2FFFF, "GD" ],  // 42.194.16.0-42.194.255.255, GD
        [ 0x2AC30000, 0x2AC3FFFF, "JS" ],  // 42.195.0.0-42.195.255.255, JS
        [ 0x2AC40000, 0x2AC4FDFF, "SH" ],  // 42.196.0.0-42.196.253.255, SH
        [ 0x2AC4FE00, 0x2AC4FEFF, "ZJ" ],  // 42.196.254.0-42.196.254.255, ZJ
        [ 0x2AC4FF00, 0x2AC4FFFF, "SH" ],  // 42.196.255.0-42.196.255.255, SH
        [ 0x2AC50000, 0x2AC5FFFF, "GD" ],  // 42.197.0.0-42.197.255.255, GD
        [ 0x2AC60000, 0x2AC6FFFF, "BJ" ],  // 42.198.0.0-42.198.255.255, BJ
        [ 0x2AC70000, 0x2AC73FFF, "GD" ],  // 42.199.0.0-42.199.63.255, GD
        [ 0x2AC74000, 0x2AC77FFF, "LN" ],  // 42.199.64.0-42.199.127.255, LN
        [ 0x2AC78000, 0x2AC7FFFF, "SD" ],  // 42.199.128.0-42.199.255.255, SD
        [ 0x2AC90000, 0x2AC93FFF, "BJ" ],  // 42.201.0.0-42.201.63.255, BJ
        [ 0x2AC94000, 0x2AC97FFF, "HB" ],  // 42.201.64.0-42.201.127.255, HB
        [ 0x2ACA0000, 0x2ACBFFFF, "LN" ],  // 42.202.0.0-42.203.255.255, LN
        [ 0x2ACC0000, 0x2ADFFFFF, "BJ" ],  // 42.204.0.0-42.223.255.255, BJ
        [ 0x2AE00000, 0x2AEFFFFF, "HA" ],  // 42.224.0.0-42.239.255.255, HA
        [ 0x2AF00000, 0x2AF07FFF, "BJ" ],  // 42.240.0.0-42.240.127.255, BJ
        [ 0x2AF08000, 0x2AF0FFFF, "GD" ],  // 42.240.128.0-42.240.255.255, GD
        [ 0x2AF20000, 0x2AF3FFFF, "YN" ],  // 42.242.0.0-42.243.255.255, YN
        [ 0x2AF40000, 0x2AF5BFFF, "JS" ],  // 42.244.0.0-42.245.191.255, JS
        [ 0x2AF5C000, 0x2AF5C1FF, "BJ" ],  // 42.245.192.0-42.245.193.255, BJ
        [ 0x2AF5C200, 0x2AF5C2FF, "ZJ" ],  // 42.245.194.0-42.245.194.255, ZJ
        [ 0x2AF5C300, 0x2AF5C3FF, "JS" ],  // 42.245.195.0-42.245.195.255, JS
        [ 0x2AF5C400, 0x2AF5CFFF, "BJ" ],  // 42.245.196.0-42.245.207.255, BJ
        [ 0x2AF5D000, 0x2AF5D7FF, "HB" ],  // 42.245.208.0-42.245.215.255, HB
        [ 0x2AF5D800, 0x2AF5E6FF, "JS" ],  // 42.245.216.0-42.245.230.255, JS
        [ 0x2AF5E700, 0x2AF5E7FF, "SD" ],  // 42.245.231.0-42.245.231.255, SD
        [ 0x2AF5E800, 0x2AF5EBFF, "GD" ],  // 42.245.232.0-42.245.235.255, GD
        [ 0x2AF5EC00, 0x2AF5F7FF, "JS" ],  // 42.245.236.0-42.245.247.255, JS
        [ 0x2AF5F800, 0x2AF5FDFF, "SH" ],  // 42.245.248.0-42.245.253.255, SH
        [ 0x2AF5FE00, 0x2AF5FFFF, "HB" ],  // 42.245.254.0-42.245.255.255, HB
        [ 0x2AF60000, 0x2AF6FFFF, "JS" ],  // 42.246.0.0-42.246.255.255, JS
        [ 0x2AF70000, 0x2AF7003F, "SX" ],  // 42.247.0.0-42.247.0.63, SX
        [ 0x2AF70040, 0x2AF7005F, "GD" ],  // 42.247.0.64-42.247.0.95, GD
        [ 0x2AF70060, 0x2AF7007F, "JS" ],  // 42.247.0.96-42.247.0.127, JS
        [ 0x2AF70080, 0x2AF700FF, "HB" ],  // 42.247.0.128-42.247.0.255, HB
        [ 0x2AF70100, 0x2AF7015F, "SH" ],  // 42.247.1.0-42.247.1.95, SH
        [ 0x2AF70160, 0x2AF7017F, "BJ" ],  // 42.247.1.96-42.247.1.127, BJ
        [ 0x2AF70180, 0x2AF701BF, "GD" ],  // 42.247.1.128-42.247.1.191, GD
        [ 0x2AF701C0, 0x2AF701C7, "CQ" ],  // 42.247.1.192-42.247.1.199, CQ
        [ 0x2AF701C8, 0x2AF701CF, "JS" ],  // 42.247.1.200-42.247.1.207, JS
        [ 0x2AF701D0, 0x2AF701D7, "SC" ],  // 42.247.1.208-42.247.1.215, SC
        [ 0x2AF701D8, 0x2AF701DF, "SH" ],  // 42.247.1.216-42.247.1.223, SH
        [ 0x2AF701E0, 0x2AF7021F, "HA" ],  // 42.247.1.224-42.247.2.31, HA
        [ 0x2AF70220, 0x2AF7023F, "SD" ],  // 42.247.2.32-42.247.2.63, SD
        [ 0x2AF70240, 0x2AF7027F, "CQ" ],  // 42.247.2.64-42.247.2.127, CQ
        [ 0x2AF70280, 0x2AF70287, "SC" ],  // 42.247.2.128-42.247.2.135, SC
        [ 0x2AF70288, 0x2AF7028F, "HL" ],  // 42.247.2.136-42.247.2.143, HL
        [ 0x2AF70290, 0x2AF70297, "SD" ],  // 42.247.2.144-42.247.2.151, SD
        [ 0x2AF70298, 0x2AF7029F, "FJ" ],  // 42.247.2.152-42.247.2.159, FJ
        [ 0x2AF702A0, 0x2AF702A7, "SC" ],  // 42.247.2.160-42.247.2.167, SC
        [ 0x2AF702A8, 0x2AF702AF, "GD" ],  // 42.247.2.168-42.247.2.175, GD
        [ 0x2AF702B0, 0x2AF702B7, "SH" ],  // 42.247.2.176-42.247.2.183, SH
        [ 0x2AF702B8, 0x2AF702BF, "XJ" ],  // 42.247.2.184-42.247.2.191, XJ
        [ 0x2AF702C0, 0x2AF702C7, "AH" ],  // 42.247.2.192-42.247.2.199, AH
        [ 0x2AF702C8, 0x2AF702CF, "GZ" ],  // 42.247.2.200-42.247.2.207, GZ
        [ 0x2AF702D0, 0x2AF702D7, "HE" ],  // 42.247.2.208-42.247.2.215, HE
        [ 0x2AF702D8, 0x2AF702DF, "ZJ" ],  // 42.247.2.216-42.247.2.223, ZJ
        [ 0x2AF702E0, 0x2AF702E7, "HE" ],  // 42.247.2.224-42.247.2.231, HE
        [ 0x2AF702E8, 0x2AF702EF, "SC" ],  // 42.247.2.232-42.247.2.239, SC
        [ 0x2AF702F0, 0x2AF7031F, "CQ" ],  // 42.247.2.240-42.247.3.31, CQ
        [ 0x2AF70320, 0x2AF70327, "GD" ],  // 42.247.3.32-42.247.3.39, GD
        [ 0x2AF70328, 0x2AF7032F, "LN" ],  // 42.247.3.40-42.247.3.47, LN
        [ 0x2AF70330, 0x2AF70337, "SD" ],  // 42.247.3.48-42.247.3.55, SD
        [ 0x2AF70338, 0x2AF7033F, "ZJ" ],  // 42.247.3.56-42.247.3.63, ZJ
        [ 0x2AF70340, 0x2AF7035F, "BJ" ],  // 42.247.3.64-42.247.3.95, BJ
        [ 0x2AF70360, 0x2AF70367, "JS" ],  // 42.247.3.96-42.247.3.103, JS
        [ 0x2AF70368, 0x2AF70377, "AH" ],  // 42.247.3.104-42.247.3.119, AH
        [ 0x2AF70378, 0x2AF7037F, "CQ" ],  // 42.247.3.120-42.247.3.127, CQ
        [ 0x2AF70380, 0x2AF703FF, "SC" ],  // 42.247.3.128-42.247.3.255, SC
        [ 0x2AF70400, 0x2AF7047F, "BJ" ],  // 42.247.4.0-42.247.4.127, BJ
        [ 0x2AF70480, 0x2AF7057F, "SN" ],  // 42.247.4.128-42.247.5.127, SN
        [ 0x2AF70580, 0x2AF70587, "GS" ],  // 42.247.5.128-42.247.5.135, GS
        [ 0x2AF70588, 0x2AF7059F, "SN" ],  // 42.247.5.136-42.247.5.159, SN
        [ 0x2AF705A0, 0x2AF705A7, "ZJ" ],  // 42.247.5.160-42.247.5.167, ZJ
        [ 0x2AF705A8, 0x2AF705AF, "CQ" ],  // 42.247.5.168-42.247.5.175, CQ
        [ 0x2AF705B0, 0x2AF705B7, "NM" ],  // 42.247.5.176-42.247.5.183, NM
        [ 0x2AF705B8, 0x2AF705BF, "AH" ],  // 42.247.5.184-42.247.5.191, AH
        [ 0x2AF705C0, 0x2AF705CF, "JS" ],  // 42.247.5.192-42.247.5.207, JS
        [ 0x2AF705D0, 0x2AF705D7, "ZJ" ],  // 42.247.5.208-42.247.5.215, ZJ
        [ 0x2AF705D8, 0x2AF705DF, "GX" ],  // 42.247.5.216-42.247.5.223, GX
        [ 0x2AF705E0, 0x2AF705E7, "HB" ],  // 42.247.5.224-42.247.5.231, HB
        [ 0x2AF705E8, 0x2AF705EF, "BJ" ],  // 42.247.5.232-42.247.5.239, BJ
        [ 0x2AF705F0, 0x2AF705FF, "SH" ],  // 42.247.5.240-42.247.5.255, SH
        [ 0x2AF70600, 0x2AF7067F, "BJ" ],  // 42.247.6.0-42.247.6.127, BJ
        [ 0x2AF70680, 0x2AF70687, "JS" ],  // 42.247.6.128-42.247.6.135, JS
        [ 0x2AF70688, 0x2AF7068F, "SN" ],  // 42.247.6.136-42.247.6.143, SN
        [ 0x2AF70690, 0x2AF70697, "GD" ],  // 42.247.6.144-42.247.6.151, GD
        [ 0x2AF70698, 0x2AF706BF, "BJ" ],  // 42.247.6.152-42.247.6.191, BJ
        [ 0x2AF706C0, 0x2AF706C7, "XJ" ],  // 42.247.6.192-42.247.6.199, XJ
        [ 0x2AF706C8, 0x2AF706CF, "JS" ],  // 42.247.6.200-42.247.6.207, JS
        [ 0x2AF706D0, 0x2AF706D7, "GD" ],  // 42.247.6.208-42.247.6.215, GD
        [ 0x2AF706D8, 0x2AF706DF, "GS" ],  // 42.247.6.216-42.247.6.223, GS
        [ 0x2AF706E0, 0x2AF706FF, "SH" ],  // 42.247.6.224-42.247.6.255, SH
        [ 0x2AF70700, 0x2AF7077F, "CQ" ],  // 42.247.7.0-42.247.7.127, CQ
        [ 0x2AF70780, 0x2AF70787, "HB" ],  // 42.247.7.128-42.247.7.135, HB
        [ 0x2AF70788, 0x2AF7078F, "SX" ],  // 42.247.7.136-42.247.7.143, SX
        [ 0x2AF70790, 0x2AF7079F, "ZJ" ],  // 42.247.7.144-42.247.7.159, ZJ
        [ 0x2AF707A0, 0x2AF707A7, "HL" ],  // 42.247.7.160-42.247.7.167, HL
        [ 0x2AF707A8, 0x2AF707AF, "JS" ],  // 42.247.7.168-42.247.7.175, JS
        [ 0x2AF707B0, 0x2AF707BF, "GD" ],  // 42.247.7.176-42.247.7.191, GD
        [ 0x2AF707C0, 0x2AF707C7, "GS" ],  // 42.247.7.192-42.247.7.199, GS
        [ 0x2AF707C8, 0x2AF707D7, "CQ" ],  // 42.247.7.200-42.247.7.215, CQ
        [ 0x2AF707D8, 0x2AF707DF, "FJ" ],  // 42.247.7.216-42.247.7.223, FJ
        [ 0x2AF707E0, 0x2AF707EF, "SC" ],  // 42.247.7.224-42.247.7.239, SC
        [ 0x2AF707F0, 0x2AF707F7, "GZ" ],  // 42.247.7.240-42.247.7.247, GZ
        [ 0x2AF707F8, 0x2AF707FF, "FJ" ],  // 42.247.7.248-42.247.7.255, FJ
        [ 0x2AF70800, 0x2AF708FF, "BJ" ],  // 42.247.8.0-42.247.8.255, BJ
        [ 0x2AF70900, 0x2AF70907, "HB" ],  // 42.247.9.0-42.247.9.7, HB
        [ 0x2AF70908, 0x2AF7090F, "SD" ],  // 42.247.9.8-42.247.9.15, SD
        [ 0x2AF70910, 0x2AF70917, "AH" ],  // 42.247.9.16-42.247.9.23, AH
        [ 0x2AF70918, 0x2AF7093F, "SN" ],  // 42.247.9.24-42.247.9.63, SN
        [ 0x2AF70940, 0x2AF70947, "HL" ],  // 42.247.9.64-42.247.9.71, HL
        [ 0x2AF70948, 0x2AF70958, "CQ" ],  // 42.247.9.72-42.247.9.88, CQ
        [ 0x2AF70959, 0x2AF7095F, "HL" ],  // 42.247.9.89-42.247.9.95, HL
        [ 0x2AF70960, 0x2AF7096F, "JL" ],  // 42.247.9.96-42.247.9.111, JL
        [ 0x2AF70970, 0x2AF7097F, "GZ" ],  // 42.247.9.112-42.247.9.127, GZ
        [ 0x2AF70980, 0x2AF70987, "SC" ],  // 42.247.9.128-42.247.9.135, SC
        [ 0x2AF70988, 0x2AF7098F, "JL" ],  // 42.247.9.136-42.247.9.143, JL
        [ 0x2AF70990, 0x2AF70997, "YN" ],  // 42.247.9.144-42.247.9.151, YN
        [ 0x2AF70998, 0x2AF7099F, "ZJ" ],  // 42.247.9.152-42.247.9.159, ZJ
        [ 0x2AF709A0, 0x2AF709BF, "HL" ],  // 42.247.9.160-42.247.9.191, HL
        [ 0x2AF709C0, 0x2AF709CF, "CQ" ],  // 42.247.9.192-42.247.9.207, CQ
        [ 0x2AF709D0, 0x2AF709D7, "JS" ],  // 42.247.9.208-42.247.9.215, JS
        [ 0x2AF709D8, 0x2AF709DF, "SC" ],  // 42.247.9.216-42.247.9.223, SC
        [ 0x2AF709E0, 0x2AF709FF, "HL" ],  // 42.247.9.224-42.247.9.255, HL
        [ 0x2AF70A00, 0x2AF70A0F, "SD" ],  // 42.247.10.0-42.247.10.15, SD
        [ 0x2AF70A10, 0x2AF70A1F, "CQ" ],  // 42.247.10.16-42.247.10.31, CQ
        [ 0x2AF70A20, 0x2AF70A4F, "XJ" ],  // 42.247.10.32-42.247.10.79, XJ
        [ 0x2AF70A50, 0x2AF70A5F, "FJ" ],  // 42.247.10.80-42.247.10.95, FJ
        [ 0x2AF70A60, 0x2AF70A9F, "SH" ],  // 42.247.10.96-42.247.10.159, SH
        [ 0x2AF70AA0, 0x2AF70ABF, "ZJ" ],  // 42.247.10.160-42.247.10.191, ZJ
        [ 0x2AF70AC0, 0x2AF70ADF, "SD" ],  // 42.247.10.192-42.247.10.223, SD
        [ 0x2AF70AE0, 0x2AF70B1F, "ZJ" ],  // 42.247.10.224-42.247.11.31, ZJ
        [ 0x2AF70B20, 0x2AF70B3F, "GD" ],  // 42.247.11.32-42.247.11.63, GD
        [ 0x2AF70B40, 0x2AF70B4F, "FJ" ],  // 42.247.11.64-42.247.11.79, FJ
        [ 0x2AF70B50, 0x2AF70B5F, "SH" ],  // 42.247.11.80-42.247.11.95, SH
        [ 0x2AF70B60, 0x2AF70B6F, "CQ" ],  // 42.247.11.96-42.247.11.111, CQ
        [ 0x2AF70B70, 0x2AF70B9F, "FJ" ],  // 42.247.11.112-42.247.11.159, FJ
        [ 0x2AF70BA0, 0x2AF70BAF, "SN" ],  // 42.247.11.160-42.247.11.175, SN
        [ 0x2AF70BB0, 0x2AF70BBF, "FJ" ],  // 42.247.11.176-42.247.11.191, FJ
        [ 0x2AF70BC0, 0x2AF70BDF, "HB" ],  // 42.247.11.192-42.247.11.223, HB
        [ 0x2AF70BE0, 0x2AF70BEF, "JX" ],  // 42.247.11.224-42.247.11.239, JX
        [ 0x2AF70BF0, 0x2AF70BFF, "GS" ],  // 42.247.11.240-42.247.11.255, GS
        [ 0x2AF70C00, 0x2AF70C1F, "HB" ],  // 42.247.12.0-42.247.12.31, HB
        [ 0x2AF70C20, 0x2AF70C3F, "SH" ],  // 42.247.12.32-42.247.12.63, SH
        [ 0x2AF70C40, 0x2AF70C4F, "FJ" ],  // 42.247.12.64-42.247.12.79, FJ
        [ 0x2AF70C50, 0x2AF70C5F, "GX" ],  // 42.247.12.80-42.247.12.95, GX
        [ 0x2AF70C60, 0x2AF70CFF, "BJ" ],  // 42.247.12.96-42.247.12.255, BJ
        [ 0x2AF70D00, 0x2AF70D5F, "SD" ],  // 42.247.13.0-42.247.13.95, SD
        [ 0x2AF70D60, 0x2AF70D6F, "HE" ],  // 42.247.13.96-42.247.13.111, HE
        [ 0x2AF70D70, 0x2AF70D7F, "AH" ],  // 42.247.13.112-42.247.13.127, AH
        [ 0x2AF70D80, 0x2AF70D8F, "HE" ],  // 42.247.13.128-42.247.13.143, HE
        [ 0x2AF70D90, 0x2AF70D97, "BJ" ],  // 42.247.13.144-42.247.13.151, BJ
        [ 0x2AF70D98, 0x2AF70D9F, "HE" ],  // 42.247.13.152-42.247.13.159, HE
        [ 0x2AF70DA0, 0x2AF70DAF, "JS" ],  // 42.247.13.160-42.247.13.175, JS
        [ 0x2AF70DB0, 0x2AF70DBF, "LN" ],  // 42.247.13.176-42.247.13.191, LN
        [ 0x2AF70DC0, 0x2AF70DDF, "SD" ],  // 42.247.13.192-42.247.13.223, SD
        [ 0x2AF70DE0, 0x2AF70DEF, "JS" ],  // 42.247.13.224-42.247.13.239, JS
        [ 0x2AF70DF0, 0x2AF70DFF, "ZJ" ],  // 42.247.13.240-42.247.13.255, ZJ
        [ 0x2AF70E00, 0x2AF70E1F, "SD" ],  // 42.247.14.0-42.247.14.31, SD
        [ 0x2AF70E20, 0x2AF70E2F, "HL" ],  // 42.247.14.32-42.247.14.47, HL
        [ 0x2AF70E30, 0x2AF70E3F, "GZ" ],  // 42.247.14.48-42.247.14.63, GZ
        [ 0x2AF70E40, 0x2AF70E7F, "GD" ],  // 42.247.14.64-42.247.14.127, GD
        [ 0x2AF70E80, 0x2AF70EFF, "BJ" ],  // 42.247.14.128-42.247.14.255, BJ
        [ 0x2AF70F00, 0x2AF70F0F, "HB" ],  // 42.247.15.0-42.247.15.15, HB
        [ 0x2AF70F10, 0x2AF70F1F, "TJ" ],  // 42.247.15.16-42.247.15.31, TJ
        [ 0x2AF70F20, 0x2AF70F3F, "JL" ],  // 42.247.15.32-42.247.15.63, JL
        [ 0x2AF70F40, 0x2AF70F5F, "HI" ],  // 42.247.15.64-42.247.15.95, HI
        [ 0x2AF70F60, 0x2AF70F7F, "LN" ],  // 42.247.15.96-42.247.15.127, LN
        [ 0x2AF70F80, 0x2AF70F9F, "TJ" ],  // 42.247.15.128-42.247.15.159, TJ
        [ 0x2AF70FA0, 0x2AF70FBF, "JS" ],  // 42.247.15.160-42.247.15.191, JS
        [ 0x2AF70FC0, 0x2AF70FDF, "HA" ],  // 42.247.15.192-42.247.15.223, HA
        [ 0x2AF70FE0, 0x2AF70FEF, "GD" ],  // 42.247.15.224-42.247.15.239, GD
        [ 0x2AF70FF0, 0x2AF70FFF, "AH" ],  // 42.247.15.240-42.247.15.255, AH
        [ 0x2AF71000, 0x2AF7102F, "NM" ],  // 42.247.16.0-42.247.16.47, NM
        [ 0x2AF71030, 0x2AF7103F, "JL" ],  // 42.247.16.48-42.247.16.63, JL
        [ 0x2AF71040, 0x2AF7104F, "HL" ],  // 42.247.16.64-42.247.16.79, HL
        [ 0x2AF71050, 0x2AF7105F, "SH" ],  // 42.247.16.80-42.247.16.95, SH
        [ 0x2AF71060, 0x2AF7107F, "SN" ],  // 42.247.16.96-42.247.16.127, SN
        [ 0x2AF71080, 0x2AF7109F, "BJ" ],  // 42.247.16.128-42.247.16.159, BJ
        [ 0x2AF710A0, 0x2AF710BF, "HL" ],  // 42.247.16.160-42.247.16.191, HL
        [ 0x2AF710C0, 0x2AF710EF, "SH" ],  // 42.247.16.192-42.247.16.239, SH
        [ 0x2AF710F0, 0x2AF710FF, "HE" ],  // 42.247.16.240-42.247.16.255, HE
        [ 0x2AF71100, 0x2AF711FF, "YN" ],  // 42.247.17.0-42.247.17.255, YN
        [ 0x2AF71200, 0x2AF7120F, "JS" ],  // 42.247.18.0-42.247.18.15, JS
        [ 0x2AF71210, 0x2AF712FF, "JL" ],  // 42.247.18.16-42.247.18.255, JL
        [ 0x2AF71300, 0x2AF7131F, "TJ" ],  // 42.247.19.0-42.247.19.31, TJ
        [ 0x2AF71320, 0x2AF7134F, "SH" ],  // 42.247.19.32-42.247.19.79, SH
        [ 0x2AF71350, 0x2AF7135F, "ZJ" ],  // 42.247.19.80-42.247.19.95, ZJ
        [ 0x2AF71360, 0x2AF7137F, "JS" ],  // 42.247.19.96-42.247.19.127, JS
        [ 0x2AF71380, 0x2AF7139F, "GD" ],  // 42.247.19.128-42.247.19.159, GD
        [ 0x2AF713A0, 0x2AF713BF, "TJ" ],  // 42.247.19.160-42.247.19.191, TJ
        [ 0x2AF713C0, 0x2AF713CF, "SD" ],  // 42.247.19.192-42.247.19.207, SD
        [ 0x2AF713D0, 0x2AF713DF, "ZJ" ],  // 42.247.19.208-42.247.19.223, ZJ
        [ 0x2AF713E0, 0x2AF713FF, "SD" ],  // 42.247.19.224-42.247.19.255, SD
        [ 0x2AF71400, 0x2AF7140F, "JS" ],  // 42.247.20.0-42.247.20.15, JS
        [ 0x2AF71410, 0x2AF7143F, "GD" ],  // 42.247.20.16-42.247.20.63, GD
        [ 0x2AF71440, 0x2AF7144F, "GZ" ],  // 42.247.20.64-42.247.20.79, GZ
        [ 0x2AF71450, 0x2AF7145F, "BJ" ],  // 42.247.20.80-42.247.20.95, BJ
        [ 0x2AF71460, 0x2AF71463, "HB" ],  // 42.247.20.96-42.247.20.99, HB
        [ 0x2AF71464, 0x2AF71467, "GD" ],  // 42.247.20.100-42.247.20.103, GD
        [ 0x2AF71468, 0x2AF7146B, "GS" ],  // 42.247.20.104-42.247.20.107, GS
        [ 0x2AF7146C, 0x2AF7146F, "GD" ],  // 42.247.20.108-42.247.20.111, GD
        [ 0x2AF71470, 0x2AF7147F, "GX" ],  // 42.247.20.112-42.247.20.127, GX
        [ 0x2AF71480, 0x2AF7148F, "HA" ],  // 42.247.20.128-42.247.20.143, HA
        [ 0x2AF71490, 0x2AF7149F, "AH" ],  // 42.247.20.144-42.247.20.159, AH
        [ 0x2AF714A0, 0x2AF714BF, "NX" ],  // 42.247.20.160-42.247.20.191, NX
        [ 0x2AF714C0, 0x2AF714CF, "BJ" ],  // 42.247.20.192-42.247.20.207, BJ
        [ 0x2AF714D0, 0x2AF714DF, "YN" ],  // 42.247.20.208-42.247.20.223, YN
        [ 0x2AF714E0, 0x2AF714FF, "XJ" ],  // 42.247.20.224-42.247.20.255, XJ
        [ 0x2AF71500, 0x2AF7151F, "SD" ],  // 42.247.21.0-42.247.21.31, SD
        [ 0x2AF71520, 0x2AF7154F, "XJ" ],  // 42.247.21.32-42.247.21.79, XJ
        [ 0x2AF71550, 0x2AF71553, "TJ" ],  // 42.247.21.80-42.247.21.83, TJ
        [ 0x2AF71554, 0x2AF71557, "SH" ],  // 42.247.21.84-42.247.21.87, SH
        [ 0x2AF71558, 0x2AF7155B, "CQ" ],  // 42.247.21.88-42.247.21.91, CQ
        [ 0x2AF7155C, 0x2AF7155F, "HE" ],  // 42.247.21.92-42.247.21.95, HE
        [ 0x2AF71560, 0x2AF71563, "SX" ],  // 42.247.21.96-42.247.21.99, SX
        [ 0x2AF71564, 0x2AF71567, "GX" ],  // 42.247.21.100-42.247.21.103, GX
        [ 0x2AF71568, 0x2AF7156F, "LN" ],  // 42.247.21.104-42.247.21.111, LN
        [ 0x2AF71570, 0x2AF71573, "JL" ],  // 42.247.21.112-42.247.21.115, JL
        [ 0x2AF71574, 0x2AF71577, "HL" ],  // 42.247.21.116-42.247.21.119, HL
        [ 0x2AF71578, 0x2AF7157B, "JS" ],  // 42.247.21.120-42.247.21.123, JS
        [ 0x2AF7157C, 0x2AF7157F, "ZJ" ],  // 42.247.21.124-42.247.21.127, ZJ
        [ 0x2AF71580, 0x2AF7159F, "JS" ],  // 42.247.21.128-42.247.21.159, JS
        [ 0x2AF715A0, 0x2AF715AF, "HE" ],  // 42.247.21.160-42.247.21.175, HE
        [ 0x2AF715B0, 0x2AF715BF, "SD" ],  // 42.247.21.176-42.247.21.191, SD
        [ 0x2AF715C0, 0x2AF715FF, "GX" ],  // 42.247.21.192-42.247.21.255, GX
        [ 0x2AF71600, 0x2AF7161F, "SH" ],  // 42.247.22.0-42.247.22.31, SH
        [ 0x2AF71620, 0x2AF7163F, "JS" ],  // 42.247.22.32-42.247.22.63, JS
        [ 0x2AF71640, 0x2AF7169F, "GD" ],  // 42.247.22.64-42.247.22.159, GD
        [ 0x2AF716A0, 0x2AF716BF, "JS" ],  // 42.247.22.160-42.247.22.191, JS
        [ 0x2AF716C0, 0x2AF716DF, "AH" ],  // 42.247.22.192-42.247.22.223, AH
        [ 0x2AF716E0, 0x2AF716F7, "GD" ],  // 42.247.22.224-42.247.22.247, GD
        [ 0x2AF716F8, 0x2AF716FF, "BJ" ],  // 42.247.22.248-42.247.22.255, BJ
        [ 0x2AF71700, 0x2AF7173F, "HE" ],  // 42.247.23.0-42.247.23.63, HE
        [ 0x2AF71740, 0x2AF7175F, "SD" ],  // 42.247.23.64-42.247.23.95, SD
        [ 0x2AF71760, 0x2AF7177F, "SH" ],  // 42.247.23.96-42.247.23.127, SH
        [ 0x2AF71780, 0x2AF7178F, "GZ" ],  // 42.247.23.128-42.247.23.143, GZ
        [ 0x2AF71790, 0x2AF7179F, "ZJ" ],  // 42.247.23.144-42.247.23.159, ZJ
        [ 0x2AF717A0, 0x2AF717BF, "JS" ],  // 42.247.23.160-42.247.23.191, JS
        [ 0x2AF717C0, 0x2AF717DF, "YN" ],  // 42.247.23.192-42.247.23.223, YN
        [ 0x2AF717E0, 0x2AF717EF, "GX" ],  // 42.247.23.224-42.247.23.239, GX
        [ 0x2AF717F0, 0x2AF717FF, "YN" ],  // 42.247.23.240-42.247.23.255, YN
        [ 0x2AF71800, 0x2AF7181F, "SC" ],  // 42.247.24.0-42.247.24.31, SC
        [ 0x2AF71820, 0x2AF7182F, "FJ" ],  // 42.247.24.32-42.247.24.47, FJ
        [ 0x2AF71830, 0x2AF7183F, "JS" ],  // 42.247.24.48-42.247.24.63, JS
        [ 0x2AF71840, 0x2AF7184F, "AH" ],  // 42.247.24.64-42.247.24.79, AH
        [ 0x2AF71850, 0x2AF7185F, "NM" ],  // 42.247.24.80-42.247.24.95, NM
        [ 0x2AF71860, 0x2AF7187F, "ZJ" ],  // 42.247.24.96-42.247.24.127, ZJ
        [ 0x2AF71880, 0x2AF7188F, "AH" ],  // 42.247.24.128-42.247.24.143, AH
        [ 0x2AF71890, 0x2AF7189F, "GD" ],  // 42.247.24.144-42.247.24.159, GD
        [ 0x2AF718A0, 0x2AF718AF, "HL" ],  // 42.247.24.160-42.247.24.175, HL
        [ 0x2AF718B0, 0x2AF718CF, "LN" ],  // 42.247.24.176-42.247.24.207, LN
        [ 0x2AF718D0, 0x2AF718DF, "AH" ],  // 42.247.24.208-42.247.24.223, AH
        [ 0x2AF718E0, 0x2AF718FF, "ZJ" ],  // 42.247.24.224-42.247.24.255, ZJ
        [ 0x2AF71900, 0x2AF7190F, "FJ" ],  // 42.247.25.0-42.247.25.15, FJ
        [ 0x2AF71910, 0x2AF7191F, "JS" ],  // 42.247.25.16-42.247.25.31, JS
        [ 0x2AF71920, 0x2AF7192F, "ZJ" ],  // 42.247.25.32-42.247.25.47, ZJ
        [ 0x2AF71930, 0x2AF7193F, "HA" ],  // 42.247.25.48-42.247.25.63, HA
        [ 0x2AF71940, 0x2AF7194F, "HE" ],  // 42.247.25.64-42.247.25.79, HE
        [ 0x2AF71950, 0x2AF7195F, "CQ" ],  // 42.247.25.80-42.247.25.95, CQ
        [ 0x2AF71960, 0x2AF7197F, "SD" ],  // 42.247.25.96-42.247.25.127, SD
        [ 0x2AF71980, 0x2AF7198F, "HB" ],  // 42.247.25.128-42.247.25.143, HB
        [ 0x2AF71990, 0x2AF7199F, "HI" ],  // 42.247.25.144-42.247.25.159, HI
        [ 0x2AF719A0, 0x2AF719BF, "HN" ],  // 42.247.25.160-42.247.25.191, HN
        [ 0x2AF719C0, 0x2AF719CF, "GX" ],  // 42.247.25.192-42.247.25.207, GX
        [ 0x2AF719D0, 0x2AF719FF, "HA" ],  // 42.247.25.208-42.247.25.255, HA
        [ 0x2AF71A00, 0x2AF71A0F, "AH" ],  // 42.247.26.0-42.247.26.15, AH
        [ 0x2AF71A10, 0x2AF71A1F, "YN" ],  // 42.247.26.16-42.247.26.31, YN
        [ 0x2AF71A20, 0x2AF71A3F, "GD" ],  // 42.247.26.32-42.247.26.63, GD
        [ 0x2AF71A40, 0x2AF71A5F, "GX" ],  // 42.247.26.64-42.247.26.95, GX
        [ 0x2AF71A60, 0x2AF71A7F, "SN" ],  // 42.247.26.96-42.247.26.127, SN
        [ 0x2AF71A80, 0x2AF71A9F, "SD" ],  // 42.247.26.128-42.247.26.159, SD
        [ 0x2AF71AA0, 0x2AF71AAF, "GZ" ],  // 42.247.26.160-42.247.26.175, GZ
        [ 0x2AF71AB0, 0x2AF71ABF, "JX" ],  // 42.247.26.176-42.247.26.191, JX
        [ 0x2AF71AC0, 0x2AF71ACF, "AH" ],  // 42.247.26.192-42.247.26.207, AH
        [ 0x2AF71AD0, 0x2AF71ADF, "SD" ],  // 42.247.26.208-42.247.26.223, SD
        [ 0x2AF71AE0, 0x2AF71AF7, "CQ" ],  // 42.247.26.224-42.247.26.247, CQ
        [ 0x2AF71AF8, 0x2AF71AFF, "SD" ],  // 42.247.26.248-42.247.26.255, SD
        [ 0x2AF71B00, 0x2AF71B0F, "YN" ],  // 42.247.27.0-42.247.27.15, YN
        [ 0x2AF71B10, 0x2AF71B1F, "GZ" ],  // 42.247.27.16-42.247.27.31, GZ
        [ 0x2AF71B20, 0x2AF71B3F, "SD" ],  // 42.247.27.32-42.247.27.63, SD
        [ 0x2AF71B40, 0x2AF71B4F, "JL" ],  // 42.247.27.64-42.247.27.79, JL
        [ 0x2AF71B50, 0x2AF71B5F, "CQ" ],  // 42.247.27.80-42.247.27.95, CQ
        [ 0x2AF71B60, 0x2AF71B7F, "JS" ],  // 42.247.27.96-42.247.27.127, JS
        [ 0x2AF71B80, 0x2AF71B8F, "ZJ" ],  // 42.247.27.128-42.247.27.143, ZJ
        [ 0x2AF71B90, 0x2AF71B9F, "AH" ],  // 42.247.27.144-42.247.27.159, AH
        [ 0x2AF71BA0, 0x2AF71BCF, "NM" ],  // 42.247.27.160-42.247.27.207, NM
        [ 0x2AF71BD0, 0x2AF71BE7, "CQ" ],  // 42.247.27.208-42.247.27.231, CQ
        [ 0x2AF71BE8, 0x2AF71BFF, "NX" ],  // 42.247.27.232-42.247.27.255, NX
        [ 0x2AF71C00, 0x2AF71C3F, "GD" ],  // 42.247.28.0-42.247.28.63, GD
        [ 0x2AF71C40, 0x2AF71C5F, "SH" ],  // 42.247.28.64-42.247.28.95, SH
        [ 0x2AF71C60, 0x2AF71C6F, "JL" ],  // 42.247.28.96-42.247.28.111, JL
        [ 0x2AF71C70, 0x2AF71C7F, "FJ" ],  // 42.247.28.112-42.247.28.127, FJ
        [ 0x2AF71C80, 0x2AF71C9F, "SD" ],  // 42.247.28.128-42.247.28.159, SD
        [ 0x2AF71CA0, 0x2AF71CBF, "AH" ],  // 42.247.28.160-42.247.28.191, AH
        [ 0x2AF71CC0, 0x2AF71CDF, "HA" ],  // 42.247.28.192-42.247.28.223, HA
        [ 0x2AF71CE0, 0x2AF71CFF, "AH" ],  // 42.247.28.224-42.247.28.255, AH
        [ 0x2AF71D00, 0x2AF71DFF, "GX" ],  // 42.247.29.0-42.247.29.255, GX
        [ 0x2AF71E00, 0x2AF71E1F, "ZJ" ],  // 42.247.30.0-42.247.30.31, ZJ
        [ 0x2AF71E20, 0x2AF71E2F, "GD" ],  // 42.247.30.32-42.247.30.47, GD
        [ 0x2AF71E30, 0x2AF71E3F, "AH" ],  // 42.247.30.48-42.247.30.63, AH
        [ 0x2AF71E40, 0x2AF71E4F, "HE" ],  // 42.247.30.64-42.247.30.79, HE
        [ 0x2AF71E50, 0x2AF71E5F, "AH" ],  // 42.247.30.80-42.247.30.95, AH
        [ 0x2AF71E60, 0x2AF71E7F, "XJ" ],  // 42.247.30.96-42.247.30.127, XJ
        [ 0x2AF71E80, 0x2AF71EFF, "ZJ" ],  // 42.247.30.128-42.247.30.255, ZJ
        [ 0x2AF71F00, 0x2AF71F0F, "GD" ],  // 42.247.31.0-42.247.31.15, GD
        [ 0x2AF71F10, 0x2AF71F1F, "JX" ],  // 42.247.31.16-42.247.31.31, JX
        [ 0x2AF71F20, 0x2AF71F2F, "AH" ],  // 42.247.31.32-42.247.31.47, AH
        [ 0x2AF71F30, 0x2AF71F37, "CQ" ],  // 42.247.31.48-42.247.31.55, CQ
        [ 0x2AF71F38, 0x2AF71F6F, "JX" ],  // 42.247.31.56-42.247.31.111, JX
        [ 0x2AF71F70, 0x2AF71FDF, "SD" ],  // 42.247.31.112-42.247.31.223, SD
        [ 0x2AF71FE0, 0x2AF71FEF, "JS" ],  // 42.247.31.224-42.247.31.239, JS
        [ 0x2AF71FF0, 0x2AF71FFF, "JX" ],  // 42.247.31.240-42.247.31.255, JX
        [ 0x2AF72000, 0x2AF7201F, "TJ" ],  // 42.247.32.0-42.247.32.31, TJ
        [ 0x2AF72020, 0x2AF7203F, "BJ" ],  // 42.247.32.32-42.247.32.63, BJ
        [ 0x2AF72040, 0x2AF7204F, "SD" ],  // 42.247.32.64-42.247.32.79, SD
        [ 0x2AF72050, 0x2AF7205F, "HE" ],  // 42.247.32.80-42.247.32.95, HE
        [ 0x2AF72060, 0x2AF7206F, "XJ" ],  // 42.247.32.96-42.247.32.111, XJ
        [ 0x2AF72070, 0x2AF7207F, "AH" ],  // 42.247.32.112-42.247.32.127, AH
        [ 0x2AF72080, 0x2AF7208F, "FJ" ],  // 42.247.32.128-42.247.32.143, FJ
        [ 0x2AF72090, 0x2AF7209F, "CQ" ],  // 42.247.32.144-42.247.32.159, CQ
        [ 0x2AF720A0, 0x2AF720BF, "SH" ],  // 42.247.32.160-42.247.32.191, SH
        [ 0x2AF720C0, 0x2AF720EF, "AH" ],  // 42.247.32.192-42.247.32.239, AH
        [ 0x2AF720F0, 0x2AF720FF, "SH" ],  // 42.247.32.240-42.247.32.255, SH
        [ 0x2AF72100, 0x2AF7210F, "SD" ],  // 42.247.33.0-42.247.33.15, SD
        [ 0x2AF72110, 0x2AF7213F, "ZJ" ],  // 42.247.33.16-42.247.33.63, ZJ
        [ 0x2AF72140, 0x2AF721FF, "NX" ],  // 42.247.33.64-42.247.33.255, NX
        [ 0x2AF72200, 0x2AF7237F, "CQ" ],  // 42.247.34.0-42.247.35.127, CQ
        [ 0x2AF72380, 0x2AF7238F, "FJ" ],  // 42.247.35.128-42.247.35.143, FJ
        [ 0x2AF72390, 0x2AF7239F, "NX" ],  // 42.247.35.144-42.247.35.159, NX
        [ 0x2AF723A0, 0x2AF723BF, "YN" ],  // 42.247.35.160-42.247.35.191, YN
        [ 0x2AF723C0, 0x2AF723DF, "GZ" ],  // 42.247.35.192-42.247.35.223, GZ
        [ 0x2AF723E0, 0x2AF723EF, "SN" ],  // 42.247.35.224-42.247.35.239, SN
        [ 0x2AF723F0, 0x2AF723FF, "HB" ],  // 42.247.35.240-42.247.35.255, HB
        [ 0x2AF72400, 0x2AF7242F, "CQ" ],  // 42.247.36.0-42.247.36.47, CQ
        [ 0x2AF72430, 0x2AF7243F, "GX" ],  // 42.247.36.48-42.247.36.63, GX
        [ 0x2AF72440, 0x2AF7245F, "HA" ],  // 42.247.36.64-42.247.36.95, HA
        [ 0x2AF72460, 0x2AF7246F, "GX" ],  // 42.247.36.96-42.247.36.111, GX
        [ 0x2AF72470, 0x2AF7247F, "BJ" ],  // 42.247.36.112-42.247.36.127, BJ
        [ 0x2AF72480, 0x2AF7249F, "GX" ],  // 42.247.36.128-42.247.36.159, GX
        [ 0x2AF724A0, 0x2AF724BF, "GD" ],  // 42.247.36.160-42.247.36.191, GD
        [ 0x2AF724C0, 0x2AF724DF, "GX" ],  // 42.247.36.192-42.247.36.223, GX
        [ 0x2AF724E0, 0x2AF724FF, "GD" ],  // 42.247.36.224-42.247.36.255, GD
        [ 0x2AF72500, 0x2AF7257F, "JS" ],  // 42.247.37.0-42.247.37.127, JS
        [ 0x2AF72580, 0x2AF725BF, "GX" ],  // 42.247.37.128-42.247.37.191, GX
        [ 0x2AF725C0, 0x2AF725CF, "FJ" ],  // 42.247.37.192-42.247.37.207, FJ
        [ 0x2AF725D0, 0x2AF725DF, "GD" ],  // 42.247.37.208-42.247.37.223, GD
        [ 0x2AF725E0, 0x2AF725FF, "HN" ],  // 42.247.37.224-42.247.37.255, HN
        [ 0x2AF72600, 0x2AF7262F, "BJ" ],  // 42.247.38.0-42.247.38.47, BJ
        [ 0x2AF72630, 0x2AF7263F, "FJ" ],  // 42.247.38.48-42.247.38.63, FJ
        [ 0x2AF72640, 0x2AF727FF, "CQ" ],  // 42.247.38.64-42.247.39.255, CQ
        [ 0x2AF72800, 0x2AF728FF, "GS" ],  // 42.247.40.0-42.247.40.255, GS
        [ 0x2AF72900, 0x2AF7297F, "HN" ],  // 42.247.41.0-42.247.41.127, HN
        [ 0x2AF72980, 0x2AF729FF, "HA" ],  // 42.247.41.128-42.247.41.255, HA
        [ 0x2AF72A00, 0x2AF72AFF, "LN" ],  // 42.247.42.0-42.247.42.255, LN
        [ 0x2AF72B00, 0x2AF72BFF, "JS" ],  // 42.247.43.0-42.247.43.255, JS
        [ 0x2AF72C00, 0x2AF72CFF, "SH" ],  // 42.247.44.0-42.247.44.255, SH
        [ 0x2AF72D00, 0x2AF72DFF, "YN" ],  // 42.247.45.0-42.247.45.255, YN
        [ 0x2AF72E00, 0x2AF72EFF, "JX" ],  // 42.247.46.0-42.247.46.255, JX
        [ 0x2AF72F00, 0x2AF72FFF, "NM" ],  // 42.247.47.0-42.247.47.255, NM
        [ 0x2AF73000, 0x2AF734FF, "GD" ],  // 42.247.48.0-42.247.52.255, GD
        [ 0x2AF73500, 0x2AF736FF, "FJ" ],  // 42.247.53.0-42.247.54.255, FJ
        [ 0x2AF73700, 0x2AF737FF, "SC" ],  // 42.247.55.0-42.247.55.255, SC
        [ 0x2AF73800, 0x2AF738FF, "SH" ],  // 42.247.56.0-42.247.56.255, SH
        [ 0x2AF73900, 0x2AF739FF, "FJ" ],  // 42.247.57.0-42.247.57.255, FJ
        [ 0x2AF73A00, 0x2AF73AFF, "YN" ],  // 42.247.58.0-42.247.58.255, YN
        [ 0x2AF73B00, 0x2AF73BFF, "SX" ],  // 42.247.59.0-42.247.59.255, SX
        [ 0x2AF73C00, 0x2AF73CFF, "SD" ],  // 42.247.60.0-42.247.60.255, SD
        [ 0x2AF73D00, 0x2AF73DFF, "HL" ],  // 42.247.61.0-42.247.61.255, HL
        [ 0x2AF73E00, 0x2AF73FFF, "FJ" ],  // 42.247.62.0-42.247.63.255, FJ
        [ 0x2AF74000, 0x2AF75FFF, "GD" ],  // 42.247.64.0-42.247.95.255, GD
        [ 0x2AF76000, 0x2AF7FFFF, "JL" ],  // 42.247.96.0-42.247.255.255, JL
        [ 0x2AF80000, 0x2AFFFFFF, "LN" ],  // 42.248.0.0-42.255.255.255, LN
        [ 0x2B000000, 0x2B0200FF, "UNK" ],  // 43.0.0.0-43.2.0.255, UNK
        [ 0x2B020100, 0x2B3FFFFF, "ZJ" ],  // 43.2.1.0-43.63.255.255, ZJ
        [ 0x2B520000, 0x2B526FFF, "SH" ],  // 43.82.0.0-43.82.111.255, SH
        [ 0x2B527000, 0x2B52FFFF, "ZJ" ],  // 43.82.112.0-43.82.255.255, ZJ
        [ 0x2B880000, 0x2B887FFF, "GD" ],  // 43.136.0.0-43.136.127.255, GD
        [ 0x2B888000, 0x2B88FFFF, "SC" ],  // 43.136.128.0-43.136.255.255, SC
        [ 0x2B890000, 0x2B897FFF, "JS" ],  // 43.137.0.0-43.137.127.255, JS
        [ 0x2B898000, 0x2B899FFF, "SH" ],  // 43.137.128.0-43.137.159.255, SH
        [ 0x2B89A000, 0x2B89BFFF, "JS" ],  // 43.137.160.0-43.137.191.255, JS
        [ 0x2B89C000, 0x2B89DFFF, "GD" ],  // 43.137.192.0-43.137.223.255, GD
        [ 0x2B89E000, 0x2B89FFFF, "TJ" ],  // 43.137.224.0-43.137.255.255, TJ
        [ 0x2B8A0000, 0x2B8A7FFF, "BJ" ],  // 43.138.0.0-43.138.127.255, BJ
        [ 0x2B8A8000, 0x2B8BFFFF, "GD" ],  // 43.138.128.0-43.139.255.255, GD
        [ 0x2B8C0000, 0x2B8C3FFF, "JS" ],  // 43.140.0.0-43.140.63.255, JS
        [ 0x2B8C4000, 0x2B8C7FFF, "SH" ],  // 43.140.64.0-43.140.127.255, SH
        [ 0x2B8C8000, 0x2B8CBFFF, "GZ" ],  // 43.140.128.0-43.140.191.255, GZ
        [ 0x2B8CC000, 0x2B8CFFFF, "BJ" ],  // 43.140.192.0-43.140.255.255, BJ
        [ 0x2B8D0000, 0x2B8D3FFF, "SH" ],  // 43.141.0.0-43.141.63.255, SH
        [ 0x2B8D4000, 0x2B8D7FFF, "TJ" ],  // 43.141.64.0-43.141.127.255, TJ
        [ 0x2B8D8000, 0x2B8DFFFF, "BJ" ],  // 43.141.128.0-43.141.255.255, BJ
        [ 0x2B8E0000, 0x2B8F7FFF, "SH" ],  // 43.142.0.0-43.143.127.255, SH
        [ 0x2B8F8000, 0x2B8FFFFF, "BJ" ],  // 43.143.128.0-43.143.255.255, BJ
        [ 0x2B900000, 0x2B97FFFF, "JS" ],  // 43.144.0.0-43.151.255.255, JS
        [ 0x2B981700, 0x2B9817FF, "GD" ],  // 43.152.23.0-43.152.23.255, GD
        [ 0x2B986D00, 0x2B986DFF, "GD" ],  // 43.152.109.0-43.152.109.255, GD
        [ 0x2B986F00, 0x2B986FFF, "GD" ],  // 43.152.111.0-43.152.111.255, GD
        [ 0x2B987100, 0x2B9871FF, "GD" ],  // 43.152.113.0-43.152.113.255, GD
        [ 0x2B987400, 0x2B987FFF, "GD" ],  // 43.152.116.0-43.152.127.255, GD
        [ 0x2B988900, 0x2B9889FF, "GD" ],  // 43.152.137.0-43.152.137.255, GD
        [ 0x2B98A100, 0x2B98A2FF, "GD" ],  // 43.152.161.0-43.152.162.255, GD
        [ 0x2B98B800, 0x2B98B8FF, "GD" ],  // 43.152.184.0-43.152.184.255, GD
        [ 0x2B98BE00, 0x2B98BEFF, "GD" ],  // 43.152.190.0-43.152.190.255, GD
        [ 0x2BA80000, 0x2BAC0EFF, "GD" ],  // 43.168.0.0-43.172.14.255, GD
        [ 0x2BAC1000, 0x2BAF02FF, "GD" ],  // 43.172.16.0-43.175.2.255, GD
        [ 0x2BAF7000, 0x2BAF70FF, "GD" ],  // 43.175.112.0-43.175.112.255, GD
        [ 0x2BAFDF00, 0x2BAFDFFF, "GD" ],  // 43.175.223.0-43.175.223.255, GD
        [ 0x2BAFE600, 0x2BAFEEFF, "GD" ],  // 43.175.230.0-43.175.238.255, GD
        [ 0x2BAFF300, 0x2BAFF3FF, "GD" ],  // 43.175.243.0-43.175.243.255, GD
        [ 0x2BAFF900, 0x2BAFF9FF, "GD" ],  // 43.175.249.0-43.175.249.255, GD
        [ 0x2BAFFB00, 0x2BAFFBFF, "GD" ],  // 43.175.251.0-43.175.251.255, GD
        [ 0x2BAFFE00, 0x2BAFFEFF, "GD" ],  // 43.175.254.0-43.175.254.255, GD
        [ 0x2BB00000, 0x2BBFFFFF, "GD" ],  // 43.176.0.0-43.191.255.255, GD
        [ 0x2BC00000, 0x2BC2FFFF, "NX" ],  // 43.192.0.0-43.194.255.255, NX
        [ 0x2BC30000, 0x2BC5FFFF, "BJ" ],  // 43.195.0.0-43.197.255.255, BJ
        [ 0x2BE00C00, 0x2BE00FFF, "FJ" ],  // 43.224.12.0-43.224.15.255, FJ
        [ 0x2BE01800, 0x2BE01BFF, "JX" ],  // 43.224.24.0-43.224.27.255, JX
        [ 0x2BE02C00, 0x2BE02FFF, "BJ" ],  // 43.224.44.0-43.224.47.255, BJ
        [ 0x2BE03400, 0x2BE037FF, "XJ" ],  // 43.224.52.0-43.224.55.255, XJ
        [ 0x2BE03800, 0x2BE03BFF, "JS" ],  // 43.224.56.0-43.224.59.255, JS
        [ 0x2BE04400, 0x2BE04BFF, "BJ" ],  // 43.224.68.0-43.224.75.255, BJ
        [ 0x2BE05000, 0x2BE053FF, "AH" ],  // 43.224.80.0-43.224.83.255, AH
        [ 0x2BE06400, 0x2BE067FF, "SH" ],  // 43.224.100.0-43.224.103.255, SH
        [ 0x2BE09000, 0x2BE093FF, "BJ" ],  // 43.224.144.0-43.224.147.255, BJ
        [ 0x2BE0A000, 0x2BE0A3FF, "HN" ],  // 43.224.160.0-43.224.163.255, HN
        [ 0x2BE0B000, 0x2BE0B3FF, "SH" ],  // 43.224.176.0-43.224.179.255, SH
        [ 0x2BE0B800, 0x2BE0BBFF, "HB" ],  // 43.224.184.0-43.224.187.255, HB
        [ 0x2BE0C800, 0x2BE0CFFF, "BJ" ],  // 43.224.200.0-43.224.207.255, BJ
        [ 0x2BE0D000, 0x2BE0D3FF, "TJ" ],  // 43.224.208.0-43.224.211.255, TJ
        [ 0x2BE0D400, 0x2BE0D7FF, "BJ" ],  // 43.224.212.0-43.224.215.255, BJ
        [ 0x2BE0D800, 0x2BE0D8FF, "JS" ],  // 43.224.216.0-43.224.216.255, JS
        [ 0x2BE0D900, 0x2BE0DBFF, "BJ" ],  // 43.224.217.0-43.224.219.255, BJ
        [ 0x2BE0F000, 0x2BE0F3FF, "GD" ],  // 43.224.240.0-43.224.243.255, GD
        [ 0x2BE14C00, 0x2BE14FFF, "ZJ" ],  // 43.225.76.0-43.225.79.255, ZJ
        [ 0x2BE15400, 0x2BE156FF, "BJ" ],  // 43.225.84.0-43.225.86.255, BJ
        [ 0x2BE17800, 0x2BE17BFF, "ZJ" ],  // 43.225.120.0-43.225.123.255, ZJ
        [ 0x2BE1B400, 0x2BE1B7FF, "ZJ" ],  // 43.225.180.0-43.225.183.255, ZJ
        [ 0x2BE1D000, 0x2BE1D3FF, "HL" ],  // 43.225.208.0-43.225.211.255, HL
        [ 0x2BE1D800, 0x2BE1EBFF, "HL" ],  // 43.225.216.0-43.225.235.255, HL
        [ 0x2BE1EC00, 0x2BE1F7FF, "BJ" ],  // 43.225.236.0-43.225.247.255, BJ
        [ 0x2BE1FC00, 0x2BE1FFFF, "TJ" ],  // 43.225.252.0-43.225.255.255, TJ
        [ 0x2BE22000, 0x2BE25FFF, "LN" ],  // 43.226.32.0-43.226.95.255, LN
        [ 0x2BE26000, 0x2BE273FF, "JS" ],  // 43.226.96.0-43.226.115.255, JS
        [ 0x2BE27400, 0x2BE277FF, "NM" ],  // 43.226.116.0-43.226.119.255, NM
        [ 0x2BE27800, 0x2BE27BFF, "TJ" ],  // 43.226.120.0-43.226.123.255, TJ
        [ 0x2BE28000, 0x2BE29FFF, "LN" ],  // 43.226.128.0-43.226.159.255, LN
        [ 0x2BE2A000, 0x2BE2A3FF, "TJ" ],  // 43.226.160.0-43.226.163.255, TJ
        [ 0x2BE2A400, 0x2BE2A7FF, "JS" ],  // 43.226.164.0-43.226.167.255, JS
        [ 0x2BE2A800, 0x2BE2D7FF, "SH" ],  // 43.226.168.0-43.226.215.255, SH
        [ 0x2BE2EC00, 0x2BE2EFFF, "BJ" ],  // 43.226.236.0-43.226.239.255, BJ
        [ 0x2BE2F000, 0x2BE30BFF, "SD" ],  // 43.226.240.0-43.227.11.255, SD
        [ 0x2BE32000, 0x2BE323FF, "BJ" ],  // 43.227.32.0-43.227.35.255, BJ
        [ 0x2BE32400, 0x2BE333FF, "SD" ],  // 43.227.36.0-43.227.51.255, SD
        [ 0x2BE33400, 0x2BE337FF, "BJ" ],  // 43.227.52.0-43.227.55.255, BJ
        [ 0x2BE33800, 0x2BE33FFF, "JS" ],  // 43.227.56.0-43.227.63.255, JS
        [ 0x2BE34000, 0x2BE35FFF, "LN" ],  // 43.227.64.0-43.227.95.255, LN
        [ 0x2BE36000, 0x2BE367FF, "SH" ],  // 43.227.96.0-43.227.103.255, SH
        [ 0x2BE36800, 0x2BE36BFF, "JS" ],  // 43.227.104.0-43.227.107.255, JS
        [ 0x2BE38800, 0x2BE38BFF, "HB" ],  // 43.227.136.0-43.227.139.255, HB
        [ 0x2BE38C00, 0x2BE38FFF, "BJ" ],  // 43.227.140.0-43.227.143.255, BJ
        [ 0x2BE39000, 0x2BE393FF, "SD" ],  // 43.227.144.0-43.227.147.255, SD
        [ 0x2BE39800, 0x2BE3B7FF, "ZJ" ],  // 43.227.152.0-43.227.183.255, ZJ
        [ 0x2BE3BC00, 0x2BE3DFFF, "ZJ" ],  // 43.227.188.0-43.227.223.255, ZJ
        [ 0x2BE3E800, 0x2BE3EBFF, "BJ" ],  // 43.227.232.0-43.227.235.255, BJ
        [ 0x2BE3F800, 0x2BE3FFFF, "BJ" ],  // 43.227.248.0-43.227.255.255, BJ
        [ 0x2BE40000, 0x2BE41FFF, "ZJ" ],  // 43.228.0.0-43.228.31.255, ZJ
        [ 0x2BE42000, 0x2BE427FF, "BJ" ],  // 43.228.32.0-43.228.39.255, BJ
        [ 0x2BE42800, 0x2BE447FF, "ZJ" ],  // 43.228.40.0-43.228.71.255, ZJ
        [ 0x2BE44C00, 0x2BE44FFF, "YN" ],  // 43.228.76.0-43.228.79.255, YN
        [ 0x2BE46400, 0x2BE467FF, "BJ" ],  // 43.228.100.0-43.228.103.255, BJ
        [ 0x2BE47400, 0x2BE477FF, "BJ" ],  // 43.228.116.0-43.228.119.255, BJ
        [ 0x2BE47800, 0x2BE47BFF, "SH" ],  // 43.228.120.0-43.228.123.255, SH
        [ 0x2BE48400, 0x2BE48BFF, "BJ" ],  // 43.228.132.0-43.228.139.255, BJ
        [ 0x2BE49400, 0x2BE49BFF, "SH" ],  // 43.228.148.0-43.228.155.255, SH
        [ 0x2BE4BC00, 0x2BE4BFFF, "SD" ],  // 43.228.188.0-43.228.191.255, SD
        [ 0x2BE4CC00, 0x2BE4CFFF, "ZJ" ],  // 43.228.204.0-43.228.207.255, ZJ
        [ 0x2BE4F000, 0x2BE4F3FF, "ZJ" ],  // 43.228.240.0-43.228.243.255, ZJ
        [ 0x2BE52800, 0x2BE52BFF, "BJ" ],  // 43.229.40.0-43.229.43.255, BJ
        [ 0x2BE53000, 0x2BE533FF, "GD" ],  // 43.229.48.0-43.229.51.255, GD
        [ 0x2BE53800, 0x2BE53BFF, "BJ" ],  // 43.229.56.0-43.229.59.255, BJ
        [ 0x2BE56000, 0x2BE563FF, "BJ" ],  // 43.229.96.0-43.229.99.255, BJ
        [ 0x2BE57800, 0x2BE57BFF, "GD" ],  // 43.229.120.0-43.229.123.255, GD
        [ 0x2BE58800, 0x2BE58BFF, "BJ" ],  // 43.229.136.0-43.229.139.255, BJ
        [ 0x2BE58C00, 0x2BE58EFF, "SH" ],  // 43.229.140.0-43.229.142.255, SH
        [ 0x2BE58F00, 0x2BE58FFF, "BJ" ],  // 43.229.143.0-43.229.143.255, BJ
        [ 0x2BE59000, 0x2BE593FF, "SH" ],  // 43.229.144.0-43.229.147.255, SH
        [ 0x2BE5A800, 0x2BE5B7FF, "JS" ],  // 43.229.168.0-43.229.183.255, JS
        [ 0x2BE5B800, 0x2BE5BBFF, "BJ" ],  // 43.229.184.0-43.229.187.255, BJ
        [ 0x2BE5BC00, 0x2BE5C7FF, "SH" ],  // 43.229.188.0-43.229.199.255, SH
        [ 0x2BE5D800, 0x2BE5DBFF, "GD" ],  // 43.229.216.0-43.229.219.255, GD
        [ 0x2BE5DC00, 0x2BE5DFFF, "BJ" ],  // 43.229.220.0-43.229.223.255, BJ
        [ 0x2BE5E800, 0x2BE5EBFF, "TJ" ],  // 43.229.232.0-43.229.235.255, TJ
        [ 0x2BE5EC00, 0x2BE5EFFF, "SH" ],  // 43.229.236.0-43.229.239.255, SH
        [ 0x2BE61400, 0x2BE617FF, "HE" ],  // 43.230.20.0-43.230.23.255, HE
        [ 0x2BE62000, 0x2BE622FF, "BJ" ],  // 43.230.32.0-43.230.34.255, BJ
        [ 0x2BE62300, 0x2BE623FF, "ZJ" ],  // 43.230.35.0-43.230.35.255, ZJ
        [ 0x2BE64400, 0x2BE647FF, "BJ" ],  // 43.230.68.0-43.230.71.255, BJ
        [ 0x2BE64800, 0x2BE64BFF, "ZJ" ],  // 43.230.72.0-43.230.75.255, ZJ
        [ 0x2BE67C00, 0x2BE67FFF, "BJ" ],  // 43.230.124.0-43.230.127.255, BJ
        [ 0x2BE68800, 0x2BE689FF, "HA" ],  // 43.230.136.0-43.230.137.255, HA
        [ 0x2BE68A00, 0x2BE68AFF, "GD" ],  // 43.230.138.0-43.230.138.255, GD
        [ 0x2BE68B00, 0x2BE68BFF, "HA" ],  // 43.230.139.0-43.230.139.255, HA
        [ 0x2BE6DC00, 0x2BE6E1FF, "GD" ],  // 43.230.220.0-43.230.225.255, GD
        [ 0x2BE6E200, 0x2BE6FFFF, "ZJ" ],  // 43.230.226.0-43.230.255.255, ZJ
        [ 0x2BE72000, 0x2BE72FFF, "JS" ],  // 43.231.32.0-43.231.47.255, JS
        [ 0x2BE75000, 0x2BE76FFF, "GD" ],  // 43.231.80.0-43.231.111.255, GD
        [ 0x2BE78800, 0x2BE78FFF, "GD" ],  // 43.231.136.0-43.231.143.255, GD
        [ 0x2BE79000, 0x2BE79FFF, "JS" ],  // 43.231.144.0-43.231.159.255, JS
        [ 0x2BE7A000, 0x2BE7B7FF, "BJ" ],  // 43.231.160.0-43.231.183.255, BJ
        [ 0x2BEC0000, 0x2BEC03FF, "BJ" ],  // 43.236.0.0-43.236.3.255, BJ
        [ 0x2BEC0400, 0x2BEC07FF, "NM" ],  // 43.236.4.0-43.236.7.255, NM
        [ 0x2BEC0800, 0x2BEC0BFF, "GD" ],  // 43.236.8.0-43.236.11.255, GD
        [ 0x2BEC0C00, 0x2BEC0FFF, "HE" ],  // 43.236.12.0-43.236.15.255, HE
        [ 0x2BEC1000, 0x2BEC17FF, "BJ" ],  // 43.236.16.0-43.236.23.255, BJ
        [ 0x2BEC1800, 0x2BEC1BFF, "JS" ],  // 43.236.24.0-43.236.27.255, JS
        [ 0x2BEC1C00, 0x2BEC1FFF, "ZJ" ],  // 43.236.28.0-43.236.31.255, ZJ
        [ 0x2BEC2000, 0x2BEC27FF, "SC" ],  // 43.236.32.0-43.236.39.255, SC
        [ 0x2BEC2800, 0x2BEC2BFF, "YN" ],  // 43.236.40.0-43.236.43.255, YN
        [ 0x2BEC2C00, 0x2BEC33FF, "GD" ],  // 43.236.44.0-43.236.51.255, GD
        [ 0x2BEC3400, 0x2BEC37FF, "SD" ],  // 43.236.52.0-43.236.55.255, SD
        [ 0x2BEC3800, 0x2BEC3BFF, "GD" ],  // 43.236.56.0-43.236.59.255, GD
        [ 0x2BEC3C00, 0x2BEC3FFF, "JX" ],  // 43.236.60.0-43.236.63.255, JX
        [ 0x2BEC4000, 0x2BEC43FF, "GD" ],  // 43.236.64.0-43.236.67.255, GD
        [ 0x2BEC4400, 0x2BEC47FF, "GZ" ],  // 43.236.68.0-43.236.71.255, GZ
        [ 0x2BEC4800, 0x2BEC4BFF, "GD" ],  // 43.236.72.0-43.236.75.255, GD
        [ 0x2BEC4C00, 0x2BEC4FFF, "ZJ" ],  // 43.236.76.0-43.236.79.255, ZJ
        [ 0x2BEC5000, 0x2BEC53FF, "AH" ],  // 43.236.80.0-43.236.83.255, AH
        [ 0x2BEC5400, 0x2BEC57FF, "YN" ],  // 43.236.84.0-43.236.87.255, YN
        [ 0x2BEC5800, 0x2BEC5BFF, "SD" ],  // 43.236.88.0-43.236.91.255, SD
        [ 0x2BEC5C00, 0x2BEC5FFF, "ZJ" ],  // 43.236.92.0-43.236.95.255, ZJ
        [ 0x2BEC6000, 0x2BEC63FF, "GD" ],  // 43.236.96.0-43.236.99.255, GD
        [ 0x2BEC6400, 0x2BEC67FF, "JS" ],  // 43.236.100.0-43.236.103.255, JS
        [ 0x2BEC6800, 0x2BEC6BFF, "ZJ" ],  // 43.236.104.0-43.236.107.255, ZJ
        [ 0x2BEC6C00, 0x2BEC6FFF, "LN" ],  // 43.236.108.0-43.236.111.255, LN
        [ 0x2BEC7000, 0x2BEC73FF, "YN" ],  // 43.236.112.0-43.236.115.255, YN
        [ 0x2BEC7400, 0x2BEC77FF, "JS" ],  // 43.236.116.0-43.236.119.255, JS
        [ 0x2BEC7800, 0x2BEC7BFF, "SD" ],  // 43.236.120.0-43.236.123.255, SD
        [ 0x2BEC7C00, 0x2BEC7FFF, "GX" ],  // 43.236.124.0-43.236.127.255, GX
        [ 0x2BEC8000, 0x2BEC83FF, "HA" ],  // 43.236.128.0-43.236.131.255, HA
        [ 0x2BEC8400, 0x2BEC87FF, "SC" ],  // 43.236.132.0-43.236.135.255, SC
        [ 0x2BEC8800, 0x2BEC8BFF, "HL" ],  // 43.236.136.0-43.236.139.255, HL
        [ 0x2BEC8C00, 0x2BEC8FFF, "JX" ],  // 43.236.140.0-43.236.143.255, JX
        [ 0x2BEC9000, 0x2BEC93FF, "JS" ],  // 43.236.144.0-43.236.147.255, JS
        [ 0x2BEC9400, 0x2BEC97FF, "GX" ],  // 43.236.148.0-43.236.151.255, GX
        [ 0x2BEC9800, 0x2BEC9BFF, "JS" ],  // 43.236.152.0-43.236.155.255, JS
        [ 0x2BEC9C00, 0x2BEC9FFF, "ZJ" ],  // 43.236.156.0-43.236.159.255, ZJ
        [ 0x2BECA000, 0x2BECA3FF, "FJ" ],  // 43.236.160.0-43.236.163.255, FJ
        [ 0x2BECA400, 0x2BECA7FF, "HA" ],  // 43.236.164.0-43.236.167.255, HA
        [ 0x2BECA800, 0x2BECABFF, "GD" ],  // 43.236.168.0-43.236.171.255, GD
        [ 0x2BECAC00, 0x2BECB3FF, "SH" ],  // 43.236.172.0-43.236.179.255, SH
        [ 0x2BECB400, 0x2BECB7FF, "ZJ" ],  // 43.236.180.0-43.236.183.255, ZJ
        [ 0x2BECB800, 0x2BECBFFF, "GD" ],  // 43.236.184.0-43.236.191.255, GD
        [ 0x2BECC000, 0x2BECC3FF, "LN" ],  // 43.236.192.0-43.236.195.255, LN
        [ 0x2BECC400, 0x2BECCBFF, "GD" ],  // 43.236.196.0-43.236.203.255, GD
        [ 0x2BECCC00, 0x2BECCFFF, "AH" ],  // 43.236.204.0-43.236.207.255, AH
        [ 0x2BECD000, 0x2BECD3FF, "ZJ" ],  // 43.236.208.0-43.236.211.255, ZJ
        [ 0x2BECD400, 0x2BECD7FF, "SX" ],  // 43.236.212.0-43.236.215.255, SX
        [ 0x2BECD800, 0x2BECDBFF, "XJ" ],  // 43.236.216.0-43.236.219.255, XJ
        [ 0x2BECDC00, 0x2BECDFFF, "HE" ],  // 43.236.220.0-43.236.223.255, HE
        [ 0x2BECE000, 0x2BECE3FF, "TJ" ],  // 43.236.224.0-43.236.227.255, TJ
        [ 0x2BECE400, 0x2BECEBFF, "SD" ],  // 43.236.228.0-43.236.235.255, SD
        [ 0x2BECEC00, 0x2BECEFFF, "ZJ" ],  // 43.236.236.0-43.236.239.255, ZJ
        [ 0x2BECF000, 0x2BECF3FF, "JS" ],  // 43.236.240.0-43.236.243.255, JS
        [ 0x2BECF400, 0x2BECF7FF, "HB" ],  // 43.236.244.0-43.236.247.255, HB
        [ 0x2BECF800, 0x2BECFBFF, "GD" ],  // 43.236.248.0-43.236.251.255, GD
        [ 0x2BECFC00, 0x2BECFFFF, "SN" ],  // 43.236.252.0-43.236.255.255, SN
        [ 0x2BED0000, 0x2BED03FF, "SD" ],  // 43.237.0.0-43.237.3.255, SD
        [ 0x2BED0400, 0x2BED07FF, "JS" ],  // 43.237.4.0-43.237.7.255, JS
        [ 0x2BED0800, 0x2BED0BFF, "HB" ],  // 43.237.8.0-43.237.11.255, HB
        [ 0x2BED0C00, 0x2BED0FFF, "ZJ" ],  // 43.237.12.0-43.237.15.255, ZJ
        [ 0x2BED1000, 0x2BED13FF, "LN" ],  // 43.237.16.0-43.237.19.255, LN
        [ 0x2BED1400, 0x2BED17FF, "JL" ],  // 43.237.20.0-43.237.23.255, JL
        [ 0x2BED1800, 0x2BED1BFF, "HN" ],  // 43.237.24.0-43.237.27.255, HN
        [ 0x2BED1C00, 0x2BED1FFF, "HA" ],  // 43.237.28.0-43.237.31.255, HA
        [ 0x2BED2000, 0x2BED23FF, "GD" ],  // 43.237.32.0-43.237.35.255, GD
        [ 0x2BED2400, 0x2BED27FF, "CQ" ],  // 43.237.36.0-43.237.39.255, CQ
        [ 0x2BED2800, 0x2BED2BFF, "GD" ],  // 43.237.40.0-43.237.43.255, GD
        [ 0x2BED2C00, 0x2BED33FF, "SD" ],  // 43.237.44.0-43.237.51.255, SD
        [ 0x2BED3400, 0x2BED3BFF, "GD" ],  // 43.237.52.0-43.237.59.255, GD
        [ 0x2BED3C00, 0x2BED47FF, "ZJ" ],  // 43.237.60.0-43.237.71.255, ZJ
        [ 0x2BED4800, 0x2BED4BFF, "TJ" ],  // 43.237.72.0-43.237.75.255, TJ
        [ 0x2BED4C00, 0x2BED57FF, "ZJ" ],  // 43.237.76.0-43.237.87.255, ZJ
        [ 0x2BED5800, 0x2BED5BFF, "AH" ],  // 43.237.88.0-43.237.91.255, AH
        [ 0x2BED5C00, 0x2BED5FFF, "GD" ],  // 43.237.92.0-43.237.95.255, GD
        [ 0x2BED6000, 0x2BED7BFF, "BJ" ],  // 43.237.96.0-43.237.123.255, BJ
        [ 0x2BED7C00, 0x2BED7FFF, "SC" ],  // 43.237.124.0-43.237.127.255, SC
        [ 0x2BED8000, 0x2BED83FF, "LN" ],  // 43.237.128.0-43.237.131.255, LN
        [ 0x2BED8400, 0x2BED8BFF, "GD" ],  // 43.237.132.0-43.237.139.255, GD
        [ 0x2BED8C00, 0x2BED93FF, "SD" ],  // 43.237.140.0-43.237.147.255, SD
        [ 0x2BED9400, 0x2BED97FF, "FJ" ],  // 43.237.148.0-43.237.151.255, FJ
        [ 0x2BED9800, 0x2BED9BFF, "JL" ],  // 43.237.152.0-43.237.155.255, JL
        [ 0x2BED9C00, 0x2BED9FFF, "GD" ],  // 43.237.156.0-43.237.159.255, GD
        [ 0x2BEDA000, 0x2BEDBFFF, "SH" ],  // 43.237.160.0-43.237.191.255, SH
        [ 0x2BEDC000, 0x2BEDCFFF, "GD" ],  // 43.237.192.0-43.237.207.255, GD
        [ 0x2BEDD000, 0x2BEDD3FF, "SD" ],  // 43.237.208.0-43.237.211.255, SD
        [ 0x2BEDD400, 0x2BEDD7FF, "AH" ],  // 43.237.212.0-43.237.215.255, AH
        [ 0x2BEDD800, 0x2BEDDBFF, "HB" ],  // 43.237.216.0-43.237.219.255, HB
        [ 0x2BEDDC00, 0x2BEDDFFF, "JS" ],  // 43.237.220.0-43.237.223.255, JS
        [ 0x2BEDE000, 0x2BEDE3FF, "FJ" ],  // 43.237.224.0-43.237.227.255, FJ
        [ 0x2BEDE400, 0x2BEDE7FF, "ZJ" ],  // 43.237.228.0-43.237.231.255, ZJ
        [ 0x2BEDE800, 0x2BEDEBFF, "JS" ],  // 43.237.232.0-43.237.235.255, JS
        [ 0x2BEDEC00, 0x2BEDEFFF, "CQ" ],  // 43.237.236.0-43.237.239.255, CQ
        [ 0x2BEDF000, 0x2BEDFBFF, "BJ" ],  // 43.237.240.0-43.237.251.255, BJ
        [ 0x2BEDFC00, 0x2BEDFFFF, "ZJ" ],  // 43.237.252.0-43.237.255.255, ZJ
        [ 0x2BEE0000, 0x2BEE03FF, "GD" ],  // 43.238.0.0-43.238.3.255, GD
        [ 0x2BEE0400, 0x2BEE07FF, "BJ" ],  // 43.238.4.0-43.238.7.255, BJ
        [ 0x2BEE0800, 0x2BEE0BFF, "HI" ],  // 43.238.8.0-43.238.11.255, HI
        [ 0x2BEE0C00, 0x2BEE0FFF, "ZJ" ],  // 43.238.12.0-43.238.15.255, ZJ
        [ 0x2BEE1000, 0x2BEE13FF, "FJ" ],  // 43.238.16.0-43.238.19.255, FJ
        [ 0x2BEE1400, 0x2BEE1BFF, "SH" ],  // 43.238.20.0-43.238.27.255, SH
        [ 0x2BEE1C00, 0x2BEE1FFF, "HB" ],  // 43.238.28.0-43.238.31.255, HB
        [ 0x2BEE2000, 0x2BEE23FF, "HA" ],  // 43.238.32.0-43.238.35.255, HA
        [ 0x2BEE2400, 0x2BEE27FF, "BJ" ],  // 43.238.36.0-43.238.39.255, BJ
        [ 0x2BEE2800, 0x2BEE2BFF, "SD" ],  // 43.238.40.0-43.238.43.255, SD
        [ 0x2BEE2C00, 0x2BEE2FFF, "ZJ" ],  // 43.238.44.0-43.238.47.255, ZJ
        [ 0x2BEE3000, 0x2BEE3FFF, "FJ" ],  // 43.238.48.0-43.238.63.255, FJ
        [ 0x2BEE4000, 0x2BEE43FF, "SH" ],  // 43.238.64.0-43.238.67.255, SH
        [ 0x2BEE4400, 0x2BEE47FF, "GD" ],  // 43.238.68.0-43.238.71.255, GD
        [ 0x2BEE4800, 0x2BEE67FF, "BJ" ],  // 43.238.72.0-43.238.103.255, BJ
        [ 0x2BEE6800, 0x2BEE6BFF, "SD" ],  // 43.238.104.0-43.238.107.255, SD
        [ 0x2BEE6C00, 0x2BEE7BFF, "GD" ],  // 43.238.108.0-43.238.123.255, GD
        [ 0x2BEE7C00, 0x2BEE83FF, "ZJ" ],  // 43.238.124.0-43.238.131.255, ZJ
        [ 0x2BEE8400, 0x2BEE87FF, "JS" ],  // 43.238.132.0-43.238.135.255, JS
        [ 0x2BEE8800, 0x2BEE8BFF, "HA" ],  // 43.238.136.0-43.238.139.255, HA
        [ 0x2BEE8C00, 0x2BEE8FFF, "HL" ],  // 43.238.140.0-43.238.143.255, HL
        [ 0x2BEE9000, 0x2BEE93FF, "HN" ],  // 43.238.144.0-43.238.147.255, HN
        [ 0x2BEE9400, 0x2BEE97FF, "JL" ],  // 43.238.148.0-43.238.151.255, JL
        [ 0x2BEE9800, 0x2BEE9FFF, "JS" ],  // 43.238.152.0-43.238.159.255, JS
        [ 0x2BEEA000, 0x2BEEABFF, "BJ" ],  // 43.238.160.0-43.238.171.255, BJ
        [ 0x2BEEAC00, 0x2BEEB3FF, "JS" ],  // 43.238.172.0-43.238.179.255, JS
        [ 0x2BEEB400, 0x2BEEB7FF, "ZJ" ],  // 43.238.180.0-43.238.183.255, ZJ
        [ 0x2BEEB800, 0x2BEEBBFF, "SD" ],  // 43.238.184.0-43.238.187.255, SD
        [ 0x2BEEBC00, 0x2BEEC3FF, "FJ" ],  // 43.238.188.0-43.238.195.255, FJ
        [ 0x2BEEC400, 0x2BEECBFF, "SD" ],  // 43.238.196.0-43.238.203.255, SD
        [ 0x2BEECC00, 0x2BEEE7FF, "SH" ],  // 43.238.204.0-43.238.231.255, SH
        [ 0x2BEEE800, 0x2BEEF7FF, "GD" ],  // 43.238.232.0-43.238.247.255, GD
        [ 0x2BEEF800, 0x2BEEFBFF, "JS" ],  // 43.238.248.0-43.238.251.255, JS
        [ 0x2BEEFC00, 0x2BEEFFFF, "LN" ],  // 43.238.252.0-43.238.255.255, LN
        [ 0x2BEF0000, 0x2BEF33FF, "BJ" ],  // 43.239.0.0-43.239.51.255, BJ
        [ 0x2BEF7400, 0x2BEF77FF, "ZJ" ],  // 43.239.116.0-43.239.119.255, ZJ
        [ 0x2BEF7800, 0x2BEF7BFF, "HE" ],  // 43.239.120.0-43.239.123.255, HE
        [ 0x2BEFAC00, 0x2BEFAFFF, "HA" ],  // 43.239.172.0-43.239.175.255, HA
        [ 0x2BEFB000, 0x2BEFB3FF, "GD" ],  // 43.239.176.0-43.239.179.255, GD
        [ 0x2BF00000, 0x2BF003FF, "JS" ],  // 43.240.0.0-43.240.3.255, JS
        [ 0x2BF03800, 0x2BF03BFF, "TJ" ],  // 43.240.56.0-43.240.59.255, TJ
        [ 0x2BF03C00, 0x2BF03FFF, "SD" ],  // 43.240.60.0-43.240.63.255, SD
        [ 0x2BF04400, 0x2BF047FF, "BJ" ],  // 43.240.68.0-43.240.71.255, BJ
        [ 0x2BF04800, 0x2BF04BFF, "ZJ" ],  // 43.240.72.0-43.240.75.255, ZJ
        [ 0x2BF04C00, 0x2BF04FFF, "SH" ],  // 43.240.76.0-43.240.79.255, SH
        [ 0x2BF05400, 0x2BF057FF, "GD" ],  // 43.240.84.0-43.240.87.255, GD
        [ 0x2BF07C00, 0x2BF083FF, "SH" ],  // 43.240.124.0-43.240.131.255, SH
        [ 0x2BF08400, 0x2BF087FF, "SC" ],  // 43.240.132.0-43.240.135.255, SC
        [ 0x2BF08800, 0x2BF08BFF, "BJ" ],  // 43.240.136.0-43.240.139.255, BJ
        [ 0x2BF09000, 0x2BF093FF, "GD" ],  // 43.240.144.0-43.240.147.255, GD
        [ 0x2BF09C00, 0x2BF09FFF, "ZJ" ],  // 43.240.156.0-43.240.159.255, ZJ
        [ 0x2BF0A000, 0x2BF0BFFF, "JS" ],  // 43.240.160.0-43.240.191.255, JS
        [ 0x2BF0C000, 0x2BF0C7FF, "SH" ],  // 43.240.192.0-43.240.199.255, SH
        [ 0x2BF0C800, 0x2BF0CBFF, "BJ" ],  // 43.240.200.0-43.240.203.255, BJ
        [ 0x2BF0CC00, 0x2BF0CFFF, "ZJ" ],  // 43.240.204.0-43.240.207.255, ZJ
        [ 0x2BF0D000, 0x2BF0D3FF, "JX" ],  // 43.240.208.0-43.240.211.255, JX
        [ 0x2BF0D400, 0x2BF0D7FF, "GD" ],  // 43.240.212.0-43.240.215.255, GD
        [ 0x2BF0D800, 0x2BF0DFFF, "BJ" ],  // 43.240.216.0-43.240.223.255, BJ
        [ 0x2BF0F000, 0x2BF10FFF, "BJ" ],  // 43.240.240.0-43.241.15.255, BJ
        [ 0x2BF11000, 0x2BF113FF, "ZJ" ],  // 43.241.16.0-43.241.19.255, ZJ
        [ 0x2BF11400, 0x2BF117FF, "BJ" ],  // 43.241.20.0-43.241.23.255, BJ
        [ 0x2BF13000, 0x2BF133FF, "JS" ],  // 43.241.48.0-43.241.51.255, JS
        [ 0x2BF14C00, 0x2BF14FFF, "BJ" ],  // 43.241.76.0-43.241.79.255, BJ
        [ 0x2BF15000, 0x2BF153FF, "GD" ],  // 43.241.80.0-43.241.83.255, GD
        [ 0x2BF15400, 0x2BF157FF, "ZJ" ],  // 43.241.84.0-43.241.87.255, ZJ
        [ 0x2BF15800, 0x2BF15FFF, "BJ" ],  // 43.241.88.0-43.241.95.255, BJ
        [ 0x2BF17000, 0x2BF173FF, "BJ" ],  // 43.241.112.0-43.241.115.255, BJ
        [ 0x2BF1A800, 0x2BF1ABFF, "HI" ],  // 43.241.168.0-43.241.171.255, HI
        [ 0x2BF1AC00, 0x2BF1AFFF, "SH" ],  // 43.241.172.0-43.241.175.255, SH
        [ 0x2BF1B000, 0x2BF1B3FF, "HI" ],  // 43.241.176.0-43.241.179.255, HI
        [ 0x2BF1B400, 0x2BF1B7FF, "TJ" ],  // 43.241.180.0-43.241.183.255, TJ
        [ 0x2BF1B800, 0x2BF1BBFF, "SD" ],  // 43.241.184.0-43.241.187.255, SD
        [ 0x2BF1D000, 0x2BF1F3FF, "BJ" ],  // 43.241.208.0-43.241.243.255, BJ
        [ 0x2BF1F800, 0x2BF1FBFF, "SC" ],  // 43.241.248.0-43.241.251.255, SC
        [ 0x2BF1FD00, 0x2BF1FDFF, "BJ" ],  // 43.241.253.0-43.241.253.255, BJ
        [ 0x2BF1FF00, 0x2BF1FFFF, "BJ" ],  // 43.241.255.0-43.241.255.255, BJ
        [ 0x2BF20800, 0x2BF21FFF, "BJ" ],  // 43.242.8.0-43.242.31.255, BJ
        [ 0x2BF23000, 0x2BF233FF, "BJ" ],  // 43.242.48.0-43.242.51.255, BJ
        [ 0x2BF23500, 0x2BF236FF, "BJ" ],  // 43.242.53.0-43.242.54.255, BJ
        [ 0x2BF23800, 0x2BF23BFF, "TJ" ],  // 43.242.56.0-43.242.59.255, TJ
        [ 0x2BF23C00, 0x2BF243FF, "BJ" ],  // 43.242.60.0-43.242.67.255, BJ
        [ 0x2BF24800, 0x2BF24BFF, "FJ" ],  // 43.242.72.0-43.242.75.255, FJ
        [ 0x2BF24C00, 0x2BF24FFF, "BJ" ],  // 43.242.76.0-43.242.79.255, BJ
        [ 0x2BF25000, 0x2BF253FF, "ZJ" ],  // 43.242.80.0-43.242.83.255, ZJ
        [ 0x2BF25400, 0x2BF25BFF, "BJ" ],  // 43.242.84.0-43.242.91.255, BJ
        [ 0x2BF25C00, 0x2BF25FFF, "SH" ],  // 43.242.92.0-43.242.95.255, SH
        [ 0x2BF26000, 0x2BF263FF, "BJ" ],  // 43.242.96.0-43.242.99.255, BJ
        [ 0x2BF29000, 0x2BF297FF, "HN" ],  // 43.242.144.0-43.242.151.255, HN
        [ 0x2BF29800, 0x2BF29BFF, "XJ" ],  // 43.242.152.0-43.242.155.255, XJ
        [ 0x2BF29C00, 0x2BF29FFF, "HN" ],  // 43.242.156.0-43.242.159.255, HN
        [ 0x2BF2A000, 0x2BF2A3FF, "GD" ],  // 43.242.160.0-43.242.163.255, GD
        [ 0x2BF2A400, 0x2BF2A7FF, "XZ" ],  // 43.242.164.0-43.242.167.255, XZ
        [ 0x2BF2A800, 0x2BF2ABFF, "BJ" ],  // 43.242.168.0-43.242.171.255, BJ
        [ 0x2BF2B400, 0x2BF2B7FF, "QH" ],  // 43.242.180.0-43.242.183.255, QH
        [ 0x2BF2BC00, 0x2BF2BFFF, "GD" ],  // 43.242.188.0-43.242.191.255, GD
        [ 0x2BF2C000, 0x2BF2C3FF, "BJ" ],  // 43.242.192.0-43.242.195.255, BJ
        [ 0x2BF2C400, 0x2BF2C7FF, "JS" ],  // 43.242.196.0-43.242.199.255, JS
        [ 0x2BF2CC00, 0x2BF2CFFF, "ZJ" ],  // 43.242.204.0-43.242.207.255, ZJ
        [ 0x2BF2D800, 0x2BF2DFFF, "BJ" ],  // 43.242.216.0-43.242.223.255, BJ
        [ 0x2BF2FC00, 0x2BF2FFFF, "TJ" ],  // 43.242.252.0-43.242.255.255, TJ
        [ 0x2BF30400, 0x2BF307FF, "GS" ],  // 43.243.4.0-43.243.7.255, GS
        [ 0x2BF30800, 0x2BF30BFF, "HA" ],  // 43.243.8.0-43.243.11.255, HA
        [ 0x2BF30C00, 0x2BF30FFF, "BJ" ],  // 43.243.12.0-43.243.15.255, BJ
        [ 0x2BF31000, 0x2BF313FF, "SC" ],  // 43.243.16.0-43.243.19.255, SC
        [ 0x2BF35800, 0x2BF35BFF, "HE" ],  // 43.243.88.0-43.243.91.255, HE
        [ 0x2BF38000, 0x2BF383FF, "FJ" ],  // 43.243.128.0-43.243.131.255, FJ
        [ 0x2BF38800, 0x2BF38BFF, "BJ" ],  // 43.243.136.0-43.243.139.255, BJ
        [ 0x2BF39000, 0x2BF393FF, "HE" ],  // 43.243.144.0-43.243.147.255, HE
        [ 0x2BF39400, 0x2BF397FF, "SH" ],  // 43.243.148.0-43.243.151.255, SH
        [ 0x2BF39C00, 0x2BF39FFF, "GZ" ],  // 43.243.156.0-43.243.159.255, GZ
        [ 0x2BF3B400, 0x2BF3B7FF, "CQ" ],  // 43.243.180.0-43.243.183.255, CQ
        [ 0x2BF3E400, 0x2BF3E7FF, "NM" ],  // 43.243.228.0-43.243.231.255, NM
        [ 0x2BF3E800, 0x2BF3EBFF, "BJ" ],  // 43.243.232.0-43.243.235.255, BJ
        [ 0x2BF3F400, 0x2BF3F7FF, "GD" ],  // 43.243.244.0-43.243.247.255, GD
        [ 0x2BF60000, 0x2BF603FF, "BJ" ],  // 43.246.0.0-43.246.3.255, BJ
        [ 0x2BF60400, 0x2BF607FF, "SC" ],  // 43.246.4.0-43.246.7.255, SC
        [ 0x2BF60800, 0x2BF60BFF, "LN" ],  // 43.246.8.0-43.246.11.255, LN
        [ 0x2BF60C00, 0x2BF613FF, "GD" ],  // 43.246.12.0-43.246.19.255, GD
        [ 0x2BF61400, 0x2BF617FF, "HL" ],  // 43.246.20.0-43.246.23.255, HL
        [ 0x2BF61800, 0x2BF61BFF, "ZJ" ],  // 43.246.24.0-43.246.27.255, ZJ
        [ 0x2BF61C00, 0x2BF61FFF, "AH" ],  // 43.246.28.0-43.246.31.255, AH
        [ 0x2BF62000, 0x2BF623FF, "SD" ],  // 43.246.32.0-43.246.35.255, SD
        [ 0x2BF62400, 0x2BF627FF, "ZJ" ],  // 43.246.36.0-43.246.39.255, ZJ
        [ 0x2BF62800, 0x2BF62BFF, "SD" ],  // 43.246.40.0-43.246.43.255, SD
        [ 0x2BF62C00, 0x2BF62FFF, "FJ" ],  // 43.246.44.0-43.246.47.255, FJ
        [ 0x2BF63000, 0x2BF633FF, "SH" ],  // 43.246.48.0-43.246.51.255, SH
        [ 0x2BF63400, 0x2BF637FF, "GD" ],  // 43.246.52.0-43.246.55.255, GD
        [ 0x2BF63800, 0x2BF63BFF, "LN" ],  // 43.246.56.0-43.246.59.255, LN
        [ 0x2BF63C00, 0x2BF63FFF, "HE" ],  // 43.246.60.0-43.246.63.255, HE
        [ 0x2BF64000, 0x2BF643FF, "TJ" ],  // 43.246.64.0-43.246.67.255, TJ
        [ 0x2BF64400, 0x2BF647FF, "JS" ],  // 43.246.68.0-43.246.71.255, JS
        [ 0x2BF64800, 0x2BF64BFF, "HB" ],  // 43.246.72.0-43.246.75.255, HB
        [ 0x2BF64C00, 0x2BF64FFF, "SN" ],  // 43.246.76.0-43.246.79.255, SN
        [ 0x2BF65000, 0x2BF653FF, "SD" ],  // 43.246.80.0-43.246.83.255, SD
        [ 0x2BF65400, 0x2BF657FF, "HN" ],  // 43.246.84.0-43.246.87.255, HN
        [ 0x2BF65800, 0x2BF65BFF, "HA" ],  // 43.246.88.0-43.246.91.255, HA
        [ 0x2BF65C00, 0x2BF65FFF, "CQ" ],  // 43.246.92.0-43.246.95.255, CQ
        [ 0x2BF66000, 0x2BF663FF, "JS" ],  // 43.246.96.0-43.246.99.255, JS
        [ 0x2BF67000, 0x2BF670FF, "TJ" ],  // 43.246.112.0-43.246.112.255, TJ
        [ 0x2BF67100, 0x2BF671FF, "GD" ],  // 43.246.113.0-43.246.113.255, GD
        [ 0x2BF6E400, 0x2BF6E5FF, "JS" ],  // 43.246.228.0-43.246.229.255, JS
        [ 0x2BF6E600, 0x2BF6E7FF, "BJ" ],  // 43.246.230.0-43.246.231.255, BJ
        [ 0x2BF70400, 0x2BF707FF, "TJ" ],  // 43.247.4.0-43.247.7.255, TJ
        [ 0x2BF70800, 0x2BF70BFF, "BJ" ],  // 43.247.8.0-43.247.11.255, BJ
        [ 0x2BF72C00, 0x2BF733FF, "GD" ],  // 43.247.44.0-43.247.51.255, GD
        [ 0x2BF74400, 0x2BF747FF, "GD" ],  // 43.247.68.0-43.247.71.255, GD
        [ 0x2BF74C00, 0x2BF74FFF, "GD" ],  // 43.247.76.0-43.247.79.255, GD
        [ 0x2BF75400, 0x2BF757FF, "SX" ],  // 43.247.84.0-43.247.87.255, SX
        [ 0x2BF75800, 0x2BF75FFF, "JS" ],  // 43.247.88.0-43.247.95.255, JS
        [ 0x2BF76000, 0x2BF763FF, "GD" ],  // 43.247.96.0-43.247.99.255, GD
        [ 0x2BF76400, 0x2BF767FF, "SH" ],  // 43.247.100.0-43.247.103.255, SH
        [ 0x2BF76C00, 0x2BF76FFF, "BJ" ],  // 43.247.108.0-43.247.111.255, BJ
        [ 0x2BF77000, 0x2BF773FF, "LN" ],  // 43.247.112.0-43.247.115.255, LN
        [ 0x2BF79400, 0x2BF797FF, "TJ" ],  // 43.247.148.0-43.247.151.255, TJ
        [ 0x2BF79800, 0x2BF79BFF, "BJ" ],  // 43.247.152.0-43.247.155.255, BJ
        [ 0x2BF7B000, 0x2BF7BFFF, "BJ" ],  // 43.247.176.0-43.247.191.255, BJ
        [ 0x2BF7C400, 0x2BF7C7FF, "GD" ],  // 43.247.196.0-43.247.199.255, GD
        [ 0x2BF7C800, 0x2BF7CBFF, "SX" ],  // 43.247.200.0-43.247.203.255, SX
        [ 0x2BF7CC00, 0x2BF7CFFF, "SC" ],  // 43.247.204.0-43.247.207.255, SC
        [ 0x2BF7D000, 0x2BF7D3FF, "GZ" ],  // 43.247.208.0-43.247.211.255, GZ
        [ 0x2BF7D400, 0x2BF7DDFF, "BJ" ],  // 43.247.212.0-43.247.221.255, BJ
        [ 0x2BF7DE00, 0x2BF7DEFF, "CQ" ],  // 43.247.222.0-43.247.222.255, CQ
        [ 0x2BF7DF00, 0x2BF7DFFF, "SX" ],  // 43.247.223.0-43.247.223.255, SX
        [ 0x2BF7E000, 0x2BF7E3FF, "JS" ],  // 43.247.224.0-43.247.227.255, JS
        [ 0x2BF7E400, 0x2BF7E7FF, "GX" ],  // 43.247.228.0-43.247.231.255, GX
        [ 0x2BF7E800, 0x2BF7EBFF, "ZJ" ],  // 43.247.232.0-43.247.235.255, ZJ
        [ 0x2BF7EC00, 0x2BF7F3FF, "BJ" ],  // 43.247.236.0-43.247.243.255, BJ
        [ 0x2BF7F400, 0x2BF7F7FF, "ZJ" ],  // 43.247.244.0-43.247.247.255, ZJ
        [ 0x2BF7F800, 0x2BF803FF, "BJ" ],  // 43.247.248.0-43.248.3.255, BJ
        [ 0x2BF80400, 0x2BF807FF, "SN" ],  // 43.248.4.0-43.248.7.255, SN
        [ 0x2BF81400, 0x2BF817FF, "AH" ],  // 43.248.20.0-43.248.23.255, AH
        [ 0x2BF81C00, 0x2BF81FFF, "BJ" ],  // 43.248.28.0-43.248.31.255, BJ
        [ 0x2BF83000, 0x2BF833FF, "BJ" ],  // 43.248.48.0-43.248.51.255, BJ
        [ 0x2BF84C00, 0x2BF86BFF, "JS" ],  // 43.248.76.0-43.248.107.255, JS
        [ 0x2BF86C00, 0x2BF86FFF, "YN" ],  // 43.248.108.0-43.248.111.255, YN
        [ 0x2BF87000, 0x2BF873FF, "BJ" ],  // 43.248.112.0-43.248.115.255, BJ
        [ 0x2BF87400, 0x2BF897FF, "JS" ],  // 43.248.116.0-43.248.151.255, JS
        [ 0x2BF8B000, 0x2BF8D3FF, "JS" ],  // 43.248.176.0-43.248.211.255, JS
        [ 0x2BF8E400, 0x2BF8E7FF, "SH" ],  // 43.248.228.0-43.248.231.255, SH
        [ 0x2BF8E800, 0x2BF8EBFF, "BJ" ],  // 43.248.232.0-43.248.235.255, BJ
        [ 0x2BF8F400, 0x2BF8F7FF, "ZJ" ],  // 43.248.244.0-43.248.247.255, ZJ
        [ 0x2BF90400, 0x2BF907FF, "HE" ],  // 43.249.4.0-43.249.7.255, HE
        [ 0x2BF97800, 0x2BF97BFF, "JS" ],  // 43.249.120.0-43.249.123.255, JS
        [ 0x2BF98400, 0x2BF987FF, "SH" ],  // 43.249.132.0-43.249.135.255, SH
        [ 0x2BF98800, 0x2BF98BFF, "TJ" ],  // 43.249.136.0-43.249.139.255, TJ
        [ 0x2BF99000, 0x2BF997FF, "JS" ],  // 43.249.144.0-43.249.151.255, JS
        [ 0x2BF99800, 0x2BF99BFF, "GD" ],  // 43.249.152.0-43.249.155.255, GD
        [ 0x2BF99C00, 0x2BF99FFF, "SD" ],  // 43.249.156.0-43.249.159.255, SD
        [ 0x2BF9A000, 0x2BF9A7FF, "GD" ],  // 43.249.160.0-43.249.167.255, GD
        [ 0x2BF9A800, 0x2BF9ABFF, "BJ" ],  // 43.249.168.0-43.249.171.255, BJ
        [ 0x2BF9C000, 0x2BF9C3FF, "SD" ],  // 43.249.192.0-43.249.195.255, SD
        [ 0x2BF9EC00, 0x2BF9EFFF, "SX" ],  // 43.249.236.0-43.249.239.255, SX
        [ 0x2BFA0400, 0x2BFA07FF, "JL" ],  // 43.250.4.0-43.250.7.255, JL
        [ 0x2BFA0C00, 0x2BFA0FFF, "BJ" ],  // 43.250.12.0-43.250.15.255, BJ
        [ 0x2BFA1000, 0x2BFA17FF, "HB" ],  // 43.250.16.0-43.250.23.255, HB
        [ 0x2BFA1C00, 0x2BFA1FFF, "SC" ],  // 43.250.28.0-43.250.31.255, SC
        [ 0x2BFA2000, 0x2BFA23FF, "HE" ],  // 43.250.32.0-43.250.35.255, HE
        [ 0x2BFA2400, 0x2BFA27FF, "BJ" ],  // 43.250.36.0-43.250.39.255, BJ
        [ 0x2BFA6000, 0x2BFA63FF, "LN" ],  // 43.250.96.0-43.250.99.255, LN
        [ 0x2BFA6400, 0x2BFA67FF, "HB" ],  // 43.250.100.0-43.250.103.255, HB
        [ 0x2BFA6C00, 0x2BFA6FFF, "HB" ],  // 43.250.108.0-43.250.111.255, HB
        [ 0x2BFA7000, 0x2BFA73FF, "SD" ],  // 43.250.112.0-43.250.115.255, SD
        [ 0x2BFA7400, 0x2BFA77FF, "GD" ],  // 43.250.116.0-43.250.119.255, GD
        [ 0x2BFA8000, 0x2BFA83FF, "HA" ],  // 43.250.128.0-43.250.131.255, HA
        [ 0x2BFA9000, 0x2BFA93FF, "SH" ],  // 43.250.144.0-43.250.147.255, SH
        [ 0x2BFA9400, 0x2BFA97FF, "JS" ],  // 43.250.148.0-43.250.151.255, JS
        [ 0x2BFAA000, 0x2BFAA3FF, "LN" ],  // 43.250.160.0-43.250.163.255, LN
        [ 0x2BFAA800, 0x2BFAABFF, "JS" ],  // 43.250.168.0-43.250.171.255, JS
        [ 0x2BFAB000, 0x2BFAB3FF, "BJ" ],  // 43.250.176.0-43.250.179.255, BJ
        [ 0x2BFAB400, 0x2BFAB5FF, "HA" ],  // 43.250.180.0-43.250.181.255, HA
        [ 0x2BFAC800, 0x2BFACBFF, "HN" ],  // 43.250.200.0-43.250.203.255, HN
        [ 0x2BFAD400, 0x2BFAD7FF, "GD" ],  // 43.250.212.0-43.250.215.255, GD
        [ 0x2BFAD800, 0x2BFADBFF, "GZ" ],  // 43.250.216.0-43.250.219.255, GZ
        [ 0x2BFADC00, 0x2BFADFFF, "BJ" ],  // 43.250.220.0-43.250.223.255, BJ
        [ 0x2BFAEC00, 0x2BFAEFFF, "BJ" ],  // 43.250.236.0-43.250.239.255, BJ
        [ 0x2BFAF400, 0x2BFAF7FF, "GX" ],  // 43.250.244.0-43.250.247.255, GX
        [ 0x2BFB0400, 0x2BFB07FF, "HI" ],  // 43.251.4.0-43.251.7.255, HI
        [ 0x2BFB0800, 0x2BFB0BFF, "GD" ],  // 43.251.8.0-43.251.11.255, GD
        [ 0x2BFB2400, 0x2BFB27FF, "NX" ],  // 43.251.36.0-43.251.39.255, NX
        [ 0x2BFB6400, 0x2BFB67FF, "BJ" ],  // 43.251.100.0-43.251.103.255, BJ
        [ 0x2BFBC000, 0x2BFBC3FF, "LN" ],  // 43.251.192.0-43.251.195.255, LN
        [ 0x2BFBE800, 0x2BFBEBFF, "AH" ],  // 43.251.232.0-43.251.235.255, AH
        [ 0x2BFBEF00, 0x2BFBEFFF, "JS" ],  // 43.251.239.0-43.251.239.255, JS
        [ 0x2BFBF400, 0x2BFBF4FF, "NM" ],  // 43.251.244.0-43.251.244.255, NM
        [ 0x2BFBF500, 0x2BFBF7FF, "HL" ],  // 43.251.245.0-43.251.247.255, HL
        [ 0x2BFC3000, 0x2BFC30FF, "BJ" ],  // 43.252.48.0-43.252.48.255, BJ
        [ 0x2BFC3100, 0x2BFC31FF, "SH" ],  // 43.252.49.0-43.252.49.255, SH
        [ 0x2BFC3200, 0x2BFC32FF, "GD" ],  // 43.252.50.0-43.252.50.255, GD
        [ 0x2BFC3300, 0x2BFC33FF, "HB" ],  // 43.252.51.0-43.252.51.255, HB
        [ 0x2BFC3800, 0x2BFC3BFF, "LN" ],  // 43.252.56.0-43.252.59.255, LN
        [ 0x2BFCE000, 0x2BFCE3FF, "BJ" ],  // 43.252.224.0-43.252.227.255, BJ
        [ 0x2BFE0000, 0x2BFE07FF, "BJ" ],  // 43.254.0.0-43.254.7.255, BJ
        [ 0x2BFE0800, 0x2BFE0BFF, "NM" ],  // 43.254.8.0-43.254.11.255, NM
        [ 0x2BFE1800, 0x2BFE1BFF, "BJ" ],  // 43.254.24.0-43.254.27.255, BJ
        [ 0x2BFE2400, 0x2BFE24FF, "BJ" ],  // 43.254.36.0-43.254.36.255, BJ
        [ 0x2BFE2500, 0x2BFE27FF, "LN" ],  // 43.254.37.0-43.254.39.255, LN
        [ 0x2BFE2C00, 0x2BFE2FFF, "SH" ],  // 43.254.44.0-43.254.47.255, SH
        [ 0x2BFE3400, 0x2BFE37FF, "JS" ],  // 43.254.52.0-43.254.55.255, JS
        [ 0x2BFE4000, 0x2BFE43FF, "BJ" ],  // 43.254.64.0-43.254.67.255, BJ
        [ 0x2BFE4800, 0x2BFE4BFF, "BJ" ],  // 43.254.72.0-43.254.75.255, BJ
        [ 0x2BFE5400, 0x2BFE5FFF, "BJ" ],  // 43.254.84.0-43.254.95.255, BJ
        [ 0x2BFE6400, 0x2BFE67FF, "GZ" ],  // 43.254.100.0-43.254.103.255, GZ
        [ 0x2BFE6800, 0x2BFE68FF, "SH" ],  // 43.254.104.0-43.254.104.255, SH
        [ 0x2BFE6900, 0x2BFE69FF, "GD" ],  // 43.254.105.0-43.254.105.255, GD
        [ 0x2BFE6A00, 0x2BFE6BFF, "SH" ],  // 43.254.106.0-43.254.107.255, SH
        [ 0x2BFE7000, 0x2BFE77FF, "BJ" ],  // 43.254.112.0-43.254.119.255, BJ
        [ 0x2BFE8000, 0x2BFE83FF, "GD" ],  // 43.254.128.0-43.254.131.255, GD
        [ 0x2BFE8800, 0x2BFE8BFF, "TJ" ],  // 43.254.136.0-43.254.139.255, TJ
        [ 0x2BFE8C00, 0x2BFE9BFF, "SH" ],  // 43.254.140.0-43.254.155.255, SH
        [ 0x2BFE9C00, 0x2BFE9FFF, "GD" ],  // 43.254.156.0-43.254.159.255, GD
        [ 0x2BFEA800, 0x2BFEABFF, "NM" ],  // 43.254.168.0-43.254.171.255, NM
        [ 0x2BFEAC00, 0x2BFEAFFF, "BJ" ],  // 43.254.172.0-43.254.175.255, BJ
        [ 0x2BFEB400, 0x2BFEB7FF, "BJ" ],  // 43.254.180.0-43.254.183.255, BJ
        [ 0x2BFEB800, 0x2BFEBBFF, "HE" ],  // 43.254.184.0-43.254.187.255, HE
        [ 0x2BFEBC00, 0x2BFEBFFF, "BJ" ],  // 43.254.188.0-43.254.191.255, BJ
        [ 0x2BFEC000, 0x2BFEC3FF, "JS" ],  // 43.254.192.0-43.254.195.255, JS
        [ 0x2BFEC400, 0x2BFEC7FF, "SH" ],  // 43.254.196.0-43.254.199.255, SH
        [ 0x2BFEC800, 0x2BFECBFF, "BJ" ],  // 43.254.200.0-43.254.203.255, BJ
        [ 0x2BFED000, 0x2BFED3FF, "BJ" ],  // 43.254.208.0-43.254.211.255, BJ
        [ 0x2BFEDC00, 0x2BFEE3FF, "SH" ],  // 43.254.220.0-43.254.227.255, SH
        [ 0x2BFEE400, 0x2BFEF3FF, "BJ" ],  // 43.254.228.0-43.254.243.255, BJ
        [ 0x2BFEF800, 0x2BFEFBFF, "BJ" ],  // 43.254.248.0-43.254.251.255, BJ
        [ 0x2BFEFC00, 0x2BFEFFFF, "YN" ],  // 43.254.252.0-43.254.255.255, YN
        [ 0x2BFF0000, 0x2BFF02FF, "GD" ],  // 43.255.0.0-43.255.2.255, GD
        [ 0x2BFF0300, 0x2BFF03FF, "BJ" ],  // 43.255.3.0-43.255.3.255, BJ
        [ 0x2BFF0400, 0x2BFF07FF, "HA" ],  // 43.255.4.0-43.255.7.255, HA
        [ 0x2BFF0800, 0x2BFF0BFF, "BJ" ],  // 43.255.8.0-43.255.11.255, BJ
        [ 0x2BFF1000, 0x2BFF13FF, "SH" ],  // 43.255.16.0-43.255.19.255, SH
        [ 0x2BFF3000, 0x2BFF33FF, "GD" ],  // 43.255.48.0-43.255.51.255, GD
        [ 0x2BFF4000, 0x2BFF43FF, "SH" ],  // 43.255.64.0-43.255.67.255, SH
        [ 0x2BFF4400, 0x2BFF47FF, "GX" ],  // 43.255.68.0-43.255.71.255, GX
        [ 0x2BFF4800, 0x2BFF4BFF, "JS" ],  // 43.255.72.0-43.255.75.255, JS
        [ 0x2BFF4C00, 0x2BFF4FFF, "SH" ],  // 43.255.76.0-43.255.79.255, SH
        [ 0x2BFF5400, 0x2BFF57FF, "JS" ],  // 43.255.84.0-43.255.87.255, JS
        [ 0x2BFF6000, 0x2BFF63FF, "BJ" ],  // 43.255.96.0-43.255.99.255, BJ
        [ 0x2BFF9000, 0x2BFF93FF, "BJ" ],  // 43.255.144.0-43.255.147.255, BJ
        [ 0x2BFFB000, 0x2BFFB3FF, "BJ" ],  // 43.255.176.0-43.255.179.255, BJ
        [ 0x2BFFB800, 0x2BFFBBFF, "ZJ" ],  // 43.255.184.0-43.255.187.255, ZJ
        [ 0x2BFFC000, 0x2BFFC3FF, "GZ" ],  // 43.255.192.0-43.255.195.255, GZ
        [ 0x2BFFC800, 0x2BFFCBFF, "BJ" ],  // 43.255.200.0-43.255.203.255, BJ
        [ 0x2BFFCC00, 0x2BFFCFFF, "GD" ],  // 43.255.204.0-43.255.207.255, GD
        [ 0x2BFFD000, 0x2BFFD3FF, "SH" ],  // 43.255.208.0-43.255.211.255, SH
        [ 0x2BFFD400, 0x2BFFD7FF, "GD" ],  // 43.255.212.0-43.255.215.255, GD
        [ 0x2BFFE000, 0x2BFFE3FF, "BJ" ],  // 43.255.224.0-43.255.227.255, BJ
        [ 0x2BFFE400, 0x2BFFEBFF, "GD" ],  // 43.255.228.0-43.255.235.255, GD
        [ 0x2BFFF400, 0x2BFFF7FF, "SD" ],  // 43.255.244.0-43.255.247.255, SD
        [ 0x2C1F1C00, 0x2C1F1CFF, "SH" ],  // 44.31.28.0-44.31.28.255, SH
        [ 0x2C1F2A00, 0x2C1F2AFF, "SH" ],  // 44.31.42.0-44.31.42.255, SH
        [ 0x2C1F2B00, 0x2C1F2BFF, "SN" ],  // 44.31.43.0-44.31.43.255, SN
        [ 0x2C1F5100, 0x2C1F51FF, "SH" ],  // 44.31.81.0-44.31.81.255, SH
        [ 0x2C1FDC00, 0x2C1FDCFF, "SH" ],  // 44.31.220.0-44.31.220.255, SH
        [ 0x2C1FEA00, 0x2C1FEAFF, "SH" ],  // 44.31.234.0-44.31.234.255, SH
        [ 0x2C204400, 0x2C2044FF, "SH" ],  // 44.32.68.0-44.32.68.255, SH
        [ 0x2C209500, 0x2C2095FF, "SD" ],  // 44.32.149.0-44.32.149.255, SD
        [ 0x2C209800, 0x2C2098FF, "LN" ],  // 44.32.152.0-44.32.152.255, LN
        [ 0x2C209A00, 0x2C209AFF, "GD" ],  // 44.32.154.0-44.32.154.255, GD
        [ 0x2C209D00, 0x2C209DFF, "ZJ" ],  // 44.32.157.0-44.32.157.255, ZJ
        [ 0x2C20A100, 0x2C20A1FF, "SH" ],  // 44.32.161.0-44.32.161.255, SH
        [ 0x2D28C000, 0x2D28D7FF, "SC" ],  // 45.40.192.0-45.40.215.255, SC
        [ 0x2D28D800, 0x2D28EFFF, "GD" ],  // 45.40.216.0-45.40.239.255, GD
        [ 0x2D28F000, 0x2D28FFFF, "SC" ],  // 45.40.240.0-45.40.255.255, SC
        [ 0x2D411000, 0x2D4113FF, "BJ" ],  // 45.65.16.0-45.65.19.255, BJ
        [ 0x2D411400, 0x2D411FFF, "GD" ],  // 45.65.20.0-45.65.31.255, GD
        [ 0x2D708400, 0x2D7087FF, "BJ" ],  // 45.112.132.0-45.112.135.255, BJ
        [ 0x2D70BC00, 0x2D70BFFF, "BJ" ],  // 45.112.188.0-45.112.191.255, BJ
        [ 0x2D70D000, 0x2D70D7FF, "ZJ" ],  // 45.112.208.0-45.112.215.255, ZJ
        [ 0x2D70D800, 0x2D70DBFF, "BJ" ],  // 45.112.216.0-45.112.219.255, BJ
        [ 0x2D70DC00, 0x2D70DCFF, "GD" ],  // 45.112.220.0-45.112.220.255, GD
        [ 0x2D70DD00, 0x2D70DEFF, "BJ" ],  // 45.112.221.0-45.112.222.255, BJ
        [ 0x2D70DF00, 0x2D70DFFF, "ZJ" ],  // 45.112.223.0-45.112.223.255, ZJ
        [ 0x2D70E400, 0x2D70EFFF, "TJ" ],  // 45.112.228.0-45.112.239.255, TJ
        [ 0x2D710C00, 0x2D710FFF, "GD" ],  // 45.113.12.0-45.113.15.255, GD
        [ 0x2D711000, 0x2D7117FF, "HE" ],  // 45.113.16.0-45.113.23.255, HE
        [ 0x2D711800, 0x2D711FFF, "JS" ],  // 45.113.24.0-45.113.31.255, JS
        [ 0x2D712800, 0x2D712BFF, "ZJ" ],  // 45.113.40.0-45.113.43.255, ZJ
        [ 0x2D713400, 0x2D7137FF, "HB" ],  // 45.113.52.0-45.113.55.255, HB
        [ 0x2D713800, 0x2D713BFF, "SH" ],  // 45.113.56.0-45.113.59.255, SH
        [ 0x2D714800, 0x2D714BFF, "LN" ],  // 45.113.72.0-45.113.75.255, LN
        [ 0x2D719000, 0x2D7197FF, "BJ" ],  // 45.113.144.0-45.113.151.255, BJ
        [ 0x2D71A800, 0x2D71ABFF, "BJ" ],  // 45.113.168.0-45.113.171.255, BJ
        [ 0x2D71B000, 0x2D71B3FF, "SH" ],  // 45.113.176.0-45.113.179.255, SH
        [ 0x2D71B800, 0x2D71BBFF, "HB" ],  // 45.113.184.0-45.113.187.255, HB
        [ 0x2D71C001, 0x2D71C1FF, "BJ" ],  // 45.113.192.1-45.113.193.255, BJ
        [ 0x2D71C800, 0x2D71CBFF, "JS" ],  // 45.113.200.0-45.113.203.255, JS
        [ 0x2D71CC00, 0x2D71D3FF, "FJ" ],  // 45.113.204.0-45.113.211.255, FJ
        [ 0x2D71D400, 0x2D71D7FF, "BJ" ],  // 45.113.212.0-45.113.215.255, BJ
        [ 0x2D71D800, 0x2D71DBFF, "FJ" ],  // 45.113.216.0-45.113.219.255, FJ
        [ 0x2D71DC00, 0x2D71DFFF, "SD" ],  // 45.113.220.0-45.113.223.255, SD
        [ 0x2D71F000, 0x2D71F3FF, "JS" ],  // 45.113.240.0-45.113.243.255, JS
        [ 0x2D71FC00, 0x2D71FFFF, "HN" ],  // 45.113.252.0-45.113.255.255, HN
        [ 0x2D720000, 0x2D7203FF, "BJ" ],  // 45.114.0.0-45.114.3.255, BJ
        [ 0x2D722000, 0x2D7223FF, "BJ" ],  // 45.114.32.0-45.114.35.255, BJ
        [ 0x2D722800, 0x2D722BFF, "GD" ],  // 45.114.40.0-45.114.43.255, GD
        [ 0x2D723400, 0x2D7237FF, "BJ" ],  // 45.114.52.0-45.114.55.255, BJ
        [ 0x2D726000, 0x2D7263FF, "BJ" ],  // 45.114.96.0-45.114.99.255, BJ
        [ 0x2D728800, 0x2D728BFF, "GD" ],  // 45.114.136.0-45.114.139.255, GD
        [ 0x2D72C400, 0x2D72CBFF, "BJ" ],  // 45.114.196.0-45.114.203.255, BJ
        [ 0x2D72E400, 0x2D72E7FF, "BJ" ],  // 45.114.228.0-45.114.231.255, BJ
        [ 0x2D72FC00, 0x2D72FFFF, "SH" ],  // 45.114.252.0-45.114.255.255, SH
        [ 0x2D731A00, 0x2D731BFF, "BJ" ],  // 45.115.26.0-45.115.27.255, BJ
        [ 0x2D732C00, 0x2D732FFF, "SH" ],  // 45.115.44.0-45.115.47.255, SH
        [ 0x2D736400, 0x2D7367FF, "BJ" ],  // 45.115.100.0-45.115.103.255, BJ
        [ 0x2D737800, 0x2D737BFF, "BJ" ],  // 45.115.120.0-45.115.123.255, BJ
        [ 0x2D738400, 0x2D7387FF, "BJ" ],  // 45.115.132.0-45.115.135.255, BJ
        [ 0x2D739000, 0x2D7393FF, "SH" ],  // 45.115.144.0-45.115.147.255, SH
        [ 0x2D739C00, 0x2D739FFF, "SD" ],  // 45.115.156.0-45.115.159.255, SD
        [ 0x2D73A400, 0x2D73A7FF, "JS" ],  // 45.115.164.0-45.115.167.255, JS
        [ 0x2D73C800, 0x2D73CBFF, "TJ" ],  // 45.115.200.0-45.115.203.255, TJ
        [ 0x2D73D400, 0x2D73D7FF, "BJ" ],  // 45.115.212.0-45.115.215.255, BJ
        [ 0x2D73E400, 0x2D73E7FF, "SH" ],  // 45.115.228.0-45.115.231.255, SH
        [ 0x2D73EC00, 0x2D73EFFF, "JS" ],  // 45.115.236.0-45.115.239.255, JS
        [ 0x2D73F400, 0x2D73F7FF, "YN" ],  // 45.115.244.0-45.115.247.255, YN
        [ 0x2D73F800, 0x2D73F8FF, "SN" ],  // 45.115.248.0-45.115.248.255, SN
        [ 0x2D73F900, 0x2D73FBFF, "BJ" ],  // 45.115.249.0-45.115.251.255, BJ
        [ 0x2D741000, 0x2D7413FF, "JS" ],  // 45.116.16.0-45.116.19.255, JS
        [ 0x2D741800, 0x2D741BFF, "JS" ],  // 45.116.24.0-45.116.27.255, JS
        [ 0x2D742000, 0x2D7423FF, "GD" ],  // 45.116.32.0-45.116.35.255, GD
        [ 0x2D742400, 0x2D7427FF, "HN" ],  // 45.116.36.0-45.116.39.255, HN
        [ 0x2D743400, 0x2D7437FF, "SH" ],  // 45.116.52.0-45.116.55.255, SH
        [ 0x2D746000, 0x2D7463FF, "GD" ],  // 45.116.96.0-45.116.99.255, GD
        [ 0x2D746400, 0x2D7467FF, "JS" ],  // 45.116.100.0-45.116.103.255, JS
        [ 0x2D748C00, 0x2D748FFF, "GD" ],  // 45.116.140.0-45.116.143.255, GD
        [ 0x2D749800, 0x2D749BFF, "NM" ],  // 45.116.152.0-45.116.155.255, NM
        [ 0x2D74D000, 0x2D74D3FF, "JL" ],  // 45.116.208.0-45.116.211.255, JL
        [ 0x2D750800, 0x2D750BFF, "JS" ],  // 45.117.8.0-45.117.11.255, JS
        [ 0x2D751400, 0x2D7517FF, "LN" ],  // 45.117.20.0-45.117.23.255, LN
        [ 0x2D754400, 0x2D7547FF, "LN" ],  // 45.117.68.0-45.117.71.255, LN
        [ 0x2D757C00, 0x2D757FFF, "NM" ],  // 45.117.124.0-45.117.127.255, NM
        [ 0x2D75FC00, 0x2D75FFFF, "JX" ],  // 45.117.252.0-45.117.255.255, JX
        [ 0x2D773C00, 0x2D773FFF, "FJ" ],  // 45.119.60.0-45.119.63.255, FJ
        [ 0x2D774000, 0x2D7743FF, "JS" ],  // 45.119.64.0-45.119.67.255, JS
        [ 0x2D774400, 0x2D7747FF, "HE" ],  // 45.119.68.0-45.119.71.255, HE
        [ 0x2D774800, 0x2D774BFF, "BJ" ],  // 45.119.72.0-45.119.75.255, BJ
        [ 0x2D776800, 0x2D776BFF, "BJ" ],  // 45.119.104.0-45.119.107.255, BJ
        [ 0x2D777400, 0x2D7777FF, "BJ" ],  // 45.119.116.0-45.119.119.255, BJ
        [ 0x2D77E800, 0x2D77EBFF, "BJ" ],  // 45.119.232.0-45.119.235.255, BJ
        [ 0x2D786400, 0x2D7867FF, "JS" ],  // 45.120.100.0-45.120.103.255, JS
        [ 0x2D788C00, 0x2D788FFF, "ZJ" ],  // 45.120.140.0-45.120.143.255, ZJ
        [ 0x2D78A400, 0x2D78A7FF, "BJ" ],  // 45.120.164.0-45.120.167.255, BJ
        [ 0x2D78F000, 0x2D78F3FF, "BJ" ],  // 45.120.240.0-45.120.243.255, BJ
        [ 0x2D793400, 0x2D7937FF, "BJ" ],  // 45.121.52.0-45.121.55.255, BJ
        [ 0x2D794000, 0x2D7947FF, "BJ" ],  // 45.121.64.0-45.121.71.255, BJ
        [ 0x2D794800, 0x2D794BFF, "SN" ],  // 45.121.72.0-45.121.75.255, SN
        [ 0x2D795C00, 0x2D795FFF, "HA" ],  // 45.121.92.0-45.121.95.255, HA
        [ 0x2D796000, 0x2D7963FF, "JX" ],  // 45.121.96.0-45.121.99.255, JX
        [ 0x2D79AC00, 0x2D79AFFF, "HE" ],  // 45.121.172.0-45.121.175.255, HE
        [ 0x2D79B000, 0x2D79B3FF, "BJ" ],  // 45.121.176.0-45.121.179.255, BJ
        [ 0x2D79D500, 0x2D79D6FF, "HA" ],  // 45.121.213.0-45.121.214.255, HA
        [ 0x2D79F000, 0x2D79F3FF, "JS" ],  // 45.121.240.0-45.121.243.255, JS
        [ 0x2D79F400, 0x2D79FBFF, "GD" ],  // 45.121.244.0-45.121.251.255, GD
        [ 0x2D79FC00, 0x2D79FFFF, "LN" ],  // 45.121.252.0-45.121.255.255, LN
        [ 0x2D7A0000, 0x2D7A03FF, "SC" ],  // 45.122.0.0-45.122.3.255, SC
        [ 0x2D7A0400, 0x2D7A07FF, "AH" ],  // 45.122.4.0-45.122.7.255, AH
        [ 0x2D7A0800, 0x2D7A0BFF, "HE" ],  // 45.122.8.0-45.122.11.255, HE
        [ 0x2D7A0C00, 0x2D7A0FFF, "GD" ],  // 45.122.12.0-45.122.15.255, GD
        [ 0x2D7A1000, 0x2D7A13FF, "HL" ],  // 45.122.16.0-45.122.19.255, HL
        [ 0x2D7A1400, 0x2D7A17FF, "HE" ],  // 45.122.20.0-45.122.23.255, HE
        [ 0x2D7A1800, 0x2D7A1BFF, "GD" ],  // 45.122.24.0-45.122.27.255, GD
        [ 0x2D7A1C00, 0x2D7A1FFF, "YN" ],  // 45.122.28.0-45.122.31.255, YN
        [ 0x2D7A2000, 0x2D7A23FF, "JX" ],  // 45.122.32.0-45.122.35.255, JX
        [ 0x2D7A2400, 0x2D7A27FF, "SX" ],  // 45.122.36.0-45.122.39.255, SX
        [ 0x2D7A2800, 0x2D7A2BFF, "JS" ],  // 45.122.40.0-45.122.43.255, JS
        [ 0x2D7A3C00, 0x2D7A3FFF, "JS" ],  // 45.122.60.0-45.122.63.255, JS
        [ 0x2D7A4000, 0x2D7A43FF, "HB" ],  // 45.122.64.0-45.122.67.255, HB
        [ 0x2D7A4400, 0x2D7A47FF, "SH" ],  // 45.122.68.0-45.122.71.255, SH
        [ 0x2D7A4800, 0x2D7A4BFF, "SD" ],  // 45.122.72.0-45.122.75.255, SD
        [ 0x2D7A4C00, 0x2D7A4FFF, "ZJ" ],  // 45.122.76.0-45.122.79.255, ZJ
        [ 0x2D7A5000, 0x2D7A53FF, "CQ" ],  // 45.122.80.0-45.122.83.255, CQ
        [ 0x2D7A5400, 0x2D7A57FF, "JS" ],  // 45.122.84.0-45.122.87.255, JS
        [ 0x2D7A5800, 0x2D7A5BFF, "GD" ],  // 45.122.88.0-45.122.91.255, GD
        [ 0x2D7A5C00, 0x2D7A5FFF, "HE" ],  // 45.122.92.0-45.122.95.255, HE
        [ 0x2D7A6000, 0x2D7A63FF, "ZJ" ],  // 45.122.96.0-45.122.99.255, ZJ
        [ 0x2D7A6400, 0x2D7A67FF, "CQ" ],  // 45.122.100.0-45.122.103.255, CQ
        [ 0x2D7A6800, 0x2D7A6BFF, "JS" ],  // 45.122.104.0-45.122.107.255, JS
        [ 0x2D7A6C00, 0x2D7A6FFF, "HE" ],  // 45.122.108.0-45.122.111.255, HE
        [ 0x2D7A7000, 0x2D7A73FF, "JS" ],  // 45.122.112.0-45.122.115.255, JS
        [ 0x2D7A7400, 0x2D7A77FF, "GD" ],  // 45.122.116.0-45.122.119.255, GD
        [ 0x2D7AA000, 0x2D7AA3FF, "JS" ],  // 45.122.160.0-45.122.163.255, JS
        [ 0x2D7AA400, 0x2D7AA7FF, "ZJ" ],  // 45.122.164.0-45.122.167.255, ZJ
        [ 0x2D7AA800, 0x2D7AABFF, "SD" ],  // 45.122.168.0-45.122.171.255, SD
        [ 0x2D7AAC00, 0x2D7AAFFF, "LN" ],  // 45.122.172.0-45.122.175.255, LN
        [ 0x2D7AB000, 0x2D7AB3FF, "HE" ],  // 45.122.176.0-45.122.179.255, HE
        [ 0x2D7AB400, 0x2D7AB7FF, "AH" ],  // 45.122.180.0-45.122.183.255, AH
        [ 0x2D7AB800, 0x2D7ABBFF, "HN" ],  // 45.122.184.0-45.122.187.255, HN
        [ 0x2D7ABC00, 0x2D7AC3FF, "GD" ],  // 45.122.188.0-45.122.195.255, GD
        [ 0x2D7AC400, 0x2D7AC7FF, "LN" ],  // 45.122.196.0-45.122.199.255, LN
        [ 0x2D7AC800, 0x2D7ACBFF, "AH" ],  // 45.122.200.0-45.122.203.255, AH
        [ 0x2D7ACC00, 0x2D7ACFFF, "LN" ],  // 45.122.204.0-45.122.207.255, LN
        [ 0x2D7AD000, 0x2D7AD3FF, "GD" ],  // 45.122.208.0-45.122.211.255, GD
        [ 0x2D7AD400, 0x2D7AD7FF, "GZ" ],  // 45.122.212.0-45.122.215.255, GZ
        [ 0x2D7AD800, 0x2D7ADBFF, "JS" ],  // 45.122.216.0-45.122.219.255, JS
        [ 0x2D7B1C00, 0x2D7B1FFF, "GX" ],  // 45.123.28.0-45.123.31.255, GX
        [ 0x2D7B2000, 0x2D7B27FF, "LN" ],  // 45.123.32.0-45.123.39.255, LN
        [ 0x2D7B2C00, 0x2D7B33FF, "SX" ],  // 45.123.44.0-45.123.51.255, SX
        [ 0x2D7B3400, 0x2D7B37FF, "HL" ],  // 45.123.52.0-45.123.55.255, HL
        [ 0x2D7B3800, 0x2D7B3BFF, "LN" ],  // 45.123.56.0-45.123.59.255, LN
        [ 0x2D7B3C00, 0x2D7B3FFF, "GX" ],  // 45.123.60.0-45.123.63.255, GX
        [ 0x2D7B4000, 0x2D7B43FF, "HL" ],  // 45.123.64.0-45.123.67.255, HL
        [ 0x2D7B4400, 0x2D7B47FF, "GZ" ],  // 45.123.68.0-45.123.71.255, GZ
        [ 0x2D7B4800, 0x2D7B4BFF, "SD" ],  // 45.123.72.0-45.123.75.255, SD
        [ 0x2D7B4C00, 0x2D7B4FFF, "SN" ],  // 45.123.76.0-45.123.79.255, SN
        [ 0x2D7B5000, 0x2D7B53FF, "LN" ],  // 45.123.80.0-45.123.83.255, LN
        [ 0x2D7B5400, 0x2D7B57FF, "FJ" ],  // 45.123.84.0-45.123.87.255, FJ
        [ 0x2D7B7800, 0x2D7B7BFF, "BJ" ],  // 45.123.120.0-45.123.123.255, BJ
        [ 0x2D7B8000, 0x2D7B83FF, "JL" ],  // 45.123.128.0-45.123.131.255, JL
        [ 0x2D7B8400, 0x2D7B87FF, "GD" ],  // 45.123.132.0-45.123.135.255, GD
        [ 0x2D7B8800, 0x2D7B8BFF, "HE" ],  // 45.123.136.0-45.123.139.255, HE
        [ 0x2D7B9400, 0x2D7B97FF, "BJ" ],  // 45.123.148.0-45.123.151.255, BJ
        [ 0x2D7B9800, 0x2D7B9FFF, "JS" ],  // 45.123.152.0-45.123.159.255, JS
        [ 0x2D7BA400, 0x2D7BA7FF, "SX" ],  // 45.123.164.0-45.123.167.255, SX
        [ 0x2D7BA800, 0x2D7BABFF, "GD" ],  // 45.123.168.0-45.123.171.255, GD
        [ 0x2D7BAC00, 0x2D7BAFFF, "JS" ],  // 45.123.172.0-45.123.175.255, JS
        [ 0x2D7BB000, 0x2D7BB3FF, "ZJ" ],  // 45.123.176.0-45.123.179.255, ZJ
        [ 0x2D7BB400, 0x2D7BB7FF, "HB" ],  // 45.123.180.0-45.123.183.255, HB
        [ 0x2D7BB800, 0x2D7BBBFF, "JL" ],  // 45.123.184.0-45.123.187.255, JL
        [ 0x2D7BCC00, 0x2D7BCFFF, "GD" ],  // 45.123.204.0-45.123.207.255, GD
        [ 0x2D7BD400, 0x2D7BD7FF, "GD" ],  // 45.123.212.0-45.123.215.255, GD
        [ 0x2D7BE000, 0x2D7BE3FF, "JS" ],  // 45.123.224.0-45.123.227.255, JS
        [ 0x2D7BE400, 0x2D7BE7FF, "HA" ],  // 45.123.228.0-45.123.231.255, HA
        [ 0x2D7BE800, 0x2D7BEBFF, "CQ" ],  // 45.123.232.0-45.123.235.255, CQ
        [ 0x2D7BEC00, 0x2D7BF3FF, "SD" ],  // 45.123.236.0-45.123.243.255, SD
        [ 0x2D7BF400, 0x2D7BFBFF, "HN" ],  // 45.123.244.0-45.123.251.255, HN
        [ 0x2D7BFC00, 0x2D7C03FF, "BJ" ],  // 45.123.252.0-45.124.3.255, BJ
        [ 0x2D7C1400, 0x2D7C15FF, "BJ" ],  // 45.124.20.0-45.124.21.255, BJ
        [ 0x2D7C1600, 0x2D7C17FF, "SN" ],  // 45.124.22.0-45.124.23.255, SN
        [ 0x2D7C1C00, 0x2D7C1FFF, "BJ" ],  // 45.124.28.0-45.124.31.255, BJ
        [ 0x2D7C2000, 0x2D7C23FF, "TJ" ],  // 45.124.32.0-45.124.35.255, TJ
        [ 0x2D7C2400, 0x2D7C27FF, "BJ" ],  // 45.124.36.0-45.124.39.255, BJ
        [ 0x2D7C2C00, 0x2D7C2FFF, "BJ" ],  // 45.124.44.0-45.124.47.255, BJ
        [ 0x2D7C4400, 0x2D7C47FF, "JS" ],  // 45.124.68.0-45.124.71.255, JS
        [ 0x2D7C4C00, 0x2D7C4FFF, "ZJ" ],  // 45.124.76.0-45.124.79.255, ZJ
        [ 0x2D7C5000, 0x2D7C53FF, "JS" ],  // 45.124.80.0-45.124.83.255, JS
        [ 0x2D7C6400, 0x2D7C67FF, "BJ" ],  // 45.124.100.0-45.124.103.255, BJ
        [ 0x2D7C7C00, 0x2D7C7FFF, "SH" ],  // 45.124.124.0-45.124.127.255, SH
        [ 0x2D7CAC00, 0x2D7CAFFF, "GD" ],  // 45.124.172.0-45.124.175.255, GD
        [ 0x2D7CB000, 0x2D7CB3FF, "BJ" ],  // 45.124.176.0-45.124.179.255, BJ
        [ 0x2D7CD000, 0x2D7CD3FF, "GD" ],  // 45.124.208.0-45.124.211.255, GD
        [ 0x2D7CF800, 0x2D7CFBFF, "SH" ],  // 45.124.248.0-45.124.251.255, SH
        [ 0x2D7D1000, 0x2D7D13FF, "SC" ],  // 45.125.16.0-45.125.19.255, SC
        [ 0x2D7D1800, 0x2D7D1BFF, "BJ" ],  // 45.125.24.0-45.125.27.255, BJ
        [ 0x2D7D2C00, 0x2D7D2FFF, "SD" ],  // 45.125.44.0-45.125.47.255, SD
        [ 0x2D7D3400, 0x2D7D3BFF, "NM" ],  // 45.125.52.0-45.125.59.255, NM
        [ 0x2D7D4C00, 0x2D7D4FFF, "GD" ],  // 45.125.76.0-45.125.79.255, GD
        [ 0x2D7D5000, 0x2D7D53FF, "SH" ],  // 45.125.80.0-45.125.83.255, SH
        [ 0x2D7D5400, 0x2D7D67FF, "GD" ],  // 45.125.84.0-45.125.103.255, GD
        [ 0x2D7D6800, 0x2D7D6BFF, "ZJ" ],  // 45.125.104.0-45.125.107.255, ZJ
        [ 0x2D7D8800, 0x2D7D8BFF, "SN" ],  // 45.125.136.0-45.125.139.255, SN
        [ 0x2D7E3000, 0x2D7E33FF, "BJ" ],  // 45.126.48.0-45.126.51.255, BJ
        [ 0x2D7E3400, 0x2D7E37FF, "HE" ],  // 45.126.52.0-45.126.55.255, HE
        [ 0x2D7E6400, 0x2D7E67FF, "GD" ],  // 45.126.100.0-45.126.103.255, GD
        [ 0x2D7E6C00, 0x2D7E6FFF, "JS" ],  // 45.126.108.0-45.126.111.255, JS
        [ 0x2D7E7000, 0x2D7E73FF, "BJ" ],  // 45.126.112.0-45.126.115.255, BJ
        [ 0x2D7E7400, 0x2D7E77FF, "GD" ],  // 45.126.116.0-45.126.119.255, GD
        [ 0x2D7E7800, 0x2D7E7BFF, "FJ" ],  // 45.126.120.0-45.126.123.255, FJ
        [ 0x2D7ED400, 0x2D7ED7FF, "GD" ],  // 45.126.212.0-45.126.215.255, GD
        [ 0x2D7EDC00, 0x2D7EDFFF, "JX" ],  // 45.126.220.0-45.126.223.255, JX
        [ 0x2D7F0800, 0x2D7F0BFF, "BJ" ],  // 45.127.8.0-45.127.11.255, BJ
        [ 0x2D7F0C00, 0x2D7F0FFF, "HE" ],  // 45.127.12.0-45.127.15.255, HE
        [ 0x2D7F7400, 0x2D7F77FF, "BJ" ],  // 45.127.116.0-45.127.119.255, BJ
        [ 0x2D7F8000, 0x2D7F83FF, "ZJ" ],  // 45.127.128.0-45.127.131.255, ZJ
        [ 0x2D7F9000, 0x2D7F97FF, "BJ" ],  // 45.127.144.0-45.127.151.255, BJ
        [ 0x2D7F9C00, 0x2D7F9FFF, "BJ" ],  // 45.127.156.0-45.127.159.255, BJ
        [ 0x2D7FD900, 0x2D7FD9FF, "SH" ],  // 45.127.217.0-45.127.217.255, SH
        [ 0x2D7FDB00, 0x2D7FDBFF, "SH" ],  // 45.127.219.0-45.127.219.255, SH
        [ 0x2D84BB00, 0x2D84BBFF, "BJ" ],  // 45.132.187.0-45.132.187.255, BJ
        [ 0x2D87B800, 0x2D87B8FF, "BJ" ],  // 45.135.184.0-45.135.184.255, BJ
        [ 0x2D8AE800, 0x2D8AEBFF, "SH" ],  // 45.138.232.0-45.138.235.255, SH
        [ 0x2D947F00, 0x2D947FFF, "BJ" ],  // 45.148.127.0-45.148.127.255, BJ
        [ 0x2DF80800, 0x2DF80BFF, "JS" ],  // 45.248.8.0-45.248.11.255, JS
        [ 0x2DF85000, 0x2DF853FF, "FJ" ],  // 45.248.80.0-45.248.83.255, FJ
        [ 0x2DF85400, 0x2DF857FF, "BJ" ],  // 45.248.84.0-45.248.87.255, BJ
        [ 0x2DF85800, 0x2DF85BFF, "GZ" ],  // 45.248.88.0-45.248.91.255, GZ
        [ 0x2DF86000, 0x2DF863FF, "HL" ],  // 45.248.96.0-45.248.99.255, HL
        [ 0x2DF86400, 0x2DF86BFF, "ZJ" ],  // 45.248.100.0-45.248.107.255, ZJ
        [ 0x2DF86C00, 0x2DF86FFF, "GD" ],  // 45.248.108.0-45.248.111.255, GD
        [ 0x2DF88000, 0x2DF883FF, "GD" ],  // 45.248.128.0-45.248.131.255, GD
        [ 0x2DF88400, 0x2DF887FF, "SD" ],  // 45.248.132.0-45.248.135.255, SD
        [ 0x2DF8CC00, 0x2DF8CFFF, "BJ" ],  // 45.248.204.0-45.248.207.255, BJ
        [ 0x2DF8D000, 0x2DF8EBFF, "GD" ],  // 45.248.208.0-45.248.235.255, GD
        [ 0x2DF8EC00, 0x2DF8EFFF, "SD" ],  // 45.248.236.0-45.248.239.255, SD
        [ 0x2DF8F000, 0x2DF907FF, "GD" ],  // 45.248.240.0-45.249.7.255, GD
        [ 0x2DF90C00, 0x2DF927FF, "SH" ],  // 45.249.12.0-45.249.39.255, SH
        [ 0x2DF97000, 0x2DF973FF, "TJ" ],  // 45.249.112.0-45.249.115.255, TJ
        [ 0x2DF9BC00, 0x2DF9D3FF, "SH" ],  // 45.249.188.0-45.249.211.255, SH
        [ 0x2DF9D400, 0x2DF9D7FF, "GD" ],  // 45.249.212.0-45.249.215.255, GD
        [ 0x2DFA0C00, 0x2DFA0FFF, "HN" ],  // 45.250.12.0-45.250.15.255, HN
        [ 0x2DFA1000, 0x2DFA13FF, "BJ" ],  // 45.250.16.0-45.250.19.255, BJ
        [ 0x2DFA1C00, 0x2DFA2BFF, "ZJ" ],  // 45.250.28.0-45.250.43.255, ZJ
        [ 0x2DFA4C00, 0x2DFA4FFF, "SC" ],  // 45.250.76.0-45.250.79.255, SC
        [ 0x2DFA5000, 0x2DFA53FF, "ZJ" ],  // 45.250.80.0-45.250.83.255, ZJ
        [ 0x2DFA5400, 0x2DFA5BFF, "SD" ],  // 45.250.84.0-45.250.91.255, SD
        [ 0x2DFA5C00, 0x2DFA5FFF, "JS" ],  // 45.250.92.0-45.250.95.255, JS
        [ 0x2DFA6000, 0x2DFA63FF, "FJ" ],  // 45.250.96.0-45.250.99.255, FJ
        [ 0x2DFA6800, 0x2DFA6FFF, "SH" ],  // 45.250.104.0-45.250.111.255, SH
        [ 0x2DFA7000, 0x2DFA7FFF, "GD" ],  // 45.250.112.0-45.250.127.255, GD
        [ 0x2DFA8000, 0x2DFA83FF, "SX" ],  // 45.250.128.0-45.250.131.255, SX
        [ 0x2DFA8400, 0x2DFA85FF, "TJ" ],  // 45.250.132.0-45.250.133.255, TJ
        [ 0x2DFA8600, 0x2DFA86FF, "GD" ],  // 45.250.134.0-45.250.134.255, GD
        [ 0x2DFA8700, 0x2DFA87FF, "TJ" ],  // 45.250.135.0-45.250.135.255, TJ
        [ 0x2DFA8800, 0x2DFA8FFF, "GD" ],  // 45.250.136.0-45.250.143.255, GD
        [ 0x2DFA9000, 0x2DFA93FF, "SH" ],  // 45.250.144.0-45.250.147.255, SH
        [ 0x2DFA9400, 0x2DFA97FF, "FJ" ],  // 45.250.148.0-45.250.151.255, FJ
        [ 0x2DFA9800, 0x2DFA9BFF, "BJ" ],  // 45.250.152.0-45.250.155.255, BJ
        [ 0x2DFAA400, 0x2DFAA7FF, "BJ" ],  // 45.250.164.0-45.250.167.255, BJ
        [ 0x2DFAB400, 0x2DFABBFF, "GD" ],  // 45.250.180.0-45.250.187.255, GD
        [ 0x2DFABC00, 0x2DFABFFF, "SH" ],  // 45.250.188.0-45.250.191.255, SH
        [ 0x2DFAC000, 0x2DFAC3FF, "BJ" ],  // 45.250.192.0-45.250.195.255, BJ
        [ 0x2DFB0000, 0x2DFB03FF, "GD" ],  // 45.251.0.0-45.251.3.255, GD
        [ 0x2DFB0800, 0x2DFB0BFF, "FJ" ],  // 45.251.8.0-45.251.11.255, FJ
        [ 0x2DFB1000, 0x2DFB13FF, "GD" ],  // 45.251.16.0-45.251.19.255, GD
        [ 0x2DFB1400, 0x2DFB17FF, "BJ" ],  // 45.251.20.0-45.251.23.255, BJ
        [ 0x2DFB3400, 0x2DFB37FF, "GD" ],  // 45.251.52.0-45.251.55.255, GD
        [ 0x2DFB5400, 0x2DFB57FF, "TJ" ],  // 45.251.84.0-45.251.87.255, TJ
        [ 0x2DFB5800, 0x2DFB5BFF, "GD" ],  // 45.251.88.0-45.251.91.255, GD
        [ 0x2DFB5C00, 0x2DFB5FFF, "GZ" ],  // 45.251.92.0-45.251.95.255, GZ
        [ 0x2DFB6000, 0x2DFB63FF, "TJ" ],  // 45.251.96.0-45.251.99.255, TJ
        [ 0x2DFB6400, 0x2DFB67FF, "GZ" ],  // 45.251.100.0-45.251.103.255, GZ
        [ 0x2DFB7800, 0x2DFB7BFF, "AH" ],  // 45.251.120.0-45.251.123.255, AH
        [ 0x2DFB7C00, 0x2DFB7FFF, "GD" ],  // 45.251.124.0-45.251.127.255, GD
        [ 0x2DFB8C00, 0x2DFB97FF, "ZJ" ],  // 45.251.140.0-45.251.151.255, ZJ
        [ 0x2DFB9800, 0x2DFBE3FF, "SH" ],  // 45.251.152.0-45.251.227.255, SH
        [ 0x2DFC0000, 0x2DFC03FF, "ZJ" ],  // 45.252.0.0-45.252.3.255, ZJ
        [ 0x2DFC0400, 0x2DFC07FF, "QH" ],  // 45.252.4.0-45.252.7.255, QH
        [ 0x2DFC0800, 0x2DFC33FF, "SH" ],  // 45.252.8.0-45.252.51.255, SH
        [ 0x2DFC5400, 0x2DFC67FF, "SH" ],  // 45.252.84.0-45.252.103.255, SH
        [ 0x2DFC6800, 0x2DFC6BFF, "JS" ],  // 45.252.104.0-45.252.107.255, JS
        [ 0x2DFC6C00, 0x2DFC77FF, "SH" ],  // 45.252.108.0-45.252.119.255, SH
        [ 0x2DFC7800, 0x2DFC7BFF, "BJ" ],  // 45.252.120.0-45.252.123.255, BJ
        [ 0x2DFC7C00, 0x2DFC7FFF, "AH" ],  // 45.252.124.0-45.252.127.255, AH
        [ 0x2DFC8000, 0x2DFC83FF, "JS" ],  // 45.252.128.0-45.252.131.255, JS
        [ 0x2DFC8400, 0x2DFC8BFF, "SH" ],  // 45.252.132.0-45.252.139.255, SH
        [ 0x2DFC8C00, 0x2DFC8FFF, "BJ" ],  // 45.252.140.0-45.252.143.255, BJ
        [ 0x2DFC9000, 0x2DFC93FF, "SH" ],  // 45.252.144.0-45.252.147.255, SH
        [ 0x2DFC9400, 0x2DFC9BFF, "BJ" ],  // 45.252.148.0-45.252.155.255, BJ
        [ 0x2DFC9C00, 0x2DFCA3FF, "SH" ],  // 45.252.156.0-45.252.163.255, SH
        [ 0x2DFCA400, 0x2DFCB3FF, "BJ" ],  // 45.252.164.0-45.252.179.255, BJ
        [ 0x2DFCC000, 0x2DFCE7FF, "BJ" ],  // 45.252.192.0-45.252.231.255, BJ
        [ 0x2DFCE800, 0x2DFCEBFF, "HE" ],  // 45.252.232.0-45.252.235.255, HE
        [ 0x2DFD0000, 0x2DFD07FF, "HB" ],  // 45.253.0.0-45.253.7.255, HB
        [ 0x2DFD0800, 0x2DFD0FFF, "BJ" ],  // 45.253.8.0-45.253.15.255, BJ
        [ 0x2DFD1000, 0x2DFD17FF, "HB" ],  // 45.253.16.0-45.253.23.255, HB
        [ 0x2DFD1800, 0x2DFD1BFF, "SH" ],  // 45.253.24.0-45.253.27.255, SH
        [ 0x2DFD1C00, 0x2DFD23FF, "BJ" ],  // 45.253.28.0-45.253.35.255, BJ
        [ 0x2DFD2400, 0x2DFD27FF, "HB" ],  // 45.253.36.0-45.253.39.255, HB
        [ 0x2DFD2800, 0x2DFD29FF, "GD" ],  // 45.253.40.0-45.253.41.255, GD
        [ 0x2DFD2A00, 0x2DFD2BFF, "BJ" ],  // 45.253.42.0-45.253.43.255, BJ
        [ 0x2DFD2C00, 0x2DFD2FFF, "JS" ],  // 45.253.44.0-45.253.47.255, JS
        [ 0x2DFD3000, 0x2DFD33FF, "TJ" ],  // 45.253.48.0-45.253.51.255, TJ
        [ 0x2DFD3400, 0x2DFD37FF, "GD" ],  // 45.253.52.0-45.253.55.255, GD
        [ 0x2DFD3800, 0x2DFD3BFF, "BJ" ],  // 45.253.56.0-45.253.59.255, BJ
        [ 0x2DFD3C00, 0x2DFD3FFF, "NX" ],  // 45.253.60.0-45.253.63.255, NX
        [ 0x2DFD4000, 0x2DFD43FF, "JS" ],  // 45.253.64.0-45.253.67.255, JS
        [ 0x2DFD4400, 0x2DFD47FF, "BJ" ],  // 45.253.68.0-45.253.71.255, BJ
        [ 0x2DFD4800, 0x2DFD4BFF, "FJ" ],  // 45.253.72.0-45.253.75.255, FJ
        [ 0x2DFD4C00, 0x2DFD4FFF, "HL" ],  // 45.253.76.0-45.253.79.255, HL
        [ 0x2DFD5000, 0x2DFD53FF, "LN" ],  // 45.253.80.0-45.253.83.255, LN
        [ 0x2DFD5400, 0x2DFD57FF, "BJ" ],  // 45.253.84.0-45.253.87.255, BJ
        [ 0x2DFD5C00, 0x2DFD5FFF, "GD" ],  // 45.253.92.0-45.253.95.255, GD
        [ 0x2DFD6000, 0x2DFD77FF, "ZJ" ],  // 45.253.96.0-45.253.119.255, ZJ
        [ 0x2DFD7800, 0x2DFD79FF, "BJ" ],  // 45.253.120.0-45.253.121.255, BJ
        [ 0x2DFD7A00, 0x2DFD7AFF, "AH" ],  // 45.253.122.0-45.253.122.255, AH
        [ 0x2DFD7B00, 0x2DFD7BFF, "BJ" ],  // 45.253.123.0-45.253.123.255, BJ
        [ 0x2DFD8400, 0x2DFDF3FF, "ZJ" ],  // 45.253.132.0-45.253.243.255, ZJ
        [ 0x2DFE0000, 0x2DFE0FFF, "GD" ],  // 45.254.0.0-45.254.15.255, GD
        [ 0x2DFE1000, 0x2DFE13FF, "BJ" ],  // 45.254.16.0-45.254.19.255, BJ
        [ 0x2DFE1400, 0x2DFE17FF, "FJ" ],  // 45.254.20.0-45.254.23.255, FJ
        [ 0x2DFE1C00, 0x2DFE1FFF, "AH" ],  // 45.254.28.0-45.254.31.255, AH
        [ 0x2DFE2800, 0x2DFE2BFF, "BJ" ],  // 45.254.40.0-45.254.43.255, BJ
        [ 0x2DFE3000, 0x2DFE32FF, "ZJ" ],  // 45.254.48.0-45.254.50.255, ZJ
        [ 0x2DFE3300, 0x2DFE37FF, "GD" ],  // 45.254.51.0-45.254.55.255, GD
        [ 0x2DFE3800, 0x2DFE3BFF, "BJ" ],  // 45.254.56.0-45.254.59.255, BJ
        [ 0x2DFE3C00, 0x2DFE3FFF, "GD" ],  // 45.254.60.0-45.254.63.255, GD
        [ 0x2DFE4000, 0x2DFE4FFF, "ZJ" ],  // 45.254.64.0-45.254.79.255, ZJ
        [ 0x2DFE5000, 0x2DFE57FF, "GD" ],  // 45.254.80.0-45.254.87.255, GD
        [ 0x2DFE5800, 0x2DFE5BFF, "ZJ" ],  // 45.254.88.0-45.254.91.255, ZJ
        [ 0x2DFE5C00, 0x2DFE5FFF, "GD" ],  // 45.254.92.0-45.254.95.255, GD
        [ 0x2DFE6000, 0x2DFE63FF, "BJ" ],  // 45.254.96.0-45.254.99.255, BJ
        [ 0x2DFE6400, 0x2DFE74FF, "GD" ],  // 45.254.100.0-45.254.116.255, GD
        [ 0x2DFE7500, 0x2DFE77FF, "ZJ" ],  // 45.254.117.0-45.254.119.255, ZJ
        [ 0x2DFE7800, 0x2DFE83FF, "GD" ],  // 45.254.120.0-45.254.131.255, GD
        [ 0x2DFE8400, 0x2DFE87FF, "BJ" ],  // 45.254.132.0-45.254.135.255, BJ
        [ 0x2DFE8800, 0x2DFE97FF, "GD" ],  // 45.254.136.0-45.254.151.255, GD
        [ 0x2DFE9800, 0x2DFE9BFF, "BJ" ],  // 45.254.152.0-45.254.155.255, BJ
        [ 0x2DFE9C00, 0x2DFE9FFF, "GD" ],  // 45.254.156.0-45.254.159.255, GD
        [ 0x2DFEA000, 0x2DFEA3FF, "BJ" ],  // 45.254.160.0-45.254.163.255, BJ
        [ 0x2DFEA400, 0x2DFEA7FF, "GD" ],  // 45.254.164.0-45.254.167.255, GD
        [ 0x2DFEA800, 0x2DFEAFFF, "BJ" ],  // 45.254.168.0-45.254.175.255, BJ
        [ 0x2DFEB000, 0x2DFEB3FF, "GD" ],  // 45.254.176.0-45.254.179.255, GD
        [ 0x2DFEB400, 0x2DFEB7FF, "BJ" ],  // 45.254.180.0-45.254.183.255, BJ
        [ 0x2DFEB800, 0x2DFEC7FF, "SH" ],  // 45.254.184.0-45.254.199.255, SH
        [ 0x2DFEC800, 0x2DFECBFF, "BJ" ],  // 45.254.200.0-45.254.203.255, BJ
        [ 0x2DFECC00, 0x2DFECFFF, "AH" ],  // 45.254.204.0-45.254.207.255, AH
        [ 0x2DFED000, 0x2DFED7FF, "BJ" ],  // 45.254.208.0-45.254.215.255, BJ
        [ 0x2DFED800, 0x2DFEDFFF, "AH" ],  // 45.254.216.0-45.254.223.255, AH
        [ 0x2DFEE000, 0x2DFEE7FF, "BJ" ],  // 45.254.224.0-45.254.231.255, BJ
        [ 0x2DFEEC00, 0x2DFEF3FF, "GD" ],  // 45.254.236.0-45.254.243.255, GD
        [ 0x2DFEF800, 0x2DFEFBFF, "GD" ],  // 45.254.248.0-45.254.251.255, GD
        [ 0x2DFF0000, 0x2DFF7BFF, "BJ" ],  // 45.255.0.0-45.255.123.255, BJ
        [ 0x2DFF8800, 0x2DFFFBFF, "BJ" ],  // 45.255.136.0-45.255.251.255, BJ
        [ 0x2EF81800, 0x2EF819FF, "BJ" ],  // 46.248.24.0-46.248.25.255, BJ
        [ 0x2F5C0000, 0x2F5C15FF, "BJ" ],  // 47.92.0.0-47.92.21.255, BJ
        [ 0x2F5C1600, 0x2F5C16FF, "HE" ],  // 47.92.22.0-47.92.22.255, HE
        [ 0x2F5C1700, 0x2F5CB8FF, "BJ" ],  // 47.92.23.0-47.92.184.255, BJ
        [ 0x2F5CB900, 0x2F5CB9FF, "HE" ],  // 47.92.185.0-47.92.185.255, HE
        [ 0x2F5CBA00, 0x2F5FFFFF, "BJ" ],  // 47.92.186.0-47.95.255.255, BJ
        [ 0x2F600000, 0x2F63FFFF, "ZJ" ],  // 47.96.0.0-47.99.255.255, ZJ
        [ 0x2F640000, 0x2F67FFFF, "SH" ],  // 47.100.0.0-47.103.255.255, SH
        [ 0x2F680000, 0x2F69FFFF, "SD" ],  // 47.104.0.0-47.105.255.255, SD
        [ 0x2F6A0000, 0x2F6BFFFF, "GD" ],  // 47.106.0.0-47.107.255.255, GD
        [ 0x2F6C0000, 0x2F6DFFFF, "SC" ],  // 47.108.0.0-47.109.255.255, SC
        [ 0x2F6E0000, 0x2F6FFFFF, "ZJ" ],  // 47.110.0.0-47.111.255.255, ZJ
        [ 0x2F700000, 0x2F71FFFF, "GD" ],  // 47.112.0.0-47.113.255.255, GD
        [ 0x2F720000, 0x2F72FFFF, "ZJ" ],  // 47.114.0.0-47.114.255.255, ZJ
        [ 0x2F730000, 0x2F73FFFF, "GD" ],  // 47.115.0.0-47.115.255.255, GD
        [ 0x2F740000, 0x2F75FFFF, "SH" ],  // 47.116.0.0-47.117.255.255, SH
        [ 0x2F760000, 0x2F76FFFF, "ZJ" ],  // 47.118.0.0-47.118.255.255, ZJ
        [ 0x2F770000, 0x2F79FFFF, "GD" ],  // 47.119.0.0-47.121.255.255, GD
        [ 0x2F7A0000, 0x2F7A34FF, "JS" ],  // 47.122.0.0-47.122.52.255, JS
        [ 0x2F7A3500, 0x2F7A35FF, "FJ" ],  // 47.122.53.0-47.122.53.255, FJ
        [ 0x2F7A3600, 0x2F7A7FFF, "JS" ],  // 47.122.54.0-47.122.127.255, JS
        [ 0x2F7A8000, 0x2F7FFFFF, "SH" ],  // 47.122.128.0-47.127.255.255, SH
        [ 0x31040000, 0x31045FFF, "BJ" ],  // 49.4.0.0-49.4.95.255, BJ
        [ 0x31046000, 0x31046EFF, "LN" ],  // 49.4.96.0-49.4.110.255, LN
        [ 0x31046F00, 0x310506FF, "BJ" ],  // 49.4.111.0-49.5.6.255, BJ
        [ 0x31050700, 0x310507FF, "LN" ],  // 49.5.7.0-49.5.7.255, LN
        [ 0x31050800, 0x31059FFF, "BJ" ],  // 49.5.8.0-49.5.159.255, BJ
        [ 0x3105A000, 0x3105BFFF, "JL" ],  // 49.5.160.0-49.5.191.255, JL
        [ 0x3105C000, 0x3107FFFF, "BJ" ],  // 49.5.192.0-49.7.255.255, BJ
        [ 0x31336E00, 0x31337FFF, "SH" ],  // 49.51.110.0-49.51.127.255, SH
        [ 0x31340000, 0x3137FFFF, "SH" ],  // 49.52.0.0-49.55.255.255, SH
        [ 0x31400000, 0x314A57FF, "JS" ],  // 49.64.0.0-49.74.87.255, JS
        [ 0x314A5800, 0x314A58FF, "SD" ],  // 49.74.88.0-49.74.88.255, SD
        [ 0x314A5900, 0x315FFFFF, "JS" ],  // 49.74.89.0-49.95.255.255, JS
        [ 0x31700000, 0x3177FFFF, "XJ" ],  // 49.112.0.0-49.119.255.255, XJ
        [ 0x31780000, 0x3179FFFF, "HB" ],  // 49.120.0.0-49.121.255.255, HB
        [ 0x317A0000, 0x317AFFFF, "HA" ],  // 49.122.0.0-49.122.255.255, HA
        [ 0x317B0000, 0x317B2FFF, "HN" ],  // 49.123.0.0-49.123.47.255, HN
        [ 0x317B3000, 0x317B3FFF, "HB" ],  // 49.123.48.0-49.123.63.255, HB
        [ 0x317B4000, 0x317B7FFF, "HN" ],  // 49.123.64.0-49.123.127.255, HN
        [ 0x317B8000, 0x317BFFFF, "HB" ],  // 49.123.128.0-49.123.255.255, HB
        [ 0x31800000, 0x318000FF, "FJ" ],  // 49.128.0.0-49.128.0.255, FJ
        [ 0x31800200, 0x318003FF, "FJ" ],  // 49.128.2.0-49.128.3.255, FJ
        [ 0x31800400, 0x318007FF, "HL" ],  // 49.128.4.0-49.128.7.255, HL
        [ 0x318C0000, 0x318D2FFF, "JL" ],  // 49.140.0.0-49.141.47.255, JL
        [ 0x318D3000, 0x318D3FFF, "LN" ],  // 49.141.48.0-49.141.63.255, LN
        [ 0x318D4000, 0x318D97FF, "JL" ],  // 49.141.64.0-49.141.151.255, JL
        [ 0x318D9800, 0x318DFFFF, "LN" ],  // 49.141.152.0-49.141.255.255, LN
        [ 0x31980000, 0x319BFFFF, "JS" ],  // 49.152.0.0-49.155.255.255, JS
        [ 0x31D00000, 0x31D0FFFF, "SN" ],  // 49.208.0.0-49.208.255.255, SN
        [ 0x31D10000, 0x31D13FFF, "XJ" ],  // 49.209.0.0-49.209.63.255, XJ
        [ 0x31D14000, 0x31D17FFF, "QH" ],  // 49.209.64.0-49.209.127.255, QH
        [ 0x31D18000, 0x31D1E7FF, "SN" ],  // 49.209.128.0-49.209.231.255, SN
        [ 0x31D1E800, 0x31D1FFFF, "GS" ],  // 49.209.232.0-49.209.255.255, GS
        [ 0x31D20000, 0x31D37FFF, "HB" ],  // 49.210.0.0-49.211.127.255, HB
        [ 0x31D38000, 0x31D3FFFF, "JX" ],  // 49.211.128.0-49.211.255.255, JX
        [ 0x31DC0000, 0x31DC7FFF, "HN" ],  // 49.220.0.0-49.220.127.255, HN
        [ 0x31DC8000, 0x31DCFFFF, "TJ" ],  // 49.220.128.0-49.220.255.255, TJ
        [ 0x31DD0000, 0x31DD1FFF, "JL" ],  // 49.221.0.0-49.221.31.255, JL
        [ 0x31DD2000, 0x31DD3FFF, "SN" ],  // 49.221.32.0-49.221.63.255, SN
        [ 0x31DD4000, 0x31DD7FFF, "LN" ],  // 49.221.64.0-49.221.127.255, LN
        [ 0x31DD8000, 0x31DD81FF, "JX" ],  // 49.221.128.0-49.221.129.255, JX
        [ 0x31DD8200, 0x31DD83FF, "SH" ],  // 49.221.130.0-49.221.131.255, SH
        [ 0x31DD8400, 0x31DD84FF, "JS" ],  // 49.221.132.0-49.221.132.255, JS
        [ 0x31DD8500, 0x31DD85FF, "SH" ],  // 49.221.133.0-49.221.133.255, SH
        [ 0x31DD8600, 0x31DD87FF, "ZJ" ],  // 49.221.134.0-49.221.135.255, ZJ
        [ 0x31DD8800, 0x31DD8DFF, "GD" ],  // 49.221.136.0-49.221.141.255, GD
        [ 0x31DD8E00, 0x31DD8FFF, "SH" ],  // 49.221.142.0-49.221.143.255, SH
        [ 0x31DD9000, 0x31DD98FF, "SC" ],  // 49.221.144.0-49.221.152.255, SC
        [ 0x31DD9900, 0x31DDFFFF, "SH" ],  // 49.221.153.0-49.221.255.255, SH
        [ 0x31DE0000, 0x31DEFFFF, "HB" ],  // 49.222.0.0-49.222.255.255, HB
        [ 0x31DF0000, 0x31DFBFFF, "SD" ],  // 49.223.0.0-49.223.191.255, SD
        [ 0x31DFC000, 0x31DFFFFF, "LN" ],  // 49.223.192.0-49.223.255.255, LN
        [ 0x31E80000, 0x31E9FFFF, "BJ" ],  // 49.232.0.0-49.233.255.255, BJ
        [ 0x31EA0000, 0x31EBFFFF, "SH" ],  // 49.234.0.0-49.235.255.255, SH
        [ 0x31EF0000, 0x31EF3FFF, "SH" ],  // 49.239.0.0-49.239.63.255, SH
        [ 0x31EFC000, 0x31EFFFFF, "GD" ],  // 49.239.192.0-49.239.255.255, GD
        [ 0x31F6E000, 0x31F6E1FF, "BJ" ],  // 49.246.224.0-49.246.225.255, BJ
        [ 0x31F6E400, 0x31F6E9FF, "BJ" ],  // 49.246.228.0-49.246.233.255, BJ
        [ 0x31F6ED00, 0x31F6FFFF, "BJ" ],  // 49.246.237.0-49.246.255.255, BJ
        [ 0x34500000, 0x3451FFFF, "BJ" ],  // 52.80.0.0-52.81.255.255, BJ
        [ 0x34520000, 0x345291FF, "NX" ],  // 52.82.0.0-52.82.145.255, NX
        [ 0x34529200, 0x345292FF, "BJ" ],  // 52.82.146.0-52.82.146.255, BJ
        [ 0x34529300, 0x345293FF, "GD" ],  // 52.82.147.0-52.82.147.255, GD
        [ 0x34529400, 0x345297FF, "NX" ],  // 52.82.148.0-52.82.151.255, NX
        [ 0x34529800, 0x345298FF, "SH" ],  // 52.82.152.0-52.82.152.255, SH
        [ 0x34529900, 0x3453FFFF, "NX" ],  // 52.82.153.0-52.83.255.255, NX
        [ 0x345FFF90, 0x345FFF9F, "BJ" ],  // 52.95.255.144-52.95.255.159, BJ
        [ 0x34820000, 0x34820FFF, "SH" ],  // 52.130.0.0-52.130.15.255, SH
        [ 0x34821000, 0x34823FFF, "BJ" ],  // 52.130.16.0-52.130.63.255, BJ
        [ 0x34824000, 0x34825FFF, "SH" ],  // 52.130.64.0-52.130.95.255, SH
        [ 0x34826000, 0x348260FF, "BJ" ],  // 52.130.96.0-52.130.96.255, BJ
        [ 0x34826100, 0x348261FF, "SH" ],  // 52.130.97.0-52.130.97.255, SH
        [ 0x34826200, 0x348263FF, "BJ" ],  // 52.130.98.0-52.130.99.255, BJ
        [ 0x34826400, 0x348265FF, "SH" ],  // 52.130.100.0-52.130.101.255, SH
        [ 0x34826600, 0x348266FF, "BJ" ],  // 52.130.102.0-52.130.102.255, BJ
        [ 0x34826700, 0x348267FF, "SH" ],  // 52.130.103.0-52.130.103.255, SH
        [ 0x34826800, 0x34826FFF, "BJ" ],  // 52.130.104.0-52.130.111.255, BJ
        [ 0x34827000, 0x34827FFF, "SH" ],  // 52.130.112.0-52.130.127.255, SH
        [ 0x34828000, 0x3482BFFF, "BJ" ],  // 52.130.128.0-52.130.191.255, BJ
        [ 0x3482C000, 0x3482FFFF, "SH" ],  // 52.130.192.0-52.130.255.255, SH
        [ 0x34830000, 0x34837FFF, "BJ" ],  // 52.131.0.0-52.131.127.255, BJ
        [ 0x34838000, 0x3483FFFF, "SH" ],  // 52.131.128.0-52.131.255.255, SH
        [ 0x36DE0000, 0x36DFFFFF, "BJ" ],  // 54.222.0.0-54.223.255.255, BJ
        [ 0x36EF0090, 0x36EF009F, "BJ" ],  // 54.239.0.144-54.239.0.159, BJ
        [ 0x36EF00B0, 0x36EF00BF, "NX" ],  // 54.239.0.176-54.239.0.191, NX
        [ 0x395C6000, 0x395C6FFF, "BJ" ],  // 57.92.96.0-57.92.111.255, BJ
        [ 0x39B00000, 0x39B1FFFF, "GZ" ],  // 57.176.0.0-57.177.255.255, GZ
        [ 0x3A0E0000, 0x3A0FFFFF, "SD" ],  // 58.14.0.0-58.15.255.255, SD
        [ 0x3A100000, 0x3A10FFFF, "GZ" ],  // 58.16.0.0-58.16.255.255, GZ
        [ 0x3A110000, 0x3A117FFF, "JX" ],  // 58.17.0.0-58.17.127.255, JX
        [ 0x3A118000, 0x3A11FFFF, "CQ" ],  // 58.17.128.0-58.17.255.255, CQ
        [ 0x3A120000, 0x3A12FFFF, "NM" ],  // 58.18.0.0-58.18.255.255, NM
        [ 0x3A130000, 0x3A13FFFF, "HB" ],  // 58.19.0.0-58.19.255.255, HB
        [ 0x3A140000, 0x3A14FFFF, "HN" ],  // 58.20.0.0-58.20.255.255, HN
        [ 0x3A150000, 0x3A15FFFF, "JL" ],  // 58.21.0.0-58.21.255.255, JL
        [ 0x3A160000, 0x3A17FFFF, "FJ" ],  // 58.22.0.0-58.23.255.255, FJ
        [ 0x3A180000, 0x3A19FFFF, "SH" ],  // 58.24.0.0-58.25.255.255, SH
        [ 0x3A1E0000, 0x3A1FA6FF, "BJ" ],  // 58.30.0.0-58.31.166.255, BJ
        [ 0x3A1FA700, 0x3A1FFFFF, "HE" ],  // 58.31.167.0-58.31.255.255, HE
        [ 0x3A200000, 0x3A23D6FF, "SH" ],  // 58.32.0.0-58.35.214.255, SH
        [ 0x3A23D700, 0x3A23E1FF, "GD" ],  // 58.35.215.0-58.35.225.255, GD
        [ 0x3A23E200, 0x3A29FFFF, "SH" ],  // 58.35.226.0-58.41.255.255, SH
        [ 0x3A2A0000, 0x3A2AFFFF, "GZ" ],  // 58.42.0.0-58.42.255.255, GZ
        [ 0x3A2B0000, 0x3A2BFFFF, "CQ" ],  // 58.43.0.0-58.43.255.255, CQ
        [ 0x3A2C0000, 0x3A2FFFFF, "HN" ],  // 58.44.0.0-58.47.255.255, HN
        [ 0x3A300000, 0x3A37FFFF, "HB" ],  // 58.48.0.0-58.55.255.255, HB
        [ 0x3A380000, 0x3A3B7FFF, "SD" ],  // 58.56.0.0-58.59.127.255, SD
        [ 0x3A3B8000, 0x3A3BFFFF, "GX" ],  // 58.59.128.0-58.59.255.255, GX
        [ 0x3A3C0000, 0x3A3FFFFF, "GD" ],  // 58.60.0.0-58.63.255.255, GD
        [ 0x3A41E800, 0x3A41EFFF, "GD" ],  // 58.65.232.0-58.65.239.255, GD
        [ 0x3A420000, 0x3A429FFF, "GD" ],  // 58.66.0.0-58.66.159.255, GD
        [ 0x3A42C000, 0x3A43FFFF, "GD" ],  // 58.66.192.0-58.67.255.255, GD
        [ 0x3A448000, 0x3A44A7FF, "BJ" ],  // 58.68.128.0-58.68.167.255, BJ
        [ 0x3A44B000, 0x3A44FFFF, "BJ" ],  // 58.68.176.0-58.68.255.255, BJ
        [ 0x3A520000, 0x3A523FFF, "GX" ],  // 58.82.0.0-58.82.63.255, GX
        [ 0x3A524000, 0x3A527FFF, "GD" ],  // 58.82.64.0-58.82.127.255, GD
        [ 0x3A530000, 0x3A5310FF, "BJ" ],  // 58.83.0.0-58.83.16.255, BJ
        [ 0x3A531100, 0x3A5311FF, "JS" ],  // 58.83.17.0-58.83.17.255, JS
        [ 0x3A531200, 0x3A53FFFF, "BJ" ],  // 58.83.18.0-58.83.255.255, BJ
        [ 0x3A574000, 0x3A5769FF, "BJ" ],  // 58.87.64.0-58.87.105.255, BJ
        [ 0x3A576A00, 0x3A577FFF, "TJ" ],  // 58.87.106.0-58.87.127.255, TJ
        [ 0x3A638000, 0x3A63FDFF, "BJ" ],  // 58.99.128.0-58.99.253.255, BJ
        [ 0x3A63FE00, 0x3A63FFFF, "GD" ],  // 58.99.254.0-58.99.255.255, GD
        [ 0x3A640000, 0x3A65FFFF, "ZJ" ],  // 58.100.0.0-58.101.255.255, ZJ
        [ 0x3A740000, 0x3A77FFFF, "BJ" ],  // 58.116.0.0-58.119.255.255, BJ
        [ 0x3A800000, 0x3A87FFFF, "BJ" ],  // 58.128.0.0-58.135.255.255, BJ
        [ 0x3A900000, 0x3A90FFFF, "CQ" ],  // 58.144.0.0-58.144.255.255, CQ
        [ 0x3A9A0000, 0x3A9AFFFF, "LN" ],  // 58.154.0.0-58.154.255.255, LN
        [ 0x3A9B0000, 0x3A9B7FFF, "HL" ],  // 58.155.0.0-58.155.127.255, HL
        [ 0x3A9B8000, 0x3A9BBFFF, "JL" ],  // 58.155.128.0-58.155.191.255, JL
        [ 0x3A9BC000, 0x3A9BFFFF, "LN" ],  // 58.155.192.0-58.155.255.255, LN
        [ 0x3AC00000, 0x3AC1FFFF, "JS" ],  // 58.192.0.0-58.193.255.255, JS
        [ 0x3AC20000, 0x3AC207FF, "HL" ],  // 58.194.0.0-58.194.7.255, HL
        [ 0x3AC20800, 0x3AC209FF, "GD" ],  // 58.194.8.0-58.194.9.255, GD
        [ 0x3AC20A00, 0x3AC20BFF, "JS" ],  // 58.194.10.0-58.194.11.255, JS
        [ 0x3AC20C00, 0x3AC20FFF, "GD" ],  // 58.194.12.0-58.194.15.255, GD
        [ 0x3AC21000, 0x3AC217FF, "JS" ],  // 58.194.16.0-58.194.23.255, JS
        [ 0x3AC21800, 0x3AC21FFF, "GD" ],  // 58.194.24.0-58.194.31.255, GD
        [ 0x3AC22000, 0x3AC23FFF, "LN" ],  // 58.194.32.0-58.194.63.255, LN
        [ 0x3AC24000, 0x3AC25FFF, "SH" ],  // 58.194.64.0-58.194.95.255, SH
        [ 0x3AC26000, 0x3AC277FF, "TJ" ],  // 58.194.96.0-58.194.119.255, TJ
        [ 0x3AC27800, 0x3AC27FFF, "HL" ],  // 58.194.120.0-58.194.127.255, HL
        [ 0x3AC28000, 0x3AC28FFF, "NX" ],  // 58.194.128.0-58.194.143.255, NX
        [ 0x3AC29000, 0x3AC29FFF, "BJ" ],  // 58.194.144.0-58.194.159.255, BJ
        [ 0x3AC2A000, 0x3AC2D7FF, "SD" ],  // 58.194.160.0-58.194.215.255, SD
        [ 0x3AC2D800, 0x3AC2FFFF, "BJ" ],  // 58.194.216.0-58.194.255.255, BJ
        [ 0x3AC30000, 0x3AC307FF, "HB" ],  // 58.195.0.0-58.195.7.255, HB
        [ 0x3AC30800, 0x3AC30FFF, "BJ" ],  // 58.195.8.0-58.195.15.255, BJ
        [ 0x3AC31000, 0x3AC31FFF, "SD" ],  // 58.195.16.0-58.195.31.255, SD
        [ 0x3AC32000, 0x3AC33FFF, "FJ" ],  // 58.195.32.0-58.195.63.255, FJ
        [ 0x3AC34000, 0x3AC352FF, "BJ" ],  // 58.195.64.0-58.195.82.255, BJ
        [ 0x3AC35300, 0x3AC353FF, "XJ" ],  // 58.195.83.0-58.195.83.255, XJ
        [ 0x3AC35400, 0x3AC3563F, "BJ" ],  // 58.195.84.0-58.195.86.63, BJ
        [ 0x3AC35640, 0x3AC358FF, "SD" ],  // 58.195.86.64-58.195.88.255, SD
        [ 0x3AC35900, 0x3AC361FF, "BJ" ],  // 58.195.89.0-58.195.97.255, BJ
        [ 0x3AC36200, 0x3AC362FF, "GD" ],  // 58.195.98.0-58.195.98.255, GD
        [ 0x3AC36300, 0x3AC363FF, "JX" ],  // 58.195.99.0-58.195.99.255, JX
        [ 0x3AC36400, 0x3AC364FF, "BJ" ],  // 58.195.100.0-58.195.100.255, BJ
        [ 0x3AC36500, 0x3AC36617, "YN" ],  // 58.195.101.0-58.195.102.23, YN
        [ 0x3AC36618, 0x3AC3661B, "FJ" ],  // 58.195.102.24-58.195.102.27, FJ
        [ 0x3AC3661C, 0x3AC3662F, "BJ" ],  // 58.195.102.28-58.195.102.47, BJ
        [ 0x3AC36630, 0x3AC36633, "AH" ],  // 58.195.102.48-58.195.102.51, AH
        [ 0x3AC36634, 0x3AC36637, "JX" ],  // 58.195.102.52-58.195.102.55, JX
        [ 0x3AC36638, 0x3AC3667F, "BJ" ],  // 58.195.102.56-58.195.102.127, BJ
        [ 0x3AC36680, 0x3AC36687, "XJ" ],  // 58.195.102.128-58.195.102.135, XJ
        [ 0x3AC36688, 0x3AC3668B, "GZ" ],  // 58.195.102.136-58.195.102.139, GZ
        [ 0x3AC3668C, 0x3AC37FFF, "BJ" ],  // 58.195.102.140-58.195.127.255, BJ
        [ 0x3AC38000, 0x3AC387FF, "SN" ],  // 58.195.128.0-58.195.135.255, SN
        [ 0x3AC38800, 0x3AC39FFF, "SD" ],  // 58.195.136.0-58.195.159.255, SD
        [ 0x3AC3A000, 0x3AC3F7FF, "HB" ],  // 58.195.160.0-58.195.247.255, HB
        [ 0x3AC3F800, 0x3AC3FFFF, "ZJ" ],  // 58.195.248.0-58.195.255.255, ZJ
        [ 0x3AC40000, 0x3AC4FFFF, "SH" ],  // 58.196.0.0-58.196.255.255, SH
        [ 0x3AC50000, 0x3AC521FF, "JS" ],  // 58.197.0.0-58.197.33.255, JS
        [ 0x3AC52200, 0x3AC5FFFF, "BJ" ],  // 58.197.34.0-58.197.255.255, BJ
        [ 0x3AC60000, 0x3AC6FFFF, "SH" ],  // 58.198.0.0-58.198.255.255, SH
        [ 0x3AC70000, 0x3AC77FFF, "FJ" ],  // 58.199.0.0-58.199.127.255, FJ
        [ 0x3AC78000, 0x3AC7BFFF, "SH" ],  // 58.199.128.0-58.199.191.255, SH
        [ 0x3AC7C000, 0x3AC7FFFF, "FJ" ],  // 58.199.192.0-58.199.255.255, FJ
        [ 0x3AC80000, 0x3AC800FF, "JS" ],  // 58.200.0.0-58.200.0.255, JS
        [ 0x3AC80100, 0x3AC801FF, "GD" ],  // 58.200.1.0-58.200.1.255, GD
        [ 0x3AC80200, 0x3AC802FF, "BJ" ],  // 58.200.2.0-58.200.2.255, BJ
        [ 0x3AC80300, 0x3AC803FF, "LN" ],  // 58.200.3.0-58.200.3.255, LN
        [ 0x3AC80400, 0x3AC804FF, "TJ" ],  // 58.200.4.0-58.200.4.255, TJ
        [ 0x3AC80500, 0x3AC805FF, "JS" ],  // 58.200.5.0-58.200.5.255, JS
        [ 0x3AC80600, 0x3AC806FF, "HE" ],  // 58.200.6.0-58.200.6.255, HE
        [ 0x3AC80700, 0x3AC8077F, "JS" ],  // 58.200.7.0-58.200.7.127, JS
        [ 0x3AC80780, 0x3AC807FF, "SC" ],  // 58.200.7.128-58.200.7.255, SC
        [ 0x3AC80800, 0x3AC809FF, "HA" ],  // 58.200.8.0-58.200.9.255, HA
        [ 0x3AC80A00, 0x3AC80AFF, "CQ" ],  // 58.200.10.0-58.200.10.255, CQ
        [ 0x3AC80B00, 0x3AC80BFF, "SH" ],  // 58.200.11.0-58.200.11.255, SH
        [ 0x3AC80C00, 0x3AC80CFF, "TJ" ],  // 58.200.12.0-58.200.12.255, TJ
        [ 0x3AC80D00, 0x3AC80DFF, "BJ" ],  // 58.200.13.0-58.200.13.255, BJ
        [ 0x3AC80E00, 0x3AC80FFF, "ZJ" ],  // 58.200.14.0-58.200.15.255, ZJ
        [ 0x3AC81000, 0x3AC810FF, "BJ" ],  // 58.200.16.0-58.200.16.255, BJ
        [ 0x3AC81100, 0x3AC811FF, "SC" ],  // 58.200.17.0-58.200.17.255, SC
        [ 0x3AC81200, 0x3AC813FF, "BJ" ],  // 58.200.18.0-58.200.19.255, BJ
        [ 0x3AC81400, 0x3AC814FF, "FJ" ],  // 58.200.20.0-58.200.20.255, FJ
        [ 0x3AC81500, 0x3AC817FF, "BJ" ],  // 58.200.21.0-58.200.23.255, BJ
        [ 0x3AC81800, 0x3AC818FF, "SD" ],  // 58.200.24.0-58.200.24.255, SD
        [ 0x3AC81900, 0x3AC81DFF, "AH" ],  // 58.200.25.0-58.200.29.255, AH
        [ 0x3AC81E00, 0x3AC81EFF, "SD" ],  // 58.200.30.0-58.200.30.255, SD
        [ 0x3AC81F00, 0x3AC81FFF, "LN" ],  // 58.200.31.0-58.200.31.255, LN
        [ 0x3AC82000, 0x3AC83FFF, "BJ" ],  // 58.200.32.0-58.200.63.255, BJ
        [ 0x3AC84000, 0x3AC8407F, "SD" ],  // 58.200.64.0-58.200.64.127, SD
        [ 0x3AC84080, 0x3AC840FF, "JS" ],  // 58.200.64.128-58.200.64.255, JS
        [ 0x3AC84100, 0x3AC842FF, "BJ" ],  // 58.200.65.0-58.200.66.255, BJ
        [ 0x3AC84300, 0x3AC844FF, "JX" ],  // 58.200.67.0-58.200.68.255, JX
        [ 0x3AC84500, 0x3AC848FF, "BJ" ],  // 58.200.69.0-58.200.72.255, BJ
        [ 0x3AC84900, 0x3AC84AFF, "JS" ],  // 58.200.73.0-58.200.74.255, JS
        [ 0x3AC84B00, 0x3AC84BFF, "LN" ],  // 58.200.75.0-58.200.75.255, LN
        [ 0x3AC84C00, 0x3AC84CFF, "BJ" ],  // 58.200.76.0-58.200.76.255, BJ
        [ 0x3AC84D00, 0x3AC84DFF, "LN" ],  // 58.200.77.0-58.200.77.255, LN
        [ 0x3AC84E00, 0x3AC84E7F, "JS" ],  // 58.200.78.0-58.200.78.127, JS
        [ 0x3AC84E80, 0x3AC84FFF, "GD" ],  // 58.200.78.128-58.200.79.255, GD
        [ 0x3AC85000, 0x3AC8507F, "JS" ],  // 58.200.80.0-58.200.80.127, JS
        [ 0x3AC85080, 0x3AC850FF, "BJ" ],  // 58.200.80.128-58.200.80.255, BJ
        [ 0x3AC85100, 0x3AC851FF, "SD" ],  // 58.200.81.0-58.200.81.255, SD
        [ 0x3AC85200, 0x3AC857FF, "CQ" ],  // 58.200.82.0-58.200.87.255, CQ
        [ 0x3AC85800, 0x3AC85FFF, "BJ" ],  // 58.200.88.0-58.200.95.255, BJ
        [ 0x3AC86000, 0x3AC8607F, "JS" ],  // 58.200.96.0-58.200.96.127, JS
        [ 0x3AC86080, 0x3AC861FF, "BJ" ],  // 58.200.96.128-58.200.97.255, BJ
        [ 0x3AC86200, 0x3AC862FF, "ZJ" ],  // 58.200.98.0-58.200.98.255, ZJ
        [ 0x3AC86300, 0x3AC863FF, "BJ" ],  // 58.200.99.0-58.200.99.255, BJ
        [ 0x3AC86400, 0x3AC864FF, "ZJ" ],  // 58.200.100.0-58.200.100.255, ZJ
        [ 0x3AC86500, 0x3AC867FF, "BJ" ],  // 58.200.101.0-58.200.103.255, BJ
        [ 0x3AC86800, 0x3AC868FF, "FJ" ],  // 58.200.104.0-58.200.104.255, FJ
        [ 0x3AC86900, 0x3AC869FF, "JS" ],  // 58.200.105.0-58.200.105.255, JS
        [ 0x3AC86A00, 0x3AC86AFF, "SH" ],  // 58.200.106.0-58.200.106.255, SH
        [ 0x3AC86B00, 0x3AC86CFF, "BJ" ],  // 58.200.107.0-58.200.108.255, BJ
        [ 0x3AC86D00, 0x3AC86DFF, "SH" ],  // 58.200.109.0-58.200.109.255, SH
        [ 0x3AC86E00, 0x3AC86FFF, "JS" ],  // 58.200.110.0-58.200.111.255, JS
        [ 0x3AC87000, 0x3AC870FF, "TJ" ],  // 58.200.112.0-58.200.112.255, TJ
        [ 0x3AC87100, 0x3AC874FF, "JS" ],  // 58.200.113.0-58.200.116.255, JS
        [ 0x3AC87500, 0x3AC876FF, "BJ" ],  // 58.200.117.0-58.200.118.255, BJ
        [ 0x3AC87700, 0x3AC877FF, "SC" ],  // 58.200.119.0-58.200.119.255, SC
        [ 0x3AC87800, 0x3AC878FF, "SX" ],  // 58.200.120.0-58.200.120.255, SX
        [ 0x3AC87900, 0x3AC87BFF, "BJ" ],  // 58.200.121.0-58.200.123.255, BJ
        [ 0x3AC87C00, 0x3AC87CFF, "GD" ],  // 58.200.124.0-58.200.124.255, GD
        [ 0x3AC87D00, 0x3AC87EFF, "BJ" ],  // 58.200.125.0-58.200.126.255, BJ
        [ 0x3AC87F00, 0x3AC87FFF, "HB" ],  // 58.200.127.0-58.200.127.255, HB
        [ 0x3AC88000, 0x3AC89AFF, "BJ" ],  // 58.200.128.0-58.200.154.255, BJ
        [ 0x3AC89B00, 0x3AC89BFF, "AH" ],  // 58.200.155.0-58.200.155.255, AH
        [ 0x3AC89C00, 0x3ACDBFFF, "BJ" ],  // 58.200.156.0-58.205.191.255, BJ
        [ 0x3ACDC000, 0x3ACDC7FF, "GD" ],  // 58.205.192.0-58.205.199.255, GD
        [ 0x3ACDC800, 0x3ACDCFFF, "ZJ" ],  // 58.205.200.0-58.205.207.255, ZJ
        [ 0x3ACDD000, 0x3ACDD7FF, "SH" ],  // 58.205.208.0-58.205.215.255, SH
        [ 0x3ACDD800, 0x3ACDDBFF, "BJ" ],  // 58.205.216.0-58.205.219.255, BJ
        [ 0x3ACDDC00, 0x3ACDFFFF, "HB" ],  // 58.205.220.0-58.205.255.255, HB
        [ 0x3ACE0000, 0x3ACE1FFF, "SC" ],  // 58.206.0.0-58.206.31.255, SC
        [ 0x3ACE2000, 0x3ACE3FFF, "GD" ],  // 58.206.32.0-58.206.63.255, GD
        [ 0x3ACE4000, 0x3ACE5FFF, "LN" ],  // 58.206.64.0-58.206.95.255, LN
        [ 0x3ACE6000, 0x3ACE7FFF, "SN" ],  // 58.206.96.0-58.206.127.255, SN
        [ 0x3ACE8000, 0x3ACE9FFF, "TJ" ],  // 58.206.128.0-58.206.159.255, TJ
        [ 0x3ACEA000, 0x3ACEBFFF, "GS" ],  // 58.206.160.0-58.206.191.255, GS
        [ 0x3ACEC000, 0x3ACEDFFF, "ZJ" ],  // 58.206.192.0-58.206.223.255, ZJ
        [ 0x3ACEE000, 0x3ACF0FFF, "BJ" ],  // 58.206.224.0-58.207.15.255, BJ
        [ 0x3ACF1000, 0x3ACF1DFF, "SH" ],  // 58.207.16.0-58.207.29.255, SH
        [ 0x3ACF1E00, 0x3ACF1EFF, "ZJ" ],  // 58.207.30.0-58.207.30.255, ZJ
        [ 0x3ACF1F00, 0x3ACF27FF, "SH" ],  // 58.207.31.0-58.207.39.255, SH
        [ 0x3ACF2800, 0x3ACF2FFF, "GS" ],  // 58.207.40.0-58.207.47.255, GS
        [ 0x3ACF3000, 0x3ACF3FFF, "AH" ],  // 58.207.48.0-58.207.63.255, AH
        [ 0x3ACF4000, 0x3ACF43FF, "XJ" ],  // 58.207.64.0-58.207.67.255, XJ
        [ 0x3ACF4400, 0x3ACF47FF, "SD" ],  // 58.207.68.0-58.207.71.255, SD
        [ 0x3ACF4800, 0x3ACF4FFF, "YN" ],  // 58.207.72.0-58.207.79.255, YN
        [ 0x3ACF5000, 0x3ACF5FFF, "CQ" ],  // 58.207.80.0-58.207.95.255, CQ
        [ 0x3ACF6000, 0x3ACF77FF, "JS" ],  // 58.207.96.0-58.207.119.255, JS
        [ 0x3ACF7800, 0x3ACF7FFF, "HN" ],  // 58.207.120.0-58.207.127.255, HN
        [ 0x3ACF8000, 0x3ACF8FFF, "GD" ],  // 58.207.128.0-58.207.143.255, GD
        [ 0x3ACF9000, 0x3ACF9FFF, "HB" ],  // 58.207.144.0-58.207.159.255, HB
        [ 0x3ACFA000, 0x3ACFAFFF, "LN" ],  // 58.207.160.0-58.207.175.255, LN
        [ 0x3ACFB000, 0x3ACFC7FF, "SN" ],  // 58.207.176.0-58.207.199.255, SN
        [ 0x3ACFC800, 0x3ACFDFFF, "HA" ],  // 58.207.200.0-58.207.223.255, HA
        [ 0x3ACFE000, 0x3ACFF7FF, "HE" ],  // 58.207.224.0-58.207.247.255, HE
        [ 0x3ACFF800, 0x3ACFFFFF, "HN" ],  // 58.207.248.0-58.207.255.255, HN
        [ 0x3AD00000, 0x3ADAE9FF, "JS" ],  // 58.208.0.0-58.218.233.255, JS
        [ 0x3ADAEA00, 0x3ADAEAFF, "GD" ],  // 58.218.234.0-58.218.234.255, GD
        [ 0x3ADAEB00, 0x3ADFFFFF, "JS" ],  // 58.218.235.0-58.223.255.255, JS
        [ 0x3AF00000, 0x3AF1FFFF, "JS" ],  // 58.240.0.0-58.241.255.255, JS
        [ 0x3AF20000, 0x3AF3FFFF, "AH" ],  // 58.242.0.0-58.243.255.255, AH
        [ 0x3AF40000, 0x3AF5FFFF, "JL" ],  // 58.244.0.0-58.245.255.255, JL
        [ 0x3AF60000, 0x3AF7FFFF, "SH" ],  // 58.246.0.0-58.247.255.255, SH
        [ 0x3AF80000, 0x3AFFFFFF, "GD" ],  // 58.248.0.0-58.255.255.255, GD
        [ 0x3B200000, 0x3B2AFFFF, "GD" ],  // 59.32.0.0-59.42.255.255, GD
        [ 0x3B2B0000, 0x3B2B00FF, "HB" ],  // 59.43.0.0-59.43.0.255, HB
        [ 0x3B2B0100, 0x3B2B0235, "BJ" ],  // 59.43.1.0-59.43.2.53, BJ
        [ 0x3B2B0236, 0x3B2B0236, "SN" ],  // 59.43.2.54-59.43.2.54, SN
        [ 0x3B2B0237, 0x3B2B0260, "BJ" ],  // 59.43.2.55-59.43.2.96, BJ
        [ 0x3B2B0261, 0x3B2B0261, "NX" ],  // 59.43.2.97-59.43.2.97, NX
        [ 0x3B2B0262, 0x3B2B0299, "BJ" ],  // 59.43.2.98-59.43.2.153, BJ
        [ 0x3B2B029A, 0x3B2B029A, "GD" ],  // 59.43.2.154-59.43.2.154, GD
        [ 0x3B2B029B, 0x3B2B029B, "BJ" ],  // 59.43.2.155-59.43.2.155, BJ
        [ 0x3B2B029C, 0x3B2B029F, "GD" ],  // 59.43.2.156-59.43.2.159, GD
        [ 0x3B2B02A0, 0x3B2B02A1, "BJ" ],  // 59.43.2.160-59.43.2.161, BJ
        [ 0x3B2B02A2, 0x3B2B02A2, "JS" ],  // 59.43.2.162-59.43.2.162, JS
        [ 0x3B2B02A3, 0x3B2B02A9, "BJ" ],  // 59.43.2.163-59.43.2.169, BJ
        [ 0x3B2B02AA, 0x3B2B02AA, "SH" ],  // 59.43.2.170-59.43.2.170, SH
        [ 0x3B2B02AB, 0x3B2B03FF, "SC" ],  // 59.43.2.171-59.43.3.255, SC
        [ 0x3B2B0400, 0x3B2B0F11, "BJ" ],  // 59.43.4.0-59.43.15.17, BJ
        [ 0x3B2B0F12, 0x3B2B0F12, "SH" ],  // 59.43.15.18-59.43.15.18, SH
        [ 0x3B2B0F13, 0x3B2B0F28, "BJ" ],  // 59.43.15.19-59.43.15.40, BJ
        [ 0x3B2B0F29, 0x3B2B0F29, "JS" ],  // 59.43.15.41-59.43.15.41, JS
        [ 0x3B2B0F2A, 0x3B2B10FF, "GD" ],  // 59.43.15.42-59.43.16.255, GD
        [ 0x3B2B1100, 0x3B2B11FF, "BJ" ],  // 59.43.17.0-59.43.17.255, BJ
        [ 0x3B2B1200, 0x3B2B12FF, "SH" ],  // 59.43.18.0-59.43.18.255, SH
        [ 0x3B2B1300, 0x3B2B13FF, "GD" ],  // 59.43.19.0-59.43.19.255, GD
        [ 0x3B2B1400, 0x3B2B14FF, "SC" ],  // 59.43.20.0-59.43.20.255, SC
        [ 0x3B2B1500, 0x3B2B15FF, "BJ" ],  // 59.43.21.0-59.43.21.255, BJ
        [ 0x3B2B1600, 0x3B2B16FF, "HB" ],  // 59.43.22.0-59.43.22.255, HB
        [ 0x3B2B1700, 0x3B2B18FF, "BJ" ],  // 59.43.23.0-59.43.24.255, BJ
        [ 0x3B2B1900, 0x3B2B19FF, "ZJ" ],  // 59.43.25.0-59.43.25.255, ZJ
        [ 0x3B2B1A00, 0x3B2B1AFF, "GD" ],  // 59.43.26.0-59.43.26.255, GD
        [ 0x3B2B1B00, 0x3B2B1EFF, "BJ" ],  // 59.43.27.0-59.43.30.255, BJ
        [ 0x3B2B1F00, 0x3B2B1F03, "GD" ],  // 59.43.31.0-59.43.31.3, GD
        [ 0x3B2B1F04, 0x3B2B1F08, "BJ" ],  // 59.43.31.4-59.43.31.8, BJ
        [ 0x3B2B1F09, 0x3B2B1F09, "GD" ],  // 59.43.31.9-59.43.31.9, GD
        [ 0x3B2B1F0A, 0x3B2B1F0C, "BJ" ],  // 59.43.31.10-59.43.31.12, BJ
        [ 0x3B2B1F0D, 0x3B2B1F0D, "GD" ],  // 59.43.31.13-59.43.31.13, GD
        [ 0x3B2B1F0E, 0x3B2B1F10, "BJ" ],  // 59.43.31.14-59.43.31.16, BJ
        [ 0x3B2B1F11, 0x3B2B1F11, "GD" ],  // 59.43.31.17-59.43.31.17, GD
        [ 0x3B2B1F12, 0x3B2B1F14, "BJ" ],  // 59.43.31.18-59.43.31.20, BJ
        [ 0x3B2B1F15, 0x3B2B1F15, "GD" ],  // 59.43.31.21-59.43.31.21, GD
        [ 0x3B2B1F16, 0x3B2B1F18, "BJ" ],  // 59.43.31.22-59.43.31.24, BJ
        [ 0x3B2B1F19, 0x3B2B1F19, "GD" ],  // 59.43.31.25-59.43.31.25, GD
        [ 0x3B2B1F1A, 0x3B2B1F1D, "BJ" ],  // 59.43.31.26-59.43.31.29, BJ
        [ 0x3B2B1F1E, 0x3B2B1F1E, "GD" ],  // 59.43.31.30-59.43.31.30, GD
        [ 0x3B2B1F1F, 0x3B2B1F31, "BJ" ],  // 59.43.31.31-59.43.31.49, BJ
        [ 0x3B2B1F32, 0x3B2B1F32, "GD" ],  // 59.43.31.50-59.43.31.50, GD
        [ 0x3B2B1F33, 0x3B2B1F3D, "BJ" ],  // 59.43.31.51-59.43.31.61, BJ
        [ 0x3B2B1F3E, 0x3B2B1F66, "GD" ],  // 59.43.31.62-59.43.31.102, GD
        [ 0x3B2B1F67, 0x3B2B1F69, "BJ" ],  // 59.43.31.103-59.43.31.105, BJ
        [ 0x3B2B1F6A, 0x3B2B1F6A, "GD" ],  // 59.43.31.106-59.43.31.106, GD
        [ 0x3B2B1F6B, 0x3B2B1F6D, "BJ" ],  // 59.43.31.107-59.43.31.109, BJ
        [ 0x3B2B1F6E, 0x3B2B1F6E, "GD" ],  // 59.43.31.110-59.43.31.110, GD
        [ 0x3B2B1F6F, 0x3B2B1F70, "BJ" ],  // 59.43.31.111-59.43.31.112, BJ
        [ 0x3B2B1F71, 0x3B2B1F71, "GD" ],  // 59.43.31.113-59.43.31.113, GD
        [ 0x3B2B1F72, 0x3B2B1F94, "BJ" ],  // 59.43.31.114-59.43.31.148, BJ
        [ 0x3B2B1F95, 0x3B2B1F95, "GD" ],  // 59.43.31.149-59.43.31.149, GD
        [ 0x3B2B1F96, 0x3B2B1FF1, "BJ" ],  // 59.43.31.150-59.43.31.241, BJ
        [ 0x3B2B1FF2, 0x3B2B1FF2, "GD" ],  // 59.43.31.242-59.43.31.242, GD
        [ 0x3B2B1FF3, 0x3B2B24FF, "BJ" ],  // 59.43.31.243-59.43.36.255, BJ
        [ 0x3B2B2500, 0x3B2B25FF, "GD" ],  // 59.43.37.0-59.43.37.255, GD
        [ 0x3B2B2600, 0x3B2B26FF, "BJ" ],  // 59.43.38.0-59.43.38.255, BJ
        [ 0x3B2B2700, 0x3B2B271D, "GD" ],  // 59.43.39.0-59.43.39.29, GD
        [ 0x3B2B271E, 0x3B2B271E, "SH" ],  // 59.43.39.30-59.43.39.30, SH
        [ 0x3B2B271F, 0x3B2B2945, "BJ" ],  // 59.43.39.31-59.43.41.69, BJ
        [ 0x3B2B2946, 0x3B2B2946, "GX" ],  // 59.43.41.70-59.43.41.70, GX
        [ 0x3B2B2947, 0x3B2B29FF, "GD" ],  // 59.43.41.71-59.43.41.255, GD
        [ 0x3B2B2A00, 0x3B2B2A03, "SC" ],  // 59.43.42.0-59.43.42.3, SC
        [ 0x3B2B2A04, 0x3B2B2A05, "GD" ],  // 59.43.42.4-59.43.42.5, GD
        [ 0x3B2B2A06, 0x3B2B2A06, "SC" ],  // 59.43.42.6-59.43.42.6, SC
        [ 0x3B2B2A07, 0x3B2B2A08, "GD" ],  // 59.43.42.7-59.43.42.8, GD
        [ 0x3B2B2A09, 0x3B2B2A09, "SC" ],  // 59.43.42.9-59.43.42.9, SC
        [ 0x3B2B2A0A, 0x3B2B2A0C, "GD" ],  // 59.43.42.10-59.43.42.12, GD
        [ 0x3B2B2A0D, 0x3B2B2A0D, "SC" ],  // 59.43.42.13-59.43.42.13, SC
        [ 0x3B2B2A0E, 0x3B2B2A10, "GD" ],  // 59.43.42.14-59.43.42.16, GD
        [ 0x3B2B2A11, 0x3B2B2A11, "SC" ],  // 59.43.42.17-59.43.42.17, SC
        [ 0x3B2B2A12, 0x3B2B2A14, "GD" ],  // 59.43.42.18-59.43.42.20, GD
        [ 0x3B2B2A15, 0x3B2B2A15, "SC" ],  // 59.43.42.21-59.43.42.21, SC
        [ 0x3B2B2A16, 0x3B2B2A18, "GD" ],  // 59.43.42.22-59.43.42.24, GD
        [ 0x3B2B2A19, 0x3B2B2A19, "SC" ],  // 59.43.42.25-59.43.42.25, SC
        [ 0x3B2B2A1A, 0x3B2B2A20, "GD" ],  // 59.43.42.26-59.43.42.32, GD
        [ 0x3B2B2A21, 0x3B2B2A21, "SC" ],  // 59.43.42.33-59.43.42.33, SC
        [ 0x3B2B2A22, 0x3B2B2A24, "GD" ],  // 59.43.42.34-59.43.42.36, GD
        [ 0x3B2B2A25, 0x3B2B2A25, "SC" ],  // 59.43.42.37-59.43.42.37, SC
        [ 0x3B2B2A26, 0x3B2B2A27, "GD" ],  // 59.43.42.38-59.43.42.39, GD
        [ 0x3B2B2A28, 0x3B2B2A2B, "SC" ],  // 59.43.42.40-59.43.42.43, SC
        [ 0x3B2B2A2C, 0x3B2B2A2D, "GD" ],  // 59.43.42.44-59.43.42.45, GD
        [ 0x3B2B2A2E, 0x3B2B2A2E, "SC" ],  // 59.43.42.46-59.43.42.46, SC
        [ 0x3B2B2A2F, 0x3B2B2A35, "GD" ],  // 59.43.42.47-59.43.42.53, GD
        [ 0x3B2B2A36, 0x3B2B2A36, "SC" ],  // 59.43.42.54-59.43.42.54, SC
        [ 0x3B2B2A37, 0x3B2B2A5C, "GD" ],  // 59.43.42.55-59.43.42.92, GD
        [ 0x3B2B2A5D, 0x3B2B2A5D, "SC" ],  // 59.43.42.93-59.43.42.93, SC
        [ 0x3B2B2A5E, 0x3B2B2A61, "GD" ],  // 59.43.42.94-59.43.42.97, GD
        [ 0x3B2B2A62, 0x3B2B2A62, "SC" ],  // 59.43.42.98-59.43.42.98, SC
        [ 0x3B2B2A63, 0x3B2B2A87, "GD" ],  // 59.43.42.99-59.43.42.135, GD
        [ 0x3B2B2A88, 0x3B2B2A8F, "SC" ],  // 59.43.42.136-59.43.42.143, SC
        [ 0x3B2B2A90, 0x3B2B2FFF, "GD" ],  // 59.43.42.144-59.43.47.255, GD
        [ 0x3B2B3000, 0x3B2B31FF, "BJ" ],  // 59.43.48.0-59.43.49.255, BJ
        [ 0x3B2B3200, 0x3B2B33FF, "GD" ],  // 59.43.50.0-59.43.51.255, GD
        [ 0x3B2B3400, 0x3B2B3403, "SH" ],  // 59.43.52.0-59.43.52.3, SH
        [ 0x3B2B3404, 0x3B2B3407, "GD" ],  // 59.43.52.4-59.43.52.7, GD
        [ 0x3B2B3408, 0x3B2B3417, "SH" ],  // 59.43.52.8-59.43.52.23, SH
        [ 0x3B2B3418, 0x3B2B341F, "GD" ],  // 59.43.52.24-59.43.52.31, GD
        [ 0x3B2B3420, 0x3B2B3423, "SH" ],  // 59.43.52.32-59.43.52.35, SH
        [ 0x3B2B3424, 0x3B2B3424, "GD" ],  // 59.43.52.36-59.43.52.36, GD
        [ 0x3B2B3425, 0x3B2B3425, "SH" ],  // 59.43.52.37-59.43.52.37, SH
        [ 0x3B2B3426, 0x3B2B3EFF, "GD" ],  // 59.43.52.38-59.43.62.255, GD
        [ 0x3B2B3F00, 0x3B2B3F07, "SC" ],  // 59.43.63.0-59.43.63.7, SC
        [ 0x3B2B3F08, 0x3B2B3F34, "GD" ],  // 59.43.63.8-59.43.63.52, GD
        [ 0x3B2B3F35, 0x3B2B3F35, "SC" ],  // 59.43.63.53-59.43.63.53, SC
        [ 0x3B2B3F36, 0x3B2B3F48, "GD" ],  // 59.43.63.54-59.43.63.72, GD
        [ 0x3B2B3F49, 0x3B2B3F49, "SC" ],  // 59.43.63.73-59.43.63.73, SC
        [ 0x3B2B3F4A, 0x3B2B3F4C, "GD" ],  // 59.43.63.74-59.43.63.76, GD
        [ 0x3B2B3F4D, 0x3B2B3F4D, "SC" ],  // 59.43.63.77-59.43.63.77, SC
        [ 0x3B2B3F4E, 0x3B2B3FFF, "GD" ],  // 59.43.63.78-59.43.63.255, GD
        [ 0x3B2B4000, 0x3B2B40FF, "JS" ],  // 59.43.64.0-59.43.64.255, JS
        [ 0x3B2B4100, 0x3B2B41FF, "ZJ" ],  // 59.43.65.0-59.43.65.255, ZJ
        [ 0x3B2B4200, 0x3B2B42FF, "AH" ],  // 59.43.66.0-59.43.66.255, AH
        [ 0x3B2B4300, 0x3B2B43FF, "JX" ],  // 59.43.67.0-59.43.67.255, JX
        [ 0x3B2B4400, 0x3B2B44FF, "HB" ],  // 59.43.68.0-59.43.68.255, HB
        [ 0x3B2B4500, 0x3B2B45FF, "HN" ],  // 59.43.69.0-59.43.69.255, HN
        [ 0x3B2B4600, 0x3B2B46FF, "GD" ],  // 59.43.70.0-59.43.70.255, GD
        [ 0x3B2B4700, 0x3B2B47FF, "GX" ],  // 59.43.71.0-59.43.71.255, GX
        [ 0x3B2B4800, 0x3B2B48FF, "SC" ],  // 59.43.72.0-59.43.72.255, SC
        [ 0x3B2B4900, 0x3B2B4901, "BJ" ],  // 59.43.73.0-59.43.73.1, BJ
        [ 0x3B2B4902, 0x3B2B4902, "YN" ],  // 59.43.73.2-59.43.73.2, YN
        [ 0x3B2B4903, 0x3B2B4AFF, "FJ" ],  // 59.43.73.3-59.43.74.255, FJ
        [ 0x3B2B4B00, 0x3B2B4BFF, "GS" ],  // 59.43.75.0-59.43.75.255, GS
        [ 0x3B2B4C00, 0x3B2B4CFF, "GD" ],  // 59.43.76.0-59.43.76.255, GD
        [ 0x3B2B4D00, 0x3B2B4D41, "BJ" ],  // 59.43.77.0-59.43.77.65, BJ
        [ 0x3B2B4D42, 0x3B2B4D42, "TJ" ],  // 59.43.77.66-59.43.77.66, TJ
        [ 0x3B2B4D43, 0x3B2B4D45, "BJ" ],  // 59.43.77.67-59.43.77.69, BJ
        [ 0x3B2B4D46, 0x3B2B4D46, "TJ" ],  // 59.43.77.70-59.43.77.70, TJ
        [ 0x3B2B4D47, 0x3B2B4D81, "BJ" ],  // 59.43.77.71-59.43.77.129, BJ
        [ 0x3B2B4D82, 0x3B2B4D9F, "SH" ],  // 59.43.77.130-59.43.77.159, SH
        [ 0x3B2B4DA0, 0x3B2B4DFF, "BJ" ],  // 59.43.77.160-59.43.77.255, BJ
        [ 0x3B2B4E00, 0x3B2B4FFF, "GD" ],  // 59.43.78.0-59.43.79.255, GD
        [ 0x3B2B5000, 0x3B2B5007, "BJ" ],  // 59.43.80.0-59.43.80.7, BJ
        [ 0x3B2B5008, 0x3B2B500F, "SH" ],  // 59.43.80.8-59.43.80.15, SH
        [ 0x3B2B5010, 0x3B2B5017, "GD" ],  // 59.43.80.16-59.43.80.23, GD
        [ 0x3B2B5018, 0x3B2B501B, "BJ" ],  // 59.43.80.24-59.43.80.27, BJ
        [ 0x3B2B501C, 0x3B2B501F, "SH" ],  // 59.43.80.28-59.43.80.31, SH
        [ 0x3B2B5020, 0x3B2B5021, "BJ" ],  // 59.43.80.32-59.43.80.33, BJ
        [ 0x3B2B5022, 0x3B2B5022, "GD" ],  // 59.43.80.34-59.43.80.34, GD
        [ 0x3B2B5023, 0x3B2B5024, "BJ" ],  // 59.43.80.35-59.43.80.36, BJ
        [ 0x3B2B5025, 0x3B2B5025, "HB" ],  // 59.43.80.37-59.43.80.37, HB
        [ 0x3B2B5026, 0x3B2B5028, "BJ" ],  // 59.43.80.38-59.43.80.40, BJ
        [ 0x3B2B5029, 0x3B2B5029, "HB" ],  // 59.43.80.41-59.43.80.41, HB
        [ 0x3B2B502A, 0x3B2B5031, "BJ" ],  // 59.43.80.42-59.43.80.49, BJ
        [ 0x3B2B5032, 0x3B2B5032, "SH" ],  // 59.43.80.50-59.43.80.50, SH
        [ 0x3B2B5033, 0x3B2B5033, "BJ" ],  // 59.43.80.51-59.43.80.51, BJ
        [ 0x3B2B5034, 0x3B2B5037, "JS" ],  // 59.43.80.52-59.43.80.55, JS
        [ 0x3B2B5038, 0x3B2B5038, "BJ" ],  // 59.43.80.56-59.43.80.56, BJ
        [ 0x3B2B5039, 0x3B2B5039, "JS" ],  // 59.43.80.57-59.43.80.57, JS
        [ 0x3B2B503A, 0x3B2B503C, "BJ" ],  // 59.43.80.58-59.43.80.60, BJ
        [ 0x3B2B503D, 0x3B2B503D, "SC" ],  // 59.43.80.61-59.43.80.61, SC
        [ 0x3B2B503E, 0x3B2B5040, "BJ" ],  // 59.43.80.62-59.43.80.64, BJ
        [ 0x3B2B5041, 0x3B2B5041, "SC" ],  // 59.43.80.65-59.43.80.65, SC
        [ 0x3B2B5042, 0x3B2B5044, "BJ" ],  // 59.43.80.66-59.43.80.68, BJ
        [ 0x3B2B5045, 0x3B2B5045, "SN" ],  // 59.43.80.69-59.43.80.69, SN
        [ 0x3B2B5046, 0x3B2B5047, "BJ" ],  // 59.43.80.70-59.43.80.71, BJ
        [ 0x3B2B5048, 0x3B2B504B, "SN" ],  // 59.43.80.72-59.43.80.75, SN
        [ 0x3B2B504C, 0x3B2B5073, "SH" ],  // 59.43.80.76-59.43.80.115, SH
        [ 0x3B2B5074, 0x3B2B5077, "GD" ],  // 59.43.80.116-59.43.80.119, GD
        [ 0x3B2B5078, 0x3B2B507F, "SH" ],  // 59.43.80.120-59.43.80.127, SH
        [ 0x3B2B5080, 0x3B2B5B08, "BJ" ],  // 59.43.80.128-59.43.91.8, BJ
        [ 0x3B2B5B09, 0x3B2B5B09, "SH" ],  // 59.43.91.9-59.43.91.9, SH
        [ 0x3B2B5B0A, 0x3B2B5B0C, "BJ" ],  // 59.43.91.10-59.43.91.12, BJ
        [ 0x3B2B5B0D, 0x3B2B5B0D, "SH" ],  // 59.43.91.13-59.43.91.13, SH
        [ 0x3B2B5B0E, 0x3B2B5B3B, "BJ" ],  // 59.43.91.14-59.43.91.59, BJ
        [ 0x3B2B5B3C, 0x3B2B5B4B, "SN" ],  // 59.43.91.60-59.43.91.75, SN
        [ 0x3B2B5B4C, 0x3B2B5B63, "BJ" ],  // 59.43.91.76-59.43.91.99, BJ
        [ 0x3B2B5B64, 0x3B2B5B67, "SH" ],  // 59.43.91.100-59.43.91.103, SH
        [ 0x3B2B5B68, 0x3B2B5B68, "BJ" ],  // 59.43.91.104-59.43.91.104, BJ
        [ 0x3B2B5B69, 0x3B2B5B6A, "SH" ],  // 59.43.91.105-59.43.91.106, SH
        [ 0x3B2B5B6B, 0x3B2B5B6B, "BJ" ],  // 59.43.91.107-59.43.91.107, BJ
        [ 0x3B2B5B6C, 0x3B2B5B83, "SH" ],  // 59.43.91.108-59.43.91.131, SH
        [ 0x3B2B5B84, 0x3B2B5B84, "BJ" ],  // 59.43.91.132-59.43.91.132, BJ
        [ 0x3B2B5B85, 0x3B2B5B85, "SN" ],  // 59.43.91.133-59.43.91.133, SN
        [ 0x3B2B5B86, 0x3B2B5B88, "BJ" ],  // 59.43.91.134-59.43.91.136, BJ
        [ 0x3B2B5B89, 0x3B2B5B89, "SN" ],  // 59.43.91.137-59.43.91.137, SN
        [ 0x3B2B5B8A, 0x3B2B5B8C, "BJ" ],  // 59.43.91.138-59.43.91.140, BJ
        [ 0x3B2B5B8D, 0x3B2B5B8D, "SN" ],  // 59.43.91.141-59.43.91.141, SN
        [ 0x3B2B5B8E, 0x3B2B5B8F, "BJ" ],  // 59.43.91.142-59.43.91.143, BJ
        [ 0x3B2B5B90, 0x3B2B5B93, "SN" ],  // 59.43.91.144-59.43.91.147, SN
        [ 0x3B2B5B94, 0x3B2B5B94, "BJ" ],  // 59.43.91.148-59.43.91.148, BJ
        [ 0x3B2B5B95, 0x3B2B5B95, "SN" ],  // 59.43.91.149-59.43.91.149, SN
        [ 0x3B2B5B96, 0x3B2B5B98, "BJ" ],  // 59.43.91.150-59.43.91.152, BJ
        [ 0x3B2B5B99, 0x3B2B5B99, "SN" ],  // 59.43.91.153-59.43.91.153, SN
        [ 0x3B2B5B9A, 0x3B2B5B9C, "BJ" ],  // 59.43.91.154-59.43.91.156, BJ
        [ 0x3B2B5B9D, 0x3B2B5B9D, "SN" ],  // 59.43.91.157-59.43.91.157, SN
        [ 0x3B2B5B9E, 0x3B2B5BA0, "BJ" ],  // 59.43.91.158-59.43.91.160, BJ
        [ 0x3B2B5BA1, 0x3B2B5BA1, "SN" ],  // 59.43.91.161-59.43.91.161, SN
        [ 0x3B2B5BA2, 0x3B2B5BA4, "BJ" ],  // 59.43.91.162-59.43.91.164, BJ
        [ 0x3B2B5BA5, 0x3B2B5BA5, "SN" ],  // 59.43.91.165-59.43.91.165, SN
        [ 0x3B2B5BA6, 0x3B2B5BA8, "BJ" ],  // 59.43.91.166-59.43.91.168, BJ
        [ 0x3B2B5BA9, 0x3B2B5BA9, "SN" ],  // 59.43.91.169-59.43.91.169, SN
        [ 0x3B2B5BAA, 0x3B2B5BAC, "BJ" ],  // 59.43.91.170-59.43.91.172, BJ
        [ 0x3B2B5BAD, 0x3B2B5BAD, "SN" ],  // 59.43.91.173-59.43.91.173, SN
        [ 0x3B2B5BAE, 0x3B2B5BC0, "BJ" ],  // 59.43.91.174-59.43.91.192, BJ
        [ 0x3B2B5BC1, 0x3B2B5BC1, "GD" ],  // 59.43.91.193-59.43.91.193, GD
        [ 0x3B2B5BC2, 0x3B2B5BC4, "BJ" ],  // 59.43.91.194-59.43.91.196, BJ
        [ 0x3B2B5BC5, 0x3B2B5BC5, "GD" ],  // 59.43.91.197-59.43.91.197, GD
        [ 0x3B2B5BC6, 0x3B2B5BC9, "BJ" ],  // 59.43.91.198-59.43.91.201, BJ
        [ 0x3B2B5BCA, 0x3B2B5BCA, "SH" ],  // 59.43.91.202-59.43.91.202, SH
        [ 0x3B2B5BCB, 0x3B2B5BCB, "BJ" ],  // 59.43.91.203-59.43.91.203, BJ
        [ 0x3B2B5BCC, 0x3B2B5BCF, "SH" ],  // 59.43.91.204-59.43.91.207, SH
        [ 0x3B2B5BD0, 0x3B2B5BF5, "BJ" ],  // 59.43.91.208-59.43.91.245, BJ
        [ 0x3B2B5BF6, 0x3B2B5BF6, "SH" ],  // 59.43.91.246-59.43.91.246, SH
        [ 0x3B2B5BF7, 0x3B2B5CFF, "YN" ],  // 59.43.91.247-59.43.92.255, YN
        [ 0x3B2B5D00, 0x3B2B5E2B, "GD" ],  // 59.43.93.0-59.43.94.43, GD
        [ 0x3B2B5E2C, 0x3B2B5E37, "JS" ],  // 59.43.94.44-59.43.94.55, JS
        [ 0x3B2B5E38, 0x3B2B5E39, "BJ" ],  // 59.43.94.56-59.43.94.57, BJ
        [ 0x3B2B5E3A, 0x3B2B5E3A, "JS" ],  // 59.43.94.58-59.43.94.58, JS
        [ 0x3B2B5E3B, 0x3B2B5E3F, "BJ" ],  // 59.43.94.59-59.43.94.63, BJ
        [ 0x3B2B5E40, 0x3B2B5E43, "JS" ],  // 59.43.94.64-59.43.94.67, JS
        [ 0x3B2B5E44, 0x3B2B5E47, "BJ" ],  // 59.43.94.68-59.43.94.71, BJ
        [ 0x3B2B5E48, 0x3B2B5E4F, "JS" ],  // 59.43.94.72-59.43.94.79, JS
        [ 0x3B2B5E50, 0x3B2B5E5C, "BJ" ],  // 59.43.94.80-59.43.94.92, BJ
        [ 0x3B2B5E5D, 0x3B2B5E5D, "FJ" ],  // 59.43.94.93-59.43.94.93, FJ
        [ 0x3B2B5E5E, 0x3B2B5E60, "BJ" ],  // 59.43.94.94-59.43.94.96, BJ
        [ 0x3B2B5E61, 0x3B2B5E61, "FJ" ],  // 59.43.94.97-59.43.94.97, FJ
        [ 0x3B2B5E62, 0x3B2B5E67, "BJ" ],  // 59.43.94.98-59.43.94.103, BJ
        [ 0x3B2B5E68, 0x3B2B5E73, "FJ" ],  // 59.43.94.104-59.43.94.115, FJ
        [ 0x3B2B5E74, 0x3B2B5E7B, "BJ" ],  // 59.43.94.116-59.43.94.123, BJ
        [ 0x3B2B5E7C, 0x3B2B5E7F, "SN" ],  // 59.43.94.124-59.43.94.127, SN
        [ 0x3B2B5E80, 0x3B2B5E83, "BJ" ],  // 59.43.94.128-59.43.94.131, BJ
        [ 0x3B2B5E84, 0x3B2B5E8F, "SN" ],  // 59.43.94.132-59.43.94.143, SN
        [ 0x3B2B5E90, 0x3B2B5EA5, "BJ" ],  // 59.43.94.144-59.43.94.165, BJ
        [ 0x3B2B5EA6, 0x3B2B5EA7, "SN" ],  // 59.43.94.166-59.43.94.167, SN
        [ 0x3B2B5EA8, 0x3B2B5EC1, "BJ" ],  // 59.43.94.168-59.43.94.193, BJ
        [ 0x3B2B5EC2, 0x3B2B5EC2, "HB" ],  // 59.43.94.194-59.43.94.194, HB
        [ 0x3B2B5EC3, 0x3B2B6030, "BJ" ],  // 59.43.94.195-59.43.96.48, BJ
        [ 0x3B2B6031, 0x3B2B6031, "SN" ],  // 59.43.96.49-59.43.96.49, SN
        [ 0x3B2B6032, 0x3B2B6034, "BJ" ],  // 59.43.96.50-59.43.96.52, BJ
        [ 0x3B2B6035, 0x3B2B6035, "SN" ],  // 59.43.96.53-59.43.96.53, SN
        [ 0x3B2B6036, 0x3B2B604F, "BJ" ],  // 59.43.96.54-59.43.96.79, BJ
        [ 0x3B2B6050, 0x3B2B605F, "HB" ],  // 59.43.96.80-59.43.96.95, HB
        [ 0x3B2B6060, 0x3B2B6065, "BJ" ],  // 59.43.96.96-59.43.96.101, BJ
        [ 0x3B2B6066, 0x3B2B6066, "GD" ],  // 59.43.96.102-59.43.96.102, GD
        [ 0x3B2B6067, 0x3B2B6067, "BJ" ],  // 59.43.96.103-59.43.96.103, BJ
        [ 0x3B2B6068, 0x3B2B606F, "GD" ],  // 59.43.96.104-59.43.96.111, GD
        [ 0x3B2B6070, 0x3B2B6070, "BJ" ],  // 59.43.96.112-59.43.96.112, BJ
        [ 0x3B2B6071, 0x3B2B6071, "SN" ],  // 59.43.96.113-59.43.96.113, SN
        [ 0x3B2B6072, 0x3B2B6074, "BJ" ],  // 59.43.96.114-59.43.96.116, BJ
        [ 0x3B2B6075, 0x3B2B6075, "SN" ],  // 59.43.96.117-59.43.96.117, SN
        [ 0x3B2B6076, 0x3B2B6078, "BJ" ],  // 59.43.96.118-59.43.96.120, BJ
        [ 0x3B2B6079, 0x3B2B6079, "GD" ],  // 59.43.96.121-59.43.96.121, GD
        [ 0x3B2B607A, 0x3B2B607C, "BJ" ],  // 59.43.96.122-59.43.96.124, BJ
        [ 0x3B2B607D, 0x3B2B607D, "SC" ],  // 59.43.96.125-59.43.96.125, SC
        [ 0x3B2B607E, 0x3B2B6080, "BJ" ],  // 59.43.96.126-59.43.96.128, BJ
        [ 0x3B2B6081, 0x3B2B6081, "SC" ],  // 59.43.96.129-59.43.96.129, SC
        [ 0x3B2B6082, 0x3B2B6090, "BJ" ],  // 59.43.96.130-59.43.96.144, BJ
        [ 0x3B2B6091, 0x3B2B6091, "SH" ],  // 59.43.96.145-59.43.96.145, SH
        [ 0x3B2B6092, 0x3B2B6094, "BJ" ],  // 59.43.96.146-59.43.96.148, BJ
        [ 0x3B2B6095, 0x3B2B6095, "SH" ],  // 59.43.96.149-59.43.96.149, SH
        [ 0x3B2B6096, 0x3B2B6098, "BJ" ],  // 59.43.96.150-59.43.96.152, BJ
        [ 0x3B2B6099, 0x3B2B6099, "SH" ],  // 59.43.96.153-59.43.96.153, SH
        [ 0x3B2B609A, 0x3B2B609A, "SC" ],  // 59.43.96.154-59.43.96.154, SC
        [ 0x3B2B609B, 0x3B2B609C, "BJ" ],  // 59.43.96.155-59.43.96.156, BJ
        [ 0x3B2B609D, 0x3B2B609D, "SH" ],  // 59.43.96.157-59.43.96.157, SH
        [ 0x3B2B609E, 0x3B2B609E, "SC" ],  // 59.43.96.158-59.43.96.158, SC
        [ 0x3B2B609F, 0x3B2B60B0, "BJ" ],  // 59.43.96.159-59.43.96.176, BJ
        [ 0x3B2B60B1, 0x3B2B6211, "GD" ],  // 59.43.96.177-59.43.98.17, GD
        [ 0x3B2B6212, 0x3B2B6214, "BJ" ],  // 59.43.98.18-59.43.98.20, BJ
        [ 0x3B2B6215, 0x3B2B6215, "SH" ],  // 59.43.98.21-59.43.98.21, SH
        [ 0x3B2B6216, 0x3B2B6218, "BJ" ],  // 59.43.98.22-59.43.98.24, BJ
        [ 0x3B2B6219, 0x3B2B6219, "SH" ],  // 59.43.98.25-59.43.98.25, SH
        [ 0x3B2B621A, 0x3B2B6224, "BJ" ],  // 59.43.98.26-59.43.98.36, BJ
        [ 0x3B2B6225, 0x3B2B6225, "SH" ],  // 59.43.98.37-59.43.98.37, SH
        [ 0x3B2B6226, 0x3B2B6226, "HB" ],  // 59.43.98.38-59.43.98.38, HB
        [ 0x3B2B6227, 0x3B2B6228, "BJ" ],  // 59.43.98.39-59.43.98.40, BJ
        [ 0x3B2B6229, 0x3B2B6229, "SH" ],  // 59.43.98.41-59.43.98.41, SH
        [ 0x3B2B622A, 0x3B2B622A, "HB" ],  // 59.43.98.42-59.43.98.42, HB
        [ 0x3B2B622B, 0x3B2B622C, "BJ" ],  // 59.43.98.43-59.43.98.44, BJ
        [ 0x3B2B622D, 0x3B2B622D, "GD" ],  // 59.43.98.45-59.43.98.45, GD
        [ 0x3B2B622E, 0x3B2B622E, "HB" ],  // 59.43.98.46-59.43.98.46, HB
        [ 0x3B2B622F, 0x3B2B6230, "BJ" ],  // 59.43.98.47-59.43.98.48, BJ
        [ 0x3B2B6231, 0x3B2B6231, "GD" ],  // 59.43.98.49-59.43.98.49, GD
        [ 0x3B2B6232, 0x3B2B6232, "HB" ],  // 59.43.98.50-59.43.98.50, HB
        [ 0x3B2B6233, 0x3B2B6244, "BJ" ],  // 59.43.98.51-59.43.98.68, BJ
        [ 0x3B2B6245, 0x3B2B6245, "GD" ],  // 59.43.98.69-59.43.98.69, GD
        [ 0x3B2B6246, 0x3B2B6248, "BJ" ],  // 59.43.98.70-59.43.98.72, BJ
        [ 0x3B2B6249, 0x3B2B6249, "GD" ],  // 59.43.98.73-59.43.98.73, GD
        [ 0x3B2B624A, 0x3B2B624B, "BJ" ],  // 59.43.98.74-59.43.98.75, BJ
        [ 0x3B2B624C, 0x3B2B624F, "GD" ],  // 59.43.98.76-59.43.98.79, GD
        [ 0x3B2B6250, 0x3B2B62A5, "BJ" ],  // 59.43.98.80-59.43.98.165, BJ
        [ 0x3B2B62A6, 0x3B2B62A6, "GD" ],  // 59.43.98.166-59.43.98.166, GD
        [ 0x3B2B62A7, 0x3B2B62A9, "BJ" ],  // 59.43.98.167-59.43.98.169, BJ
        [ 0x3B2B62AA, 0x3B2B62AA, "GD" ],  // 59.43.98.170-59.43.98.170, GD
        [ 0x3B2B62AB, 0x3B2B62CC, "BJ" ],  // 59.43.98.171-59.43.98.204, BJ
        [ 0x3B2B62CD, 0x3B2B62CD, "GD" ],  // 59.43.98.205-59.43.98.205, GD
        [ 0x3B2B62CE, 0x3B2B62CE, "FJ" ],  // 59.43.98.206-59.43.98.206, FJ
        [ 0x3B2B62CF, 0x3B2B62D0, "BJ" ],  // 59.43.98.207-59.43.98.208, BJ
        [ 0x3B2B62D1, 0x3B2B62D1, "GD" ],  // 59.43.98.209-59.43.98.209, GD
        [ 0x3B2B62D2, 0x3B2B62D2, "FJ" ],  // 59.43.98.210-59.43.98.210, FJ
        [ 0x3B2B62D3, 0x3B2B63FF, "SC" ],  // 59.43.98.211-59.43.99.255, SC
        [ 0x3B2B6400, 0x3B2B6514, "YN" ],  // 59.43.100.0-59.43.101.20, YN
        [ 0x3B2B6515, 0x3B2B6515, "SC" ],  // 59.43.101.21-59.43.101.21, SC
        [ 0x3B2B6516, 0x3B2B652B, "BJ" ],  // 59.43.101.22-59.43.101.43, BJ
        [ 0x3B2B652C, 0x3B2B6533, "SC" ],  // 59.43.101.44-59.43.101.51, SC
        [ 0x3B2B6534, 0x3B2B65EC, "BJ" ],  // 59.43.101.52-59.43.101.236, BJ
        [ 0x3B2B65ED, 0x3B2B65ED, "SH" ],  // 59.43.101.237-59.43.101.237, SH
        [ 0x3B2B65EE, 0x3B2B6928, "BJ" ],  // 59.43.101.238-59.43.105.40, BJ
        [ 0x3B2B6929, 0x3B2B6929, "SC" ],  // 59.43.105.41-59.43.105.41, SC
        [ 0x3B2B692A, 0x3B2B693D, "BJ" ],  // 59.43.105.42-59.43.105.61, BJ
        [ 0x3B2B693E, 0x3B2B693E, "GD" ],  // 59.43.105.62-59.43.105.62, GD
        [ 0x3B2B693F, 0x3B2B6948, "BJ" ],  // 59.43.105.63-59.43.105.72, BJ
        [ 0x3B2B6949, 0x3B2B6949, "SH" ],  // 59.43.105.73-59.43.105.73, SH
        [ 0x3B2B694A, 0x3B2B694A, "GD" ],  // 59.43.105.74-59.43.105.74, GD
        [ 0x3B2B694B, 0x3B2B694C, "BJ" ],  // 59.43.105.75-59.43.105.76, BJ
        [ 0x3B2B694D, 0x3B2B694D, "SH" ],  // 59.43.105.77-59.43.105.77, SH
        [ 0x3B2B694E, 0x3B2B694E, "GD" ],  // 59.43.105.78-59.43.105.78, GD
        [ 0x3B2B694F, 0x3B2B6954, "BJ" ],  // 59.43.105.79-59.43.105.84, BJ
        [ 0x3B2B6955, 0x3B2B6955, "SH" ],  // 59.43.105.85-59.43.105.85, SH
        [ 0x3B2B6956, 0x3B2B6956, "GD" ],  // 59.43.105.86-59.43.105.86, GD
        [ 0x3B2B6957, 0x3B2B6968, "BJ" ],  // 59.43.105.87-59.43.105.104, BJ
        [ 0x3B2B6969, 0x3B2B6969, "JS" ],  // 59.43.105.105-59.43.105.105, JS
        [ 0x3B2B696A, 0x3B2B6972, "BJ" ],  // 59.43.105.106-59.43.105.114, BJ
        [ 0x3B2B6973, 0x3B2B6973, "JS" ],  // 59.43.105.115-59.43.105.115, JS
        [ 0x3B2B6974, 0x3B2B697C, "BJ" ],  // 59.43.105.116-59.43.105.124, BJ
        [ 0x3B2B697D, 0x3B2B697D, "JS" ],  // 59.43.105.125-59.43.105.125, JS
        [ 0x3B2B697E, 0x3B2B699C, "BJ" ],  // 59.43.105.126-59.43.105.156, BJ
        [ 0x3B2B699D, 0x3B2B699D, "JS" ],  // 59.43.105.157-59.43.105.157, JS
        [ 0x3B2B699E, 0x3B2B699E, "BJ" ],  // 59.43.105.158-59.43.105.158, BJ
        [ 0x3B2B699F, 0x3B2B699F, "JS" ],  // 59.43.105.159-59.43.105.159, JS
        [ 0x3B2B69A0, 0x3B2B69DC, "BJ" ],  // 59.43.105.160-59.43.105.220, BJ
        [ 0x3B2B69DD, 0x3B2B69DD, "SN" ],  // 59.43.105.221-59.43.105.221, SN
        [ 0x3B2B69DE, 0x3B2B69EC, "BJ" ],  // 59.43.105.222-59.43.105.236, BJ
        [ 0x3B2B69ED, 0x3B2B69ED, "SN" ],  // 59.43.105.237-59.43.105.237, SN
        [ 0x3B2B69EE, 0x3B2B6AFF, "FJ" ],  // 59.43.105.238-59.43.106.255, FJ
        [ 0x3B2B6B00, 0x3B2B6C47, "BJ" ],  // 59.43.107.0-59.43.108.71, BJ
        [ 0x3B2B6C48, 0x3B2B6C4B, "GD" ],  // 59.43.108.72-59.43.108.75, GD
        [ 0x3B2B6C4C, 0x3B2B6C4C, "BJ" ],  // 59.43.108.76-59.43.108.76, BJ
        [ 0x3B2B6C4D, 0x3B2B6C4D, "GD" ],  // 59.43.108.77-59.43.108.77, GD
        [ 0x3B2B6C4E, 0x3B2B6C53, "BJ" ],  // 59.43.108.78-59.43.108.83, BJ
        [ 0x3B2B6C54, 0x3B2B6C57, "GD" ],  // 59.43.108.84-59.43.108.87, GD
        [ 0x3B2B6C58, 0x3B2B6C58, "BJ" ],  // 59.43.108.88-59.43.108.88, BJ
        [ 0x3B2B6C59, 0x3B2B6C59, "GD" ],  // 59.43.108.89-59.43.108.89, GD
        [ 0x3B2B6C5A, 0x3B2B6C60, "BJ" ],  // 59.43.108.90-59.43.108.96, BJ
        [ 0x3B2B6C61, 0x3B2B6C61, "SH" ],  // 59.43.108.97-59.43.108.97, SH
        [ 0x3B2B6C62, 0x3B2B6C9C, "BJ" ],  // 59.43.108.98-59.43.108.156, BJ
        [ 0x3B2B6C9D, 0x3B2B6E51, "GD" ],  // 59.43.108.157-59.43.110.81, GD
        [ 0x3B2B6E52, 0x3B2B6E52, "JS" ],  // 59.43.110.82-59.43.110.82, JS
        [ 0x3B2B6E53, 0x3B2B6E60, "BJ" ],  // 59.43.110.83-59.43.110.96, BJ
        [ 0x3B2B6E61, 0x3B2B6E61, "GD" ],  // 59.43.110.97-59.43.110.97, GD
        [ 0x3B2B6E62, 0x3B2B6E69, "BJ" ],  // 59.43.110.98-59.43.110.105, BJ
        [ 0x3B2B6E6A, 0x3B2B6E6A, "SC" ],  // 59.43.110.106-59.43.110.106, SC
        [ 0x3B2B6E6B, 0x3B2B6E6B, "BJ" ],  // 59.43.110.107-59.43.110.107, BJ
        [ 0x3B2B6E6C, 0x3B2B6E6F, "SC" ],  // 59.43.110.108-59.43.110.111, SC
        [ 0x3B2B6E70, 0x3B2B6E73, "BJ" ],  // 59.43.110.112-59.43.110.115, BJ
        [ 0x3B2B6E74, 0x3B2B6E7F, "SN" ],  // 59.43.110.116-59.43.110.127, SN
        [ 0x3B2B6E80, 0x3B2B6E8B, "BJ" ],  // 59.43.110.128-59.43.110.139, BJ
        [ 0x3B2B6E8C, 0x3B2B6E8F, "SN" ],  // 59.43.110.140-59.43.110.143, SN
        [ 0x3B2B6E90, 0x3B2B6EA8, "BJ" ],  // 59.43.110.144-59.43.110.168, BJ
        [ 0x3B2B6EA9, 0x3B2B6EA9, "GD" ],  // 59.43.110.169-59.43.110.169, GD
        [ 0x3B2B6EAA, 0x3B2B6ED8, "BJ" ],  // 59.43.110.170-59.43.110.216, BJ
        [ 0x3B2B6ED9, 0x3B2B6ED9, "GD" ],  // 59.43.110.217-59.43.110.217, GD
        [ 0x3B2B6EDA, 0x3B2B7390, "BJ" ],  // 59.43.110.218-59.43.115.144, BJ
        [ 0x3B2B7391, 0x3B2B7391, "GD" ],  // 59.43.115.145-59.43.115.145, GD
        [ 0x3B2B7392, 0x3B2B7394, "BJ" ],  // 59.43.115.146-59.43.115.148, BJ
        [ 0x3B2B7395, 0x3B2B7395, "GD" ],  // 59.43.115.149-59.43.115.149, GD
        [ 0x3B2B7396, 0x3B2B7397, "BJ" ],  // 59.43.115.150-59.43.115.151, BJ
        [ 0x3B2B7398, 0x3B2B739F, "GD" ],  // 59.43.115.152-59.43.115.159, GD
        [ 0x3B2B73A0, 0x3B2B7510, "JX" ],  // 59.43.115.160-59.43.117.16, JX
        [ 0x3B2B7511, 0x3B2B7511, "HB" ],  // 59.43.117.17-59.43.117.17, HB
        [ 0x3B2B7512, 0x3B2B7514, "BJ" ],  // 59.43.117.18-59.43.117.20, BJ
        [ 0x3B2B7515, 0x3B2B7515, "HB" ],  // 59.43.117.21-59.43.117.21, HB
        [ 0x3B2B7516, 0x3B2B7518, "BJ" ],  // 59.43.117.22-59.43.117.24, BJ
        [ 0x3B2B7519, 0x3B2B7519, "HB" ],  // 59.43.117.25-59.43.117.25, HB
        [ 0x3B2B751A, 0x3B2B751C, "BJ" ],  // 59.43.117.26-59.43.117.28, BJ
        [ 0x3B2B751D, 0x3B2B751D, "HB" ],  // 59.43.117.29-59.43.117.29, HB
        [ 0x3B2B751E, 0x3B2B7528, "BJ" ],  // 59.43.117.30-59.43.117.40, BJ
        [ 0x3B2B7529, 0x3B2B7529, "HB" ],  // 59.43.117.41-59.43.117.41, HB
        [ 0x3B2B752A, 0x3B2B752C, "BJ" ],  // 59.43.117.42-59.43.117.44, BJ
        [ 0x3B2B752D, 0x3B2B752D, "HB" ],  // 59.43.117.45-59.43.117.45, HB
        [ 0x3B2B752E, 0x3B2B7530, "BJ" ],  // 59.43.117.46-59.43.117.48, BJ
        [ 0x3B2B7531, 0x3B2B7531, "HB" ],  // 59.43.117.49-59.43.117.49, HB
        [ 0x3B2B7532, 0x3B2B7534, "BJ" ],  // 59.43.117.50-59.43.117.52, BJ
        [ 0x3B2B7535, 0x3B2B7535, "HB" ],  // 59.43.117.53-59.43.117.53, HB
        [ 0x3B2B7536, 0x3B2B7558, "BJ" ],  // 59.43.117.54-59.43.117.88, BJ
        [ 0x3B2B7559, 0x3B2B7559, "HB" ],  // 59.43.117.89-59.43.117.89, HB
        [ 0x3B2B755A, 0x3B2B755C, "BJ" ],  // 59.43.117.90-59.43.117.92, BJ
        [ 0x3B2B755D, 0x3B2B755D, "HB" ],  // 59.43.117.93-59.43.117.93, HB
        [ 0x3B2B755E, 0x3B2B7560, "BJ" ],  // 59.43.117.94-59.43.117.96, BJ
        [ 0x3B2B7561, 0x3B2B7561, "HB" ],  // 59.43.117.97-59.43.117.97, HB
        [ 0x3B2B7562, 0x3B2B756F, "BJ" ],  // 59.43.117.98-59.43.117.111, BJ
        [ 0x3B2B7570, 0x3B2B7587, "HB" ],  // 59.43.117.112-59.43.117.135, HB
        [ 0x3B2B7588, 0x3B2B75B8, "BJ" ],  // 59.43.117.136-59.43.117.184, BJ
        [ 0x3B2B75B9, 0x3B2B75B9, "HB" ],  // 59.43.117.185-59.43.117.185, HB
        [ 0x3B2B75BA, 0x3B2B75BC, "BJ" ],  // 59.43.117.186-59.43.117.188, BJ
        [ 0x3B2B75BD, 0x3B2B75BD, "HB" ],  // 59.43.117.189-59.43.117.189, HB
        [ 0x3B2B75BE, 0x3B2B75C0, "BJ" ],  // 59.43.117.190-59.43.117.192, BJ
        [ 0x3B2B75C1, 0x3B2B75C1, "HB" ],  // 59.43.117.193-59.43.117.193, HB
        [ 0x3B2B75C2, 0x3B2B75C4, "BJ" ],  // 59.43.117.194-59.43.117.196, BJ
        [ 0x3B2B75C5, 0x3B2B75C5, "HB" ],  // 59.43.117.197-59.43.117.197, HB
        [ 0x3B2B75C6, 0x3B2B75CF, "BJ" ],  // 59.43.117.198-59.43.117.207, BJ
        [ 0x3B2B75D0, 0x3B2B75E3, "HB" ],  // 59.43.117.208-59.43.117.227, HB
        [ 0x3B2B75E4, 0x3B2B75E4, "BJ" ],  // 59.43.117.228-59.43.117.228, BJ
        [ 0x3B2B75E5, 0x3B2B75E5, "HB" ],  // 59.43.117.229-59.43.117.229, HB
        [ 0x3B2B75E6, 0x3B2B75E8, "BJ" ],  // 59.43.117.230-59.43.117.232, BJ
        [ 0x3B2B75E9, 0x3B2B75E9, "HB" ],  // 59.43.117.233-59.43.117.233, HB
        [ 0x3B2B75EA, 0x3B2B75EC, "BJ" ],  // 59.43.117.234-59.43.117.236, BJ
        [ 0x3B2B75ED, 0x3B2B75ED, "HB" ],  // 59.43.117.237-59.43.117.237, HB
        [ 0x3B2B75EE, 0x3B2B75EF, "BJ" ],  // 59.43.117.238-59.43.117.239, BJ
        [ 0x3B2B75F0, 0x3B2B75F3, "HB" ],  // 59.43.117.240-59.43.117.243, HB
        [ 0x3B2B75F4, 0x3B2B75F4, "BJ" ],  // 59.43.117.244-59.43.117.244, BJ
        [ 0x3B2B75F5, 0x3B2B75F5, "HB" ],  // 59.43.117.245-59.43.117.245, HB
        [ 0x3B2B75F6, 0x3B2B75F8, "BJ" ],  // 59.43.117.246-59.43.117.248, BJ
        [ 0x3B2B75F9, 0x3B2B75F9, "HB" ],  // 59.43.117.249-59.43.117.249, HB
        [ 0x3B2B75FA, 0x3B2B75FC, "BJ" ],  // 59.43.117.250-59.43.117.252, BJ
        [ 0x3B2B75FD, 0x3B2B75FD, "HB" ],  // 59.43.117.253-59.43.117.253, HB
        [ 0x3B2B75FE, 0x3B2B75FF, "BJ" ],  // 59.43.117.254-59.43.117.255, BJ
        [ 0x3B2B7600, 0x3B2B7603, "HB" ],  // 59.43.118.0-59.43.118.3, HB
        [ 0x3B2B7604, 0x3B2B7604, "SC" ],  // 59.43.118.4-59.43.118.4, SC
        [ 0x3B2B7605, 0x3B2B7605, "HB" ],  // 59.43.118.5-59.43.118.5, HB
        [ 0x3B2B7606, 0x3B2B7618, "SC" ],  // 59.43.118.6-59.43.118.24, SC
        [ 0x3B2B7619, 0x3B2B7619, "HB" ],  // 59.43.118.25-59.43.118.25, HB
        [ 0x3B2B761A, 0x3B2B761C, "SC" ],  // 59.43.118.26-59.43.118.28, SC
        [ 0x3B2B761D, 0x3B2B761D, "HB" ],  // 59.43.118.29-59.43.118.29, HB
        [ 0x3B2B761E, 0x3B2B7630, "SC" ],  // 59.43.118.30-59.43.118.48, SC
        [ 0x3B2B7631, 0x3B2B7631, "HB" ],  // 59.43.118.49-59.43.118.49, HB
        [ 0x3B2B7632, 0x3B2B7634, "SC" ],  // 59.43.118.50-59.43.118.52, SC
        [ 0x3B2B7635, 0x3B2B7635, "HB" ],  // 59.43.118.53-59.43.118.53, HB
        [ 0x3B2B7636, 0x3B2B7638, "SC" ],  // 59.43.118.54-59.43.118.56, SC
        [ 0x3B2B7639, 0x3B2B7639, "HB" ],  // 59.43.118.57-59.43.118.57, HB
        [ 0x3B2B763A, 0x3B2B763C, "SC" ],  // 59.43.118.58-59.43.118.60, SC
        [ 0x3B2B763D, 0x3B2B763D, "HB" ],  // 59.43.118.61-59.43.118.61, HB
        [ 0x3B2B763E, 0x3B2B7671, "SC" ],  // 59.43.118.62-59.43.118.113, SC
        [ 0x3B2B7672, 0x3B2B7672, "JS" ],  // 59.43.118.114-59.43.118.114, JS
        [ 0x3B2B7673, 0x3B2B7673, "SC" ],  // 59.43.118.115-59.43.118.115, SC
        [ 0x3B2B7674, 0x3B2B767F, "JS" ],  // 59.43.118.116-59.43.118.127, JS
        [ 0x3B2B7680, 0x3B2B768C, "SC" ],  // 59.43.118.128-59.43.118.140, SC
        [ 0x3B2B768D, 0x3B2B768D, "JS" ],  // 59.43.118.141-59.43.118.141, JS
        [ 0x3B2B768E, 0x3B2B78FF, "SC" ],  // 59.43.118.142-59.43.120.255, SC
        [ 0x3B2B7900, 0x3B2B7A10, "BJ" ],  // 59.43.121.0-59.43.122.16, BJ
        [ 0x3B2B7A11, 0x3B2B7A11, "GX" ],  // 59.43.122.17-59.43.122.17, GX
        [ 0x3B2B7A12, 0x3B2B7A29, "BJ" ],  // 59.43.122.18-59.43.122.41, BJ
        [ 0x3B2B7A2A, 0x3B2B7A2A, "GX" ],  // 59.43.122.42-59.43.122.42, GX
        [ 0x3B2B7A2B, 0x3B2B7A2D, "BJ" ],  // 59.43.122.43-59.43.122.45, BJ
        [ 0x3B2B7A2E, 0x3B2B7A2E, "GX" ],  // 59.43.122.46-59.43.122.46, GX
        [ 0x3B2B7A2F, 0x3B2B7AA1, "BJ" ],  // 59.43.122.47-59.43.122.161, BJ
        [ 0x3B2B7AA2, 0x3B2B7AA2, "GX" ],  // 59.43.122.162-59.43.122.162, GX
        [ 0x3B2B7AA3, 0x3B2B7AAD, "BJ" ],  // 59.43.122.163-59.43.122.173, BJ
        [ 0x3B2B7AAE, 0x3B2B7AAE, "SN" ],  // 59.43.122.174-59.43.122.174, SN
        [ 0x3B2B7AAF, 0x3B2B7CBD, "SD" ],  // 59.43.122.175-59.43.124.189, SD
        [ 0x3B2B7CBE, 0x3B2B7CBE, "GD" ],  // 59.43.124.190-59.43.124.190, GD
        [ 0x3B2B7CBF, 0x3B2B7CCB, "BJ" ],  // 59.43.124.191-59.43.124.203, BJ
        [ 0x3B2B7CCC, 0x3B2B7CCF, "GD" ],  // 59.43.124.204-59.43.124.207, GD
        [ 0x3B2B7CD0, 0x3B2B7CD1, "BJ" ],  // 59.43.124.208-59.43.124.209, BJ
        [ 0x3B2B7CD2, 0x3B2B7CD2, "GD" ],  // 59.43.124.210-59.43.124.210, GD
        [ 0x3B2B7CD3, 0x3B2B7CD5, "BJ" ],  // 59.43.124.211-59.43.124.213, BJ
        [ 0x3B2B7CD6, 0x3B2B7CD7, "GD" ],  // 59.43.124.214-59.43.124.215, GD
        [ 0x3B2B7CD8, 0x3B2B7CDB, "BJ" ],  // 59.43.124.216-59.43.124.219, BJ
        [ 0x3B2B7CDC, 0x3B2B7CFB, "GD" ],  // 59.43.124.220-59.43.124.251, GD
        [ 0x3B2B7CFC, 0x3B2B83FF, "BJ" ],  // 59.43.124.252-59.43.131.255, BJ
        [ 0x3B2B8400, 0x3B2B85FF, "GD" ],  // 59.43.132.0-59.43.133.255, GD
        [ 0x3B2B8600, 0x3B2B87FF, "JS" ],  // 59.43.134.0-59.43.135.255, JS
        [ 0x3B2B8800, 0x3B2B8EFF, "AH" ],  // 59.43.136.0-59.43.142.255, AH
        [ 0x3B2B8F00, 0x3B2B8FFF, "JS" ],  // 59.43.143.0-59.43.143.255, JS
        [ 0x3B2B9000, 0x3B2B93FF, "BJ" ],  // 59.43.144.0-59.43.147.255, BJ
        [ 0x3B2B9400, 0x3B2BA153, "GD" ],  // 59.43.148.0-59.43.161.83, GD
        [ 0x3B2BA154, 0x3B2BA163, "HB" ],  // 59.43.161.84-59.43.161.99, HB
        [ 0x3B2BA164, 0x3B2BA168, "BJ" ],  // 59.43.161.100-59.43.161.104, BJ
        [ 0x3B2BA169, 0x3B2BA169, "HB" ],  // 59.43.161.105-59.43.161.105, HB
        [ 0x3B2BA16A, 0x3B2BA18F, "BJ" ],  // 59.43.161.106-59.43.161.143, BJ
        [ 0x3B2BA190, 0x3B2BA19F, "HB" ],  // 59.43.161.144-59.43.161.159, HB
        [ 0x3B2BA1A0, 0x3B2BA2FF, "SN" ],  // 59.43.161.160-59.43.162.255, SN
        [ 0x3B2BA300, 0x3B2BA30B, "BJ" ],  // 59.43.163.0-59.43.163.11, BJ
        [ 0x3B2BA30C, 0x3B2BA317, "SN" ],  // 59.43.163.12-59.43.163.23, SN
        [ 0x3B2BA318, 0x3B2BA338, "BJ" ],  // 59.43.163.24-59.43.163.56, BJ
        [ 0x3B2BA339, 0x3B2BA339, "SN" ],  // 59.43.163.57-59.43.163.57, SN
        [ 0x3B2BA33A, 0x3B2BA347, "BJ" ],  // 59.43.163.58-59.43.163.71, BJ
        [ 0x3B2BA348, 0x3B2BA4FF, "SN" ],  // 59.43.163.72-59.43.164.255, SN
        [ 0x3B2BA500, 0x3B2BD5FF, "BJ" ],  // 59.43.165.0-59.43.213.255, BJ
        [ 0x3B2BD600, 0x3B2BD6FF, "GS" ],  // 59.43.214.0-59.43.214.255, GS
        [ 0x3B2BD700, 0x3B2BD97F, "BJ" ],  // 59.43.215.0-59.43.217.127, BJ
        [ 0x3B2BD980, 0x3B2BD987, "SN" ],  // 59.43.217.128-59.43.217.135, SN
        [ 0x3B2BD988, 0x3B2BDBFF, "SX" ],  // 59.43.217.136-59.43.219.255, SX
        [ 0x3B2BDC00, 0x3B2BDDEC, "JL" ],  // 59.43.220.0-59.43.221.236, JL
        [ 0x3B2BDDED, 0x3B2BDDED, "SN" ],  // 59.43.221.237-59.43.221.237, SN
        [ 0x3B2BDDEE, 0x3B2BDDF4, "BJ" ],  // 59.43.221.238-59.43.221.244, BJ
        [ 0x3B2BDDF5, 0x3B2BDDF5, "SN" ],  // 59.43.221.245-59.43.221.245, SN
        [ 0x3B2BDDF6, 0x3B2BDDF8, "BJ" ],  // 59.43.221.246-59.43.221.248, BJ
        [ 0x3B2BDDF9, 0x3B2BDDF9, "SN" ],  // 59.43.221.249-59.43.221.249, SN
        [ 0x3B2BDDFA, 0x3B2BE110, "BJ" ],  // 59.43.221.250-59.43.225.16, BJ
        [ 0x3B2BE111, 0x3B2BE111, "GD" ],  // 59.43.225.17-59.43.225.17, GD
        [ 0x3B2BE112, 0x3B2BE177, "BJ" ],  // 59.43.225.18-59.43.225.119, BJ
        [ 0x3B2BE178, 0x3B2BE17B, "SN" ],  // 59.43.225.120-59.43.225.123, SN
        [ 0x3B2BE17C, 0x3B2BE1D1, "BJ" ],  // 59.43.225.124-59.43.225.209, BJ
        [ 0x3B2BE1D2, 0x3B2BE1D2, "GD" ],  // 59.43.225.210-59.43.225.210, GD
        [ 0x3B2BE1D3, 0x3B2BE1D3, "BJ" ],  // 59.43.225.211-59.43.225.211, BJ
        [ 0x3B2BE1D4, 0x3B2BE1D7, "GD" ],  // 59.43.225.212-59.43.225.215, GD
        [ 0x3B2BE1D8, 0x3B2BE1E1, "BJ" ],  // 59.43.225.216-59.43.225.225, BJ
        [ 0x3B2BE1E2, 0x3B2BE1E2, "GD" ],  // 59.43.225.226-59.43.225.226, GD
        [ 0x3B2BE1E3, 0x3B2BE1F4, "BJ" ],  // 59.43.225.227-59.43.225.244, BJ
        [ 0x3B2BE1F5, 0x3B2BE1F7, "SH" ],  // 59.43.225.245-59.43.225.247, SH
        [ 0x3B2BE1F8, 0x3B2BE260, "BJ" ],  // 59.43.225.248-59.43.226.96, BJ
        [ 0x3B2BE261, 0x3B2BE267, "SH" ],  // 59.43.226.97-59.43.226.103, SH
        [ 0x3B2BE268, 0x3B2BE26F, "JS" ],  // 59.43.226.104-59.43.226.111, JS
        [ 0x3B2BE270, 0x3B2BE271, "BJ" ],  // 59.43.226.112-59.43.226.113, BJ
        [ 0x3B2BE272, 0x3B2BE272, "JS" ],  // 59.43.226.114-59.43.226.114, JS
        [ 0x3B2BE273, 0x3B2BE2C4, "BJ" ],  // 59.43.226.115-59.43.226.196, BJ
        [ 0x3B2BE2C5, 0x3B2BE2C5, "SH" ],  // 59.43.226.197-59.43.226.197, SH
        [ 0x3B2BE2C6, 0x3B2BE2E8, "BJ" ],  // 59.43.226.198-59.43.226.232, BJ
        [ 0x3B2BE2E9, 0x3B2BE2E9, "SH" ],  // 59.43.226.233-59.43.226.233, SH
        [ 0x3B2BE2EA, 0x3B2BE2EC, "BJ" ],  // 59.43.226.234-59.43.226.236, BJ
        [ 0x3B2BE2ED, 0x3B2BE2ED, "SH" ],  // 59.43.226.237-59.43.226.237, SH
        [ 0x3B2BE2EE, 0x3B2BE2F0, "BJ" ],  // 59.43.226.238-59.43.226.240, BJ
        [ 0x3B2BE2F1, 0x3B2BE2F1, "SH" ],  // 59.43.226.241-59.43.226.241, SH
        [ 0x3B2BE2F2, 0x3B2BE2F4, "BJ" ],  // 59.43.226.242-59.43.226.244, BJ
        [ 0x3B2BE2F5, 0x3B2BE2F5, "SH" ],  // 59.43.226.245-59.43.226.245, SH
        [ 0x3B2BE2F6, 0x3B2BE87F, "BJ" ],  // 59.43.226.246-59.43.232.127, BJ
        [ 0x3B2BE880, 0x3B2BE887, "SN" ],  // 59.43.232.128-59.43.232.135, SN
        [ 0x3B2BE888, 0x3B2BE898, "BJ" ],  // 59.43.232.136-59.43.232.152, BJ
        [ 0x3B2BE899, 0x3B2BE899, "SN" ],  // 59.43.232.153-59.43.232.153, SN
        [ 0x3B2BE89A, 0x3B2BE9FF, "SC" ],  // 59.43.232.154-59.43.233.255, SC
        [ 0x3B2BEA00, 0x3B2BF5FF, "BJ" ],  // 59.43.234.0-59.43.245.255, BJ
        [ 0x3B2BF600, 0x3B2BF6FF, "SH" ],  // 59.43.246.0-59.43.246.255, SH
        [ 0x3B2BF700, 0x3B2BFD03, "BJ" ],  // 59.43.247.0-59.43.253.3, BJ
        [ 0x3B2BFD04, 0x3B2BFD07, "GD" ],  // 59.43.253.4-59.43.253.7, GD
        [ 0x3B2BFD08, 0x3B2BFD29, "BJ" ],  // 59.43.253.8-59.43.253.41, BJ
        [ 0x3B2BFD2A, 0x3B2BFD2A, "GD" ],  // 59.43.253.42-59.43.253.42, GD
        [ 0x3B2BFD2B, 0x3B2BFD31, "BJ" ],  // 59.43.253.43-59.43.253.49, BJ
        [ 0x3B2BFD32, 0x3B2BFD32, "GD" ],  // 59.43.253.50-59.43.253.50, GD
        [ 0x3B2BFD33, 0x3B2BFD5D, "BJ" ],  // 59.43.253.51-59.43.253.93, BJ
        [ 0x3B2BFD5E, 0x3B2BFD5E, "SH" ],  // 59.43.253.94-59.43.253.94, SH
        [ 0x3B2BFD5F, 0x3B2BFF07, "BJ" ],  // 59.43.253.95-59.43.255.7, BJ
        [ 0x3B2BFF08, 0x3B2BFF0B, "SH" ],  // 59.43.255.8-59.43.255.11, SH
        [ 0x3B2BFF0C, 0x3B2BFF13, "GD" ],  // 59.43.255.12-59.43.255.19, GD
        [ 0x3B2BFF14, 0x3B2BFF29, "BJ" ],  // 59.43.255.20-59.43.255.41, BJ
        [ 0x3B2BFF2A, 0x3B2BFF2A, "GD" ],  // 59.43.255.42-59.43.255.42, GD
        [ 0x3B2BFF2B, 0x3B2BFF34, "BJ" ],  // 59.43.255.43-59.43.255.52, BJ
        [ 0x3B2BFF35, 0x3B2BFF35, "SH" ],  // 59.43.255.53-59.43.255.53, SH
        [ 0x3B2BFF36, 0x3B2BFF39, "BJ" ],  // 59.43.255.54-59.43.255.57, BJ
        [ 0x3B2BFF3A, 0x3B2BFF3A, "SH" ],  // 59.43.255.58-59.43.255.58, SH
        [ 0x3B2BFF3B, 0x3B2BFF3D, "BJ" ],  // 59.43.255.59-59.43.255.61, BJ
        [ 0x3B2BFF3E, 0x3B2BFF3E, "SH" ],  // 59.43.255.62-59.43.255.62, SH
        [ 0x3B2BFF3F, 0x3B2BFF41, "BJ" ],  // 59.43.255.63-59.43.255.65, BJ
        [ 0x3B2BFF42, 0x3B2BFF42, "GD" ],  // 59.43.255.66-59.43.255.66, GD
        [ 0x3B2BFF43, 0x3B2BFF6F, "BJ" ],  // 59.43.255.67-59.43.255.111, BJ
        [ 0x3B2BFF70, 0x3B2BFF70, "SH" ],  // 59.43.255.112-59.43.255.112, SH
        [ 0x3B2BFF71, 0x3B2BFF90, "BJ" ],  // 59.43.255.113-59.43.255.144, BJ
        [ 0x3B2BFF91, 0x3B2BFF91, "GD" ],  // 59.43.255.145-59.43.255.145, GD
        [ 0x3B2BFF92, 0x3B2BFFFF, "BJ" ],  // 59.43.255.146-59.43.255.255, BJ
        [ 0x3B2C0000, 0x3B2FFFFF, "LN" ],  // 59.44.0.0-59.47.255.255, LN
        [ 0x3B300000, 0x3B317FFF, "SX" ],  // 59.48.0.0-59.49.127.255, SX
        [ 0x3B318000, 0x3B32FFFF, "HI" ],  // 59.49.128.0-59.50.255.255, HI
        [ 0x3B330000, 0x3B337FFF, "HN" ],  // 59.51.0.0-59.51.127.255, HN
        [ 0x3B338000, 0x3B33FFFF, "GZ" ],  // 59.51.128.0-59.51.255.255, GZ
        [ 0x3B340000, 0x3B37FFFF, "JX" ],  // 59.52.0.0-59.55.255.255, JX
        [ 0x3B380000, 0x3B3DFFFF, "FJ" ],  // 59.56.0.0-59.61.255.255, FJ
        [ 0x3B3E0000, 0x3B3FFFFF, "JX" ],  // 59.62.0.0-59.63.255.255, JX
        [ 0x3B400000, 0x3B42FFFF, "BJ" ],  // 59.64.0.0-59.66.255.255, BJ
        [ 0x3B430000, 0x3B43BFFF, "TJ" ],  // 59.67.0.0-59.67.191.255, TJ
        [ 0x3B43C000, 0x3B43FFFF, "HE" ],  // 59.67.192.0-59.67.255.255, HE
        [ 0x3B440000, 0x3B457FFF, "HB" ],  // 59.68.0.0-59.69.127.255, HB
        [ 0x3B458000, 0x3B45DFFF, "HA" ],  // 59.69.128.0-59.69.223.255, HA
        [ 0x3B45E000, 0x3B45FFFF, "HB" ],  // 59.69.224.0-59.69.255.255, HB
        [ 0x3B460000, 0x3B46CFFF, "HA" ],  // 59.70.0.0-59.70.207.255, HA
        [ 0x3B46D000, 0x3B46DFFF, "HB" ],  // 59.70.208.0-59.70.223.255, HB
        [ 0x3B46E000, 0x3B46FFFF, "HA" ],  // 59.70.224.0-59.70.255.255, HA
        [ 0x3B470000, 0x3B477FFF, "HN" ],  // 59.71.0.0-59.71.127.255, HN
        [ 0x3B478000, 0x3B47FFFF, "HB" ],  // 59.71.128.0-59.71.255.255, HB
        [ 0x3B480000, 0x3B48FFFF, "JL" ],  // 59.72.0.0-59.72.255.255, JL
        [ 0x3B490000, 0x3B49BFFF, "LN" ],  // 59.73.0.0-59.73.191.255, LN
        [ 0x3B49C000, 0x3B49FFFF, "JL" ],  // 59.73.192.0-59.73.255.255, JL
        [ 0x3B4A0000, 0x3B4A29FF, "SN" ],  // 59.74.0.0-59.74.41.255, SN
        [ 0x3B4A2A00, 0x3B4A2AFF, "GD" ],  // 59.74.42.0-59.74.42.255, GD
        [ 0x3B4A2B00, 0x3B4A2BFF, "SN" ],  // 59.74.43.0-59.74.43.255, SN
        [ 0x3B4A2C00, 0x3B4A2DFF, "GD" ],  // 59.74.44.0-59.74.45.255, GD
        [ 0x3B4A2E00, 0x3B4A2EFF, "SN" ],  // 59.74.46.0-59.74.46.255, SN
        [ 0x3B4A2F00, 0x3B4A2FFF, "GD" ],  // 59.74.47.0-59.74.47.255, GD
        [ 0x3B4A3000, 0x3B4ABFFF, "SN" ],  // 59.74.48.0-59.74.191.255, SN
        [ 0x3B4AC000, 0x3B4AFFFF, "GS" ],  // 59.74.192.0-59.74.255.255, GS
        [ 0x3B4B0000, 0x3B4B7FFF, "SN" ],  // 59.75.0.0-59.75.127.255, SN
        [ 0x3B4B8000, 0x3B4BB7FF, "XJ" ],  // 59.75.128.0-59.75.183.255, XJ
        [ 0x3B4BB800, 0x3B4BBFFF, "SN" ],  // 59.75.184.0-59.75.191.255, SN
        [ 0x3B4BC000, 0x3B4BD1FF, "QH" ],  // 59.75.192.0-59.75.209.255, QH
        [ 0x3B4BD200, 0x3B4BDFFF, "SN" ],  // 59.75.210.0-59.75.223.255, SN
        [ 0x3B4BE000, 0x3B4BF7FF, "XJ" ],  // 59.75.224.0-59.75.247.255, XJ
        [ 0x3B4BF800, 0x3B4BFFFF, "SN" ],  // 59.75.248.0-59.75.255.255, SN
        [ 0x3B4C0000, 0x3B4C9FFF, "GS" ],  // 59.76.0.0-59.76.159.255, GS
        [ 0x3B4CA000, 0x3B4CAFFF, "SN" ],  // 59.76.160.0-59.76.175.255, SN
        [ 0x3B4CB000, 0x3B4CFFFF, "NX" ],  // 59.76.176.0-59.76.255.255, NX
        [ 0x3B4D0000, 0x3B4DFFFF, "FJ" ],  // 59.77.0.0-59.77.255.255, FJ
        [ 0x3B4E0000, 0x3B4F6FFF, "SH" ],  // 59.78.0.0-59.79.111.255, SH
        [ 0x3B4F7000, 0x3B4F71FF, "LN" ],  // 59.79.112.0-59.79.113.255, LN
        [ 0x3B4F7200, 0x3B4F7FFF, "SH" ],  // 59.79.114.0-59.79.127.255, SH
        [ 0x3B4F8000, 0x3B4FBFFF, "ZJ" ],  // 59.79.128.0-59.79.191.255, ZJ
        [ 0x3B4FC000, 0x3B4FFFFF, "FJ" ],  // 59.79.192.0-59.79.255.255, FJ
        [ 0x3B500000, 0x3B50FFFF, "GZ" ],  // 59.80.0.0-59.80.255.255, GZ
        [ 0x3B510000, 0x3B5107FF, "BJ" ],  // 59.81.0.0-59.81.7.255, BJ
        [ 0x3B510800, 0x3B5109FF, "TJ" ],  // 59.81.8.0-59.81.9.255, TJ
        [ 0x3B510A00, 0x3B510BFF, "BJ" ],  // 59.81.10.0-59.81.11.255, BJ
        [ 0x3B510C00, 0x3B510DFF, "SD" ],  // 59.81.12.0-59.81.13.255, SD
        [ 0x3B510E00, 0x3B510FFF, "BJ" ],  // 59.81.14.0-59.81.15.255, BJ
        [ 0x3B511000, 0x3B5111FF, "HE" ],  // 59.81.16.0-59.81.17.255, HE
        [ 0x3B511200, 0x3B5113FF, "BJ" ],  // 59.81.18.0-59.81.19.255, BJ
        [ 0x3B511400, 0x3B5115FF, "LN" ],  // 59.81.20.0-59.81.21.255, LN
        [ 0x3B511600, 0x3B5117FF, "BJ" ],  // 59.81.22.0-59.81.23.255, BJ
        [ 0x3B511800, 0x3B5119FF, "HL" ],  // 59.81.24.0-59.81.25.255, HL
        [ 0x3B511A00, 0x3B511FFF, "BJ" ],  // 59.81.26.0-59.81.31.255, BJ
        [ 0x3B512000, 0x3B5121FF, "SX" ],  // 59.81.32.0-59.81.33.255, SX
        [ 0x3B512200, 0x3B5123FF, "BJ" ],  // 59.81.34.0-59.81.35.255, BJ
        [ 0x3B512400, 0x3B5125FF, "SN" ],  // 59.81.36.0-59.81.37.255, SN
        [ 0x3B512600, 0x3B5127FF, "BJ" ],  // 59.81.38.0-59.81.39.255, BJ
        [ 0x3B512800, 0x3B5129FF, "NM" ],  // 59.81.40.0-59.81.41.255, NM
        [ 0x3B512A00, 0x3B512BFF, "BJ" ],  // 59.81.42.0-59.81.43.255, BJ
        [ 0x3B512C00, 0x3B512CFF, "YN" ],  // 59.81.44.0-59.81.44.255, YN
        [ 0x3B512D00, 0x3B512DFF, "BJ" ],  // 59.81.45.0-59.81.45.255, BJ
        [ 0x3B512E00, 0x3B512EFF, "TJ" ],  // 59.81.46.0-59.81.46.255, TJ
        [ 0x3B512F00, 0x3B513DFF, "BJ" ],  // 59.81.47.0-59.81.61.255, BJ
        [ 0x3B513E00, 0x3B513FFF, "HA" ],  // 59.81.62.0-59.81.63.255, HA
        [ 0x3B514000, 0x3B5141FF, "SH" ],  // 59.81.64.0-59.81.65.255, SH
        [ 0x3B514200, 0x3B5143FF, "BJ" ],  // 59.81.66.0-59.81.67.255, BJ
        [ 0x3B514400, 0x3B5145FF, "JS" ],  // 59.81.68.0-59.81.69.255, JS
        [ 0x3B514600, 0x3B5147FF, "BJ" ],  // 59.81.70.0-59.81.71.255, BJ
        [ 0x3B514800, 0x3B5149FF, "FJ" ],  // 59.81.72.0-59.81.73.255, FJ
        [ 0x3B514A00, 0x3B514BFF, "BJ" ],  // 59.81.74.0-59.81.75.255, BJ
        [ 0x3B514C00, 0x3B514DFF, "SC" ],  // 59.81.76.0-59.81.77.255, SC
        [ 0x3B514E00, 0x3B514FFF, "HA" ],  // 59.81.78.0-59.81.79.255, HA
        [ 0x3B515000, 0x3B5151FF, "AH" ],  // 59.81.80.0-59.81.81.255, AH
        [ 0x3B515200, 0x3B5153FF, "GX" ],  // 59.81.82.0-59.81.83.255, GX
        [ 0x3B515400, 0x3B5155FF, "BJ" ],  // 59.81.84.0-59.81.85.255, BJ
        [ 0x3B515600, 0x3B5157FF, "HN" ],  // 59.81.86.0-59.81.87.255, HN
        [ 0x3B515800, 0x3B5159FF, "JX" ],  // 59.81.88.0-59.81.89.255, JX
        [ 0x3B515A00, 0x3B515BFF, "BJ" ],  // 59.81.90.0-59.81.91.255, BJ
        [ 0x3B515C00, 0x3B515DFF, "YN" ],  // 59.81.92.0-59.81.93.255, YN
        [ 0x3B515E00, 0x3B515FFF, "GS" ],  // 59.81.94.0-59.81.95.255, GS
        [ 0x3B516000, 0x3B5161FF, "SD" ],  // 59.81.96.0-59.81.97.255, SD
        [ 0x3B516200, 0x3B5163FF, "NX" ],  // 59.81.98.0-59.81.99.255, NX
        [ 0x3B516400, 0x3B5165FF, "HI" ],  // 59.81.100.0-59.81.101.255, HI
        [ 0x3B516600, 0x3B5167FF, "XZ" ],  // 59.81.102.0-59.81.103.255, XZ
        [ 0x3B516800, 0x3B5169FF, "XJ" ],  // 59.81.104.0-59.81.105.255, XJ
        [ 0x3B516A00, 0x3B516BFF, "SH" ],  // 59.81.106.0-59.81.107.255, SH
        [ 0x3B516C00, 0x3B51FFFF, "BJ" ],  // 59.81.108.0-59.81.255.255, BJ
        [ 0x3B520000, 0x3B5207FF, "ZJ" ],  // 59.82.0.0-59.82.7.255, ZJ
        [ 0x3B520800, 0x3B520FFF, "SH" ],  // 59.82.8.0-59.82.15.255, SH
        [ 0x3B521000, 0x3B521FFF, "BJ" ],  // 59.82.16.0-59.82.31.255, BJ
        [ 0x3B522000, 0x3B522FFF, "SH" ],  // 59.82.32.0-59.82.47.255, SH
        [ 0x3B523000, 0x3B5237FF, "GD" ],  // 59.82.48.0-59.82.55.255, GD
        [ 0x3B523800, 0x3B525FFF, "BJ" ],  // 59.82.56.0-59.82.95.255, BJ
        [ 0x3B526000, 0x3B5263FF, "SC" ],  // 59.82.96.0-59.82.99.255, SC
        [ 0x3B526400, 0x3B527FFF, "BJ" ],  // 59.82.100.0-59.82.127.255, BJ
        [ 0x3B528000, 0x3B528FFF, "NM" ],  // 59.82.128.0-59.82.143.255, NM
        [ 0x3B529000, 0x3B52AFFF, "SC" ],  // 59.82.144.0-59.82.175.255, SC
        [ 0x3B52B000, 0x3B52FFFF, "ZJ" ],  // 59.82.176.0-59.82.255.255, ZJ
        [ 0x3B530000, 0x3B533FFF, "SD" ],  // 59.83.0.0-59.83.63.255, SD
        [ 0x3B534000, 0x3B537FFF, "TJ" ],  // 59.83.64.0-59.83.127.255, TJ
        [ 0x3B538000, 0x3B5383FF, "BJ" ],  // 59.83.128.0-59.83.131.255, BJ
        [ 0x3B538400, 0x3B53BFFF, "SD" ],  // 59.83.132.0-59.83.191.255, SD
        [ 0x3B53C000, 0x3B53EBFF, "JS" ],  // 59.83.192.0-59.83.235.255, JS
        [ 0x3B53EC00, 0x3B53FEFF, "SD" ],  // 59.83.236.0-59.83.254.255, SD
        [ 0x3B53FF00, 0x3B53FFFF, "BJ" ],  // 59.83.255.0-59.83.255.255, BJ
        [ 0x3B6B0000, 0x3B6BFFFF, "GD" ],  // 59.107.0.0-59.107.255.255, GD
        [ 0x3B6C0000, 0x3B6C1FFF, "BJ" ],  // 59.108.0.0-59.108.31.255, BJ
        [ 0x3B6C2000, 0x3B6C2007, "JL" ],  // 59.108.32.0-59.108.32.7, JL
        [ 0x3B6C2008, 0x3B6C200F, "LN" ],  // 59.108.32.8-59.108.32.15, LN
        [ 0x3B6C2010, 0x3B6C2017, "SH" ],  // 59.108.32.16-59.108.32.23, SH
        [ 0x3B6C2018, 0x3B6C202F, "TJ" ],  // 59.108.32.24-59.108.32.47, TJ
        [ 0x3B6C2030, 0x3B6C204F, "SX" ],  // 59.108.32.48-59.108.32.79, SX
        [ 0x3B6C2050, 0x3B6C205F, "SN" ],  // 59.108.32.80-59.108.32.95, SN
        [ 0x3B6C2060, 0x3B6C206F, "GS" ],  // 59.108.32.96-59.108.32.111, GS
        [ 0x3B6C2070, 0x3B6C2EFF, "BJ" ],  // 59.108.32.112-59.108.46.255, BJ
        [ 0x3B6C2F00, 0x3B6C2F7F, "LN" ],  // 59.108.47.0-59.108.47.127, LN
        [ 0x3B6C2F80, 0x3B6C7FFF, "BJ" ],  // 59.108.47.128-59.108.127.255, BJ
        [ 0x3B6C8000, 0x3B6C80FF, "JL" ],  // 59.108.128.0-59.108.128.255, JL
        [ 0x3B6C8100, 0x3B6C99DF, "BJ" ],  // 59.108.129.0-59.108.153.223, BJ
        [ 0x3B6C99E0, 0x3B6C99EF, "HE" ],  // 59.108.153.224-59.108.153.239, HE
        [ 0x3B6C99F0, 0x3B6CC8FF, "SH" ],  // 59.108.153.240-59.108.200.255, SH
        [ 0x3B6CC900, 0x3B6D03FF, "BJ" ],  // 59.108.201.0-59.109.3.255, BJ
        [ 0x3B6D0400, 0x3B6D04FF, "LN" ],  // 59.109.4.0-59.109.4.255, LN
        [ 0x3B6D0500, 0x3B6D05FF, "JL" ],  // 59.109.5.0-59.109.5.255, JL
        [ 0x3B6D0600, 0x3B6D2EFF, "BJ" ],  // 59.109.6.0-59.109.46.255, BJ
        [ 0x3B6D2F00, 0x3B6D2FFF, "LN" ],  // 59.109.47.0-59.109.47.255, LN
        [ 0x3B6D3000, 0x3B6D3FFF, "BJ" ],  // 59.109.48.0-59.109.63.255, BJ
        [ 0x3B6D4000, 0x3B6D40FF, "SX" ],  // 59.109.64.0-59.109.64.255, SX
        [ 0x3B6D4100, 0x3B6D4AFF, "BJ" ],  // 59.109.65.0-59.109.74.255, BJ
        [ 0x3B6D4B00, 0x3B6D4BFF, "LN" ],  // 59.109.75.0-59.109.75.255, LN
        [ 0x3B6D4C00, 0x3B6D53FF, "BJ" ],  // 59.109.76.0-59.109.83.255, BJ
        [ 0x3B6D5400, 0x3B6D5FFF, "TJ" ],  // 59.109.84.0-59.109.95.255, TJ
        [ 0x3B6D6000, 0x3B6D7FFF, "BJ" ],  // 59.109.96.0-59.109.127.255, BJ
        [ 0x3B6D8000, 0x3B6D8FFF, "TJ" ],  // 59.109.128.0-59.109.143.255, TJ
        [ 0x3B6D9000, 0x3B6D9FFF, "BJ" ],  // 59.109.144.0-59.109.159.255, BJ
        [ 0x3B6DA000, 0x3B6DBFFF, "LN" ],  // 59.109.160.0-59.109.191.255, LN
        [ 0x3B6DC000, 0x3B6EFFFF, "BJ" ],  // 59.109.192.0-59.110.255.255, BJ
        [ 0x3B6F0000, 0x3B6FFFFF, "ZJ" ],  // 59.111.0.0-59.111.255.255, ZJ
        [ 0x3B970000, 0x3B977FFF, "BJ" ],  // 59.151.0.0-59.151.127.255, BJ
        [ 0x3B981000, 0x3B981FFF, "HE" ],  // 59.152.16.0-59.152.31.255, HE
        [ 0x3B982000, 0x3B9822FF, "LN" ],  // 59.152.32.0-59.152.34.255, LN
        [ 0x3B982400, 0x3B9827FF, "HA" ],  // 59.152.36.0-59.152.39.255, HA
        [ 0x3B982F40, 0x3B982F5F, "GD" ],  // 59.152.47.64-59.152.47.95, GD
        [ 0x3B984000, 0x3B984FFF, "HE" ],  // 59.152.64.0-59.152.79.255, HE
        [ 0x3B987000, 0x3B9873FF, "SD" ],  // 59.152.112.0-59.152.115.255, SD
        [ 0x3B987400, 0x3B9877FF, "ZJ" ],  // 59.152.116.0-59.152.119.255, ZJ
        [ 0x3B990400, 0x3B9907FF, "SX" ],  // 59.153.4.0-59.153.7.255, SX
        [ 0x3B992000, 0x3B9923FF, "SH" ],  // 59.153.32.0-59.153.35.255, SH
        [ 0x3B993C00, 0x3B993FFF, "GD" ],  // 59.153.60.0-59.153.63.255, GD
        [ 0x3B994000, 0x3B9943FF, "BJ" ],  // 59.153.64.0-59.153.67.255, BJ
        [ 0x3B994400, 0x3B994BFF, "SD" ],  // 59.153.68.0-59.153.75.255, SD
        [ 0x3B995C00, 0x3B995FFF, "SH" ],  // 59.153.92.0-59.153.95.255, SH
        [ 0x3B997400, 0x3B9977FF, "GD" ],  // 59.153.116.0-59.153.119.255, GD
        [ 0x3B998800, 0x3B998BFF, "SN" ],  // 59.153.136.0-59.153.139.255, SN
        [ 0x3B999800, 0x3B999BFF, "BJ" ],  // 59.153.152.0-59.153.155.255, BJ
        [ 0x3B99A400, 0x3B99C3FF, "SH" ],  // 59.153.164.0-59.153.195.255, SH
        [ 0x3B9B0000, 0x3B9B3FFF, "GD" ],  // 59.155.0.0-59.155.63.255, GD
        [ 0x3B9B4000, 0x3B9BBFFF, "SH" ],  // 59.155.64.0-59.155.191.255, SH
        [ 0x3B9BC000, 0x3B9BFFFF, "GD" ],  // 59.155.192.0-59.155.255.255, GD
        [ 0x3BAC0000, 0x3BAFFFFF, "HB" ],  // 59.172.0.0-59.175.255.255, HB
        [ 0x3BBF0000, 0x3BBF7FFF, "GD" ],  // 59.191.0.0-59.191.127.255, GD
        [ 0x3BC00000, 0x3BFFFFFF, "BJ" ],  // 59.192.0.0-59.255.255.255, BJ
        [ 0x3C000000, 0x3C0AFFFF, "HE" ],  // 60.0.0.0-60.10.255.255, HE
        [ 0x3C0B0000, 0x3C0BFFFF, "HL" ],  // 60.11.0.0-60.11.255.255, HL
        [ 0x3C0C0000, 0x3C0CFFFF, "ZJ" ],  // 60.12.0.0-60.12.255.255, ZJ
        [ 0x3C0D0000, 0x3C0D3FFF, "GS" ],  // 60.13.0.0-60.13.63.255, GS
        [ 0x3C0D4000, 0x3C0D7FFF, "HI" ],  // 60.13.64.0-60.13.127.255, HI
        [ 0x3C0D8000, 0x3C0DFFFF, "XJ" ],  // 60.13.128.0-60.13.255.255, XJ
        [ 0x3C0E0000, 0x3C0FFFFF, "HL" ],  // 60.14.0.0-60.15.255.255, HL
        [ 0x3C100000, 0x3C17FFFF, "LN" ],  // 60.16.0.0-60.23.255.255, LN
        [ 0x3C180000, 0x3C19F1FF, "TJ" ],  // 60.24.0.0-60.25.241.255, TJ
        [ 0x3C19F200, 0x3C19F3FF, "HE" ],  // 60.25.242.0-60.25.243.255, HE
        [ 0x3C19F400, 0x3C1EFFFF, "TJ" ],  // 60.25.244.0-60.30.255.255, TJ
        [ 0x3C1F0000, 0x3C1FFFFF, "NM" ],  // 60.31.0.0-60.31.255.255, NM
        [ 0x3C370000, 0x3C37FFFF, "ZJ" ],  // 60.55.0.0-60.55.255.255, ZJ
        [ 0x3C3F0000, 0x3C3FFFFF, "SH" ],  // 60.63.0.0-60.63.255.255, SH
        [ 0x3CA00000, 0x3CA1FFFF, "YN" ],  // 60.160.0.0-60.161.255.255, YN
        [ 0x3CA20000, 0x3CA3FFFF, "ZJ" ],  // 60.162.0.0-60.163.255.255, ZJ
        [ 0x3CA40000, 0x3CA5FEEE, "GS" ],  // 60.164.0.0-60.165.254.238, GS
        [ 0x3CA5FEEF, 0x3CA5FEEF, "SC" ],  // 60.165.254.239-60.165.254.239, SC
        [ 0x3CA5FEF0, 0x3CA5FFFF, "GS" ],  // 60.165.254.240-60.165.255.255, GS
        [ 0x3CA60000, 0x3CABF4FF, "AH" ],  // 60.166.0.0-60.171.244.255, AH
        [ 0x3CABF500, 0x3CABF5FF, "GD" ],  // 60.171.245.0-60.171.245.255, GD
        [ 0x3CABF600, 0x3CABF6FF, "AH" ],  // 60.171.246.0-60.171.246.255, AH
        [ 0x3CABF700, 0x3CABFAFF, "GD" ],  // 60.171.247.0-60.171.250.255, GD
        [ 0x3CABFB00, 0x3CABFBFF, "AH" ],  // 60.171.251.0-60.171.251.255, AH
        [ 0x3CABFC00, 0x3CABFEFF, "GD" ],  // 60.171.252.0-60.171.254.255, GD
        [ 0x3CABFF00, 0x3CAFFFFF, "AH" ],  // 60.171.255.0-60.175.255.255, AH
        [ 0x3CB00000, 0x3CBFFFFF, "ZJ" ],  // 60.176.0.0-60.191.255.255, ZJ
        [ 0x3CC20000, 0x3CC3FFFF, "BJ" ],  // 60.194.0.0-60.195.255.255, BJ
        [ 0x3CC80000, 0x3CCBFFFF, "JX" ],  // 60.200.0.0-60.203.255.255, JX
        [ 0x3CCC0000, 0x3CCC7FFF, "SH" ],  // 60.204.0.0-60.204.127.255, SH
        [ 0x3CCC8000, 0x3CCCFFFF, "JX" ],  // 60.204.128.0-60.204.255.255, JX
        [ 0x3CCD0000, 0x3CCFFFFF, "BJ" ],  // 60.205.0.0-60.207.255.255, BJ
        [ 0x3CD00000, 0x3CD9FFFF, "SD" ],  // 60.208.0.0-60.217.255.255, SD
        [ 0x3CDA0000, 0x3CDBFFFF, "HL" ],  // 60.218.0.0-60.219.255.255, HL
        [ 0x3CDC0000, 0x3CDFFFFF, "SX" ],  // 60.220.0.0-60.223.255.255, SX
        [ 0x3CE80000, 0x3CE9FFFF, "SD" ],  // 60.232.0.0-60.233.255.255, SD
        [ 0x3CEB0000, 0x3CEBFFFF, "SD" ],  // 60.235.0.0-60.235.255.255, SD
        [ 0x3CF58000, 0x3CF5FFFF, "BJ" ],  // 60.245.128.0-60.245.255.255, BJ
        [ 0x3CF70000, 0x3CF77FFF, "BJ" ],  // 60.247.0.0-60.247.127.255, BJ
        [ 0x3CF78000, 0x3CF7FFFF, "SC" ],  // 60.247.128.0-60.247.255.255, SC
        [ 0x3CFC0000, 0x3CFCFFFF, "HL" ],  // 60.252.0.0-60.252.255.255, HL
        [ 0x3CFD8000, 0x3CFDFFFF, "BJ" ],  // 60.253.128.0-60.253.255.255, BJ
        [ 0x3CFF0000, 0x3CFF5612, "SC" ],  // 60.255.0.0-60.255.86.18, SC
        [ 0x3CFF5613, 0x3CFF5613, "YN" ],  // 60.255.86.19-60.255.86.19, YN
        [ 0x3CFF5614, 0x3CFF5616, "SC" ],  // 60.255.86.20-60.255.86.22, SC
        [ 0x3CFF5617, 0x3CFF5617, "YN" ],  // 60.255.86.23-60.255.86.23, YN
        [ 0x3CFF5618, 0x3CFF5618, "SC" ],  // 60.255.86.24-60.255.86.24, SC
        [ 0x3CFF5619, 0x3CFF5619, "YN" ],  // 60.255.86.25-60.255.86.25, YN
        [ 0x3CFF561A, 0x3CFF561A, "SC" ],  // 60.255.86.26-60.255.86.26, SC
        [ 0x3CFF561B, 0x3CFF561E, "YN" ],  // 60.255.86.27-60.255.86.30, YN
        [ 0x3CFF561F, 0x3CFFFFFF, "SC" ],  // 60.255.86.31-60.255.255.255, SC
        [ 0x3D045000, 0x3D0455FF, "BJ" ],  // 61.4.80.0-61.4.85.255, BJ
        [ 0x3D045600, 0x3D045FFF, "GD" ],  // 61.4.86.0-61.4.95.255, GD
        [ 0x3D04B000, 0x3D04BFFF, "BJ" ],  // 61.4.176.0-61.4.191.255, BJ
        [ 0x3D08A000, 0x3D08AFFF, "SH" ],  // 61.8.160.0-61.8.175.255, SH
        [ 0x3D0ED400, 0x3D0ED7FF, "GX" ],  // 61.14.212.0-61.14.215.255, GX
        [ 0x3D0ED800, 0x3D0EDBFF, "GD" ],  // 61.14.216.0-61.14.219.255, GD
        [ 0x3D0EDC00, 0x3D0EDFFF, "HN" ],  // 61.14.220.0-61.14.223.255, HN
        [ 0x3D0EF000, 0x3D0EF3FF, "ZJ" ],  // 61.14.240.0-61.14.243.255, ZJ
        [ 0x3D0EF400, 0x3D0EF7FF, "BJ" ],  // 61.14.244.0-61.14.247.255, BJ
        [ 0x3D1C0000, 0x3D1C7FFF, "GD" ],  // 61.28.0.0-61.28.127.255, GD
        [ 0x3D1CC300, 0x3D1CC4FF, "BJ" ],  // 61.28.195.0-61.28.196.255, BJ
        [ 0x3D1CD400, 0x3D1CD4FF, "BJ" ],  // 61.28.212.0-61.28.212.255, BJ
        [ 0x3D1D8000, 0x3D1DEFFF, "GD" ],  // 61.29.128.0-61.29.239.255, GD
        [ 0x3D2D8000, 0x3D2DBFFF, "AH" ],  // 61.45.128.0-61.45.191.255, AH
        [ 0x3D2DE000, 0x3D2DEFFF, "GD" ],  // 61.45.224.0-61.45.239.255, GD
        [ 0x3D2F8000, 0x3D2FBFFF, "HL" ],  // 61.47.128.0-61.47.191.255, HL
        [ 0x3D300000, 0x3D33FFFF, "BJ" ],  // 61.48.0.0-61.51.255.255, BJ
        [ 0x3D340000, 0x3D36FFFF, "HA" ],  // 61.52.0.0-61.54.255.255, HA
        [ 0x3D370000, 0x3D37FFFF, "HE" ],  // 61.55.0.0-61.55.255.255, HE
        [ 0x3D57C000, 0x3D57FFFF, "SH" ],  // 61.87.192.0-61.87.255.255, SH
        [ 0x3D800000, 0x3D807FFF, "XJ" ],  // 61.128.0.0-61.128.127.255, XJ
        [ 0x3D808000, 0x3D80FFFF, "CQ" ],  // 61.128.128.0-61.128.255.255, CQ
        [ 0x3D810000, 0x3D81FFFF, "SH" ],  // 61.129.0.0-61.129.255.255, SH
        [ 0x3D820000, 0x3D82FFFF, "ZJ" ],  // 61.130.0.0-61.130.255.255, ZJ
        [ 0x3D830000, 0x3D837FFF, "FJ" ],  // 61.131.0.0-61.131.127.255, FJ
        [ 0x3D838000, 0x3D83FFFF, "JX" ],  // 61.131.128.0-61.131.255.255, JX
        [ 0x3D840000, 0x3D847FFF, "JS" ],  // 61.132.0.0-61.132.127.255, JS
        [ 0x3D848000, 0x3D84FFFF, "AH" ],  // 61.132.128.0-61.132.255.255, AH
        [ 0x3D850000, 0x3D857FFF, "SD" ],  // 61.133.0.0-61.133.127.255, SD
        [ 0x3D858000, 0x3D85BFFF, "AH" ],  // 61.133.128.0-61.133.191.255, AH
        [ 0x3D85C000, 0x3D85DFFF, "NX" ],  // 61.133.192.0-61.133.223.255, NX
        [ 0x3D85E000, 0x3D85FFFF, "QH" ],  // 61.133.224.0-61.133.255.255, QH
        [ 0x3D860000, 0x3D863FFF, "SN" ],  // 61.134.0.0-61.134.63.255, SN
        [ 0x3D864000, 0x3D865FFF, "GS" ],  // 61.134.64.0-61.134.95.255, GS
        [ 0x3D866000, 0x3D867FFF, "NM" ],  // 61.134.96.0-61.134.127.255, NM
        [ 0x3D868000, 0x3D86BFFF, "HE" ],  // 61.134.128.0-61.134.191.255, HE
        [ 0x3D86C000, 0x3D86FFFF, "SX" ],  // 61.134.192.0-61.134.255.255, SX
        [ 0x3D870000, 0x3D87ABEA, "BJ" ],  // 61.135.0.0-61.135.171.234, BJ
        [ 0x3D87ABEB, 0x3D87ABEC, "GD" ],  // 61.135.171.235-61.135.171.236, GD
        [ 0x3D87ABED, 0x3D87FFFF, "BJ" ],  // 61.135.171.237-61.135.255.255, BJ
        [ 0x3D880000, 0x3D882AFF, "TJ" ],  // 61.136.0.0-61.136.42.255, TJ
        [ 0x3D882B00, 0x3D882BFF, "HE" ],  // 61.136.43.0-61.136.43.255, HE
        [ 0x3D882C00, 0x3D883FFF, "TJ" ],  // 61.136.44.0-61.136.63.255, TJ
        [ 0x3D884000, 0x3D887FFF, "HA" ],  // 61.136.64.0-61.136.127.255, HA
        [ 0x3D888000, 0x3D88FFFF, "HB" ],  // 61.136.128.0-61.136.255.255, HB
        [ 0x3D890000, 0x3D897FFF, "HN" ],  // 61.137.0.0-61.137.127.255, HN
        [ 0x3D898000, 0x3D89FFFF, "LN" ],  // 61.137.128.0-61.137.255.255, LN
        [ 0x3D8A0000, 0x3D8A3FFF, "HL" ],  // 61.138.0.0-61.138.63.255, HL
        [ 0x3D8A4000, 0x3D8A7FFF, "NM" ],  // 61.138.64.0-61.138.127.255, NM
        [ 0x3D8A8000, 0x3D8ABFFF, "JL" ],  // 61.138.128.0-61.138.191.255, JL
        [ 0x3D8AC000, 0x3D8ADFFF, "YN" ],  // 61.138.192.0-61.138.223.255, YN
        [ 0x3D8AE000, 0x3D8AFFFF, "XJ" ],  // 61.138.224.0-61.138.255.255, XJ
        [ 0x3D8B0000, 0x3D8B7FFF, "SC" ],  // 61.139.0.0-61.139.127.255, SC
        [ 0x3D8B8000, 0x3D8BBFFF, "JL" ],  // 61.139.128.0-61.139.191.255, JL
        [ 0x3D8BC000, 0x3D8BFFFF, "GX" ],  // 61.139.192.0-61.139.255.255, GX
        [ 0x3D8C0000, 0x3D92FFFF, "GD" ],  // 61.140.0.0-61.146.255.255, GD
        [ 0x3D930000, 0x3D93FFFF, "JS" ],  // 61.147.0.0-61.147.255.255, JS
        [ 0x3D940000, 0x3D95FFFF, "BJ" ],  // 61.148.0.0-61.149.255.255, BJ
        [ 0x3D960000, 0x3D967FFF, "SN" ],  // 61.150.0.0-61.150.127.255, SN
        [ 0x3D968000, 0x3D96FFFF, "HN" ],  // 61.150.128.0-61.150.255.255, HN
        [ 0x3D970000, 0x3D98FFFF, "SH" ],  // 61.151.0.0-61.152.255.255, SH
        [ 0x3D990000, 0x3D99FFFF, "ZJ" ],  // 61.153.0.0-61.153.255.255, ZJ
        [ 0x3D9A0000, 0x3D9AFFFF, "FJ" ],  // 61.154.0.0-61.154.255.255, FJ
        [ 0x3D9B0000, 0x3D9BFFFF, "JS" ],  // 61.155.0.0-61.155.255.255, JS
        [ 0x3D9C0000, 0x3D9CFFFF, "SD" ],  // 61.156.0.0-61.156.255.255, SD
        [ 0x3D9D0000, 0x3D9DFFFF, "SC" ],  // 61.157.0.0-61.157.255.255, SC
        [ 0x3D9E0000, 0x3D9E7FFF, "HL" ],  // 61.158.0.0-61.158.127.255, HL
        [ 0x3D9E8000, 0x3D9EFFFF, "HA" ],  // 61.158.128.0-61.158.255.255, HA
        [ 0x3D9F0000, 0x3D9F3FFF, "HE" ],  // 61.159.0.0-61.159.63.255, HE
        [ 0x3D9F4000, 0x3D9F7FFF, "GS" ],  // 61.159.64.0-61.159.127.255, GS
        [ 0x3D9F8000, 0x3D9FBFFF, "GZ" ],  // 61.159.128.0-61.159.191.255, GZ
        [ 0x3D9FC000, 0x3D9FFFFF, "YN" ],  // 61.159.192.0-61.159.255.255, YN
        [ 0x3DA00000, 0x3DA0FFFF, "JS" ],  // 61.160.0.0-61.160.255.255, JS
        [ 0x3DA10000, 0x3DA13FFF, "JL" ],  // 61.161.0.0-61.161.63.255, JL
        [ 0x3DA14000, 0x3DA17FFF, "CQ" ],  // 61.161.64.0-61.161.127.255, CQ
        [ 0x3DA18000, 0x3DA1FFFF, "LN" ],  // 61.161.128.0-61.161.255.255, LN
        [ 0x3DA20000, 0x3DA2FFFF, "SD" ],  // 61.162.0.0-61.162.255.255, SD
        [ 0x3DA30000, 0x3DA3FFFF, "HA" ],  // 61.163.0.0-61.163.255.255, HA
        [ 0x3DA40000, 0x3DA4FFFF, "ZJ" ],  // 61.164.0.0-61.164.255.255, ZJ
        [ 0x3DA50000, 0x3DA5FFFF, "SH" ],  // 61.165.0.0-61.165.255.255, SH
        [ 0x3DA60000, 0x3DA6FFFF, "YN" ],  // 61.166.0.0-61.166.255.255, YN
        [ 0x3DA70000, 0x3DA7FFFF, "HL" ],  // 61.167.0.0-61.167.255.255, HL
        [ 0x3DA80000, 0x3DA8FFFF, "HA" ],  // 61.168.0.0-61.168.255.255, HA
        [ 0x3DA90000, 0x3DADFFFF, "SH" ],  // 61.169.0.0-61.173.255.255, SH
        [ 0x3DAE0000, 0x3DAFFFFF, "ZJ" ],  // 61.174.0.0-61.175.255.255, ZJ
        [ 0x3DB00000, 0x3DB0FFFF, "LN" ],  // 61.176.0.0-61.176.255.255, LN
        [ 0x3DB10000, 0x3DB1FFFF, "JS" ],  // 61.177.0.0-61.177.255.255, JS
        [ 0x3DB20000, 0x3DB2FFFF, "GS" ],  // 61.178.0.0-61.178.255.255, GS
        [ 0x3DB30000, 0x3DB3FFFF, "SD" ],  // 61.179.0.0-61.179.255.255, SD
        [ 0x3DB40000, 0x3DB47FFF, "JX" ],  // 61.180.0.0-61.180.127.255, JX
        [ 0x3DB48000, 0x3DB4FFFF, "HL" ],  // 61.180.128.0-61.180.255.255, HL
        [ 0x3DB50000, 0x3DB5FFFF, "TJ" ],  // 61.181.0.0-61.181.255.255, TJ
        [ 0x3DB60000, 0x3DB6FFFF, "HE" ],  // 61.182.0.0-61.182.255.255, HE
        [ 0x3DB70000, 0x3DB8FFFF, "HB" ],  // 61.183.0.0-61.184.255.255, HB
        [ 0x3DB90000, 0x3DB9FFFF, "SN" ],  // 61.185.0.0-61.185.255.255, SN
        [ 0x3DBA0000, 0x3DBA3FFF, "HI" ],  // 61.186.0.0-61.186.63.255, HI
        [ 0x3DBA4000, 0x3DBA7FFF, "HN" ],  // 61.186.64.0-61.186.127.255, HN
        [ 0x3DBA8000, 0x3DBAFFFF, "CQ" ],  // 61.186.128.0-61.186.255.255, CQ
        [ 0x3DBB0000, 0x3DBBFFFF, "HN" ],  // 61.187.0.0-61.187.255.255, HN
        [ 0x3DBC0000, 0x3DBCFFFF, "SC" ],  // 61.188.0.0-61.188.255.255, SC
        [ 0x3DBD0000, 0x3DBD7FFF, "LN" ],  // 61.189.0.0-61.189.127.255, LN
        [ 0x3DBD8000, 0x3DBDFFFF, "GZ" ],  // 61.189.128.0-61.189.255.255, GZ
        [ 0x3DBE0000, 0x3DBFFFFF, "AH" ],  // 61.190.0.0-61.191.255.255, AH
        [ 0x3DE80000, 0x3DE80FFF, "BJ" ],  // 61.232.0.0-61.232.15.255, BJ
        [ 0x3DE81000, 0x3DE81BFF, "TJ" ],  // 61.232.16.0-61.232.27.255, TJ
        [ 0x3DE81C00, 0x3DE823FF, "HE" ],  // 61.232.28.0-61.232.35.255, HE
        [ 0x3DE82400, 0x3DE829FF, "SX" ],  // 61.232.36.0-61.232.41.255, SX
        [ 0x3DE82A00, 0x3DE839FF, "SD" ],  // 61.232.42.0-61.232.57.255, SD
        [ 0x3DE83A00, 0x3DE83DFF, "NM" ],  // 61.232.58.0-61.232.61.255, NM
        [ 0x3DE83E00, 0x3DE83EFF, "JS" ],  // 61.232.62.0-61.232.62.255, JS
        [ 0x3DE83F00, 0x3DE842FF, "SH" ],  // 61.232.63.0-61.232.66.255, SH
        [ 0x3DE84300, 0x3DE844FF, "JS" ],  // 61.232.67.0-61.232.68.255, JS
        [ 0x3DE84500, 0x3DE84DFF, "SH" ],  // 61.232.69.0-61.232.77.255, SH
        [ 0x3DE84E00, 0x3DE859FF, "ZJ" ],  // 61.232.78.0-61.232.89.255, ZJ
        [ 0x3DE85A00, 0x3DE869FF, "FJ" ],  // 61.232.90.0-61.232.105.255, FJ
        [ 0x3DE86A00, 0x3DE875FF, "JS" ],  // 61.232.106.0-61.232.117.255, JS
        [ 0x3DE87600, 0x3DE87DFF, "JX" ],  // 61.232.118.0-61.232.125.255, JX
        [ 0x3DE87E00, 0x3DE88DFF, "GD" ],  // 61.232.126.0-61.232.141.255, GD
        [ 0x3DE88E00, 0x3DE895FF, "HN" ],  // 61.232.142.0-61.232.149.255, HN
        [ 0x3DE89600, 0x3DE89BFF, "GX" ],  // 61.232.150.0-61.232.155.255, GX
        [ 0x3DE89C00, 0x3DE89CFF, "HE" ],  // 61.232.156.0-61.232.156.255, HE
        [ 0x3DE89D00, 0x3DE8A7FF, "LN" ],  // 61.232.157.0-61.232.167.255, LN
        [ 0x3DE8A800, 0x3DE8AFFF, "JL" ],  // 61.232.168.0-61.232.175.255, JL
        [ 0x3DE8B000, 0x3DE8B7FF, "HL" ],  // 61.232.176.0-61.232.183.255, HL
        [ 0x3DE8B800, 0x3DE8C3FF, "HA" ],  // 61.232.184.0-61.232.195.255, HA
        [ 0x3DE8C400, 0x3DE8CBFF, "SN" ],  // 61.232.196.0-61.232.203.255, SN
        [ 0x3DE8CC00, 0x3DE8D3FF, "HB" ],  // 61.232.204.0-61.232.211.255, HB
        [ 0x3DE8D400, 0x3DE8DFFF, "SC" ],  // 61.232.212.0-61.232.223.255, SC
        [ 0x3DE8E000, 0x3DE8E7FF, "CQ" ],  // 61.232.224.0-61.232.231.255, CQ
        [ 0x3DE8E800, 0x3DE8EBFF, "YN" ],  // 61.232.232.0-61.232.235.255, YN
        [ 0x3DE8EC00, 0x3DE8F3FF, "GS" ],  // 61.232.236.0-61.232.243.255, GS
        [ 0x3DE8F400, 0x3DE8FBFF, "NX" ],  // 61.232.244.0-61.232.251.255, NX
        [ 0x3DE8FC00, 0x3DE8FFFF, "XJ" ],  // 61.232.252.0-61.232.255.255, XJ
        [ 0x3DE90000, 0x3DE91FFF, "BJ" ],  // 61.233.0.0-61.233.31.255, BJ
        [ 0x3DE92000, 0x3DE92FFF, "HE" ],  // 61.233.32.0-61.233.47.255, HE
        [ 0x3DE93000, 0x3DE93FFF, "NM" ],  // 61.233.48.0-61.233.63.255, NM
        [ 0x3DE94000, 0x3DE97FFF, "HA" ],  // 61.233.64.0-61.233.127.255, HA
        [ 0x3DE98000, 0x3DE98FFF, "SX" ],  // 61.233.128.0-61.233.143.255, SX
        [ 0x3DE99000, 0x3DE99FFF, "SD" ],  // 61.233.144.0-61.233.159.255, SD
        [ 0x3DE9A000, 0x3DE9BFFF, "HL" ],  // 61.233.160.0-61.233.191.255, HL
        [ 0x3DE9C000, 0x3DE9CFFF, "XJ" ],  // 61.233.192.0-61.233.207.255, XJ
        [ 0x3DE9D000, 0x3DE9FFFF, "JX" ],  // 61.233.208.0-61.233.255.255, JX
        [ 0x3DEA0000, 0x3DEA0FFF, "GS" ],  // 61.234.0.0-61.234.15.255, GS
        [ 0x3DEA1000, 0x3DEA1FFF, "HE" ],  // 61.234.16.0-61.234.31.255, HE
        [ 0x3DEA2000, 0x3DEA3FFF, "GX" ],  // 61.234.32.0-61.234.63.255, GX
        [ 0x3DEA4000, 0x3DEA5FFF, "TJ" ],  // 61.234.64.0-61.234.95.255, TJ
        [ 0x3DEA6000, 0x3DEA7FFF, "GD" ],  // 61.234.96.0-61.234.127.255, GD
        [ 0x3DEA8000, 0x3DEA8FFF, "XJ" ],  // 61.234.128.0-61.234.143.255, XJ
        [ 0x3DEA9000, 0x3DEA9FFF, "HB" ],  // 61.234.144.0-61.234.159.255, HB
        [ 0x3DEAA000, 0x3DEAAFFF, "GD" ],  // 61.234.160.0-61.234.175.255, GD
        [ 0x3DEAB000, 0x3DEABFFF, "ZJ" ],  // 61.234.176.0-61.234.191.255, ZJ
        [ 0x3DEAC000, 0x3DEAE3FF, "FJ" ],  // 61.234.192.0-61.234.227.255, FJ
        [ 0x3DEAE400, 0x3DEAFFFF, "HN" ],  // 61.234.228.0-61.234.255.255, HN
        [ 0x3DEB0000, 0x3DEB23FF, "JX" ],  // 61.235.0.0-61.235.35.255, JX
        [ 0x3DEB2400, 0x3DEB2FFF, "AH" ],  // 61.235.36.0-61.235.47.255, AH
        [ 0x3DEB3000, 0x3DEB3FFF, "JL" ],  // 61.235.48.0-61.235.63.255, JL
        [ 0x3DEB4000, 0x3DEB83FF, "GD" ],  // 61.235.64.0-61.235.131.255, GD
        [ 0x3DEB8400, 0x3DEB9FFF, "HE" ],  // 61.235.132.0-61.235.159.255, HE
        [ 0x3DEBA000, 0x3DEBC3FF, "GX" ],  // 61.235.160.0-61.235.195.255, GX
        [ 0x3DEBC400, 0x3DEBDFFF, "CQ" ],  // 61.235.196.0-61.235.223.255, CQ
        [ 0x3DEBE000, 0x3DEBEFFF, "HI" ],  // 61.235.224.0-61.235.239.255, HI
        [ 0x3DEBF000, 0x3DEC3FFF, "LN" ],  // 61.235.240.0-61.236.63.255, LN
        [ 0x3DEC4000, 0x3DEC4FFF, "HN" ],  // 61.236.64.0-61.236.79.255, HN
        [ 0x3DEC5000, 0x3DEC77FF, "HL" ],  // 61.236.80.0-61.236.119.255, HL
        [ 0x3DEC7800, 0x3DEC9FFF, "SC" ],  // 61.236.120.0-61.236.159.255, SC
        [ 0x3DECA000, 0x3DECAFFF, "QH" ],  // 61.236.160.0-61.236.175.255, QH
        [ 0x3DECB000, 0x3DECCFFF, "GZ" ],  // 61.236.176.0-61.236.207.255, GZ
        [ 0x3DECD000, 0x3DECFFFF, "SN" ],  // 61.236.208.0-61.236.255.255, SN
        [ 0x3DED0000, 0x3DED0057, "GD" ],  // 61.237.0.0-61.237.0.87, GD
        [ 0x3DED0058, 0x3DED005F, "ZJ" ],  // 61.237.0.88-61.237.0.95, ZJ
        [ 0x3DED0060, 0x3DED006F, "GD" ],  // 61.237.0.96-61.237.0.111, GD
        [ 0x3DED0070, 0x3DED0081, "SH" ],  // 61.237.0.112-61.237.0.129, SH
        [ 0x3DED0082, 0x3DED0084, "GS" ],  // 61.237.0.130-61.237.0.132, GS
        [ 0x3DED0085, 0x3DED0085, "GD" ],  // 61.237.0.133-61.237.0.133, GD
        [ 0x3DED0086, 0x3DED0086, "TJ" ],  // 61.237.0.134-61.237.0.134, TJ
        [ 0x3DED0087, 0x3DED0088, "HA" ],  // 61.237.0.135-61.237.0.136, HA
        [ 0x3DED0089, 0x3DED008A, "GD" ],  // 61.237.0.137-61.237.0.138, GD
        [ 0x3DED008B, 0x3DED0090, "HA" ],  // 61.237.0.139-61.237.0.144, HA
        [ 0x3DED0091, 0x3DED009F, "GD" ],  // 61.237.0.145-61.237.0.159, GD
        [ 0x3DED00A0, 0x3DED00A7, "SH" ],  // 61.237.0.160-61.237.0.167, SH
        [ 0x3DED00A8, 0x3DED00A8, "HA" ],  // 61.237.0.168-61.237.0.168, HA
        [ 0x3DED00A9, 0x3DED00AA, "AH" ],  // 61.237.0.169-61.237.0.170, AH
        [ 0x3DED00AB, 0x3DED00AC, "HA" ],  // 61.237.0.171-61.237.0.172, HA
        [ 0x3DED00AD, 0x3DED00AE, "AH" ],  // 61.237.0.173-61.237.0.174, AH
        [ 0x3DED00AF, 0x3DED00AF, "HA" ],  // 61.237.0.175-61.237.0.175, HA
        [ 0x3DED00B0, 0x3DED00BF, "SH" ],  // 61.237.0.176-61.237.0.191, SH
        [ 0x3DED00C0, 0x3DED00C7, "GD" ],  // 61.237.0.192-61.237.0.199, GD
        [ 0x3DED00C8, 0x3DED00CB, "HI" ],  // 61.237.0.200-61.237.0.203, HI
        [ 0x3DED00CC, 0x3DED0103, "GD" ],  // 61.237.0.204-61.237.1.3, GD
        [ 0x3DED0104, 0x3DED0107, "JL" ],  // 61.237.1.4-61.237.1.7, JL
        [ 0x3DED0108, 0x3DED010B, "GD" ],  // 61.237.1.8-61.237.1.11, GD
        [ 0x3DED010C, 0x3DED011B, "HL" ],  // 61.237.1.12-61.237.1.27, HL
        [ 0x3DED011C, 0x3DED011D, "SH" ],  // 61.237.1.28-61.237.1.29, SH
        [ 0x3DED011E, 0x3DED011E, "HN" ],  // 61.237.1.30-61.237.1.30, HN
        [ 0x3DED011F, 0x3DED0120, "HL" ],  // 61.237.1.31-61.237.1.32, HL
        [ 0x3DED0121, 0x3DED0121, "SH" ],  // 61.237.1.33-61.237.1.33, SH
        [ 0x3DED0122, 0x3DED0122, "HN" ],  // 61.237.1.34-61.237.1.34, HN
        [ 0x3DED0123, 0x3DED0123, "HL" ],  // 61.237.1.35-61.237.1.35, HL
        [ 0x3DED0124, 0x3DED0133, "GD" ],  // 61.237.1.36-61.237.1.51, GD
        [ 0x3DED0134, 0x3DED0137, "HB" ],  // 61.237.1.52-61.237.1.55, HB
        [ 0x3DED0138, 0x3DED0138, "HL" ],  // 61.237.1.56-61.237.1.56, HL
        [ 0x3DED0139, 0x3DED013A, "FJ" ],  // 61.237.1.57-61.237.1.58, FJ
        [ 0x3DED013B, 0x3DED013F, "HL" ],  // 61.237.1.59-61.237.1.63, HL
        [ 0x3DED0140, 0x3DED0143, "HB" ],  // 61.237.1.64-61.237.1.67, HB
        [ 0x3DED0144, 0x3DED0144, "HL" ],  // 61.237.1.68-61.237.1.68, HL
        [ 0x3DED0145, 0x3DED0145, "SH" ],  // 61.237.1.69-61.237.1.69, SH
        [ 0x3DED0146, 0x3DED0146, "HN" ],  // 61.237.1.70-61.237.1.70, HN
        [ 0x3DED0147, 0x3DED0148, "HL" ],  // 61.237.1.71-61.237.1.72, HL
        [ 0x3DED0149, 0x3DED0149, "SH" ],  // 61.237.1.73-61.237.1.73, SH
        [ 0x3DED014A, 0x3DED014A, "HN" ],  // 61.237.1.74-61.237.1.74, HN
        [ 0x3DED014B, 0x3DED014B, "HL" ],  // 61.237.1.75-61.237.1.75, HL
        [ 0x3DED014C, 0x3DED014F, "LN" ],  // 61.237.1.76-61.237.1.79, LN
        [ 0x3DED0150, 0x3DED0154, "HL" ],  // 61.237.1.80-61.237.1.84, HL
        [ 0x3DED0155, 0x3DED0155, "BJ" ],  // 61.237.1.85-61.237.1.85, BJ
        [ 0x3DED0156, 0x3DED0157, "HL" ],  // 61.237.1.86-61.237.1.87, HL
        [ 0x3DED0158, 0x3DED015B, "LN" ],  // 61.237.1.88-61.237.1.91, LN
        [ 0x3DED015C, 0x3DED015F, "NM" ],  // 61.237.1.92-61.237.1.95, NM
        [ 0x3DED0160, 0x3DED0160, "HL" ],  // 61.237.1.96-61.237.1.96, HL
        [ 0x3DED0161, 0x3DED0161, "BJ" ],  // 61.237.1.97-61.237.1.97, BJ
        [ 0x3DED0162, 0x3DED0163, "HL" ],  // 61.237.1.98-61.237.1.99, HL
        [ 0x3DED0164, 0x3DED0167, "SN" ],  // 61.237.1.100-61.237.1.103, SN
        [ 0x3DED0168, 0x3DED0168, "HL" ],  // 61.237.1.104-61.237.1.104, HL
        [ 0x3DED0169, 0x3DED0169, "BJ" ],  // 61.237.1.105-61.237.1.105, BJ
        [ 0x3DED016A, 0x3DED016A, "HE" ],  // 61.237.1.106-61.237.1.106, HE
        [ 0x3DED016B, 0x3DED016C, "HL" ],  // 61.237.1.107-61.237.1.108, HL
        [ 0x3DED016D, 0x3DED016D, "BJ" ],  // 61.237.1.109-61.237.1.109, BJ
        [ 0x3DED016E, 0x3DED016E, "HE" ],  // 61.237.1.110-61.237.1.110, HE
        [ 0x3DED016F, 0x3DED0170, "HL" ],  // 61.237.1.111-61.237.1.112, HL
        [ 0x3DED0171, 0x3DED0171, "GD" ],  // 61.237.1.113-61.237.1.113, GD
        [ 0x3DED0172, 0x3DED0172, "BJ" ],  // 61.237.1.114-61.237.1.114, BJ
        [ 0x3DED0173, 0x3DED0173, "HN" ],  // 61.237.1.115-61.237.1.115, HN
        [ 0x3DED0174, 0x3DED0177, "HB" ],  // 61.237.1.116-61.237.1.119, HB
        [ 0x3DED0178, 0x3DED017B, "SN" ],  // 61.237.1.120-61.237.1.123, SN
        [ 0x3DED017C, 0x3DED017F, "HB" ],  // 61.237.1.124-61.237.1.127, HB
        [ 0x3DED0180, 0x3DED0183, "SC" ],  // 61.237.1.128-61.237.1.131, SC
        [ 0x3DED0184, 0x3DED018F, "HB" ],  // 61.237.1.132-61.237.1.143, HB
        [ 0x3DED0190, 0x3DED0193, "SC" ],  // 61.237.1.144-61.237.1.147, SC
        [ 0x3DED0194, 0x3DED0197, "HB" ],  // 61.237.1.148-61.237.1.151, HB
        [ 0x3DED0198, 0x3DED019B, "HN" ],  // 61.237.1.152-61.237.1.155, HN
        [ 0x3DED019C, 0x3DED019F, "HB" ],  // 61.237.1.156-61.237.1.159, HB
        [ 0x3DED01A0, 0x3DED01A3, "SX" ],  // 61.237.1.160-61.237.1.163, SX
        [ 0x3DED01A4, 0x3DED01A7, "HE" ],  // 61.237.1.164-61.237.1.167, HE
        [ 0x3DED01A8, 0x3DED01AB, "TJ" ],  // 61.237.1.168-61.237.1.171, TJ
        [ 0x3DED01AC, 0x3DED01AF, "SD" ],  // 61.237.1.172-61.237.1.175, SD
        [ 0x3DED01B0, 0x3DED01B3, "HB" ],  // 61.237.1.176-61.237.1.179, HB
        [ 0x3DED01B4, 0x3DED01B7, "XJ" ],  // 61.237.1.180-61.237.1.183, XJ
        [ 0x3DED01B8, 0x3DED01BB, "HN" ],  // 61.237.1.184-61.237.1.187, HN
        [ 0x3DED01BC, 0x3DED01BF, "HL" ],  // 61.237.1.188-61.237.1.191, HL
        [ 0x3DED01C0, 0x3DED01C3, "GD" ],  // 61.237.1.192-61.237.1.195, GD
        [ 0x3DED01C4, 0x3DED01C7, "JL" ],  // 61.237.1.196-61.237.1.199, JL
        [ 0x3DED01C8, 0x3DED01C8, "HN" ],  // 61.237.1.200-61.237.1.200, HN
        [ 0x3DED01C9, 0x3DED01C9, "GD" ],  // 61.237.1.201-61.237.1.201, GD
        [ 0x3DED01CA, 0x3DED01CA, "GX" ],  // 61.237.1.202-61.237.1.202, GX
        [ 0x3DED01CB, 0x3DED01CC, "HN" ],  // 61.237.1.203-61.237.1.204, HN
        [ 0x3DED01CD, 0x3DED01CD, "GD" ],  // 61.237.1.205-61.237.1.205, GD
        [ 0x3DED01CE, 0x3DED01CE, "GX" ],  // 61.237.1.206-61.237.1.206, GX
        [ 0x3DED01CF, 0x3DED01CF, "HN" ],  // 61.237.1.207-61.237.1.207, HN
        [ 0x3DED01D0, 0x3DED01D3, "JS" ],  // 61.237.1.208-61.237.1.211, JS
        [ 0x3DED01D4, 0x3DED01D7, "HN" ],  // 61.237.1.212-61.237.1.215, HN
        [ 0x3DED01D8, 0x3DED01DB, "AH" ],  // 61.237.1.216-61.237.1.219, AH
        [ 0x3DED01DC, 0x3DED01DF, "HN" ],  // 61.237.1.220-61.237.1.223, HN
        [ 0x3DED01E0, 0x3DED01E3, "GD" ],  // 61.237.1.224-61.237.1.227, GD
        [ 0x3DED01E4, 0x3DED01E7, "JX" ],  // 61.237.1.228-61.237.1.231, JX
        [ 0x3DED01E8, 0x3DED01EB, "ZJ" ],  // 61.237.1.232-61.237.1.235, ZJ
        [ 0x3DED01EC, 0x3DED01EF, "SN" ],  // 61.237.1.236-61.237.1.239, SN
        [ 0x3DED01F0, 0x3DED01F7, "FJ" ],  // 61.237.1.240-61.237.1.247, FJ
        [ 0x3DED01F8, 0x3DED01FB, "HA" ],  // 61.237.1.248-61.237.1.251, HA
        [ 0x3DED01FC, 0x3DED02FF, "HN" ],  // 61.237.1.252-61.237.2.255, HN
        [ 0x3DED0300, 0x3DED04FF, "BJ" ],  // 61.237.3.0-61.237.4.255, BJ
        [ 0x3DED0500, 0x3DED051F, "GD" ],  // 61.237.5.0-61.237.5.31, GD
        [ 0x3DED0520, 0x3DED0530, "BJ" ],  // 61.237.5.32-61.237.5.48, BJ
        [ 0x3DED0531, 0x3DED0532, "HE" ],  // 61.237.5.49-61.237.5.50, HE
        [ 0x3DED0533, 0x3DED0533, "BJ" ],  // 61.237.5.51-61.237.5.51, BJ
        [ 0x3DED0534, 0x3DED0537, "HE" ],  // 61.237.5.52-61.237.5.55, HE
        [ 0x3DED0538, 0x3DED0554, "BJ" ],  // 61.237.5.56-61.237.5.84, BJ
        [ 0x3DED0555, 0x3DED0556, "SD" ],  // 61.237.5.85-61.237.5.86, SD
        [ 0x3DED0557, 0x3DED057F, "BJ" ],  // 61.237.5.87-61.237.5.127, BJ
        [ 0x3DED0580, 0x3DED0583, "SD" ],  // 61.237.5.128-61.237.5.131, SD
        [ 0x3DED0584, 0x3DED05FF, "BJ" ],  // 61.237.5.132-61.237.5.255, BJ
        [ 0x3DED0600, 0x3DED06FF, "HA" ],  // 61.237.6.0-61.237.6.255, HA
        [ 0x3DED0700, 0x3DED0728, "BJ" ],  // 61.237.7.0-61.237.7.40, BJ
        [ 0x3DED0729, 0x3DED072A, "HN" ],  // 61.237.7.41-61.237.7.42, HN
        [ 0x3DED072B, 0x3DED073F, "BJ" ],  // 61.237.7.43-61.237.7.63, BJ
        [ 0x3DED0740, 0x3DED074B, "HA" ],  // 61.237.7.64-61.237.7.75, HA
        [ 0x3DED074C, 0x3DED0777, "BJ" ],  // 61.237.7.76-61.237.7.119, BJ
        [ 0x3DED0778, 0x3DED079F, "XJ" ],  // 61.237.7.120-61.237.7.159, XJ
        [ 0x3DED07A0, 0x3DED07BF, "BJ" ],  // 61.237.7.160-61.237.7.191, BJ
        [ 0x3DED07C0, 0x3DED07D4, "HA" ],  // 61.237.7.192-61.237.7.212, HA
        [ 0x3DED07D5, 0x3DED07D5, "QH" ],  // 61.237.7.213-61.237.7.213, QH
        [ 0x3DED07D6, 0x3DED07D6, "XZ" ],  // 61.237.7.214-61.237.7.214, XZ
        [ 0x3DED07D7, 0x3DED07FF, "HA" ],  // 61.237.7.215-61.237.7.255, HA
        [ 0x3DED0800, 0x3DED09FF, "BJ" ],  // 61.237.8.0-61.237.9.255, BJ
        [ 0x3DED0A00, 0x3DED0AFF, "SC" ],  // 61.237.10.0-61.237.10.255, SC
        [ 0x3DED0B00, 0x3DED0B3F, "LN" ],  // 61.237.11.0-61.237.11.63, LN
        [ 0x3DED0B40, 0x3DED0B7F, "SN" ],  // 61.237.11.64-61.237.11.127, SN
        [ 0x3DED0B80, 0x3DED0BBF, "SC" ],  // 61.237.11.128-61.237.11.191, SC
        [ 0x3DED0BC0, 0x3DED0BDF, "NM" ],  // 61.237.11.192-61.237.11.223, NM
        [ 0x3DED0BE0, 0x3DED0C1F, "SX" ],  // 61.237.11.224-61.237.12.31, SX
        [ 0x3DED0C20, 0x3DED0C3F, "HE" ],  // 61.237.12.32-61.237.12.63, HE
        [ 0x3DED0C40, 0x3DED0C5F, "TJ" ],  // 61.237.12.64-61.237.12.95, TJ
        [ 0x3DED0C60, 0x3DED0C7F, "SD" ],  // 61.237.12.96-61.237.12.127, SD
        [ 0x3DED0C80, 0x3DED0C9F, "JS" ],  // 61.237.12.128-61.237.12.159, JS
        [ 0x3DED0CA0, 0x3DED0CFF, "JL" ],  // 61.237.12.160-61.237.12.255, JL
        [ 0x3DED0D00, 0x3DED0D1F, "LN" ],  // 61.237.13.0-61.237.13.31, LN
        [ 0x3DED0D20, 0x3DED0D3F, "FJ" ],  // 61.237.13.32-61.237.13.63, FJ
        [ 0x3DED0D40, 0x3DED0D5F, "JS" ],  // 61.237.13.64-61.237.13.95, JS
        [ 0x3DED0D60, 0x3DED0D7F, "AH" ],  // 61.237.13.96-61.237.13.127, AH
        [ 0x3DED0D80, 0x3DED0DBF, "FJ" ],  // 61.237.13.128-61.237.13.191, FJ
        [ 0x3DED0DC0, 0x3DED0DDF, "ZJ" ],  // 61.237.13.192-61.237.13.223, ZJ
        [ 0x3DED0DE0, 0x3DED0E1F, "FJ" ],  // 61.237.13.224-61.237.14.31, FJ
        [ 0x3DED0E20, 0x3DED0E3F, "HA" ],  // 61.237.14.32-61.237.14.63, HA
        [ 0x3DED0E40, 0x3DED0E5F, "GD" ],  // 61.237.14.64-61.237.14.95, GD
        [ 0x3DED0E60, 0x3DED0E7F, "FJ" ],  // 61.237.14.96-61.237.14.127, FJ
        [ 0x3DED0E80, 0x3DED0E9F, "HN" ],  // 61.237.14.128-61.237.14.159, HN
        [ 0x3DED0EA0, 0x3DED0EFF, "SD" ],  // 61.237.14.160-61.237.14.255, SD
        [ 0x3DED0F00, 0x3DED0F1F, "GX" ],  // 61.237.15.0-61.237.15.31, GX
        [ 0x3DED0F20, 0x3DED0F3F, "GZ" ],  // 61.237.15.32-61.237.15.63, GZ
        [ 0x3DED0F40, 0x3DED0F5F, "CQ" ],  // 61.237.15.64-61.237.15.95, CQ
        [ 0x3DED0F60, 0x3DED0F7F, "QH" ],  // 61.237.15.96-61.237.15.127, QH
        [ 0x3DED0F80, 0x3DED0F9F, "XJ" ],  // 61.237.15.128-61.237.15.159, XJ
        [ 0x3DED0FA0, 0x3DED0FBF, "GS" ],  // 61.237.15.160-61.237.15.191, GS
        [ 0x3DED0FC0, 0x3DED0FDF, "NX" ],  // 61.237.15.192-61.237.15.223, NX
        [ 0x3DED0FE0, 0x3DED105F, "NM" ],  // 61.237.15.224-61.237.16.95, NM
        [ 0x3DED1060, 0x3DED106F, "SX" ],  // 61.237.16.96-61.237.16.111, SX
        [ 0x3DED1070, 0x3DED10FF, "HE" ],  // 61.237.16.112-61.237.16.255, HE
        [ 0x3DED1100, 0x3DED11BF, "SD" ],  // 61.237.17.0-61.237.17.191, SD
        [ 0x3DED11C0, 0x3DED11DF, "JS" ],  // 61.237.17.192-61.237.17.223, JS
        [ 0x3DED11E0, 0x3DED11FF, "SD" ],  // 61.237.17.224-61.237.17.255, SD
        [ 0x3DED1200, 0x3DED15FF, "LN" ],  // 61.237.18.0-61.237.21.255, LN
        [ 0x3DED1600, 0x3DED161F, "ZJ" ],  // 61.237.22.0-61.237.22.31, ZJ
        [ 0x3DED1620, 0x3DED16DF, "LN" ],  // 61.237.22.32-61.237.22.223, LN
        [ 0x3DED16E0, 0x3DED16FF, "HB" ],  // 61.237.22.224-61.237.22.255, HB
        [ 0x3DED1700, 0x3DED181F, "LN" ],  // 61.237.23.0-61.237.24.31, LN
        [ 0x3DED1820, 0x3DED183F, "HN" ],  // 61.237.24.32-61.237.24.63, HN
        [ 0x3DED1840, 0x3DED185D, "LN" ],  // 61.237.24.64-61.237.24.93, LN
        [ 0x3DED185E, 0x3DED185E, "HN" ],  // 61.237.24.94-61.237.24.94, HN
        [ 0x3DED185F, 0x3DED187F, "LN" ],  // 61.237.24.95-61.237.24.127, LN
        [ 0x3DED1880, 0x3DED18BF, "HN" ],  // 61.237.24.128-61.237.24.191, HN
        [ 0x3DED18C0, 0x3DED18DF, "LN" ],  // 61.237.24.192-61.237.24.223, LN
        [ 0x3DED18E0, 0x3DED18FF, "CQ" ],  // 61.237.24.224-61.237.24.255, CQ
        [ 0x3DED1900, 0x3DED1AFF, "LN" ],  // 61.237.25.0-61.237.26.255, LN
        [ 0x3DED1B00, 0x3DED1B1F, "HE" ],  // 61.237.27.0-61.237.27.31, HE
        [ 0x3DED1B20, 0x3DED1CFF, "LN" ],  // 61.237.27.32-61.237.28.255, LN
        [ 0x3DED1D00, 0x3DED1D0F, "ZJ" ],  // 61.237.29.0-61.237.29.15, ZJ
        [ 0x3DED1D10, 0x3DED1D3F, "BJ" ],  // 61.237.29.16-61.237.29.63, BJ
        [ 0x3DED1D40, 0x3DED1D43, "GD" ],  // 61.237.29.64-61.237.29.67, GD
        [ 0x3DED1D44, 0x3DED1DA3, "BJ" ],  // 61.237.29.68-61.237.29.163, BJ
        [ 0x3DED1DA4, 0x3DED1DA7, "SH" ],  // 61.237.29.164-61.237.29.167, SH
        [ 0x3DED1DA8, 0x3DED1DDB, "BJ" ],  // 61.237.29.168-61.237.29.219, BJ
        [ 0x3DED1DDC, 0x3DED1DDF, "FJ" ],  // 61.237.29.220-61.237.29.223, FJ
        [ 0x3DED1DE0, 0x3DED1DEB, "BJ" ],  // 61.237.29.224-61.237.29.235, BJ
        [ 0x3DED1DEC, 0x3DED1DF3, "FJ" ],  // 61.237.29.236-61.237.29.243, FJ
        [ 0x3DED1DF4, 0x3DED1DF7, "BJ" ],  // 61.237.29.244-61.237.29.247, BJ
        [ 0x3DED1DF8, 0x3DED1DFB, "ZJ" ],  // 61.237.29.248-61.237.29.251, ZJ
        [ 0x3DED1DFC, 0x3DED1DFF, "BJ" ],  // 61.237.29.252-61.237.29.255, BJ
        [ 0x3DED1E00, 0x3DED1EFF, "HN" ],  // 61.237.30.0-61.237.30.255, HN
        [ 0x3DED1F00, 0x3DED1F1F, "HA" ],  // 61.237.31.0-61.237.31.31, HA
        [ 0x3DED1F20, 0x3DED1F67, "BJ" ],  // 61.237.31.32-61.237.31.103, BJ
        [ 0x3DED1F68, 0x3DED1F6B, "HA" ],  // 61.237.31.104-61.237.31.107, HA
        [ 0x3DED1F6C, 0x3DED1F77, "BJ" ],  // 61.237.31.108-61.237.31.119, BJ
        [ 0x3DED1F78, 0x3DED1F7B, "GD" ],  // 61.237.31.120-61.237.31.123, GD
        [ 0x3DED1F7C, 0x3DED1F7F, "JS" ],  // 61.237.31.124-61.237.31.127, JS
        [ 0x3DED1F80, 0x3DED1F97, "BJ" ],  // 61.237.31.128-61.237.31.151, BJ
        [ 0x3DED1F98, 0x3DED1FA3, "HA" ],  // 61.237.31.152-61.237.31.163, HA
        [ 0x3DED1FA4, 0x3DED1FAF, "BJ" ],  // 61.237.31.164-61.237.31.175, BJ
        [ 0x3DED1FB0, 0x3DED1FB3, "SC" ],  // 61.237.31.176-61.237.31.179, SC
        [ 0x3DED1FB4, 0x3DED1FBB, "BJ" ],  // 61.237.31.180-61.237.31.187, BJ
        [ 0x3DED1FBC, 0x3DED1FC7, "GD" ],  // 61.237.31.188-61.237.31.199, GD
        [ 0x3DED1FC8, 0x3DED1FD7, "BJ" ],  // 61.237.31.200-61.237.31.215, BJ
        [ 0x3DED1FD8, 0x3DED1FDB, "HA" ],  // 61.237.31.216-61.237.31.219, HA
        [ 0x3DED1FDC, 0x3DED1FDF, "BJ" ],  // 61.237.31.220-61.237.31.223, BJ
        [ 0x3DED1FE0, 0x3DED1FE3, "SX" ],  // 61.237.31.224-61.237.31.227, SX
        [ 0x3DED1FE4, 0x3DED1FEF, "BJ" ],  // 61.237.31.228-61.237.31.239, BJ
        [ 0x3DED1FF0, 0x3DED1FF3, "ZJ" ],  // 61.237.31.240-61.237.31.243, ZJ
        [ 0x3DED1FF4, 0x3DED1FFF, "BJ" ],  // 61.237.31.244-61.237.31.255, BJ
        [ 0x3DED2000, 0x3DED20FF, "SD" ],  // 61.237.32.0-61.237.32.255, SD
        [ 0x3DED2100, 0x3DED21FF, "NM" ],  // 61.237.33.0-61.237.33.255, NM
        [ 0x3DED2200, 0x3DED23FF, "HA" ],  // 61.237.34.0-61.237.35.255, HA
        [ 0x3DED2400, 0x3DED241F, "BJ" ],  // 61.237.36.0-61.237.36.31, BJ
        [ 0x3DED2420, 0x3DED24FF, "HA" ],  // 61.237.36.32-61.237.36.255, HA
        [ 0x3DED2500, 0x3DED25FF, "HE" ],  // 61.237.37.0-61.237.37.255, HE
        [ 0x3DED2600, 0x3DED37FF, "HA" ],  // 61.237.38.0-61.237.55.255, HA
        [ 0x3DED3800, 0x3DED38FF, "QH" ],  // 61.237.56.0-61.237.56.255, QH
        [ 0x3DED3900, 0x3DED3FFF, "HA" ],  // 61.237.57.0-61.237.63.255, HA
        [ 0x3DED4000, 0x3DED4003, "HN" ],  // 61.237.64.0-61.237.64.3, HN
        [ 0x3DED4004, 0x3DED4004, "ZJ" ],  // 61.237.64.4-61.237.64.4, ZJ
        [ 0x3DED4005, 0x3DED4006, "HN" ],  // 61.237.64.5-61.237.64.6, HN
        [ 0x3DED4007, 0x3DED400D, "GD" ],  // 61.237.64.7-61.237.64.13, GD
        [ 0x3DED400E, 0x3DED4048, "HE" ],  // 61.237.64.14-61.237.64.72, HE
        [ 0x3DED4049, 0x3DED409C, "ZJ" ],  // 61.237.64.73-61.237.64.156, ZJ
        [ 0x3DED409D, 0x3DED40E4, "HN" ],  // 61.237.64.157-61.237.64.228, HN
        [ 0x3DED40E5, 0x3DED40E7, "HI" ],  // 61.237.64.229-61.237.64.231, HI
        [ 0x3DED40E8, 0x3DED4163, "GS" ],  // 61.237.64.232-61.237.65.99, GS
        [ 0x3DED4164, 0x3DED4167, "SH" ],  // 61.237.65.100-61.237.65.103, SH
        [ 0x3DED4168, 0x3DED41BB, "GD" ],  // 61.237.65.104-61.237.65.187, GD
        [ 0x3DED41BC, 0x3DED41D2, "HL" ],  // 61.237.65.188-61.237.65.210, HL
        [ 0x3DED41D3, 0x3DED4275, "SC" ],  // 61.237.65.211-61.237.66.117, SC
        [ 0x3DED4276, 0x3DED43FF, "HL" ],  // 61.237.66.118-61.237.67.255, HL
        [ 0x3DED4400, 0x3DED4473, "JS" ],  // 61.237.68.0-61.237.68.115, JS
        [ 0x3DED4474, 0x3DED4477, "SH" ],  // 61.237.68.116-61.237.68.119, SH
        [ 0x3DED4478, 0x3DED447F, "JS" ],  // 61.237.68.120-61.237.68.127, JS
        [ 0x3DED4480, 0x3DED485E, "GD" ],  // 61.237.68.128-61.237.72.94, GD
        [ 0x3DED485F, 0x3DED49FF, "HN" ],  // 61.237.72.95-61.237.73.255, HN
        [ 0x3DED4A00, 0x3DED4FFF, "NM" ],  // 61.237.74.0-61.237.79.255, NM
        [ 0x3DED5000, 0x3DED50FF, "BJ" ],  // 61.237.80.0-61.237.80.255, BJ
        [ 0x3DED5100, 0x3DED51FF, "HA" ],  // 61.237.81.0-61.237.81.255, HA
        [ 0x3DED5200, 0x3DED52FF, "JS" ],  // 61.237.82.0-61.237.82.255, JS
        [ 0x3DED5300, 0x3DED53FF, "HA" ],  // 61.237.83.0-61.237.83.255, HA
        [ 0x3DED5400, 0x3DED55FF, "ZJ" ],  // 61.237.84.0-61.237.85.255, ZJ
        [ 0x3DED5600, 0x3DED57FF, "GS" ],  // 61.237.86.0-61.237.87.255, GS
        [ 0x3DED5800, 0x3DED58FF, "HL" ],  // 61.237.88.0-61.237.88.255, HL
        [ 0x3DED5900, 0x3DED59FF, "HA" ],  // 61.237.89.0-61.237.89.255, HA
        [ 0x3DED5A00, 0x3DED5AFF, "HL" ],  // 61.237.90.0-61.237.90.255, HL
        [ 0x3DED5B00, 0x3DED5BFF, "GZ" ],  // 61.237.91.0-61.237.91.255, GZ
        [ 0x3DED5C00, 0x3DED5DFF, "BJ" ],  // 61.237.92.0-61.237.93.255, BJ
        [ 0x3DED5E00, 0x3DED5EFF, "SC" ],  // 61.237.94.0-61.237.94.255, SC
        [ 0x3DED5F00, 0x3DED5FFF, "GS" ],  // 61.237.95.0-61.237.95.255, GS
        [ 0x3DED6000, 0x3DED60FF, "GD" ],  // 61.237.96.0-61.237.96.255, GD
        [ 0x3DED6100, 0x3DED6103, "HA" ],  // 61.237.97.0-61.237.97.3, HA
        [ 0x3DED6104, 0x3DED6104, "GD" ],  // 61.237.97.4-61.237.97.4, GD
        [ 0x3DED6105, 0x3DED6105, "BJ" ],  // 61.237.97.5-61.237.97.5, BJ
        [ 0x3DED6106, 0x3DED6106, "HL" ],  // 61.237.97.6-61.237.97.6, HL
        [ 0x3DED6107, 0x3DED610B, "GS" ],  // 61.237.97.7-61.237.97.11, GS
        [ 0x3DED610C, 0x3DED610F, "YN" ],  // 61.237.97.12-61.237.97.15, YN
        [ 0x3DED6110, 0x3DED6121, "GX" ],  // 61.237.97.16-61.237.97.33, GX
        [ 0x3DED6122, 0x3DED6138, "BJ" ],  // 61.237.97.34-61.237.97.56, BJ
        [ 0x3DED6139, 0x3DED613F, "SX" ],  // 61.237.97.57-61.237.97.63, SX
        [ 0x3DED6140, 0x3DED6141, "JL" ],  // 61.237.97.64-61.237.97.65, JL
        [ 0x3DED6142, 0x3DED6142, "HL" ],  // 61.237.97.66-61.237.97.66, HL
        [ 0x3DED6143, 0x3DED6143, "JL" ],  // 61.237.97.67-61.237.97.67, JL
        [ 0x3DED6144, 0x3DED615B, "JX" ],  // 61.237.97.68-61.237.97.91, JX
        [ 0x3DED615C, 0x3DED6160, "JS" ],  // 61.237.97.92-61.237.97.96, JS
        [ 0x3DED6161, 0x3DED6161, "SH" ],  // 61.237.97.97-61.237.97.97, SH
        [ 0x3DED6162, 0x3DED6163, "JS" ],  // 61.237.97.98-61.237.97.99, JS
        [ 0x3DED6164, 0x3DED6167, "GZ" ],  // 61.237.97.100-61.237.97.103, GZ
        [ 0x3DED6168, 0x3DED6179, "JS" ],  // 61.237.97.104-61.237.97.121, JS
        [ 0x3DED617A, 0x3DED6187, "BJ" ],  // 61.237.97.122-61.237.97.135, BJ
        [ 0x3DED6188, 0x3DED6197, "GX" ],  // 61.237.97.136-61.237.97.151, GX
        [ 0x3DED6198, 0x3DED619B, "XJ" ],  // 61.237.97.152-61.237.97.155, XJ
        [ 0x3DED619C, 0x3DED61A0, "GX" ],  // 61.237.97.156-61.237.97.160, GX
        [ 0x3DED61A1, 0x3DED61A1, "GD" ],  // 61.237.97.161-61.237.97.161, GD
        [ 0x3DED61A2, 0x3DED61A3, "GX" ],  // 61.237.97.162-61.237.97.163, GX
        [ 0x3DED61A4, 0x3DED61AB, "HL" ],  // 61.237.97.164-61.237.97.171, HL
        [ 0x3DED61AC, 0x3DED61AF, "HE" ],  // 61.237.97.172-61.237.97.175, HE
        [ 0x3DED61B0, 0x3DED61B3, "LN" ],  // 61.237.97.176-61.237.97.179, LN
        [ 0x3DED61B4, 0x3DED61B7, "NX" ],  // 61.237.97.180-61.237.97.183, NX
        [ 0x3DED61B8, 0x3DED61BB, "GX" ],  // 61.237.97.184-61.237.97.187, GX
        [ 0x3DED61BC, 0x3DED61BF, "QH" ],  // 61.237.97.188-61.237.97.191, QH
        [ 0x3DED61C0, 0x3DED61C3, "GX" ],  // 61.237.97.192-61.237.97.195, GX
        [ 0x3DED61C4, 0x3DED61C7, "GS" ],  // 61.237.97.196-61.237.97.199, GS
        [ 0x3DED61C8, 0x3DED61CB, "BJ" ],  // 61.237.97.200-61.237.97.203, BJ
        [ 0x3DED61CC, 0x3DED61CF, "SD" ],  // 61.237.97.204-61.237.97.207, SD
        [ 0x3DED61D0, 0x3DED61FF, "GX" ],  // 61.237.97.208-61.237.97.255, GX
        [ 0x3DED6200, 0x3DED62C7, "HE" ],  // 61.237.98.0-61.237.98.199, HE
        [ 0x3DED62C8, 0x3DED62CB, "GZ" ],  // 61.237.98.200-61.237.98.203, GZ
        [ 0x3DED62CC, 0x3DED62CF, "JX" ],  // 61.237.98.204-61.237.98.207, JX
        [ 0x3DED62D0, 0x3DED62FB, "HE" ],  // 61.237.98.208-61.237.98.251, HE
        [ 0x3DED62FC, 0x3DED62FF, "AH" ],  // 61.237.98.252-61.237.98.255, AH
        [ 0x3DED6300, 0x3DED63FF, "XJ" ],  // 61.237.99.0-61.237.99.255, XJ
        [ 0x3DED6400, 0x3DED64FF, "LN" ],  // 61.237.100.0-61.237.100.255, LN
        [ 0x3DED6500, 0x3DED6FFF, "HA" ],  // 61.237.101.0-61.237.111.255, HA
        [ 0x3DED7000, 0x3DED7007, "BJ" ],  // 61.237.112.0-61.237.112.7, BJ
        [ 0x3DED7008, 0x3DED700F, "ZJ" ],  // 61.237.112.8-61.237.112.15, ZJ
        [ 0x3DED7010, 0x3DED7017, "HA" ],  // 61.237.112.16-61.237.112.23, HA
        [ 0x3DED7018, 0x3DED701B, "BJ" ],  // 61.237.112.24-61.237.112.27, BJ
        [ 0x3DED701C, 0x3DED7023, "HA" ],  // 61.237.112.28-61.237.112.35, HA
        [ 0x3DED7024, 0x3DED7027, "BJ" ],  // 61.237.112.36-61.237.112.39, BJ
        [ 0x3DED7028, 0x3DED702B, "HA" ],  // 61.237.112.40-61.237.112.43, HA
        [ 0x3DED702C, 0x3DED7047, "BJ" ],  // 61.237.112.44-61.237.112.71, BJ
        [ 0x3DED7048, 0x3DED704F, "SH" ],  // 61.237.112.72-61.237.112.79, SH
        [ 0x3DED7050, 0x3DED7053, "HA" ],  // 61.237.112.80-61.237.112.83, HA
        [ 0x3DED7054, 0x3DED7057, "HN" ],  // 61.237.112.84-61.237.112.87, HN
        [ 0x3DED7058, 0x3DED705B, "BJ" ],  // 61.237.112.88-61.237.112.91, BJ
        [ 0x3DED705C, 0x3DED705F, "ZJ" ],  // 61.237.112.92-61.237.112.95, ZJ
        [ 0x3DED7060, 0x3DED7063, "JS" ],  // 61.237.112.96-61.237.112.99, JS
        [ 0x3DED7064, 0x3DED7067, "HA" ],  // 61.237.112.100-61.237.112.103, HA
        [ 0x3DED7068, 0x3DED706F, "TJ" ],  // 61.237.112.104-61.237.112.111, TJ
        [ 0x3DED7070, 0x3DED7073, "ZJ" ],  // 61.237.112.112-61.237.112.115, ZJ
        [ 0x3DED7074, 0x3DED7077, "HN" ],  // 61.237.112.116-61.237.112.119, HN
        [ 0x3DED7078, 0x3DED707B, "HA" ],  // 61.237.112.120-61.237.112.123, HA
        [ 0x3DED707C, 0x3DED707F, "LN" ],  // 61.237.112.124-61.237.112.127, LN
        [ 0x3DED7080, 0x3DED7087, "BJ" ],  // 61.237.112.128-61.237.112.135, BJ
        [ 0x3DED7088, 0x3DED708B, "HA" ],  // 61.237.112.136-61.237.112.139, HA
        [ 0x3DED708C, 0x3DED708F, "BJ" ],  // 61.237.112.140-61.237.112.143, BJ
        [ 0x3DED7090, 0x3DED7093, "JS" ],  // 61.237.112.144-61.237.112.147, JS
        [ 0x3DED7094, 0x3DED7097, "HA" ],  // 61.237.112.148-61.237.112.151, HA
        [ 0x3DED7098, 0x3DED709F, "BJ" ],  // 61.237.112.152-61.237.112.159, BJ
        [ 0x3DED70A0, 0x3DED70A3, "HA" ],  // 61.237.112.160-61.237.112.163, HA
        [ 0x3DED70A4, 0x3DED70A7, "ZJ" ],  // 61.237.112.164-61.237.112.167, ZJ
        [ 0x3DED70A8, 0x3DED70AF, "BJ" ],  // 61.237.112.168-61.237.112.175, BJ
        [ 0x3DED70B0, 0x3DED70C3, "HA" ],  // 61.237.112.176-61.237.112.195, HA
        [ 0x3DED70C4, 0x3DED70C7, "BJ" ],  // 61.237.112.196-61.237.112.199, BJ
        [ 0x3DED70C8, 0x3DED70D3, "HA" ],  // 61.237.112.200-61.237.112.211, HA
        [ 0x3DED70D4, 0x3DED70D7, "ZJ" ],  // 61.237.112.212-61.237.112.215, ZJ
        [ 0x3DED70D8, 0x3DED70DB, "BJ" ],  // 61.237.112.216-61.237.112.219, BJ
        [ 0x3DED70DC, 0x3DED70DF, "HA" ],  // 61.237.112.220-61.237.112.223, HA
        [ 0x3DED70E0, 0x3DED70E7, "BJ" ],  // 61.237.112.224-61.237.112.231, BJ
        [ 0x3DED70E8, 0x3DED70EF, "ZJ" ],  // 61.237.112.232-61.237.112.239, ZJ
        [ 0x3DED70F0, 0x3DED70F3, "XJ" ],  // 61.237.112.240-61.237.112.243, XJ
        [ 0x3DED70F4, 0x3DED70F7, "HA" ],  // 61.237.112.244-61.237.112.247, HA
        [ 0x3DED70F8, 0x3DED70FB, "BJ" ],  // 61.237.112.248-61.237.112.251, BJ
        [ 0x3DED70FC, 0x3DED70FF, "ZJ" ],  // 61.237.112.252-61.237.112.255, ZJ
        [ 0x3DED7100, 0x3DED771F, "JL" ],  // 61.237.113.0-61.237.119.31, JL
        [ 0x3DED7720, 0x3DED7727, "BJ" ],  // 61.237.119.32-61.237.119.39, BJ
        [ 0x3DED7728, 0x3DED7757, "HN" ],  // 61.237.119.40-61.237.119.87, HN
        [ 0x3DED7758, 0x3DED7773, "GD" ],  // 61.237.119.88-61.237.119.115, GD
        [ 0x3DED7774, 0x3DED777B, "HN" ],  // 61.237.119.116-61.237.119.123, HN
        [ 0x3DED777C, 0x3DED7794, "BJ" ],  // 61.237.119.124-61.237.119.148, BJ
        [ 0x3DED7795, 0x3DED7795, "SH" ],  // 61.237.119.149-61.237.119.149, SH
        [ 0x3DED7796, 0x3DED7796, "JS" ],  // 61.237.119.150-61.237.119.150, JS
        [ 0x3DED7797, 0x3DED779F, "BJ" ],  // 61.237.119.151-61.237.119.159, BJ
        [ 0x3DED77A0, 0x3DED77BF, "SN" ],  // 61.237.119.160-61.237.119.191, SN
        [ 0x3DED77C0, 0x3DED77FF, "BJ" ],  // 61.237.119.192-61.237.119.255, BJ
        [ 0x3DED7800, 0x3DED780B, "CQ" ],  // 61.237.120.0-61.237.120.11, CQ
        [ 0x3DED780C, 0x3DED781B, "GD" ],  // 61.237.120.12-61.237.120.27, GD
        [ 0x3DED781C, 0x3DED782F, "BJ" ],  // 61.237.120.28-61.237.120.47, BJ
        [ 0x3DED7830, 0x3DED7833, "XJ" ],  // 61.237.120.48-61.237.120.51, XJ
        [ 0x3DED7834, 0x3DED7857, "GD" ],  // 61.237.120.52-61.237.120.87, GD
        [ 0x3DED7858, 0x3DED785B, "JS" ],  // 61.237.120.88-61.237.120.91, JS
        [ 0x3DED785C, 0x3DED7863, "XJ" ],  // 61.237.120.92-61.237.120.99, XJ
        [ 0x3DED7864, 0x3DED7867, "JL" ],  // 61.237.120.100-61.237.120.103, JL
        [ 0x3DED7868, 0x3DED78C7, "XJ" ],  // 61.237.120.104-61.237.120.199, XJ
        [ 0x3DED78C8, 0x3DED78CF, "SC" ],  // 61.237.120.200-61.237.120.207, SC
        [ 0x3DED78D0, 0x3DED78DF, "XJ" ],  // 61.237.120.208-61.237.120.223, XJ
        [ 0x3DED78E0, 0x3DED78FF, "HN" ],  // 61.237.120.224-61.237.120.255, HN
        [ 0x3DED7900, 0x3DED792F, "GD" ],  // 61.237.121.0-61.237.121.47, GD
        [ 0x3DED7930, 0x3DED7933, "FJ" ],  // 61.237.121.48-61.237.121.51, FJ
        [ 0x3DED7934, 0x3DED7941, "BJ" ],  // 61.237.121.52-61.237.121.65, BJ
        [ 0x3DED7942, 0x3DED7942, "GD" ],  // 61.237.121.66-61.237.121.66, GD
        [ 0x3DED7943, 0x3DED7945, "BJ" ],  // 61.237.121.67-61.237.121.69, BJ
        [ 0x3DED7946, 0x3DED7946, "SH" ],  // 61.237.121.70-61.237.121.70, SH
        [ 0x3DED7947, 0x3DED7949, "BJ" ],  // 61.237.121.71-61.237.121.73, BJ
        [ 0x3DED794A, 0x3DED794A, "JS" ],  // 61.237.121.74-61.237.121.74, JS
        [ 0x3DED794B, 0x3DED7953, "BJ" ],  // 61.237.121.75-61.237.121.83, BJ
        [ 0x3DED7954, 0x3DED7955, "LN" ],  // 61.237.121.84-61.237.121.85, LN
        [ 0x3DED7956, 0x3DED7956, "GD" ],  // 61.237.121.86-61.237.121.86, GD
        [ 0x3DED7957, 0x3DED7957, "LN" ],  // 61.237.121.87-61.237.121.87, LN
        [ 0x3DED7958, 0x3DED795B, "GD" ],  // 61.237.121.88-61.237.121.91, GD
        [ 0x3DED795C, 0x3DED795F, "SN" ],  // 61.237.121.92-61.237.121.95, SN
        [ 0x3DED7960, 0x3DED7960, "HB" ],  // 61.237.121.96-61.237.121.96, HB
        [ 0x3DED7961, 0x3DED7961, "GD" ],  // 61.237.121.97-61.237.121.97, GD
        [ 0x3DED7962, 0x3DED7963, "HB" ],  // 61.237.121.98-61.237.121.99, HB
        [ 0x3DED7964, 0x3DED7967, "GD" ],  // 61.237.121.100-61.237.121.103, GD
        [ 0x3DED7968, 0x3DED796B, "YN" ],  // 61.237.121.104-61.237.121.107, YN
        [ 0x3DED796C, 0x3DED796F, "GD" ],  // 61.237.121.108-61.237.121.111, GD
        [ 0x3DED7970, 0x3DED7973, "HN" ],  // 61.237.121.112-61.237.121.115, HN
        [ 0x3DED7974, 0x3DED7983, "GD" ],  // 61.237.121.116-61.237.121.131, GD
        [ 0x3DED7984, 0x3DED7997, "SN" ],  // 61.237.121.132-61.237.121.151, SN
        [ 0x3DED7998, 0x3DED799B, "HN" ],  // 61.237.121.152-61.237.121.155, HN
        [ 0x3DED799C, 0x3DED79A3, "GD" ],  // 61.237.121.156-61.237.121.163, GD
        [ 0x3DED79A4, 0x3DED79A7, "FJ" ],  // 61.237.121.164-61.237.121.167, FJ
        [ 0x3DED79A8, 0x3DED79BB, "JX" ],  // 61.237.121.168-61.237.121.187, JX
        [ 0x3DED79BC, 0x3DED79BF, "HI" ],  // 61.237.121.188-61.237.121.191, HI
        [ 0x3DED79C0, 0x3DED79D3, "GD" ],  // 61.237.121.192-61.237.121.211, GD
        [ 0x3DED79D4, 0x3DED7AFF, "NM" ],  // 61.237.121.212-61.237.122.255, NM
        [ 0x3DED7B00, 0x3DED7B10, "HN" ],  // 61.237.123.0-61.237.123.16, HN
        [ 0x3DED7B11, 0x3DED7B11, "SD" ],  // 61.237.123.17-61.237.123.17, SD
        [ 0x3DED7B12, 0x3DED7B13, "HN" ],  // 61.237.123.18-61.237.123.19, HN
        [ 0x3DED7B14, 0x3DED7B14, "BJ" ],  // 61.237.123.20-61.237.123.20, BJ
        [ 0x3DED7B15, 0x3DED7B15, "SD" ],  // 61.237.123.21-61.237.123.21, SD
        [ 0x3DED7B16, 0x3DED7B18, "BJ" ],  // 61.237.123.22-61.237.123.24, BJ
        [ 0x3DED7B19, 0x3DED7B19, "SD" ],  // 61.237.123.25-61.237.123.25, SD
        [ 0x3DED7B1A, 0x3DED7B1A, "SH" ],  // 61.237.123.26-61.237.123.26, SH
        [ 0x3DED7B1B, 0x3DED7B1D, "BJ" ],  // 61.237.123.27-61.237.123.29, BJ
        [ 0x3DED7B1E, 0x3DED7B1E, "SH" ],  // 61.237.123.30-61.237.123.30, SH
        [ 0x3DED7B1F, 0x3DED7B1F, "BJ" ],  // 61.237.123.31-61.237.123.31, BJ
        [ 0x3DED7B20, 0x3DED7B2B, "GD" ],  // 61.237.123.32-61.237.123.43, GD
        [ 0x3DED7B2C, 0x3DED7B2F, "HE" ],  // 61.237.123.44-61.237.123.47, HE
        [ 0x3DED7B30, 0x3DED7B33, "TJ" ],  // 61.237.123.48-61.237.123.51, TJ
        [ 0x3DED7B34, 0x3DED7B37, "LN" ],  // 61.237.123.52-61.237.123.55, LN
        [ 0x3DED7B38, 0x3DED7B3C, "BJ" ],  // 61.237.123.56-61.237.123.60, BJ
        [ 0x3DED7B3D, 0x3DED7B3D, "SH" ],  // 61.237.123.61-61.237.123.61, SH
        [ 0x3DED7B3E, 0x3DED7B3E, "HB" ],  // 61.237.123.62-61.237.123.62, HB
        [ 0x3DED7B3F, 0x3DED7B3F, "BJ" ],  // 61.237.123.63-61.237.123.63, BJ
        [ 0x3DED7B40, 0x3DED7B43, "GD" ],  // 61.237.123.64-61.237.123.67, GD
        [ 0x3DED7B44, 0x3DED7B4C, "SD" ],  // 61.237.123.68-61.237.123.76, SD
        [ 0x3DED7B4D, 0x3DED7B4D, "HB" ],  // 61.237.123.77-61.237.123.77, HB
        [ 0x3DED7B4E, 0x3DED7B4E, "GD" ],  // 61.237.123.78-61.237.123.78, GD
        [ 0x3DED7B4F, 0x3DED7B53, "SD" ],  // 61.237.123.79-61.237.123.83, SD
        [ 0x3DED7B54, 0x3DED7B63, "HA" ],  // 61.237.123.84-61.237.123.99, HA
        [ 0x3DED7B64, 0x3DED7B69, "GD" ],  // 61.237.123.100-61.237.123.105, GD
        [ 0x3DED7B6A, 0x3DED7B6A, "HB" ],  // 61.237.123.106-61.237.123.106, HB
        [ 0x3DED7B6B, 0x3DED7B6B, "GD" ],  // 61.237.123.107-61.237.123.107, GD
        [ 0x3DED7B6C, 0x3DED7B6C, "HN" ],  // 61.237.123.108-61.237.123.108, HN
        [ 0x3DED7B6D, 0x3DED7B6D, "HB" ],  // 61.237.123.109-61.237.123.109, HB
        [ 0x3DED7B6E, 0x3DED7B73, "HN" ],  // 61.237.123.110-61.237.123.115, HN
        [ 0x3DED7B74, 0x3DED7B74, "HB" ],  // 61.237.123.116-61.237.123.116, HB
        [ 0x3DED7B75, 0x3DED7B75, "SH" ],  // 61.237.123.117-61.237.123.117, SH
        [ 0x3DED7B76, 0x3DED7B76, "GD" ],  // 61.237.123.118-61.237.123.118, GD
        [ 0x3DED7B77, 0x3DED7B77, "HB" ],  // 61.237.123.119-61.237.123.119, HB
        [ 0x3DED7B78, 0x3DED7B78, "BJ" ],  // 61.237.123.120-61.237.123.120, BJ
        [ 0x3DED7B79, 0x3DED7B79, "SH" ],  // 61.237.123.121-61.237.123.121, SH
        [ 0x3DED7B7A, 0x3DED7B7A, "FJ" ],  // 61.237.123.122-61.237.123.122, FJ
        [ 0x3DED7B7B, 0x3DED7B7C, "BJ" ],  // 61.237.123.123-61.237.123.124, BJ
        [ 0x3DED7B7D, 0x3DED7B7D, "SH" ],  // 61.237.123.125-61.237.123.125, SH
        [ 0x3DED7B7E, 0x3DED7B7E, "FJ" ],  // 61.237.123.126-61.237.123.126, FJ
        [ 0x3DED7B7F, 0x3DED7B81, "BJ" ],  // 61.237.123.127-61.237.123.129, BJ
        [ 0x3DED7B82, 0x3DED7B82, "GD" ],  // 61.237.123.130-61.237.123.130, GD
        [ 0x3DED7B83, 0x3DED7B85, "BJ" ],  // 61.237.123.131-61.237.123.133, BJ
        [ 0x3DED7B86, 0x3DED7B86, "GD" ],  // 61.237.123.134-61.237.123.134, GD
        [ 0x3DED7B87, 0x3DED7B8C, "BJ" ],  // 61.237.123.135-61.237.123.140, BJ
        [ 0x3DED7B8D, 0x3DED7B8D, "GD" ],  // 61.237.123.141-61.237.123.141, GD
        [ 0x3DED7B8E, 0x3DED7B8E, "FJ" ],  // 61.237.123.142-61.237.123.142, FJ
        [ 0x3DED7B8F, 0x3DED7B90, "BJ" ],  // 61.237.123.143-61.237.123.144, BJ
        [ 0x3DED7B91, 0x3DED7B91, "GD" ],  // 61.237.123.145-61.237.123.145, GD
        [ 0x3DED7B92, 0x3DED7B92, "ZJ" ],  // 61.237.123.146-61.237.123.146, ZJ
        [ 0x3DED7B93, 0x3DED7B94, "BJ" ],  // 61.237.123.147-61.237.123.148, BJ
        [ 0x3DED7B95, 0x3DED7B95, "GD" ],  // 61.237.123.149-61.237.123.149, GD
        [ 0x3DED7B96, 0x3DED7B96, "JS" ],  // 61.237.123.150-61.237.123.150, JS
        [ 0x3DED7B97, 0x3DED7B98, "BJ" ],  // 61.237.123.151-61.237.123.152, BJ
        [ 0x3DED7B99, 0x3DED7B99, "GD" ],  // 61.237.123.153-61.237.123.153, GD
        [ 0x3DED7B9A, 0x3DED7B9A, "JS" ],  // 61.237.123.154-61.237.123.154, JS
        [ 0x3DED7B9B, 0x3DED7B9B, "BJ" ],  // 61.237.123.155-61.237.123.155, BJ
        [ 0x3DED7B9C, 0x3DED7B9C, "AH" ],  // 61.237.123.156-61.237.123.156, AH
        [ 0x3DED7B9D, 0x3DED7B9D, "GD" ],  // 61.237.123.157-61.237.123.157, GD
        [ 0x3DED7B9E, 0x3DED7BA0, "AH" ],  // 61.237.123.158-61.237.123.160, AH
        [ 0x3DED7BA1, 0x3DED7BA1, "SH" ],  // 61.237.123.161-61.237.123.161, SH
        [ 0x3DED7BA2, 0x3DED7BA3, "AH" ],  // 61.237.123.162-61.237.123.163, AH
        [ 0x3DED7BA4, 0x3DED7BA5, "BJ" ],  // 61.237.123.164-61.237.123.165, BJ
        [ 0x3DED7BA6, 0x3DED7BA6, "JS" ],  // 61.237.123.166-61.237.123.166, JS
        [ 0x3DED7BA7, 0x3DED7BA7, "BJ" ],  // 61.237.123.167-61.237.123.167, BJ
        [ 0x3DED7BA8, 0x3DED7BAB, "JS" ],  // 61.237.123.168-61.237.123.171, JS
        [ 0x3DED7BAC, 0x3DED7BAF, "GD" ],  // 61.237.123.172-61.237.123.175, GD
        [ 0x3DED7BB0, 0x3DED7BCB, "BJ" ],  // 61.237.123.176-61.237.123.203, BJ
        [ 0x3DED7BCC, 0x3DED7BDB, "GD" ],  // 61.237.123.204-61.237.123.219, GD
        [ 0x3DED7BDC, 0x3DED7BE3, "HI" ],  // 61.237.123.220-61.237.123.227, HI
        [ 0x3DED7BE4, 0x3DED7BE7, "YN" ],  // 61.237.123.228-61.237.123.231, YN
        [ 0x3DED7BE8, 0x3DED7BFF, "BJ" ],  // 61.237.123.232-61.237.123.255, BJ
        [ 0x3DED7C00, 0x3DED7C0F, "NM" ],  // 61.237.124.0-61.237.124.15, NM
        [ 0x3DED7C10, 0x3DED7C13, "GD" ],  // 61.237.124.16-61.237.124.19, GD
        [ 0x3DED7C14, 0x3DED7C14, "NM" ],  // 61.237.124.20-61.237.124.20, NM
        [ 0x3DED7C15, 0x3DED7C15, "LN" ],  // 61.237.124.21-61.237.124.21, LN
        [ 0x3DED7C16, 0x3DED7C18, "NM" ],  // 61.237.124.22-61.237.124.24, NM
        [ 0x3DED7C19, 0x3DED7C19, "LN" ],  // 61.237.124.25-61.237.124.25, LN
        [ 0x3DED7C1A, 0x3DED7C1C, "NM" ],  // 61.237.124.26-61.237.124.28, NM
        [ 0x3DED7C1D, 0x3DED7C1D, "LN" ],  // 61.237.124.29-61.237.124.29, LN
        [ 0x3DED7C1E, 0x3DED7C20, "NM" ],  // 61.237.124.30-61.237.124.32, NM
        [ 0x3DED7C21, 0x3DED7C21, "LN" ],  // 61.237.124.33-61.237.124.33, LN
        [ 0x3DED7C22, 0x3DED7C33, "NM" ],  // 61.237.124.34-61.237.124.51, NM
        [ 0x3DED7C34, 0x3DED7C3B, "XJ" ],  // 61.237.124.52-61.237.124.59, XJ
        [ 0x3DED7C3C, 0x3DED7C4B, "NM" ],  // 61.237.124.60-61.237.124.75, NM
        [ 0x3DED7C4C, 0x3DED7C4F, "QH" ],  // 61.237.124.76-61.237.124.79, QH
        [ 0x3DED7C50, 0x3DED7C50, "NX" ],  // 61.237.124.80-61.237.124.80, NX
        [ 0x3DED7C51, 0x3DED7C51, "SN" ],  // 61.237.124.81-61.237.124.81, SN
        [ 0x3DED7C52, 0x3DED7C5B, "NX" ],  // 61.237.124.82-61.237.124.91, NX
        [ 0x3DED7C5C, 0x3DED7C63, "SC" ],  // 61.237.124.92-61.237.124.99, SC
        [ 0x3DED7C64, 0x3DED7C68, "GD" ],  // 61.237.124.100-61.237.124.104, GD
        [ 0x3DED7C69, 0x3DED7C69, "SC" ],  // 61.237.124.105-61.237.124.105, SC
        [ 0x3DED7C6A, 0x3DED7C6A, "GZ" ],  // 61.237.124.106-61.237.124.106, GZ
        [ 0x3DED7C6B, 0x3DED7C6C, "GD" ],  // 61.237.124.107-61.237.124.108, GD
        [ 0x3DED7C6D, 0x3DED7C6D, "SC" ],  // 61.237.124.109-61.237.124.109, SC
        [ 0x3DED7C6E, 0x3DED7C6E, "GZ" ],  // 61.237.124.110-61.237.124.110, GZ
        [ 0x3DED7C6F, 0x3DED7C6F, "GD" ],  // 61.237.124.111-61.237.124.111, GD
        [ 0x3DED7C70, 0x3DED7C70, "GZ" ],  // 61.237.124.112-61.237.124.112, GZ
        [ 0x3DED7C71, 0x3DED7C71, "SC" ],  // 61.237.124.113-61.237.124.113, SC
        [ 0x3DED7C72, 0x3DED7C73, "GZ" ],  // 61.237.124.114-61.237.124.115, GZ
        [ 0x3DED7C74, 0x3DED7C97, "NM" ],  // 61.237.124.116-61.237.124.151, NM
        [ 0x3DED7C98, 0x3DED7C9F, "LN" ],  // 61.237.124.152-61.237.124.159, LN
        [ 0x3DED7CA0, 0x3DED7CA7, "SC" ],  // 61.237.124.160-61.237.124.167, SC
        [ 0x3DED7CA8, 0x3DED7CAF, "SN" ],  // 61.237.124.168-61.237.124.175, SN
        [ 0x3DED7CB0, 0x3DED7CB3, "SX" ],  // 61.237.124.176-61.237.124.179, SX
        [ 0x3DED7CB4, 0x3DED7CBF, "BJ" ],  // 61.237.124.180-61.237.124.191, BJ
        [ 0x3DED7CC0, 0x3DED7CC7, "HL" ],  // 61.237.124.192-61.237.124.199, HL
        [ 0x3DED7CC8, 0x3DED7CD3, "BJ" ],  // 61.237.124.200-61.237.124.211, BJ
        [ 0x3DED7CD4, 0x3DED7CD7, "GS" ],  // 61.237.124.212-61.237.124.215, GS
        [ 0x3DED7CD8, 0x3DED7CE3, "NM" ],  // 61.237.124.216-61.237.124.227, NM
        [ 0x3DED7CE4, 0x3DED7CE7, "GX" ],  // 61.237.124.228-61.237.124.231, GX
        [ 0x3DED7CE8, 0x3DED7CEF, "NX" ],  // 61.237.124.232-61.237.124.239, NX
        [ 0x3DED7CF0, 0x3DED7CF7, "CQ" ],  // 61.237.124.240-61.237.124.247, CQ
        [ 0x3DED7CF8, 0x3DED7DFF, "GD" ],  // 61.237.124.248-61.237.125.255, GD
        [ 0x3DED7E00, 0x3DED7E3F, "HN" ],  // 61.237.126.0-61.237.126.63, HN
        [ 0x3DED7E40, 0x3DED7E43, "TJ" ],  // 61.237.126.64-61.237.126.67, TJ
        [ 0x3DED7E44, 0x3DED7E4C, "HB" ],  // 61.237.126.68-61.237.126.76, HB
        [ 0x3DED7E4D, 0x3DED7E4D, "GD" ],  // 61.237.126.77-61.237.126.77, GD
        [ 0x3DED7E4E, 0x3DED7E4F, "HB" ],  // 61.237.126.78-61.237.126.79, HB
        [ 0x3DED7E50, 0x3DED7E50, "TJ" ],  // 61.237.126.80-61.237.126.80, TJ
        [ 0x3DED7E51, 0x3DED7E51, "GD" ],  // 61.237.126.81-61.237.126.81, GD
        [ 0x3DED7E52, 0x3DED7E52, "HB" ],  // 61.237.126.82-61.237.126.82, HB
        [ 0x3DED7E53, 0x3DED7E58, "TJ" ],  // 61.237.126.83-61.237.126.88, TJ
        [ 0x3DED7E59, 0x3DED7E59, "SH" ],  // 61.237.126.89-61.237.126.89, SH
        [ 0x3DED7E5A, 0x3DED7E5A, "HB" ],  // 61.237.126.90-61.237.126.90, HB
        [ 0x3DED7E5B, 0x3DED7E5C, "TJ" ],  // 61.237.126.91-61.237.126.92, TJ
        [ 0x3DED7E5D, 0x3DED7E5D, "GD" ],  // 61.237.126.93-61.237.126.93, GD
        [ 0x3DED7E5E, 0x3DED7E5E, "FJ" ],  // 61.237.126.94-61.237.126.94, FJ
        [ 0x3DED7E5F, 0x3DED7E5F, "TJ" ],  // 61.237.126.95-61.237.126.95, TJ
        [ 0x3DED7E60, 0x3DED7E60, "HA" ],  // 61.237.126.96-61.237.126.96, HA
        [ 0x3DED7E61, 0x3DED7E61, "GD" ],  // 61.237.126.97-61.237.126.97, GD
        [ 0x3DED7E62, 0x3DED7E62, "FJ" ],  // 61.237.126.98-61.237.126.98, FJ
        [ 0x3DED7E63, 0x3DED7E64, "HA" ],  // 61.237.126.99-61.237.126.100, HA
        [ 0x3DED7E65, 0x3DED7E65, "SH" ],  // 61.237.126.101-61.237.126.101, SH
        [ 0x3DED7E66, 0x3DED7E66, "FJ" ],  // 61.237.126.102-61.237.126.102, FJ
        [ 0x3DED7E67, 0x3DED7E68, "HA" ],  // 61.237.126.103-61.237.126.104, HA
        [ 0x3DED7E69, 0x3DED7E69, "SH" ],  // 61.237.126.105-61.237.126.105, SH
        [ 0x3DED7E6A, 0x3DED7E6A, "FJ" ],  // 61.237.126.106-61.237.126.106, FJ
        [ 0x3DED7E6B, 0x3DED7E6C, "HA" ],  // 61.237.126.107-61.237.126.108, HA
        [ 0x3DED7E6D, 0x3DED7E6D, "SH" ],  // 61.237.126.109-61.237.126.109, SH
        [ 0x3DED7E6E, 0x3DED7E6E, "GD" ],  // 61.237.126.110-61.237.126.110, GD
        [ 0x3DED7E6F, 0x3DED7E70, "HA" ],  // 61.237.126.111-61.237.126.112, HA
        [ 0x3DED7E71, 0x3DED7E71, "SH" ],  // 61.237.126.113-61.237.126.113, SH
        [ 0x3DED7E72, 0x3DED7E72, "GD" ],  // 61.237.126.114-61.237.126.114, GD
        [ 0x3DED7E73, 0x3DED7E74, "HA" ],  // 61.237.126.115-61.237.126.116, HA
        [ 0x3DED7E75, 0x3DED7E75, "SH" ],  // 61.237.126.117-61.237.126.117, SH
        [ 0x3DED7E76, 0x3DED7E76, "GD" ],  // 61.237.126.118-61.237.126.118, GD
        [ 0x3DED7E77, 0x3DED7E78, "HA" ],  // 61.237.126.119-61.237.126.120, HA
        [ 0x3DED7E79, 0x3DED7E79, "SH" ],  // 61.237.126.121-61.237.126.121, SH
        [ 0x3DED7E7A, 0x3DED7E7A, "GD" ],  // 61.237.126.122-61.237.126.122, GD
        [ 0x3DED7E7B, 0x3DED7E8B, "HA" ],  // 61.237.126.123-61.237.126.139, HA
        [ 0x3DED7E8C, 0x3DED7E93, "SH" ],  // 61.237.126.140-61.237.126.147, SH
        [ 0x3DED7E94, 0x3DED7E9F, "GD" ],  // 61.237.126.148-61.237.126.159, GD
        [ 0x3DED7EA0, 0x3DED7EE1, "HA" ],  // 61.237.126.160-61.237.126.225, HA
        [ 0x3DED7EE2, 0x3DED7EE2, "GD" ],  // 61.237.126.226-61.237.126.226, GD
        [ 0x3DED7EE3, 0x3DED7F00, "HA" ],  // 61.237.126.227-61.237.127.0, HA
        [ 0x3DED7F01, 0x3DED7F01, "SH" ],  // 61.237.127.1-61.237.127.1, SH
        [ 0x3DED7F02, 0x3DED7F02, "SD" ],  // 61.237.127.2-61.237.127.2, SD
        [ 0x3DED7F03, 0x3DED7F05, "SH" ],  // 61.237.127.3-61.237.127.5, SH
        [ 0x3DED7F06, 0x3DED7F06, "SD" ],  // 61.237.127.6-61.237.127.6, SD
        [ 0x3DED7F07, 0x3DED7F09, "SH" ],  // 61.237.127.7-61.237.127.9, SH
        [ 0x3DED7F0A, 0x3DED7F0A, "JL" ],  // 61.237.127.10-61.237.127.10, JL
        [ 0x3DED7F0B, 0x3DED7F0D, "SH" ],  // 61.237.127.11-61.237.127.13, SH
        [ 0x3DED7F0E, 0x3DED7F0E, "JL" ],  // 61.237.127.14-61.237.127.14, JL
        [ 0x3DED7F0F, 0x3DED7F21, "SH" ],  // 61.237.127.15-61.237.127.33, SH
        [ 0x3DED7F22, 0x3DED7F22, "HB" ],  // 61.237.127.34-61.237.127.34, HB
        [ 0x3DED7F23, 0x3DED7F25, "SH" ],  // 61.237.127.35-61.237.127.37, SH
        [ 0x3DED7F26, 0x3DED7F26, "HB" ],  // 61.237.127.38-61.237.127.38, HB
        [ 0x3DED7F27, 0x3DED7F29, "SH" ],  // 61.237.127.39-61.237.127.41, SH
        [ 0x3DED7F2A, 0x3DED7F2A, "HB" ],  // 61.237.127.42-61.237.127.42, HB
        [ 0x3DED7F2B, 0x3DED7F2D, "SH" ],  // 61.237.127.43-61.237.127.45, SH
        [ 0x3DED7F2E, 0x3DED7F2E, "HB" ],  // 61.237.127.46-61.237.127.46, HB
        [ 0x3DED7F2F, 0x3DED7F31, "SH" ],  // 61.237.127.47-61.237.127.49, SH
        [ 0x3DED7F32, 0x3DED7F32, "SD" ],  // 61.237.127.50-61.237.127.50, SD
        [ 0x3DED7F33, 0x3DED7F35, "SH" ],  // 61.237.127.51-61.237.127.53, SH
        [ 0x3DED7F36, 0x3DED7F36, "SD" ],  // 61.237.127.54-61.237.127.54, SD
        [ 0x3DED7F37, 0x3DED7F38, "SH" ],  // 61.237.127.55-61.237.127.56, SH
        [ 0x3DED7F39, 0x3DED7F39, "GD" ],  // 61.237.127.57-61.237.127.57, GD
        [ 0x3DED7F3A, 0x3DED7F3A, "CQ" ],  // 61.237.127.58-61.237.127.58, CQ
        [ 0x3DED7F3B, 0x3DED7F3D, "SH" ],  // 61.237.127.59-61.237.127.61, SH
        [ 0x3DED7F3E, 0x3DED7F3E, "JL" ],  // 61.237.127.62-61.237.127.62, JL
        [ 0x3DED7F3F, 0x3DED7F43, "SH" ],  // 61.237.127.63-61.237.127.67, SH
        [ 0x3DED7F44, 0x3DED7F47, "SD" ],  // 61.237.127.68-61.237.127.71, SD
        [ 0x3DED7F48, 0x3DED7F48, "SH" ],  // 61.237.127.72-61.237.127.72, SH
        [ 0x3DED7F49, 0x3DED7F49, "GD" ],  // 61.237.127.73-61.237.127.73, GD
        [ 0x3DED7F4A, 0x3DED7F4A, "SC" ],  // 61.237.127.74-61.237.127.74, SC
        [ 0x3DED7F4B, 0x3DED7F4C, "SH" ],  // 61.237.127.75-61.237.127.76, SH
        [ 0x3DED7F4D, 0x3DED7F4D, "GD" ],  // 61.237.127.77-61.237.127.77, GD
        [ 0x3DED7F4E, 0x3DED7F4E, "SC" ],  // 61.237.127.78-61.237.127.78, SC
        [ 0x3DED7F4F, 0x3DED7F50, "SH" ],  // 61.237.127.79-61.237.127.80, SH
        [ 0x3DED7F51, 0x3DED7F51, "GD" ],  // 61.237.127.81-61.237.127.81, GD
        [ 0x3DED7F52, 0x3DED7F52, "CQ" ],  // 61.237.127.82-61.237.127.82, CQ
        [ 0x3DED7F53, 0x3DED7F53, "SH" ],  // 61.237.127.83-61.237.127.83, SH
        [ 0x3DED7F54, 0x3DED7F5B, "GD" ],  // 61.237.127.84-61.237.127.91, GD
        [ 0x3DED7F5C, 0x3DED7F5F, "SC" ],  // 61.237.127.92-61.237.127.95, SC
        [ 0x3DED7F60, 0x3DED7F78, "SH" ],  // 61.237.127.96-61.237.127.120, SH
        [ 0x3DED7F79, 0x3DED7F79, "HN" ],  // 61.237.127.121-61.237.127.121, HN
        [ 0x3DED7F7A, 0x3DED7F7A, "HB" ],  // 61.237.127.122-61.237.127.122, HB
        [ 0x3DED7F7B, 0x3DED7F7B, "SH" ],  // 61.237.127.123-61.237.127.123, SH
        [ 0x3DED7F7C, 0x3DED7F8F, "HB" ],  // 61.237.127.124-61.237.127.143, HB
        [ 0x3DED7F90, 0x3DED7FA7, "SC" ],  // 61.237.127.144-61.237.127.167, SC
        [ 0x3DED7FA8, 0x3DED7FB1, "SH" ],  // 61.237.127.168-61.237.127.177, SH
        [ 0x3DED7FB2, 0x3DED7FB2, "JL" ],  // 61.237.127.178-61.237.127.178, JL
        [ 0x3DED7FB3, 0x3DED7FB5, "SH" ],  // 61.237.127.179-61.237.127.181, SH
        [ 0x3DED7FB6, 0x3DED7FB6, "JL" ],  // 61.237.127.182-61.237.127.182, JL
        [ 0x3DED7FB7, 0x3DED7FC1, "SH" ],  // 61.237.127.183-61.237.127.193, SH
        [ 0x3DED7FC2, 0x3DED7FC2, "HL" ],  // 61.237.127.194-61.237.127.194, HL
        [ 0x3DED7FC3, 0x3DED7FC5, "SH" ],  // 61.237.127.195-61.237.127.197, SH
        [ 0x3DED7FC6, 0x3DED7FC6, "HL" ],  // 61.237.127.198-61.237.127.198, HL
        [ 0x3DED7FC7, 0x3DED7FC9, "SH" ],  // 61.237.127.199-61.237.127.201, SH
        [ 0x3DED7FCA, 0x3DED7FCA, "LN" ],  // 61.237.127.202-61.237.127.202, LN
        [ 0x3DED7FCB, 0x3DED7FCD, "SH" ],  // 61.237.127.203-61.237.127.205, SH
        [ 0x3DED7FCE, 0x3DED7FCE, "LN" ],  // 61.237.127.206-61.237.127.206, LN
        [ 0x3DED7FCF, 0x3DED7FD1, "SH" ],  // 61.237.127.207-61.237.127.209, SH
        [ 0x3DED7FD2, 0x3DED7FD2, "JL" ],  // 61.237.127.210-61.237.127.210, JL
        [ 0x3DED7FD3, 0x3DED7FE7, "SH" ],  // 61.237.127.211-61.237.127.231, SH
        [ 0x3DED7FE8, 0x3DED7FEF, "GD" ],  // 61.237.127.232-61.237.127.239, GD
        [ 0x3DED7FF0, 0x3DED7FFF, "SH" ],  // 61.237.127.240-61.237.127.255, SH
        [ 0x3DED8000, 0x3DED8FFF, "HN" ],  // 61.237.128.0-61.237.143.255, HN
        [ 0x3DED9000, 0x3DED9FFF, "SX" ],  // 61.237.144.0-61.237.159.255, SX
        [ 0x3DEDA000, 0x3DEDAFFF, "JS" ],  // 61.237.160.0-61.237.175.255, JS
        [ 0x3DEDB000, 0x3DEDBFFF, "AH" ],  // 61.237.176.0-61.237.191.255, AH
        [ 0x3DEDC000, 0x3DEDDFFF, "HL" ],  // 61.237.192.0-61.237.223.255, HL
        [ 0x3DEDE000, 0x3DEDF0FF, "BJ" ],  // 61.237.224.0-61.237.240.255, BJ
        [ 0x3DEDF100, 0x3DEDF117, "XJ" ],  // 61.237.241.0-61.237.241.23, XJ
        [ 0x3DEDF118, 0x3DEDF127, "JS" ],  // 61.237.241.24-61.237.241.39, JS
        [ 0x3DEDF128, 0x3DEDF20F, "BJ" ],  // 61.237.241.40-61.237.242.15, BJ
        [ 0x3DEDF210, 0x3DEDF217, "SD" ],  // 61.237.242.16-61.237.242.23, SD
        [ 0x3DEDF218, 0x3DEDF25F, "BJ" ],  // 61.237.242.24-61.237.242.95, BJ
        [ 0x3DEDF260, 0x3DEDF26F, "LN" ],  // 61.237.242.96-61.237.242.111, LN
        [ 0x3DEDF270, 0x3DEDF273, "SD" ],  // 61.237.242.112-61.237.242.115, SD
        [ 0x3DEDF274, 0x3DEDF27F, "BJ" ],  // 61.237.242.116-61.237.242.127, BJ
        [ 0x3DEDF280, 0x3DEDF2FF, "HA" ],  // 61.237.242.128-61.237.242.255, HA
        [ 0x3DEDF300, 0x3DEDFFFF, "BJ" ],  // 61.237.243.0-61.237.255.255, BJ
        [ 0x3DF00000, 0x3DF01FFF, "TJ" ],  // 61.240.0.0-61.240.31.255, TJ
        [ 0x3DF02000, 0x3DF03FFF, "SX" ],  // 61.240.32.0-61.240.63.255, SX
        [ 0x3DF04000, 0x3DF07FFF, "SD" ],  // 61.240.64.0-61.240.127.255, SD
        [ 0x3DF08000, 0x3DF09FFF, "HE" ],  // 61.240.128.0-61.240.159.255, HE
        [ 0x3DF0A000, 0x3DF0BFFF, "NM" ],  // 61.240.160.0-61.240.191.255, NM
        [ 0x3DF0C000, 0x3DF0DAFF, "HN" ],  // 61.240.192.0-61.240.218.255, HN
        [ 0x3DF0DB00, 0x3DF0DBFF, "SH" ],  // 61.240.219.0-61.240.219.255, SH
        [ 0x3DF0DC00, 0x3DF0EFFF, "HN" ],  // 61.240.220.0-61.240.239.255, HN
        [ 0x3DF0F000, 0x3DF0FFFF, "HI" ],  // 61.240.240.0-61.240.255.255, HI
        [ 0x3DF10000, 0x3DF13FFF, "JS" ],  // 61.241.0.0-61.241.63.255, JS
        [ 0x3DF14000, 0x3DF17FFF, "ZJ" ],  // 61.241.64.0-61.241.127.255, ZJ
        [ 0x3DF18000, 0x3DF1ABFF, "AH" ],  // 61.241.128.0-61.241.171.255, AH
        [ 0x3DF1AC00, 0x3DF1AFFF, "GS" ],  // 61.241.172.0-61.241.175.255, GS
        [ 0x3DF1B000, 0x3DF1BFFF, "GX" ],  // 61.241.176.0-61.241.191.255, GX
        [ 0x3DF1C000, 0x3DF1DFFF, "FJ" ],  // 61.241.192.0-61.241.223.255, FJ
        [ 0x3DF1E000, 0x3DF1FFFF, "HN" ],  // 61.241.224.0-61.241.255.255, HN
        [ 0x3DF20000, 0x3DF27FFF, "GD" ],  // 61.242.0.0-61.242.127.255, GD
        [ 0x3DF28000, 0x3DF290FF, "HB" ],  // 61.242.128.0-61.242.144.255, HB
        [ 0x3DF29100, 0x3DF293FF, "JX" ],  // 61.242.145.0-61.242.147.255, JX
        [ 0x3DF29400, 0x3DF299FF, "HB" ],  // 61.242.148.0-61.242.153.255, HB
        [ 0x3DF29A00, 0x3DF29FFF, "JX" ],  // 61.242.154.0-61.242.159.255, JX
        [ 0x3DF2A000, 0x3DF2BFFF, "HB" ],  // 61.242.160.0-61.242.191.255, HB
        [ 0x3DF2C000, 0x3DF2C1FF, "CQ" ],  // 61.242.192.0-61.242.193.255, CQ
        [ 0x3DF2C200, 0x3DF2C7FF, "HA" ],  // 61.242.194.0-61.242.199.255, HA
        [ 0x3DF2C800, 0x3DF2C9FF, "CQ" ],  // 61.242.200.0-61.242.201.255, CQ
        [ 0x3DF2CA00, 0x3DF2D6FF, "HA" ],  // 61.242.202.0-61.242.214.255, HA
        [ 0x3DF2D700, 0x3DF2D8FF, "CQ" ],  // 61.242.215.0-61.242.216.255, CQ
        [ 0x3DF2D900, 0x3DF2DBFF, "HA" ],  // 61.242.217.0-61.242.219.255, HA
        [ 0x3DF2DC00, 0x3DF2DCFF, "CQ" ],  // 61.242.220.0-61.242.220.255, CQ
        [ 0x3DF2DD00, 0x3DF2DFFF, "HA" ],  // 61.242.221.0-61.242.223.255, HA
        [ 0x3DF2E000, 0x3DF2FFFF, "CQ" ],  // 61.242.224.0-61.242.255.255, CQ
        [ 0x3DF30000, 0x3DF301FF, "GZ" ],  // 61.243.0.0-61.243.1.255, GZ
        [ 0x3DF30200, 0x3DF303FF, "SC" ],  // 61.243.2.0-61.243.3.255, SC
        [ 0x3DF30400, 0x3DF304FF, "GZ" ],  // 61.243.4.0-61.243.4.255, GZ
        [ 0x3DF30500, 0x3DF31FFF, "SC" ],  // 61.243.5.0-61.243.31.255, SC
        [ 0x3DF32000, 0x3DF32FFF, "GZ" ],  // 61.243.32.0-61.243.47.255, GZ
        [ 0x3DF33000, 0x3DF33FFF, "YN" ],  // 61.243.48.0-61.243.63.255, YN
        [ 0x3DF34000, 0x3DF35FFF, "XJ" ],  // 61.243.64.0-61.243.95.255, XJ
        [ 0x3DF36000, 0x3DF36FFF, "SN" ],  // 61.243.96.0-61.243.111.255, SN
        [ 0x3DF37000, 0x3DF37BFF, "NX" ],  // 61.243.112.0-61.243.123.255, NX
        [ 0x3DF37C00, 0x3DF37FFF, "HI" ],  // 61.243.124.0-61.243.127.255, HI
        [ 0x3DF38000, 0x3DF3BFFF, "LN" ],  // 61.243.128.0-61.243.191.255, LN
        [ 0x3DF3C000, 0x3DF3DFFF, "HL" ],  // 61.243.192.0-61.243.223.255, HL
        [ 0x3DF3E000, 0x3DF3FFFF, "JL" ],  // 61.243.224.0-61.243.255.255, JL
        [ 0x3EEA0000, 0x3EEAFFFF, "BJ" ],  // 62.234.0.0-62.234.255.255, BJ
        [ 0x40EBE698, 0x40EBE69B, "SH" ],  // 64.235.230.152-64.235.230.155, SH
        [ 0x42671584, 0x42671584, "SH" ],  // 66.103.21.132-66.103.21.132, SH
        [ 0x42779500, 0x427795FF, "BJ" ],  // 66.119.149.0-66.119.149.255, BJ
        [ 0x43C79AF8, 0x43C79AFF, "BJ" ],  // 67.199.154.248-67.199.154.255, BJ
        [ 0x43C79C40, 0x43C79C47, "SH" ],  // 67.199.156.64-67.199.156.71, SH
        [ 0x43C79D90, 0x43C79D93, "HB" ],  // 67.199.157.144-67.199.157.147, HB
        [ 0x43C79D94, 0x43C79D97, "BJ" ],  // 67.199.157.148-67.199.157.151, BJ
        [ 0x43C79EA4, 0x43C79EA7, "SH" ],  // 67.199.158.164-67.199.158.167, SH
        [ 0x43C79FE0, 0x43C79FE3, "HB" ],  // 67.199.159.224-67.199.159.227, HB
        [ 0x444F0000, 0x444F3FFF, "NX" ],  // 68.79.0.0-68.79.63.255, NX
        [ 0x45555D00, 0x45555DFF, "SH" ],  // 69.85.93.0-69.85.93.255, SH
        [ 0x45AE7900, 0x45AE793F, "BJ" ],  // 69.174.121.0-69.174.121.63, BJ
        [ 0x45AE79F0, 0x45AE79F7, "BJ" ],  // 69.174.121.240-69.174.121.247, BJ
        [ 0x45AE7B88, 0x45AE7B8F, "GD" ],  // 69.174.123.136-69.174.123.143, GD
        [ 0x45E6C000, 0x45E6FFFF, "NX" ],  // 69.230.192.0-69.230.255.255, NX
        [ 0x45E78000, 0x45E7BFFF, "NX" ],  // 69.231.128.0-69.231.191.255, NX
        [ 0x45EAC000, 0x45EAFFFF, "NX" ],  // 69.234.192.0-69.234.255.255, NX
        [ 0x45EB8000, 0x45EBBFFF, "NX" ],  // 69.235.128.0-69.235.191.255, NX
        [ 0x4783C000, 0x47843FFF, "BJ" ],  // 71.131.192.0-71.132.63.255, BJ
        [ 0x47884000, 0x47887FFF, "BJ" ],  // 71.136.64.0-71.136.127.255, BJ
        [ 0x47890000, 0x47893FFF, "BJ" ],  // 71.137.0.0-71.137.63.255, BJ
        [ 0x48A3F800, 0x48A3FBFF, "SH" ],  // 72.163.248.0-72.163.251.255, SH
        [ 0x4A7D1040, 0x4A7D107F, "HN" ],  // 74.125.16.64-74.125.16.127, HN
        [ 0x51440000, 0x5145FFFF, "SH" ],  // 81.68.0.0-81.69.255.255, SH
        [ 0x51460000, 0x51467FFF, "BJ" ],  // 81.70.0.0-81.70.127.255, BJ
        [ 0x51468000, 0x51468BFF, "HN" ],  // 81.70.128.0-81.70.139.255, HN
        [ 0x51468C00, 0x51468CFF, "BJ" ],  // 81.70.140.0-81.70.140.255, BJ
        [ 0x51468D00, 0x51468DFF, "HN" ],  // 81.70.141.0-81.70.141.255, HN
        [ 0x51468E00, 0x5146FFFF, "BJ" ],  // 81.70.142.0-81.70.255.255, BJ
        [ 0x51470000, 0x5147FFFF, "GD" ],  // 81.71.0.0-81.71.255.255, GD
        [ 0x5215BB00, 0x5215BBFF, "BJ" ],  // 82.21.187.0-82.21.187.255, BJ
        [ 0x529C0000, 0x529DFFFF, "BJ" ],  // 82.156.0.0-82.157.255.255, BJ
        [ 0x55D1D900, 0x55D1D9FF, "GD" ],  // 85.209.217.0-85.209.217.255, GD
        [ 0x5BEA2400, 0x5BEA24FF, "GD" ],  // 91.234.36.0-91.234.36.255, GD
        [ 0x5BEE9500, 0x5BEE95FF, "BJ" ],  // 91.238.149.0-91.238.149.255, BJ
        [ 0x5D736800, 0x5D7368FF, "BJ" ],  // 93.115.104.0-93.115.104.255, BJ
        [ 0x5EBF0000, 0x5EBF7FFF, "CQ" ],  // 94.191.0.0-94.191.127.255, CQ
        [ 0x65000000, 0x650003FF, "FJ" ],  // 101.0.0.0-101.0.3.255, FJ
        [ 0x65010000, 0x650103FF, "NM" ],  // 101.1.0.0-101.1.3.255, NM
        [ 0x6502AC00, 0x6502AFFF, "NM" ],  // 101.2.172.0-101.2.175.255, NM
        [ 0x65040000, 0x65043DFF, "BJ" ],  // 101.4.0.0-101.4.61.255, BJ
        [ 0x65043E00, 0x650466FF, "SX" ],  // 101.4.62.0-101.4.102.255, SX
        [ 0x65046700, 0x650467FF, "XJ" ],  // 101.4.103.0-101.4.103.255, XJ
        [ 0x65046800, 0x650468FF, "GD" ],  // 101.4.104.0-101.4.104.255, GD
        [ 0x65046900, 0x650469FF, "HN" ],  // 101.4.105.0-101.4.105.255, HN
        [ 0x65046A00, 0x65046AFF, "SH" ],  // 101.4.106.0-101.4.106.255, SH
        [ 0x65046B00, 0x65046BFF, "LN" ],  // 101.4.107.0-101.4.107.255, LN
        [ 0x65046C00, 0x65046CFF, "JX" ],  // 101.4.108.0-101.4.108.255, JX
        [ 0x65046D00, 0x65046EFF, "GD" ],  // 101.4.109.0-101.4.110.255, GD
        [ 0x65046F00, 0x650470FF, "NX" ],  // 101.4.111.0-101.4.112.255, NX
        [ 0x65047100, 0x6504712F, "BJ" ],  // 101.4.113.0-101.4.113.47, BJ
        [ 0x65047130, 0x65047134, "ZJ" ],  // 101.4.113.48-101.4.113.52, ZJ
        [ 0x65047135, 0x65047135, "AH" ],  // 101.4.113.53-101.4.113.53, AH
        [ 0x65047136, 0x65047137, "ZJ" ],  // 101.4.113.54-101.4.113.55, ZJ
        [ 0x65047138, 0x6504713F, "BJ" ],  // 101.4.113.56-101.4.113.63, BJ
        [ 0x65047140, 0x65047147, "GS" ],  // 101.4.113.64-101.4.113.71, GS
        [ 0x65047148, 0x65047157, "HE" ],  // 101.4.113.72-101.4.113.87, HE
        [ 0x65047158, 0x65047162, "BJ" ],  // 101.4.113.88-101.4.113.98, BJ
        [ 0x65047163, 0x6504717E, "HA" ],  // 101.4.113.99-101.4.113.126, HA
        [ 0x6504717F, 0x65047187, "CQ" ],  // 101.4.113.127-101.4.113.135, CQ
        [ 0x65047188, 0x650471AF, "GD" ],  // 101.4.113.136-101.4.113.175, GD
        [ 0x650471B0, 0x650471BF, "SH" ],  // 101.4.113.176-101.4.113.191, SH
        [ 0x650471C0, 0x650471C1, "LN" ],  // 101.4.113.192-101.4.113.193, LN
        [ 0x650471C2, 0x650471EE, "BJ" ],  // 101.4.113.194-101.4.113.238, BJ
        [ 0x650471EF, 0x650471F6, "HE" ],  // 101.4.113.239-101.4.113.246, HE
        [ 0x650471F7, 0x650471FF, "ZJ" ],  // 101.4.113.247-101.4.113.255, ZJ
        [ 0x65047200, 0x650473C9, "SH" ],  // 101.4.114.0-101.4.115.201, SH
        [ 0x650473CA, 0x650473CA, "AH" ],  // 101.4.115.202-101.4.115.202, AH
        [ 0x650473CB, 0x65047518, "GX" ],  // 101.4.115.203-101.4.117.24, GX
        [ 0x65047519, 0x65047519, "AH" ],  // 101.4.117.25-101.4.117.25, AH
        [ 0x6504751A, 0x6504751A, "JS" ],  // 101.4.117.26-101.4.117.26, JS
        [ 0x6504751B, 0x6504759B, "BJ" ],  // 101.4.117.27-101.4.117.155, BJ
        [ 0x6504759C, 0x6504759F, "SN" ],  // 101.4.117.156-101.4.117.159, SN
        [ 0x650475A0, 0x650475FF, "BJ" ],  // 101.4.117.160-101.4.117.255, BJ
        [ 0x65047600, 0x650477FF, "QH" ],  // 101.4.118.0-101.4.119.255, QH
        [ 0x65047800, 0x65047EFF, "JX" ],  // 101.4.120.0-101.4.126.255, JX
        [ 0x65047F00, 0x650480FF, "SH" ],  // 101.4.127.0-101.4.128.255, SH
        [ 0x65048100, 0x650489FF, "SC" ],  // 101.4.129.0-101.4.137.255, SC
        [ 0x65048A00, 0x65048BFF, "GD" ],  // 101.4.138.0-101.4.139.255, GD
        [ 0x65048C00, 0x65048C03, "TJ" ],  // 101.4.140.0-101.4.140.3, TJ
        [ 0x65048C04, 0x65048C07, "SH" ],  // 101.4.140.4-101.4.140.7, SH
        [ 0x65048C08, 0x65048C0B, "CQ" ],  // 101.4.140.8-101.4.140.11, CQ
        [ 0x65048C0C, 0x65048C0F, "HE" ],  // 101.4.140.12-101.4.140.15, HE
        [ 0x65048C10, 0x65048C13, "SX" ],  // 101.4.140.16-101.4.140.19, SX
        [ 0x65048C14, 0x65048C17, "HB" ],  // 101.4.140.20-101.4.140.23, HB
        [ 0x65048C18, 0x65048C1F, "LN" ],  // 101.4.140.24-101.4.140.31, LN
        [ 0x65048C20, 0x65048C2F, "JL" ],  // 101.4.140.32-101.4.140.47, JL
        [ 0x65048C30, 0x65048C33, "AH" ],  // 101.4.140.48-101.4.140.51, AH
        [ 0x65048C34, 0x65048C3F, "HB" ],  // 101.4.140.52-101.4.140.63, HB
        [ 0x65048C40, 0x65048C5F, "SD" ],  // 101.4.140.64-101.4.140.95, SD
        [ 0x65048C60, 0x65048C67, "HI" ],  // 101.4.140.96-101.4.140.103, HI
        [ 0x65048C68, 0x65048C6F, "GZ" ],  // 101.4.140.104-101.4.140.111, GZ
        [ 0x65048C70, 0x65048C7F, "XZ" ],  // 101.4.140.112-101.4.140.127, XZ
        [ 0x65048C80, 0x65048C93, "HB" ],  // 101.4.140.128-101.4.140.147, HB
        [ 0x65048C94, 0x65048C94, "GZ" ],  // 101.4.140.148-101.4.140.148, GZ
        [ 0x65048C95, 0x65048C95, "HB" ],  // 101.4.140.149-101.4.140.149, HB
        [ 0x65048C96, 0x65048C96, "GZ" ],  // 101.4.140.150-101.4.140.150, GZ
        [ 0x65048C97, 0x65048C9F, "HB" ],  // 101.4.140.151-101.4.140.159, HB
        [ 0x65048CA0, 0x65048CA3, "AH" ],  // 101.4.140.160-101.4.140.163, AH
        [ 0x65048CA4, 0x65048CAF, "HB" ],  // 101.4.140.164-101.4.140.175, HB
        [ 0x65048CB0, 0x65048CB7, "SD" ],  // 101.4.140.176-101.4.140.183, SD
        [ 0x65048CB8, 0x65048CBF, "HA" ],  // 101.4.140.184-101.4.140.191, HA
        [ 0x65048CC0, 0x65048CCF, "GD" ],  // 101.4.140.192-101.4.140.207, GD
        [ 0x65048CD0, 0x65048CD7, "HI" ],  // 101.4.140.208-101.4.140.215, HI
        [ 0x65048CD8, 0x65048CD8, "GZ" ],  // 101.4.140.216-101.4.140.216, GZ
        [ 0x65048CD9, 0x65048CD9, "HB" ],  // 101.4.140.217-101.4.140.217, HB
        [ 0x65048CDA, 0x65048CDA, "GZ" ],  // 101.4.140.218-101.4.140.218, GZ
        [ 0x65048CDB, 0x65048CFF, "HB" ],  // 101.4.140.219-101.4.140.255, HB
        [ 0x65048D00, 0x6504BFFF, "BJ" ],  // 101.4.141.0-101.4.191.255, BJ
        [ 0x6504C000, 0x6504FFFF, "NM" ],  // 101.4.192.0-101.4.255.255, NM
        [ 0x65050000, 0x6506FFFF, "BJ" ],  // 101.5.0.0-101.6.255.255, BJ
        [ 0x65070000, 0x650703FF, "NM" ],  // 101.7.0.0-101.7.3.255, NM
        [ 0x65070400, 0x650706FF, "HB" ],  // 101.7.4.0-101.7.6.255, HB
        [ 0x65070700, 0x650707FF, "BJ" ],  // 101.7.7.0-101.7.7.255, BJ
        [ 0x65070800, 0x650708FF, "SH" ],  // 101.7.8.0-101.7.8.255, SH
        [ 0x65070900, 0x650709FF, "BJ" ],  // 101.7.9.0-101.7.9.255, BJ
        [ 0x65070A00, 0x65073FFF, "HB" ],  // 101.7.10.0-101.7.63.255, HB
        [ 0x65074000, 0x65077FFF, "NM" ],  // 101.7.64.0-101.7.127.255, NM
        [ 0x65078000, 0x6507BFFF, "SX" ],  // 101.7.128.0-101.7.191.255, SX
        [ 0x6507C000, 0x6507D3FF, "HE" ],  // 101.7.192.0-101.7.211.255, HE
        [ 0x6507D400, 0x6507DFFF, "BJ" ],  // 101.7.212.0-101.7.223.255, BJ
        [ 0x6507E000, 0x6507FFFF, "HE" ],  // 101.7.224.0-101.7.255.255, HE
        [ 0x65100000, 0x651FFFFF, "HE" ],  // 101.16.0.0-101.31.255.255, HE
        [ 0x65218000, 0x6521BFFF, "BJ" ],  // 101.33.128.0-101.33.191.255, BJ
        [ 0x6521C000, 0x6521FFFF, "GD" ],  // 101.33.192.0-101.33.255.255, GD
        [ 0x65220000, 0x6523FFFF, "SH" ],  // 101.34.0.0-101.35.255.255, SH
        [ 0x65240000, 0x65244FFF, "BJ" ],  // 101.36.0.0-101.36.79.255, BJ
        [ 0x65245000, 0x652453FF, "GD" ],  // 101.36.80.0-101.36.83.255, GD
        [ 0x65245400, 0x652457FF, "FJ" ],  // 101.36.84.0-101.36.87.255, FJ
        [ 0x65245800, 0x65245FFF, "BJ" ],  // 101.36.88.0-101.36.95.255, BJ
        [ 0x65248000, 0x6524FFFF, "BJ" ],  // 101.36.128.0-101.36.255.255, BJ
        [ 0x65250000, 0x6525FFFF, "ZJ" ],  // 101.37.0.0-101.37.255.255, ZJ
        [ 0x65260000, 0x6527DFFF, "BJ" ],  // 101.38.0.0-101.39.223.255, BJ
        [ 0x6527E000, 0x6527E0FF, "SD" ],  // 101.39.224.0-101.39.224.255, SD
        [ 0x6527E100, 0x6527E1FF, "CQ" ],  // 101.39.225.0-101.39.225.255, CQ
        [ 0x6527E200, 0x6527E2FF, "SX" ],  // 101.39.226.0-101.39.226.255, SX
        [ 0x6527E300, 0x6527E3FF, "YN" ],  // 101.39.227.0-101.39.227.255, YN
        [ 0x6527E400, 0x6527E4FF, "JL" ],  // 101.39.228.0-101.39.228.255, JL
        [ 0x6527E500, 0x6527E5FF, "BJ" ],  // 101.39.229.0-101.39.229.255, BJ
        [ 0x6527E600, 0x6527E7FF, "HB" ],  // 101.39.230.0-101.39.231.255, HB
        [ 0x6527E800, 0x652B01FF, "BJ" ],  // 101.39.232.0-101.43.1.255, BJ
        [ 0x652B0200, 0x652B7FFF, "SH" ],  // 101.43.2.0-101.43.127.255, SH
        [ 0x652B8000, 0x652BFFFF, "BJ" ],  // 101.43.128.0-101.43.255.255, BJ
        [ 0x652C7000, 0x652C8FFF, "SH" ],  // 101.44.112.0-101.44.143.255, SH
        [ 0x652F6000, 0x652F7FFF, "HE" ],  // 101.47.96.0-101.47.127.255, HE
        [ 0x652FC000, 0x652FDFFF, "CQ" ],  // 101.47.192.0-101.47.223.255, CQ
        [ 0x652FE000, 0x652FFFFF, "GD" ],  // 101.47.224.0-101.47.255.255, GD
        [ 0x65300000, 0x653016FF, "BJ" ],  // 101.48.0.0-101.48.22.255, BJ
        [ 0x65301700, 0x65307EFF, "LN" ],  // 101.48.23.0-101.48.126.255, LN
        [ 0x65307F00, 0x65307FFF, "BJ" ],  // 101.48.127.0-101.48.127.255, BJ
        [ 0x65308000, 0x6530FFFF, "LN" ],  // 101.48.128.0-101.48.255.255, LN
        [ 0x65310000, 0x65313FFF, "BJ" ],  // 101.49.0.0-101.49.63.255, BJ
        [ 0x65314000, 0x65317FFF, "JS" ],  // 101.49.64.0-101.49.127.255, JS
        [ 0x65318000, 0x653193FF, "GD" ],  // 101.49.128.0-101.49.147.255, GD
        [ 0x65319400, 0x6531FFFF, "BJ" ],  // 101.49.148.0-101.49.255.255, BJ
        [ 0x65320800, 0x65320BFF, "ZJ" ],  // 101.50.8.0-101.50.11.255, ZJ
        [ 0x65320C00, 0x65320FFF, "FJ" ],  // 101.50.12.0-101.50.15.255, FJ
        [ 0x65323800, 0x65323BFF, "NM" ],  // 101.50.56.0-101.50.59.255, NM
        [ 0x65340000, 0x65348BFF, "SH" ],  // 101.52.0.0-101.52.139.255, SH
        [ 0x65348C00, 0x65348FFF, "GD" ],  // 101.52.140.0-101.52.143.255, GD
        [ 0x65349000, 0x6534EBFF, "SH" ],  // 101.52.144.0-101.52.235.255, SH
        [ 0x6534EC00, 0x6534EFFF, "GD" ],  // 101.52.236.0-101.52.239.255, GD
        [ 0x6534F000, 0x6534FFFF, "SH" ],  // 101.52.240.0-101.52.255.255, SH
        [ 0x65356400, 0x653567FF, "NM" ],  // 101.53.100.0-101.53.103.255, NM
        [ 0x65360000, 0x6536FFFF, "BJ" ],  // 101.54.0.0-101.54.255.255, BJ
        [ 0x6537E000, 0x6537E7FF, "GD" ],  // 101.55.224.0-101.55.231.255, GD
        [ 0x65400000, 0x6547FFFF, "ZJ" ],  // 101.64.0.0-101.71.255.255, ZJ
        [ 0x65480000, 0x654BFFFF, "HE" ],  // 101.72.0.0-101.75.255.255, HE
        [ 0x654C0000, 0x654C7FFF, "JS" ],  // 101.76.0.0-101.76.127.255, JS
        [ 0x654C8000, 0x654CBFFF, "AH" ],  // 101.76.128.0-101.76.191.255, AH
        [ 0x654CC000, 0x654CFFFF, "SD" ],  // 101.76.192.0-101.76.255.255, SD
        [ 0x654D0000, 0x654DFFFF, "JS" ],  // 101.77.0.0-101.77.255.255, JS
        [ 0x654E0000, 0x654E03FF, "NM" ],  // 101.78.0.0-101.78.3.255, NM
        [ 0x654E2000, 0x654E3FFF, "BJ" ],  // 101.78.32.0-101.78.63.255, BJ
        [ 0x65500000, 0x655FFFFF, "SH" ],  // 101.80.0.0-101.95.255.255, SH
        [ 0x65600000, 0x656007FF, "GD" ],  // 101.96.0.0-101.96.7.255, GD
        [ 0x65600800, 0x656009FF, "BJ" ],  // 101.96.8.0-101.96.9.255, BJ
        [ 0x65600A00, 0x65600BFF, "SH" ],  // 101.96.10.0-101.96.11.255, SH
        [ 0x65601000, 0x65601FFF, "GD" ],  // 101.96.16.0-101.96.31.255, GD
        [ 0x65608000, 0x6560FFFF, "BJ" ],  // 101.96.128.0-101.96.255.255, BJ
        [ 0x65636000, 0x65637FFF, "GD" ],  // 101.99.96.0-101.99.127.255, GD
        [ 0x65654000, 0x65655FFF, "GD" ],  // 101.101.64.0-101.101.95.255, GD
        [ 0x65656400, 0x656564FF, "FJ" ],  // 101.101.100.0-101.101.100.255, FJ
        [ 0x65656600, 0x656567FF, "FJ" ],  // 101.101.102.0-101.101.103.255, FJ
        [ 0x65656800, 0x65657FFF, "GD" ],  // 101.101.104.0-101.101.127.255, GD
        [ 0x65664000, 0x65665FFF, "GD" ],  // 101.102.64.0-101.102.95.255, GD
        [ 0x65666400, 0x656666FF, "FJ" ],  // 101.102.100.0-101.102.102.255, FJ
        [ 0x65666800, 0x65667FFF, "GD" ],  // 101.102.104.0-101.102.127.255, GD
        [ 0x65680000, 0x65687FFF, "GD" ],  // 101.104.0.0-101.104.127.255, GD
        [ 0x65688000, 0x65688FFF, "LN" ],  // 101.104.128.0-101.104.143.255, LN
        [ 0x65689000, 0x656891FF, "HL" ],  // 101.104.144.0-101.104.145.255, HL
        [ 0x65689200, 0x656892BF, "LN" ],  // 101.104.146.0-101.104.146.191, LN
        [ 0x656892C0, 0x656892FF, "SN" ],  // 101.104.146.192-101.104.146.255, SN
        [ 0x65689300, 0x656893FF, "LN" ],  // 101.104.147.0-101.104.147.255, LN
        [ 0x65689400, 0x656894FF, "JL" ],  // 101.104.148.0-101.104.148.255, JL
        [ 0x65689500, 0x65689FFF, "LN" ],  // 101.104.149.0-101.104.159.255, LN
        [ 0x6568A000, 0x6568A0FF, "HE" ],  // 101.104.160.0-101.104.160.255, HE
        [ 0x6568A100, 0x6568BFFF, "LN" ],  // 101.104.161.0-101.104.191.255, LN
        [ 0x6568C000, 0x6568DFFF, "HA" ],  // 101.104.192.0-101.104.223.255, HA
        [ 0x6568E000, 0x6568FFFF, "LN" ],  // 101.104.224.0-101.104.255.255, LN
        [ 0x65690000, 0x65693FFF, "GD" ],  // 101.105.0.0-101.105.63.255, GD
        [ 0x65694000, 0x65697FFF, "AH" ],  // 101.105.64.0-101.105.127.255, AH
        [ 0x65698000, 0x6569BAFF, "CQ" ],  // 101.105.128.0-101.105.186.255, CQ
        [ 0x6569BB00, 0x6569BCFF, "BJ" ],  // 101.105.187.0-101.105.188.255, BJ
        [ 0x6569BD00, 0x6569BFFF, "CQ" ],  // 101.105.189.0-101.105.191.255, CQ
        [ 0x6569C000, 0x6569DFFF, "JS" ],  // 101.105.192.0-101.105.223.255, JS
        [ 0x6569E000, 0x6569FFFF, "SN" ],  // 101.105.224.0-101.105.255.255, SN
        [ 0x656A0000, 0x656A3FFF, "TJ" ],  // 101.106.0.0-101.106.63.255, TJ
        [ 0x656A4000, 0x656A7FFF, "GD" ],  // 101.106.64.0-101.106.127.255, GD
        [ 0x656A8000, 0x656ABFFF, "LN" ],  // 101.106.128.0-101.106.191.255, LN
        [ 0x656AC000, 0x656AEFFF, "HL" ],  // 101.106.192.0-101.106.239.255, HL
        [ 0x656AF000, 0x656AF7FF, "JS" ],  // 101.106.240.0-101.106.247.255, JS
        [ 0x656AF800, 0x656AFFFF, "HE" ],  // 101.106.248.0-101.106.255.255, HE
        [ 0x656B0000, 0x656B3FFF, "HA" ],  // 101.107.0.0-101.107.63.255, HA
        [ 0x656B4000, 0x656B7FFF, "GD" ],  // 101.107.64.0-101.107.127.255, GD
        [ 0x656B8000, 0x656BBFFF, "SN" ],  // 101.107.128.0-101.107.191.255, SN
        [ 0x656BC000, 0x656BFFFF, "GD" ],  // 101.107.192.0-101.107.255.255, GD
        [ 0x656E4000, 0x656E6FFF, "GD" ],  // 101.110.64.0-101.110.111.255, GD
        [ 0x656E7400, 0x656E74FF, "SH" ],  // 101.110.116.0-101.110.116.255, SH
        [ 0x656E7500, 0x656E7FFF, "GD" ],  // 101.110.117.0-101.110.127.255, GD
        [ 0x65780000, 0x657C3FFF, "BJ" ],  // 101.120.0.0-101.124.63.255, BJ
        [ 0x657C4000, 0x657C7FFF, "SH" ],  // 101.124.64.0-101.124.127.255, SH
        [ 0x657C8000, 0x657C9FFF, "GD" ],  // 101.124.128.0-101.124.159.255, GD
        [ 0x657CA000, 0x657DFFFF, "JS" ],  // 101.124.160.0-101.125.255.255, JS
        [ 0x657E0000, 0x657E3FFF, "GD" ],  // 101.126.0.0-101.126.63.255, GD
        [ 0x657E4000, 0x657E7FFF, "HE" ],  // 101.126.64.0-101.126.127.255, HE
        [ 0x657E8000, 0x657EFFFF, "HN" ],  // 101.126.128.0-101.126.255.255, HN
        [ 0x65800000, 0x658003FF, "NM" ],  // 101.128.0.0-101.128.3.255, NM
        [ 0x65800800, 0x65803FFF, "GD" ],  // 101.128.8.0-101.128.63.255, GD
        [ 0x65810000, 0x6581FFFF, "BJ" ],  // 101.129.0.0-101.129.255.255, BJ
        [ 0x65820000, 0x65827FFF, "HN" ],  // 101.130.0.0-101.130.127.255, HN
        [ 0x65828000, 0x6582BFFF, "GD" ],  // 101.130.128.0-101.130.191.255, GD
        [ 0x6582C000, 0x6582DFFF, "FJ" ],  // 101.130.192.0-101.130.223.255, FJ
        [ 0x6582E000, 0x6582FFFF, "GD" ],  // 101.130.224.0-101.130.255.255, GD
        [ 0x65830000, 0x6583FFFF, "LN" ],  // 101.131.0.0-101.131.255.255, LN
        [ 0x65840000, 0x6585FFFF, "SH" ],  // 101.132.0.0-101.133.255.255, SH
        [ 0x65860000, 0x6587FFFF, "BJ" ],  // 101.134.0.0-101.135.255.255, BJ
        [ 0x65900000, 0x6591FFFF, "HB" ],  // 101.144.0.0-101.145.255.255, HB
        [ 0x65920000, 0x6593FFFF, "GX" ],  // 101.146.0.0-101.147.255.255, GX
        [ 0x65940000, 0x659FFFFF, "BJ" ],  // 101.148.0.0-101.159.255.255, BJ
        [ 0x65C00000, 0x65C3FFFF, "BJ" ],  // 101.192.0.0-101.195.255.255, BJ
        [ 0x65C40000, 0x65C4FFFF, "SH" ],  // 101.196.0.0-101.196.255.255, SH
        [ 0x65C50000, 0x65C67FFF, "BJ" ],  // 101.197.0.0-101.198.127.255, BJ
        [ 0x65C68000, 0x65C6BFFF, "SH" ],  // 101.198.128.0-101.198.191.255, SH
        [ 0x65C6C000, 0x65C6C1FF, "BJ" ],  // 101.198.192.0-101.198.193.255, BJ
        [ 0x65C6C200, 0x65C6C2FF, "SH" ],  // 101.198.194.0-101.198.194.255, SH
        [ 0x65C6C300, 0x65C6C3FF, "BJ" ],  // 101.198.195.0-101.198.195.255, BJ
        [ 0x65C6C400, 0x65C6C5FF, "HE" ],  // 101.198.196.0-101.198.197.255, HE
        [ 0x65C6C600, 0x65C6CBFF, "SH" ],  // 101.198.198.0-101.198.203.255, SH
        [ 0x65C6CC00, 0x65C72FFF, "BJ" ],  // 101.198.204.0-101.199.47.255, BJ
        [ 0x65C73000, 0x65C73FFF, "NX" ],  // 101.199.48.0-101.199.63.255, NX
        [ 0x65C74000, 0x65C7C3FF, "BJ" ],  // 101.199.64.0-101.199.195.255, BJ
        [ 0x65C7C400, 0x65C7C7FF, "HE" ],  // 101.199.196.0-101.199.199.255, HE
        [ 0x65C7C800, 0x65C9F9FF, "BJ" ],  // 101.199.200.0-101.201.249.255, BJ
        [ 0x65C9FA00, 0x65C9FAFF, "ZJ" ],  // 101.201.250.0-101.201.250.255, ZJ
        [ 0x65C9FB00, 0x65C9FFFF, "BJ" ],  // 101.201.251.0-101.201.255.255, BJ
        [ 0x65CB8000, 0x65CBA7FF, "GD" ],  // 101.203.128.0-101.203.167.255, GD
        [ 0x65CBAC00, 0x65CBAFFF, "NM" ],  // 101.203.172.0-101.203.175.255, NM
        [ 0x65CBB000, 0x65CBBFFF, "GD" ],  // 101.203.176.0-101.203.191.255, GD
        [ 0x65CC0000, 0x65CFFFFF, "SC" ],  // 101.204.0.0-101.207.255.255, SC
        [ 0x65E00000, 0x65E7FFFF, "SH" ],  // 101.224.0.0-101.231.255.255, SH
        [ 0x65E80000, 0x65E9FFFF, "GD" ],  // 101.232.0.0-101.233.255.255, GD
        [ 0x65EA4000, 0x65EA47FF, "GD" ],  // 101.234.64.0-101.234.71.255, GD
        [ 0x65EA4C00, 0x65EA4FFF, "NM" ],  // 101.234.76.0-101.234.79.255, NM
        [ 0x65EA5000, 0x65EA7FFF, "GD" ],  // 101.234.80.0-101.234.127.255, GD
        [ 0x65EC0000, 0x65ECFFFF, "BJ" ],  // 101.236.0.0-101.236.255.255, BJ
        [ 0x65ED0000, 0x65EDFFFF, "SC" ],  // 101.237.0.0-101.237.255.255, SC
        [ 0x65EE0000, 0x65EEFFFF, "GZ" ],  // 101.238.0.0-101.238.255.255, GZ
        [ 0x65EF0000, 0x65F1B7FF, "BJ" ],  // 101.239.0.0-101.241.183.255, BJ
        [ 0x65F1B800, 0x65F1B9FF, "HE" ],  // 101.241.184.0-101.241.185.255, HE
        [ 0x65F1BA00, 0x65F253FF, "BJ" ],  // 101.241.186.0-101.242.83.255, BJ
        [ 0x65F25400, 0x65F254FF, "HE" ],  // 101.242.84.0-101.242.84.255, HE
        [ 0x65F25500, 0x65F256FF, "BJ" ],  // 101.242.85.0-101.242.86.255, BJ
        [ 0x65F25700, 0x65F257FF, "HE" ],  // 101.242.87.0-101.242.87.255, HE
        [ 0x65F25800, 0x65F2A3FF, "BJ" ],  // 101.242.88.0-101.242.163.255, BJ
        [ 0x65F2A400, 0x65F2A5FF, "HE" ],  // 101.242.164.0-101.242.165.255, HE
        [ 0x65F2A600, 0x65F339FF, "BJ" ],  // 101.242.166.0-101.243.57.255, BJ
        [ 0x65F33A00, 0x65F33BFF, "HE" ],  // 101.243.58.0-101.243.59.255, HE
        [ 0x65F33C00, 0x65F397FF, "BJ" ],  // 101.243.60.0-101.243.151.255, BJ
        [ 0x65F39800, 0x65F399FF, "HE" ],  // 101.243.152.0-101.243.153.255, HE
        [ 0x65F39A00, 0x65F3FFFF, "BJ" ],  // 101.243.154.0-101.243.255.255, BJ
        [ 0x65F40000, 0x65F5FFFF, "SH" ],  // 101.244.0.0-101.245.255.255, SH
        [ 0x65F60000, 0x65F63FFF, "GD" ],  // 101.246.0.0-101.246.63.255, GD
        [ 0x65F64000, 0x65F6BFFF, "LN" ],  // 101.246.64.0-101.246.191.255, LN
        [ 0x65F6C000, 0x65F6FFFF, "HL" ],  // 101.246.192.0-101.246.255.255, HL
        [ 0x65F70000, 0x65F73FFF, "SN" ],  // 101.247.0.0-101.247.63.255, SN
        [ 0x65F74000, 0x65F77FFF, "JS" ],  // 101.247.64.0-101.247.127.255, JS
        [ 0x65F78000, 0x65F7BFFF, "SX" ],  // 101.247.128.0-101.247.191.255, SX
        [ 0x65F7C000, 0x65F7FFFF, "GD" ],  // 101.247.192.0-101.247.255.255, GD
        [ 0x65F80000, 0x65F9FFFF, "XZ" ],  // 101.248.0.0-101.249.255.255, XZ
        [ 0x65FB0000, 0x65FB03FF, "NM" ],  // 101.251.0.0-101.251.3.255, NM
        [ 0x65FB0800, 0x65FB3FFF, "GD" ],  // 101.251.8.0-101.251.63.255, GD
        [ 0x65FB4000, 0x65FB4FFF, "SH" ],  // 101.251.64.0-101.251.79.255, SH
        [ 0x65FB5000, 0x65FB5FFF, "JS" ],  // 101.251.80.0-101.251.95.255, JS
        [ 0x65FB6000, 0x65FB7FFF, "SH" ],  // 101.251.96.0-101.251.127.255, SH
        [ 0x65FB8000, 0x65FB8FFF, "BJ" ],  // 101.251.128.0-101.251.143.255, BJ
        [ 0x65FB9000, 0x65FB9FFF, "ZJ" ],  // 101.251.144.0-101.251.159.255, ZJ
        [ 0x65FBA000, 0x65FBA7FF, "JS" ],  // 101.251.160.0-101.251.167.255, JS
        [ 0x65FBA800, 0x65FBBFFF, "ZJ" ],  // 101.251.168.0-101.251.191.255, ZJ
        [ 0x65FBC000, 0x65FEFFFF, "BJ" ],  // 101.251.192.0-101.254.255.255, BJ
        [ 0x6626E500, 0x6626E5FF, "BJ" ],  // 102.38.229.0-102.38.229.255, BJ
        [ 0x67010800, 0x67010BFF, "BJ" ],  // 103.1.8.0-103.1.11.255, BJ
        [ 0x67011400, 0x670117FF, "TJ" ],  // 103.1.20.0-103.1.23.255, TJ
        [ 0x67011800, 0x67011BFF, "SH" ],  // 103.1.24.0-103.1.27.255, SH
        [ 0x67014800, 0x67014BFF, "SN" ],  // 103.1.72.0-103.1.75.255, SN
        [ 0x67015800, 0x67015BFF, "ZJ" ],  // 103.1.88.0-103.1.91.255, ZJ
        [ 0x6701A800, 0x6701ABFF, "HE" ],  // 103.1.168.0-103.1.171.255, HE
        [ 0x67026C00, 0x67026FFF, "BJ" ],  // 103.2.108.0-103.2.111.255, BJ
        [ 0x67029C00, 0x67029FFF, "BJ" ],  // 103.2.156.0-103.2.159.255, BJ
        [ 0x6702A400, 0x6702A7FF, "BJ" ],  // 103.2.164.0-103.2.167.255, BJ
        [ 0x6702BC00, 0x6702BDFF, "BJ" ],  // 103.2.188.0-103.2.189.255, BJ
        [ 0x6702C800, 0x6702CBFF, "BJ" ],  // 103.2.200.0-103.2.203.255, BJ
        [ 0x6702CC00, 0x6702CFFF, "SH" ],  // 103.2.204.0-103.2.207.255, SH
        [ 0x6702D000, 0x6702D3FF, "BJ" ],  // 103.2.208.0-103.2.211.255, BJ
        [ 0x6702D400, 0x6702D7FF, "HL" ],  // 103.2.212.0-103.2.215.255, HL
        [ 0x67035400, 0x670357FF, "BJ" ],  // 103.3.84.0-103.3.87.255, BJ
        [ 0x67035800, 0x67035BFF, "SH" ],  // 103.3.88.0-103.3.91.255, SH
        [ 0x67035C00, 0x67035FFF, "BJ" ],  // 103.3.92.0-103.3.95.255, BJ
        [ 0x67036000, 0x670363FF, "TJ" ],  // 103.3.96.0-103.3.99.255, TJ
        [ 0x67036400, 0x670367FF, "HL" ],  // 103.3.100.0-103.3.103.255, HL
        [ 0x67036800, 0x67036BFF, "HB" ],  // 103.3.104.0-103.3.107.255, HB
        [ 0x67036C00, 0x67036FFF, "SC" ],  // 103.3.108.0-103.3.111.255, SC
        [ 0x67037000, 0x670373FF, "ZJ" ],  // 103.3.112.0-103.3.115.255, ZJ
        [ 0x67037400, 0x670377FF, "YN" ],  // 103.3.116.0-103.3.119.255, YN
        [ 0x67037800, 0x67037BFF, "BJ" ],  // 103.3.120.0-103.3.123.255, BJ
        [ 0x67037C00, 0x67037FFF, "XZ" ],  // 103.3.124.0-103.3.127.255, XZ
        [ 0x67038000, 0x670383FF, "BJ" ],  // 103.3.128.0-103.3.131.255, BJ
        [ 0x67038400, 0x670387FF, "SN" ],  // 103.3.132.0-103.3.135.255, SN
        [ 0x67038800, 0x67038BFF, "XJ" ],  // 103.3.136.0-103.3.139.255, XJ
        [ 0x67038C00, 0x67038FFF, "NM" ],  // 103.3.140.0-103.3.143.255, NM
        [ 0x67039400, 0x670397FF, "CQ" ],  // 103.3.148.0-103.3.151.255, CQ
        [ 0x67039800, 0x67039BFF, "GZ" ],  // 103.3.152.0-103.3.155.255, GZ
        [ 0x67039C00, 0x67039FFF, "HE" ],  // 103.3.156.0-103.3.159.255, HE
        [ 0x67043800, 0x67043BFF, "BJ" ],  // 103.4.56.0-103.4.59.255, BJ
        [ 0x6704A800, 0x6704ABFF, "BJ" ],  // 103.4.168.0-103.4.171.255, BJ
        [ 0x6704B800, 0x6704BBFF, "TJ" ],  // 103.4.184.0-103.4.187.255, TJ
        [ 0x6704E000, 0x6704E3FF, "GD" ],  // 103.4.224.0-103.4.227.255, GD
        [ 0x67052400, 0x670527FF, "ZJ" ],  // 103.5.36.0-103.5.39.255, ZJ
        [ 0x67053400, 0x67053BFF, "GD" ],  // 103.5.52.0-103.5.59.255, GD
        [ 0x67059800, 0x67059BFF, "BJ" ],  // 103.5.152.0-103.5.155.255, BJ
        [ 0x6705A800, 0x6705ABFF, "JS" ],  // 103.5.168.0-103.5.171.255, JS
        [ 0x6705C000, 0x6705C3FF, "SH" ],  // 103.5.192.0-103.5.195.255, SH
        [ 0x6705FC00, 0x6705FFFF, "SC" ],  // 103.5.252.0-103.5.255.255, SC
        [ 0x67064C00, 0x67064FFF, "GD" ],  // 103.6.76.0-103.6.79.255, GD
        [ 0x67066C00, 0x67066FFF, "SH" ],  // 103.6.108.0-103.6.111.255, SH
        [ 0x6706DC00, 0x6706DFFF, "SH" ],  // 103.6.220.0-103.6.223.255, SH
        [ 0x6706E400, 0x6706E7FF, "SH" ],  // 103.6.228.0-103.6.231.255, SH
        [ 0x67078C00, 0x67078FFF, "HB" ],  // 103.7.140.0-103.7.143.255, HB
        [ 0x6707D400, 0x6707D7FF, "JS" ],  // 103.7.212.0-103.7.215.255, JS
        [ 0x6707D800, 0x6707DBFF, "AH" ],  // 103.7.216.0-103.7.219.255, AH
        [ 0x6707DC00, 0x6707DFFF, "BJ" ],  // 103.7.220.0-103.7.223.255, BJ
        [ 0x67080000, 0x670803FF, "GD" ],  // 103.8.0.0-103.8.3.255, GD
        [ 0x67080400, 0x670807FF, "JS" ],  // 103.8.4.0-103.8.7.255, JS
        [ 0x67080800, 0x67080BFF, "BJ" ],  // 103.8.8.0-103.8.11.255, BJ
        [ 0x67082000, 0x670823FF, "AH" ],  // 103.8.32.0-103.8.35.255, AH
        [ 0x67083400, 0x670837FF, "BJ" ],  // 103.8.52.0-103.8.55.255, BJ
        [ 0x67084400, 0x670847FF, "HB" ],  // 103.8.68.0-103.8.71.255, HB
        [ 0x67086C00, 0x67086FFF, "FJ" ],  // 103.8.108.0-103.8.111.255, FJ
        [ 0x67089C00, 0x67089FFF, "BJ" ],  // 103.8.156.0-103.8.159.255, BJ
        [ 0x6708C800, 0x6708CBFF, "SH" ],  // 103.8.200.0-103.8.203.255, SH
        [ 0x6708CC00, 0x6708CFFF, "BJ" ],  // 103.8.204.0-103.8.207.255, BJ
        [ 0x6708DC00, 0x6708DFFF, "JS" ],  // 103.8.220.0-103.8.223.255, JS
        [ 0x67090800, 0x67090BFF, "BJ" ],  // 103.9.8.0-103.9.11.255, BJ
        [ 0x67091800, 0x67091BFF, "SH" ],  // 103.9.24.0-103.9.27.255, SH
        [ 0x67096C00, 0x67096FFF, "SH" ],  // 103.9.108.0-103.9.111.255, SH
        [ 0x67099800, 0x67099BFF, "BJ" ],  // 103.9.152.0-103.9.155.255, BJ
        [ 0x6709F800, 0x6709FFFF, "JS" ],  // 103.9.248.0-103.9.255.255, JS
        [ 0x670A0000, 0x670A03FF, "SH" ],  // 103.10.0.0-103.10.3.255, SH
        [ 0x670A1000, 0x670A13FF, "TJ" ],  // 103.10.16.0-103.10.19.255, TJ
        [ 0x670A5400, 0x670A57FF, "BJ" ],  // 103.10.84.0-103.10.87.255, BJ
        [ 0x670A8C00, 0x670A8FFF, "BJ" ],  // 103.10.140.0-103.10.143.255, BJ
        [ 0x670B1000, 0x670B13FF, "GD" ],  // 103.11.16.0-103.11.19.255, GD
        [ 0x670BA800, 0x670BABFF, "SH" ],  // 103.11.168.0-103.11.171.255, SH
        [ 0x670BB400, 0x670BB7FF, "ZJ" ],  // 103.11.180.0-103.11.183.255, ZJ
        [ 0x670C2000, 0x670C23FF, "TJ" ],  // 103.12.32.0-103.12.35.255, TJ
        [ 0x670C5C00, 0x670C5FFF, "BJ" ],  // 103.12.92.0-103.12.95.255, BJ
        [ 0x670C6200, 0x670C63FF, "YN" ],  // 103.12.98.0-103.12.99.255, YN
        [ 0x670C8800, 0x670C8BFF, "SH" ],  // 103.12.136.0-103.12.139.255, SH
        [ 0x670CB800, 0x670CBBFF, "GD" ],  // 103.12.184.0-103.12.187.255, GD
        [ 0x670CE800, 0x670CEBFF, "BJ" ],  // 103.12.232.0-103.12.235.255, BJ
        [ 0x670D0C00, 0x670D0FFF, "FJ" ],  // 103.13.12.0-103.13.15.255, FJ
        [ 0x670D7C00, 0x670D7FFF, "GD" ],  // 103.13.124.0-103.13.127.255, GD
        [ 0x670D9000, 0x670D93FF, "SH" ],  // 103.13.144.0-103.13.147.255, SH
        [ 0x670DC400, 0x670DC7FF, "SH" ],  // 103.13.196.0-103.13.199.255, SH
        [ 0x670DF400, 0x670DF7FF, "SH" ],  // 103.13.244.0-103.13.247.255, SH
        [ 0x670E5400, 0x670E57FF, "GD" ],  // 103.14.84.0-103.14.87.255, GD
        [ 0x670E6400, 0x670E67FF, "BJ" ],  // 103.14.100.0-103.14.103.255, BJ
        [ 0x670E8400, 0x670E87FF, "AH" ],  // 103.14.132.0-103.14.135.255, AH
        [ 0x670E8800, 0x670E8BFF, "BJ" ],  // 103.14.136.0-103.14.139.255, BJ
        [ 0x670E9C00, 0x670E9FFF, "SH" ],  // 103.14.156.0-103.14.159.255, SH
        [ 0x670EF000, 0x670EF3FF, "AH" ],  // 103.14.240.0-103.14.243.255, AH
        [ 0x670F0400, 0x670F07FF, "SX" ],  // 103.15.4.0-103.15.7.255, SX
        [ 0x670F0800, 0x670F0BFF, "BJ" ],  // 103.15.8.0-103.15.11.255, BJ
        [ 0x670F1000, 0x670F13FF, "SH" ],  // 103.15.16.0-103.15.19.255, SH
        [ 0x670F6000, 0x670F63FF, "BJ" ],  // 103.15.96.0-103.15.99.255, BJ
        [ 0x670FC800, 0x670FCBFF, "SD" ],  // 103.15.200.0-103.15.203.255, SD
        [ 0x67103400, 0x671037FF, "BJ" ],  // 103.16.52.0-103.16.55.255, BJ
        [ 0x67105000, 0x671053FF, "AH" ],  // 103.16.80.0-103.16.83.255, AH
        [ 0x67105400, 0x671057FF, "BJ" ],  // 103.16.84.0-103.16.87.255, BJ
        [ 0x67105800, 0x67105BFF, "AH" ],  // 103.16.88.0-103.16.91.255, AH
        [ 0x67106C00, 0x67106FFF, "BJ" ],  // 103.16.108.0-103.16.111.255, BJ
        [ 0x67107C00, 0x67107FFF, "BJ" ],  // 103.16.124.0-103.16.127.255, BJ
        [ 0x67112800, 0x67112BFF, "BJ" ],  // 103.17.40.0-103.17.43.255, BJ
        [ 0x67114000, 0x671143FF, "GD" ],  // 103.17.64.0-103.17.67.255, GD
        [ 0x67117800, 0x67117BFF, "SH" ],  // 103.17.120.0-103.17.123.255, SH
        [ 0x67118800, 0x67118BFF, "ZJ" ],  // 103.17.136.0-103.17.139.255, ZJ
        [ 0x6711A000, 0x6711A3FF, "SH" ],  // 103.17.160.0-103.17.163.255, SH
        [ 0x6711CC00, 0x6711CFFF, "SN" ],  // 103.17.204.0-103.17.207.255, SN
        [ 0x6711E400, 0x6711E7FF, "ZJ" ],  // 103.17.228.0-103.17.231.255, ZJ
        [ 0x6712BA00, 0x6712BBFF, "GD" ],  // 103.18.186.0-103.18.187.255, GD
        [ 0x6712C000, 0x6712C3FF, "GD" ],  // 103.18.192.0-103.18.195.255, GD
        [ 0x6712D000, 0x6712D3FF, "BJ" ],  // 103.18.208.0-103.18.211.255, BJ
        [ 0x6712D400, 0x6712D7FF, "GD" ],  // 103.18.212.0-103.18.215.255, GD
        [ 0x6712E000, 0x6712E3FF, "ZJ" ],  // 103.18.224.0-103.18.227.255, ZJ
        [ 0x67130C00, 0x67130FFF, "BJ" ],  // 103.19.12.0-103.19.15.255, BJ
        [ 0x67132800, 0x67132BFF, "ZJ" ],  // 103.19.40.0-103.19.43.255, ZJ
        [ 0x67132C00, 0x67132FFF, "BJ" ],  // 103.19.44.0-103.19.47.255, BJ
        [ 0x67134000, 0x67134BFF, "BJ" ],  // 103.19.64.0-103.19.75.255, BJ
        [ 0x6713E800, 0x6713EBFF, "JS" ],  // 103.19.232.0-103.19.235.255, JS
        [ 0x67140C00, 0x67140FFF, "BJ" ],  // 103.20.12.0-103.20.15.255, BJ
        [ 0x67142100, 0x671423FF, "GD" ],  // 103.20.33.0-103.20.35.255, GD
        [ 0x67142E00, 0x67142FFF, "SN" ],  // 103.20.46.0-103.20.47.255, SN
        [ 0x67144400, 0x671447FF, "BJ" ],  // 103.20.68.0-103.20.71.255, BJ
        [ 0x67147000, 0x671473FF, "BJ" ],  // 103.20.112.0-103.20.115.255, BJ
        [ 0x67148000, 0x671483FF, "BJ" ],  // 103.20.128.0-103.20.131.255, BJ
        [ 0x6714A000, 0x6714A3FF, "JS" ],  // 103.20.160.0-103.20.163.255, JS
        [ 0x6714F800, 0x6714FBFF, "SH" ],  // 103.20.248.0-103.20.251.255, SH
        [ 0x67156200, 0x671563FF, "BJ" ],  // 103.21.98.0-103.21.99.255, BJ
        [ 0x67156600, 0x671566FF, "JX" ],  // 103.21.102.0-103.21.102.255, JX
        [ 0x67157000, 0x671573FF, "BJ" ],  // 103.21.112.0-103.21.115.255, BJ
        [ 0x67157400, 0x671577FF, "JS" ],  // 103.21.116.0-103.21.119.255, JS
        [ 0x67158B00, 0x67158FFF, "SH" ],  // 103.21.139.0-103.21.143.255, SH
        [ 0x6715B000, 0x6715B3FF, "GD" ],  // 103.21.176.0-103.21.179.255, GD
        [ 0x6715F000, 0x6715F3FF, "BJ" ],  // 103.21.240.0-103.21.243.255, BJ
        [ 0x67160000, 0x671603FF, "JX" ],  // 103.22.0.0-103.22.3.255, JX
        [ 0x67160400, 0x671607FF, "BJ" ],  // 103.22.4.0-103.22.7.255, BJ
        [ 0x67160800, 0x67160BFF, "NM" ],  // 103.22.8.0-103.22.11.255, NM
        [ 0x67160C00, 0x67160FFF, "CQ" ],  // 103.22.12.0-103.22.15.255, CQ
        [ 0x67161000, 0x671613FF, "AH" ],  // 103.22.16.0-103.22.19.255, AH
        [ 0x67161400, 0x671617FF, "JS" ],  // 103.22.20.0-103.22.23.255, JS
        [ 0x67161800, 0x67161BFF, "GZ" ],  // 103.22.24.0-103.22.27.255, GZ
        [ 0x67161C00, 0x67161FFF, "YN" ],  // 103.22.28.0-103.22.31.255, YN
        [ 0x67162000, 0x671623FF, "FJ" ],  // 103.22.32.0-103.22.35.255, FJ
        [ 0x67162400, 0x671627FF, "SN" ],  // 103.22.36.0-103.22.39.255, SN
        [ 0x67162800, 0x67162BFF, "GD" ],  // 103.22.40.0-103.22.43.255, GD
        [ 0x67162C00, 0x67162FFF, "XZ" ],  // 103.22.44.0-103.22.47.255, XZ
        [ 0x67163000, 0x671633FF, "HI" ],  // 103.22.48.0-103.22.51.255, HI
        [ 0x67163400, 0x671637FF, "ZJ" ],  // 103.22.52.0-103.22.55.255, ZJ
        [ 0x67163800, 0x67163BFF, "GS" ],  // 103.22.56.0-103.22.59.255, GS
        [ 0x67163C00, 0x67163FFF, "GX" ],  // 103.22.60.0-103.22.63.255, GX
        [ 0x67164000, 0x671643FF, "NX" ],  // 103.22.64.0-103.22.67.255, NX
        [ 0x67164400, 0x671647FF, "HN" ],  // 103.22.68.0-103.22.71.255, HN
        [ 0x67164800, 0x67164BFF, "SX" ],  // 103.22.72.0-103.22.75.255, SX
        [ 0x67164C00, 0x67164FFF, "SH" ],  // 103.22.76.0-103.22.79.255, SH
        [ 0x67165000, 0x671653FF, "HB" ],  // 103.22.80.0-103.22.83.255, HB
        [ 0x67165400, 0x671657FF, "HE" ],  // 103.22.84.0-103.22.87.255, HE
        [ 0x67165800, 0x67165BFF, "HA" ],  // 103.22.88.0-103.22.91.255, HA
        [ 0x67165C00, 0x67165FFF, "BJ" ],  // 103.22.92.0-103.22.95.255, BJ
        [ 0x67166400, 0x671667FF, "QH" ],  // 103.22.100.0-103.22.103.255, QH
        [ 0x67166800, 0x67166BFF, "LN" ],  // 103.22.104.0-103.22.107.255, LN
        [ 0x67166C00, 0x67166FFF, "SD" ],  // 103.22.108.0-103.22.111.255, SD
        [ 0x67167000, 0x671673FF, "JL" ],  // 103.22.112.0-103.22.115.255, JL
        [ 0x67167400, 0x671677FF, "XJ" ],  // 103.22.116.0-103.22.119.255, XJ
        [ 0x67167800, 0x67167BFF, "TJ" ],  // 103.22.120.0-103.22.123.255, TJ
        [ 0x67167C00, 0x67167FFF, "SC" ],  // 103.22.124.0-103.22.127.255, SC
        [ 0x6716BC00, 0x6716BFFF, "HA" ],  // 103.22.188.0-103.22.191.255, HA
        [ 0x6716E400, 0x6716E7FF, "SH" ],  // 103.22.228.0-103.22.231.255, SH
        [ 0x6716FC00, 0x6716FFFF, "BJ" ],  // 103.22.252.0-103.22.255.255, BJ
        [ 0x67170800, 0x67170BFF, "YN" ],  // 103.23.8.0-103.23.11.255, YN
        [ 0x67173800, 0x67173BFF, "JS" ],  // 103.23.56.0-103.23.59.255, JS
        [ 0x6717A000, 0x6717A3FF, "BJ" ],  // 103.23.160.0-103.23.163.255, BJ
        [ 0x6717A400, 0x6717A7FF, "GD" ],  // 103.23.164.0-103.23.167.255, GD
        [ 0x6717B000, 0x6717B3FF, "BJ" ],  // 103.23.176.0-103.23.179.255, BJ
        [ 0x6717E400, 0x6717E7FF, "BJ" ],  // 103.23.228.0-103.23.231.255, BJ
        [ 0x67181800, 0x67181BFF, "GD" ],  // 103.24.24.0-103.24.27.255, GD
        [ 0x67187400, 0x671877FF, "SH" ],  // 103.24.116.0-103.24.119.255, SH
        [ 0x67188000, 0x671883FF, "BJ" ],  // 103.24.128.0-103.24.131.255, BJ
        [ 0x67189000, 0x671893FF, "GD" ],  // 103.24.144.0-103.24.147.255, GD
        [ 0x6718B000, 0x6718B3FF, "GD" ],  // 103.24.176.0-103.24.179.255, GD
        [ 0x6718B800, 0x6718BBFF, "SC" ],  // 103.24.184.0-103.24.187.255, SC
        [ 0x6718DC00, 0x6718DFFF, "SH" ],  // 103.24.220.0-103.24.223.255, SH
        [ 0x6718E400, 0x6718E7FF, "TJ" ],  // 103.24.228.0-103.24.231.255, TJ
        [ 0x6718FC00, 0x6718FFFF, "SH" ],  // 103.24.252.0-103.24.255.255, SH
        [ 0x67191400, 0x67191BFF, "BJ" ],  // 103.25.20.0-103.25.27.255, BJ
        [ 0x67191C00, 0x67191FFF, "HE" ],  // 103.25.28.0-103.25.31.255, HE
        [ 0x67192000, 0x671923FF, "SD" ],  // 103.25.32.0-103.25.35.255, SD
        [ 0x67192400, 0x671927FF, "BJ" ],  // 103.25.36.0-103.25.39.255, BJ
        [ 0x67192800, 0x67192BFF, "TJ" ],  // 103.25.40.0-103.25.43.255, TJ
        [ 0x67193000, 0x671933FF, "JL" ],  // 103.25.48.0-103.25.51.255, JL
        [ 0x67194000, 0x671943FF, "SH" ],  // 103.25.64.0-103.25.67.255, SH
        [ 0x67194400, 0x671947FF, "BJ" ],  // 103.25.68.0-103.25.71.255, BJ
        [ 0x67199400, 0x671997FF, "GD" ],  // 103.25.148.0-103.25.151.255, GD
        [ 0x67199C00, 0x67199FFF, "BJ" ],  // 103.25.156.0-103.25.159.255, BJ
        [ 0x6719D800, 0x6719DBFF, "SH" ],  // 103.25.216.0-103.25.219.255, SH
        [ 0x671A0000, 0x671A03FF, "BJ" ],  // 103.26.0.0-103.26.3.255, BJ
        [ 0x671A4000, 0x671A41FF, "BJ" ],  // 103.26.64.0-103.26.65.255, BJ
        [ 0x671A4200, 0x671A43FF, "SH" ],  // 103.26.66.0-103.26.67.255, SH
        [ 0x671A4C00, 0x671A4FFF, "JS" ],  // 103.26.76.0-103.26.79.255, JS
        [ 0x671A8400, 0x671A87FF, "BJ" ],  // 103.26.132.0-103.26.135.255, BJ
        [ 0x671A9C00, 0x671A9FFF, "SD" ],  // 103.26.156.0-103.26.159.255, SD
        [ 0x671AA000, 0x671AA3FF, "BJ" ],  // 103.26.160.0-103.26.163.255, BJ
        [ 0x671AE400, 0x671AE7FF, "SH" ],  // 103.26.228.0-103.26.231.255, SH
        [ 0x671AF000, 0x671AF3FF, "CQ" ],  // 103.26.240.0-103.26.243.255, CQ
        [ 0x671B0400, 0x671B07FF, "FJ" ],  // 103.27.4.0-103.27.7.255, FJ
        [ 0x671B0C00, 0x671B0FFF, "BJ" ],  // 103.27.12.0-103.27.15.255, BJ
        [ 0x671B1800, 0x671B1BFF, "GD" ],  // 103.27.24.0-103.27.27.255, GD
        [ 0x671B3800, 0x671B3BFF, "JS" ],  // 103.27.56.0-103.27.59.255, JS
        [ 0x671B6000, 0x671B63FF, "BJ" ],  // 103.27.96.0-103.27.99.255, BJ
        [ 0x671BF000, 0x671BF3FF, "SX" ],  // 103.27.240.0-103.27.243.255, SX
        [ 0x671C0400, 0x671C07FF, "GD" ],  // 103.28.4.0-103.28.7.255, GD
        [ 0x671C0800, 0x671C0BFF, "BJ" ],  // 103.28.8.0-103.28.11.255, BJ
        [ 0x671CB800, 0x671CBBFF, "GD" ],  // 103.28.184.0-103.28.187.255, GD
        [ 0x671CCC00, 0x671CCFFF, "AH" ],  // 103.28.204.0-103.28.207.255, AH
        [ 0x671CD400, 0x671CD7FF, "SH" ],  // 103.28.212.0-103.28.215.255, SH
        [ 0x671D1000, 0x671D13FF, "BJ" ],  // 103.29.16.0-103.29.19.255, BJ
        [ 0x671D1800, 0x671D19FF, "JS" ],  // 103.29.24.0-103.29.25.255, JS
        [ 0x671D1D00, 0x671D1DFF, "SH" ],  // 103.29.29.0-103.29.29.255, SH
        [ 0x671D8000, 0x671D83FF, "HL" ],  // 103.29.128.0-103.29.131.255, HL
        [ 0x671D8400, 0x671D8BFF, "BJ" ],  // 103.29.132.0-103.29.139.255, BJ
        [ 0x671DEC00, 0x671DEDFF, "GD" ],  // 103.29.236.0-103.29.237.255, GD
        [ 0x671E1400, 0x671E17FF, "BJ" ],  // 103.30.20.0-103.30.23.255, BJ
        [ 0x671E6000, 0x671E63FF, "ZJ" ],  // 103.30.96.0-103.30.99.255, ZJ
        [ 0x671E6800, 0x671E69FF, "ZJ" ],  // 103.30.104.0-103.30.105.255, ZJ
        [ 0x671E6A00, 0x671E6BFF, "BJ" ],  // 103.30.106.0-103.30.107.255, BJ
        [ 0x671E9400, 0x671E97FF, "BJ" ],  // 103.30.148.0-103.30.151.255, BJ
        [ 0x671EE400, 0x671EE7FF, "SD" ],  // 103.30.228.0-103.30.231.255, SD
        [ 0x671EEC00, 0x671EEFFF, "BJ" ],  // 103.30.236.0-103.30.239.255, BJ
        [ 0x671F0000, 0x671F03FF, "LN" ],  // 103.31.0.0-103.31.3.255, LN
        [ 0x671F3000, 0x671F33FF, "SH" ],  // 103.31.48.0-103.31.51.255, SH
        [ 0x671F3400, 0x671F37FF, "BJ" ],  // 103.31.52.0-103.31.55.255, BJ
        [ 0x671F3800, 0x671F3BFF, "ZJ" ],  // 103.31.56.0-103.31.59.255, ZJ
        [ 0x671F3C00, 0x671F47FF, "SH" ],  // 103.31.60.0-103.31.71.255, SH
        [ 0x671F9400, 0x671F97FF, "BJ" ],  // 103.31.148.0-103.31.151.255, BJ
        [ 0x671FA000, 0x671FA3FF, "HA" ],  // 103.31.160.0-103.31.163.255, HA
        [ 0x671FA800, 0x671FABFF, "ZJ" ],  // 103.31.168.0-103.31.171.255, ZJ
        [ 0x671FC800, 0x671FCBFF, "SH" ],  // 103.31.200.0-103.31.203.255, SH
        [ 0x671FEC00, 0x671FEFFF, "HL" ],  // 103.31.236.0-103.31.239.255, HL
        [ 0x671FF200, 0x671FF3FF, "SH" ],  // 103.31.242.0-103.31.243.255, SH
        [ 0x67200000, 0x672003FF, "BJ" ],  // 103.32.0.0-103.32.3.255, BJ
        [ 0x67200400, 0x672007FF, "NM" ],  // 103.32.4.0-103.32.7.255, NM
        [ 0x67200800, 0x67200BFF, "GD" ],  // 103.32.8.0-103.32.11.255, GD
        [ 0x67200C00, 0x67200FFF, "HE" ],  // 103.32.12.0-103.32.15.255, HE
        [ 0x67201000, 0x672017FF, "BJ" ],  // 103.32.16.0-103.32.23.255, BJ
        [ 0x67201800, 0x67201FFF, "JS" ],  // 103.32.24.0-103.32.31.255, JS
        [ 0x67202000, 0x672027FF, "SC" ],  // 103.32.32.0-103.32.39.255, SC
        [ 0x67202800, 0x67202BFF, "LN" ],  // 103.32.40.0-103.32.43.255, LN
        [ 0x67202C00, 0x672033FF, "GD" ],  // 103.32.44.0-103.32.51.255, GD
        [ 0x67203400, 0x672037FF, "SD" ],  // 103.32.52.0-103.32.55.255, SD
        [ 0x67203800, 0x67203BFF, "GD" ],  // 103.32.56.0-103.32.59.255, GD
        [ 0x67203C00, 0x67203FFF, "FJ" ],  // 103.32.60.0-103.32.63.255, FJ
        [ 0x67204000, 0x672043FF, "GD" ],  // 103.32.64.0-103.32.67.255, GD
        [ 0x67204400, 0x672047FF, "GZ" ],  // 103.32.68.0-103.32.71.255, GZ
        [ 0x67204800, 0x67204BFF, "HL" ],  // 103.32.72.0-103.32.75.255, HL
        [ 0x67204C00, 0x67204FFF, "ZJ" ],  // 103.32.76.0-103.32.79.255, ZJ
        [ 0x67205000, 0x672053FF, "AH" ],  // 103.32.80.0-103.32.83.255, AH
        [ 0x67205400, 0x672057FF, "GD" ],  // 103.32.84.0-103.32.87.255, GD
        [ 0x67205800, 0x67205BFF, "SD" ],  // 103.32.88.0-103.32.91.255, SD
        [ 0x67205C00, 0x67205FFF, "ZJ" ],  // 103.32.92.0-103.32.95.255, ZJ
        [ 0x67206000, 0x672063FF, "GD" ],  // 103.32.96.0-103.32.99.255, GD
        [ 0x67206400, 0x672067FF, "JS" ],  // 103.32.100.0-103.32.103.255, JS
        [ 0x67206800, 0x67206BFF, "ZJ" ],  // 103.32.104.0-103.32.107.255, ZJ
        [ 0x67206C00, 0x67206FFF, "LN" ],  // 103.32.108.0-103.32.111.255, LN
        [ 0x67207000, 0x672073FF, "YN" ],  // 103.32.112.0-103.32.115.255, YN
        [ 0x67207400, 0x672077FF, "JS" ],  // 103.32.116.0-103.32.119.255, JS
        [ 0x67207800, 0x67207BFF, "SD" ],  // 103.32.120.0-103.32.123.255, SD
        [ 0x67207C00, 0x67207FFF, "GX" ],  // 103.32.124.0-103.32.127.255, GX
        [ 0x67208000, 0x672083FF, "HA" ],  // 103.32.128.0-103.32.131.255, HA
        [ 0x67208400, 0x672087FF, "SC" ],  // 103.32.132.0-103.32.135.255, SC
        [ 0x67208800, 0x67208BFF, "HL" ],  // 103.32.136.0-103.32.139.255, HL
        [ 0x67208C00, 0x67208FFF, "JX" ],  // 103.32.140.0-103.32.143.255, JX
        [ 0x67209000, 0x672093FF, "JS" ],  // 103.32.144.0-103.32.147.255, JS
        [ 0x67209400, 0x672097FF, "GX" ],  // 103.32.148.0-103.32.151.255, GX
        [ 0x67209800, 0x67209BFF, "JS" ],  // 103.32.152.0-103.32.155.255, JS
        [ 0x67209C00, 0x67209FFF, "ZJ" ],  // 103.32.156.0-103.32.159.255, ZJ
        [ 0x6720A000, 0x6720A7FF, "FJ" ],  // 103.32.160.0-103.32.167.255, FJ
        [ 0x6720A800, 0x6720ABFF, "GD" ],  // 103.32.168.0-103.32.171.255, GD
        [ 0x6720AC00, 0x6720B3FF, "SH" ],  // 103.32.172.0-103.32.179.255, SH
        [ 0x6720B400, 0x6720B7FF, "ZJ" ],  // 103.32.180.0-103.32.183.255, ZJ
        [ 0x6720B800, 0x6720BFFF, "GD" ],  // 103.32.184.0-103.32.191.255, GD
        [ 0x6720C000, 0x6720C3FF, "LN" ],  // 103.32.192.0-103.32.195.255, LN
        [ 0x6720C400, 0x6720C7FF, "HE" ],  // 103.32.196.0-103.32.199.255, HE
        [ 0x6720C800, 0x6720CBFF, "GD" ],  // 103.32.200.0-103.32.203.255, GD
        [ 0x6720CC00, 0x6720CFFF, "JS" ],  // 103.32.204.0-103.32.207.255, JS
        [ 0x6720D000, 0x6720D3FF, "ZJ" ],  // 103.32.208.0-103.32.211.255, ZJ
        [ 0x6720D400, 0x6720D7FF, "SX" ],  // 103.32.212.0-103.32.215.255, SX
        [ 0x6720D800, 0x6720DBFF, "ZJ" ],  // 103.32.216.0-103.32.219.255, ZJ
        [ 0x6720DC00, 0x6720DFFF, "HE" ],  // 103.32.220.0-103.32.223.255, HE
        [ 0x6720E000, 0x6720E3FF, "TJ" ],  // 103.32.224.0-103.32.227.255, TJ
        [ 0x6720E400, 0x6720EBFF, "SD" ],  // 103.32.228.0-103.32.235.255, SD
        [ 0x6720EC00, 0x6720EFFF, "ZJ" ],  // 103.32.236.0-103.32.239.255, ZJ
        [ 0x6720F000, 0x6720F3FF, "JS" ],  // 103.32.240.0-103.32.243.255, JS
        [ 0x6720F400, 0x6720FBFF, "HB" ],  // 103.32.244.0-103.32.251.255, HB
        [ 0x6720FC00, 0x6720FFFF, "SN" ],  // 103.32.252.0-103.32.255.255, SN
        [ 0x67210000, 0x672103FF, "SD" ],  // 103.33.0.0-103.33.3.255, SD
        [ 0x67210400, 0x672107FF, "JS" ],  // 103.33.4.0-103.33.7.255, JS
        [ 0x67210800, 0x67210BFF, "HB" ],  // 103.33.8.0-103.33.11.255, HB
        [ 0x67210C00, 0x67210FFF, "ZJ" ],  // 103.33.12.0-103.33.15.255, ZJ
        [ 0x67211000, 0x672113FF, "LN" ],  // 103.33.16.0-103.33.19.255, LN
        [ 0x67211400, 0x672117FF, "JL" ],  // 103.33.20.0-103.33.23.255, JL
        [ 0x67211800, 0x67211BFF, "HN" ],  // 103.33.24.0-103.33.27.255, HN
        [ 0x67211C00, 0x67211FFF, "HA" ],  // 103.33.28.0-103.33.31.255, HA
        [ 0x67212000, 0x672123FF, "GD" ],  // 103.33.32.0-103.33.35.255, GD
        [ 0x67212400, 0x672127FF, "CQ" ],  // 103.33.36.0-103.33.39.255, CQ
        [ 0x67212800, 0x67212BFF, "GD" ],  // 103.33.40.0-103.33.43.255, GD
        [ 0x67212C00, 0x672133FF, "SD" ],  // 103.33.44.0-103.33.51.255, SD
        [ 0x67213400, 0x67213BFF, "GD" ],  // 103.33.52.0-103.33.59.255, GD
        [ 0x67213C00, 0x672147FF, "ZJ" ],  // 103.33.60.0-103.33.71.255, ZJ
        [ 0x67214800, 0x67214BFF, "TJ" ],  // 103.33.72.0-103.33.75.255, TJ
        [ 0x67214C00, 0x672157FF, "ZJ" ],  // 103.33.76.0-103.33.87.255, ZJ
        [ 0x67215800, 0x67215BFF, "AH" ],  // 103.33.88.0-103.33.91.255, AH
        [ 0x67215C00, 0x67215FFF, "GD" ],  // 103.33.92.0-103.33.95.255, GD
        [ 0x67216000, 0x67217BFF, "BJ" ],  // 103.33.96.0-103.33.123.255, BJ
        [ 0x67217C00, 0x67217FFF, "SC" ],  // 103.33.124.0-103.33.127.255, SC
        [ 0x67218000, 0x672187FF, "LN" ],  // 103.33.128.0-103.33.135.255, LN
        [ 0x67218800, 0x67218BFF, "GD" ],  // 103.33.136.0-103.33.139.255, GD
        [ 0x67218C00, 0x672193FF, "SD" ],  // 103.33.140.0-103.33.147.255, SD
        [ 0x67219400, 0x672197FF, "FJ" ],  // 103.33.148.0-103.33.151.255, FJ
        [ 0x67219800, 0x67219BFF, "JL" ],  // 103.33.152.0-103.33.155.255, JL
        [ 0x67219C00, 0x67219FFF, "GD" ],  // 103.33.156.0-103.33.159.255, GD
        [ 0x6721A000, 0x6721BFFF, "SH" ],  // 103.33.160.0-103.33.191.255, SH
        [ 0x6721C000, 0x6721CFFF, "GD" ],  // 103.33.192.0-103.33.207.255, GD
        [ 0x6721D000, 0x6721D3FF, "SD" ],  // 103.33.208.0-103.33.211.255, SD
        [ 0x6721D400, 0x6721D7FF, "AH" ],  // 103.33.212.0-103.33.215.255, AH
        [ 0x6721D800, 0x6721DBFF, "HB" ],  // 103.33.216.0-103.33.219.255, HB
        [ 0x6721DC00, 0x6721DFFF, "JS" ],  // 103.33.220.0-103.33.223.255, JS
        [ 0x6721E000, 0x6721E3FF, "FJ" ],  // 103.33.224.0-103.33.227.255, FJ
        [ 0x6721E400, 0x6721E7FF, "ZJ" ],  // 103.33.228.0-103.33.231.255, ZJ
        [ 0x6721E800, 0x6721EBFF, "JS" ],  // 103.33.232.0-103.33.235.255, JS
        [ 0x6721EC00, 0x6721EFFF, "CQ" ],  // 103.33.236.0-103.33.239.255, CQ
        [ 0x6721F000, 0x6721FBFF, "BJ" ],  // 103.33.240.0-103.33.251.255, BJ
        [ 0x6721FC00, 0x6721FFFF, "ZJ" ],  // 103.33.252.0-103.33.255.255, ZJ
        [ 0x67220000, 0x672203FF, "GD" ],  // 103.34.0.0-103.34.3.255, GD
        [ 0x67220400, 0x672207FF, "BJ" ],  // 103.34.4.0-103.34.7.255, BJ
        [ 0x67220800, 0x67220BFF, "HI" ],  // 103.34.8.0-103.34.11.255, HI
        [ 0x67220C00, 0x67220FFF, "ZJ" ],  // 103.34.12.0-103.34.15.255, ZJ
        [ 0x67221000, 0x672213FF, "FJ" ],  // 103.34.16.0-103.34.19.255, FJ
        [ 0x67221400, 0x67221BFF, "SH" ],  // 103.34.20.0-103.34.27.255, SH
        [ 0x67221C00, 0x67221FFF, "HB" ],  // 103.34.28.0-103.34.31.255, HB
        [ 0x67222000, 0x672223FF, "HA" ],  // 103.34.32.0-103.34.35.255, HA
        [ 0x67222400, 0x672227FF, "BJ" ],  // 103.34.36.0-103.34.39.255, BJ
        [ 0x67222800, 0x67222BFF, "SD" ],  // 103.34.40.0-103.34.43.255, SD
        [ 0x67222C00, 0x67222FFF, "ZJ" ],  // 103.34.44.0-103.34.47.255, ZJ
        [ 0x67223000, 0x67223FFF, "FJ" ],  // 103.34.48.0-103.34.63.255, FJ
        [ 0x67224000, 0x672243FF, "SH" ],  // 103.34.64.0-103.34.67.255, SH
        [ 0x67224400, 0x672247FF, "GD" ],  // 103.34.68.0-103.34.71.255, GD
        [ 0x67224800, 0x672267FF, "BJ" ],  // 103.34.72.0-103.34.103.255, BJ
        [ 0x67226800, 0x67226BFF, "SD" ],  // 103.34.104.0-103.34.107.255, SD
        [ 0x67226C00, 0x67227BFF, "GD" ],  // 103.34.108.0-103.34.123.255, GD
        [ 0x67227C00, 0x672283FF, "ZJ" ],  // 103.34.124.0-103.34.131.255, ZJ
        [ 0x67228400, 0x672287FF, "JS" ],  // 103.34.132.0-103.34.135.255, JS
        [ 0x67228800, 0x67228BFF, "HA" ],  // 103.34.136.0-103.34.139.255, HA
        [ 0x67228C00, 0x67228FFF, "HL" ],  // 103.34.140.0-103.34.143.255, HL
        [ 0x67229000, 0x672293FF, "HN" ],  // 103.34.144.0-103.34.147.255, HN
        [ 0x67229400, 0x672297FF, "JL" ],  // 103.34.148.0-103.34.151.255, JL
        [ 0x67229800, 0x67229FFF, "JS" ],  // 103.34.152.0-103.34.159.255, JS
        [ 0x6722A000, 0x6722ABFF, "BJ" ],  // 103.34.160.0-103.34.171.255, BJ
        [ 0x6722AC00, 0x6722B3FF, "JS" ],  // 103.34.172.0-103.34.179.255, JS
        [ 0x6722B400, 0x6722B7FF, "ZJ" ],  // 103.34.180.0-103.34.183.255, ZJ
        [ 0x6722B800, 0x6722BBFF, "SD" ],  // 103.34.184.0-103.34.187.255, SD
        [ 0x6722BC00, 0x6722C3FF, "FJ" ],  // 103.34.188.0-103.34.195.255, FJ
        [ 0x6722C400, 0x6722CBFF, "SD" ],  // 103.34.196.0-103.34.203.255, SD
        [ 0x6722CC00, 0x6722E7FF, "SH" ],  // 103.34.204.0-103.34.231.255, SH
        [ 0x6722E800, 0x6722F7FF, "GD" ],  // 103.34.232.0-103.34.247.255, GD
        [ 0x6722F800, 0x6722FBFF, "JS" ],  // 103.34.248.0-103.34.251.255, JS
        [ 0x6722FC00, 0x672303FF, "LN" ],  // 103.34.252.0-103.35.3.255, LN
        [ 0x67230400, 0x672307FF, "BJ" ],  // 103.35.4.0-103.35.7.255, BJ
        [ 0x67230800, 0x67230BFF, "SD" ],  // 103.35.8.0-103.35.11.255, SD
        [ 0x67230C00, 0x67230FFF, "AH" ],  // 103.35.12.0-103.35.15.255, AH
        [ 0x67231000, 0x672313FF, "FJ" ],  // 103.35.16.0-103.35.19.255, FJ
        [ 0x67231400, 0x672317FF, "BJ" ],  // 103.35.20.0-103.35.23.255, BJ
        [ 0x67231800, 0x67231BFF, "CQ" ],  // 103.35.24.0-103.35.27.255, CQ
        [ 0x67231C00, 0x67231FFF, "SD" ],  // 103.35.28.0-103.35.31.255, SD
        [ 0x67232000, 0x672333FF, "BJ" ],  // 103.35.32.0-103.35.51.255, BJ
        [ 0x67236800, 0x67236BFF, "BJ" ],  // 103.35.104.0-103.35.107.255, BJ
        [ 0x67237400, 0x672377FF, "GD" ],  // 103.35.116.0-103.35.119.255, GD
        [ 0x6723B400, 0x6723B5FF, "TJ" ],  // 103.35.180.0-103.35.181.255, TJ
        [ 0x6723C800, 0x6723CBFF, "GD" ],  // 103.35.200.0-103.35.203.255, GD
        [ 0x6723DC00, 0x6723DDFF, "JS" ],  // 103.35.220.0-103.35.221.255, JS
        [ 0x6723DE00, 0x6723DFFF, "BJ" ],  // 103.35.222.0-103.35.223.255, BJ
        [ 0x67241C00, 0x67241FFF, "TJ" ],  // 103.36.28.0-103.36.31.255, TJ
        [ 0x67242400, 0x672427FF, "SD" ],  // 103.36.36.0-103.36.39.255, SD
        [ 0x67243800, 0x67243BFF, "BJ" ],  // 103.36.56.0-103.36.59.255, BJ
        [ 0x67243C00, 0x67243FFF, "ZJ" ],  // 103.36.60.0-103.36.63.255, ZJ
        [ 0x67244000, 0x672443FF, "SH" ],  // 103.36.64.0-103.36.67.255, SH
        [ 0x67244800, 0x67244BFF, "GD" ],  // 103.36.72.0-103.36.75.255, GD
        [ 0x67246000, 0x672463FF, "BJ" ],  // 103.36.96.0-103.36.99.255, BJ
        [ 0x67248400, 0x67248BFF, "SH" ],  // 103.36.132.0-103.36.139.255, SH
        [ 0x6724A000, 0x6724A3FF, "BJ" ],  // 103.36.160.0-103.36.163.255, BJ
        [ 0x6724A400, 0x6724A7FF, "ZJ" ],  // 103.36.164.0-103.36.167.255, ZJ
        [ 0x6724A800, 0x6724AFFF, "SH" ],  // 103.36.168.0-103.36.175.255, SH
        [ 0x6724B000, 0x6724BBFF, "JS" ],  // 103.36.176.0-103.36.187.255, JS
        [ 0x6724BC00, 0x6724BFFF, "FJ" ],  // 103.36.188.0-103.36.191.255, FJ
        [ 0x6724C000, 0x6724CFFF, "JS" ],  // 103.36.192.0-103.36.207.255, JS
        [ 0x6724D000, 0x6724D7FF, "ZJ" ],  // 103.36.208.0-103.36.215.255, ZJ
        [ 0x6724D800, 0x6724DBFF, "FJ" ],  // 103.36.216.0-103.36.219.255, FJ
        [ 0x6724DC00, 0x6724DDFF, "BJ" ],  // 103.36.220.0-103.36.221.255, BJ
        [ 0x6724DE00, 0x6724DFFF, "FJ" ],  // 103.36.222.0-103.36.223.255, FJ
        [ 0x6724E000, 0x6724F7FF, "BJ" ],  // 103.36.224.0-103.36.247.255, BJ
        [ 0x67250C00, 0x67250FFF, "SD" ],  // 103.37.12.0-103.37.15.255, SD
        [ 0x67251000, 0x672513FF, "ZJ" ],  // 103.37.16.0-103.37.19.255, ZJ
        [ 0x67251800, 0x67251BFF, "BJ" ],  // 103.37.24.0-103.37.27.255, BJ
        [ 0x67252C00, 0x67252FFF, "JS" ],  // 103.37.44.0-103.37.47.255, JS
        [ 0x67253400, 0x67253BFF, "ZJ" ],  // 103.37.52.0-103.37.59.255, ZJ
        [ 0x67254800, 0x67254BFF, "BJ" ],  // 103.37.72.0-103.37.75.255, BJ
        [ 0x67256400, 0x672567FF, "SD" ],  // 103.37.100.0-103.37.103.255, SD
        [ 0x67256800, 0x67256BFF, "FJ" ],  // 103.37.104.0-103.37.107.255, FJ
        [ 0x67258800, 0x6725A7FF, "BJ" ],  // 103.37.136.0-103.37.167.255, BJ
        [ 0x6725AC00, 0x6725AFFF, "BJ" ],  // 103.37.172.0-103.37.175.255, BJ
        [ 0x6725B000, 0x6725B3FF, "SC" ],  // 103.37.176.0-103.37.179.255, SC
        [ 0x6725BC00, 0x6725BFFF, "GD" ],  // 103.37.188.0-103.37.191.255, GD
        [ 0x6725D000, 0x6725DFFF, "BJ" ],  // 103.37.208.0-103.37.223.255, BJ
        [ 0x6725FC00, 0x6725FFFF, "BJ" ],  // 103.37.252.0-103.37.255.255, BJ
        [ 0x67260000, 0x672603FF, "TJ" ],  // 103.38.0.0-103.38.3.255, TJ
        [ 0x67262000, 0x672623FF, "HN" ],  // 103.38.32.0-103.38.35.255, HN
        [ 0x67262800, 0x67262BFF, "HN" ],  // 103.38.40.0-103.38.43.255, HN
        [ 0x67262C00, 0x67262FFF, "GD" ],  // 103.38.44.0-103.38.47.255, GD
        [ 0x67263800, 0x67263BFF, "BJ" ],  // 103.38.56.0-103.38.59.255, BJ
        [ 0x67264C00, 0x67264FFF, "BJ" ],  // 103.38.76.0-103.38.79.255, BJ
        [ 0x67265400, 0x672657FF, "ZJ" ],  // 103.38.84.0-103.38.87.255, ZJ
        [ 0x67265C00, 0x672663FF, "BJ" ],  // 103.38.92.0-103.38.99.255, BJ
        [ 0x67267400, 0x672677FF, "TJ" ],  // 103.38.116.0-103.38.119.255, TJ
        [ 0x67268400, 0x672687FF, "HA" ],  // 103.38.132.0-103.38.135.255, HA
        [ 0x67268C00, 0x67268FFF, "BJ" ],  // 103.38.140.0-103.38.143.255, BJ
        [ 0x6726E000, 0x6726E3FF, "BJ" ],  // 103.38.224.0-103.38.227.255, BJ
        [ 0x6726E400, 0x6726E7FF, "HE" ],  // 103.38.228.0-103.38.231.255, HE
        [ 0x6726E800, 0x6726EBFF, "SH" ],  // 103.38.232.0-103.38.235.255, SH
        [ 0x6726FC00, 0x6726FDFF, "SH" ],  // 103.38.252.0-103.38.253.255, SH
        [ 0x67274000, 0x672743FF, "BJ" ],  // 103.39.64.0-103.39.67.255, BJ
        [ 0x67275800, 0x67275BFF, "AH" ],  // 103.39.88.0-103.39.91.255, AH
        [ 0x67276400, 0x672767FF, "BJ" ],  // 103.39.100.0-103.39.103.255, BJ
        [ 0x67276800, 0x67276BFF, "LN" ],  // 103.39.104.0-103.39.107.255, LN
        [ 0x6727A000, 0x6727BFFF, "GD" ],  // 103.39.160.0-103.39.191.255, GD
        [ 0x6727C800, 0x6727CFFF, "BJ" ],  // 103.39.200.0-103.39.207.255, BJ
        [ 0x6727D000, 0x6727EBFF, "GD" ],  // 103.39.208.0-103.39.235.255, GD
        [ 0x67280C00, 0x67282FFF, "JS" ],  // 103.40.12.0-103.40.47.255, JS
        [ 0x67285800, 0x67285BFF, "HB" ],  // 103.40.88.0-103.40.91.255, HB
        [ 0x67289E00, 0x67289FFF, "HI" ],  // 103.40.158.0-103.40.159.255, HI
        [ 0x6728AE00, 0x6728AFFF, "GD" ],  // 103.40.174.0-103.40.175.255, GD
        [ 0x6728C000, 0x6728C3FF, "JS" ],  // 103.40.192.0-103.40.195.255, JS
        [ 0x6728D400, 0x6728D7FF, "HL" ],  // 103.40.212.0-103.40.215.255, HL
        [ 0x6728DC00, 0x6728DDFF, "SH" ],  // 103.40.220.0-103.40.221.255, SH
        [ 0x6728DE00, 0x6728DEFF, "GD" ],  // 103.40.222.0-103.40.222.255, GD
        [ 0x6728DF00, 0x6728DFFF, "SH" ],  // 103.40.223.0-103.40.223.255, SH
        [ 0x6728E400, 0x6728E7FF, "BJ" ],  // 103.40.228.0-103.40.231.255, BJ
        [ 0x6728E800, 0x6728EFFF, "JS" ],  // 103.40.232.0-103.40.239.255, JS
        [ 0x6728F000, 0x6728FFFF, "GD" ],  // 103.40.240.0-103.40.255.255, GD
        [ 0x67290000, 0x672903FF, "BJ" ],  // 103.41.0.0-103.41.3.255, BJ
        [ 0x67293400, 0x672937FF, "BJ" ],  // 103.41.52.0-103.41.55.255, BJ
        [ 0x67297400, 0x672977FF, "ZJ" ],  // 103.41.116.0-103.41.119.255, ZJ
        [ 0x67298C00, 0x67298CA5, "BJ" ],  // 103.41.140.0-103.41.140.165, BJ
        [ 0x67298CA6, 0x67298EFF, "GD" ],  // 103.41.140.166-103.41.142.255, GD
        [ 0x67298F00, 0x67298FAB, "SD" ],  // 103.41.143.0-103.41.143.171, SD
        [ 0x67298FAC, 0x67298FFF, "BJ" ],  // 103.41.143.172-103.41.143.255, BJ
        [ 0x67299400, 0x67299BFF, "HB" ],  // 103.41.148.0-103.41.155.255, HB
        [ 0x6729A000, 0x6729A3FF, "SC" ],  // 103.41.160.0-103.41.163.255, SC
        [ 0x6729A400, 0x6729A7FF, "HE" ],  // 103.41.164.0-103.41.167.255, HE
        [ 0x6729DC00, 0x6729E3FF, "HB" ],  // 103.41.220.0-103.41.227.255, HB
        [ 0x6729E400, 0x6729E7FF, "SC" ],  // 103.41.228.0-103.41.231.255, SC
        [ 0x6729E800, 0x6729EBFF, "GZ" ],  // 103.41.232.0-103.41.235.255, GZ
        [ 0x672A0800, 0x672A0BFF, "JS" ],  // 103.42.8.0-103.42.11.255, JS
        [ 0x672A1800, 0x672A1BFF, "LN" ],  // 103.42.24.0-103.42.27.255, LN
        [ 0x672A2000, 0x672A23FF, "BJ" ],  // 103.42.32.0-103.42.35.255, BJ
        [ 0x672A4000, 0x672A43FF, "GZ" ],  // 103.42.64.0-103.42.67.255, GZ
        [ 0x672A4400, 0x672A47FF, "BJ" ],  // 103.42.68.0-103.42.71.255, BJ
        [ 0x672A4C00, 0x672A4FFF, "BJ" ],  // 103.42.76.0-103.42.79.255, BJ
        [ 0x672A6800, 0x672A6BFF, "GD" ],  // 103.42.104.0-103.42.107.255, GD
        [ 0x672AE800, 0x672AEBFF, "LN" ],  // 103.42.232.0-103.42.235.255, LN
        [ 0x672B1200, 0x672B13FF, "JS" ],  // 103.43.18.0-103.43.19.255, JS
        [ 0x672B6000, 0x672B67FF, "BJ" ],  // 103.43.96.0-103.43.103.255, BJ
        [ 0x672B6800, 0x672B6BFF, "AH" ],  // 103.43.104.0-103.43.107.255, AH
        [ 0x672B7C00, 0x672B7FFF, "SH" ],  // 103.43.124.0-103.43.127.255, SH
        [ 0x672B8400, 0x672B87FF, "ZJ" ],  // 103.43.132.0-103.43.135.255, ZJ
        [ 0x672BB800, 0x672BBBFF, "BJ" ],  // 103.43.184.0-103.43.187.255, BJ
        [ 0x672BC000, 0x672BC7FF, "SH" ],  // 103.43.192.0-103.43.199.255, SH
        [ 0x672BD000, 0x672BD3FF, "HB" ],  // 103.43.208.0-103.43.211.255, HB
        [ 0x672BDC00, 0x672BE3FF, "BJ" ],  // 103.43.220.0-103.43.227.255, BJ
        [ 0x672BF000, 0x672BF3FF, "GD" ],  // 103.43.240.0-103.43.243.255, GD
        [ 0x672C3A00, 0x672C3BFF, "BJ" ],  // 103.44.58.0-103.44.59.255, BJ
        [ 0x672C5000, 0x672C53FF, "ZJ" ],  // 103.44.80.0-103.44.83.255, ZJ
        [ 0x672C7800, 0x672C7FFF, "BJ" ],  // 103.44.120.0-103.44.127.255, BJ
        [ 0x672C9000, 0x672C93FF, "ZJ" ],  // 103.44.144.0-103.44.147.255, ZJ
        [ 0x672CA800, 0x672CABFF, "HL" ],  // 103.44.168.0-103.44.171.255, HL
        [ 0x672CB000, 0x672CB7FF, "BJ" ],  // 103.44.176.0-103.44.183.255, BJ
        [ 0x672CB800, 0x672CBBFF, "SH" ],  // 103.44.184.0-103.44.187.255, SH
        [ 0x672CBC00, 0x672CCFFF, "BJ" ],  // 103.44.188.0-103.44.207.255, BJ
        [ 0x672CE000, 0x672CE3FF, "TJ" ],  // 103.44.224.0-103.44.227.255, TJ
        [ 0x672CEC00, 0x672D3FFF, "GD" ],  // 103.44.236.0-103.45.63.255, GD
        [ 0x672D4800, 0x672D4FFF, "JS" ],  // 103.45.72.0-103.45.79.255, JS
        [ 0x672D5000, 0x672D5FFF, "GD" ],  // 103.45.80.0-103.45.95.255, GD
        [ 0x672D6000, 0x672D9FFF, "NM" ],  // 103.45.96.0-103.45.159.255, NM
        [ 0x672DA000, 0x672DA3FF, "JS" ],  // 103.45.160.0-103.45.163.255, JS
        [ 0x672DA400, 0x672DA7FF, "NM" ],  // 103.45.164.0-103.45.167.255, NM
        [ 0x672DA800, 0x672DABFF, "TJ" ],  // 103.45.168.0-103.45.171.255, TJ
        [ 0x672DAC00, 0x672DBFFF, "LN" ],  // 103.45.172.0-103.45.191.255, LN
        [ 0x672DC000, 0x672DDFFF, "GD" ],  // 103.45.192.0-103.45.223.255, GD
        [ 0x672DE000, 0x672DE3FF, "TJ" ],  // 103.45.224.0-103.45.227.255, TJ
        [ 0x672DF800, 0x672DFBFF, "LN" ],  // 103.45.248.0-103.45.251.255, LN
        [ 0x672E0000, 0x672E03FF, "GD" ],  // 103.46.0.0-103.46.3.255, GD
        [ 0x672E0C00, 0x672E8BFF, "ZJ" ],  // 103.46.12.0-103.46.139.255, ZJ
        [ 0x672E9800, 0x672EB7FF, "GD" ],  // 103.46.152.0-103.46.183.255, GD
        [ 0x672EF400, 0x672EF7FF, "HB" ],  // 103.46.244.0-103.46.247.255, HB
        [ 0x672EF800, 0x672EFBFF, "NX" ],  // 103.46.248.0-103.46.251.255, NX
        [ 0x672F0400, 0x672F07FF, "ZJ" ],  // 103.47.4.0-103.47.7.255, ZJ
        [ 0x672F1400, 0x672F17FF, "BJ" ],  // 103.47.20.0-103.47.23.255, BJ
        [ 0x672F2400, 0x672F2BFF, "BJ" ],  // 103.47.36.0-103.47.43.255, BJ
        [ 0x672F3000, 0x672F33FF, "BJ" ],  // 103.47.48.0-103.47.51.255, BJ
        [ 0x672F5000, 0x672F53FF, "YN" ],  // 103.47.80.0-103.47.83.255, YN
        [ 0x672F6000, 0x672F63FF, "BJ" ],  // 103.47.96.0-103.47.99.255, BJ
        [ 0x672F6C00, 0x672F6FFF, "SH" ],  // 103.47.108.0-103.47.111.255, SH
        [ 0x672F7400, 0x672F7AFF, "BJ" ],  // 103.47.116.0-103.47.122.255, BJ
        [ 0x672F7B00, 0x672F7BFF, "SH" ],  // 103.47.123.0-103.47.123.255, SH
        [ 0x672F8800, 0x672F8FFF, "SH" ],  // 103.47.136.0-103.47.143.255, SH
        [ 0x672FD400, 0x672FD7FF, "SD" ],  // 103.47.212.0-103.47.215.255, SD
        [ 0x67303400, 0x673037FF, "BJ" ],  // 103.48.52.0-103.48.55.255, BJ
        [ 0x67305C00, 0x67305FFF, "BJ" ],  // 103.48.92.0-103.48.95.255, BJ
        [ 0x67309400, 0x673097FF, "BJ" ],  // 103.48.148.0-103.48.151.255, BJ
        [ 0x67309800, 0x673098FF, "SH" ],  // 103.48.152.0-103.48.152.255, SH
        [ 0x67309900, 0x673099FF, "BJ" ],  // 103.48.153.0-103.48.153.255, BJ
        [ 0x67309A00, 0x67309FFF, "SH" ],  // 103.48.154.0-103.48.159.255, SH
        [ 0x6730CA00, 0x6730CBFF, "BJ" ],  // 103.48.202.0-103.48.203.255, BJ
        [ 0x6730D800, 0x6730EBFF, "BJ" ],  // 103.48.216.0-103.48.235.255, BJ
        [ 0x6730EC00, 0x6730F7FF, "SH" ],  // 103.48.236.0-103.48.247.255, SH
        [ 0x67310C00, 0x67310FFF, "GD" ],  // 103.49.12.0-103.49.15.255, GD
        [ 0x67311400, 0x673117FF, "SH" ],  // 103.49.20.0-103.49.23.255, SH
        [ 0x67314800, 0x67314FFF, "BJ" ],  // 103.49.72.0-103.49.79.255, BJ
        [ 0x67316000, 0x673163FF, "BJ" ],  // 103.49.96.0-103.49.99.255, BJ
        [ 0x67316C00, 0x67316FFF, "ZJ" ],  // 103.49.108.0-103.49.111.255, ZJ
        [ 0x6731B000, 0x6731B7FF, "BJ" ],  // 103.49.176.0-103.49.183.255, BJ
        [ 0x6731C400, 0x6731C7FF, "HA" ],  // 103.49.196.0-103.49.199.255, HA
        [ 0x67322400, 0x673227FF, "GD" ],  // 103.50.36.0-103.50.39.255, GD
        [ 0x67322C00, 0x67324BFF, "ZJ" ],  // 103.50.44.0-103.50.75.255, ZJ
        [ 0x67326C00, 0x67327FFF, "ZJ" ],  // 103.50.108.0-103.50.127.255, ZJ
        [ 0x67328400, 0x67328FFF, "ZJ" ],  // 103.50.132.0-103.50.143.255, ZJ
        [ 0x6732AC00, 0x6732CBFF, "ZJ" ],  // 103.50.172.0-103.50.203.255, ZJ
        [ 0x6732DC00, 0x6732FBFF, "ZJ" ],  // 103.50.220.0-103.50.251.255, ZJ
        [ 0x67333E00, 0x67333FFF, "SC" ],  // 103.51.62.0-103.51.63.255, SC
        [ 0x67342800, 0x67342BFF, "BJ" ],  // 103.52.40.0-103.52.43.255, BJ
        [ 0x67344800, 0x673453FF, "BJ" ],  // 103.52.72.0-103.52.83.255, BJ
        [ 0x67345400, 0x673454FF, "SH" ],  // 103.52.84.0-103.52.84.255, SH
        [ 0x67345500, 0x673455FF, "BJ" ],  // 103.52.85.0-103.52.85.255, BJ
        [ 0x67345600, 0x673456FF, "SD" ],  // 103.52.86.0-103.52.86.255, SD
        [ 0x67345700, 0x673457FF, "SH" ],  // 103.52.87.0-103.52.87.255, SH
        [ 0x67346000, 0x67346BFF, "TJ" ],  // 103.52.96.0-103.52.107.255, TJ
        [ 0x6734A000, 0x6734A3FF, "GD" ],  // 103.52.160.0-103.52.163.255, GD
        [ 0x6734A400, 0x6734A7FF, "BJ" ],  // 103.52.164.0-103.52.167.255, BJ
        [ 0x6734AC00, 0x6734AFFF, "HE" ],  // 103.52.172.0-103.52.175.255, HE
        [ 0x6734B000, 0x6734B3FF, "JS" ],  // 103.52.176.0-103.52.179.255, JS
        [ 0x6734B800, 0x6734BBFF, "CQ" ],  // 103.52.184.0-103.52.187.255, CQ
        [ 0x6734C400, 0x6734C7FF, "ZJ" ],  // 103.52.196.0-103.52.199.255, ZJ
        [ 0x67354000, 0x673547FF, "BJ" ],  // 103.53.64.0-103.53.71.255, BJ
        [ 0x67355C00, 0x67355FFF, "BJ" ],  // 103.53.92.0-103.53.95.255, BJ
        [ 0x67356400, 0x673567FF, "SH" ],  // 103.53.100.0-103.53.103.255, SH
        [ 0x67357C00, 0x67357FFF, "JS" ],  // 103.53.124.0-103.53.127.255, JS
        [ 0x67358000, 0x673587FF, "FJ" ],  // 103.53.128.0-103.53.135.255, FJ
        [ 0x67358800, 0x67358BFF, "BJ" ],  // 103.53.136.0-103.53.139.255, BJ
        [ 0x67358C00, 0x67358FFF, "FJ" ],  // 103.53.140.0-103.53.143.255, FJ
        [ 0x67359000, 0x673593FF, "SD" ],  // 103.53.144.0-103.53.147.255, SD
        [ 0x6735B400, 0x6735B7FF, "JS" ],  // 103.53.180.0-103.53.183.255, JS
        [ 0x6735CC00, 0x6735CFFF, "GD" ],  // 103.53.204.0-103.53.207.255, GD
        [ 0x6735D000, 0x6735D3FF, "BJ" ],  // 103.53.208.0-103.53.211.255, BJ
        [ 0x6735D400, 0x6735D7FF, "GD" ],  // 103.53.212.0-103.53.215.255, GD
        [ 0x6735EC00, 0x6735EFFF, "BJ" ],  // 103.53.236.0-103.53.239.255, BJ
        [ 0x6735F800, 0x6735FBFF, "GD" ],  // 103.53.248.0-103.53.251.255, GD
        [ 0x67360800, 0x67360BFF, "BJ" ],  // 103.54.8.0-103.54.11.255, BJ
        [ 0x67363000, 0x673633FF, "BJ" ],  // 103.54.48.0-103.54.51.255, BJ
        [ 0x6736A000, 0x6736A7FF, "BJ" ],  // 103.54.160.0-103.54.167.255, BJ
        [ 0x6736D400, 0x6736D7FF, "BJ" ],  // 103.54.212.0-103.54.215.255, BJ
        [ 0x6736F000, 0x6736F3FF, "SH" ],  // 103.54.240.0-103.54.243.255, SH
        [ 0x67375000, 0x673753FF, "BJ" ],  // 103.55.80.0-103.55.83.255, BJ
        [ 0x67377800, 0x67377BFF, "BJ" ],  // 103.55.120.0-103.55.123.255, BJ
        [ 0x67379800, 0x67379BFF, "BJ" ],  // 103.55.152.0-103.55.155.255, BJ
        [ 0x6737AC00, 0x6737AFFF, "SH" ],  // 103.55.172.0-103.55.175.255, SH
        [ 0x6737CC00, 0x6737D3FF, "BJ" ],  // 103.55.204.0-103.55.211.255, BJ
        [ 0x6737E400, 0x6737E7FF, "TJ" ],  // 103.55.228.0-103.55.231.255, TJ
        [ 0x6737EC00, 0x6737EFFF, "BJ" ],  // 103.55.236.0-103.55.239.255, BJ
        [ 0x67380800, 0x67380BFF, "SH" ],  // 103.56.8.0-103.56.11.255, SH
        [ 0x67381000, 0x673813FF, "JS" ],  // 103.56.16.0-103.56.19.255, JS
        [ 0x67381400, 0x673817FF, "YN" ],  // 103.56.20.0-103.56.23.255, YN
        [ 0x67382000, 0x673823FF, "TJ" ],  // 103.56.32.0-103.56.35.255, TJ
        [ 0x67383800, 0x67383FFF, "JS" ],  // 103.56.56.0-103.56.63.255, JS
        [ 0x67384800, 0x67384BFF, "HN" ],  // 103.56.72.0-103.56.75.255, HN
        [ 0x67384C00, 0x67384FFF, "GD" ],  // 103.56.76.0-103.56.79.255, GD
        [ 0x67385E00, 0x67385FFF, "BJ" ],  // 103.56.94.0-103.56.95.255, BJ
        [ 0x67386400, 0x67386BFF, "ZJ" ],  // 103.56.100.0-103.56.107.255, ZJ
        [ 0x67388C00, 0x67388FFF, "GD" ],  // 103.56.140.0-103.56.143.255, GD
        [ 0x67389800, 0x67389BFF, "JS" ],  // 103.56.152.0-103.56.155.255, JS
        [ 0x6738B800, 0x6738BBFF, "GD" ],  // 103.56.184.0-103.56.187.255, GD
        [ 0x6738C800, 0x6738CBFF, "LN" ],  // 103.56.200.0-103.56.203.255, LN
        [ 0x67390C00, 0x67390FFF, "JL" ],  // 103.57.12.0-103.57.15.255, JL
        [ 0x67393400, 0x673937FF, "TJ" ],  // 103.57.52.0-103.57.55.255, TJ
        [ 0x67393800, 0x67393BFF, "BJ" ],  // 103.57.56.0-103.57.59.255, BJ
        [ 0x67394C00, 0x67394FFF, "LN" ],  // 103.57.76.0-103.57.79.255, LN
        [ 0x67398800, 0x67398BFF, "LN" ],  // 103.57.136.0-103.57.139.255, LN
        [ 0x6739C400, 0x6739C7FF, "NM" ],  // 103.57.196.0-103.57.199.255, NM
        [ 0x673A1800, 0x673A1BFF, "JX" ],  // 103.58.24.0-103.58.27.255, JX
        [ 0x673B4C00, 0x673B4FFF, "SH" ],  // 103.59.76.0-103.59.79.255, SH
        [ 0x673B7000, 0x673B73FF, "FJ" ],  // 103.59.112.0-103.59.115.255, FJ
        [ 0x673B7400, 0x673B77FF, "JS" ],  // 103.59.116.0-103.59.119.255, JS
        [ 0x673B7800, 0x673B78FF, "SH" ],  // 103.59.120.0-103.59.120.255, SH
        [ 0x673B7A00, 0x673B7BFF, "SH" ],  // 103.59.122.0-103.59.123.255, SH
        [ 0x673B7C00, 0x673B7FFF, "HE" ],  // 103.59.124.0-103.59.127.255, HE
        [ 0x673B8000, 0x673B83FF, "BJ" ],  // 103.59.128.0-103.59.131.255, BJ
        [ 0x673B9400, 0x673B97FF, "BJ" ],  // 103.59.148.0-103.59.151.255, BJ
        [ 0x673BA400, 0x673BA7FF, "NM" ],  // 103.59.164.0-103.59.167.255, NM
        [ 0x673BA800, 0x673BA9FF, "SH" ],  // 103.59.168.0-103.59.169.255, SH
        [ 0x673C2000, 0x673C23FF, "SH" ],  // 103.60.32.0-103.60.35.255, SH
        [ 0x673C2C00, 0x673C2FFF, "BJ" ],  // 103.60.44.0-103.60.47.255, BJ
        [ 0x673CA400, 0x673CA7FF, "JS" ],  // 103.60.164.0-103.60.167.255, JS
        [ 0x673CE400, 0x673CE7FF, "SH" ],  // 103.60.228.0-103.60.231.255, SH
        [ 0x673CEC00, 0x673CEFFF, "BJ" ],  // 103.60.236.0-103.60.239.255, BJ
        [ 0x673D3C00, 0x673D3FFF, "BJ" ],  // 103.61.60.0-103.61.63.255, BJ
        [ 0x673D6800, 0x673D69FF, "SH" ],  // 103.61.104.0-103.61.105.255, SH
        [ 0x673D6A00, 0x673D6BFF, "BJ" ],  // 103.61.106.0-103.61.107.255, BJ
        [ 0x673D8C00, 0x673D8FFF, "BJ" ],  // 103.61.140.0-103.61.143.255, BJ
        [ 0x673D9800, 0x673D9FFF, "BJ" ],  // 103.61.152.0-103.61.159.255, BJ
        [ 0x673DA000, 0x673DA3FF, "SN" ],  // 103.61.160.0-103.61.163.255, SN
        [ 0x673DAC00, 0x673DAFFF, "HA" ],  // 103.61.172.0-103.61.175.255, HA
        [ 0x673DB000, 0x673DB3FF, "JX" ],  // 103.61.176.0-103.61.179.255, JX
        [ 0x673DBC00, 0x673DBFFF, "GD" ],  // 103.61.188.0-103.61.191.255, GD
        [ 0x673E1800, 0x673E1BFF, "HE" ],  // 103.62.24.0-103.62.27.255, HE
        [ 0x673E3400, 0x673E34FF, "GD" ],  // 103.62.52.0-103.62.52.255, GD
        [ 0x673E3700, 0x673E37FF, "GD" ],  // 103.62.55.0-103.62.55.255, GD
        [ 0x673E4800, 0x673E57FF, "SN" ],  // 103.62.72.0-103.62.87.255, SN
        [ 0x673E5800, 0x673E5BFF, "SC" ],  // 103.62.88.0-103.62.91.255, SC
        [ 0x673E6000, 0x673E87FF, "LN" ],  // 103.62.96.0-103.62.135.255, LN
        [ 0x673E9C00, 0x673E9FFF, "BJ" ],  // 103.62.156.0-103.62.159.255, BJ
        [ 0x673EA000, 0x673EA3FF, "JS" ],  // 103.62.160.0-103.62.163.255, JS
        [ 0x673EA400, 0x673EA7FF, "HB" ],  // 103.62.164.0-103.62.167.255, HB
        [ 0x673EA800, 0x673EABFF, "SH" ],  // 103.62.168.0-103.62.171.255, SH
        [ 0x673EAC00, 0x673EAFFF, "SD" ],  // 103.62.172.0-103.62.175.255, SD
        [ 0x673EB000, 0x673EB3FF, "ZJ" ],  // 103.62.176.0-103.62.179.255, ZJ
        [ 0x673EB400, 0x673EB7FF, "CQ" ],  // 103.62.180.0-103.62.183.255, CQ
        [ 0x673EB800, 0x673EBBFF, "JS" ],  // 103.62.184.0-103.62.187.255, JS
        [ 0x673EBC00, 0x673EBFFF, "GD" ],  // 103.62.188.0-103.62.191.255, GD
        [ 0x673EC000, 0x673EC3FF, "HE" ],  // 103.62.192.0-103.62.195.255, HE
        [ 0x673ECC00, 0x673ECFFF, "ZJ" ],  // 103.62.204.0-103.62.207.255, ZJ
        [ 0x673ED000, 0x673ED3FF, "CQ" ],  // 103.62.208.0-103.62.211.255, CQ
        [ 0x673ED400, 0x673ED7FF, "JS" ],  // 103.62.212.0-103.62.215.255, JS
        [ 0x673ED800, 0x673EDBFF, "HE" ],  // 103.62.216.0-103.62.219.255, HE
        [ 0x673EDC00, 0x673EDFFF, "JS" ],  // 103.62.220.0-103.62.223.255, JS
        [ 0x673EE000, 0x673EE3FF, "GD" ],  // 103.62.224.0-103.62.227.255, GD
        [ 0x673F2000, 0x673F23FF, "JS" ],  // 103.63.32.0-103.63.35.255, JS
        [ 0x673F2400, 0x673F27FF, "ZJ" ],  // 103.63.36.0-103.63.39.255, ZJ
        [ 0x673F2800, 0x673F2BFF, "SD" ],  // 103.63.40.0-103.63.43.255, SD
        [ 0x673F2C00, 0x673F2FFF, "LN" ],  // 103.63.44.0-103.63.47.255, LN
        [ 0x673F3000, 0x673F33FF, "HE" ],  // 103.63.48.0-103.63.51.255, HE
        [ 0x673F3400, 0x673F37FF, "AH" ],  // 103.63.52.0-103.63.55.255, AH
        [ 0x673F3800, 0x673F3BFF, "HN" ],  // 103.63.56.0-103.63.59.255, HN
        [ 0x673F3C00, 0x673F43FF, "GD" ],  // 103.63.60.0-103.63.67.255, GD
        [ 0x673F4400, 0x673F47FF, "LN" ],  // 103.63.68.0-103.63.71.255, LN
        [ 0x673F4800, 0x673F4BFF, "AH" ],  // 103.63.72.0-103.63.75.255, AH
        [ 0x673F4C00, 0x673F4FFF, "LN" ],  // 103.63.76.0-103.63.79.255, LN
        [ 0x673F5000, 0x673F53FF, "GD" ],  // 103.63.80.0-103.63.83.255, GD
        [ 0x673F5400, 0x673F57FF, "GZ" ],  // 103.63.84.0-103.63.87.255, GZ
        [ 0x673F5800, 0x673F5BFF, "JS" ],  // 103.63.88.0-103.63.91.255, JS
        [ 0x673F8C00, 0x673F93FF, "HE" ],  // 103.63.140.0-103.63.147.255, HE
        [ 0x673F9800, 0x673F9BFF, "LN" ],  // 103.63.152.0-103.63.155.255, LN
        [ 0x673FA000, 0x673FA7FF, "SX" ],  // 103.63.160.0-103.63.167.255, SX
        [ 0x673FA800, 0x673FABFF, "HL" ],  // 103.63.168.0-103.63.171.255, HL
        [ 0x673FAC00, 0x673FAFFF, "LN" ],  // 103.63.172.0-103.63.175.255, LN
        [ 0x673FB000, 0x673FB3FF, "GX" ],  // 103.63.176.0-103.63.179.255, GX
        [ 0x673FB400, 0x673FB7FF, "HL" ],  // 103.63.180.0-103.63.183.255, HL
        [ 0x673FB800, 0x673FBBFF, "GZ" ],  // 103.63.184.0-103.63.187.255, GZ
        [ 0x673FC000, 0x673FC3FF, "SD" ],  // 103.63.192.0-103.63.195.255, SD
        [ 0x673FC400, 0x673FC7FF, "SN" ],  // 103.63.196.0-103.63.199.255, SN
        [ 0x673FC800, 0x673FCBFF, "LN" ],  // 103.63.200.0-103.63.203.255, LN
        [ 0x673FCC00, 0x673FCFFF, "FJ" ],  // 103.63.204.0-103.63.207.255, FJ
        [ 0x673FD000, 0x673FD3FF, "HB" ],  // 103.63.208.0-103.63.211.255, HB
        [ 0x673FF000, 0x673FF3FF, "BJ" ],  // 103.63.240.0-103.63.243.255, BJ
        [ 0x673FF400, 0x673FF7FF, "JL" ],  // 103.63.244.0-103.63.247.255, JL
        [ 0x673FF800, 0x673FFBFF, "GD" ],  // 103.63.248.0-103.63.251.255, GD
        [ 0x673FFC00, 0x674007FF, "BJ" ],  // 103.63.252.0-103.64.7.255, BJ
        [ 0x67401800, 0x67401FFF, "SD" ],  // 103.64.24.0-103.64.31.255, SD
        [ 0x67402000, 0x67407FFF, "GD" ],  // 103.64.32.0-103.64.127.255, GD
        [ 0x67408C00, 0x674093FF, "SD" ],  // 103.64.140.0-103.64.147.255, SD
        [ 0x67409800, 0x67409BFF, "SD" ],  // 103.64.152.0-103.64.155.255, SD
        [ 0x67409C00, 0x67409FFF, "FJ" ],  // 103.64.156.0-103.64.159.255, FJ
        [ 0x6740A000, 0x6740D3FF, "SD" ],  // 103.64.160.0-103.64.211.255, SD
        [ 0x6740D400, 0x674107FF, "FJ" ],  // 103.64.212.0-103.65.7.255, FJ
        [ 0x67410800, 0x67410BFF, "SH" ],  // 103.65.8.0-103.65.11.255, SH
        [ 0x67410C00, 0x674113FF, "FJ" ],  // 103.65.12.0-103.65.19.255, FJ
        [ 0x67413000, 0x674133FF, "CQ" ],  // 103.65.48.0-103.65.51.255, CQ
        [ 0x67413400, 0x674137FF, "GD" ],  // 103.65.52.0-103.65.55.255, GD
        [ 0x67413800, 0x67413BFF, "HA" ],  // 103.65.56.0-103.65.59.255, HA
        [ 0x67413C00, 0x67414BFF, "GD" ],  // 103.65.60.0-103.65.75.255, GD
        [ 0x67414C00, 0x67415FFF, "CQ" ],  // 103.65.76.0-103.65.95.255, CQ
        [ 0x67416400, 0x674173FF, "SD" ],  // 103.65.100.0-103.65.115.255, SD
        [ 0x67419000, 0x6741AFFF, "GD" ],  // 103.65.144.0-103.65.175.255, GD
        [ 0x6741CC00, 0x6741CDFF, "GX" ],  // 103.65.204.0-103.65.205.255, GX
        [ 0x6741CE00, 0x6741CFFF, "BJ" ],  // 103.65.206.0-103.65.207.255, BJ
        [ 0x6741E000, 0x6741E1FF, "HB" ],  // 103.65.224.0-103.65.225.255, HB
        [ 0x67422000, 0x674223FF, "BJ" ],  // 103.66.32.0-103.66.35.255, BJ
        [ 0x67422800, 0x67422BFF, "FJ" ],  // 103.66.40.0-103.66.43.255, FJ
        [ 0x67425C00, 0x67425FFF, "TJ" ],  // 103.66.92.0-103.66.95.255, TJ
        [ 0x67426C00, 0x67426FFF, "LN" ],  // 103.66.108.0-103.66.111.255, LN
        [ 0x6742C800, 0x6742CBFF, "SH" ],  // 103.66.200.0-103.66.203.255, SH
        [ 0x6742F000, 0x67430BFF, "NM" ],  // 103.66.240.0-103.67.11.255, NM
        [ 0x67433400, 0x674335FF, "SH" ],  // 103.67.52.0-103.67.53.255, SH
        [ 0x67436400, 0x674367FF, "SH" ],  // 103.67.100.0-103.67.103.255, SH
        [ 0x67436800, 0x67436BFF, "JS" ],  // 103.67.104.0-103.67.107.255, JS
        [ 0x67436C00, 0x674377FF, "ZJ" ],  // 103.67.108.0-103.67.119.255, ZJ
        [ 0x67437800, 0x67437FFF, "SH" ],  // 103.67.120.0-103.67.127.255, SH
        [ 0x67438000, 0x674387FF, "JS" ],  // 103.67.128.0-103.67.135.255, JS
        [ 0x67438800, 0x674397FF, "SH" ],  // 103.67.136.0-103.67.151.255, SH
        [ 0x6743AC00, 0x6743ADFF, "HB" ],  // 103.67.172.0-103.67.173.255, HB
        [ 0x6743C000, 0x6743C3FF, "BJ" ],  // 103.67.192.0-103.67.195.255, BJ
        [ 0x6743D400, 0x6743D7FF, "GD" ],  // 103.67.212.0-103.67.215.255, GD
        [ 0x67445800, 0x67445BFF, "BJ" ],  // 103.68.88.0-103.68.91.255, BJ
        [ 0x67446400, 0x674467FF, "SN" ],  // 103.68.100.0-103.68.103.255, SN
        [ 0x67448000, 0x674483FF, "SH" ],  // 103.68.128.0-103.68.131.255, SH
        [ 0x67451000, 0x674513FF, "JS" ],  // 103.69.16.0-103.69.19.255, JS
        [ 0x67453E00, 0x67453FFF, "CQ" ],  // 103.69.62.0-103.69.63.255, CQ
        [ 0x67457400, 0x674577FF, "SH" ],  // 103.69.116.0-103.69.119.255, SH
        [ 0x67460800, 0x67460BFF, "BJ" ],  // 103.70.8.0-103.70.11.255, BJ
        [ 0x67469400, 0x674697FF, "BJ" ],  // 103.70.148.0-103.70.151.255, BJ
        [ 0x6746DC00, 0x6746DFFF, "GD" ],  // 103.70.220.0-103.70.223.255, GD
        [ 0x6746E000, 0x6746E3FF, "CQ" ],  // 103.70.224.0-103.70.227.255, CQ
        [ 0x6746EC00, 0x6746EFFF, "LN" ],  // 103.70.236.0-103.70.239.255, LN
        [ 0x6746FC00, 0x6746FFFF, "BJ" ],  // 103.70.252.0-103.70.255.255, BJ
        [ 0x67470000, 0x674703FF, "HE" ],  // 103.71.0.0-103.71.3.255, HE
        [ 0x67473000, 0x674731FF, "GD" ],  // 103.71.48.0-103.71.49.255, GD
        [ 0x67473300, 0x674733FF, "GD" ],  // 103.71.51.0-103.71.51.255, GD
        [ 0x67474400, 0x674744FF, "AH" ],  // 103.71.68.0-103.71.68.255, AH
        [ 0x67474500, 0x674747FF, "JS" ],  // 103.71.69.0-103.71.71.255, JS
        [ 0x67474800, 0x67474BFF, "BJ" ],  // 103.71.72.0-103.71.75.255, BJ
        [ 0x67475000, 0x674753FF, "SH" ],  // 103.71.80.0-103.71.83.255, SH
        [ 0x67475400, 0x674757FF, "XJ" ],  // 103.71.84.0-103.71.87.255, XJ
        [ 0x67475800, 0x67475BFF, "ZJ" ],  // 103.71.88.0-103.71.91.255, ZJ
        [ 0x67477800, 0x67477BFF, "BJ" ],  // 103.71.120.0-103.71.123.255, BJ
        [ 0x67477C00, 0x67477FFF, "ZJ" ],  // 103.71.124.0-103.71.127.255, ZJ
        [ 0x67478000, 0x674783FF, "BJ" ],  // 103.71.128.0-103.71.131.255, BJ
        [ 0x67479000, 0x674791FF, "HN" ],  // 103.71.144.0-103.71.145.255, HN
        [ 0x67479200, 0x674793FF, "JS" ],  // 103.71.146.0-103.71.147.255, JS
        [ 0x6747C400, 0x6747CAFF, "BJ" ],  // 103.71.196.0-103.71.202.255, BJ
        [ 0x6747CB00, 0x6747CBFF, "ZJ" ],  // 103.71.203.0-103.71.203.255, ZJ
        [ 0x6747E800, 0x6747EBFF, "BJ" ],  // 103.71.232.0-103.71.235.255, BJ
        [ 0x67480C00, 0x67480FFF, "BJ" ],  // 103.72.12.0-103.72.15.255, BJ
        [ 0x67481000, 0x674827FF, "ZJ" ],  // 103.72.16.0-103.72.39.255, ZJ
        [ 0x67482800, 0x674837FF, "BJ" ],  // 103.72.40.0-103.72.55.255, BJ
        [ 0x67487000, 0x674873FF, "SH" ],  // 103.72.112.0-103.72.115.255, SH
        [ 0x67487400, 0x674877FF, "BJ" ],  // 103.72.116.0-103.72.119.255, BJ
        [ 0x67487B00, 0x67487BFF, "ZJ" ],  // 103.72.123.0-103.72.123.255, ZJ
        [ 0x67487C00, 0x67487FFF, "HB" ],  // 103.72.124.0-103.72.127.255, HB
        [ 0x67488000, 0x674887FF, "BJ" ],  // 103.72.128.0-103.72.135.255, BJ
        [ 0x6748AC00, 0x6748AFFF, "BJ" ],  // 103.72.172.0-103.72.175.255, BJ
        [ 0x6748B400, 0x6748B7FF, "AH" ],  // 103.72.180.0-103.72.183.255, AH
        [ 0x6748E000, 0x67491FFF, "GD" ],  // 103.72.224.0-103.73.31.255, GD
        [ 0x67493000, 0x674933FF, "GD" ],  // 103.73.48.0-103.73.51.255, GD
        [ 0x67497400, 0x674977FF, "JS" ],  // 103.73.116.0-103.73.119.255, JS
        [ 0x67497800, 0x67497BFF, "GD" ],  // 103.73.120.0-103.73.123.255, GD
        [ 0x67498000, 0x674983FF, "GD" ],  // 103.73.128.0-103.73.131.255, GD
        [ 0x67498400, 0x674987FF, "LN" ],  // 103.73.132.0-103.73.135.255, LN
        [ 0x67498800, 0x67498FFF, "FJ" ],  // 103.73.136.0-103.73.143.255, FJ
        [ 0x67499000, 0x674993FF, "JS" ],  // 103.73.144.0-103.73.147.255, JS
        [ 0x6749A800, 0x6749ABFF, "HN" ],  // 103.73.168.0-103.73.171.255, HN
        [ 0x6749B000, 0x6749B3FF, "JL" ],  // 103.73.176.0-103.73.179.255, JL
        [ 0x6749CC00, 0x6749CFFF, "GD" ],  // 103.73.204.0-103.73.207.255, GD
        [ 0x6749D000, 0x6749D3FF, "BJ" ],  // 103.73.208.0-103.73.211.255, BJ
        [ 0x6749F000, 0x6749F1FF, "SH" ],  // 103.73.240.0-103.73.241.255, SH
        [ 0x6749F400, 0x6749FBFF, "GD" ],  // 103.73.244.0-103.73.251.255, GD
        [ 0x674A1800, 0x674A23FF, "ZJ" ],  // 103.74.24.0-103.74.35.255, ZJ
        [ 0x674A2400, 0x674A2FFF, "BJ" ],  // 103.74.36.0-103.74.47.255, BJ
        [ 0x674A3000, 0x674A33FF, "ZJ" ],  // 103.74.48.0-103.74.51.255, ZJ
        [ 0x674A3800, 0x674A3FFF, "BJ" ],  // 103.74.56.0-103.74.63.255, BJ
        [ 0x674A5000, 0x674A53FF, "BJ" ],  // 103.74.80.0-103.74.83.255, BJ
        [ 0x674A7C00, 0x674A7FFF, "SH" ],  // 103.74.124.0-103.74.127.255, SH
        [ 0x674A9400, 0x674A97FF, "BJ" ],  // 103.74.148.0-103.74.151.255, BJ
        [ 0x674A9800, 0x674A9FFF, "SH" ],  // 103.74.152.0-103.74.159.255, SH
        [ 0x674ACC00, 0x674ACFFF, "LN" ],  // 103.74.204.0-103.74.207.255, LN
        [ 0x674AE800, 0x674AEBFF, "BJ" ],  // 103.74.232.0-103.74.235.255, BJ
        [ 0x674B5800, 0x674B5FFF, "BJ" ],  // 103.75.88.0-103.75.95.255, BJ
        [ 0x674B6800, 0x674B6BFF, "BJ" ],  // 103.75.104.0-103.75.107.255, BJ
        [ 0x674B6C00, 0x674B6FFF, "GD" ],  // 103.75.108.0-103.75.111.255, GD
        [ 0x674B7000, 0x674B73FF, "BJ" ],  // 103.75.112.0-103.75.115.255, BJ
        [ 0x674B7800, 0x674B7BFF, "BJ" ],  // 103.75.120.0-103.75.123.255, BJ
        [ 0x674B8000, 0x674B83FF, "BJ" ],  // 103.75.128.0-103.75.131.255, BJ
        [ 0x674B9000, 0x674B93FF, "GD" ],  // 103.75.144.0-103.75.147.255, GD
        [ 0x674B9800, 0x674B9BFF, "BJ" ],  // 103.75.152.0-103.75.155.255, BJ
        [ 0x674C3C00, 0x674C3FFF, "BJ" ],  // 103.76.60.0-103.76.63.255, BJ
        [ 0x674C4000, 0x674C43FF, "ZJ" ],  // 103.76.64.0-103.76.67.255, ZJ
        [ 0x674C4400, 0x674C47FF, "LN" ],  // 103.76.68.0-103.76.71.255, LN
        [ 0x674C4800, 0x674C4BFF, "GZ" ],  // 103.76.72.0-103.76.75.255, GZ
        [ 0x674C5C00, 0x674C5FFF, "SH" ],  // 103.76.92.0-103.76.95.255, SH
        [ 0x674CD800, 0x674CE3FF, "BJ" ],  // 103.76.216.0-103.76.227.255, BJ
        [ 0x674D1C00, 0x674D1FFF, "BJ" ],  // 103.77.28.0-103.77.31.255, BJ
        [ 0x674D3400, 0x674D37FF, "SH" ],  // 103.77.52.0-103.77.55.255, SH
        [ 0x674D3800, 0x674D3BFF, "HE" ],  // 103.77.56.0-103.77.59.255, HE
        [ 0x674D4800, 0x674D4BFF, "GD" ],  // 103.77.72.0-103.77.75.255, GD
        [ 0x674D5800, 0x674D5BFF, "GD" ],  // 103.77.88.0-103.77.91.255, GD
        [ 0x674D5C00, 0x674D5FFF, "BJ" ],  // 103.77.92.0-103.77.95.255, BJ
        [ 0x674D8400, 0x674D87FF, "BJ" ],  // 103.77.132.0-103.77.135.255, BJ
        [ 0x674D9400, 0x674D97FF, "GD" ],  // 103.77.148.0-103.77.151.255, GD
        [ 0x674DDC00, 0x674DDFFF, "BJ" ],  // 103.77.220.0-103.77.223.255, BJ
        [ 0x674E3800, 0x674E3FFF, "BJ" ],  // 103.78.56.0-103.78.63.255, BJ
        [ 0x674E4000, 0x674E43FF, "JS" ],  // 103.78.64.0-103.78.67.255, JS
        [ 0x674E4400, 0x674E47FF, "ZJ" ],  // 103.78.68.0-103.78.71.255, ZJ
        [ 0x674E7C00, 0x674E7DFF, "BJ" ],  // 103.78.124.0-103.78.125.255, BJ
        [ 0x674E7E00, 0x674E7EFF, "SC" ],  // 103.78.126.0-103.78.126.255, SC
        [ 0x674E7F00, 0x674E7FFF, "HN" ],  // 103.78.127.0-103.78.127.255, HN
        [ 0x674EAC00, 0x674EB3FF, "GD" ],  // 103.78.172.0-103.78.179.255, GD
        [ 0x674EC400, 0x674EC7FF, "BJ" ],  // 103.78.196.0-103.78.199.255, BJ
        [ 0x674EE400, 0x674EE7FF, "JS" ],  // 103.78.228.0-103.78.231.255, JS
        [ 0x674F1800, 0x674F1BFF, "BJ" ],  // 103.79.24.0-103.79.27.255, BJ
        [ 0x674F1C00, 0x674F1FFF, "SD" ],  // 103.79.28.0-103.79.31.255, SD
        [ 0x674F2400, 0x674F2FFF, "BJ" ],  // 103.79.36.0-103.79.47.255, BJ
        [ 0x674F3800, 0x674F47FF, "SX" ],  // 103.79.56.0-103.79.71.255, SX
        [ 0x674F5000, 0x674F53FF, "BJ" ],  // 103.79.80.0-103.79.83.255, BJ
        [ 0x674F5400, 0x674F57FF, "HB" ],  // 103.79.84.0-103.79.87.255, HB
        [ 0x674F8800, 0x674F8BFF, "GD" ],  // 103.79.136.0-103.79.139.255, GD
        [ 0x674FBC00, 0x674FBFFF, "GD" ],  // 103.79.188.0-103.79.191.255, GD
        [ 0x674FC000, 0x674FCFFF, "BJ" ],  // 103.79.192.0-103.79.207.255, BJ
        [ 0x674FD000, 0x674FD3FF, "HE" ],  // 103.79.208.0-103.79.211.255, HE
        [ 0x674FD400, 0x674FD7FF, "BJ" ],  // 103.79.212.0-103.79.215.255, BJ
        [ 0x674FE400, 0x674FE4FF, "BJ" ],  // 103.79.228.0-103.79.228.255, BJ
        [ 0x674FE500, 0x674FE5FF, "SH" ],  // 103.79.229.0-103.79.229.255, SH
        [ 0x67501C00, 0x67501CFF, "BJ" ],  // 103.80.28.0-103.80.28.255, BJ
        [ 0x67502C00, 0x67502FFF, "SH" ],  // 103.80.44.0-103.80.47.255, SH
        [ 0x67504800, 0x67504BFF, "JS" ],  // 103.80.72.0-103.80.75.255, JS
        [ 0x6750B000, 0x6750B3FF, "SN" ],  // 103.80.176.0-103.80.179.255, SN
        [ 0x6750B400, 0x6750B7FF, "GX" ],  // 103.80.180.0-103.80.183.255, GX
        [ 0x6750B800, 0x6750BBFF, "BJ" ],  // 103.80.184.0-103.80.187.255, BJ
        [ 0x6750C000, 0x6750C3FF, "ZJ" ],  // 103.80.192.0-103.80.195.255, ZJ
        [ 0x6750C800, 0x6750CBFF, "ZJ" ],  // 103.80.200.0-103.80.203.255, ZJ
        [ 0x6750E800, 0x6750EBFF, "GD" ],  // 103.80.232.0-103.80.235.255, GD
        [ 0x67510400, 0x675107FF, "GZ" ],  // 103.81.4.0-103.81.7.255, GZ
        [ 0x67510800, 0x67510BFF, "FJ" ],  // 103.81.8.0-103.81.11.255, FJ
        [ 0x67511000, 0x675117FF, "FJ" ],  // 103.81.16.0-103.81.23.255, FJ
        [ 0x67512C00, 0x67512FFF, "SH" ],  // 103.81.44.0-103.81.47.255, SH
        [ 0x67513000, 0x675133FF, "SD" ],  // 103.81.48.0-103.81.51.255, SD
        [ 0x67516000, 0x675163FF, "BJ" ],  // 103.81.96.0-103.81.99.255, BJ
        [ 0x67517800, 0x67517BFF, "JS" ],  // 103.81.120.0-103.81.123.255, JS
        [ 0x67519400, 0x675194FF, "SH" ],  // 103.81.148.0-103.81.148.255, SH
        [ 0x67519500, 0x675195FF, "TJ" ],  // 103.81.149.0-103.81.149.255, TJ
        [ 0x67519600, 0x675197FF, "SH" ],  // 103.81.150.0-103.81.151.255, SH
        [ 0x6751A400, 0x6751A7FF, "SH" ],  // 103.81.164.0-103.81.167.255, SH
        [ 0x6751C800, 0x6751CBFF, "BJ" ],  // 103.81.200.0-103.81.203.255, BJ
        [ 0x6751E800, 0x6751EBFF, "BJ" ],  // 103.81.232.0-103.81.235.255, BJ
        [ 0x67523400, 0x675237FF, "BJ" ],  // 103.82.52.0-103.82.55.255, BJ
        [ 0x67523C00, 0x67523FFF, "GD" ],  // 103.82.60.0-103.82.63.255, GD
        [ 0x67524400, 0x675247FF, "BJ" ],  // 103.82.68.0-103.82.71.255, BJ
        [ 0x67525400, 0x675257FF, "BJ" ],  // 103.82.84.0-103.82.87.255, BJ
        [ 0x67526800, 0x67526BFF, "XJ" ],  // 103.82.104.0-103.82.107.255, XJ
        [ 0x6752E000, 0x6752E3FF, "BJ" ],  // 103.82.224.0-103.82.227.255, BJ
        [ 0x6752EC00, 0x6752EFFF, "BJ" ],  // 103.82.236.0-103.82.239.255, BJ
        [ 0x67532C00, 0x67532FFF, "BJ" ],  // 103.83.44.0-103.83.47.255, BJ
        [ 0x67533400, 0x675337FF, "BJ" ],  // 103.83.52.0-103.83.55.255, BJ
        [ 0x67533C00, 0x67533FFF, "HE" ],  // 103.83.60.0-103.83.63.255, HE
        [ 0x67534000, 0x675343FF, "ZJ" ],  // 103.83.64.0-103.83.67.255, ZJ
        [ 0x67534800, 0x67534BFF, "JS" ],  // 103.83.72.0-103.83.75.255, JS
        [ 0x67537000, 0x675373FF, "ZJ" ],  // 103.83.112.0-103.83.115.255, ZJ
        [ 0x67537800, 0x675379FF, "BJ" ],  // 103.83.120.0-103.83.121.255, BJ
        [ 0x6753B400, 0x6753B7FF, "BJ" ],  // 103.83.180.0-103.83.183.255, BJ
        [ 0x67540000, 0x675403FF, "BJ" ],  // 103.84.0.0-103.84.3.255, BJ
        [ 0x67540C00, 0x675413FF, "GD" ],  // 103.84.12.0-103.84.19.255, GD
        [ 0x67541400, 0x67541BFF, "SH" ],  // 103.84.20.0-103.84.27.255, SH
        [ 0x67541C00, 0x67541FFF, "GD" ],  // 103.84.28.0-103.84.31.255, GD
        [ 0x67543000, 0x675433FF, "BJ" ],  // 103.84.48.0-103.84.51.255, BJ
        [ 0x67544000, 0x675443FF, "ZJ" ],  // 103.84.64.0-103.84.67.255, ZJ
        [ 0x67544800, 0x67544BFF, "ZJ" ],  // 103.84.72.0-103.84.75.255, ZJ
        [ 0x6754AA00, 0x6754ABFF, "SH" ],  // 103.84.170.0-103.84.171.255, SH
        [ 0x6754CC00, 0x6754CCFF, "GD" ],  // 103.84.204.0-103.84.204.255, GD
        [ 0x67552C00, 0x67552FFF, "SC" ],  // 103.85.44.0-103.85.47.255, SC
        [ 0x67553000, 0x675533FF, "BJ" ],  // 103.85.48.0-103.85.51.255, BJ
        [ 0x67555400, 0x675557FF, "JS" ],  // 103.85.84.0-103.85.87.255, JS
        [ 0x67558800, 0x67558BFF, "ZJ" ],  // 103.85.136.0-103.85.139.255, ZJ
        [ 0x67559000, 0x675593FF, "GZ" ],  // 103.85.144.0-103.85.147.255, GZ
        [ 0x6755A400, 0x6755B3FF, "BJ" ],  // 103.85.164.0-103.85.179.255, BJ
        [ 0x6755E000, 0x6755E3FF, "BJ" ],  // 103.85.224.0-103.85.227.255, BJ
        [ 0x67561C00, 0x67561FFF, "BJ" ],  // 103.86.28.0-103.86.31.255, BJ
        [ 0x67562000, 0x675623FF, "HN" ],  // 103.86.32.0-103.86.35.255, HN
        [ 0x67563C00, 0x67563FFF, "JS" ],  // 103.86.60.0-103.86.63.255, JS
        [ 0x67565000, 0x675653FF, "JS" ],  // 103.86.80.0-103.86.83.255, JS
        [ 0x6756CC00, 0x6756E7FF, "BJ" ],  // 103.86.204.0-103.86.231.255, BJ
        [ 0x6756E800, 0x6756EEFF, "TJ" ],  // 103.86.232.0-103.86.238.255, TJ
        [ 0x6756EF00, 0x6756EFFF, "BJ" ],  // 103.86.239.0-103.86.239.255, BJ
        [ 0x6756F000, 0x6756F0FF, "TJ" ],  // 103.86.240.0-103.86.240.255, TJ
        [ 0x6756F100, 0x6756F1FF, "BJ" ],  // 103.86.241.0-103.86.241.255, BJ
        [ 0x6756F200, 0x6756F6FF, "TJ" ],  // 103.86.242.0-103.86.246.255, TJ
        [ 0x6756F700, 0x6756F7FF, "BJ" ],  // 103.86.247.0-103.86.247.255, BJ
        [ 0x6756F800, 0x6756F8FF, "TJ" ],  // 103.86.248.0-103.86.248.255, TJ
        [ 0x6756F900, 0x675707FF, "BJ" ],  // 103.86.249.0-103.87.7.255, BJ
        [ 0x67571400, 0x675717FF, "BJ" ],  // 103.87.20.0-103.87.23.255, BJ
        [ 0x67572000, 0x675723FF, "ZJ" ],  // 103.87.32.0-103.87.35.255, ZJ
        [ 0x67576000, 0x675763FF, "BJ" ],  // 103.87.96.0-103.87.99.255, BJ
        [ 0x67578400, 0x675787FF, "SH" ],  // 103.87.132.0-103.87.135.255, SH
        [ 0x6757B400, 0x6757B7FF, "JS" ],  // 103.87.180.0-103.87.183.255, JS
        [ 0x6757E000, 0x6757E3FF, "ZJ" ],  // 103.87.224.0-103.87.227.255, ZJ
        [ 0x67580400, 0x675813FF, "SH" ],  // 103.88.4.0-103.88.19.255, SH
        [ 0x67581400, 0x675817FF, "BJ" ],  // 103.88.20.0-103.88.23.255, BJ
        [ 0x67582000, 0x675823FF, "ZJ" ],  // 103.88.32.0-103.88.35.255, ZJ
        [ 0x67582400, 0x675827FF, "SD" ],  // 103.88.36.0-103.88.39.255, SD
        [ 0x67583C00, 0x67583FFF, "ZJ" ],  // 103.88.60.0-103.88.63.255, ZJ
        [ 0x67584000, 0x675843FF, "BJ" ],  // 103.88.64.0-103.88.67.255, BJ
        [ 0x67584800, 0x67584BFF, "ZJ" ],  // 103.88.72.0-103.88.75.255, ZJ
        [ 0x67586000, 0x675863FF, "BJ" ],  // 103.88.96.0-103.88.99.255, BJ
        [ 0x6758A400, 0x6758A7FF, "ZJ" ],  // 103.88.164.0-103.88.167.255, ZJ
        [ 0x6758D400, 0x6758D7FF, "ZJ" ],  // 103.88.212.0-103.88.215.255, ZJ
        [ 0x67591C00, 0x67591FFF, "SH" ],  // 103.89.28.0-103.89.31.255, SH
        [ 0x67596000, 0x675977FF, "ZJ" ],  // 103.89.96.0-103.89.119.255, ZJ
        [ 0x67599400, 0x675997FF, "BJ" ],  // 103.89.148.0-103.89.151.255, BJ
        [ 0x6759AC00, 0x6759AFFF, "BJ" ],  // 103.89.172.0-103.89.175.255, BJ
        [ 0x6759B800, 0x6759E7FF, "HE" ],  // 103.89.184.0-103.89.231.255, HE
        [ 0x675A3300, 0x675A33FF, "SH" ],  // 103.90.51.0-103.90.51.255, SH
        [ 0x675A3400, 0x675A37FF, "JS" ],  // 103.90.52.0-103.90.55.255, JS
        [ 0x675A3800, 0x675A39FF, "SH" ],  // 103.90.56.0-103.90.57.255, SH
        [ 0x675A5C00, 0x675A5FFF, "JS" ],  // 103.90.92.0-103.90.95.255, JS
        [ 0x675A6400, 0x675A67FF, "BJ" ],  // 103.90.100.0-103.90.103.255, BJ
        [ 0x675A6800, 0x675A87FF, "ZJ" ],  // 103.90.104.0-103.90.135.255, ZJ
        [ 0x675A9800, 0x675A9BFF, "GZ" ],  // 103.90.152.0-103.90.155.255, GZ
        [ 0x675AA800, 0x675AABFF, "GD" ],  // 103.90.168.0-103.90.171.255, GD
        [ 0x675AAD00, 0x675AADFF, "BJ" ],  // 103.90.173.0-103.90.173.255, BJ
        [ 0x675AB000, 0x675AB3FF, "BJ" ],  // 103.90.176.0-103.90.179.255, BJ
        [ 0x675ABC00, 0x675ABFFF, "BJ" ],  // 103.90.188.0-103.90.191.255, BJ
        [ 0x675AC000, 0x675AC3FF, "ZJ" ],  // 103.90.192.0-103.90.195.255, ZJ
        [ 0x675B2400, 0x675B2BFF, "BJ" ],  // 103.91.36.0-103.91.43.255, BJ
        [ 0x675B6C00, 0x675B6FFF, "HN" ],  // 103.91.108.0-103.91.111.255, HN
        [ 0x675B7000, 0x675B71FF, "BJ" ],  // 103.91.112.0-103.91.113.255, BJ
        [ 0x675B8A00, 0x675B8BFF, "SH" ],  // 103.91.138.0-103.91.139.255, SH
        [ 0x675B9800, 0x675B9BFF, "BJ" ],  // 103.91.152.0-103.91.155.255, BJ
        [ 0x675BB000, 0x675BB3FF, "BJ" ],  // 103.91.176.0-103.91.179.255, BJ
        [ 0x675BC800, 0x675BCBFF, "GD" ],  // 103.91.200.0-103.91.203.255, GD
        [ 0x675BD000, 0x675BD3FF, "SD" ],  // 103.91.208.0-103.91.211.255, SD
        [ 0x675BD400, 0x675BD7FF, "BJ" ],  // 103.91.212.0-103.91.215.255, BJ
        [ 0x675BEC00, 0x675BEFFF, "ZJ" ],  // 103.91.236.0-103.91.239.255, ZJ
        [ 0x675BFC00, 0x675C0FFF, "GD" ],  // 103.91.252.0-103.92.15.255, GD
        [ 0x675C3000, 0x675C33FF, "FJ" ],  // 103.92.48.0-103.92.51.255, FJ
        [ 0x675C3400, 0x675C3BFF, "BJ" ],  // 103.92.52.0-103.92.59.255, BJ
        [ 0x675C3C00, 0x675C53FF, "ZJ" ],  // 103.92.60.0-103.92.83.255, ZJ
        [ 0x675C5800, 0x675C5BFF, "SH" ],  // 103.92.88.0-103.92.91.255, SH
        [ 0x675C6C00, 0x675C6FFF, "ZJ" ],  // 103.92.108.0-103.92.111.255, ZJ
        [ 0x675C7C00, 0x675C7FFF, "BJ" ],  // 103.92.124.0-103.92.127.255, BJ
        [ 0x675C8000, 0x675C80FF, "GD" ],  // 103.92.128.0-103.92.128.255, GD
        [ 0x675C8400, 0x675C87FF, "HN" ],  // 103.92.132.0-103.92.135.255, HN
        [ 0x675C9C00, 0x675C9FFF, "BJ" ],  // 103.92.156.0-103.92.159.255, BJ
        [ 0x675CA400, 0x675CC3FF, "ZJ" ],  // 103.92.164.0-103.92.195.255, ZJ
        [ 0x675CEC00, 0x675CEFFF, "ZJ" ],  // 103.92.236.0-103.92.239.255, ZJ
        [ 0x675CF000, 0x675CF3FF, "LN" ],  // 103.92.240.0-103.92.243.255, LN
        [ 0x675CF400, 0x675D07FF, "ZJ" ],  // 103.92.244.0-103.93.7.255, ZJ
        [ 0x675D1C00, 0x675D1FFF, "ZJ" ],  // 103.93.28.0-103.93.31.255, ZJ
        [ 0x675D5400, 0x675D57FF, "HE" ],  // 103.93.84.0-103.93.87.255, HE
        [ 0x675D8E00, 0x675D8FFF, "SH" ],  // 103.93.142.0-103.93.143.255, SH
        [ 0x675D9800, 0x675D9BFF, "HN" ],  // 103.93.152.0-103.93.155.255, HN
        [ 0x675DB400, 0x675DB7FF, "BJ" ],  // 103.93.180.0-103.93.183.255, BJ
        [ 0x675DCC00, 0x675DCFFF, "BJ" ],  // 103.93.204.0-103.93.207.255, BJ
        [ 0x675E0C00, 0x675E0FFF, "BJ" ],  // 103.94.12.0-103.94.15.255, BJ
        [ 0x675E1400, 0x675E17FF, "HB" ],  // 103.94.20.0-103.94.23.255, HB
        [ 0x675E1C00, 0x675E2BFF, "BJ" ],  // 103.94.28.0-103.94.43.255, BJ
        [ 0x675E2C00, 0x675E2FFF, "SH" ],  // 103.94.44.0-103.94.47.255, SH
        [ 0x675E4800, 0x675E4BFF, "ZJ" ],  // 103.94.72.0-103.94.75.255, ZJ
        [ 0x675E5800, 0x675E5BFF, "YN" ],  // 103.94.88.0-103.94.91.255, YN
        [ 0x675E7400, 0x675E77FF, "ZJ" ],  // 103.94.116.0-103.94.119.255, ZJ
        [ 0x675EA000, 0x675EA3FF, "HL" ],  // 103.94.160.0-103.94.163.255, HL
        [ 0x675EC800, 0x675ECBFF, "SD" ],  // 103.94.200.0-103.94.203.255, SD
        [ 0x675F3400, 0x675F37FF, "HB" ],  // 103.95.52.0-103.95.55.255, HB
        [ 0x675F4400, 0x675F47FF, "BJ" ],  // 103.95.68.0-103.95.71.255, BJ
        [ 0x675F5800, 0x675F5BFF, "GD" ],  // 103.95.88.0-103.95.91.255, GD
        [ 0x675F5C00, 0x675F5DFF, "LN" ],  // 103.95.92.0-103.95.93.255, LN
        [ 0x675F5E00, 0x675F5FFF, "BJ" ],  // 103.95.94.0-103.95.95.255, BJ
        [ 0x675F8000, 0x675F83FF, "ZJ" ],  // 103.95.128.0-103.95.131.255, ZJ
        [ 0x675F8800, 0x675F88FF, "HE" ],  // 103.95.136.0-103.95.136.255, HE
        [ 0x675F8900, 0x675F8FFF, "BJ" ],  // 103.95.137.0-103.95.143.255, BJ
        [ 0x675F9000, 0x675F93FF, "SH" ],  // 103.95.144.0-103.95.147.255, SH
        [ 0x675F9800, 0x675F9BFF, "HB" ],  // 103.95.152.0-103.95.155.255, HB
        [ 0x675FD800, 0x675FDBFF, "HB" ],  // 103.95.216.0-103.95.219.255, HB
        [ 0x675FDC00, 0x675FDEFF, "ZJ" ],  // 103.95.220.0-103.95.222.255, ZJ
        [ 0x675FDF00, 0x675FDFFF, "SH" ],  // 103.95.223.0-103.95.223.255, SH
        [ 0x675FE000, 0x675FE3FF, "BJ" ],  // 103.95.224.0-103.95.227.255, BJ
        [ 0x675FEC00, 0x675FF3FF, "BJ" ],  // 103.95.236.0-103.95.243.255, BJ
        [ 0x675FF400, 0x675FF7FF, "SH" ],  // 103.95.244.0-103.95.247.255, SH
        [ 0x675FF800, 0x675FFBFF, "ZJ" ],  // 103.95.248.0-103.95.251.255, ZJ
        [ 0x675FFC00, 0x675FFFFF, "GD" ],  // 103.95.252.0-103.95.255.255, GD
        [ 0x67600800, 0x67600BFF, "GD" ],  // 103.96.8.0-103.96.11.255, GD
        [ 0x67607C00, 0x67607FFF, "BJ" ],  // 103.96.124.0-103.96.127.255, BJ
        [ 0x67608800, 0x67608CFF, "GD" ],  // 103.96.136.0-103.96.140.255, GD
        [ 0x67609800, 0x6760BFFF, "ZJ" ],  // 103.96.152.0-103.96.191.255, ZJ
        [ 0x6760C000, 0x6760C3FF, "GD" ],  // 103.96.192.0-103.96.195.255, GD
        [ 0x6760C400, 0x6760D3FF, "ZJ" ],  // 103.96.196.0-103.96.211.255, ZJ
        [ 0x6760D400, 0x6760D5FF, "SH" ],  // 103.96.212.0-103.96.213.255, SH
        [ 0x6760D600, 0x6760D7FF, "JS" ],  // 103.96.214.0-103.96.215.255, JS
        [ 0x6760D800, 0x6760DBFF, "HN" ],  // 103.96.216.0-103.96.219.255, HN
        [ 0x6760E000, 0x6760E1FF, "SH" ],  // 103.96.224.0-103.96.225.255, SH
        [ 0x67610800, 0x67610BFF, "BJ" ],  // 103.97.8.0-103.97.11.255, BJ
        [ 0x67610C00, 0x67610FFF, "GD" ],  // 103.97.12.0-103.97.15.255, GD
        [ 0x67611000, 0x67611FFF, "BJ" ],  // 103.97.16.0-103.97.31.255, BJ
        [ 0x67612000, 0x676121FF, "SH" ],  // 103.97.32.0-103.97.33.255, SH
        [ 0x67612400, 0x676127FF, "GD" ],  // 103.97.36.0-103.97.39.255, GD
        [ 0x67612800, 0x67612BFF, "BJ" ],  // 103.97.40.0-103.97.43.255, BJ
        [ 0x67613900, 0x67613BFF, "HA" ],  // 103.97.57.0-103.97.59.255, HA
        [ 0x67613C00, 0x67613CFF, "JS" ],  // 103.97.60.0-103.97.60.255, JS
        [ 0x67613D00, 0x67613FFF, "SH" ],  // 103.97.61.0-103.97.63.255, SH
        [ 0x67614000, 0x676147FF, "GD" ],  // 103.97.64.0-103.97.71.255, GD
        [ 0x67614800, 0x67614BFF, "BJ" ],  // 103.97.72.0-103.97.75.255, BJ
        [ 0x67617000, 0x676173FF, "SH" ],  // 103.97.112.0-103.97.115.255, SH
        [ 0x67617400, 0x676177FF, "BJ" ],  // 103.97.116.0-103.97.119.255, BJ
        [ 0x67619000, 0x676193FF, "HB" ],  // 103.97.144.0-103.97.147.255, HB
        [ 0x67619400, 0x676197FF, "GD" ],  // 103.97.148.0-103.97.151.255, GD
        [ 0x6761BC00, 0x6761BFFF, "HA" ],  // 103.97.188.0-103.97.191.255, HA
        [ 0x6761C000, 0x6761C3FF, "BJ" ],  // 103.97.192.0-103.97.195.255, BJ
        [ 0x67620000, 0x676201FF, "SH" ],  // 103.98.0.0-103.98.1.255, SH
        [ 0x67621C00, 0x67621DFF, "SH" ],  // 103.98.28.0-103.98.29.255, SH
        [ 0x67622800, 0x67622BFF, "BJ" ],  // 103.98.40.0-103.98.43.255, BJ
        [ 0x67622C00, 0x67622FFF, "ZJ" ],  // 103.98.44.0-103.98.47.255, ZJ
        [ 0x67623000, 0x676233FF, "TJ" ],  // 103.98.48.0-103.98.51.255, TJ
        [ 0x67623800, 0x67623BFF, "SD" ],  // 103.98.56.0-103.98.59.255, SD
        [ 0x67625000, 0x676253FF, "HB" ],  // 103.98.80.0-103.98.83.255, HB
        [ 0x67625800, 0x67625BFF, "SH" ],  // 103.98.88.0-103.98.91.255, SH
        [ 0x67625C00, 0x676263FF, "ZJ" ],  // 103.98.92.0-103.98.99.255, ZJ
        [ 0x67626400, 0x676267FF, "SH" ],  // 103.98.100.0-103.98.103.255, SH
        [ 0x67627C00, 0x67627EFF, "SH" ],  // 103.98.124.0-103.98.126.255, SH
        [ 0x67627F00, 0x67627FFF, "BJ" ],  // 103.98.127.0-103.98.127.255, BJ
        [ 0x67628800, 0x676293FF, "JS" ],  // 103.98.136.0-103.98.147.255, JS
        [ 0x6762A400, 0x6762A7FF, "SH" ],  // 103.98.164.0-103.98.167.255, SH
        [ 0x6762A800, 0x6762ABFF, "SD" ],  // 103.98.168.0-103.98.171.255, SD
        [ 0x6762B400, 0x6762B7FF, "HN" ],  // 103.98.180.0-103.98.183.255, HN
        [ 0x6762C400, 0x6762C7FF, "HB" ],  // 103.98.196.0-103.98.199.255, HB
        [ 0x6762D800, 0x6762DBFF, "ZJ" ],  // 103.98.216.0-103.98.219.255, ZJ
        [ 0x6762DC00, 0x6762DFFF, "SH" ],  // 103.98.220.0-103.98.223.255, SH
        [ 0x6762E000, 0x6762E3FF, "HE" ],  // 103.98.224.0-103.98.227.255, HE
        [ 0x6762E400, 0x6762E7FF, "SH" ],  // 103.98.228.0-103.98.231.255, SH
        [ 0x6762E800, 0x6762EBFF, "HE" ],  // 103.98.232.0-103.98.235.255, HE
        [ 0x6762F000, 0x6762F7FF, "HB" ],  // 103.98.240.0-103.98.247.255, HB
        [ 0x6762F800, 0x6762FFFF, "BJ" ],  // 103.98.248.0-103.98.255.255, BJ
        [ 0x67633400, 0x676337FF, "HB" ],  // 103.99.52.0-103.99.55.255, HB
        [ 0x67633800, 0x67633BFF, "SX" ],  // 103.99.56.0-103.99.59.255, SX
        [ 0x67634D00, 0x67634DFF, "SH" ],  // 103.99.77.0-103.99.77.255, SH
        [ 0x67634F00, 0x67634FFF, "SH" ],  // 103.99.79.0-103.99.79.255, SH
        [ 0x67636800, 0x67636BFF, "FJ" ],  // 103.99.104.0-103.99.107.255, FJ
        [ 0x67637400, 0x67637BFF, "HB" ],  // 103.99.116.0-103.99.123.255, HB
        [ 0x67639800, 0x67639BFF, "BJ" ],  // 103.99.152.0-103.99.155.255, BJ
        [ 0x6763DC00, 0x6763DFFF, "BJ" ],  // 103.99.220.0-103.99.223.255, BJ
        [ 0x6763E800, 0x6763EFFF, "HB" ],  // 103.99.232.0-103.99.239.255, HB
        [ 0x67640000, 0x676403FF, "BJ" ],  // 103.100.0.0-103.100.3.255, BJ
        [ 0x67642000, 0x676420FF, "TJ" ],  // 103.100.32.0-103.100.32.255, TJ
        [ 0x67642100, 0x676423FF, "GS" ],  // 103.100.33.0-103.100.35.255, GS
        [ 0x67642800, 0x67642BFF, "GD" ],  // 103.100.40.0-103.100.43.255, GD
        [ 0x67643000, 0x676433FF, "JX" ],  // 103.100.48.0-103.100.51.255, JX
        [ 0x67643400, 0x676437FF, "ZJ" ],  // 103.100.52.0-103.100.55.255, ZJ
        [ 0x67643800, 0x67643BFF, "GD" ],  // 103.100.56.0-103.100.59.255, GD
        [ 0x67644000, 0x676443FF, "BJ" ],  // 103.100.64.0-103.100.67.255, BJ
        [ 0x67644500, 0x676445FF, "HA" ],  // 103.100.69.0-103.100.69.255, HA
        [ 0x67644600, 0x676447FF, "GD" ],  // 103.100.70.0-103.100.71.255, GD
        [ 0x67645800, 0x67645BFF, "SN" ],  // 103.100.88.0-103.100.91.255, SN
        [ 0x67647400, 0x676477FF, "HE" ],  // 103.100.116.0-103.100.119.255, HE
        [ 0x67649000, 0x676493FF, "HE" ],  // 103.100.144.0-103.100.147.255, HE
        [ 0x6764EC00, 0x6764EFFF, "CQ" ],  // 103.100.236.0-103.100.239.255, CQ
        [ 0x6764F000, 0x6764F3FF, "GD" ],  // 103.100.240.0-103.100.243.255, GD
        [ 0x6764F800, 0x6764FFFF, "HB" ],  // 103.100.248.0-103.100.255.255, HB
        [ 0x67650400, 0x676507FF, "FJ" ],  // 103.101.4.0-103.101.7.255, FJ
        [ 0x67650800, 0x67650BFF, "BJ" ],  // 103.101.8.0-103.101.11.255, BJ
        [ 0x67650C00, 0x67650FFF, "GD" ],  // 103.101.12.0-103.101.15.255, GD
        [ 0x67651F00, 0x67651FFF, "FJ" ],  // 103.101.31.0-103.101.31.255, FJ
        [ 0x67653C00, 0x67653FFF, "BJ" ],  // 103.101.60.0-103.101.63.255, BJ
        [ 0x67657800, 0x676578FF, "BJ" ],  // 103.101.120.0-103.101.120.255, BJ
        [ 0x67657900, 0x67657BFF, "CQ" ],  // 103.101.121.0-103.101.123.255, CQ
        [ 0x67657C00, 0x67657CFF, "SH" ],  // 103.101.124.0-103.101.124.255, SH
        [ 0x67657E00, 0x67657FFF, "BJ" ],  // 103.101.126.0-103.101.127.255, BJ
        [ 0x67659000, 0x676597FF, "HB" ],  // 103.101.144.0-103.101.151.255, HB
        [ 0x6765B400, 0x6765B7FF, "JS" ],  // 103.101.180.0-103.101.183.255, JS
        [ 0x6765B800, 0x6765BBFF, "QH" ],  // 103.101.184.0-103.101.187.255, QH
        [ 0x67664C00, 0x676653FF, "HB" ],  // 103.102.76.0-103.102.83.255, HB
        [ 0x6766A800, 0x6766AFFF, "JS" ],  // 103.102.168.0-103.102.175.255, JS
        [ 0x6766B400, 0x6766B7FF, "GD" ],  // 103.102.180.0-103.102.183.255, GD
        [ 0x6766B800, 0x6766BFFF, "SH" ],  // 103.102.184.0-103.102.191.255, SH
        [ 0x6766C000, 0x6766C420, "BJ" ],  // 103.102.192.0-103.102.196.32, BJ
        [ 0x6766C421, 0x6766C4FF, "SH" ],  // 103.102.196.33-103.102.196.255, SH
        [ 0x6766C500, 0x6766CBFF, "BJ" ],  // 103.102.197.0-103.102.203.255, BJ
        [ 0x6766D000, 0x6766D7FF, "HB" ],  // 103.102.208.0-103.102.215.255, HB
        [ 0x67670C00, 0x676713FF, "BJ" ],  // 103.103.12.0-103.103.19.255, BJ
        [ 0x67672400, 0x676724FF, "BJ" ],  // 103.103.36.0-103.103.36.255, BJ
        [ 0x67672500, 0x676727FF, "SC" ],  // 103.103.37.0-103.103.39.255, SC
        [ 0x67674800, 0x67674BFF, "HN" ],  // 103.103.72.0-103.103.75.255, HN
        [ 0x6767BC00, 0x6767BFFF, "SH" ],  // 103.103.188.0-103.103.191.255, SH
        [ 0x6767C800, 0x6767CBFF, "HA" ],  // 103.103.200.0-103.103.203.255, HA
        [ 0x6767CC00, 0x6767CFFF, "FJ" ],  // 103.103.204.0-103.103.207.255, FJ
        [ 0x6767DC01, 0x6767DCFF, "SC" ],  // 103.103.220.1-103.103.220.255, SC
        [ 0x6767DD01, 0x6767DDFF, "SC" ],  // 103.103.221.1-103.103.221.255, SC
        [ 0x6767DE01, 0x6767DEFF, "SC" ],  // 103.103.222.1-103.103.222.255, SC
        [ 0x6767DF01, 0x6767E0FF, "SC" ],  // 103.103.223.1-103.103.224.255, SC
        [ 0x6767E100, 0x6767E1FF, "GZ" ],  // 103.103.225.0-103.103.225.255, GZ
        [ 0x6767E200, 0x6767E7FF, "SC" ],  // 103.103.226.0-103.103.231.255, SC
        [ 0x6767E800, 0x6767EBFF, "GD" ],  // 103.103.232.0-103.103.235.255, GD
        [ 0x6767F800, 0x6767FFFF, "GD" ],  // 103.103.248.0-103.103.255.255, GD
        [ 0x67680000, 0x676800FF, "CQ" ],  // 103.104.0.0-103.104.0.255, CQ
        [ 0x67680100, 0x676801FF, "SC" ],  // 103.104.1.0-103.104.1.255, SC
        [ 0x67680200, 0x676803FF, "CQ" ],  // 103.104.2.0-103.104.3.255, CQ
        [ 0x67680400, 0x676807FF, "SC" ],  // 103.104.4.0-103.104.7.255, SC
        [ 0x67682400, 0x67682BFF, "HB" ],  // 103.104.36.0-103.104.43.255, HB
        [ 0x67684000, 0x676843FF, "BJ" ],  // 103.104.64.0-103.104.67.255, BJ
        [ 0x67689800, 0x67689BFF, "BJ" ],  // 103.104.152.0-103.104.155.255, BJ
        [ 0x6768BC00, 0x6768BFFF, "BJ" ],  // 103.104.188.0-103.104.191.255, BJ
        [ 0x6768FC00, 0x676903FF, "HB" ],  // 103.104.252.0-103.105.3.255, HB
        [ 0x67690400, 0x676907FF, "ZJ" ],  // 103.105.4.0-103.105.7.255, ZJ
        [ 0x67690C00, 0x67690FFF, "ZJ" ],  // 103.105.12.0-103.105.15.255, ZJ
        [ 0x67691000, 0x676913FF, "JS" ],  // 103.105.16.0-103.105.19.255, JS
        [ 0x67691700, 0x676917FF, "TJ" ],  // 103.105.23.0-103.105.23.255, TJ
        [ 0x67693C00, 0x67693FFF, "SD" ],  // 103.105.60.0-103.105.63.255, SD
        [ 0x67697400, 0x676977FF, "XJ" ],  // 103.105.116.0-103.105.119.255, XJ
        [ 0x6769B400, 0x6769BBFF, "HB" ],  // 103.105.180.0-103.105.187.255, HB
        [ 0x6769C800, 0x6769CBFF, "BJ" ],  // 103.105.200.0-103.105.203.255, BJ
        [ 0x6769CC00, 0x6769CFFF, "AH" ],  // 103.105.204.0-103.105.207.255, AH
        [ 0x6769DC00, 0x6769DFFF, "ZJ" ],  // 103.105.220.0-103.105.223.255, ZJ
        [ 0x676A2400, 0x676A2BFF, "HB" ],  // 103.106.36.0-103.106.43.255, HB
        [ 0x676A2C00, 0x676A2FFF, "BJ" ],  // 103.106.44.0-103.106.47.255, BJ
        [ 0x676A3C00, 0x676A3FFF, "LN" ],  // 103.106.60.0-103.106.63.255, LN
        [ 0x676A4400, 0x676A47FF, "BJ" ],  // 103.106.68.0-103.106.71.255, BJ
        [ 0x676A6000, 0x676A61FF, "BJ" ],  // 103.106.96.0-103.106.97.255, BJ
        [ 0x676A6200, 0x676A63FF, "HE" ],  // 103.106.98.0-103.106.99.255, HE
        [ 0x676A7800, 0x676A7BFF, "BJ" ],  // 103.106.120.0-103.106.123.255, BJ
        [ 0x676A8000, 0x676A87FF, "HB" ],  // 103.106.128.0-103.106.135.255, HB
        [ 0x676AC400, 0x676AC7FF, "BJ" ],  // 103.106.196.0-103.106.199.255, BJ
        [ 0x676ACA00, 0x676ACBFF, "BJ" ],  // 103.106.202.0-103.106.203.255, BJ
        [ 0x676AD400, 0x676AD7FF, "BJ" ],  // 103.106.212.0-103.106.215.255, BJ
        [ 0x676AFC00, 0x676B03FF, "HB" ],  // 103.106.252.0-103.107.3.255, HB
        [ 0x676B1C00, 0x676B23FF, "HB" ],  // 103.107.28.0-103.107.35.255, HB
        [ 0x676B2C00, 0x676B2FFF, "BJ" ],  // 103.107.44.0-103.107.47.255, BJ
        [ 0x676B4800, 0x676B4BFF, "BJ" ],  // 103.107.72.0-103.107.75.255, BJ
        [ 0x676B6F00, 0x676B6FFF, "GD" ],  // 103.107.111.0-103.107.111.255, GD
        [ 0x676BA400, 0x676BABFF, "BJ" ],  // 103.107.164.0-103.107.171.255, BJ
        [ 0x676BBC00, 0x676BBFFF, "JS" ],  // 103.107.188.0-103.107.191.255, JS
        [ 0x676BC000, 0x676BC3FF, "ZJ" ],  // 103.107.192.0-103.107.195.255, ZJ
        [ 0x676BD000, 0x676BD3FF, "JX" ],  // 103.107.208.0-103.107.211.255, JX
        [ 0x676BD400, 0x676BD7FF, "ZJ" ],  // 103.107.212.0-103.107.215.255, ZJ
        [ 0x676BD800, 0x676BDFFF, "BJ" ],  // 103.107.216.0-103.107.223.255, BJ
        [ 0x676C3400, 0x676C37FF, "FJ" ],  // 103.108.52.0-103.108.55.255, FJ
        [ 0x676CA000, 0x676CA3FF, "SH" ],  // 103.108.160.0-103.108.163.255, SH
        [ 0x676CA400, 0x676CA7FF, "GD" ],  // 103.108.164.0-103.108.167.255, GD
        [ 0x676CC400, 0x676CC7FF, "FJ" ],  // 103.108.196.0-103.108.199.255, FJ
        [ 0x676CD000, 0x676CD3FF, "ZJ" ],  // 103.108.208.0-103.108.211.255, ZJ
        [ 0x676CD400, 0x676CD7FF, "BJ" ],  // 103.108.212.0-103.108.215.255, BJ
        [ 0x676CE000, 0x676CE3FF, "JS" ],  // 103.108.224.0-103.108.227.255, JS
        [ 0x676CF400, 0x676CF4FF, "SH" ],  // 103.108.244.0-103.108.244.255, SH
        [ 0x676CF500, 0x676CF7FF, "BJ" ],  // 103.108.245.0-103.108.247.255, BJ
        [ 0x676D1400, 0x676D17FF, "SD" ],  // 103.109.20.0-103.109.23.255, SD
        [ 0x676D3000, 0x676D33FF, "ZJ" ],  // 103.109.48.0-103.109.51.255, ZJ
        [ 0x676D5800, 0x676D5BFF, "JS" ],  // 103.109.88.0-103.109.91.255, JS
        [ 0x676D6A00, 0x676D6BFF, "FJ" ],  // 103.109.106.0-103.109.107.255, FJ
        [ 0x676DF800, 0x676DFBFF, "HN" ],  // 103.109.248.0-103.109.251.255, HN
        [ 0x676E5C00, 0x676E5FFF, "TJ" ],  // 103.110.92.0-103.110.95.255, TJ
        [ 0x676E7400, 0x676E75FF, "BJ" ],  // 103.110.116.0-103.110.117.255, BJ
        [ 0x676E7600, 0x676E77FF, "SC" ],  // 103.110.118.0-103.110.119.255, SC
        [ 0x676E8400, 0x676E87FF, "TJ" ],  // 103.110.132.0-103.110.135.255, TJ
        [ 0x676E8800, 0x676E8BFF, "BJ" ],  // 103.110.136.0-103.110.139.255, BJ
        [ 0x676E9800, 0x676E98FF, "TJ" ],  // 103.110.152.0-103.110.152.255, TJ
        [ 0x676E9900, 0x676E9BFF, "BJ" ],  // 103.110.153.0-103.110.155.255, BJ
        [ 0x676E9C00, 0x676E9FFF, "JL" ],  // 103.110.156.0-103.110.159.255, JL
        [ 0x676EBC00, 0x676EBFFF, "HA" ],  // 103.110.188.0-103.110.191.255, HA
        [ 0x676ECC00, 0x676ECFFF, "BJ" ],  // 103.110.204.0-103.110.207.255, BJ
        [ 0x676F4000, 0x676F43FF, "SH" ],  // 103.111.64.0-103.111.67.255, SH
        [ 0x676FAC00, 0x676FAFFF, "BJ" ],  // 103.111.172.0-103.111.175.255, BJ
        [ 0x676FFC00, 0x676FFFFF, "SC" ],  // 103.111.252.0-103.111.255.255, SC
        [ 0x67701C00, 0x67701FFF, "GD" ],  // 103.112.28.0-103.112.31.255, GD
        [ 0x67704800, 0x67704BFF, "ZJ" ],  // 103.112.72.0-103.112.75.255, ZJ
        [ 0x67705800, 0x67705BFF, "GD" ],  // 103.112.88.0-103.112.91.255, GD
        [ 0x67705C00, 0x67705FFF, "BJ" ],  // 103.112.92.0-103.112.95.255, BJ
        [ 0x67706C00, 0x677073FF, "BJ" ],  // 103.112.108.0-103.112.115.255, BJ
        [ 0x67708C00, 0x67708FFF, "BJ" ],  // 103.112.140.0-103.112.143.255, BJ
        [ 0x67710400, 0x677107FF, "HB" ],  // 103.113.4.0-103.113.7.255, HB
        [ 0x67719000, 0x677193FF, "BJ" ],  // 103.113.144.0-103.113.147.255, BJ
        [ 0x6771DC00, 0x6771DFFF, "SN" ],  // 103.113.220.0-103.113.223.255, SN
        [ 0x6771E800, 0x6771EBFF, "SC" ],  // 103.113.232.0-103.113.235.255, SC
        [ 0x6771EC00, 0x6771EFFF, "ZJ" ],  // 103.113.236.0-103.113.239.255, ZJ
        [ 0x67720400, 0x677207FF, "BJ" ],  // 103.114.4.0-103.114.7.255, BJ
        [ 0x67721C00, 0x67721FFF, "SH" ],  // 103.114.28.0-103.114.31.255, SH
        [ 0x67724400, 0x677247FF, "NM" ],  // 103.114.68.0-103.114.71.255, NM
        [ 0x67726400, 0x677267FF, "SN" ],  // 103.114.100.0-103.114.103.255, SN
        [ 0x67729400, 0x677297FF, "LN" ],  // 103.114.148.0-103.114.151.255, LN
        [ 0x67729C00, 0x67729DFF, "SH" ],  // 103.114.156.0-103.114.157.255, SH
        [ 0x67729E00, 0x67729FFF, "BJ" ],  // 103.114.158.0-103.114.159.255, BJ
        [ 0x6772D400, 0x6772D7FF, "BJ" ],  // 103.114.212.0-103.114.215.255, BJ
        [ 0x6772EC00, 0x6772ECFF, "SH" ],  // 103.114.236.0-103.114.236.255, SH
        [ 0x6772ED00, 0x6772EFFF, "GD" ],  // 103.114.237.0-103.114.239.255, GD
        [ 0x6772F000, 0x6772F3FF, "SH" ],  // 103.114.240.0-103.114.243.255, SH
        [ 0x67731000, 0x677312FF, "HB" ],  // 103.115.16.0-103.115.18.255, HB
        [ 0x67733400, 0x677337FF, "BJ" ],  // 103.115.52.0-103.115.55.255, BJ
        [ 0x67734400, 0x677347FF, "SD" ],  // 103.115.68.0-103.115.71.255, SD
        [ 0x67735C00, 0x67735FFF, "JS" ],  // 103.115.92.0-103.115.95.255, JS
        [ 0x67737800, 0x67737BFF, "BJ" ],  // 103.115.120.0-103.115.123.255, BJ
        [ 0x67739400, 0x677397FF, "BJ" ],  // 103.115.148.0-103.115.151.255, BJ
        [ 0x6773F800, 0x6773FBFF, "GZ" ],  // 103.115.248.0-103.115.251.255, GZ
        [ 0x67742800, 0x67742BFF, "BJ" ],  // 103.116.40.0-103.116.43.255, BJ
        [ 0x67744C00, 0x67744FFF, "SH" ],  // 103.116.76.0-103.116.79.255, SH
        [ 0x67745C00, 0x67745FFF, "GD" ],  // 103.116.92.0-103.116.95.255, GD
        [ 0x67747800, 0x677479FF, "BJ" ],  // 103.116.120.0-103.116.121.255, BJ
        [ 0x67747A00, 0x67747AFF, "GD" ],  // 103.116.122.0-103.116.122.255, GD
        [ 0x67747B00, 0x67747BFF, "BJ" ],  // 103.116.123.0-103.116.123.255, BJ
        [ 0x67748000, 0x677483FF, "BJ" ],  // 103.116.128.0-103.116.131.255, BJ
        [ 0x67748B00, 0x67748BFF, "TJ" ],  // 103.116.139.0-103.116.139.255, TJ
        [ 0x67749400, 0x677497FF, "SH" ],  // 103.116.148.0-103.116.151.255, SH
        [ 0x6774B800, 0x6774BBFF, "ZJ" ],  // 103.116.184.0-103.116.187.255, ZJ
        [ 0x6774CE00, 0x6774CFFF, "SH" ],  // 103.116.206.0-103.116.207.255, SH
        [ 0x6774DC00, 0x6774DFFF, "SD" ],  // 103.116.220.0-103.116.223.255, SD
        [ 0x6774E000, 0x6774E3FF, "BJ" ],  // 103.116.224.0-103.116.227.255, BJ
        [ 0x6774E400, 0x6774E7FF, "SH" ],  // 103.116.228.0-103.116.231.255, SH
        [ 0x67751000, 0x677513FF, "BJ" ],  // 103.117.16.0-103.117.19.255, BJ
        [ 0x67754900, 0x67754BFF, "SH" ],  // 103.117.73.0-103.117.75.255, SH
        [ 0x67755800, 0x67755BFF, "LN" ],  // 103.117.88.0-103.117.91.255, LN
        [ 0x67758800, 0x67758BFF, "BJ" ],  // 103.117.136.0-103.117.139.255, BJ
        [ 0x6775BC00, 0x6775BFFF, "BJ" ],  // 103.117.188.0-103.117.191.255, BJ
        [ 0x6775DC00, 0x6775DFFF, "SN" ],  // 103.117.220.0-103.117.223.255, SN
        [ 0x67763400, 0x67763BFF, "BJ" ],  // 103.118.52.0-103.118.59.255, BJ
        [ 0x67763C00, 0x67763FFF, "SH" ],  // 103.118.60.0-103.118.63.255, SH
        [ 0x67764000, 0x677643FF, "GD" ],  // 103.118.64.0-103.118.67.255, GD
        [ 0x67764400, 0x677647FF, "ZJ" ],  // 103.118.68.0-103.118.71.255, ZJ
        [ 0x67764800, 0x67764BFF, "BJ" ],  // 103.118.72.0-103.118.75.255, BJ
        [ 0x67765800, 0x67765BFF, "GD" ],  // 103.118.88.0-103.118.91.255, GD
        [ 0x6776AD00, 0x6776ADFF, "SH" ],  // 103.118.173.0-103.118.173.255, SH
        [ 0x67771C00, 0x67771FFF, "BJ" ],  // 103.119.28.0-103.119.31.255, BJ
        [ 0x67777300, 0x677773FF, "JS" ],  // 103.119.115.0-103.119.115.255, JS
        [ 0x67779C00, 0x67779FFF, "ZJ" ],  // 103.119.156.0-103.119.159.255, ZJ
        [ 0x6777B400, 0x6777B7FF, "JS" ],  // 103.119.180.0-103.119.183.255, JS
        [ 0x6777C800, 0x6777CBFF, "SN" ],  // 103.119.200.0-103.119.203.255, SN
        [ 0x6777E000, 0x6777E3FF, "SH" ],  // 103.119.224.0-103.119.227.255, SH
        [ 0x67783400, 0x677837FF, "BJ" ],  // 103.120.52.0-103.120.55.255, BJ
        [ 0x67784800, 0x67784BFF, "ZJ" ],  // 103.120.72.0-103.120.75.255, ZJ
        [ 0x67785800, 0x67785BFF, "BJ" ],  // 103.120.88.0-103.120.91.255, BJ
        [ 0x67786000, 0x677863FF, "BJ" ],  // 103.120.96.0-103.120.99.255, BJ
        [ 0x67786400, 0x677867FF, "CQ" ],  // 103.120.100.0-103.120.103.255, CQ
        [ 0x67788C00, 0x67788FFF, "BJ" ],  // 103.120.140.0-103.120.143.255, BJ
        [ 0x6778C400, 0x6778C7FF, "SH" ],  // 103.120.196.0-103.120.199.255, SH
        [ 0x6778E000, 0x6778E3FF, "TJ" ],  // 103.120.224.0-103.120.227.255, TJ
        [ 0x67793110, 0x67793113, "BJ" ],  // 103.121.49.16-103.121.49.19, BJ
        [ 0x67793400, 0x677937FF, "BJ" ],  // 103.121.52.0-103.121.55.255, BJ
        [ 0x67795C00, 0x67795FFF, "TJ" ],  // 103.121.92.0-103.121.95.255, TJ
        [ 0x6779A000, 0x6779A0FF, "BJ" ],  // 103.121.160.0-103.121.160.255, BJ
        [ 0x6779A100, 0x6779A3FF, "TJ" ],  // 103.121.161.0-103.121.163.255, TJ
        [ 0x6779A400, 0x6779A7FF, "BJ" ],  // 103.121.164.0-103.121.167.255, BJ
        [ 0x6779FA00, 0x6779FAFF, "SH" ],  // 103.121.250.0-103.121.250.255, SH
        [ 0x6779FC00, 0x6779FFFF, "JS" ],  // 103.121.252.0-103.121.255.255, JS
        [ 0x677A3000, 0x677A33FF, "SN" ],  // 103.122.48.0-103.122.51.255, SN
        [ 0x677AC000, 0x677AC3FF, "BJ" ],  // 103.122.192.0-103.122.195.255, BJ
        [ 0x677AF000, 0x677AF3FF, "GD" ],  // 103.122.240.0-103.122.243.255, GD
        [ 0x677B0400, 0x677B07FF, "CQ" ],  // 103.123.4.0-103.123.7.255, CQ
        [ 0x677B3800, 0x677B3BFF, "ZJ" ],  // 103.123.56.0-103.123.59.255, ZJ
        [ 0x677B5800, 0x677B5BFF, "GD" ],  // 103.123.88.0-103.123.91.255, GD
        [ 0x677B5C00, 0x677B5FFF, "BJ" ],  // 103.123.92.0-103.123.95.255, BJ
        [ 0x677B7400, 0x677B77FF, "BJ" ],  // 103.123.116.0-103.123.119.255, BJ
        [ 0x677BB000, 0x677BB3FF, "BJ" ],  // 103.123.176.0-103.123.179.255, BJ
        [ 0x677BC800, 0x677BCFFF, "HA" ],  // 103.123.200.0-103.123.207.255, HA
        [ 0x677BD000, 0x677BD3FF, "BJ" ],  // 103.123.208.0-103.123.211.255, BJ
        [ 0x677BD400, 0x677BD7FF, "NM" ],  // 103.123.212.0-103.123.215.255, NM
        [ 0x677C1800, 0x677C1BFF, "BJ" ],  // 103.124.24.0-103.124.27.255, BJ
        [ 0x677C3000, 0x677C33FF, "BJ" ],  // 103.124.48.0-103.124.51.255, BJ
        [ 0x677C4000, 0x677C43FF, "LN" ],  // 103.124.64.0-103.124.67.255, LN
        [ 0x677CD400, 0x677CD7FF, "ZJ" ],  // 103.124.212.0-103.124.215.255, ZJ
        [ 0x677CD800, 0x677CDBFF, "HB" ],  // 103.124.216.0-103.124.219.255, HB
        [ 0x677D1400, 0x677D17FF, "SC" ],  // 103.125.20.0-103.125.23.255, SC
        [ 0x677D2C00, 0x677D2FFF, "BJ" ],  // 103.125.44.0-103.125.47.255, BJ
        [ 0x677D8400, 0x677D87FF, "BJ" ],  // 103.125.132.0-103.125.135.255, BJ
        [ 0x677DA400, 0x677DA7FF, "BJ" ],  // 103.125.164.0-103.125.167.255, BJ
        [ 0x677DC400, 0x677DC7FF, "BJ" ],  // 103.125.196.0-103.125.199.255, BJ
        [ 0x677DEC00, 0x677DEFFF, "HE" ],  // 103.125.236.0-103.125.239.255, HE
        [ 0x677DF800, 0x677DF8FF, "FJ" ],  // 103.125.248.0-103.125.248.255, FJ
        [ 0x677DFB00, 0x677DFBFF, "FJ" ],  // 103.125.251.0-103.125.251.255, FJ
        [ 0x677E0000, 0x677E03FF, "ZJ" ],  // 103.126.0.0-103.126.3.255, ZJ
        [ 0x677E1000, 0x677E13FF, "BJ" ],  // 103.126.16.0-103.126.19.255, BJ
        [ 0x677E2C00, 0x677E2FFF, "BJ" ],  // 103.126.44.0-103.126.47.255, BJ
        [ 0x677E6400, 0x677E65FF, "HB" ],  // 103.126.100.0-103.126.101.255, HB
        [ 0x677E6600, 0x677E66FF, "BJ" ],  // 103.126.102.0-103.126.102.255, BJ
        [ 0x677E6700, 0x677E67FF, "HB" ],  // 103.126.103.0-103.126.103.255, HB
        [ 0x677E7C00, 0x677E7FFF, "HB" ],  // 103.126.124.0-103.126.127.255, HB
        [ 0x677E8000, 0x677E83FF, "LN" ],  // 103.126.128.0-103.126.131.255, LN
        [ 0x677E8400, 0x677E87FF, "GD" ],  // 103.126.132.0-103.126.135.255, GD
        [ 0x677ED200, 0x677ED2FF, "HA" ],  // 103.126.210.0-103.126.210.255, HA
        [ 0x67828400, 0x678287FF, "BJ" ],  // 103.130.132.0-103.130.135.255, BJ
        [ 0x6782A000, 0x6782A3FF, "BJ" ],  // 103.130.160.0-103.130.163.255, BJ
        [ 0x6782E400, 0x6782E7FF, "BJ" ],  // 103.130.228.0-103.130.231.255, BJ
        [ 0x67831400, 0x678317FF, "GD" ],  // 103.131.20.0-103.131.23.255, GD
        [ 0x67832400, 0x678327FF, "BJ" ],  // 103.131.36.0-103.131.39.255, BJ
        [ 0x67838A00, 0x67838BFF, "HE" ],  // 103.131.138.0-103.131.139.255, HE
        [ 0x67839800, 0x67839BFF, "BJ" ],  // 103.131.152.0-103.131.155.255, BJ
        [ 0x6783A800, 0x6783ABFF, "BJ" ],  // 103.131.168.0-103.131.171.255, BJ
        [ 0x6783E000, 0x6783E7FF, "ZJ" ],  // 103.131.224.0-103.131.231.255, ZJ
        [ 0x6783F000, 0x6783F3FF, "BJ" ],  // 103.131.240.0-103.131.243.255, BJ
        [ 0x67841600, 0x678417FF, "BJ" ],  // 103.132.22.0-103.132.23.255, BJ
        [ 0x67843C00, 0x67843FFF, "BJ" ],  // 103.132.60.0-103.132.63.255, BJ
        [ 0x67844000, 0x678443FF, "SX" ],  // 103.132.64.0-103.132.67.255, SX
        [ 0x67844400, 0x678453FF, "HE" ],  // 103.132.68.0-103.132.83.255, HE
        [ 0x67846800, 0x67846FFF, "JS" ],  // 103.132.104.0-103.132.111.255, JS
        [ 0x67847000, 0x678473FF, "FJ" ],  // 103.132.112.0-103.132.115.255, FJ
        [ 0x67847400, 0x678477FF, "SH" ],  // 103.132.116.0-103.132.119.255, SH
        [ 0x67847800, 0x67847BFF, "GD" ],  // 103.132.120.0-103.132.123.255, GD
        [ 0x6784BC00, 0x6784BFFF, "BJ" ],  // 103.132.188.0-103.132.191.255, BJ
        [ 0x6784D000, 0x6784D7FF, "SH" ],  // 103.132.208.0-103.132.215.255, SH
        [ 0x67850C00, 0x67850FFF, "ZJ" ],  // 103.133.12.0-103.133.15.255, ZJ
        [ 0x67852800, 0x67852BFF, "GD" ],  // 103.133.40.0-103.133.43.255, GD
        [ 0x67858000, 0x678583FF, "BJ" ],  // 103.133.128.0-103.133.131.255, BJ
        [ 0x6785E800, 0x6785EBFF, "HB" ],  // 103.133.232.0-103.133.235.255, HB
        [ 0x6786C400, 0x6786C7FF, "SC" ],  // 103.134.196.0-103.134.199.255, SC
        [ 0x6786E800, 0x6786E9FF, "AH" ],  // 103.134.232.0-103.134.233.255, AH
        [ 0x67875000, 0x678753FF, "NM" ],  // 103.135.80.0-103.135.83.255, NM
        [ 0x67877C00, 0x67877FFF, "BJ" ],  // 103.135.124.0-103.135.127.255, BJ
        [ 0x67879400, 0x678795FF, "JS" ],  // 103.135.148.0-103.135.149.255, JS
        [ 0x67879600, 0x678797FF, "SH" ],  // 103.135.150.0-103.135.151.255, SH
        [ 0x67879C00, 0x6787A0FF, "BJ" ],  // 103.135.156.0-103.135.160.255, BJ
        [ 0x6787A100, 0x6787A1FF, "AH" ],  // 103.135.161.0-103.135.161.255, AH
        [ 0x6787A200, 0x6787A7FF, "BJ" ],  // 103.135.162.0-103.135.167.255, BJ
        [ 0x6787B000, 0x6787B3FF, "SH" ],  // 103.135.176.0-103.135.179.255, SH
        [ 0x6787B800, 0x6787BBFF, "LN" ],  // 103.135.184.0-103.135.187.255, LN
        [ 0x6787C000, 0x6787C3FF, "SH" ],  // 103.135.192.0-103.135.195.255, SH
        [ 0x6787C400, 0x6787C7FF, "GD" ],  // 103.135.196.0-103.135.199.255, GD
        [ 0x6787EC00, 0x6787EFFF, "JX" ],  // 103.135.236.0-103.135.239.255, JX
        [ 0x67888000, 0x678883FF, "BJ" ],  // 103.136.128.0-103.136.131.255, BJ
        [ 0x6788E800, 0x6788EBFF, "ZJ" ],  // 103.136.232.0-103.136.235.255, ZJ
        [ 0x67893A00, 0x67893CFF, "BJ" ],  // 103.137.58.0-103.137.60.255, BJ
        [ 0x67894C00, 0x67894FFF, "GD" ],  // 103.137.76.0-103.137.79.255, GD
        [ 0x67898800, 0x678989FF, "JS" ],  // 103.137.136.0-103.137.137.255, JS
        [ 0x67899500, 0x678995FF, "BJ" ],  // 103.137.149.0-103.137.149.255, BJ
        [ 0x6789B400, 0x6789B7FF, "ZJ" ],  // 103.137.180.0-103.137.183.255, ZJ
        [ 0x6789EC00, 0x6789EFFF, "BJ" ],  // 103.137.236.0-103.137.239.255, BJ
        [ 0x678A0200, 0x678A03FF, "BJ" ],  // 103.138.2.0-103.138.3.255, BJ
        [ 0x678A0C00, 0x678A0DFF, "BJ" ],  // 103.138.12.0-103.138.13.255, BJ
        [ 0x678A4EA0, 0x678A4EBF, "GD" ],  // 103.138.78.160-103.138.78.191, GD
        [ 0x678A8600, 0x678A87FF, "BJ" ],  // 103.138.134.0-103.138.135.255, BJ
        [ 0x678A9C00, 0x678A9DFF, "BJ" ],  // 103.138.156.0-103.138.157.255, BJ
        [ 0x678AD000, 0x678AD1FF, "JL" ],  // 103.138.208.0-103.138.209.255, JL
        [ 0x678ADC00, 0x678ADDFF, "FJ" ],  // 103.138.220.0-103.138.221.255, FJ
        [ 0x678AF600, 0x678AF6FF, "JL" ],  // 103.138.246.0-103.138.246.255, JL
        [ 0x678AF800, 0x678AF9FF, "BJ" ],  // 103.138.248.0-103.138.249.255, BJ
        [ 0x678B1600, 0x678B17FF, "BJ" ],  // 103.139.22.0-103.139.23.255, BJ
        [ 0x678B5C00, 0x678B5DFF, "HA" ],  // 103.139.92.0-103.139.93.255, HA
        [ 0x678B7100, 0x678B71FF, "BJ" ],  // 103.139.113.0-103.139.113.255, BJ
        [ 0x678B8600, 0x678B89FF, "BJ" ],  // 103.139.134.0-103.139.137.255, BJ
        [ 0x678BAC00, 0x678BADFF, "JS" ],  // 103.139.172.0-103.139.173.255, JS
        [ 0x678BCC00, 0x678BCDFF, "BJ" ],  // 103.139.204.0-103.139.205.255, BJ
        [ 0x678BD400, 0x678BD5FF, "BJ" ],  // 103.139.212.0-103.139.213.255, BJ
        [ 0x678C0E00, 0x678C0FFF, "SH" ],  // 103.140.14.0-103.140.15.255, SH
        [ 0x678C8C00, 0x678C8DFF, "SH" ],  // 103.140.140.0-103.140.141.255, SH
        [ 0x678C9000, 0x678C91FF, "GD" ],  // 103.140.144.0-103.140.145.255, GD
        [ 0x678C9800, 0x678C99FF, "GD" ],  // 103.140.152.0-103.140.153.255, GD
        [ 0x678CC000, 0x678CC1FF, "BJ" ],  // 103.140.192.0-103.140.193.255, BJ
        [ 0x678D0A00, 0x678D0BFF, "BJ" ],  // 103.141.10.0-103.141.11.255, BJ
        [ 0x678D3A00, 0x678D3BFF, "HB" ],  // 103.141.58.0-103.141.59.255, HB
        [ 0x678D8000, 0x678D81FF, "BJ" ],  // 103.141.128.0-103.141.129.255, BJ
        [ 0x678DBA00, 0x678DBBFF, "GD" ],  // 103.141.186.0-103.141.187.255, GD
        [ 0x678DF200, 0x678DF3FF, "BJ" ],  // 103.141.242.0-103.141.243.255, BJ
        [ 0x678E1C00, 0x678E1DFF, "SN" ],  // 103.142.28.0-103.142.29.255, SN
        [ 0x678E3A00, 0x678E3BFF, "SH" ],  // 103.142.58.0-103.142.59.255, SH
        [ 0x678E5200, 0x678E5319, "GD" ],  // 103.142.82.0-103.142.83.25, GD
        [ 0x678E531A, 0x678E53FF, "BJ" ],  // 103.142.83.26-103.142.83.255, BJ
        [ 0x678E6000, 0x678E60FF, "AH" ],  // 103.142.96.0-103.142.96.255, AH
        [ 0x678E6100, 0x678E61FF, "SH" ],  // 103.142.97.0-103.142.97.255, SH
        [ 0x678E7A00, 0x678E7BFF, "SX" ],  // 103.142.122.0-103.142.123.255, SX
        [ 0x678E8000, 0x678E81FF, "JS" ],  // 103.142.128.0-103.142.129.255, JS
        [ 0x678E9A00, 0x678E9DFF, "BJ" ],  // 103.142.154.0-103.142.157.255, BJ
        [ 0x678EAC00, 0x678EADFF, "GD" ],  // 103.142.172.0-103.142.173.255, GD
        [ 0x678EB400, 0x678EB5FF, "BJ" ],  // 103.142.180.0-103.142.181.255, BJ
        [ 0x678EBA00, 0x678EBBFF, "HE" ],  // 103.142.186.0-103.142.187.255, HE
        [ 0x678EBE00, 0x678EBFFF, "GD" ],  // 103.142.190.0-103.142.191.255, GD
        [ 0x678EDC00, 0x678EDDFF, "GD" ],  // 103.142.220.0-103.142.221.255, GD
        [ 0x678EE600, 0x678EE6FF, "JL" ],  // 103.142.230.0-103.142.230.255, JL
        [ 0x678EEA00, 0x678EEBFF, "BJ" ],  // 103.142.234.0-103.142.235.255, BJ
        [ 0x678EEE00, 0x678EEFFF, "BJ" ],  // 103.142.238.0-103.142.239.255, BJ
        [ 0x678F1000, 0x678F13FF, "HE" ],  // 103.143.16.0-103.143.19.255, HE
        [ 0x678F4A00, 0x678F4BFF, "GD" ],  // 103.143.74.0-103.143.75.255, GD
        [ 0x678F7C00, 0x678F7DFF, "GD" ],  // 103.143.124.0-103.143.125.255, GD
        [ 0x678F8400, 0x678F85FF, "JX" ],  // 103.143.132.0-103.143.133.255, JX
        [ 0x678F8600, 0x678F87FF, "BJ" ],  // 103.143.134.0-103.143.135.255, BJ
        [ 0x678FAE00, 0x678FAFFF, "HA" ],  // 103.143.174.0-103.143.175.255, HA
        [ 0x678FE400, 0x678FE5FF, "BJ" ],  // 103.143.228.0-103.143.229.255, BJ
        [ 0x67903400, 0x679035FF, "BJ" ],  // 103.144.52.0-103.144.53.255, BJ
        [ 0x67904200, 0x679043FF, "SH" ],  // 103.144.66.0-103.144.67.255, SH
        [ 0x67904600, 0x679047FF, "BJ" ],  // 103.144.70.0-103.144.71.255, BJ
        [ 0x67904800, 0x679049FF, "GD" ],  // 103.144.72.0-103.144.73.255, GD
        [ 0x67906C00, 0x67906DFF, "HA" ],  // 103.144.108.0-103.144.109.255, HA
        [ 0x67908800, 0x679089FF, "BJ" ],  // 103.144.136.0-103.144.137.255, BJ
        [ 0x67909E00, 0x67909FFF, "SH" ],  // 103.144.158.0-103.144.159.255, SH
        [ 0x6790F000, 0x6790F1FF, "SH" ],  // 103.144.240.0-103.144.241.255, SH
        [ 0x67912800, 0x679128FF, "SH" ],  // 103.145.40.0-103.145.40.255, SH
        [ 0x67912A00, 0x67912BFF, "SH" ],  // 103.145.42.0-103.145.43.255, SH
        [ 0x67915600, 0x679156FF, "GD" ],  // 103.145.86.0-103.145.86.255, GD
        [ 0x67915E00, 0x67915FFF, "GD" ],  // 103.145.94.0-103.145.95.255, GD
        [ 0x67916200, 0x679163FF, "SH" ],  // 103.145.98.0-103.145.99.255, SH
        [ 0x67916B00, 0x67916BFF, "LN" ],  // 103.145.107.0-103.145.107.255, LN
        [ 0x6791BC00, 0x6791BDFF, "SD" ],  // 103.145.188.0-103.145.189.255, SD
        [ 0x6791BE00, 0x6791BEFF, "GD" ],  // 103.145.190.0-103.145.190.255, GD
        [ 0x6791BF00, 0x6791BFFF, "JS" ],  // 103.145.191.0-103.145.191.255, JS
        [ 0x67924800, 0x679249FF, "BJ" ],  // 103.146.72.0-103.146.73.255, BJ
        [ 0x67925B00, 0x67925BFF, "SH" ],  // 103.146.91.0-103.146.91.255, SH
        [ 0x67927C00, 0x67927CFF, "GD" ],  // 103.146.124.0-103.146.124.255, GD
        [ 0x67927E00, 0x67927FFF, "BJ" ],  // 103.146.126.0-103.146.127.255, BJ
        [ 0x67928A00, 0x67928BFF, "BJ" ],  // 103.146.138.0-103.146.139.255, BJ
        [ 0x6792E700, 0x6792E7FF, "GD" ],  // 103.146.231.0-103.146.231.255, GD
        [ 0x6792EC00, 0x6792EDFF, "ZJ" ],  // 103.146.236.0-103.146.237.255, ZJ
        [ 0x6792FC00, 0x6792FDFF, "XJ" ],  // 103.146.252.0-103.146.253.255, XJ
        [ 0x67930C00, 0x67930DFF, "ZJ" ],  // 103.147.12.0-103.147.13.255, ZJ
        [ 0x67937C00, 0x67937DFF, "SH" ],  // 103.147.124.0-103.147.125.255, SH
        [ 0x6793CE00, 0x6793CFFF, "BJ" ],  // 103.147.206.0-103.147.207.255, BJ
        [ 0x6794AE00, 0x6794AFFF, "BJ" ],  // 103.148.174.0-103.148.175.255, BJ
        [ 0x67950600, 0x679507FF, "SH" ],  // 103.149.6.0-103.149.7.255, SH
        [ 0x67951100, 0x679511FF, "BJ" ],  // 103.149.17.0-103.149.17.255, BJ
        [ 0x67952C00, 0x67952DFF, "BJ" ],  // 103.149.44.0-103.149.45.255, BJ
        [ 0x67959C00, 0x67959DFF, "SH" ],  // 103.149.156.0-103.149.157.255, SH
        [ 0x6795D200, 0x6795D3FF, "SH" ],  // 103.149.210.0-103.149.211.255, SH
        [ 0x6795D600, 0x6795D7FF, "BJ" ],  // 103.149.214.0-103.149.215.255, BJ
        [ 0x6795DC00, 0x6795DDFF, "BJ" ],  // 103.149.220.0-103.149.221.255, BJ
        [ 0x6795F200, 0x6795F3FF, "BJ" ],  // 103.149.242.0-103.149.243.255, BJ
        [ 0x6795F400, 0x6795F7FF, "HE" ],  // 103.149.244.0-103.149.247.255, HE
        [ 0x67960A00, 0x67960BFF, "JS" ],  // 103.150.10.0-103.150.11.255, JS
        [ 0x67961800, 0x679619FF, "SD" ],  // 103.150.24.0-103.150.25.255, SD
        [ 0x67964200, 0x679643FF, "ZJ" ],  // 103.150.66.0-103.150.67.255, ZJ
        [ 0x67964800, 0x679649FF, "BJ" ],  // 103.150.72.0-103.150.73.255, BJ
        [ 0x67967A00, 0x67967BFF, "BJ" ],  // 103.150.122.0-103.150.123.255, BJ
        [ 0x67967E00, 0x67967FFF, "HN" ],  // 103.150.126.0-103.150.127.255, HN
        [ 0x67968000, 0x679681FF, "BJ" ],  // 103.150.128.0-103.150.129.255, BJ
        [ 0x67968200, 0x679683FF, "SH" ],  // 103.150.130.0-103.150.131.255, SH
        [ 0x67969200, 0x679693FF, "BJ" ],  // 103.150.146.0-103.150.147.255, BJ
        [ 0x6796A400, 0x6796A5FF, "LN" ],  // 103.150.164.0-103.150.165.255, LN
        [ 0x6796AC00, 0x6796ACFF, "HN" ],  // 103.150.172.0-103.150.172.255, HN
        [ 0x6796AD00, 0x6796ADFF, "BJ" ],  // 103.150.173.0-103.150.173.255, BJ
        [ 0x6796C800, 0x6796C9FF, "BJ" ],  // 103.150.200.0-103.150.201.255, BJ
        [ 0x6796D200, 0x6796D3FF, "GD" ],  // 103.150.210.0-103.150.211.255, GD
        [ 0x6796D800, 0x6796D9FF, "GS" ],  // 103.150.216.0-103.150.217.255, GS
        [ 0x6796F400, 0x6796F5FF, "SH" ],  // 103.150.244.0-103.150.245.255, SH
        [ 0x67970400, 0x679705FF, "BJ" ],  // 103.151.4.0-103.151.5.255, BJ
        [ 0x67972C00, 0x67972DFF, "GD" ],  // 103.151.44.0-103.151.45.255, GD
        [ 0x67978E00, 0x67978FFF, "SD" ],  // 103.151.142.0-103.151.143.255, SD
        [ 0x67979400, 0x679795FF, "BJ" ],  // 103.151.148.0-103.151.149.255, BJ
        [ 0x67979E00, 0x67979FFF, "JS" ],  // 103.151.158.0-103.151.159.255, JS
        [ 0x6797CE00, 0x6797CFFF, "JX" ],  // 103.151.206.0-103.151.207.255, JX
        [ 0x67981900, 0x679819FF, "SH" ],  // 103.152.25.0-103.152.25.255, SH
        [ 0x67981C00, 0x67981FFF, "BJ" ],  // 103.152.28.0-103.152.31.255, BJ
        [ 0x67983800, 0x679839FF, "BJ" ],  // 103.152.56.0-103.152.57.255, BJ
        [ 0x67984C00, 0x67984DFF, "GS" ],  // 103.152.76.0-103.152.77.255, GS
        [ 0x67987800, 0x679879FF, "SH" ],  // 103.152.120.0-103.152.121.255, SH
        [ 0x67987A00, 0x67987BFF, "BJ" ],  // 103.152.122.0-103.152.123.255, BJ
        [ 0x67989800, 0x679899FF, "BJ" ],  // 103.152.152.0-103.152.153.255, BJ
        [ 0x6798A800, 0x6798A9FF, "SN" ],  // 103.152.168.0-103.152.169.255, SN
        [ 0x6798BA00, 0x6798BBFF, "LN" ],  // 103.152.186.0-103.152.187.255, LN
        [ 0x6798BE00, 0x6798C1FF, "GD" ],  // 103.152.190.0-103.152.193.255, GD
        [ 0x6798C800, 0x6798C9FF, "GD" ],  // 103.152.200.0-103.152.201.255, GD
        [ 0x6798D000, 0x6798D1FF, "JL" ],  // 103.152.208.0-103.152.209.255, JL
        [ 0x6798E000, 0x6798E1FF, "BJ" ],  // 103.152.224.0-103.152.225.255, BJ
        [ 0x6798F600, 0x6798F6FF, "BJ" ],  // 103.152.246.0-103.152.246.255, BJ
        [ 0x6798FA00, 0x6798FBFF, "SH" ],  // 103.152.250.0-103.152.251.255, SH
        [ 0x67990400, 0x679905FF, "GD" ],  // 103.153.4.0-103.153.5.255, GD
        [ 0x67992400, 0x679925FF, "FJ" ],  // 103.153.36.0-103.153.37.255, FJ
        [ 0x67997200, 0x679973FF, "HN" ],  // 103.153.114.0-103.153.115.255, HN
        [ 0x67997A00, 0x67997BFF, "HN" ],  // 103.153.122.0-103.153.123.255, HN
        [ 0x67998000, 0x679981FF, "JS" ],  // 103.153.128.0-103.153.129.255, JS
        [ 0x67998400, 0x679985FF, "LN" ],  // 103.153.132.0-103.153.133.255, LN
        [ 0x67998A00, 0x67998BFF, "FJ" ],  // 103.153.138.0-103.153.139.255, FJ
        [ 0x67999200, 0x679993FF, "BJ" ],  // 103.153.146.0-103.153.147.255, BJ
        [ 0x6799A000, 0x6799A1FF, "SH" ],  // 103.153.160.0-103.153.161.255, SH
        [ 0x679A1200, 0x679A13FF, "SH" ],  // 103.154.18.0-103.154.19.255, SH
        [ 0x679A1E00, 0x679A1FFF, "BJ" ],  // 103.154.30.0-103.154.31.255, BJ
        [ 0x679A2000, 0x679A21FF, "ZJ" ],  // 103.154.32.0-103.154.33.255, ZJ
        [ 0x679A2800, 0x679A29FF, "ZJ" ],  // 103.154.40.0-103.154.41.255, ZJ
        [ 0x679A4200, 0x679A43FF, "BJ" ],  // 103.154.66.0-103.154.67.255, BJ
        [ 0x679AA200, 0x679AA3FF, "SD" ],  // 103.154.162.0-103.154.163.255, SD
        [ 0x679AA400, 0x679AA5FF, "BJ" ],  // 103.154.164.0-103.154.165.255, BJ
        [ 0x679AA800, 0x679AA9FF, "GD" ],  // 103.154.168.0-103.154.169.255, GD
        [ 0x679B0E00, 0x679B0FFF, "LN" ],  // 103.155.14.0-103.155.15.255, LN
        [ 0x679B2200, 0x679B23FF, "TJ" ],  // 103.155.34.0-103.155.35.255, TJ
        [ 0x679B3000, 0x679B31FF, "SH" ],  // 103.155.48.0-103.155.49.255, SH
        [ 0x679B4C00, 0x679B4DFF, "BJ" ],  // 103.155.76.0-103.155.77.255, BJ
        [ 0x679B6E00, 0x679B6FFF, "FJ" ],  // 103.155.110.0-103.155.111.255, FJ
        [ 0x679B7800, 0x679B79FF, "ZJ" ],  // 103.155.120.0-103.155.121.255, ZJ
        [ 0x679BD600, 0x679BD7FF, "GD" ],  // 103.155.214.0-103.155.215.255, GD
        [ 0x679BF800, 0x679BF9FF, "SH" ],  // 103.155.248.0-103.155.249.255, SH
        [ 0x679C1C00, 0x679C1DFF, "GD" ],  // 103.156.28.0-103.156.29.255, GD
        [ 0x679C4400, 0x679C45FF, "SH" ],  // 103.156.68.0-103.156.69.255, SH
        [ 0x679C4E00, 0x679C4FFF, "GD" ],  // 103.156.78.0-103.156.79.255, GD
        [ 0x679C6800, 0x679C69FF, "JS" ],  // 103.156.104.0-103.156.105.255, JS
        [ 0x679C9E00, 0x679C9FFF, "SH" ],  // 103.156.158.0-103.156.159.255, SH
        [ 0x679CAE00, 0x679CAFFF, "HL" ],  // 103.156.174.0-103.156.175.255, HL
        [ 0x679CBA00, 0x679CBBFF, "HL" ],  // 103.156.186.0-103.156.187.255, HL
        [ 0x679CE400, 0x679CE5FF, "SD" ],  // 103.156.228.0-103.156.229.255, SD
        [ 0x679D1E00, 0x679D1FFF, "BJ" ],  // 103.157.30.0-103.157.31.255, BJ
        [ 0x679D8A00, 0x679D8BFF, "FJ" ],  // 103.157.138.0-103.157.139.255, FJ
        [ 0x679DAE00, 0x679DAFFF, "ZJ" ],  // 103.157.174.0-103.157.175.255, ZJ
        [ 0x679DD400, 0x679DD5FF, "ZJ" ],  // 103.157.212.0-103.157.213.255, ZJ
        [ 0x679DEA00, 0x679DEBFF, "SC" ],  // 103.157.234.0-103.157.235.255, SC
        [ 0x679DFE00, 0x679DFFFF, "SH" ],  // 103.157.254.0-103.157.255.255, SH
        [ 0x679E0000, 0x679E01FF, "BJ" ],  // 103.158.0.0-103.158.1.255, BJ
        [ 0x679E0800, 0x679E09FF, "GD" ],  // 103.158.8.0-103.158.9.255, GD
        [ 0x679E1000, 0x679E11FF, "SD" ],  // 103.158.16.0-103.158.17.255, SD
        [ 0x679EC800, 0x679EC9FF, "JS" ],  // 103.158.200.0-103.158.201.255, JS
        [ 0x679EE000, 0x679EE1FF, "FJ" ],  // 103.158.224.0-103.158.225.255, FJ
        [ 0x679F5000, 0x679F50FF, "BJ" ],  // 103.159.80.0-103.159.80.255, BJ
        [ 0x679F7A00, 0x679F7BFF, "SH" ],  // 103.159.122.0-103.159.123.255, SH
        [ 0x679F7C00, 0x679F7DFF, "BJ" ],  // 103.159.124.0-103.159.125.255, BJ
        [ 0x679F8600, 0x679F87FF, "BJ" ],  // 103.159.134.0-103.159.135.255, BJ
        [ 0x679F8E00, 0x679F8FFF, "BJ" ],  // 103.159.142.0-103.159.143.255, BJ
        [ 0x67A02000, 0x67A021FF, "SC" ],  // 103.160.32.0-103.160.33.255, SC
        [ 0x67A02200, 0x67A023FF, "JS" ],  // 103.160.34.0-103.160.35.255, JS
        [ 0x67A07000, 0x67A071FF, "LN" ],  // 103.160.112.0-103.160.113.255, LN
        [ 0x67A07200, 0x67A073FF, "SD" ],  // 103.160.114.0-103.160.115.255, SD
        [ 0x67A0F400, 0x67A0F5FF, "SH" ],  // 103.160.244.0-103.160.245.255, SH
        [ 0x67A0FE00, 0x67A0FFFF, "ZJ" ],  // 103.160.254.0-103.160.255.255, ZJ
        [ 0x67A10E00, 0x67A10FFF, "BJ" ],  // 103.161.14.0-103.161.15.255, BJ
        [ 0x67A16600, 0x67A167FF, "SD" ],  // 103.161.102.0-103.161.103.255, SD
        [ 0x67A18A00, 0x67A18BFF, "SH" ],  // 103.161.138.0-103.161.139.255, SH
        [ 0x67A1D000, 0x67A1D1FF, "JS" ],  // 103.161.208.0-103.161.209.255, JS
        [ 0x67A1DC00, 0x67A1DDFF, "GD" ],  // 103.161.220.0-103.161.221.255, GD
        [ 0x67A1FE00, 0x67A1FFFF, "GD" ],  // 103.161.254.0-103.161.255.255, GD
        [ 0x67A20A00, 0x67A20BFF, "BJ" ],  // 103.162.10.0-103.162.11.255, BJ
        [ 0x67A22000, 0x67A221FF, "GZ" ],  // 103.162.32.0-103.162.33.255, GZ
        [ 0x67A27400, 0x67A275FF, "FJ" ],  // 103.162.116.0-103.162.117.255, FJ
        [ 0x67A31C00, 0x67A31DFF, "GD" ],  // 103.163.28.0-103.163.29.255, GD
        [ 0x67A32000, 0x67A321FF, "BJ" ],  // 103.163.32.0-103.163.33.255, BJ
        [ 0x67A32E00, 0x67A32FFF, "HL" ],  // 103.163.46.0-103.163.47.255, HL
        [ 0x67A34A00, 0x67A34BFF, "HE" ],  // 103.163.74.0-103.163.75.255, HE
        [ 0x67A3B400, 0x67A3B5FF, "HB" ],  // 103.163.180.0-103.163.181.255, HB
        [ 0x67A40400, 0x67A405FF, "AH" ],  // 103.164.4.0-103.164.5.255, AH
        [ 0x67A42000, 0x67A421FF, "SH" ],  // 103.164.32.0-103.164.33.255, SH
        [ 0x67A42800, 0x67A429FF, "GD" ],  // 103.164.40.0-103.164.41.255, GD
        [ 0x67A42A00, 0x67A42BFF, "SC" ],  // 103.164.42.0-103.164.43.255, SC
        [ 0x67A44000, 0x67A441FF, "ZJ" ],  // 103.164.64.0-103.164.65.255, ZJ
        [ 0x67A44C00, 0x67A44DFF, "SC" ],  // 103.164.76.0-103.164.77.255, SC
        [ 0x67A4B200, 0x67A4B3FF, "BJ" ],  // 103.164.178.0-103.164.179.255, BJ
        [ 0x67A52C00, 0x67A52DFF, "SD" ],  // 103.165.44.0-103.165.45.255, SD
        [ 0x67A53400, 0x67A535FF, "HN" ],  // 103.165.52.0-103.165.53.255, HN
        [ 0x67A55200, 0x67A553FF, "LN" ],  // 103.165.82.0-103.165.83.255, LN
        [ 0x67A56E00, 0x67A56FFF, "BJ" ],  // 103.165.110.0-103.165.111.255, BJ
        [ 0x67A61400, 0x67A615FF, "ZJ" ],  // 103.166.20.0-103.166.21.255, ZJ
        [ 0x67A63200, 0x67A635FF, "GD" ],  // 103.166.50.0-103.166.53.255, GD
        [ 0x67A63600, 0x67A637FF, "BJ" ],  // 103.166.54.0-103.166.55.255, BJ
        [ 0x67A65400, 0x67A655FF, "GD" ],  // 103.166.84.0-103.166.85.255, GD
        [ 0x67A68A00, 0x67A68BFF, "JL" ],  // 103.166.138.0-103.166.139.255, JL
        [ 0x67A6F700, 0x67A6F7FF, "JS" ],  // 103.166.247.0-103.166.247.255, JS
        [ 0x67A70000, 0x67A701FF, "BJ" ],  // 103.167.0.0-103.167.1.255, BJ
        [ 0x67A72400, 0x67A725FF, "SC" ],  // 103.167.36.0-103.167.37.255, SC
        [ 0x67A76400, 0x67A765FF, "ZJ" ],  // 103.167.100.0-103.167.101.255, ZJ
        [ 0x67A86200, 0x67A863FF, "GD" ],  // 103.168.98.0-103.168.99.255, GD
        [ 0x67A8AA00, 0x67A8ABFF, "SH" ],  // 103.168.170.0-103.168.171.255, SH
        [ 0x67A93200, 0x67A933FF, "SH" ],  // 103.169.50.0-103.169.51.255, SH
        [ 0x67A93E00, 0x67A93FFF, "HB" ],  // 103.169.62.0-103.169.63.255, HB
        [ 0x67A96C00, 0x67A96DFF, "SH" ],  // 103.169.108.0-103.169.109.255, SH
        [ 0x67A9A200, 0x67A9A3FF, "GX" ],  // 103.169.162.0-103.169.163.255, GX
        [ 0x67A9CA00, 0x67A9CBFF, "BJ" ],  // 103.169.202.0-103.169.203.255, BJ
        [ 0x67AA0400, 0x67AA05FF, "GD" ],  // 103.170.4.0-103.170.5.255, GD
        [ 0x67AA8600, 0x67AA87FF, "TJ" ],  // 103.170.134.0-103.170.135.255, TJ
        [ 0x67AAD400, 0x67AAD5FF, "SH" ],  // 103.170.212.0-103.170.213.255, SH
        [ 0x67AB2000, 0x67AB21FF, "BJ" ],  // 103.171.32.0-103.171.33.255, BJ
        [ 0x67ABA600, 0x67ABA6FF, "GD" ],  // 103.171.166.0-103.171.166.255, GD
        [ 0x67ABD600, 0x67ABD7FF, "TJ" ],  // 103.171.214.0-103.171.215.255, TJ
        [ 0x67AC2000, 0x67AC21FF, "AH" ],  // 103.172.32.0-103.172.33.255, AH
        [ 0x67ACA000, 0x67ACA1FF, "ZJ" ],  // 103.172.160.0-103.172.161.255, ZJ
        [ 0x67ACBF00, 0x67ACBFFF, "GD" ],  // 103.172.191.0-103.172.191.255, GD
        [ 0x67AD6600, 0x67AD67FF, "BJ" ],  // 103.173.102.0-103.173.103.255, BJ
        [ 0x67ADB600, 0x67ADB7FF, "BJ" ],  // 103.173.182.0-103.173.183.255, BJ
        [ 0x67ADB800, 0x67ADB9FF, "SH" ],  // 103.173.184.0-103.173.185.255, SH
        [ 0x67AE5E00, 0x67AE5FFF, "BJ" ],  // 103.174.94.0-103.174.95.255, BJ
        [ 0x67AF7200, 0x67AF73FF, "SH" ],  // 103.175.114.0-103.175.115.255, SH
        [ 0x67AF7600, 0x67AF77FF, "NX" ],  // 103.175.118.0-103.175.119.255, NX
        [ 0x67B03400, 0x67B035FF, "BJ" ],  // 103.176.52.0-103.176.53.255, BJ
        [ 0x67B0DE00, 0x67B0DFFF, "HN" ],  // 103.176.222.0-103.176.223.255, HN
        [ 0x67B0F400, 0x67B0F5FF, "HL" ],  // 103.176.244.0-103.176.245.255, HL
        [ 0x67B11C00, 0x67B11DFF, "SH" ],  // 103.177.28.0-103.177.29.255, SH
        [ 0x67B14600, 0x67B147FF, "BJ" ],  // 103.177.70.0-103.177.71.255, BJ
        [ 0x67B1A200, 0x67B1A2FF, "GD" ],  // 103.177.162.0-103.177.162.255, GD
        [ 0x67B23800, 0x67B238FF, "GD" ],  // 103.178.56.0-103.178.56.255, GD
        [ 0x67B2F000, 0x67B2F1FF, "QH" ],  // 103.178.240.0-103.178.241.255, QH
        [ 0x67B34C00, 0x67B34DFF, "LN" ],  // 103.179.76.0-103.179.77.255, LN
        [ 0x67B34E00, 0x67B34FFF, "SH" ],  // 103.179.78.0-103.179.79.255, SH
        [ 0x67B4E200, 0x67B4E3FF, "HN" ],  // 103.180.226.0-103.180.227.255, HN
        [ 0x67B5EA00, 0x67B5EBFF, "GD" ],  // 103.181.234.0-103.181.235.255, GD
        [ 0x67B71A00, 0x67B71BFF, "SH" ],  // 103.183.26.0-103.183.27.255, SH
        [ 0x67B74200, 0x67B743FF, "SH" ],  // 103.183.66.0-103.183.67.255, SH
        [ 0x67B77A00, 0x67B77DFF, "JS" ],  // 103.183.122.0-103.183.125.255, JS
        [ 0x67B82C00, 0x67B82DFF, "JX" ],  // 103.184.44.0-103.184.45.255, JX
        [ 0x67B82E00, 0x67B82FFF, "HB" ],  // 103.184.46.0-103.184.47.255, HB
        [ 0x67B83C00, 0x67B83DFF, "BJ" ],  // 103.184.60.0-103.184.61.255, BJ
        [ 0x67B94E00, 0x67B951FF, "TJ" ],  // 103.185.78.0-103.185.81.255, TJ
        [ 0x67BA0400, 0x67BA05FF, "AH" ],  // 103.186.4.0-103.186.5.255, AH
        [ 0x67BA6C00, 0x67BA6DFF, "GD" ],  // 103.186.108.0-103.186.109.255, GD
        [ 0x67BA8800, 0x67BA89FF, "GD" ],  // 103.186.136.0-103.186.137.255, GD
        [ 0x67BA9E00, 0x67BA9FFF, "HA" ],  // 103.186.158.0-103.186.159.255, HA
        [ 0x67BAE400, 0x67BAE5FF, "HE" ],  // 103.186.228.0-103.186.229.255, HE
        [ 0x67BD5C00, 0x67BD5DFF, "AH" ],  // 103.189.92.0-103.189.93.255, AH
        [ 0x67BD9800, 0x67BD99FF, "SD" ],  // 103.189.152.0-103.189.153.255, SD
        [ 0x67BD9A00, 0x67BD9BFF, "GD" ],  // 103.189.154.0-103.189.155.255, GD
        [ 0x67BE1400, 0x67BE15FF, "BJ" ],  // 103.190.20.0-103.190.21.255, BJ
        [ 0x67BE4700, 0x67BE47FF, "SH" ],  // 103.190.71.0-103.190.71.255, SH
        [ 0x67BE6800, 0x67BE69FF, "BJ" ],  // 103.190.104.0-103.190.105.255, BJ
        [ 0x67BE7400, 0x67BE75FF, "TJ" ],  // 103.190.116.0-103.190.117.255, TJ
        [ 0x67BE7600, 0x67BE77FF, "GD" ],  // 103.190.118.0-103.190.119.255, GD
        [ 0x67BE7A00, 0x67BE7BFF, "SH" ],  // 103.190.122.0-103.190.123.255, SH
        [ 0x67BF6600, 0x67BF67FF, "SH" ],  // 103.191.102.0-103.191.103.255, SH
        [ 0x67BFF200, 0x67BFF3FF, "GD" ],  // 103.191.242.0-103.191.243.255, GD
        [ 0x67C00000, 0x67C007FF, "JS" ],  // 103.192.0.0-103.192.7.255, JS
        [ 0x67C00800, 0x67C00BFF, "SX" ],  // 103.192.8.0-103.192.11.255, SX
        [ 0x67C00C00, 0x67C00FFF, "JS" ],  // 103.192.12.0-103.192.15.255, JS
        [ 0x67C01000, 0x67C013FF, "GD" ],  // 103.192.16.0-103.192.19.255, GD
        [ 0x67C01400, 0x67C017FF, "ZJ" ],  // 103.192.20.0-103.192.23.255, ZJ
        [ 0x67C01800, 0x67C01BFF, "HB" ],  // 103.192.24.0-103.192.27.255, HB
        [ 0x67C01C00, 0x67C01FFF, "JL" ],  // 103.192.28.0-103.192.31.255, JL
        [ 0x67C03000, 0x67C033FF, "GD" ],  // 103.192.48.0-103.192.51.255, GD
        [ 0x67C03400, 0x67C037FF, "AH" ],  // 103.192.52.0-103.192.55.255, AH
        [ 0x67C03800, 0x67C03BFF, "JS" ],  // 103.192.56.0-103.192.59.255, JS
        [ 0x67C05400, 0x67C057FF, "HA" ],  // 103.192.84.0-103.192.87.255, HA
        [ 0x67C05800, 0x67C05BFF, "CQ" ],  // 103.192.88.0-103.192.91.255, CQ
        [ 0x67C05C00, 0x67C063FF, "SD" ],  // 103.192.92.0-103.192.99.255, SD
        [ 0x67C06400, 0x67C067FF, "HN" ],  // 103.192.100.0-103.192.103.255, HN
        [ 0x67C06800, 0x67C06BFF, "CQ" ],  // 103.192.104.0-103.192.107.255, CQ
        [ 0x67C06C00, 0x67C06FFF, "BJ" ],  // 103.192.108.0-103.192.111.255, BJ
        [ 0x67C07000, 0x67C073FF, "CQ" ],  // 103.192.112.0-103.192.115.255, CQ
        [ 0x67C08000, 0x67C083FF, "HN" ],  // 103.192.128.0-103.192.131.255, HN
        [ 0x67C08400, 0x67C087FF, "SN" ],  // 103.192.132.0-103.192.135.255, SN
        [ 0x67C08800, 0x67C093FF, "BJ" ],  // 103.192.136.0-103.192.147.255, BJ
        [ 0x67C0A400, 0x67C0A7FF, "BJ" ],  // 103.192.164.0-103.192.167.255, BJ
        [ 0x67C0BC00, 0x67C0BFFF, "JS" ],  // 103.192.188.0-103.192.191.255, JS
        [ 0x67C0D000, 0x67C0D3FF, "ZJ" ],  // 103.192.208.0-103.192.211.255, ZJ
        [ 0x67C0D400, 0x67C0D7FF, "SH" ],  // 103.192.212.0-103.192.215.255, SH
        [ 0x67C0D800, 0x67C0DBFF, "GD" ],  // 103.192.216.0-103.192.219.255, GD
        [ 0x67C0FC00, 0x67C0FFFF, "SH" ],  // 103.192.252.0-103.192.255.255, SH
        [ 0x67C12800, 0x67C12BFF, "GD" ],  // 103.193.40.0-103.193.43.255, GD
        [ 0x67C12C00, 0x67C12FFF, "BJ" ],  // 103.193.44.0-103.193.47.255, BJ
        [ 0x67C17800, 0x67C17BFF, "SH" ],  // 103.193.120.0-103.193.123.255, SH
        [ 0x67C18C00, 0x67C18FFF, "BJ" ],  // 103.193.140.0-103.193.143.255, BJ
        [ 0x67C1A000, 0x67C1A3FF, "BJ" ],  // 103.193.160.0-103.193.163.255, BJ
        [ 0x67C1BC00, 0x67C1C3FF, "NM" ],  // 103.193.188.0-103.193.195.255, NM
        [ 0x67C1D400, 0x67C1D7FF, "BJ" ],  // 103.193.212.0-103.193.215.255, BJ
        [ 0x67C1D800, 0x67C1DBFF, "SH" ],  // 103.193.216.0-103.193.219.255, SH
        [ 0x67C1DC00, 0x67C1EFFF, "GD" ],  // 103.193.220.0-103.193.239.255, GD
        [ 0x67C36800, 0x67C36BFF, "BJ" ],  // 103.195.104.0-103.195.107.255, BJ
        [ 0x67C37000, 0x67C373FF, "JX" ],  // 103.195.112.0-103.195.115.255, JX
        [ 0x67C39400, 0x67C394FF, "GD" ],  // 103.195.148.0-103.195.148.255, GD
        [ 0x67C39500, 0x67C397FF, "GX" ],  // 103.195.149.0-103.195.151.255, GX
        [ 0x67C39800, 0x67C39BFF, "BJ" ],  // 103.195.152.0-103.195.155.255, BJ
        [ 0x67C3A000, 0x67C3A3FF, "HE" ],  // 103.195.160.0-103.195.163.255, HE
        [ 0x67C43000, 0x67C433FF, "BJ" ],  // 103.196.48.0-103.196.51.255, BJ
        [ 0x67C44000, 0x67C443FF, "ZJ" ],  // 103.196.64.0-103.196.67.255, ZJ
        [ 0x67C44800, 0x67C44BFF, "BJ" ],  // 103.196.72.0-103.196.75.255, BJ
        [ 0x67C45800, 0x67C463FF, "BJ" ],  // 103.196.88.0-103.196.99.255, BJ
        [ 0x67C4A800, 0x67C4ABFF, "BJ" ],  // 103.196.168.0-103.196.171.255, BJ
        [ 0x67C4CC00, 0x67C4CFFF, "SH" ],  // 103.196.204.0-103.196.207.255, SH
        [ 0x67C50000, 0x67C503FF, "GD" ],  // 103.197.0.0-103.197.3.255, GD
        [ 0x67C5B400, 0x67C5B4FF, "GD" ],  // 103.197.180.0-103.197.180.255, GD
        [ 0x67C5B500, 0x67C5B7FF, "HA" ],  // 103.197.181.0-103.197.183.255, HA
        [ 0x67C5E400, 0x67C5E7FF, "SN" ],  // 103.197.228.0-103.197.231.255, SN
        [ 0x67C61400, 0x67C617FF, "SH" ],  // 103.198.20.0-103.198.23.255, SH
        [ 0x67C63C00, 0x67C63FFF, "BJ" ],  // 103.198.60.0-103.198.63.255, BJ
        [ 0x67C64000, 0x67C643FF, "SD" ],  // 103.198.64.0-103.198.67.255, SD
        [ 0x67C64800, 0x67C64BFF, "SD" ],  // 103.198.72.0-103.198.75.255, SD
        [ 0x67C67C00, 0x67C67FFF, "SH" ],  // 103.198.124.0-103.198.127.255, SH
        [ 0x67C69C00, 0x67C69FFF, "GD" ],  // 103.198.156.0-103.198.159.255, GD
        [ 0x67C6B400, 0x67C6B7FF, "SN" ],  // 103.198.180.0-103.198.183.255, SN
        [ 0x67C6C400, 0x67C6C7FF, "BJ" ],  // 103.198.196.0-103.198.199.255, BJ
        [ 0x67C6D800, 0x67C6EFFF, "SH" ],  // 103.198.216.0-103.198.239.255, SH
        [ 0x67C6F100, 0x67C6F1FF, "SH" ],  // 103.198.241.0-103.198.241.255, SH
        [ 0x67C6F300, 0x67C6F7FF, "SH" ],  // 103.198.243.0-103.198.247.255, SH
        [ 0x67C7A400, 0x67C7A7FF, "SH" ],  // 103.199.164.0-103.199.167.255, SH
        [ 0x67C7C400, 0x67C7C7FF, "BJ" ],  // 103.199.196.0-103.199.199.255, BJ
        [ 0x67C7E400, 0x67C7E7FF, "BJ" ],  // 103.199.228.0-103.199.231.255, BJ
        [ 0x67C7F800, 0x67C7FBFF, "JS" ],  // 103.199.248.0-103.199.251.255, JS
        [ 0x67C7FC00, 0x67C7FFFF, "SH" ],  // 103.199.252.0-103.199.255.255, SH
        [ 0x67C83400, 0x67C837FF, "SC" ],  // 103.200.52.0-103.200.55.255, SC
        [ 0x67C84000, 0x67C847FF, "BJ" ],  // 103.200.64.0-103.200.71.255, BJ
        [ 0x67C88800, 0x67C897FF, "SH" ],  // 103.200.136.0-103.200.151.255, SH
        [ 0x67C89800, 0x67C89BFF, "SC" ],  // 103.200.152.0-103.200.155.255, SC
        [ 0x67C89C00, 0x67C8C3FF, "BJ" ],  // 103.200.156.0-103.200.195.255, BJ
        [ 0x67C8DC00, 0x67C8E7FF, "BJ" ],  // 103.200.220.0-103.200.231.255, BJ
        [ 0x67C8E800, 0x67C8F3FF, "GD" ],  // 103.200.232.0-103.200.243.255, GD
        [ 0x67C8F400, 0x67C8FBFF, "AH" ],  // 103.200.244.0-103.200.251.255, AH
        [ 0x67C8FC00, 0x67C903FF, "BJ" ],  // 103.200.252.0-103.201.3.255, BJ
        [ 0x67C90400, 0x67C907FF, "AH" ],  // 103.201.4.0-103.201.7.255, AH
        [ 0x67C90800, 0x67C90BFF, "BJ" ],  // 103.201.8.0-103.201.11.255, BJ
        [ 0x67C90C00, 0x67C90FFF, "ZJ" ],  // 103.201.12.0-103.201.15.255, ZJ
        [ 0x67C91000, 0x67C913FF, "HN" ],  // 103.201.16.0-103.201.19.255, HN
        [ 0x67C91400, 0x67C917FF, "HB" ],  // 103.201.20.0-103.201.23.255, HB
        [ 0x67C91C00, 0x67C91FFF, "JL" ],  // 103.201.28.0-103.201.31.255, JL
        [ 0x67C92000, 0x67C923FF, "ZJ" ],  // 103.201.32.0-103.201.35.255, ZJ
        [ 0x67C92400, 0x67C927FF, "GD" ],  // 103.201.36.0-103.201.39.255, GD
        [ 0x67C92800, 0x67C92BFF, "BJ" ],  // 103.201.40.0-103.201.43.255, BJ
        [ 0x67C92C00, 0x67C92FFF, "HB" ],  // 103.201.44.0-103.201.47.255, HB
        [ 0x67C93000, 0x67C933FF, "YN" ],  // 103.201.48.0-103.201.51.255, YN
        [ 0x67C93400, 0x67C937FF, "JS" ],  // 103.201.52.0-103.201.55.255, JS
        [ 0x67C93800, 0x67C93BFF, "GS" ],  // 103.201.56.0-103.201.59.255, GS
        [ 0x67C93C00, 0x67C943FF, "BJ" ],  // 103.201.60.0-103.201.67.255, BJ
        [ 0x67C94C00, 0x67C94FFF, "HN" ],  // 103.201.76.0-103.201.79.255, HN
        [ 0x67C95000, 0x67C953FF, "HA" ],  // 103.201.80.0-103.201.83.255, HA
        [ 0x67C95400, 0x67C957FF, "JX" ],  // 103.201.84.0-103.201.87.255, JX
        [ 0x67C95800, 0x67C95BFF, "BJ" ],  // 103.201.88.0-103.201.91.255, BJ
        [ 0x67C95C00, 0x67C95FFF, "HA" ],  // 103.201.92.0-103.201.95.255, HA
        [ 0x67C96000, 0x67C963FF, "HE" ],  // 103.201.96.0-103.201.99.255, HE
        [ 0x67C96400, 0x67C967FF, "GD" ],  // 103.201.100.0-103.201.103.255, GD
        [ 0x67C96800, 0x67C96BFF, "ZJ" ],  // 103.201.104.0-103.201.107.255, ZJ
        [ 0x67C96C00, 0x67C96FFF, "BJ" ],  // 103.201.108.0-103.201.111.255, BJ
        [ 0x67C97000, 0x67C973FF, "HI" ],  // 103.201.112.0-103.201.115.255, HI
        [ 0x67C97400, 0x67C977FF, "GD" ],  // 103.201.116.0-103.201.119.255, GD
        [ 0x67C97800, 0x67C97BFF, "BJ" ],  // 103.201.120.0-103.201.123.255, BJ
        [ 0x67C99800, 0x67C99BFF, "BJ" ],  // 103.201.152.0-103.201.155.255, BJ
        [ 0x67C99C00, 0x67C99FFF, "GD" ],  // 103.201.156.0-103.201.159.255, GD
        [ 0x67C9A000, 0x67C9A3FF, "ZJ" ],  // 103.201.160.0-103.201.163.255, ZJ
        [ 0x67C9A400, 0x67C9A7FF, "LN" ],  // 103.201.164.0-103.201.167.255, LN
        [ 0x67C9A800, 0x67C9ABFF, "BJ" ],  // 103.201.168.0-103.201.171.255, BJ
        [ 0x67C9AC00, 0x67C9AFFF, "SX" ],  // 103.201.172.0-103.201.175.255, SX
        [ 0x67C9B000, 0x67C9B3FF, "BJ" ],  // 103.201.176.0-103.201.179.255, BJ
        [ 0x67C9B400, 0x67C9B7FF, "JS" ],  // 103.201.180.0-103.201.183.255, JS
        [ 0x67C9B800, 0x67C9BBFF, "HE" ],  // 103.201.184.0-103.201.187.255, HE
        [ 0x67C9BC00, 0x67C9BFFF, "TJ" ],  // 103.201.188.0-103.201.191.255, TJ
        [ 0x67C9C000, 0x67C9CFFF, "BJ" ],  // 103.201.192.0-103.201.207.255, BJ
        [ 0x67C9D000, 0x67C9D7FF, "SH" ],  // 103.201.208.0-103.201.215.255, SH
        [ 0x67C9D800, 0x67C9DBFF, "AH" ],  // 103.201.216.0-103.201.219.255, AH
        [ 0x67C9DC00, 0x67C9DFFF, "ZJ" ],  // 103.201.220.0-103.201.223.255, ZJ
        [ 0x67C9E000, 0x67C9E3FF, "HB" ],  // 103.201.224.0-103.201.227.255, HB
        [ 0x67C9E400, 0x67C9EBFF, "BJ" ],  // 103.201.228.0-103.201.235.255, BJ
        [ 0x67C9EC00, 0x67C9F3FF, "JS" ],  // 103.201.236.0-103.201.243.255, JS
        [ 0x67C9F400, 0x67C9F7FF, "HB" ],  // 103.201.244.0-103.201.247.255, HB
        [ 0x67C9F800, 0x67C9FBFF, "ZJ" ],  // 103.201.248.0-103.201.251.255, ZJ
        [ 0x67C9FC00, 0x67C9FFFF, "HN" ],  // 103.201.252.0-103.201.255.255, HN
        [ 0x67CA0000, 0x67CA0FFF, "SH" ],  // 103.202.0.0-103.202.15.255, SH
        [ 0x67CA1000, 0x67CA13FF, "ZJ" ],  // 103.202.16.0-103.202.19.255, ZJ
        [ 0x67CA1400, 0x67CA2FFF, "SH" ],  // 103.202.20.0-103.202.47.255, SH
        [ 0x67CA3800, 0x67CA5BFF, "BJ" ],  // 103.202.56.0-103.202.91.255, BJ
        [ 0x67CA5C00, 0x67CA73FF, "SH" ],  // 103.202.92.0-103.202.115.255, SH
        [ 0x67CA7400, 0x67CA77FF, "BJ" ],  // 103.202.116.0-103.202.119.255, BJ
        [ 0x67CA7800, 0x67CA93FF, "SH" ],  // 103.202.120.0-103.202.147.255, SH
        [ 0x67CA9800, 0x67CAABFF, "LN" ],  // 103.202.152.0-103.202.171.255, LN
        [ 0x67CAAC00, 0x67CAAFFF, "HB" ],  // 103.202.172.0-103.202.175.255, HB
        [ 0x67CAB000, 0x67CAB3FF, "SD" ],  // 103.202.176.0-103.202.179.255, SD
        [ 0x67CAB400, 0x67CAB7FF, "LN" ],  // 103.202.180.0-103.202.183.255, LN
        [ 0x67CAB800, 0x67CABBFF, "SN" ],  // 103.202.184.0-103.202.187.255, SN
        [ 0x67CABC00, 0x67CABFFF, "GD" ],  // 103.202.188.0-103.202.191.255, GD
        [ 0x67CAC000, 0x67CAC3FF, "HN" ],  // 103.202.192.0-103.202.195.255, HN
        [ 0x67CAC400, 0x67CACFFF, "HB" ],  // 103.202.196.0-103.202.207.255, HB
        [ 0x67CAD400, 0x67CAD7FF, "SH" ],  // 103.202.212.0-103.202.215.255, SH
        [ 0x67CAE400, 0x67CAE7FF, "GD" ],  // 103.202.228.0-103.202.231.255, GD
        [ 0x67CAEC00, 0x67CAFFFF, "HB" ],  // 103.202.236.0-103.202.255.255, HB
        [ 0x67CB0000, 0x67CB03FF, "GD" ],  // 103.203.0.0-103.203.3.255, GD
        [ 0x67CB0400, 0x67CB07FF, "HN" ],  // 103.203.4.0-103.203.7.255, HN
        [ 0x67CB0800, 0x67CB0BFF, "GX" ],  // 103.203.8.0-103.203.11.255, GX
        [ 0x67CB0C00, 0x67CB0FFF, "HA" ],  // 103.203.12.0-103.203.15.255, HA
        [ 0x67CB1000, 0x67CB13FF, "JS" ],  // 103.203.16.0-103.203.19.255, JS
        [ 0x67CB1400, 0x67CB17FF, "FJ" ],  // 103.203.20.0-103.203.23.255, FJ
        [ 0x67CB1800, 0x67CB1FFF, "SD" ],  // 103.203.24.0-103.203.31.255, SD
        [ 0x67CB2000, 0x67CB23FF, "JS" ],  // 103.203.32.0-103.203.35.255, JS
        [ 0x67CB3800, 0x67CB3BFF, "BJ" ],  // 103.203.56.0-103.203.59.255, BJ
        [ 0x67CB6000, 0x67CB63FF, "SD" ],  // 103.203.96.0-103.203.99.255, SD
        [ 0x67CB6400, 0x67CB67FF, "GD" ],  // 103.203.100.0-103.203.103.255, GD
        [ 0x67CB6800, 0x67CB6BFF, "SN" ],  // 103.203.104.0-103.203.107.255, SN
        [ 0x67CB6C00, 0x67CB73FF, "HB" ],  // 103.203.108.0-103.203.115.255, HB
        [ 0x67CB7400, 0x67CB77FF, "JS" ],  // 103.203.116.0-103.203.119.255, JS
        [ 0x67CB7800, 0x67CB7BFF, "SC" ],  // 103.203.120.0-103.203.123.255, SC
        [ 0x67CB7C00, 0x67CB83FF, "SD" ],  // 103.203.124.0-103.203.131.255, SD
        [ 0x67CB8C00, 0x67CB8FFF, "YN" ],  // 103.203.140.0-103.203.143.255, YN
        [ 0x67CBA400, 0x67CBA7FF, "HN" ],  // 103.203.164.0-103.203.167.255, HN
        [ 0x67CBA800, 0x67CBABFF, "SD" ],  // 103.203.168.0-103.203.171.255, SD
        [ 0x67CBC000, 0x67CBC3FF, "BJ" ],  // 103.203.192.0-103.203.195.255, BJ
        [ 0x67CBC800, 0x67CBCBFF, "LN" ],  // 103.203.200.0-103.203.203.255, LN
        [ 0x67CBD400, 0x67CBD7FF, "SH" ],  // 103.203.212.0-103.203.215.255, SH
        [ 0x67CBD800, 0x67CBDBFF, "SC" ],  // 103.203.216.0-103.203.219.255, SC
        [ 0x67CC1800, 0x67CC1BFF, "JX" ],  // 103.204.24.0-103.204.27.255, JX
        [ 0x67CC4800, 0x67CC4BFF, "SH" ],  // 103.204.72.0-103.204.75.255, SH
        [ 0x67CC5800, 0x67CC5BFF, "LN" ],  // 103.204.88.0-103.204.91.255, LN
        [ 0x67CC7000, 0x67CC73FF, "SC" ],  // 103.204.112.0-103.204.115.255, SC
        [ 0x67CC8800, 0x67CC8BFF, "HB" ],  // 103.204.136.0-103.204.139.255, HB
        [ 0x67CC8C00, 0x67CC93FF, "BJ" ],  // 103.204.140.0-103.204.147.255, BJ
        [ 0x67CC9400, 0x67CC9BFF, "SC" ],  // 103.204.148.0-103.204.155.255, SC
        [ 0x67CCC400, 0x67CCC7FF, "SH" ],  // 103.204.196.0-103.204.199.255, SH
        [ 0x67CCD400, 0x67CCD7FF, "SH" ],  // 103.204.212.0-103.204.215.255, SH
        [ 0x67CCD800, 0x67CCD9FF, "ZJ" ],  // 103.204.216.0-103.204.217.255, ZJ
        [ 0x67CCE800, 0x67CCEBFF, "BJ" ],  // 103.204.232.0-103.204.235.255, BJ
        [ 0x67CCEC00, 0x67CCEFFF, "HN" ],  // 103.204.236.0-103.204.239.255, HN
        [ 0x67CD0400, 0x67CD07FF, "JS" ],  // 103.205.4.0-103.205.7.255, JS
        [ 0x67CD2800, 0x67CD2BFF, "BJ" ],  // 103.205.40.0-103.205.43.255, BJ
        [ 0x67CD2C00, 0x67CD2FFF, "LN" ],  // 103.205.44.0-103.205.47.255, LN
        [ 0x67CD3400, 0x67CD37FF, "ZJ" ],  // 103.205.52.0-103.205.55.255, ZJ
        [ 0x67CD6C00, 0x67CD6FFF, "ZJ" ],  // 103.205.108.0-103.205.111.255, ZJ
        [ 0x67CD7400, 0x67CD77FF, "BJ" ],  // 103.205.116.0-103.205.119.255, BJ
        [ 0x67CD8800, 0x67CD8BFF, "HA" ],  // 103.205.136.0-103.205.139.255, HA
        [ 0x67CD9E41, 0x67CD9EFF, "GD" ],  // 103.205.158.65-103.205.158.255, GD
        [ 0x67CDA200, 0x67CDA2FF, "YN" ],  // 103.205.162.0-103.205.162.255, YN
        [ 0x67CDBC00, 0x67CDBFFF, "SN" ],  // 103.205.188.0-103.205.191.255, SN
        [ 0x67CDC000, 0x67CDC3FF, "TJ" ],  // 103.205.192.0-103.205.195.255, TJ
        [ 0x67CDC400, 0x67CDCBFF, "BJ" ],  // 103.205.196.0-103.205.203.255, BJ
        [ 0x67CDEC00, 0x67CDEFFF, "BJ" ],  // 103.205.236.0-103.205.239.255, BJ
        [ 0x67CDF800, 0x67CDFBFF, "BJ" ],  // 103.205.248.0-103.205.251.255, BJ
        [ 0x67CDFC00, 0x67CDFFFF, "JS" ],  // 103.205.252.0-103.205.255.255, JS
        [ 0x67CE0000, 0x67CE03FF, "SH" ],  // 103.206.0.0-103.206.3.255, SH
        [ 0x67CE2C00, 0x67CE2FFF, "SH" ],  // 103.206.44.0-103.206.47.255, SH
        [ 0x67CE9400, 0x67CE97FF, "SX" ],  // 103.206.148.0-103.206.151.255, SX
        [ 0x67CF3000, 0x67CF33FF, "SH" ],  // 103.207.48.0-103.207.51.255, SH
        [ 0x67CF6800, 0x67CF6BFF, "HA" ],  // 103.207.104.0-103.207.107.255, HA
        [ 0x67CFB800, 0x67CFBFFF, "BJ" ],  // 103.207.184.0-103.207.191.255, BJ
        [ 0x67CFC000, 0x67CFC3FF, "GD" ],  // 103.207.192.0-103.207.195.255, GD
        [ 0x67CFC400, 0x67CFC7FF, "HN" ],  // 103.207.196.0-103.207.199.255, HN
        [ 0x67CFC800, 0x67CFCBFF, "GD" ],  // 103.207.200.0-103.207.203.255, GD
        [ 0x67CFCC00, 0x67CFCFFF, "BJ" ],  // 103.207.204.0-103.207.207.255, BJ
        [ 0x67CFD000, 0x67CFD7FF, "GD" ],  // 103.207.208.0-103.207.215.255, GD
        [ 0x67CFDC00, 0x67CFDFFF, "SX" ],  // 103.207.220.0-103.207.223.255, SX
        [ 0x67CFE400, 0x67CFEBFF, "TJ" ],  // 103.207.228.0-103.207.235.255, TJ
        [ 0x67D00C00, 0x67D013FF, "BJ" ],  // 103.208.12.0-103.208.19.255, BJ
        [ 0x67D01C00, 0x67D01FFF, "SH" ],  // 103.208.28.0-103.208.31.255, SH
        [ 0x67D02800, 0x67D033FF, "JS" ],  // 103.208.40.0-103.208.51.255, JS
        [ 0x67D17000, 0x67D173FF, "ZJ" ],  // 103.209.112.0-103.209.115.255, ZJ
        [ 0x67D18800, 0x67D18BFF, "SH" ],  // 103.209.136.0-103.209.139.255, SH
        [ 0x67D1C800, 0x67D1CBFF, "GD" ],  // 103.209.200.0-103.209.203.255, GD
        [ 0x67D1D000, 0x67D1D3FF, "SH" ],  // 103.209.208.0-103.209.211.255, SH
        [ 0x67D1D800, 0x67D1DBFF, "SH" ],  // 103.209.216.0-103.209.219.255, SH
        [ 0x67D26000, 0x67D263FF, "YN" ],  // 103.210.96.0-103.210.99.255, YN
        [ 0x67D29C00, 0x67D29FFF, "GZ" ],  // 103.210.156.0-103.210.159.255, GZ
        [ 0x67D2A000, 0x67D2A3FF, "GD" ],  // 103.210.160.0-103.210.163.255, GD
        [ 0x67D2A400, 0x67D2A7FF, "BJ" ],  // 103.210.164.0-103.210.167.255, BJ
        [ 0x67D2A800, 0x67D2B7FF, "GD" ],  // 103.210.168.0-103.210.183.255, GD
        [ 0x67D2B800, 0x67D2BBFF, "BJ" ],  // 103.210.184.0-103.210.187.255, BJ
        [ 0x67D2BC00, 0x67D2BFFF, "HB" ],  // 103.210.188.0-103.210.191.255, HB
        [ 0x67D2D800, 0x67D2DBFF, "BJ" ],  // 103.210.216.0-103.210.219.255, BJ
        [ 0x67D32C00, 0x67D32FFF, "SH" ],  // 103.211.44.0-103.211.47.255, SH
        [ 0x67D36000, 0x67D362FF, "TJ" ],  // 103.211.96.0-103.211.98.255, TJ
        [ 0x67D36300, 0x67D363FF, "BJ" ],  // 103.211.99.0-103.211.99.255, BJ
        [ 0x67D39C00, 0x67D39FFF, "TJ" ],  // 103.211.156.0-103.211.159.255, TJ
        [ 0x67D3A500, 0x67D3A5FF, "BJ" ],  // 103.211.165.0-103.211.165.255, BJ
        [ 0x67D3A700, 0x67D3A7FF, "BJ" ],  // 103.211.167.0-103.211.167.255, BJ
        [ 0x67D3DC00, 0x67D3DFFF, "JS" ],  // 103.211.220.0-103.211.223.255, JS
        [ 0x67D3E000, 0x67D3E3FF, "LN" ],  // 103.211.224.0-103.211.227.255, LN
        [ 0x67D3F800, 0x67D3FBFF, "GD" ],  // 103.211.248.0-103.211.251.255, GD
        [ 0x67D40000, 0x67D407FF, "BJ" ],  // 103.212.0.0-103.212.7.255, BJ
        [ 0x67D40800, 0x67D40BFF, "LN" ],  // 103.212.8.0-103.212.11.255, LN
        [ 0x67D40C00, 0x67D40FFF, "BJ" ],  // 103.212.12.0-103.212.15.255, BJ
        [ 0x67D42C00, 0x67D42FFF, "ZJ" ],  // 103.212.44.0-103.212.47.255, ZJ
        [ 0x67D43000, 0x67D433FF, "GD" ],  // 103.212.48.0-103.212.51.255, GD
        [ 0x67D45400, 0x67D457FF, "GD" ],  // 103.212.84.0-103.212.87.255, GD
        [ 0x67D46400, 0x67D467FF, "BJ" ],  // 103.212.100.0-103.212.103.255, BJ
        [ 0x67D46C00, 0x67D46FFF, "GD" ],  // 103.212.108.0-103.212.111.255, GD
        [ 0x67D49400, 0x67D497FF, "JS" ],  // 103.212.148.0-103.212.151.255, JS
        [ 0x67D4A400, 0x67D4A7FF, "ZJ" ],  // 103.212.164.0-103.212.167.255, ZJ
        [ 0x67D4C400, 0x67D4CBFF, "TJ" ],  // 103.212.196.0-103.212.203.255, TJ
        [ 0x67D4E400, 0x67D4E7FF, "GD" ],  // 103.212.228.0-103.212.231.255, GD
        [ 0x67D4FC00, 0x67D4FFFF, "SH" ],  // 103.212.252.0-103.212.255.255, SH
        [ 0x67D52800, 0x67D55FFF, "BJ" ],  // 103.213.40.0-103.213.95.255, BJ
        [ 0x67D56000, 0x67D563FF, "JS" ],  // 103.213.96.0-103.213.99.255, JS
        [ 0x67D58400, 0x67D587FF, "JS" ],  // 103.213.132.0-103.213.135.255, JS
        [ 0x67D58800, 0x67D5BFFF, "BJ" ],  // 103.213.136.0-103.213.191.255, BJ
        [ 0x67D5C400, 0x67D5C5FF, "CQ" ],  // 103.213.196.0-103.213.197.255, CQ
        [ 0x67D5C600, 0x67D5C7FF, "SC" ],  // 103.213.198.0-103.213.199.255, SC
        [ 0x67D5E200, 0x67D5E3FF, "JS" ],  // 103.213.226.0-103.213.227.255, JS
        [ 0x67D5E800, 0x67D5E9FF, "BJ" ],  // 103.213.232.0-103.213.233.255, BJ
        [ 0x67D63000, 0x67D633FF, "AH" ],  // 103.214.48.0-103.214.51.255, AH
        [ 0x67D65400, 0x67D657FF, "SH" ],  // 103.214.84.0-103.214.87.255, SH
        [ 0x67D6D400, 0x67D6D7FF, "BJ" ],  // 103.214.212.0-103.214.215.255, BJ
        [ 0x67D6F000, 0x67D6F7FF, "SH" ],  // 103.214.240.0-103.214.247.255, SH
        [ 0x67D71C00, 0x67D71FFF, "NM" ],  // 103.215.28.0-103.215.31.255, NM
        [ 0x67D72000, 0x67D723FF, "BJ" ],  // 103.215.32.0-103.215.35.255, BJ
        [ 0x67D72400, 0x67D727FF, "JS" ],  // 103.215.36.0-103.215.39.255, JS
        [ 0x67D72C00, 0x67D733FF, "GD" ],  // 103.215.44.0-103.215.51.255, GD
        [ 0x67D76400, 0x67D767FF, "BJ" ],  // 103.215.100.0-103.215.103.255, BJ
        [ 0x67D76C00, 0x67D76FFF, "FJ" ],  // 103.215.108.0-103.215.111.255, FJ
        [ 0x67D77400, 0x67D77BFF, "FJ" ],  // 103.215.116.0-103.215.123.255, FJ
        [ 0x67D78C00, 0x67D78FFF, "GD" ],  // 103.215.140.0-103.215.143.255, GD
        [ 0x67D80400, 0x67D82FFF, "BJ" ],  // 103.216.4.0-103.216.47.255, BJ
        [ 0x67D84000, 0x67D843FF, "SD" ],  // 103.216.64.0-103.216.67.255, SD
        [ 0x67D86C00, 0x67D86FFF, "ZJ" ],  // 103.216.108.0-103.216.111.255, ZJ
        [ 0x67D88800, 0x67D88BFF, "JS" ],  // 103.216.136.0-103.216.139.255, JS
        [ 0x67D89800, 0x67D89BFF, "JS" ],  // 103.216.152.0-103.216.155.255, JS
        [ 0x67D89C00, 0x67D89DFF, "BJ" ],  // 103.216.156.0-103.216.157.255, BJ
        [ 0x67D8E000, 0x67D8E7FF, "FJ" ],  // 103.216.224.0-103.216.231.255, FJ
        [ 0x67D8F000, 0x67D8FFFF, "HL" ],  // 103.216.240.0-103.216.255.255, HL
        [ 0x67D90000, 0x67D93FFF, "GD" ],  // 103.217.0.0-103.217.63.255, GD
        [ 0x67D9A800, 0x67D9ABFF, "BJ" ],  // 103.217.168.0-103.217.171.255, BJ
        [ 0x67D9B400, 0x67D9CFFF, "SH" ],  // 103.217.180.0-103.217.207.255, SH
        [ 0x67DA0800, 0x67DA0BFF, "BJ" ],  // 103.218.8.0-103.218.11.255, BJ
        [ 0x67DA0C00, 0x67DA0FFF, "SC" ],  // 103.218.12.0-103.218.15.255, SC
        [ 0x67DA1000, 0x67DA13FF, "ZJ" ],  // 103.218.16.0-103.218.19.255, ZJ
        [ 0x67DA1400, 0x67DA17FF, "HN" ],  // 103.218.20.0-103.218.23.255, HN
        [ 0x67DA1C00, 0x67DA1CFF, "BJ" ],  // 103.218.28.0-103.218.28.255, BJ
        [ 0x67DA1D00, 0x67DA23FF, "SD" ],  // 103.218.29.0-103.218.35.255, SD
        [ 0x67DA2400, 0x67DA27FF, "JS" ],  // 103.218.36.0-103.218.39.255, JS
        [ 0x67DA2800, 0x67DA2BFF, "FJ" ],  // 103.218.40.0-103.218.43.255, FJ
        [ 0x67DA2C00, 0x67DA33FF, "SH" ],  // 103.218.44.0-103.218.51.255, SH
        [ 0x67DA3400, 0x67DA43FF, "GD" ],  // 103.218.52.0-103.218.67.255, GD
        [ 0x67DA4400, 0x67DA47FF, "SX" ],  // 103.218.68.0-103.218.71.255, SX
        [ 0x67DA4800, 0x67DA4BFF, "TJ" ],  // 103.218.72.0-103.218.75.255, TJ
        [ 0x67DA4C00, 0x67DA4FFF, "GD" ],  // 103.218.76.0-103.218.79.255, GD
        [ 0x67DA5000, 0x67DA53FF, "SH" ],  // 103.218.80.0-103.218.83.255, SH
        [ 0x67DA5400, 0x67DA57FF, "GD" ],  // 103.218.84.0-103.218.87.255, GD
        [ 0x67DA5800, 0x67DA5BFF, "FJ" ],  // 103.218.88.0-103.218.91.255, FJ
        [ 0x67DA5C00, 0x67DA5CFF, "GD" ],  // 103.218.92.0-103.218.92.255, GD
        [ 0x67DA5D00, 0x67DA5FFF, "HA" ],  // 103.218.93.0-103.218.95.255, HA
        [ 0x67DAB200, 0x67DAB3FF, "HB" ],  // 103.218.178.0-103.218.179.255, HB
        [ 0x67DAC000, 0x67DACFFF, "SH" ],  // 103.218.192.0-103.218.207.255, SH
        [ 0x67DAD000, 0x67DAD3FF, "GD" ],  // 103.218.208.0-103.218.211.255, GD
        [ 0x67DAD400, 0x67DAD7FF, "HB" ],  // 103.218.212.0-103.218.215.255, HB
        [ 0x67DAD800, 0x67DADBFF, "GD" ],  // 103.218.216.0-103.218.219.255, GD
        [ 0x67DB1800, 0x67DB1BFF, "JS" ],  // 103.219.24.0-103.219.27.255, JS
        [ 0x67DB1C00, 0x67DB27FF, "ZJ" ],  // 103.219.28.0-103.219.39.255, ZJ
        [ 0x67DB4000, 0x67DB43FF, "BJ" ],  // 103.219.64.0-103.219.67.255, BJ
        [ 0x67DB5400, 0x67DB67FF, "GD" ],  // 103.219.84.0-103.219.103.255, GD
        [ 0x67DBB000, 0x67DBB3FF, "FJ" ],  // 103.219.176.0-103.219.179.255, FJ
        [ 0x67DBB800, 0x67DBBBFF, "BJ" ],  // 103.219.184.0-103.219.187.255, BJ
        [ 0x67DC3000, 0x67DC33FF, "TJ" ],  // 103.220.48.0-103.220.51.255, TJ
        [ 0x67DC3400, 0x67DC37FF, "GD" ],  // 103.220.52.0-103.220.55.255, GD
        [ 0x67DC3800, 0x67DC3BFF, "GZ" ],  // 103.220.56.0-103.220.59.255, GZ
        [ 0x67DC3C00, 0x67DC3FFF, "GD" ],  // 103.220.60.0-103.220.63.255, GD
        [ 0x67DC4000, 0x67DC43FF, "GZ" ],  // 103.220.64.0-103.220.67.255, GZ
        [ 0x67DC5C00, 0x67DC5FFF, "AH" ],  // 103.220.92.0-103.220.95.255, AH
        [ 0x67DC6000, 0x67DC63FF, "SC" ],  // 103.220.96.0-103.220.99.255, SC
        [ 0x67DC6400, 0x67DC67FF, "GD" ],  // 103.220.100.0-103.220.103.255, GD
        [ 0x67DC6800, 0x67DC6FFF, "ZJ" ],  // 103.220.104.0-103.220.111.255, ZJ
        [ 0x67DC7400, 0x67DC77FF, "ZJ" ],  // 103.220.116.0-103.220.119.255, ZJ
        [ 0x67DC7800, 0x67DC7BFF, "SH" ],  // 103.220.120.0-103.220.123.255, SH
        [ 0x67DC7C00, 0x67DC7FFF, "ZJ" ],  // 103.220.124.0-103.220.127.255, ZJ
        [ 0x67DC8000, 0x67DC9BFF, "SH" ],  // 103.220.128.0-103.220.155.255, SH
        [ 0x67DCA000, 0x67DCA3FF, "ZJ" ],  // 103.220.160.0-103.220.163.255, ZJ
        [ 0x67DCA400, 0x67DCCBFF, "SH" ],  // 103.220.164.0-103.220.203.255, SH
        [ 0x67DCF000, 0x67DCF3FF, "ZJ" ],  // 103.220.240.0-103.220.243.255, ZJ
        [ 0x67DCF400, 0x67DCF7FF, "QH" ],  // 103.220.244.0-103.220.247.255, QH
        [ 0x67DCF800, 0x67DD33FF, "SH" ],  // 103.220.248.0-103.221.51.255, SH
        [ 0x67DD5800, 0x67DD5BFF, "GZ" ],  // 103.221.88.0-103.221.91.255, GZ
        [ 0x67DD5C00, 0x67DD5FFF, "SH" ],  // 103.221.92.0-103.221.95.255, SH
        [ 0x67DD6000, 0x67DD63FF, "AH" ],  // 103.221.96.0-103.221.99.255, AH
        [ 0x67DD6400, 0x67DD67FF, "SH" ],  // 103.221.100.0-103.221.103.255, SH
        [ 0x67DD6800, 0x67DD6BFF, "AH" ],  // 103.221.104.0-103.221.107.255, AH
        [ 0x67DD6C00, 0x67DD83FF, "SH" ],  // 103.221.108.0-103.221.131.255, SH
        [ 0x67DD8400, 0x67DD87FF, "BJ" ],  // 103.221.132.0-103.221.135.255, BJ
        [ 0x67DD8800, 0x67DD8BFF, "SH" ],  // 103.221.136.0-103.221.139.255, SH
        [ 0x67DD8C00, 0x67DD8FFF, "JS" ],  // 103.221.140.0-103.221.143.255, JS
        [ 0x67DD9000, 0x67DDABFF, "BJ" ],  // 103.221.144.0-103.221.171.255, BJ
        [ 0x67DDAC00, 0x67DDAFFF, "HI" ],  // 103.221.172.0-103.221.175.255, HI
        [ 0x67DDB000, 0x67DDB3FF, "JS" ],  // 103.221.176.0-103.221.179.255, JS
        [ 0x67DDB400, 0x67DDB7FF, "GX" ],  // 103.221.180.0-103.221.183.255, GX
        [ 0x67DDB800, 0x67DDBFFF, "HE" ],  // 103.221.184.0-103.221.191.255, HE
        [ 0x67DDC000, 0x67DDC0FF, "GD" ],  // 103.221.192.0-103.221.192.255, GD
        [ 0x67DDC100, 0x67DDC2FF, "HL" ],  // 103.221.193.0-103.221.194.255, HL
        [ 0x67DDC300, 0x67DDC3FF, "GD" ],  // 103.221.195.0-103.221.195.255, GD
        [ 0x67DDC400, 0x67DDC7FF, "HA" ],  // 103.221.196.0-103.221.199.255, HA
        [ 0x67DDC800, 0x67DDCBFF, "BJ" ],  // 103.221.200.0-103.221.203.255, BJ
        [ 0x67DDCC00, 0x67DDCFFF, "HE" ],  // 103.221.204.0-103.221.207.255, HE
        [ 0x67DE0000, 0x67DE03FF, "HL" ],  // 103.222.0.0-103.222.3.255, HL
        [ 0x67DE0400, 0x67DE07FF, "SD" ],  // 103.222.4.0-103.222.7.255, SD
        [ 0x67DE0800, 0x67DE0BFF, "HA" ],  // 103.222.8.0-103.222.11.255, HA
        [ 0x67DE0C00, 0x67DE0FFF, "SD" ],  // 103.222.12.0-103.222.15.255, SD
        [ 0x67DE1000, 0x67DE13FF, "HE" ],  // 103.222.16.0-103.222.19.255, HE
        [ 0x67DE1800, 0x67DE1BFF, "GZ" ],  // 103.222.24.0-103.222.27.255, GZ
        [ 0x67DE1C00, 0x67DE1FFF, "GS" ],  // 103.222.28.0-103.222.31.255, GS
        [ 0x67DE2000, 0x67DE23FF, "BJ" ],  // 103.222.32.0-103.222.35.255, BJ
        [ 0x67DE2400, 0x67DE27FF, "HB" ],  // 103.222.36.0-103.222.39.255, HB
        [ 0x67DE2800, 0x67DE2BFF, "SH" ],  // 103.222.40.0-103.222.43.255, SH
        [ 0x67DE2C00, 0x67DE2FFF, "HB" ],  // 103.222.44.0-103.222.47.255, HB
        [ 0x67DE3000, 0x67DE33FF, "HE" ],  // 103.222.48.0-103.222.51.255, HE
        [ 0x67DE3400, 0x67DE37FF, "BJ" ],  // 103.222.52.0-103.222.55.255, BJ
        [ 0x67DE3800, 0x67DE3FFF, "AH" ],  // 103.222.56.0-103.222.63.255, AH
        [ 0x67DE4000, 0x67DE43FF, "SX" ],  // 103.222.64.0-103.222.67.255, SX
        [ 0x67DE4400, 0x67DE47FF, "HA" ],  // 103.222.68.0-103.222.71.255, HA
        [ 0x67DE4800, 0x67DE4BFF, "BJ" ],  // 103.222.72.0-103.222.75.255, BJ
        [ 0x67DE4C00, 0x67DE4FFF, "HN" ],  // 103.222.76.0-103.222.79.255, HN
        [ 0x67DE5000, 0x67DE53FF, "HE" ],  // 103.222.80.0-103.222.83.255, HE
        [ 0x67DE5400, 0x67DE57FF, "GZ" ],  // 103.222.84.0-103.222.87.255, GZ
        [ 0x67DE5800, 0x67DE5BFF, "HA" ],  // 103.222.88.0-103.222.91.255, HA
        [ 0x67DE5C00, 0x67DE5FFF, "JS" ],  // 103.222.92.0-103.222.95.255, JS
        [ 0x67DE6000, 0x67DE63FF, "HA" ],  // 103.222.96.0-103.222.99.255, HA
        [ 0x67DE6400, 0x67DE67FF, "LN" ],  // 103.222.100.0-103.222.103.255, LN
        [ 0x67DE6800, 0x67DE6BFF, "GD" ],  // 103.222.104.0-103.222.107.255, GD
        [ 0x67DE6C00, 0x67DE6FFF, "HE" ],  // 103.222.108.0-103.222.111.255, HE
        [ 0x67DE7000, 0x67DE8FFF, "GD" ],  // 103.222.112.0-103.222.143.255, GD
        [ 0x67DE9000, 0x67DE93FF, "JS" ],  // 103.222.144.0-103.222.147.255, JS
        [ 0x67DE9400, 0x67DE97FF, "TJ" ],  // 103.222.148.0-103.222.151.255, TJ
        [ 0x67DE9800, 0x67DE9BFF, "JS" ],  // 103.222.152.0-103.222.155.255, JS
        [ 0x67DE9C00, 0x67DE9FFF, "SH" ],  // 103.222.156.0-103.222.159.255, SH
        [ 0x67DEA000, 0x67DEA3FF, "HA" ],  // 103.222.160.0-103.222.163.255, HA
        [ 0x67DEA400, 0x67DEA7FF, "BJ" ],  // 103.222.164.0-103.222.167.255, BJ
        [ 0x67DEA800, 0x67DEABFF, "GD" ],  // 103.222.168.0-103.222.171.255, GD
        [ 0x67DEAC00, 0x67DEAFFF, "BJ" ],  // 103.222.172.0-103.222.175.255, BJ
        [ 0x67DEB000, 0x67DEB7FF, "GD" ],  // 103.222.176.0-103.222.183.255, GD
        [ 0x67DEB800, 0x67DEBBFF, "NX" ],  // 103.222.184.0-103.222.187.255, NX
        [ 0x67DEBC00, 0x67DEBFFF, "JS" ],  // 103.222.188.0-103.222.191.255, JS
        [ 0x67DEC000, 0x67DEC3FF, "BJ" ],  // 103.222.192.0-103.222.195.255, BJ
        [ 0x67DEC400, 0x67DEC7FF, "FJ" ],  // 103.222.196.0-103.222.199.255, FJ
        [ 0x67DEC800, 0x67DECBFF, "HA" ],  // 103.222.200.0-103.222.203.255, HA
        [ 0x67DECC00, 0x67DECFFF, "YN" ],  // 103.222.204.0-103.222.207.255, YN
        [ 0x67DED000, 0x67DED3FF, "SD" ],  // 103.222.208.0-103.222.211.255, SD
        [ 0x67DED400, 0x67DED7FF, "HE" ],  // 103.222.212.0-103.222.215.255, HE
        [ 0x67DED800, 0x67DEDBFF, "SD" ],  // 103.222.216.0-103.222.219.255, SD
        [ 0x67DEDC00, 0x67DEEBFF, "GD" ],  // 103.222.220.0-103.222.235.255, GD
        [ 0x67DEF000, 0x67DEF3FF, "GD" ],  // 103.222.240.0-103.222.243.255, GD
        [ 0x67DEF400, 0x67DEF7FF, "BJ" ],  // 103.222.244.0-103.222.247.255, BJ
        [ 0x67DF1000, 0x67DF77FF, "GD" ],  // 103.223.16.0-103.223.119.255, GD
        [ 0x67DF7C00, 0x67DF83FF, "GD" ],  // 103.223.124.0-103.223.131.255, GD
        [ 0x67DF8400, 0x67DF87FF, "FJ" ],  // 103.223.132.0-103.223.135.255, FJ
        [ 0x67DF8C00, 0x67DFB7FF, "BJ" ],  // 103.223.140.0-103.223.183.255, BJ
        [ 0x67DFBC00, 0x67E003FF, "BJ" ],  // 103.223.188.0-103.224.3.255, BJ
        [ 0x67E02800, 0x67E02FFF, "BJ" ],  // 103.224.40.0-103.224.47.255, BJ
        [ 0x67E03C00, 0x67E03FFF, "BJ" ],  // 103.224.60.0-103.224.63.255, BJ
        [ 0x67E0DC00, 0x67E0E3FF, "BJ" ],  // 103.224.220.0-103.224.227.255, BJ
        [ 0x67E0E400, 0x67E0E5FF, "JS" ],  // 103.224.228.0-103.224.229.255, JS
        [ 0x67E0E600, 0x67E0E7FF, "BJ" ],  // 103.224.230.0-103.224.231.255, BJ
        [ 0x67E0E800, 0x67E0EBFF, "NM" ],  // 103.224.232.0-103.224.235.255, NM
        [ 0x67E11200, 0x67E112FF, "FJ" ],  // 103.225.18.0-103.225.18.255, FJ
        [ 0x67E21000, 0x67E213FF, "GD" ],  // 103.226.16.0-103.226.19.255, GD
        [ 0x67E22800, 0x67E22BFF, "GD" ],  // 103.226.40.0-103.226.43.255, GD
        [ 0x67E23800, 0x67E23FFF, "BJ" ],  // 103.226.56.0-103.226.63.255, BJ
        [ 0x67E25000, 0x67E253FF, "BJ" ],  // 103.226.80.0-103.226.83.255, BJ
        [ 0x67E27400, 0x67E275FF, "JS" ],  // 103.226.116.0-103.226.117.255, JS
        [ 0x67E28400, 0x67E287FF, "TJ" ],  // 103.226.132.0-103.226.135.255, TJ
        [ 0x67E29C00, 0x67E29FFF, "HB" ],  // 103.226.156.0-103.226.159.255, HB
        [ 0x67E2B400, 0x67E2B7FF, "BJ" ],  // 103.226.180.0-103.226.183.255, BJ
        [ 0x67E2C400, 0x67E2C7FF, "SC" ],  // 103.226.196.0-103.226.199.255, SC
        [ 0x67E33000, 0x67E333FF, "BJ" ],  // 103.227.48.0-103.227.51.255, BJ
        [ 0x67E34800, 0x67E353FF, "BJ" ],  // 103.227.72.0-103.227.83.255, BJ
        [ 0x67E36400, 0x67E367FF, "HL" ],  // 103.227.100.0-103.227.103.255, HL
        [ 0x67E37800, 0x67E379FF, "JS" ],  // 103.227.120.0-103.227.121.255, JS
        [ 0x67E37A00, 0x67E37BFF, "BJ" ],  // 103.227.122.0-103.227.123.255, BJ
        [ 0x67E38400, 0x67E387FF, "BJ" ],  // 103.227.132.0-103.227.135.255, BJ
        [ 0x67E38800, 0x67E38BFF, "TJ" ],  // 103.227.136.0-103.227.139.255, TJ
        [ 0x67E3C400, 0x67E3C7FF, "BJ" ],  // 103.227.196.0-103.227.199.255, BJ
        [ 0x67E3CC00, 0x67E3CFFF, "BJ" ],  // 103.227.204.0-103.227.207.255, BJ
        [ 0x67E3D400, 0x67E3D7FF, "HE" ],  // 103.227.212.0-103.227.215.255, HE
        [ 0x67E3E400, 0x67E3E7FF, "XJ" ],  // 103.227.228.0-103.227.231.255, XJ
        [ 0x67E40C00, 0x67E40FFF, "SC" ],  // 103.228.12.0-103.228.15.255, SC
        [ 0x67E45800, 0x67E45BFF, "SC" ],  // 103.228.88.0-103.228.91.255, SC
        [ 0x67E48800, 0x67E48BFF, "BJ" ],  // 103.228.136.0-103.228.139.255, BJ
        [ 0x67E4A000, 0x67E4A3FF, "GD" ],  // 103.228.160.0-103.228.163.255, GD
        [ 0x67E4B000, 0x67E4B3FF, "HE" ],  // 103.228.176.0-103.228.179.255, HE
        [ 0x67E4CC00, 0x67E4CFFF, "BJ" ],  // 103.228.204.0-103.228.207.255, BJ
        [ 0x67E4D000, 0x67E4D3FF, "GX" ],  // 103.228.208.0-103.228.211.255, GX
        [ 0x67E4E400, 0x67E4E7FF, "GD" ],  // 103.228.228.0-103.228.231.255, GD
        [ 0x67E4E800, 0x67E4EBFF, "BJ" ],  // 103.228.232.0-103.228.235.255, BJ
        [ 0x67E51400, 0x67E517FF, "CQ" ],  // 103.229.20.0-103.229.23.255, CQ
        [ 0x67E53C00, 0x67E53FFF, "TJ" ],  // 103.229.60.0-103.229.63.255, TJ
        [ 0x67E58800, 0x67E58BFF, "LN" ],  // 103.229.136.0-103.229.139.255, LN
        [ 0x67E59400, 0x67E597FF, "JS" ],  // 103.229.148.0-103.229.151.255, JS
        [ 0x67E5AC00, 0x67E5AFFF, "SX" ],  // 103.229.172.0-103.229.175.255, SX
        [ 0x67E5D400, 0x67E5D8FF, "JS" ],  // 103.229.212.0-103.229.216.255, JS
        [ 0x67E5D900, 0x67E5DAFF, "BJ" ],  // 103.229.217.0-103.229.218.255, BJ
        [ 0x67E5DB00, 0x67E5DFFF, "JS" ],  // 103.229.219.0-103.229.223.255, JS
        [ 0x67E5E400, 0x67E5E7FF, "BJ" ],  // 103.229.228.0-103.229.231.255, BJ
        [ 0x67E5EC00, 0x67E5ECFF, "BJ" ],  // 103.229.236.0-103.229.236.255, BJ
        [ 0x67E5ED00, 0x67E5EFFF, "GD" ],  // 103.229.237.0-103.229.239.255, GD
        [ 0x67E5F000, 0x67E5F3FF, "BJ" ],  // 103.229.240.0-103.229.243.255, BJ
        [ 0x67E60000, 0x67E603FF, "BJ" ],  // 103.230.0.0-103.230.3.255, BJ
        [ 0x67E61C00, 0x67E61FFF, "TJ" ],  // 103.230.28.0-103.230.31.255, TJ
        [ 0x67E62C00, 0x67E62FFF, "SH" ],  // 103.230.44.0-103.230.47.255, SH
        [ 0x67E66000, 0x67E663FF, "BJ" ],  // 103.230.96.0-103.230.99.255, BJ
        [ 0x67E66E00, 0x67E66FFF, "SH" ],  // 103.230.110.0-103.230.111.255, SH
        [ 0x67E68000, 0x67E681FF, "BJ" ],  // 103.230.128.0-103.230.129.255, BJ
        [ 0x67E6C400, 0x67E6C7FF, "FJ" ],  // 103.230.196.0-103.230.199.255, FJ
        [ 0x67E6C800, 0x67E6CBFF, "NM" ],  // 103.230.200.0-103.230.203.255, NM
        [ 0x67E6CC00, 0x67E6CFFF, "SH" ],  // 103.230.204.0-103.230.207.255, SH
        [ 0x67E6D400, 0x67E6D7FF, "BJ" ],  // 103.230.212.0-103.230.215.255, BJ
        [ 0x67E6EC00, 0x67E6EFFF, "FJ" ],  // 103.230.236.0-103.230.239.255, FJ
        [ 0x67E71000, 0x67E717FF, "SH" ],  // 103.231.16.0-103.231.23.255, SH
        [ 0x67E74000, 0x67E747FF, "BJ" ],  // 103.231.64.0-103.231.71.255, BJ
        [ 0x67E79000, 0x67E793FF, "TJ" ],  // 103.231.144.0-103.231.147.255, TJ
        [ 0x67E7B400, 0x67E7B7FF, "BJ" ],  // 103.231.180.0-103.231.183.255, BJ
        [ 0x67E7B800, 0x67E7BBFF, "GD" ],  // 103.231.184.0-103.231.187.255, GD
        [ 0x67E7F400, 0x67E7F7FF, "GD" ],  // 103.231.244.0-103.231.247.255, GD
        [ 0x67E80400, 0x67E807FF, "SH" ],  // 103.232.4.0-103.232.7.255, SH
        [ 0x67E89000, 0x67E893FF, "GS" ],  // 103.232.144.0-103.232.147.255, GS
        [ 0x67E8A600, 0x67E8A7FF, "GS" ],  // 103.232.166.0-103.232.167.255, GS
        [ 0x67E8BC00, 0x67E8BFFF, "JS" ],  // 103.232.188.0-103.232.191.255, JS
        [ 0x67E90400, 0x67E907FF, "TJ" ],  // 103.233.4.0-103.233.7.255, TJ
        [ 0x67E92C00, 0x67E92FFF, "LN" ],  // 103.233.44.0-103.233.47.255, LN
        [ 0x67E93400, 0x67E937FF, "BJ" ],  // 103.233.52.0-103.233.55.255, BJ
        [ 0x67E96800, 0x67E96BFF, "ZJ" ],  // 103.233.104.0-103.233.107.255, ZJ
        [ 0x67E98000, 0x67E983FF, "BJ" ],  // 103.233.128.0-103.233.131.255, BJ
        [ 0x67E98800, 0x67E98BFF, "BJ" ],  // 103.233.136.0-103.233.139.255, BJ
        [ 0x67E9A200, 0x67E9A3FF, "BJ" ],  // 103.233.162.0-103.233.163.255, BJ
        [ 0x67E9E400, 0x67E9E7FF, "SD" ],  // 103.233.228.0-103.233.231.255, SD
        [ 0x67EA0000, 0x67EA03FF, "BJ" ],  // 103.234.0.0-103.234.3.255, BJ
        [ 0x67EA1400, 0x67EA17FF, "BJ" ],  // 103.234.20.0-103.234.23.255, BJ
        [ 0x67EA3800, 0x67EA3BFF, "JS" ],  // 103.234.56.0-103.234.59.255, JS
        [ 0x67EA8000, 0x67EA83FF, "SH" ],  // 103.234.128.0-103.234.131.255, SH
        [ 0x67EAAC00, 0x67EAAFFF, "HE" ],  // 103.234.172.0-103.234.175.255, HE
        [ 0x67EAB400, 0x67EAB7FF, "BJ" ],  // 103.234.180.0-103.234.183.255, BJ
        [ 0x67EAF400, 0x67EAF7FF, "TJ" ],  // 103.234.244.0-103.234.247.255, TJ
        [ 0x67EB3000, 0x67EB33FF, "SH" ],  // 103.235.48.0-103.235.51.255, SH
        [ 0x67EB3800, 0x67EB3BFF, "FJ" ],  // 103.235.56.0-103.235.59.255, FJ
        [ 0x67EB3C00, 0x67EB3FFF, "BJ" ],  // 103.235.60.0-103.235.63.255, BJ
        [ 0x67EB5000, 0x67EB53FF, "BJ" ],  // 103.235.80.0-103.235.83.255, BJ
        [ 0x67EB5500, 0x67EB55FF, "BJ" ],  // 103.235.85.0-103.235.85.255, BJ
        [ 0x67EB5600, 0x67EB57FF, "LN" ],  // 103.235.86.0-103.235.87.255, LN
        [ 0x67EB6400, 0x67EB67FF, "ZJ" ],  // 103.235.100.0-103.235.103.255, ZJ
        [ 0x67EB8000, 0x67EB83FF, "SD" ],  // 103.235.128.0-103.235.131.255, SD
        [ 0x67EB8400, 0x67EB87FF, "BJ" ],  // 103.235.132.0-103.235.135.255, BJ
        [ 0x67EB8800, 0x67EB8BFF, "SD" ],  // 103.235.136.0-103.235.139.255, SD
        [ 0x67EB8C00, 0x67EB97FF, "BJ" ],  // 103.235.140.0-103.235.151.255, BJ
        [ 0x67EBB800, 0x67EBBBFF, "GZ" ],  // 103.235.184.0-103.235.187.255, GZ
        [ 0x67EBC000, 0x67EBC3FF, "HA" ],  // 103.235.192.0-103.235.195.255, HA
        [ 0x67EBC800, 0x67EBCBFF, "BJ" ],  // 103.235.200.0-103.235.203.255, BJ
        [ 0x67EBDC00, 0x67EC03FF, "BJ" ],  // 103.235.220.0-103.236.3.255, BJ
        [ 0x67EC0400, 0x67EC07FF, "SC" ],  // 103.236.4.0-103.236.7.255, SC
        [ 0x67EC0800, 0x67EC0BFF, "YN" ],  // 103.236.8.0-103.236.11.255, YN
        [ 0x67EC0C00, 0x67EC13FF, "GD" ],  // 103.236.12.0-103.236.19.255, GD
        [ 0x67EC1400, 0x67EC17FF, "HL" ],  // 103.236.20.0-103.236.23.255, HL
        [ 0x67EC1800, 0x67EC1BFF, "ZJ" ],  // 103.236.24.0-103.236.27.255, ZJ
        [ 0x67EC1C00, 0x67EC1FFF, "AH" ],  // 103.236.28.0-103.236.31.255, AH
        [ 0x67EC2000, 0x67EC23FF, "SD" ],  // 103.236.32.0-103.236.35.255, SD
        [ 0x67EC2400, 0x67EC27FF, "ZJ" ],  // 103.236.36.0-103.236.39.255, ZJ
        [ 0x67EC2800, 0x67EC2BFF, "SD" ],  // 103.236.40.0-103.236.43.255, SD
        [ 0x67EC2C00, 0x67EC2FFF, "FJ" ],  // 103.236.44.0-103.236.47.255, FJ
        [ 0x67EC3000, 0x67EC33FF, "SH" ],  // 103.236.48.0-103.236.51.255, SH
        [ 0x67EC3400, 0x67EC37FF, "GD" ],  // 103.236.52.0-103.236.55.255, GD
        [ 0x67EC3800, 0x67EC3BFF, "LN" ],  // 103.236.56.0-103.236.59.255, LN
        [ 0x67EC3C00, 0x67EC3FFF, "HE" ],  // 103.236.60.0-103.236.63.255, HE
        [ 0x67EC4000, 0x67EC43FF, "TJ" ],  // 103.236.64.0-103.236.67.255, TJ
        [ 0x67EC4400, 0x67EC47FF, "JS" ],  // 103.236.68.0-103.236.71.255, JS
        [ 0x67EC4800, 0x67EC4BFF, "HB" ],  // 103.236.72.0-103.236.75.255, HB
        [ 0x67EC4C00, 0x67EC4FFF, "SN" ],  // 103.236.76.0-103.236.79.255, SN
        [ 0x67EC5000, 0x67EC53FF, "SD" ],  // 103.236.80.0-103.236.83.255, SD
        [ 0x67EC5400, 0x67EC57FF, "HN" ],  // 103.236.84.0-103.236.87.255, HN
        [ 0x67EC5800, 0x67EC5BFF, "HA" ],  // 103.236.88.0-103.236.91.255, HA
        [ 0x67EC5C00, 0x67EC5FFF, "CQ" ],  // 103.236.92.0-103.236.95.255, CQ
        [ 0x67EC6000, 0x67EC63FF, "JS" ],  // 103.236.96.0-103.236.99.255, JS
        [ 0x67EC7400, 0x67EC75FF, "BJ" ],  // 103.236.116.0-103.236.117.255, BJ
        [ 0x67EC7800, 0x67EC7BFF, "HE" ],  // 103.236.120.0-103.236.123.255, HE
        [ 0x67ECB800, 0x67ECBBFF, "BJ" ],  // 103.236.184.0-103.236.187.255, BJ
        [ 0x67ECDC00, 0x67ECDCFF, "GZ" ],  // 103.236.220.0-103.236.220.255, GZ
        [ 0x67ECDD00, 0x67ECDFFF, "HL" ],  // 103.236.221.0-103.236.223.255, HL
        [ 0x67ECF000, 0x67ECF3FF, "JS" ],  // 103.236.240.0-103.236.243.255, JS
        [ 0x67ECF400, 0x67ECF7FF, "BJ" ],  // 103.236.244.0-103.236.247.255, BJ
        [ 0x67ECF800, 0x67ECFFFF, "FJ" ],  // 103.236.248.0-103.236.255.255, FJ
        [ 0x67ED0000, 0x67ED0FFF, "BJ" ],  // 103.237.0.0-103.237.15.255, BJ
        [ 0x67ED1800, 0x67ED1FFF, "TJ" ],  // 103.237.24.0-103.237.31.255, TJ
        [ 0x67ED4400, 0x67ED47FF, "HE" ],  // 103.237.68.0-103.237.71.255, HE
        [ 0x67ED5800, 0x67ED5BFF, "BJ" ],  // 103.237.88.0-103.237.91.255, BJ
        [ 0x67ED5C00, 0x67ED5DFF, "SH" ],  // 103.237.92.0-103.237.93.255, SH
        [ 0x67ED9800, 0x67ED9BFF, "LN" ],  // 103.237.152.0-103.237.155.255, LN
        [ 0x67EDB000, 0x67EDF7FF, "HA" ],  // 103.237.176.0-103.237.247.255, HA
        [ 0x67EDF800, 0x67EE07FF, "BJ" ],  // 103.237.248.0-103.238.7.255, BJ
        [ 0x67EE1000, 0x67EE13FF, "GD" ],  // 103.238.16.0-103.238.19.255, GD
        [ 0x67EE1400, 0x67EE17FF, "BJ" ],  // 103.238.20.0-103.238.23.255, BJ
        [ 0x67EE1800, 0x67EE1BFF, "SC" ],  // 103.238.24.0-103.238.27.255, SC
        [ 0x67EE1C00, 0x67EE1FFF, "GS" ],  // 103.238.28.0-103.238.31.255, GS
        [ 0x67EE2000, 0x67EE23FF, "GZ" ],  // 103.238.32.0-103.238.35.255, GZ
        [ 0x67EE2400, 0x67EE27FF, "SC" ],  // 103.238.36.0-103.238.39.255, SC
        [ 0x67EE2800, 0x67EE2BFF, "JS" ],  // 103.238.40.0-103.238.43.255, JS
        [ 0x67EE2C00, 0x67EE2FFF, "GZ" ],  // 103.238.44.0-103.238.47.255, GZ
        [ 0x67EE3000, 0x67EE33FF, "BJ" ],  // 103.238.48.0-103.238.51.255, BJ
        [ 0x67EE3400, 0x67EE37FF, "ZJ" ],  // 103.238.52.0-103.238.55.255, ZJ
        [ 0x67EE3800, 0x67EE3BFF, "BJ" ],  // 103.238.56.0-103.238.59.255, BJ
        [ 0x67EE5800, 0x67EE5BFF, "NM" ],  // 103.238.88.0-103.238.91.255, NM
        [ 0x67EE5C00, 0x67EE63FF, "BJ" ],  // 103.238.92.0-103.238.99.255, BJ
        [ 0x67EE8400, 0x67EE87FF, "BJ" ],  // 103.238.132.0-103.238.135.255, BJ
        [ 0x67EE8C00, 0x67EE8FFF, "SH" ],  // 103.238.140.0-103.238.143.255, SH
        [ 0x67EE9000, 0x67EE93FF, "BJ" ],  // 103.238.144.0-103.238.147.255, BJ
        [ 0x67EE9800, 0x67EE98FF, "BJ" ],  // 103.238.152.0-103.238.152.255, BJ
        [ 0x67EEA000, 0x67EEA3FF, "TJ" ],  // 103.238.160.0-103.238.163.255, TJ
        [ 0x67EEA400, 0x67EEABFF, "SH" ],  // 103.238.164.0-103.238.171.255, SH
        [ 0x67EEAC00, 0x67EEB3FF, "HI" ],  // 103.238.172.0-103.238.179.255, HI
        [ 0x67EEB400, 0x67EEBBFF, "SH" ],  // 103.238.180.0-103.238.187.255, SH
        [ 0x67EEBC00, 0x67EEBFFF, "GD" ],  // 103.238.188.0-103.238.191.255, GD
        [ 0x67EEC400, 0x67EEC7FF, "BJ" ],  // 103.238.196.0-103.238.199.255, BJ
        [ 0x67EECC00, 0x67EECFFF, "BJ" ],  // 103.238.204.0-103.238.207.255, BJ
        [ 0x67EEFC00, 0x67EEFFFF, "HA" ],  // 103.238.252.0-103.238.255.255, HA
        [ 0x67EF0000, 0x67EF03FF, "SH" ],  // 103.239.0.0-103.239.3.255, SH
        [ 0x67EF2C00, 0x67EF2FFF, "JS" ],  // 103.239.44.0-103.239.47.255, JS
        [ 0x67EF4400, 0x67EF47FF, "BJ" ],  // 103.239.68.0-103.239.71.255, BJ
        [ 0x67EF9800, 0x67EF9BFF, "SD" ],  // 103.239.152.0-103.239.155.255, SD
        [ 0x67EF9C00, 0x67EF9FFF, "BJ" ],  // 103.239.156.0-103.239.159.255, BJ
        [ 0x67EFB400, 0x67EFBBFF, "ZJ" ],  // 103.239.180.0-103.239.187.255, ZJ
        [ 0x67EFC000, 0x67EFC3FF, "BJ" ],  // 103.239.192.0-103.239.195.255, BJ
        [ 0x67EFC400, 0x67EFC7FF, "SH" ],  // 103.239.196.0-103.239.199.255, SH
        [ 0x67EFCC00, 0x67EFD3FF, "GD" ],  // 103.239.204.0-103.239.211.255, GD
        [ 0x67EFE000, 0x67EFE3FF, "SD" ],  // 103.239.224.0-103.239.227.255, SD
        [ 0x67EFF400, 0x67EFF7FF, "JS" ],  // 103.239.244.0-103.239.247.255, JS
        [ 0x67F01000, 0x67F013FF, "BJ" ],  // 103.240.16.0-103.240.19.255, BJ
        [ 0x67F02400, 0x67F027FF, "GS" ],  // 103.240.36.0-103.240.39.255, GS
        [ 0x67F02A00, 0x67F02BFF, "BJ" ],  // 103.240.42.0-103.240.43.255, BJ
        [ 0x67F04800, 0x67F04BFF, "AH" ],  // 103.240.72.0-103.240.75.255, AH
        [ 0x67F05400, 0x67F057FF, "FJ" ],  // 103.240.84.0-103.240.87.255, FJ
        [ 0x67F07C00, 0x67F07FFF, "JX" ],  // 103.240.124.0-103.240.127.255, JX
        [ 0x67F0AC00, 0x67F0AFFF, "BJ" ],  // 103.240.172.0-103.240.175.255, BJ
        [ 0x67F0BC00, 0x67F0BFFF, "LN" ],  // 103.240.188.0-103.240.191.255, LN
        [ 0x67F0C800, 0x67F0C9FF, "SH" ],  // 103.240.200.0-103.240.201.255, SH
        [ 0x67F0CA00, 0x67F0CBFF, "BJ" ],  // 103.240.202.0-103.240.203.255, BJ
        [ 0x67F0F400, 0x67F0F7FF, "BJ" ],  // 103.240.244.0-103.240.247.255, BJ
        [ 0x67F10C00, 0x67F10FFF, "BJ" ],  // 103.241.12.0-103.241.15.255, BJ
        [ 0x67F15C00, 0x67F163FF, "NM" ],  // 103.241.92.0-103.241.99.255, NM
        [ 0x67F1A000, 0x67F1A3FF, "GD" ],  // 103.241.160.0-103.241.163.255, GD
        [ 0x67F1AC00, 0x67F1ADFF, "BJ" ],  // 103.241.172.0-103.241.173.255, BJ
        [ 0x67F1B800, 0x67F1BBFF, "SH" ],  // 103.241.184.0-103.241.187.255, SH
        [ 0x67F1BC00, 0x67F1BFFF, "GX" ],  // 103.241.188.0-103.241.191.255, GX
        [ 0x67F1DC00, 0x67F1DFFF, "TJ" ],  // 103.241.220.0-103.241.223.255, TJ
        [ 0x67F24000, 0x67F243FF, "BJ" ],  // 103.242.64.0-103.242.67.255, BJ
        [ 0x67F28000, 0x67F282FF, "SH" ],  // 103.242.128.0-103.242.130.255, SH
        [ 0x67F28300, 0x67F283FF, "BJ" ],  // 103.242.131.0-103.242.131.255, BJ
        [ 0x67F28400, 0x67F287FF, "SC" ],  // 103.242.132.0-103.242.135.255, SC
        [ 0x67F2A000, 0x67F2A3FF, "BJ" ],  // 103.242.160.0-103.242.163.255, BJ
        [ 0x67F2A800, 0x67F2ABFF, "SH" ],  // 103.242.168.0-103.242.171.255, SH
        [ 0x67F2AC00, 0x67F2B3FF, "BJ" ],  // 103.242.172.0-103.242.179.255, BJ
        [ 0x67F2C800, 0x67F2CBFF, "BJ" ],  // 103.242.200.0-103.242.203.255, BJ
        [ 0x67F2D400, 0x67F2D7FF, "GZ" ],  // 103.242.212.0-103.242.215.255, GZ
        [ 0x67F2DC00, 0x67F2DFFF, "BJ" ],  // 103.242.220.0-103.242.223.255, BJ
        [ 0x67F2F000, 0x67F2F3FF, "BJ" ],  // 103.242.240.0-103.242.243.255, BJ
        [ 0x67F38800, 0x67F38BFF, "NM" ],  // 103.243.136.0-103.243.139.255, NM
        [ 0x67F3FC00, 0x67F3FFFF, "SH" ],  // 103.243.252.0-103.243.255.255, SH
        [ 0x67F41000, 0x67F413FF, "ZJ" ],  // 103.244.16.0-103.244.19.255, ZJ
        [ 0x67F41A00, 0x67F41BFF, "BJ" ],  // 103.244.26.0-103.244.27.255, BJ
        [ 0x67F43A00, 0x67F443FF, "BJ" ],  // 103.244.58.0-103.244.67.255, BJ
        [ 0x67F44400, 0x67F447FF, "ZJ" ],  // 103.244.68.0-103.244.71.255, ZJ
        [ 0x67F44800, 0x67F457FF, "BJ" ],  // 103.244.72.0-103.244.87.255, BJ
        [ 0x67F49120, 0x67F4912B, "BJ" ],  // 103.244.145.32-103.244.145.43, BJ
        [ 0x67F4A400, 0x67F4A7FF, "TJ" ],  // 103.244.164.0-103.244.167.255, TJ
        [ 0x67F4E800, 0x67F4EBFF, "BJ" ],  // 103.244.232.0-103.244.235.255, BJ
        [ 0x67F4FC00, 0x67F4FFFF, "BJ" ],  // 103.244.252.0-103.244.255.255, BJ
        [ 0x67F51700, 0x67F517FF, "BJ" ],  // 103.245.23.0-103.245.23.255, BJ
        [ 0x67F51800, 0x67F519FF, "GD" ],  // 103.245.24.0-103.245.25.255, GD
        [ 0x67F53400, 0x67F537FF, "SH" ],  // 103.245.52.0-103.245.55.255, SH
        [ 0x67F53C00, 0x67F53FFF, "BJ" ],  // 103.245.60.0-103.245.63.255, BJ
        [ 0x67F55000, 0x67F553FF, "SH" ],  // 103.245.80.0-103.245.83.255, SH
        [ 0x67F57C00, 0x67F57FFF, "GD" ],  // 103.245.124.0-103.245.127.255, GD
        [ 0x67F58000, 0x67F583FF, "BJ" ],  // 103.245.128.0-103.245.131.255, BJ
        [ 0x67F60800, 0x67F60BFF, "HN" ],  // 103.246.8.0-103.246.11.255, HN
        [ 0x67F60C00, 0x67F60FFF, "BJ" ],  // 103.246.12.0-103.246.15.255, BJ
        [ 0x67F67800, 0x67F67BFF, "SX" ],  // 103.246.120.0-103.246.123.255, SX
        [ 0x67F67C00, 0x67F67FFF, "ZJ" ],  // 103.246.124.0-103.246.127.255, ZJ
        [ 0x67F68400, 0x67F687FF, "SH" ],  // 103.246.132.0-103.246.135.255, SH
        [ 0x67F69800, 0x67F69BFF, "ZJ" ],  // 103.246.152.0-103.246.155.255, ZJ
        [ 0x67F69C00, 0x67F69FFF, "GD" ],  // 103.246.156.0-103.246.159.255, GD
        [ 0x67F7A800, 0x67F7B3FF, "BJ" ],  // 103.247.168.0-103.247.179.255, BJ
        [ 0x67F7BF00, 0x67F7BFFF, "GD" ],  // 103.247.191.0-103.247.191.255, GD
        [ 0x67F7C800, 0x67F7CBFF, "SH" ],  // 103.247.200.0-103.247.203.255, SH
        [ 0x67F7D400, 0x67F7D7FF, "BJ" ],  // 103.247.212.0-103.247.215.255, BJ
        [ 0x67F84000, 0x67F843FF, "SD" ],  // 103.248.64.0-103.248.67.255, SD
        [ 0x67F86400, 0x67F867FF, "TJ" ],  // 103.248.100.0-103.248.103.255, TJ
        [ 0x67F87C00, 0x67F87FFF, "ZJ" ],  // 103.248.124.0-103.248.127.255, ZJ
        [ 0x67F89800, 0x67F89BFF, "ZJ" ],  // 103.248.152.0-103.248.155.255, ZJ
        [ 0x67F8A800, 0x67F8ABFF, "GD" ],  // 103.248.168.0-103.248.171.255, GD
        [ 0x67F8C000, 0x67F8C3FF, "SH" ],  // 103.248.192.0-103.248.195.255, SH
        [ 0x67F8D400, 0x67F8D7FF, "CQ" ],  // 103.248.212.0-103.248.215.255, CQ
        [ 0x67F8E000, 0x67F8E3FF, "GD" ],  // 103.248.224.0-103.248.227.255, GD
        [ 0x67F90800, 0x67F90BFF, "SH" ],  // 103.249.8.0-103.249.11.255, SH
        [ 0x67F90C00, 0x67F90FFF, "GD" ],  // 103.249.12.0-103.249.15.255, GD
        [ 0x67F93400, 0x67F937FF, "BJ" ],  // 103.249.52.0-103.249.55.255, BJ
        [ 0x67F98000, 0x67F983FF, "BJ" ],  // 103.249.128.0-103.249.131.255, BJ
        [ 0x67F98800, 0x67F988FF, "SH" ],  // 103.249.136.0-103.249.136.255, SH
        [ 0x67F98900, 0x67F98BFF, "BJ" ],  // 103.249.137.0-103.249.139.255, BJ
        [ 0x67F99000, 0x67F993FF, "BJ" ],  // 103.249.144.0-103.249.147.255, BJ
        [ 0x67F9A400, 0x67F9B3FF, "BJ" ],  // 103.249.164.0-103.249.179.255, BJ
        [ 0x67F9BC00, 0x67F9BFFF, "BJ" ],  // 103.249.188.0-103.249.191.255, BJ
        [ 0x67F9C000, 0x67F9C3FF, "GD" ],  // 103.249.192.0-103.249.195.255, GD
        [ 0x67F9F400, 0x67F9F7FF, "BJ" ],  // 103.249.244.0-103.249.247.255, BJ
        [ 0x67F9FC00, 0x67F9FFFF, "BJ" ],  // 103.249.252.0-103.249.255.255, BJ
        [ 0x67FA2000, 0x67FA23FF, "JL" ],  // 103.250.32.0-103.250.35.255, JL
        [ 0x67FA6800, 0x67FA6BFF, "LN" ],  // 103.250.104.0-103.250.107.255, LN
        [ 0x67FA7C00, 0x67FA7FFF, "SD" ],  // 103.250.124.0-103.250.127.255, SD
        [ 0x67FAB400, 0x67FAB7FF, "HA" ],  // 103.250.180.0-103.250.183.255, HA
        [ 0x67FAC000, 0x67FAC3FF, "SH" ],  // 103.250.192.0-103.250.195.255, SH
        [ 0x67FAD800, 0x67FADBFF, "JS" ],  // 103.250.216.0-103.250.219.255, JS
        [ 0x67FAE000, 0x67FAE3FF, "BJ" ],  // 103.250.224.0-103.250.227.255, BJ
        [ 0x67FAEC00, 0x67FAEFFF, "SH" ],  // 103.250.236.0-103.250.239.255, SH
        [ 0x67FAF800, 0x67FAFBFF, "HN" ],  // 103.250.248.0-103.250.251.255, HN
        [ 0x67FAFC00, 0x67FAFFFF, "JX" ],  // 103.250.252.0-103.250.255.255, JX
        [ 0x67FB2000, 0x67FB23FF, "GD" ],  // 103.251.32.0-103.251.35.255, GD
        [ 0x67FB5400, 0x67FB57FF, "SH" ],  // 103.251.84.0-103.251.87.255, SH
        [ 0x67FB6000, 0x67FB63FF, "GX" ],  // 103.251.96.0-103.251.99.255, GX
        [ 0x67FB7C00, 0x67FB7FFF, "HI" ],  // 103.251.124.0-103.251.127.255, HI
        [ 0x67FBA000, 0x67FBA3FF, "QH" ],  // 103.251.160.0-103.251.163.255, QH
        [ 0x67FBC000, 0x67FBC3FF, "SH" ],  // 103.251.192.0-103.251.195.255, SH
        [ 0x67FBCC00, 0x67FBCDFF, "BJ" ],  // 103.251.204.0-103.251.205.255, BJ
        [ 0x67FBCE00, 0x67FBCFFF, "SH" ],  // 103.251.206.0-103.251.207.255, SH
        [ 0x67FBF000, 0x67FBF3FF, "NX" ],  // 103.251.240.0-103.251.243.255, NX
        [ 0x67FC1C00, 0x67FC1FFF, "GD" ],  // 103.252.28.0-103.252.31.255, GD
        [ 0x67FC2400, 0x67FC27FF, "BJ" ],  // 103.252.36.0-103.252.39.255, BJ
        [ 0x67FC4000, 0x67FC43FF, "BJ" ],  // 103.252.64.0-103.252.67.255, BJ
        [ 0x67FC6000, 0x67FC63FF, "SH" ],  // 103.252.96.0-103.252.99.255, SH
        [ 0x67FC6800, 0x67FC6BFF, "BJ" ],  // 103.252.104.0-103.252.107.255, BJ
        [ 0x67FCAC00, 0x67FCAFFF, "JS" ],  // 103.252.172.0-103.252.175.255, JS
        [ 0x67FCCC00, 0x67FCD3FF, "TJ" ],  // 103.252.204.0-103.252.211.255, TJ
        [ 0x67FCE800, 0x67FCEBFF, "TJ" ],  // 103.252.232.0-103.252.235.255, TJ
        [ 0x67FCF800, 0x67FCFBFF, "TJ" ],  // 103.252.248.0-103.252.251.255, TJ
        [ 0x67FD0400, 0x67FD07FF, "BJ" ],  // 103.253.4.0-103.253.7.255, BJ
        [ 0x67FD3C00, 0x67FD3FFF, "HE" ],  // 103.253.60.0-103.253.63.255, HE
        [ 0x67FDCC00, 0x67FDCFFF, "SH" ],  // 103.253.204.0-103.253.207.255, SH
        [ 0x67FDDC00, 0x67FDDFFF, "SD" ],  // 103.253.220.0-103.253.223.255, SD
        [ 0x67FDE000, 0x67FDE3FF, "AH" ],  // 103.253.224.0-103.253.227.255, AH
        [ 0x67FDE800, 0x67FDEBFF, "BJ" ],  // 103.253.232.0-103.253.235.255, BJ
        [ 0x67FE0800, 0x67FE0BFF, "JL" ],  // 103.254.8.0-103.254.11.255, JL
        [ 0x67FE1400, 0x67FE17FF, "JL" ],  // 103.254.20.0-103.254.23.255, JL
        [ 0x67FE4000, 0x67FE47FF, "BJ" ],  // 103.254.64.0-103.254.71.255, BJ
        [ 0x67FE4C00, 0x67FE4FFF, "SD" ],  // 103.254.76.0-103.254.79.255, SD
        [ 0x67FE7000, 0x67FE73FF, "BJ" ],  // 103.254.112.0-103.254.115.255, BJ
        [ 0x67FEB000, 0x67FEB3FF, "BJ" ],  // 103.254.176.0-103.254.179.255, BJ
        [ 0x67FEBC00, 0x67FEBFFF, "BJ" ],  // 103.254.188.0-103.254.191.255, BJ
        [ 0x67FEC400, 0x67FEC4FF, "SH" ],  // 103.254.196.0-103.254.196.255, SH
        [ 0x67FF4400, 0x67FF47FF, "BJ" ],  // 103.255.68.0-103.255.71.255, BJ
        [ 0x67FF5800, 0x67FF5BFF, "BJ" ],  // 103.255.88.0-103.255.91.255, BJ
        [ 0x67FF5C00, 0x67FF5FFF, "JS" ],  // 103.255.92.0-103.255.95.255, JS
        [ 0x67FF8800, 0x67FF8BFF, "JS" ],  // 103.255.136.0-103.255.139.255, JS
        [ 0x67FF8C00, 0x67FF8FFF, "BJ" ],  // 103.255.140.0-103.255.143.255, BJ
        [ 0x67FFB800, 0x67FFBBFF, "BJ" ],  // 103.255.184.0-103.255.187.255, BJ
        [ 0x67FFC800, 0x67FFCBFF, "JS" ],  // 103.255.200.0-103.255.203.255, JS
        [ 0x67FFD400, 0x67FFD7FF, "BJ" ],  // 103.255.212.0-103.255.215.255, BJ
        [ 0x67FFE400, 0x67FFE7FF, "BJ" ],  // 103.255.228.0-103.255.231.255, BJ
        [ 0x681C092E, 0x681C0930, "BJ" ],  // 104.28.9.46-104.28.9.48, BJ
        [ 0x681C2B24, 0x681C2B25, "JS" ],  // 104.28.43.36-104.28.43.37, JS
        [ 0x681C2B26, 0x681C2B27, "SH" ],  // 104.28.43.38-104.28.43.39, SH
        [ 0x681C2B28, 0x681C2B29, "GD" ],  // 104.28.43.40-104.28.43.41, GD
        [ 0x681C2B2A, 0x681C2B2B, "ZJ" ],  // 104.28.43.42-104.28.43.43, ZJ
        [ 0x681C2B2C, 0x681C2B31, "GD" ],  // 104.28.43.44-104.28.43.49, GD
        [ 0x681C2B32, 0x681C2B33, "GX" ],  // 104.28.43.50-104.28.43.51, GX
        [ 0x681C2B34, 0x681C2B35, "GD" ],  // 104.28.43.52-104.28.43.53, GD
        [ 0x681C2B36, 0x681C2B37, "JX" ],  // 104.28.43.54-104.28.43.55, JX
        [ 0x681C420F, 0x681C4211, "XJ" ],  // 104.28.66.15-104.28.66.17, XJ
        [ 0x681C421E, 0x681C421F, "JS" ],  // 104.28.66.30-104.28.66.31, JS
        [ 0x681C4220, 0x681C4221, "SH" ],  // 104.28.66.32-104.28.66.33, SH
        [ 0x681C4222, 0x681C4223, "JL" ],  // 104.28.66.34-104.28.66.35, JL
        [ 0x681C4224, 0x681C4225, "SD" ],  // 104.28.66.36-104.28.66.37, SD
        [ 0x681C4226, 0x681C4227, "HB" ],  // 104.28.66.38-104.28.66.39, HB
        [ 0x681C4228, 0x681C4229, "GD" ],  // 104.28.66.40-104.28.66.41, GD
        [ 0x681C422A, 0x681C422B, "ZJ" ],  // 104.28.66.42-104.28.66.43, ZJ
        [ 0x681C422C, 0x681C422D, "TJ" ],  // 104.28.66.44-104.28.66.45, TJ
        [ 0x681C422E, 0x681C4233, "HA" ],  // 104.28.66.46-104.28.66.51, HA
        [ 0x681C4234, 0x681C4235, "HE" ],  // 104.28.66.52-104.28.66.53, HE
        [ 0x681C4236, 0x681C4237, "SD" ],  // 104.28.66.54-104.28.66.55, SD
        [ 0x681C4238, 0x681C4239, "BJ" ],  // 104.28.66.56-104.28.66.57, BJ
        [ 0x681C423A, 0x681C423B, "GD" ],  // 104.28.66.58-104.28.66.59, GD
        [ 0x681C423C, 0x681C423D, "JS" ],  // 104.28.66.60-104.28.66.61, JS
        [ 0x681C423E, 0x681C423F, "SN" ],  // 104.28.66.62-104.28.66.63, SN
        [ 0x681C4240, 0x681C4241, "AH" ],  // 104.28.66.64-104.28.66.65, AH
        [ 0x681C4242, 0x681C4243, "HE" ],  // 104.28.66.66-104.28.66.67, HE
        [ 0x681C4244, 0x681C4245, "HA" ],  // 104.28.66.68-104.28.66.69, HA
        [ 0x681C4246, 0x681C4247, "LN" ],  // 104.28.66.70-104.28.66.71, LN
        [ 0x681C424A, 0x681C424B, "AH" ],  // 104.28.66.74-104.28.66.75, AH
        [ 0x681C424C, 0x681C424D, "SC" ],  // 104.28.66.76-104.28.66.77, SC
        [ 0x681C424E, 0x681C424F, "GD" ],  // 104.28.66.78-104.28.66.79, GD
        [ 0x681C4250, 0x681C4251, "SD" ],  // 104.28.66.80-104.28.66.81, SD
        [ 0x681C4252, 0x681C4253, "GD" ],  // 104.28.66.82-104.28.66.83, GD
        [ 0x681C4254, 0x681C4255, "GX" ],  // 104.28.66.84-104.28.66.85, GX
        [ 0x681C4256, 0x681C4257, "JS" ],  // 104.28.66.86-104.28.66.87, JS
        [ 0x681C4258, 0x681C4259, "HN" ],  // 104.28.66.88-104.28.66.89, HN
        [ 0x681C425A, 0x681C425B, "GD" ],  // 104.28.66.90-104.28.66.91, GD
        [ 0x681C425C, 0x681C425D, "JX" ],  // 104.28.66.92-104.28.66.93, JX
        [ 0x681C4260, 0x681C4261, "SD" ],  // 104.28.66.96-104.28.66.97, SD
        [ 0x681C4262, 0x681C4263, "CQ" ],  // 104.28.66.98-104.28.66.99, CQ
        [ 0x681C4264, 0x681C4265, "HE" ],  // 104.28.66.100-104.28.66.101, HE
        [ 0x681C4266, 0x681C4267, "HN" ],  // 104.28.66.102-104.28.66.103, HN
        [ 0x681C4268, 0x681C4269, "JS" ],  // 104.28.66.104-104.28.66.105, JS
        [ 0x681C5302, 0x681C5303, "JS" ],  // 104.28.83.2-104.28.83.3, JS
        [ 0x681C5304, 0x681C5305, "SH" ],  // 104.28.83.4-104.28.83.5, SH
        [ 0x681C5306, 0x681C5307, "JL" ],  // 104.28.83.6-104.28.83.7, JL
        [ 0x681C5308, 0x681C5309, "SD" ],  // 104.28.83.8-104.28.83.9, SD
        [ 0x681C530A, 0x681C530B, "HB" ],  // 104.28.83.10-104.28.83.11, HB
        [ 0x681C530C, 0x681C530D, "GD" ],  // 104.28.83.12-104.28.83.13, GD
        [ 0x681C530E, 0x681C530F, "ZJ" ],  // 104.28.83.14-104.28.83.15, ZJ
        [ 0x681C5310, 0x681C5311, "TJ" ],  // 104.28.83.16-104.28.83.17, TJ
        [ 0x681C5312, 0x681C5317, "HA" ],  // 104.28.83.18-104.28.83.23, HA
        [ 0x681C5318, 0x681C5319, "HE" ],  // 104.28.83.24-104.28.83.25, HE
        [ 0x681C531A, 0x681C531B, "SD" ],  // 104.28.83.26-104.28.83.27, SD
        [ 0x681C531C, 0x681C531D, "BJ" ],  // 104.28.83.28-104.28.83.29, BJ
        [ 0x681C531E, 0x681C531F, "GD" ],  // 104.28.83.30-104.28.83.31, GD
        [ 0x681C5320, 0x681C5321, "JS" ],  // 104.28.83.32-104.28.83.33, JS
        [ 0x681C5322, 0x681C5323, "SN" ],  // 104.28.83.34-104.28.83.35, SN
        [ 0x681C5324, 0x681C5325, "AH" ],  // 104.28.83.36-104.28.83.37, AH
        [ 0x681C5326, 0x681C5327, "HE" ],  // 104.28.83.38-104.28.83.39, HE
        [ 0x681C5328, 0x681C5329, "HA" ],  // 104.28.83.40-104.28.83.41, HA
        [ 0x681C532A, 0x681C532B, "LN" ],  // 104.28.83.42-104.28.83.43, LN
        [ 0x681C532E, 0x681C532F, "AH" ],  // 104.28.83.46-104.28.83.47, AH
        [ 0x681C5330, 0x681C5331, "SC" ],  // 104.28.83.48-104.28.83.49, SC
        [ 0x681C5332, 0x681C5333, "GD" ],  // 104.28.83.50-104.28.83.51, GD
        [ 0x681C5334, 0x681C5335, "SD" ],  // 104.28.83.52-104.28.83.53, SD
        [ 0x681C5336, 0x681C5337, "GD" ],  // 104.28.83.54-104.28.83.55, GD
        [ 0x681C5338, 0x681C5339, "GX" ],  // 104.28.83.56-104.28.83.57, GX
        [ 0x681C533A, 0x681C533B, "JS" ],  // 104.28.83.58-104.28.83.59, JS
        [ 0x681C533C, 0x681C533D, "HN" ],  // 104.28.83.60-104.28.83.61, HN
        [ 0x681C533E, 0x681C533F, "GD" ],  // 104.28.83.62-104.28.83.63, GD
        [ 0x681C5340, 0x681C5341, "JX" ],  // 104.28.83.64-104.28.83.65, JX
        [ 0x681C5344, 0x681C5345, "SD" ],  // 104.28.83.68-104.28.83.69, SD
        [ 0x681C5346, 0x681C5347, "CQ" ],  // 104.28.83.70-104.28.83.71, CQ
        [ 0x681C5348, 0x681C5349, "HE" ],  // 104.28.83.72-104.28.83.73, HE
        [ 0x681C534A, 0x681C534B, "HN" ],  // 104.28.83.74-104.28.83.75, HN
        [ 0x681C534C, 0x681C534D, "JS" ],  // 104.28.83.76-104.28.83.77, JS
        [ 0x681C6300, 0x681C6301, "JS" ],  // 104.28.99.0-104.28.99.1, JS
        [ 0x681C6302, 0x681C6303, "SH" ],  // 104.28.99.2-104.28.99.3, SH
        [ 0x681C6304, 0x681C6305, "JL" ],  // 104.28.99.4-104.28.99.5, JL
        [ 0x681C6306, 0x681C6307, "SD" ],  // 104.28.99.6-104.28.99.7, SD
        [ 0x681C6308, 0x681C6309, "HB" ],  // 104.28.99.8-104.28.99.9, HB
        [ 0x681C630A, 0x681C630B, "GD" ],  // 104.28.99.10-104.28.99.11, GD
        [ 0x681C630C, 0x681C630D, "ZJ" ],  // 104.28.99.12-104.28.99.13, ZJ
        [ 0x681C630E, 0x681C630F, "TJ" ],  // 104.28.99.14-104.28.99.15, TJ
        [ 0x681C6310, 0x681C6315, "HA" ],  // 104.28.99.16-104.28.99.21, HA
        [ 0x681C6316, 0x681C6317, "HE" ],  // 104.28.99.22-104.28.99.23, HE
        [ 0x681C6318, 0x681C6319, "SD" ],  // 104.28.99.24-104.28.99.25, SD
        [ 0x681C631A, 0x681C631B, "BJ" ],  // 104.28.99.26-104.28.99.27, BJ
        [ 0x681C631C, 0x681C631D, "GD" ],  // 104.28.99.28-104.28.99.29, GD
        [ 0x681C631E, 0x681C631F, "JS" ],  // 104.28.99.30-104.28.99.31, JS
        [ 0x681C6320, 0x681C6321, "SN" ],  // 104.28.99.32-104.28.99.33, SN
        [ 0x681C6322, 0x681C6323, "AH" ],  // 104.28.99.34-104.28.99.35, AH
        [ 0x681C6324, 0x681C6325, "HE" ],  // 104.28.99.36-104.28.99.37, HE
        [ 0x681C6326, 0x681C6327, "HA" ],  // 104.28.99.38-104.28.99.39, HA
        [ 0x681C6328, 0x681C6329, "LN" ],  // 104.28.99.40-104.28.99.41, LN
        [ 0x681C632A, 0x681C632A, "XJ" ],  // 104.28.99.42-104.28.99.42, XJ
        [ 0x681C632C, 0x681C632D, "AH" ],  // 104.28.99.44-104.28.99.45, AH
        [ 0x681C632E, 0x681C632F, "GD" ],  // 104.28.99.46-104.28.99.47, GD
        [ 0x681C6330, 0x681C6331, "SD" ],  // 104.28.99.48-104.28.99.49, SD
        [ 0x681C6332, 0x681C6333, "GD" ],  // 104.28.99.50-104.28.99.51, GD
        [ 0x681C6334, 0x681C6335, "JS" ],  // 104.28.99.52-104.28.99.53, JS
        [ 0x681C6336, 0x681C6337, "HN" ],  // 104.28.99.54-104.28.99.55, HN
        [ 0x681C6338, 0x681C6339, "GD" ],  // 104.28.99.56-104.28.99.57, GD
        [ 0x681C633A, 0x681C633B, "JX" ],  // 104.28.99.58-104.28.99.59, JX
        [ 0x681C633E, 0x681C633F, "SD" ],  // 104.28.99.62-104.28.99.63, SD
        [ 0x681C6340, 0x681C6341, "CQ" ],  // 104.28.99.64-104.28.99.65, CQ
        [ 0x681C6342, 0x681C6343, "HE" ],  // 104.28.99.66-104.28.99.67, HE
        [ 0x681C6344, 0x681C6345, "HN" ],  // 104.28.99.68-104.28.99.69, HN
        [ 0x681C6346, 0x681C6347, "JS" ],  // 104.28.99.70-104.28.99.71, JS
        [ 0x681C6500, 0x681C6501, "JS" ],  // 104.28.101.0-104.28.101.1, JS
        [ 0x681C6502, 0x681C6503, "SH" ],  // 104.28.101.2-104.28.101.3, SH
        [ 0x681C6504, 0x681C6505, "JL" ],  // 104.28.101.4-104.28.101.5, JL
        [ 0x681C6506, 0x681C6507, "SD" ],  // 104.28.101.6-104.28.101.7, SD
        [ 0x681C6508, 0x681C6509, "HB" ],  // 104.28.101.8-104.28.101.9, HB
        [ 0x681C650A, 0x681C650B, "GD" ],  // 104.28.101.10-104.28.101.11, GD
        [ 0x681C650C, 0x681C650D, "ZJ" ],  // 104.28.101.12-104.28.101.13, ZJ
        [ 0x681C650E, 0x681C650F, "TJ" ],  // 104.28.101.14-104.28.101.15, TJ
        [ 0x681C6510, 0x681C6515, "HA" ],  // 104.28.101.16-104.28.101.21, HA
        [ 0x681C6516, 0x681C6517, "HE" ],  // 104.28.101.22-104.28.101.23, HE
        [ 0x681C6518, 0x681C6519, "SD" ],  // 104.28.101.24-104.28.101.25, SD
        [ 0x681C651A, 0x681C651B, "BJ" ],  // 104.28.101.26-104.28.101.27, BJ
        [ 0x681C651C, 0x681C651D, "GD" ],  // 104.28.101.28-104.28.101.29, GD
        [ 0x681C651E, 0x681C651F, "JS" ],  // 104.28.101.30-104.28.101.31, JS
        [ 0x681C6520, 0x681C6521, "SN" ],  // 104.28.101.32-104.28.101.33, SN
        [ 0x681C6522, 0x681C6523, "AH" ],  // 104.28.101.34-104.28.101.35, AH
        [ 0x681C6524, 0x681C6525, "HE" ],  // 104.28.101.36-104.28.101.37, HE
        [ 0x681C6526, 0x681C6527, "HA" ],  // 104.28.101.38-104.28.101.39, HA
        [ 0x681C6528, 0x681C6529, "LN" ],  // 104.28.101.40-104.28.101.41, LN
        [ 0x681C652C, 0x681C652D, "AH" ],  // 104.28.101.44-104.28.101.45, AH
        [ 0x681C652E, 0x681C652F, "GD" ],  // 104.28.101.46-104.28.101.47, GD
        [ 0x681C6530, 0x681C6531, "SD" ],  // 104.28.101.48-104.28.101.49, SD
        [ 0x681C6532, 0x681C6533, "GD" ],  // 104.28.101.50-104.28.101.51, GD
        [ 0x681C6534, 0x681C6535, "JS" ],  // 104.28.101.52-104.28.101.53, JS
        [ 0x681C6536, 0x681C6537, "HN" ],  // 104.28.101.54-104.28.101.55, HN
        [ 0x681C6538, 0x681C6539, "GD" ],  // 104.28.101.56-104.28.101.57, GD
        [ 0x681C653A, 0x681C653B, "JX" ],  // 104.28.101.58-104.28.101.59, JX
        [ 0x681C653E, 0x681C653F, "SD" ],  // 104.28.101.62-104.28.101.63, SD
        [ 0x681C6540, 0x681C6541, "CQ" ],  // 104.28.101.64-104.28.101.65, CQ
        [ 0x681C6542, 0x681C6543, "HE" ],  // 104.28.101.66-104.28.101.67, HE
        [ 0x681C6544, 0x681C6545, "HN" ],  // 104.28.101.68-104.28.101.69, HN
        [ 0x681C6546, 0x681C6547, "JS" ],  // 104.28.101.70-104.28.101.71, JS
        [ 0x681C7520, 0x681C7521, "JS" ],  // 104.28.117.32-104.28.117.33, JS
        [ 0x681C7522, 0x681C7523, "SH" ],  // 104.28.117.34-104.28.117.35, SH
        [ 0x681C7524, 0x681C7525, "JL" ],  // 104.28.117.36-104.28.117.37, JL
        [ 0x681C7526, 0x681C7527, "SD" ],  // 104.28.117.38-104.28.117.39, SD
        [ 0x681C7528, 0x681C7529, "HB" ],  // 104.28.117.40-104.28.117.41, HB
        [ 0x681C752A, 0x681C752B, "GD" ],  // 104.28.117.42-104.28.117.43, GD
        [ 0x681C752C, 0x681C752D, "ZJ" ],  // 104.28.117.44-104.28.117.45, ZJ
        [ 0x681C752E, 0x681C752F, "TJ" ],  // 104.28.117.46-104.28.117.47, TJ
        [ 0x681C7530, 0x681C7535, "HA" ],  // 104.28.117.48-104.28.117.53, HA
        [ 0x681C7536, 0x681C7537, "HE" ],  // 104.28.117.54-104.28.117.55, HE
        [ 0x681C7538, 0x681C7539, "SD" ],  // 104.28.117.56-104.28.117.57, SD
        [ 0x681C753A, 0x681C753B, "BJ" ],  // 104.28.117.58-104.28.117.59, BJ
        [ 0x681C753C, 0x681C753D, "GD" ],  // 104.28.117.60-104.28.117.61, GD
        [ 0x681C753E, 0x681C753F, "JS" ],  // 104.28.117.62-104.28.117.63, JS
        [ 0x681C7540, 0x681C7541, "SN" ],  // 104.28.117.64-104.28.117.65, SN
        [ 0x681C7542, 0x681C7543, "AH" ],  // 104.28.117.66-104.28.117.67, AH
        [ 0x681C7544, 0x681C7545, "HE" ],  // 104.28.117.68-104.28.117.69, HE
        [ 0x681C7546, 0x681C7547, "HA" ],  // 104.28.117.70-104.28.117.71, HA
        [ 0x681C7548, 0x681C7549, "LN" ],  // 104.28.117.72-104.28.117.73, LN
        [ 0x681C754C, 0x681C754D, "AH" ],  // 104.28.117.76-104.28.117.77, AH
        [ 0x681C754E, 0x681C754F, "SC" ],  // 104.28.117.78-104.28.117.79, SC
        [ 0x681C7550, 0x681C7551, "GD" ],  // 104.28.117.80-104.28.117.81, GD
        [ 0x681C7552, 0x681C7553, "SD" ],  // 104.28.117.82-104.28.117.83, SD
        [ 0x681C7554, 0x681C7555, "GD" ],  // 104.28.117.84-104.28.117.85, GD
        [ 0x681C7556, 0x681C7557, "GX" ],  // 104.28.117.86-104.28.117.87, GX
        [ 0x681C7558, 0x681C7559, "JS" ],  // 104.28.117.88-104.28.117.89, JS
        [ 0x681C755A, 0x681C755B, "HN" ],  // 104.28.117.90-104.28.117.91, HN
        [ 0x681C755C, 0x681C755D, "GD" ],  // 104.28.117.92-104.28.117.93, GD
        [ 0x681C755E, 0x681C755F, "JX" ],  // 104.28.117.94-104.28.117.95, JX
        [ 0x681C7562, 0x681C7563, "SD" ],  // 104.28.117.98-104.28.117.99, SD
        [ 0x681C7564, 0x681C7565, "CQ" ],  // 104.28.117.100-104.28.117.101, CQ
        [ 0x681C7566, 0x681C7567, "HE" ],  // 104.28.117.102-104.28.117.103, HE
        [ 0x681C7568, 0x681C7569, "HN" ],  // 104.28.117.104-104.28.117.105, HN
        [ 0x681C756A, 0x681C756B, "JS" ],  // 104.28.117.106-104.28.117.107, JS
        [ 0x681C7820, 0x681C7821, "JS" ],  // 104.28.120.32-104.28.120.33, JS
        [ 0x681C7822, 0x681C7823, "SH" ],  // 104.28.120.34-104.28.120.35, SH
        [ 0x681C7824, 0x681C7825, "JL" ],  // 104.28.120.36-104.28.120.37, JL
        [ 0x681C7826, 0x681C7827, "SD" ],  // 104.28.120.38-104.28.120.39, SD
        [ 0x681C7828, 0x681C7829, "HB" ],  // 104.28.120.40-104.28.120.41, HB
        [ 0x681C782A, 0x681C782B, "GD" ],  // 104.28.120.42-104.28.120.43, GD
        [ 0x681C782C, 0x681C782D, "ZJ" ],  // 104.28.120.44-104.28.120.45, ZJ
        [ 0x681C782E, 0x681C782F, "TJ" ],  // 104.28.120.46-104.28.120.47, TJ
        [ 0x681C7830, 0x681C7835, "HA" ],  // 104.28.120.48-104.28.120.53, HA
        [ 0x681C7836, 0x681C7837, "HE" ],  // 104.28.120.54-104.28.120.55, HE
        [ 0x681C7838, 0x681C7839, "SD" ],  // 104.28.120.56-104.28.120.57, SD
        [ 0x681C783A, 0x681C783B, "BJ" ],  // 104.28.120.58-104.28.120.59, BJ
        [ 0x681C783C, 0x681C783D, "GD" ],  // 104.28.120.60-104.28.120.61, GD
        [ 0x681C783E, 0x681C783F, "JS" ],  // 104.28.120.62-104.28.120.63, JS
        [ 0x681C7840, 0x681C7841, "SN" ],  // 104.28.120.64-104.28.120.65, SN
        [ 0x681C7842, 0x681C7843, "AH" ],  // 104.28.120.66-104.28.120.67, AH
        [ 0x681C7844, 0x681C7845, "HE" ],  // 104.28.120.68-104.28.120.69, HE
        [ 0x681C7846, 0x681C7847, "HA" ],  // 104.28.120.70-104.28.120.71, HA
        [ 0x681C7848, 0x681C7849, "LN" ],  // 104.28.120.72-104.28.120.73, LN
        [ 0x681C784C, 0x681C784D, "AH" ],  // 104.28.120.76-104.28.120.77, AH
        [ 0x681C784E, 0x681C784F, "SC" ],  // 104.28.120.78-104.28.120.79, SC
        [ 0x681C7850, 0x681C7851, "GD" ],  // 104.28.120.80-104.28.120.81, GD
        [ 0x681C7852, 0x681C7853, "SD" ],  // 104.28.120.82-104.28.120.83, SD
        [ 0x681C7854, 0x681C7855, "GD" ],  // 104.28.120.84-104.28.120.85, GD
        [ 0x681C7856, 0x681C7857, "GX" ],  // 104.28.120.86-104.28.120.87, GX
        [ 0x681C7858, 0x681C7859, "JS" ],  // 104.28.120.88-104.28.120.89, JS
        [ 0x681C785A, 0x681C785B, "HN" ],  // 104.28.120.90-104.28.120.91, HN
        [ 0x681C785C, 0x681C785D, "GD" ],  // 104.28.120.92-104.28.120.93, GD
        [ 0x681C785E, 0x681C785F, "JX" ],  // 104.28.120.94-104.28.120.95, JX
        [ 0x681C7862, 0x681C7863, "SD" ],  // 104.28.120.98-104.28.120.99, SD
        [ 0x681C7864, 0x681C7865, "CQ" ],  // 104.28.120.100-104.28.120.101, CQ
        [ 0x681C7866, 0x681C7867, "HE" ],  // 104.28.120.102-104.28.120.103, HE
        [ 0x681C7868, 0x681C7869, "HN" ],  // 104.28.120.104-104.28.120.105, HN
        [ 0x681C786A, 0x681C786B, "JS" ],  // 104.28.120.106-104.28.120.107, JS
        [ 0x681C94CC, 0x681C94CC, "GD" ],  // 104.28.148.204-104.28.148.204, GD
        [ 0x681C9CCC, 0x681C9CCC, "GD" ],  // 104.28.156.204-104.28.156.204, GD
        [ 0x681CA2BE, 0x681CA2BE, "HB" ],  // 104.28.162.190-104.28.162.190, HB
        [ 0x681CA2BF, 0x681CA2BF, "SN" ],  // 104.28.162.191-104.28.162.191, SN
        [ 0x681CC00D, 0x681CC014, "GD" ],  // 104.28.192.13-104.28.192.20, GD
        [ 0x681CC082, 0x681CC088, "HN" ],  // 104.28.192.130-104.28.192.136, HN
        [ 0x681CC0C5, 0x681CC0CB, "HE" ],  // 104.28.192.197-104.28.192.203, HE
        [ 0x681CC312, 0x681CC318, "AH" ],  // 104.28.195.18-104.28.195.24, AH
        [ 0x681CC3C2, 0x681CC3C8, "HA" ],  // 104.28.195.194-104.28.195.200, HA
        [ 0x681CC55D, 0x681CC564, "GD" ],  // 104.28.197.93-104.28.197.100, GD
        [ 0x681CC7C8, 0x681CC7CE, "HB" ],  // 104.28.199.200-104.28.199.206, HB
        [ 0x681CCCB6, 0x681CCCBC, "JS" ],  // 104.28.204.182-104.28.204.188, JS
        [ 0x681CD01B, 0x681CD021, "SN" ],  // 104.28.208.27-104.28.208.33, SN
        [ 0x681CD042, 0x681CD048, "AH" ],  // 104.28.208.66-104.28.208.72, AH
        [ 0x681CD07E, 0x681CD084, "SD" ],  // 104.28.208.126-104.28.208.132, SD
        [ 0x681CD085, 0x681CD08C, "SH" ],  // 104.28.208.133-104.28.208.140, SH
        [ 0x681CD093, 0x681CD099, "BJ" ],  // 104.28.208.147-104.28.208.153, BJ
        [ 0x681CD1E0, 0x681CD1E7, "JX" ],  // 104.28.209.224-104.28.209.231, JX
        [ 0x681CD1F6, 0x681CD1FC, "SD" ],  // 104.28.209.246-104.28.209.252, SD
        [ 0x681CD306, 0x681CD30C, "HA" ],  // 104.28.211.6-104.28.211.12, HA
        [ 0x681CD329, 0x681CD32F, "CQ" ],  // 104.28.211.41-104.28.211.47, CQ
        [ 0x681CD484, 0x681CD48B, "GD" ],  // 104.28.212.132-104.28.212.139, GD
        [ 0x681CD834, 0x681CD83A, "TJ" ],  // 104.28.216.52-104.28.216.58, TJ
        [ 0x681CD83B, 0x681CD83E, "XJ" ],  // 104.28.216.59-104.28.216.62, XJ
        [ 0x681CD884, 0x681CD88B, "JS" ],  // 104.28.216.132-104.28.216.139, JS
        [ 0x681CD8BD, 0x681CD8C3, "LN" ],  // 104.28.216.189-104.28.216.195, LN
        [ 0x681CDB2E, 0x681CDB35, "SC" ],  // 104.28.219.46-104.28.219.53, SC
        [ 0x681CDB6D, 0x681CDB73, "JL" ],  // 104.28.219.109-104.28.219.115, JL
        [ 0x681CDCCF, 0x681CDCD5, "JS" ],  // 104.28.220.207-104.28.220.213, JS
        [ 0x681CDD02, 0x681CDD08, "JS" ],  // 104.28.221.2-104.28.221.8, JS
        [ 0x681CE121, 0x681CE127, "HA" ],  // 104.28.225.33-104.28.225.39, HA
        [ 0x681CE165, 0x681CE16C, "ZJ" ],  // 104.28.225.101-104.28.225.108, ZJ
        [ 0x681CE312, 0x681CE318, "AH" ],  // 104.28.227.18-104.28.227.24, AH
        [ 0x681CE3C2, 0x681CE3C8, "HA" ],  // 104.28.227.194-104.28.227.200, HA
        [ 0x681CE6AB, 0x681CE6B1, "GX" ],  // 104.28.230.171-104.28.230.177, GX
        [ 0x681CECB6, 0x681CECBC, "JS" ],  // 104.28.236.182-104.28.236.188, JS
        [ 0x681CF01B, 0x681CF021, "SN" ],  // 104.28.240.27-104.28.240.33, SN
        [ 0x681CF042, 0x681CF048, "AH" ],  // 104.28.240.66-104.28.240.72, AH
        [ 0x681CF07E, 0x681CF084, "SD" ],  // 104.28.240.126-104.28.240.132, SD
        [ 0x681CF085, 0x681CF08C, "SH" ],  // 104.28.240.133-104.28.240.140, SH
        [ 0x681CF093, 0x681CF099, "BJ" ],  // 104.28.240.147-104.28.240.153, BJ
        [ 0x681CF484, 0x681CF48B, "GD" ],  // 104.28.244.132-104.28.244.139, GD
        [ 0x681CF5AA, 0x681CF5CD, "HA" ],  // 104.28.245.170-104.28.245.205, HA
        [ 0x681CF834, 0x681CF83A, "TJ" ],  // 104.28.248.52-104.28.248.58, TJ
        [ 0x681CF83B, 0x681CF83E, "XJ" ],  // 104.28.248.59-104.28.248.62, XJ
        [ 0x681CF884, 0x681CF88B, "JS" ],  // 104.28.248.132-104.28.248.139, JS
        [ 0x681CF8BD, 0x681CF8C3, "LN" ],  // 104.28.248.189-104.28.248.195, LN
        [ 0x681CFB2E, 0x681CFB35, "SC" ],  // 104.28.251.46-104.28.251.53, SC
        [ 0x681CFB6D, 0x681CFB73, "JL" ],  // 104.28.251.109-104.28.251.115, JL
        [ 0x681CFD02, 0x681CFD08, "JS" ],  // 104.28.253.2-104.28.253.8, JS
        [ 0x68EAEC00, 0x68EAECFF, "BJ" ],  // 104.234.236.0-104.234.236.255, BJ
        [ 0x68ED5400, 0x68ED54FF, "BJ" ],  // 104.237.84.0-104.237.84.255, BJ
        [ 0x6A000000, 0x6A0000FF, "FJ" ],  // 106.0.0.0-106.0.0.255, FJ
        [ 0x6A000200, 0x6A0003FF, "FJ" ],  // 106.0.2.0-106.0.3.255, FJ
        [ 0x6A000400, 0x6A0007FF, "BJ" ],  // 106.0.4.0-106.0.7.255, BJ
        [ 0x6A000800, 0x6A001FFF, "GD" ],  // 106.0.8.0-106.0.31.255, GD
        [ 0x6A002C00, 0x6A002FFF, "SX" ],  // 106.0.44.0-106.0.47.255, SX
        [ 0x6A004000, 0x6A007FFF, "GD" ],  // 106.0.64.0-106.0.127.255, GD
        [ 0x6A020000, 0x6A021FFF, "BJ" ],  // 106.2.0.0-106.2.31.255, BJ
        [ 0x6A022000, 0x6A027FFF, "ZJ" ],  // 106.2.32.0-106.2.127.255, ZJ
        [ 0x6A028000, 0x6A0353FF, "BJ" ],  // 106.2.128.0-106.3.83.255, BJ
        [ 0x6A035800, 0x6A035FFF, "LN" ],  // 106.3.88.0-106.3.95.255, LN
        [ 0x6A036000, 0x6A03CFFF, "BJ" ],  // 106.3.96.0-106.3.207.255, BJ
        [ 0x6A03D000, 0x6A03DFFF, "ZJ" ],  // 106.3.208.0-106.3.223.255, ZJ
        [ 0x6A03E000, 0x6A03E7FF, "GD" ],  // 106.3.224.0-106.3.231.255, GD
        [ 0x6A03E800, 0x6A03FFFF, "BJ" ],  // 106.3.232.0-106.3.255.255, BJ
        [ 0x6A040000, 0x6A07FFFF, "JX" ],  // 106.4.0.0-106.7.255.255, JX
        [ 0x6A080000, 0x6A09FFFF, "HE" ],  // 106.8.0.0-106.9.255.255, HE
        [ 0x6A0B0000, 0x6A0B00FF, "GD" ],  // 106.11.0.0-106.11.0.255, GD
        [ 0x6A0B0100, 0x6A0B01FF, "BJ" ],  // 106.11.1.0-106.11.1.255, BJ
        [ 0x6A0B0200, 0x6A0B1FFF, "GD" ],  // 106.11.2.0-106.11.31.255, GD
        [ 0x6A0B2000, 0x6A0B23FF, "BJ" ],  // 106.11.32.0-106.11.35.255, BJ
        [ 0x6A0B2400, 0x6A0B27FF, "SD" ],  // 106.11.36.0-106.11.39.255, SD
        [ 0x6A0B2800, 0x6A0B2FFF, "BJ" ],  // 106.11.40.0-106.11.47.255, BJ
        [ 0x6A0B3000, 0x6A0B480B, "SH" ],  // 106.11.48.0-106.11.72.11, SH
        [ 0x6A0B480C, 0x6A0B4813, "GD" ],  // 106.11.72.12-106.11.72.19, GD
        [ 0x6A0B4814, 0x6A0B4817, "SH" ],  // 106.11.72.20-106.11.72.23, SH
        [ 0x6A0B4818, 0x6A0B4AFF, "GD" ],  // 106.11.72.24-106.11.74.255, GD
        [ 0x6A0B4B00, 0x6A0B4BEF, "SH" ],  // 106.11.75.0-106.11.75.239, SH
        [ 0x6A0B4BF0, 0x6A0B4BFF, "ZJ" ],  // 106.11.75.240-106.11.75.255, ZJ
        [ 0x6A0B4C00, 0x6A0B5FFF, "SH" ],  // 106.11.76.0-106.11.95.255, SH
        [ 0x6A0B6000, 0x6A0B7FFF, "ZJ" ],  // 106.11.96.0-106.11.127.255, ZJ
        [ 0x6A0B8000, 0x6A0B828F, "GD" ],  // 106.11.128.0-106.11.130.143, GD
        [ 0x6A0B8290, 0x6A0B829F, "BJ" ],  // 106.11.130.144-106.11.130.159, BJ
        [ 0x6A0B82A0, 0x6A0B82AF, "ZJ" ],  // 106.11.130.160-106.11.130.175, ZJ
        [ 0x6A0B82B0, 0x6A0B82FF, "BJ" ],  // 106.11.130.176-106.11.130.255, BJ
        [ 0x6A0B8300, 0x6A0B8FFF, "GD" ],  // 106.11.131.0-106.11.143.255, GD
        [ 0x6A0B9000, 0x6A0B9FFF, "ZJ" ],  // 106.11.144.0-106.11.159.255, ZJ
        [ 0x6A0BA000, 0x6A0BAFFF, "SH" ],  // 106.11.160.0-106.11.175.255, SH
        [ 0x6A0BB000, 0x6A0BB7FF, "ZJ" ],  // 106.11.176.0-106.11.183.255, ZJ
        [ 0x6A0BB800, 0x6A0BC1FF, "BJ" ],  // 106.11.184.0-106.11.193.255, BJ
        [ 0x6A0BC200, 0x6A0BC3FF, "SH" ],  // 106.11.194.0-106.11.195.255, SH
        [ 0x6A0BC400, 0x6A0BC5FF, "ZJ" ],  // 106.11.196.0-106.11.197.255, ZJ
        [ 0x6A0BC600, 0x6A0BC6FF, "SC" ],  // 106.11.198.0-106.11.198.255, SC
        [ 0x6A0BC700, 0x6A0BC7FF, "GD" ],  // 106.11.199.0-106.11.199.255, GD
        [ 0x6A0BC800, 0x6A0BC9FF, "ZJ" ],  // 106.11.200.0-106.11.201.255, ZJ
        [ 0x6A0BCA00, 0x6A0BCBFF, "SH" ],  // 106.11.202.0-106.11.203.255, SH
        [ 0x6A0BCC00, 0x6A0BCFFF, "GD" ],  // 106.11.204.0-106.11.207.255, GD
        [ 0x6A0BD000, 0x6A0BDFFF, "BJ" ],  // 106.11.208.0-106.11.223.255, BJ
        [ 0x6A0BE000, 0x6A0BFC3F, "SH" ],  // 106.11.224.0-106.11.252.63, SH
        [ 0x6A0BFC40, 0x6A0BFFFF, "ZJ" ],  // 106.11.252.64-106.11.255.255, ZJ
        [ 0x6A0C0000, 0x6A0C5FFF, "JS" ],  // 106.12.0.0-106.12.95.255, JS
        [ 0x6A0C6000, 0x6A0C8FFF, "GD" ],  // 106.12.96.0-106.12.143.255, GD
        [ 0x6A0C9000, 0x6A0CAFFF, "BJ" ],  // 106.12.144.0-106.12.175.255, BJ
        [ 0x6A0CB000, 0x6A0CBFFF, "JS" ],  // 106.12.176.0-106.12.191.255, JS
        [ 0x6A0CC000, 0x6A0CE7FF, "BJ" ],  // 106.12.192.0-106.12.231.255, BJ
        [ 0x6A0CE800, 0x6A0CEFFF, "GD" ],  // 106.12.232.0-106.12.239.255, GD
        [ 0x6A0CF000, 0x6A0CF9FF, "SN" ],  // 106.12.240.0-106.12.249.255, SN
        [ 0x6A0CFA00, 0x6A0CFBFF, "JS" ],  // 106.12.250.0-106.12.251.255, JS
        [ 0x6A0CFC00, 0x6A0CFFFF, "SN" ],  // 106.12.252.0-106.12.255.255, SN
        [ 0x6A0D0000, 0x6A0D1FFF, "GD" ],  // 106.13.0.0-106.13.31.255, GD
        [ 0x6A0D2000, 0x6A0D9FFF, "BJ" ],  // 106.13.32.0-106.13.159.255, BJ
        [ 0x6A0DA000, 0x6A0DBFFF, "JS" ],  // 106.13.160.0-106.13.191.255, JS
        [ 0x6A0DC000, 0x6A0DF3FF, "GD" ],  // 106.13.192.0-106.13.243.255, GD
        [ 0x6A0DF400, 0x6A0DF9FF, "BJ" ],  // 106.13.244.0-106.13.249.255, BJ
        [ 0x6A0DFA00, 0x6A0DFBFF, "JS" ],  // 106.13.250.0-106.13.251.255, JS
        [ 0x6A0DFC00, 0x6A0DFFFF, "GD" ],  // 106.13.252.0-106.13.255.255, GD
        [ 0x6A0E0000, 0x6A0FFFFF, "SH" ],  // 106.14.0.0-106.15.255.255, SH
        [ 0x6A100000, 0x6A1FFFFF, "HN" ],  // 106.16.0.0-106.31.255.255, HN
        [ 0x6A200000, 0x6A20FFFF, "GZ" ],  // 106.32.0.0-106.32.255.255, GZ
        [ 0x6A210000, 0x6A22FFFF, "HA" ],  // 106.33.0.0-106.34.255.255, HA
        [ 0x6A230000, 0x6A23FFFF, "NM" ],  // 106.35.0.0-106.35.255.255, NM
        [ 0x6A240000, 0x6A24FFFF, "SN" ],  // 106.36.0.0-106.36.255.255, SN
        [ 0x6A250000, 0x6A2680FF, "BJ" ],  // 106.37.0.0-106.38.128.255, BJ
        [ 0x6A268100, 0x6A2681FF, "HE" ],  // 106.38.129.0-106.38.129.255, HE
        [ 0x6A268200, 0x6A27FFFF, "BJ" ],  // 106.38.130.0-106.39.255.255, BJ
        [ 0x6A280000, 0x6A28FFFF, "NM" ],  // 106.40.0.0-106.40.255.255, NM
        [ 0x6A290000, 0x6A29FFFF, "JL" ],  // 106.41.0.0-106.41.255.255, JL
        [ 0x6A2A0000, 0x6A2AFFFF, "HA" ],  // 106.42.0.0-106.42.255.255, HA
        [ 0x6A2B0000, 0x6A2BFFFF, "GZ" ],  // 106.43.0.0-106.43.255.255, GZ
        [ 0x6A2C0000, 0x6A2CFFFF, "SN" ],  // 106.44.0.0-106.44.255.255, SN
        [ 0x6A2D0000, 0x6A2DFFFF, "NX" ],  // 106.45.0.0-106.45.255.255, NX
        [ 0x6A2E0000, 0x6A2EFFFF, "HA" ],  // 106.46.0.0-106.46.255.255, HA
        [ 0x6A2F0000, 0x6A2FFFFF, "TJ" ],  // 106.47.0.0-106.47.255.255, TJ
        [ 0x6A300000, 0x6A300FFF, "BJ" ],  // 106.48.0.0-106.48.15.255, BJ
        [ 0x6A301000, 0x6A3017FF, "JS" ],  // 106.48.16.0-106.48.23.255, JS
        [ 0x6A301800, 0x6A3023FF, "BJ" ],  // 106.48.24.0-106.48.35.255, BJ
        [ 0x6A302400, 0x6A3025FF, "GD" ],  // 106.48.36.0-106.48.37.255, GD
        [ 0x6A302600, 0x6A3027FF, "SH" ],  // 106.48.38.0-106.48.39.255, SH
        [ 0x6A302800, 0x6A32FFFF, "BJ" ],  // 106.48.40.0-106.50.255.255, BJ
        [ 0x6A340000, 0x6A35FFFF, "GD" ],  // 106.52.0.0-106.53.255.255, GD
        [ 0x6A360000, 0x6A36FFFF, "SH" ],  // 106.54.0.0-106.54.255.255, SH
        [ 0x6A370000, 0x6A37FFFF, "GD" ],  // 106.55.0.0-106.55.255.255, GD
        [ 0x6A380000, 0x6A3EFFFF, "YN" ],  // 106.56.0.0-106.62.255.255, YN
        [ 0x6A3F0000, 0x6A3F7FFF, "TJ" ],  // 106.63.0.0-106.63.127.255, TJ
        [ 0x6A3F8000, 0x6A3FFFFF, "YN" ],  // 106.63.128.0-106.63.255.255, YN
        [ 0x6A4A0000, 0x6A4A4FFF, "NM" ],  // 106.74.0.0-106.74.79.255, NM
        [ 0x6A4A5000, 0x6A4A51FF, "BJ" ],  // 106.74.80.0-106.74.81.255, BJ
        [ 0x6A4A5200, 0x6A4A9BFF, "NM" ],  // 106.74.82.0-106.74.155.255, NM
        [ 0x6A4A9C00, 0x6A4A9FFF, "GZ" ],  // 106.74.156.0-106.74.159.255, GZ
        [ 0x6A4AA000, 0x6A4AC3FF, "NM" ],  // 106.74.160.0-106.74.195.255, NM
        [ 0x6A4AC400, 0x6A4AC7FF, "LN" ],  // 106.74.196.0-106.74.199.255, LN
        [ 0x6A4AC800, 0x6A4ACBFF, "SX" ],  // 106.74.200.0-106.74.203.255, SX
        [ 0x6A4ACC00, 0x6A4ACFFF, "JL" ],  // 106.74.204.0-106.74.207.255, JL
        [ 0x6A4AD000, 0x6A4AD7FF, "SD" ],  // 106.74.208.0-106.74.215.255, SD
        [ 0x6A4AD800, 0x6A4ADBFF, "TJ" ],  // 106.74.216.0-106.74.219.255, TJ
        [ 0x6A4ADC00, 0x6A4ADFFF, "HL" ],  // 106.74.220.0-106.74.223.255, HL
        [ 0x6A4AE000, 0x6A4AE3FF, "HE" ],  // 106.74.224.0-106.74.227.255, HE
        [ 0x6A4AE400, 0x6A4AF0FF, "NM" ],  // 106.74.228.0-106.74.240.255, NM
        [ 0x6A4AF100, 0x6A4AF1FF, "LN" ],  // 106.74.241.0-106.74.241.255, LN
        [ 0x6A4AF200, 0x6A4AF2FF, "SX" ],  // 106.74.242.0-106.74.242.255, SX
        [ 0x6A4AF300, 0x6A4AF3FF, "JL" ],  // 106.74.243.0-106.74.243.255, JL
        [ 0x6A4AF400, 0x6A4AF4FF, "NM" ],  // 106.74.244.0-106.74.244.255, NM
        [ 0x6A4AF500, 0x6A4AF5FF, "SD" ],  // 106.74.245.0-106.74.245.255, SD
        [ 0x6A4AF600, 0x6A4AF6FF, "TJ" ],  // 106.74.246.0-106.74.246.255, TJ
        [ 0x6A4AF700, 0x6A4AF7FF, "HL" ],  // 106.74.247.0-106.74.247.255, HL
        [ 0x6A4AF800, 0x6A4AF8FF, "HE" ],  // 106.74.248.0-106.74.248.255, HE
        [ 0x6A4AF900, 0x6A4AFFFF, "NM" ],  // 106.74.249.0-106.74.255.255, NM
        [ 0x6A4B0000, 0x6A4B7FFF, "BJ" ],  // 106.75.0.0-106.75.127.255, BJ
        [ 0x6A4B8000, 0x6A4BBFFF, "GD" ],  // 106.75.128.0-106.75.191.255, GD
        [ 0x6A4BC800, 0x6A4BFFFF, "SH" ],  // 106.75.200.0-106.75.255.255, SH
        [ 0x6A500000, 0x6A57EBFF, "CQ" ],  // 106.80.0.0-106.87.235.255, CQ
        [ 0x6A57EC00, 0x6A57ECFF, "HB" ],  // 106.87.236.0-106.87.236.255, HB
        [ 0x6A57ED00, 0x6A5FFFFF, "CQ" ],  // 106.87.237.0-106.95.255.255, CQ
        [ 0x6A6C0000, 0x6A6DFFFF, "GZ" ],  // 106.108.0.0-106.109.255.255, GZ
        [ 0x6A6E0000, 0x6A6FFFFF, "JS" ],  // 106.110.0.0-106.111.255.255, JS
        [ 0x6A700000, 0x6A77FFFF, "HE" ],  // 106.112.0.0-106.119.255.255, HE
        [ 0x6A780000, 0x6A79FFFF, "BJ" ],  // 106.120.0.0-106.121.255.255, BJ
        [ 0x6A7A0000, 0x6A7AFFFF, "FJ" ],  // 106.122.0.0-106.122.255.255, FJ
        [ 0x6A7B0000, 0x6A7CFFFF, "XJ" ],  // 106.123.0.0-106.124.255.255, XJ
        [ 0x6A7D0000, 0x6A7DFFFF, "NM" ],  // 106.125.0.0-106.125.255.255, NM
        [ 0x6A7E0000, 0x6A7E7FFF, "FJ" ],  // 106.126.0.0-106.126.127.255, FJ
        [ 0x6A7E8000, 0x6A7EFFFF, "GD" ],  // 106.126.128.0-106.126.255.255, GD
        [ 0x6A7F0000, 0x6A7FFFFF, "GX" ],  // 106.127.0.0-106.127.255.255, GX
        [ 0x6AE00000, 0x6AEFFFFF, "JX" ],  // 106.224.0.0-106.239.255.255, JX
        [ 0x6BA80400, 0x6BA805FF, "SH" ],  // 107.168.4.0-107.168.5.255, SH
        [ 0x6BB00000, 0x6BB1FFFF, "BJ" ],  // 107.176.0.0-107.177.255.255, BJ
        [ 0x6CB34020, 0x6CB34027, "SH" ],  // 108.179.64.32-108.179.64.39, SH
        [ 0x6CB34060, 0x6CB34067, "BJ" ],  // 108.179.64.96-108.179.64.103, BJ
        [ 0x6CB34260, 0x6CB34267, "BJ" ],  // 108.179.66.96-108.179.66.103, BJ
        [ 0x6CB34420, 0x6CB34427, "BJ" ],  // 108.179.68.32-108.179.68.39, BJ
        [ 0x6CB34C48, 0x6CB34C4F, "BJ" ],  // 108.179.76.72-108.179.76.79, BJ
        [ 0x6CB34C58, 0x6CB34C5F, "SH" ],  // 108.179.76.88-108.179.76.95, SH
        [ 0x6CB34CA0, 0x6CB34CA7, "BJ" ],  // 108.179.76.160-108.179.76.167, BJ
        [ 0x6CB34FD0, 0x6CB34FD7, "BJ" ],  // 108.179.79.208-108.179.79.215, BJ
        [ 0x6CB350C0, 0x6CB350C7, "CQ" ],  // 108.179.80.192-108.179.80.199, CQ
        [ 0x6CB35410, 0x6CB35417, "CQ" ],  // 108.179.84.16-108.179.84.23, CQ
        [ 0x6CB35448, 0x6CB3544F, "CQ" ],  // 108.179.84.72-108.179.84.79, CQ
        [ 0x6CB354C0, 0x6CB354C7, "BJ" ],  // 108.179.84.192-108.179.84.199, BJ
        [ 0x6CB354E0, 0x6CB354E7, "SH" ],  // 108.179.84.224-108.179.84.231, SH
        [ 0x6CB355B0, 0x6CB355B7, "SH" ],  // 108.179.85.176-108.179.85.183, SH
        [ 0x6CB356E8, 0x6CB356EF, "BJ" ],  // 108.179.86.232-108.179.86.239, BJ
        [ 0x6CB35708, 0x6CB3570F, "BJ" ],  // 108.179.87.8-108.179.87.15, BJ
        [ 0x6CB35830, 0x6CB35837, "BJ" ],  // 108.179.88.48-108.179.88.55, BJ
        [ 0x6CB35908, 0x6CB3590F, "SH" ],  // 108.179.89.8-108.179.89.15, SH
        [ 0x6CB35B60, 0x6CB35B67, "BJ" ],  // 108.179.91.96-108.179.91.103, BJ
        [ 0x6CB35BD8, 0x6CB35BDF, "SH" ],  // 108.179.91.216-108.179.91.223, SH
        [ 0x6CB35BF8, 0x6CB35BFF, "SH" ],  // 108.179.91.248-108.179.91.255, SH
        [ 0x6CB35E48, 0x6CB35E4F, "SH" ],  // 108.179.94.72-108.179.94.79, SH
        [ 0x6CB35E98, 0x6CB35E9F, "SH" ],  // 108.179.94.152-108.179.94.159, SH
        [ 0x6CB362D0, 0x6CB362D7, "BJ" ],  // 108.179.98.208-108.179.98.215, BJ
        [ 0x6CB364A8, 0x6CB364AF, "BJ" ],  // 108.179.100.168-108.179.100.175, BJ
        [ 0x6CB36500, 0x6CB36507, "SH" ],  // 108.179.101.0-108.179.101.7, SH
        [ 0x6CB365C8, 0x6CB365CF, "BJ" ],  // 108.179.101.200-108.179.101.207, BJ
        [ 0x6CB366A0, 0x6CB366A7, "BJ" ],  // 108.179.102.160-108.179.102.167, BJ
        [ 0x6CB36938, 0x6CB3693F, "CQ" ],  // 108.179.105.56-108.179.105.63, CQ
        [ 0x6CB36A58, 0x6CB36A5F, "BJ" ],  // 108.179.106.88-108.179.106.95, BJ
        [ 0x6CB36AC8, 0x6CB36ACF, "BJ" ],  // 108.179.106.200-108.179.106.207, BJ
        [ 0x6CB36C78, 0x6CB36C7F, "SH" ],  // 108.179.108.120-108.179.108.127, SH
        [ 0x6CB37470, 0x6CB37477, "SH" ],  // 108.179.116.112-108.179.116.119, SH
        [ 0x6CB37480, 0x6CB37487, "SH" ],  // 108.179.116.128-108.179.116.135, SH
        [ 0x6CB37560, 0x6CB37567, "BJ" ],  // 108.179.117.96-108.179.117.103, BJ
        [ 0x6CB376E0, 0x6CB376E7, "SH" ],  // 108.179.118.224-108.179.118.231, SH
        [ 0x6CB37740, 0x6CB37747, "SH" ],  // 108.179.119.64-108.179.119.71, SH
        [ 0x6CB378B8, 0x6CB378BF, "SH" ],  // 108.179.120.184-108.179.120.191, SH
        [ 0x6CB37A90, 0x6CB37A97, "BJ" ],  // 108.179.122.144-108.179.122.151, BJ
        [ 0x6CB37D10, 0x6CB37D17, "SH" ],  // 108.179.125.16-108.179.125.23, SH
        [ 0x6CB37DE8, 0x6CB37DEF, "BJ" ],  // 108.179.125.232-108.179.125.239, BJ
        [ 0x6CB37FE0, 0x6CB37FE7, "BJ" ],  // 108.179.127.224-108.179.127.231, BJ
        [ 0x6D470400, 0x6D4704FF, "BJ" ],  // 109.71.4.0-109.71.4.255, BJ
        [ 0x6DAC6400, 0x6DAC64FF, "BJ" ],  // 109.172.100.0-109.172.100.255, BJ
        [ 0x6DF40000, 0x6DF41FFF, "BJ" ],  // 109.244.0.0-109.244.31.255, BJ
        [ 0x6DF42000, 0x6DF42FFF, "SH" ],  // 109.244.32.0-109.244.47.255, SH
        [ 0x6DF43000, 0x6DF44FFF, "GD" ],  // 109.244.48.0-109.244.79.255, GD
        [ 0x6DF45000, 0x6DF47FFF, "SC" ],  // 109.244.80.0-109.244.127.255, SC
        [ 0x6DF48000, 0x6DF487FF, "GD" ],  // 109.244.128.0-109.244.135.255, GD
        [ 0x6DF48800, 0x6DF48BFF, "CQ" ],  // 109.244.136.0-109.244.139.255, CQ
        [ 0x6DF48C00, 0x6DF48FFF, "SC" ],  // 109.244.140.0-109.244.143.255, SC
        [ 0x6DF49000, 0x6DF497FF, "SH" ],  // 109.244.144.0-109.244.151.255, SH
        [ 0x6DF49800, 0x6DF49BFF, "JS" ],  // 109.244.152.0-109.244.155.255, JS
        [ 0x6DF49C00, 0x6DF49FFF, "SH" ],  // 109.244.156.0-109.244.159.255, SH
        [ 0x6DF4A000, 0x6DF4A7FF, "GD" ],  // 109.244.160.0-109.244.167.255, GD
        [ 0x6DF4A800, 0x6DF4AFFF, "TJ" ],  // 109.244.168.0-109.244.175.255, TJ
        [ 0x6DF4B000, 0x6DF4C7FF, "GD" ],  // 109.244.176.0-109.244.199.255, GD
        [ 0x6DF4C800, 0x6DF4CBFF, "CQ" ],  // 109.244.200.0-109.244.203.255, CQ
        [ 0x6DF4CC00, 0x6DF4CFFF, "SC" ],  // 109.244.204.0-109.244.207.255, SC
        [ 0x6DF4D000, 0x6DF4DFFF, "SH" ],  // 109.244.208.0-109.244.223.255, SH
        [ 0x6DF4E000, 0x6DF4E7FF, "JS" ],  // 109.244.224.0-109.244.231.255, JS
        [ 0x6DF4E800, 0x6DF4EFFF, "GD" ],  // 109.244.232.0-109.244.239.255, GD
        [ 0x6DF4F000, 0x6DF4F7FF, "TJ" ],  // 109.244.240.0-109.244.247.255, TJ
        [ 0x6DF4F800, 0x6DF4FFFF, "JS" ],  // 109.244.248.0-109.244.255.255, JS
        [ 0x6E060000, 0x6E07FFFF, "NM" ],  // 110.6.0.0-110.7.255.255, NM
        [ 0x6E100000, 0x6E13FFFF, "NM" ],  // 110.16.0.0-110.19.255.255, NM
        [ 0x6E222800, 0x6E222BFF, "BJ" ],  // 110.34.40.0-110.34.43.255, BJ
        [ 0x6E222C00, 0x6E222FFF, "ZJ" ],  // 110.34.44.0-110.34.47.255, ZJ
        [ 0x6E280000, 0x6E2810FF, "BJ" ],  // 110.40.0.0-110.40.16.255, BJ
        [ 0x6E281100, 0x6E287FFF, "SC" ],  // 110.40.17.0-110.40.127.255, SC
        [ 0x6E288000, 0x6E28FFFF, "SH" ],  // 110.40.128.0-110.40.255.255, SH
        [ 0x6E290000, 0x6E29FFFF, "GD" ],  // 110.41.0.0-110.41.255.255, GD
        [ 0x6E2A0000, 0x6E2A7FFF, "ZJ" ],  // 110.42.0.0-110.42.127.255, ZJ
        [ 0x6E2A8000, 0x6E2AFFFF, "SH" ],  // 110.42.128.0-110.42.255.255, SH
        [ 0x6E2B0000, 0x6E2B04FF, "BJ" ],  // 110.43.0.0-110.43.4.255, BJ
        [ 0x6E2B0500, 0x6E2B09FF, "GD" ],  // 110.43.5.0-110.43.9.255, GD
        [ 0x6E2B0A00, 0x6E2B1FFF, "BJ" ],  // 110.43.10.0-110.43.31.255, BJ
        [ 0x6E2B2000, 0x6E2B3FFF, "GD" ],  // 110.43.32.0-110.43.63.255, GD
        [ 0x6E2B4000, 0x6E2B9FFF, "BJ" ],  // 110.43.64.0-110.43.159.255, BJ
        [ 0x6E2BA000, 0x6E2BB7FF, "SH" ],  // 110.43.160.0-110.43.183.255, SH
        [ 0x6E2BB800, 0x6E2BEFFF, "BJ" ],  // 110.43.184.0-110.43.239.255, BJ
        [ 0x6E2BF000, 0x6E2BFFFF, "GD" ],  // 110.43.240.0-110.43.255.255, GD
        [ 0x6E2C0C00, 0x6E2C0FFF, "JS" ],  // 110.44.12.0-110.44.15.255, JS
        [ 0x6E2C9000, 0x6E2C9FFF, "BJ" ],  // 110.44.144.0-110.44.159.255, BJ
        [ 0x6E300000, 0x6E30FFFF, "BJ" ],  // 110.48.0.0-110.48.255.255, BJ
        [ 0x6E330000, 0x6E33FFFF, "SX" ],  // 110.51.0.0-110.51.255.255, SX
        [ 0x6E340000, 0x6E35FFFF, "HN" ],  // 110.52.0.0-110.53.255.255, HN
        [ 0x6E380000, 0x6E3FFFFF, "BJ" ],  // 110.56.0.0-110.63.255.255, BJ
        [ 0x6E400000, 0x6E4098FF, "GD" ],  // 110.64.0.0-110.64.152.255, GD
        [ 0x6E409900, 0x6E4099FF, "JS" ],  // 110.64.153.0-110.64.153.255, JS
        [ 0x6E409A00, 0x6E41EFFF, "GD" ],  // 110.64.154.0-110.65.239.255, GD
        [ 0x6E41F000, 0x6E41FFFF, "HI" ],  // 110.65.240.0-110.65.255.255, HI
        [ 0x6E480000, 0x6E49FFFF, "GX" ],  // 110.72.0.0-110.73.255.255, GX
        [ 0x6E4B0000, 0x6E4BEBFF, "ZJ" ],  // 110.75.0.0-110.75.235.255, ZJ
        [ 0x6E4BEC00, 0x6E4BFFFF, "GD" ],  // 110.75.236.0-110.75.255.255, GD
        [ 0x6E4C0000, 0x6E4C1DFF, "ZJ" ],  // 110.76.0.0-110.76.29.255, ZJ
        [ 0x6E4C1E00, 0x6E4C1FFF, "SH" ],  // 110.76.30.0-110.76.31.255, SH
        [ 0x6E4C2000, 0x6E4C3FFF, "ZJ" ],  // 110.76.32.0-110.76.63.255, ZJ
        [ 0x6E4C8400, 0x6E4C87FF, "HN" ],  // 110.76.132.0-110.76.135.255, HN
        [ 0x6E4C9C00, 0x6E4C9FFF, "NM" ],  // 110.76.156.0-110.76.159.255, NM
        [ 0x6E4CB800, 0x6E4CBBFF, "NM" ],  // 110.76.184.0-110.76.187.255, NM
        [ 0x6E4CC000, 0x6E4D7FFF, "HA" ],  // 110.76.192.0-110.77.127.255, HA
        [ 0x6E500000, 0x6E5B50FF, "FJ" ],  // 110.80.0.0-110.91.80.255, FJ
        [ 0x6E5B5100, 0x6E5B51FF, "YN" ],  // 110.91.81.0-110.91.81.255, YN
        [ 0x6E5B5200, 0x6E5BFFFF, "FJ" ],  // 110.91.82.0-110.91.255.255, FJ
        [ 0x6E5C4400, 0x6E5C47FF, "HB" ],  // 110.92.68.0-110.92.71.255, HB
        [ 0x6E5D2000, 0x6E5D3FFF, "GD" ],  // 110.93.32.0-110.93.63.255, GD
        [ 0x6E5E0000, 0x6E60FFFF, "BJ" ],  // 110.94.0.0-110.96.255.255, BJ
        [ 0x6E610000, 0x6E62FFFF, "HE" ],  // 110.97.0.0-110.98.255.255, HE
        [ 0x6E630000, 0x6E65FFFF, "JS" ],  // 110.99.0.0-110.101.255.255, JS
        [ 0x6E660000, 0x6E66FFFF, "NM" ],  // 110.102.0.0-110.102.255.255, NM
        [ 0x6E670000, 0x6E68FFFF, "LN" ],  // 110.103.0.0-110.104.255.255, LN
        [ 0x6E690000, 0x6E698FFF, "JS" ],  // 110.105.0.0-110.105.143.255, JS
        [ 0x6E699000, 0x6E699FFF, "LN" ],  // 110.105.144.0-110.105.159.255, LN
        [ 0x6E69A000, 0x6E69BFFF, "JS" ],  // 110.105.160.0-110.105.191.255, JS
        [ 0x6E69C000, 0x6E69EFFF, "LN" ],  // 110.105.192.0-110.105.239.255, LN
        [ 0x6E69F000, 0x6E6AEFFF, "JS" ],  // 110.105.240.0-110.106.239.255, JS
        [ 0x6E6AF000, 0x6E6AF7FF, "LN" ],  // 110.106.240.0-110.106.247.255, LN
        [ 0x6E6AF800, 0x6E6BFFFF, "JS" ],  // 110.106.248.0-110.107.255.255, JS
        [ 0x6E6C0000, 0x6E6DFFFF, "JL" ],  // 110.108.0.0-110.109.255.255, JL
        [ 0x6E6E0000, 0x6E70FFFF, "HL" ],  // 110.110.0.0-110.112.255.255, HL
        [ 0x6E710000, 0x6E72FFFF, "BJ" ],  // 110.113.0.0-110.114.255.255, BJ
        [ 0x6E730000, 0x6E75FFFF, "JS" ],  // 110.115.0.0-110.117.255.255, JS
        [ 0x6E760000, 0x6E76FFFF, "ZJ" ],  // 110.118.0.0-110.118.255.255, ZJ
        [ 0x6E770000, 0x6E77FFFF, "SC" ],  // 110.119.0.0-110.119.255.255, SC
        [ 0x6E780000, 0x6E7893FF, "GD" ],  // 110.120.0.0-110.120.147.255, GD
        [ 0x6E789400, 0x6E7897FF, "HB" ],  // 110.120.148.0-110.120.151.255, HB
        [ 0x6E789800, 0x6E78FFFF, "GD" ],  // 110.120.152.0-110.120.255.255, GD
        [ 0x6E790000, 0x6E7903FF, "HB" ],  // 110.121.0.0-110.121.3.255, HB
        [ 0x6E790400, 0x6E7904FF, "JS" ],  // 110.121.4.0-110.121.4.255, JS
        [ 0x6E790500, 0x6E7905FF, "HB" ],  // 110.121.5.0-110.121.5.255, HB
        [ 0x6E790600, 0x6E7906FF, "JS" ],  // 110.121.6.0-110.121.6.255, JS
        [ 0x6E790700, 0x6E7927FF, "HB" ],  // 110.121.7.0-110.121.39.255, HB
        [ 0x6E792800, 0x6E792FFF, "JS" ],  // 110.121.40.0-110.121.47.255, JS
        [ 0x6E793000, 0x6E7947FF, "HB" ],  // 110.121.48.0-110.121.71.255, HB
        [ 0x6E794800, 0x6E794FFF, "JS" ],  // 110.121.72.0-110.121.79.255, JS
        [ 0x6E795000, 0x6E797FFF, "HB" ],  // 110.121.80.0-110.121.127.255, HB
        [ 0x6E798000, 0x6E7983FF, "JS" ],  // 110.121.128.0-110.121.131.255, JS
        [ 0x6E798400, 0x6E79ACFF, "HB" ],  // 110.121.132.0-110.121.172.255, HB
        [ 0x6E79AD00, 0x6E79ADFF, "JS" ],  // 110.121.173.0-110.121.173.255, JS
        [ 0x6E79AE00, 0x6E79AEFF, "SH" ],  // 110.121.174.0-110.121.174.255, SH
        [ 0x6E79AF00, 0x6E79AFFF, "JS" ],  // 110.121.175.0-110.121.175.255, JS
        [ 0x6E79B000, 0x6E79E3FF, "HB" ],  // 110.121.176.0-110.121.227.255, HB
        [ 0x6E79E400, 0x6E79EFFF, "JS" ],  // 110.121.228.0-110.121.239.255, JS
        [ 0x6E79F000, 0x6E79F7FF, "HB" ],  // 110.121.240.0-110.121.247.255, HB
        [ 0x6E79F800, 0x6E79FFFF, "JS" ],  // 110.121.248.0-110.121.255.255, JS
        [ 0x6E7A0000, 0x6E7BFFFF, "AH" ],  // 110.122.0.0-110.123.255.255, AH
        [ 0x6E7C0000, 0x6E7DFFFF, "FJ" ],  // 110.124.0.0-110.125.255.255, FJ
        [ 0x6E7E0000, 0x6E7EB0FF, "JS" ],  // 110.126.0.0-110.126.176.255, JS
        [ 0x6E7EB100, 0x6E7EBFFF, "FJ" ],  // 110.126.177.0-110.126.191.255, FJ
        [ 0x6E7EC000, 0x6E7EFFFF, "JS" ],  // 110.126.192.0-110.126.255.255, JS
        [ 0x6E7F0000, 0x6E7FFFFF, "JL" ],  // 110.127.0.0-110.127.255.255, JL
        [ 0x6E980000, 0x6E9DFFFF, "XJ" ],  // 110.152.0.0-110.157.255.255, XJ
        [ 0x6EA60000, 0x6EA7FFFF, "QH" ],  // 110.166.0.0-110.167.255.255, QH
        [ 0x6EACC000, 0x6EAD07FF, "BJ" ],  // 110.172.192.0-110.173.7.255, BJ
        [ 0x6EAD0800, 0x6EAD1FFF, "LN" ],  // 110.173.8.0-110.173.31.255, LN
        [ 0x6EAD2000, 0x6EAD2FFF, "BJ" ],  // 110.173.32.0-110.173.47.255, BJ
        [ 0x6EAD4000, 0x6EAD5FFF, "GD" ],  // 110.173.64.0-110.173.95.255, GD
        [ 0x6EAD6000, 0x6EAD7FFF, "BJ" ],  // 110.173.96.0-110.173.127.255, BJ
        [ 0x6EADC000, 0x6EADDFFF, "ZJ" ],  // 110.173.192.0-110.173.223.255, ZJ
        [ 0x6EB00000, 0x6EB7FFFF, "SX" ],  // 110.176.0.0-110.183.255.255, SX
        [ 0x6EB80000, 0x6EBFFFFF, "SC" ],  // 110.184.0.0-110.191.255.255, SC
        [ 0x6EC00000, 0x6EC0FFFF, "JX" ],  // 110.192.0.0-110.192.255.255, JX
        [ 0x6EC10000, 0x6EC1FFFF, "JS" ],  // 110.193.0.0-110.193.255.255, JS
        [ 0x6EC20000, 0x6EC4FFFF, "SD" ],  // 110.194.0.0-110.196.255.255, SD
        [ 0x6EC50000, 0x6EC6FFFF, "HA" ],  // 110.197.0.0-110.198.255.255, HA
        [ 0x6EC70000, 0x6EC7FFFF, "JS" ],  // 110.199.0.0-110.199.255.255, JS
        [ 0x6EC80000, 0x6ECAFFFF, "HB" ],  // 110.200.0.0-110.202.255.255, HB
        [ 0x6ECB0000, 0x6ECFFFFF, "HN" ],  // 110.203.0.0-110.207.255.255, HN
        [ 0x6ED00000, 0x6ED3FFFF, "GD" ],  // 110.208.0.0-110.211.255.255, GD
        [ 0x6ED40000, 0x6ED4FFFF, "GX" ],  // 110.212.0.0-110.212.255.255, GX
        [ 0x6ED50000, 0x6ED5FFFF, "JS" ],  // 110.213.0.0-110.213.255.255, JS
        [ 0x6ED60000, 0x6ED6FFFF, "CQ" ],  // 110.214.0.0-110.214.255.255, CQ
        [ 0x6ED70000, 0x6ED7FFFF, "SC" ],  // 110.215.0.0-110.215.255.255, SC
        [ 0x6ED80000, 0x6ED8FFFF, "GZ" ],  // 110.216.0.0-110.216.255.255, GZ
        [ 0x6ED90000, 0x6ED9FFFF, "SN" ],  // 110.217.0.0-110.217.255.255, SN
        [ 0x6EDA0000, 0x6EDBFFFF, "JS" ],  // 110.218.0.0-110.219.255.255, JS
        [ 0x6EDC0000, 0x6EDCFFFF, "GS" ],  // 110.220.0.0-110.220.255.255, GS
        [ 0x6EDD0000, 0x6EDDFFFF, "BJ" ],  // 110.221.0.0-110.221.255.255, BJ
        [ 0x6EDE0000, 0x6EDE7FFF, "NX" ],  // 110.222.0.0-110.222.127.255, NX
        [ 0x6EDE8000, 0x6EDEFFFF, "QH" ],  // 110.222.128.0-110.222.255.255, QH
        [ 0x6EDF0000, 0x6EDFFFFF, "SD" ],  // 110.223.0.0-110.223.255.255, SD
        [ 0x6EE40000, 0x6EE7FFFF, "HE" ],  // 110.228.0.0-110.231.255.255, HE
        [ 0x6EE82000, 0x6EE83FFF, "BJ" ],  // 110.232.32.0-110.232.63.255, BJ
        [ 0x6EEC0000, 0x6EEDFFFF, "FJ" ],  // 110.236.0.0-110.237.255.255, FJ
        [ 0x6EF00000, 0x6EFFFFFF, "HE" ],  // 110.240.0.0-110.255.255.255, HE
        [ 0x6F000000, 0x6F02BEFF, "ZJ" ],  // 111.0.0.0-111.2.190.255, ZJ
        [ 0x6F02BF00, 0x6F02BFFF, "SH" ],  // 111.2.191.0-111.2.191.255, SH
        [ 0x6F02C000, 0x6F03FFFF, "ZJ" ],  // 111.2.192.0-111.3.255.255, ZJ
        [ 0x6F040000, 0x6F04FFFF, "HB" ],  // 111.4.0.0-111.4.255.255, HB
        [ 0x6F050000, 0x6F07FFFF, "HA" ],  // 111.5.0.0-111.7.255.255, HA
        [ 0x6F080000, 0x6F08FFFF, "HN" ],  // 111.8.0.0-111.8.255.255, HN
        [ 0x6F090000, 0x6F09660F, "SC" ],  // 111.9.0.0-111.9.102.15, SC
        [ 0x6F096610, 0x6F096610, "XZ" ],  // 111.9.102.16-111.9.102.16, XZ
        [ 0x6F096611, 0x6F096629, "SC" ],  // 111.9.102.17-111.9.102.41, SC
        [ 0x6F09662A, 0x6F09662A, "XZ" ],  // 111.9.102.42-111.9.102.42, XZ
        [ 0x6F09662B, 0x6F09FFFF, "SC" ],  // 111.9.102.43-111.9.255.255, SC
        [ 0x6F0A0000, 0x6F0AFFFF, "CQ" ],  // 111.10.0.0-111.10.255.255, CQ
        [ 0x6F0B0000, 0x6F0B7FFF, "HE" ],  // 111.11.0.0-111.11.127.255, HE
        [ 0x6F0B8000, 0x6F0BBFFF, "GS" ],  // 111.11.128.0-111.11.191.255, GS
        [ 0x6F0BC000, 0x6F0BFFFF, "XZ" ],  // 111.11.192.0-111.11.255.255, XZ
        [ 0x6F0C0000, 0x6F0C7FFF, "GX" ],  // 111.12.0.0-111.12.127.255, GX
        [ 0x6F0C8000, 0x6F0CFFFF, "QH" ],  // 111.12.128.0-111.12.255.255, QH
        [ 0x6F0D0000, 0x6F0DFFFF, "BJ" ],  // 111.13.0.0-111.13.255.255, BJ
        [ 0x6F0E0000, 0x6F11FFFF, "SD" ],  // 111.14.0.0-111.17.255.255, SD
        [ 0x6F120000, 0x6F15FFFF, "SN" ],  // 111.18.0.0-111.21.255.255, SN
        [ 0x6F160000, 0x6F17FFFF, "HN" ],  // 111.22.0.0-111.23.255.255, HN
        [ 0x6F180000, 0x6F18FFFF, "GD" ],  // 111.24.0.0-111.24.255.255, GD
        [ 0x6F190000, 0x6F1BFFFF, "JL" ],  // 111.25.0.0-111.27.255.255, JL
        [ 0x6F1C0000, 0x6F1DFFFF, "HI" ],  // 111.28.0.0-111.29.255.255, HI
        [ 0x6F1E0000, 0x6F21FFFF, "TJ" ],  // 111.30.0.0-111.33.255.255, TJ
        [ 0x6F220000, 0x6F25FFFF, "SD" ],  // 111.34.0.0-111.37.255.255, SD
        [ 0x6F260000, 0x6F27FFFF, "AH" ],  // 111.38.0.0-111.39.255.255, AH
        [ 0x6F280000, 0x6F2B4F65, "HL" ],  // 111.40.0.0-111.43.79.101, HL
        [ 0x6F2B4F66, 0x6F2B4F66, "JL" ],  // 111.43.79.102-111.43.79.102, JL
        [ 0x6F2B4F67, 0x6F2BFFFF, "HL" ],  // 111.43.79.103-111.43.255.255, HL
        [ 0x6F2C0000, 0x6F2C7FFF, "BJ" ],  // 111.44.0.0-111.44.127.255, BJ
        [ 0x6F2C8000, 0x6F2CFFFF, "QH" ],  // 111.44.128.0-111.44.255.255, QH
        [ 0x6F2D0000, 0x6F2D7FFF, "GD" ],  // 111.45.0.0-111.45.127.255, GD
        [ 0x6F2D8000, 0x6F2DFFFF, "LN" ],  // 111.45.128.0-111.45.255.255, LN
        [ 0x6F2E0000, 0x6F30FFFF, "HB" ],  // 111.46.0.0-111.48.255.255, HB
        [ 0x6F310000, 0x6F31A3FF, "NX" ],  // 111.49.0.0-111.49.163.255, NX
        [ 0x6F31A400, 0x6F31A4FF, "GD" ],  // 111.49.164.0-111.49.164.255, GD
        [ 0x6F31A500, 0x6F31A5FF, "NX" ],  // 111.49.165.0-111.49.165.255, NX
        [ 0x6F31A600, 0x6F31A6FF, "GD" ],  // 111.49.166.0-111.49.166.255, GD
        [ 0x6F31A700, 0x6F33FFFF, "NX" ],  // 111.49.167.0-111.51.255.255, NX
        [ 0x6F340000, 0x6F35FFFF, "SX" ],  // 111.52.0.0-111.53.255.255, SX
        [ 0x6F360000, 0x6F3708FF, "CQ" ],  // 111.54.0.0-111.55.8.255, CQ
        [ 0x6F370900, 0x6F370DFF, "GX" ],  // 111.55.9.0-111.55.13.255, GX
        [ 0x6F370E00, 0x6F370FFF, "CQ" ],  // 111.55.14.0-111.55.15.255, CQ
        [ 0x6F371000, 0x6F3717FF, "HA" ],  // 111.55.16.0-111.55.23.255, HA
        [ 0x6F371800, 0x6F371AFF, "HE" ],  // 111.55.24.0-111.55.26.255, HE
        [ 0x6F371B00, 0x6F371FFF, "HA" ],  // 111.55.27.0-111.55.31.255, HA
        [ 0x6F372000, 0x6F3721FF, "YN" ],  // 111.55.32.0-111.55.33.255, YN
        [ 0x6F372200, 0x6F3722FF, "GD" ],  // 111.55.34.0-111.55.34.255, GD
        [ 0x6F372300, 0x6F3724FF, "YN" ],  // 111.55.35.0-111.55.36.255, YN
        [ 0x6F372500, 0x6F3727FF, "GD" ],  // 111.55.37.0-111.55.39.255, GD
        [ 0x6F372800, 0x6F372FFF, "SN" ],  // 111.55.40.0-111.55.47.255, SN
        [ 0x6F373000, 0x6F3737FF, "LN" ],  // 111.55.48.0-111.55.55.255, LN
        [ 0x6F373800, 0x6F373EFF, "CQ" ],  // 111.55.56.0-111.55.62.255, CQ
        [ 0x6F373F00, 0x6F373FFF, "SH" ],  // 111.55.63.0-111.55.63.255, SH
        [ 0x6F374000, 0x6F3747FF, "GD" ],  // 111.55.64.0-111.55.71.255, GD
        [ 0x6F374800, 0x6F375FFF, "JS" ],  // 111.55.72.0-111.55.95.255, JS
        [ 0x6F376000, 0x6F376FFF, "HN" ],  // 111.55.96.0-111.55.111.255, HN
        [ 0x6F377000, 0x6F3787FF, "HL" ],  // 111.55.112.0-111.55.135.255, HL
        [ 0x6F378800, 0x6F378CFF, "GD" ],  // 111.55.136.0-111.55.140.255, GD
        [ 0x6F378D00, 0x6F378D0F, "ZJ" ],  // 111.55.141.0-111.55.141.15, ZJ
        [ 0x6F378D10, 0x6F378DFF, "GD" ],  // 111.55.141.16-111.55.141.255, GD
        [ 0x6F378E00, 0x6F378FFF, "ZJ" ],  // 111.55.142.0-111.55.143.255, ZJ
        [ 0x6F379000, 0x6F3790FF, "HL" ],  // 111.55.144.0-111.55.144.255, HL
        [ 0x6F379100, 0x6F3791FF, "SC" ],  // 111.55.145.0-111.55.145.255, SC
        [ 0x6F379200, 0x6F3793FF, "HL" ],  // 111.55.146.0-111.55.147.255, HL
        [ 0x6F379400, 0x6F3796FF, "SC" ],  // 111.55.148.0-111.55.150.255, SC
        [ 0x6F379700, 0x6F379FFF, "GD" ],  // 111.55.151.0-111.55.159.255, GD
        [ 0x6F37A000, 0x6F37A1FF, "HI" ],  // 111.55.160.0-111.55.161.255, HI
        [ 0x6F37A200, 0x6F37A5FF, "BJ" ],  // 111.55.162.0-111.55.165.255, BJ
        [ 0x6F37A600, 0x6F37AAFF, "GX" ],  // 111.55.166.0-111.55.170.255, GX
        [ 0x6F37AB00, 0x6F37BFFF, "HL" ],  // 111.55.171.0-111.55.191.255, HL
        [ 0x6F37C000, 0x6F37FFFF, "CQ" ],  // 111.55.192.0-111.55.255.255, CQ
        [ 0x6F380000, 0x6F39FFFF, "NM" ],  // 111.56.0.0-111.57.255.255, NM
        [ 0x6F3A0000, 0x6F3BFFFF, "GX" ],  // 111.58.0.0-111.59.255.255, GX
        [ 0x6F3C0000, 0x6F3CFFFF, "HB" ],  // 111.60.0.0-111.60.255.255, HB
        [ 0x6F3D0000, 0x6F3FFFFF, "HE" ],  // 111.61.0.0-111.63.255.255, HE
        [ 0x6F420000, 0x6F42B2FF, "GD" ],  // 111.66.0.0-111.66.178.255, GD
        [ 0x6F42B300, 0x6F42B3FF, "TJ" ],  // 111.66.179.0-111.66.179.255, TJ
        [ 0x6F42B400, 0x6F42FFFF, "GD" ],  // 111.66.180.0-111.66.255.255, GD
        [ 0x6F43C000, 0x6F43CFFF, "BJ" ],  // 111.67.192.0-111.67.207.255, BJ
        [ 0x6F444000, 0x6F445FFF, "SN" ],  // 111.68.64.0-111.68.95.255, SN
        [ 0x6F480000, 0x6F4FFFFF, "JX" ],  // 111.72.0.0-111.79.255.255, JX
        [ 0x6F550000, 0x6F55FFFF, "GZ" ],  // 111.85.0.0-111.85.255.255, GZ
        [ 0x6F5CF800, 0x6F5CFBFF, "JL" ],  // 111.92.248.0-111.92.251.255, JL
        [ 0x6F5CFC00, 0x6F5CFFFF, "ZJ" ],  // 111.92.252.0-111.92.255.255, ZJ
        [ 0x6F700000, 0x6F71FFFF, "NX" ],  // 111.112.0.0-111.113.255.255, NX
        [ 0x6F720000, 0x6F72FFFF, "SN" ],  // 111.114.0.0-111.114.255.255, SN
        [ 0x6F730000, 0x6F733FFF, "GS" ],  // 111.115.0.0-111.115.63.255, GS
        [ 0x6F734000, 0x6F737FFF, "XJ" ],  // 111.115.64.0-111.115.127.255, XJ
        [ 0x6F738000, 0x6F73BFFF, "GS" ],  // 111.115.128.0-111.115.191.255, GS
        [ 0x6F73C000, 0x6F73DFFF, "QH" ],  // 111.115.192.0-111.115.223.255, QH
        [ 0x6F73E000, 0x6F73FFFF, "SN" ],  // 111.115.224.0-111.115.255.255, SN
        [ 0x6F740000, 0x6F74FFFF, "JL" ],  // 111.116.0.0-111.116.255.255, JL
        [ 0x6F750000, 0x6F753FFF, "HL" ],  // 111.117.0.0-111.117.63.255, HL
        [ 0x6F754000, 0x6F75BFFF, "LN" ],  // 111.117.64.0-111.117.191.255, LN
        [ 0x6F75C000, 0x6F75FFFF, "JL" ],  // 111.117.192.0-111.117.255.255, JL
        [ 0x6F76C800, 0x6F76CFFF, "BJ" ],  // 111.118.200.0-111.118.207.255, BJ
        [ 0x6F774000, 0x6F7752FF, "GZ" ],  // 111.119.64.0-111.119.82.255, GZ
        [ 0x6F775300, 0x6F7753FF, "SH" ],  // 111.119.83.0-111.119.83.255, SH
        [ 0x6F775400, 0x6F778FFF, "GZ" ],  // 111.119.84.0-111.119.143.255, GZ
        [ 0x6F779000, 0x6F7797FF, "SH" ],  // 111.119.144.0-111.119.151.255, SH
        [ 0x6F779800, 0x6F779FFF, "GZ" ],  // 111.119.152.0-111.119.159.255, GZ
        [ 0x6F780000, 0x6F7CFFFF, "GZ" ],  // 111.120.0.0-111.124.255.255, GZ
        [ 0x6F7E0000, 0x6F7FFFFF, "NM" ],  // 111.126.0.0-111.127.255.255, NM
        [ 0x6F800000, 0x6F80FFFF, "FJ" ],  // 111.128.0.0-111.128.255.255, FJ
        [ 0x6F810000, 0x6F83FFFF, "AH" ],  // 111.129.0.0-111.131.255.255, AH
        [ 0x6F840000, 0x6F8485FF, "BJ" ],  // 111.132.0.0-111.132.133.255, BJ
        [ 0x6F848600, 0x6F8488FF, "TJ" ],  // 111.132.134.0-111.132.136.255, TJ
        [ 0x6F848900, 0x6F84FFFF, "BJ" ],  // 111.132.137.0-111.132.255.255, BJ
        [ 0x6F850000, 0x6F85FFFF, "SX" ],  // 111.133.0.0-111.133.255.255, SX
        [ 0x6F860000, 0x6F87FFFF, "BJ" ],  // 111.134.0.0-111.135.255.255, BJ
        [ 0x6F880000, 0x6F88FFFF, "JL" ],  // 111.136.0.0-111.136.255.255, JL
        [ 0x6F890000, 0x6F89FFFF, "HL" ],  // 111.137.0.0-111.137.255.255, HL
        [ 0x6F8A0000, 0x6F8BFFFF, "BJ" ],  // 111.138.0.0-111.139.255.255, BJ
        [ 0x6F8C0000, 0x6F8CFFFF, "ZJ" ],  // 111.140.0.0-111.140.255.255, ZJ
        [ 0x6F8D0000, 0x6F8DFFFF, "AH" ],  // 111.141.0.0-111.141.255.255, AH
        [ 0x6F8E0000, 0x6F93FFFF, "FJ" ],  // 111.142.0.0-111.147.255.255, FJ
        [ 0x6F940000, 0x6F97FFFF, "GD" ],  // 111.148.0.0-111.151.255.255, GD
        [ 0x6F980000, 0x6F9AFFFF, "BJ" ],  // 111.152.0.0-111.154.255.255, BJ
        [ 0x6F9B0000, 0x6F9BFFFF, "SN" ],  // 111.155.0.0-111.155.255.255, SN
        [ 0x6F9C0000, 0x6F9FFFFF, "BJ" ],  // 111.156.0.0-111.159.255.255, BJ
        [ 0x6FA00000, 0x6FA7FFFF, "TJ" ],  // 111.160.0.0-111.167.255.255, TJ
        [ 0x6FAA0000, 0x6FAAFFFF, "HB" ],  // 111.170.0.0-111.170.255.255, HB
        [ 0x6FAC0000, 0x6FB7FFFF, "HB" ],  // 111.172.0.0-111.183.255.255, HB
        [ 0x6FBA0000, 0x6FBA7FFF, "SH" ],  // 111.186.0.0-111.186.127.255, SH
        [ 0x6FBA8000, 0x6FBA8FFF, "BJ" ],  // 111.186.128.0-111.186.143.255, BJ
        [ 0x6FBA9000, 0x6FBABFFF, "SH" ],  // 111.186.144.0-111.186.191.255, SH
        [ 0x6FBAC000, 0x6FBAFFFF, "FJ" ],  // 111.186.192.0-111.186.255.255, FJ
        [ 0x6FBB0000, 0x6FBB7FFF, "SH" ],  // 111.187.0.0-111.187.127.255, SH
        [ 0x6FBB8000, 0x6FBBFFFF, "FJ" ],  // 111.187.128.0-111.187.255.255, FJ
        [ 0x6FC00000, 0x6FCCC8FF, "BJ" ],  // 111.192.0.0-111.204.200.255, BJ
        [ 0x6FCCC900, 0x6FCCC9FF, "GD" ],  // 111.204.201.0-111.204.201.255, GD
        [ 0x6FCCCA00, 0x6FCCCCFF, "BJ" ],  // 111.204.202.0-111.204.204.255, BJ
        [ 0x6FCCCD00, 0x6FCCCDFF, "GD" ],  // 111.204.205.0-111.204.205.255, GD
        [ 0x6FCCCE00, 0x6FCD2DFF, "BJ" ],  // 111.204.206.0-111.205.45.255, BJ
        [ 0x6FCD2E00, 0x6FCD2EFF, "HE" ],  // 111.205.46.0-111.205.46.255, HE
        [ 0x6FCD2F00, 0x6FCFFFFF, "BJ" ],  // 111.205.47.0-111.207.255.255, BJ
        [ 0x6FD00000, 0x6FD3FFFF, "JS" ],  // 111.208.0.0-111.211.255.255, JS
        [ 0x6FD40000, 0x6FD7FFFF, "SH" ],  // 111.212.0.0-111.215.255.255, SH
        [ 0x6FDD1C00, 0x6FDD1CFF, "BJ" ],  // 111.221.28.0-111.221.28.255, BJ
        [ 0x6FDD8000, 0x6FDEFFFF, "GD" ],  // 111.221.128.0-111.222.255.255, GD
        [ 0x6FDF0400, 0x6FDF07FF, "BJ" ],  // 111.223.4.0-111.223.7.255, BJ
        [ 0x6FDF0800, 0x6FDF0BFF, "SH" ],  // 111.223.8.0-111.223.11.255, SH
        [ 0x6FDF0C00, 0x6FDF0FFF, "JS" ],  // 111.223.12.0-111.223.15.255, JS
        [ 0x6FDF1000, 0x6FDF13FF, "SH" ],  // 111.223.16.0-111.223.19.255, SH
        [ 0x6FDFF000, 0x6FDFF3FF, "BJ" ],  // 111.223.240.0-111.223.243.255, BJ
        [ 0x6FDFF800, 0x6FDFFBFF, "BJ" ],  // 111.223.248.0-111.223.251.255, BJ
        [ 0x6FE00000, 0x6FE3FFFF, "HE" ],  // 111.224.0.0-111.227.255.255, HE
        [ 0x6FE40000, 0x6FE4FFFF, "ZJ" ],  // 111.228.0.0-111.228.255.255, ZJ
        [ 0x6FE50000, 0x6FE5FFFF, "SH" ],  // 111.229.0.0-111.229.255.255, SH
        [ 0x6FE60000, 0x6FE6FFFF, "GD" ],  // 111.230.0.0-111.230.255.255, GD
        [ 0x6FE70000, 0x6FE7BBFF, "SH" ],  // 111.231.0.0-111.231.187.255, SH
        [ 0x6FE7BC00, 0x6FE7BDFF, "CQ" ],  // 111.231.188.0-111.231.189.255, CQ
        [ 0x6FE7BE00, 0x6FE7E5FF, "SC" ],  // 111.231.190.0-111.231.229.255, SC
        [ 0x6FE7E600, 0x6FE7FFFF, "GD" ],  // 111.231.230.0-111.231.255.255, GD
        [ 0x6FEB6000, 0x6FEB7FFF, "SH" ],  // 111.235.96.0-111.235.127.255, SH
        [ 0x6FEB9C00, 0x6FEB9FFF, "NM" ],  // 111.235.156.0-111.235.159.255, NM
        [ 0x6FEBA000, 0x6FEBA2FF, "BJ" ],  // 111.235.160.0-111.235.162.255, BJ
        [ 0x6FEBA300, 0x6FEBA3FF, "SH" ],  // 111.235.163.0-111.235.163.255, SH
        [ 0x6FEBA400, 0x6FEBA4FF, "BJ" ],  // 111.235.164.0-111.235.164.255, BJ
        [ 0x6FEBA500, 0x6FEBA5FF, "SC" ],  // 111.235.165.0-111.235.165.255, SC
        [ 0x6FEBA600, 0x6FEBA8FF, "BJ" ],  // 111.235.166.0-111.235.168.255, BJ
        [ 0x6FEBA900, 0x6FEBA9FF, "HI" ],  // 111.235.169.0-111.235.169.255, HI
        [ 0x6FEBAA00, 0x6FEBB1FF, "BJ" ],  // 111.235.170.0-111.235.177.255, BJ
        [ 0x6FEBB200, 0x6FEBB3FF, "SC" ],  // 111.235.178.0-111.235.179.255, SC
        [ 0x6FEBB400, 0x6FEBBFFF, "BJ" ],  // 111.235.180.0-111.235.191.255, BJ
        [ 0x70000000, 0x7004FFFF, "JS" ],  // 112.0.0.0-112.4.255.255, JS
        [ 0x70050000, 0x7005FFFF, "FJ" ],  // 112.5.0.0-112.5.255.255, FJ
        [ 0x70060000, 0x7009FFFF, "SD" ],  // 112.6.0.0-112.9.255.255, SD
        [ 0x700A0000, 0x7011FFFF, "ZJ" ],  // 112.10.0.0-112.17.255.255, ZJ
        [ 0x70120000, 0x7013FFFF, "SC" ],  // 112.18.0.0-112.19.255.255, SC
        [ 0x70140000, 0x7019FFFF, "JS" ],  // 112.20.0.0-112.25.255.255, JS
        [ 0x701A0000, 0x7020FFFF, "AH" ],  // 112.26.0.0-112.32.255.255, AH
        [ 0x70210000, 0x7021F9FF, "GD" ],  // 112.33.0.0-112.33.249.255, GD
        [ 0x7021FA00, 0x7021FFFF, "HN" ],  // 112.33.250.0-112.33.255.255, HN
        [ 0x70220000, 0x7022FFFF, "BJ" ],  // 112.34.0.0-112.34.255.255, BJ
        [ 0x70230000, 0x70230AFF, "GD" ],  // 112.35.0.0-112.35.10.255, GD
        [ 0x70230B00, 0x7023FFFF, "BJ" ],  // 112.35.11.0-112.35.255.255, BJ
        [ 0x70240000, 0x7026FFFF, "SD" ],  // 112.36.0.0-112.38.255.255, SD
        [ 0x70270000, 0x702AFFFF, "LN" ],  // 112.39.0.0-112.42.255.255, LN
        [ 0x702B0000, 0x702BFFFF, "XJ" ],  // 112.43.0.0-112.43.255.255, XJ
        [ 0x702C0000, 0x702DFFFF, "SC" ],  // 112.44.0.0-112.45.255.255, SC
        [ 0x702E0000, 0x702EFFFF, "SN" ],  // 112.46.0.0-112.46.255.255, SN
        [ 0x702F0000, 0x7033FFFF, "FJ" ],  // 112.47.0.0-112.51.255.255, FJ
        [ 0x70340000, 0x7034FFFF, "SH" ],  // 112.52.0.0-112.52.255.255, SH
        [ 0x70350000, 0x70353FFF, "GD" ],  // 112.53.0.0-112.53.63.255, GD
        [ 0x70354000, 0x70355FFF, "SD" ],  // 112.53.64.0-112.53.95.255, SD
        [ 0x70356000, 0x70357FFF, "HA" ],  // 112.53.96.0-112.53.127.255, HA
        [ 0x70358000, 0x70359FFF, "JS" ],  // 112.53.128.0-112.53.159.255, JS
        [ 0x7035A000, 0x7035AFFF, "SC" ],  // 112.53.160.0-112.53.175.255, SC
        [ 0x7035B000, 0x7035BFFF, "ZJ" ],  // 112.53.176.0-112.53.191.255, ZJ
        [ 0x7035C000, 0x7035CFFF, "HE" ],  // 112.53.192.0-112.53.207.255, HE
        [ 0x7035D000, 0x7035DFFF, "GD" ],  // 112.53.208.0-112.53.223.255, GD
        [ 0x7035E000, 0x7035EFFF, "AH" ],  // 112.53.224.0-112.53.239.255, AH
        [ 0x7035F000, 0x7035FFFF, "HB" ],  // 112.53.240.0-112.53.255.255, HB
        [ 0x70360000, 0x70360FFF, "LN" ],  // 112.54.0.0-112.54.15.255, LN
        [ 0x70361000, 0x70361FFF, "YN" ],  // 112.54.16.0-112.54.31.255, YN
        [ 0x70362000, 0x70362FFF, "FJ" ],  // 112.54.32.0-112.54.47.255, FJ
        [ 0x70363000, 0x70363FFF, "GX" ],  // 112.54.48.0-112.54.63.255, GX
        [ 0x70364000, 0x70364FFF, "SN" ],  // 112.54.64.0-112.54.79.255, SN
        [ 0x70365000, 0x703657FF, "SD" ],  // 112.54.80.0-112.54.87.255, SD
        [ 0x70365800, 0x70365FFF, "SC" ],  // 112.54.88.0-112.54.95.255, SC
        [ 0x70366000, 0x703667FF, "ZJ" ],  // 112.54.96.0-112.54.103.255, ZJ
        [ 0x70366800, 0x70366FFF, "HE" ],  // 112.54.104.0-112.54.111.255, HE
        [ 0x70367000, 0x703677FF, "HL" ],  // 112.54.112.0-112.54.119.255, HL
        [ 0x70367800, 0x70367FFF, "JX" ],  // 112.54.120.0-112.54.127.255, JX
        [ 0x70368000, 0x703687FF, "BJ" ],  // 112.54.128.0-112.54.135.255, BJ
        [ 0x70368800, 0x70368FFF, "GZ" ],  // 112.54.136.0-112.54.143.255, GZ
        [ 0x70369000, 0x70369FFF, "SX" ],  // 112.54.144.0-112.54.159.255, SX
        [ 0x7036A000, 0x7036A7FF, "SH" ],  // 112.54.160.0-112.54.167.255, SH
        [ 0x7036A800, 0x7036AFFF, "NM" ],  // 112.54.168.0-112.54.175.255, NM
        [ 0x7036B000, 0x7036B7FF, "CQ" ],  // 112.54.176.0-112.54.183.255, CQ
        [ 0x7036B800, 0x7036BFFF, "GS" ],  // 112.54.184.0-112.54.191.255, GS
        [ 0x7036C000, 0x7036C7FF, "JS" ],  // 112.54.192.0-112.54.199.255, JS
        [ 0x7036C800, 0x7036CBFF, "SC" ],  // 112.54.200.0-112.54.203.255, SC
        [ 0x7036CC00, 0x7036CFFF, "ZJ" ],  // 112.54.204.0-112.54.207.255, ZJ
        [ 0x7036D000, 0x7036D3FF, "HL" ],  // 112.54.208.0-112.54.211.255, HL
        [ 0x7036D400, 0x7036D7FF, "JX" ],  // 112.54.212.0-112.54.215.255, JX
        [ 0x7036D800, 0x7036DBFF, "BJ" ],  // 112.54.216.0-112.54.219.255, BJ
        [ 0x7036DC00, 0x7036E3FF, "GZ" ],  // 112.54.220.0-112.54.227.255, GZ
        [ 0x7036E400, 0x7036E7FF, "SX" ],  // 112.54.228.0-112.54.231.255, SX
        [ 0x7036E800, 0x7036EBFF, "SH" ],  // 112.54.232.0-112.54.235.255, SH
        [ 0x7036EC00, 0x7036EFFF, "NM" ],  // 112.54.236.0-112.54.239.255, NM
        [ 0x7036F000, 0x7036F3FF, "TJ" ],  // 112.54.240.0-112.54.243.255, TJ
        [ 0x7036F400, 0x7036F7FF, "HI" ],  // 112.54.244.0-112.54.247.255, HI
        [ 0x7036F800, 0x7036F9FF, "CQ" ],  // 112.54.248.0-112.54.249.255, CQ
        [ 0x7036FA00, 0x7036FBFF, "NX" ],  // 112.54.250.0-112.54.251.255, NX
        [ 0x7036FC00, 0x7036FDFF, "QH" ],  // 112.54.252.0-112.54.253.255, QH
        [ 0x7036FE00, 0x7036FFFF, "XZ" ],  // 112.54.254.0-112.54.255.255, XZ
        [ 0x70370000, 0x70393FFF, "BJ" ],  // 112.55.0.0-112.57.63.255, BJ
        [ 0x70394000, 0x70394FFF, "TJ" ],  // 112.57.64.0-112.57.79.255, TJ
        [ 0x70395000, 0x70396FFF, "HE" ],  // 112.57.80.0-112.57.111.255, HE
        [ 0x70397000, 0x70398FFF, "SX" ],  // 112.57.112.0-112.57.143.255, SX
        [ 0x70399000, 0x7039AFFF, "NM" ],  // 112.57.144.0-112.57.175.255, NM
        [ 0x7039B000, 0x7039EFFF, "JL" ],  // 112.57.176.0-112.57.239.255, JL
        [ 0x7039F000, 0x703A3FFF, "LN" ],  // 112.57.240.0-112.58.63.255, LN
        [ 0x703A4000, 0x703AAFFF, "JS" ],  // 112.58.64.0-112.58.175.255, JS
        [ 0x703AB000, 0x703AEFFF, "ZJ" ],  // 112.58.176.0-112.58.239.255, ZJ
        [ 0x703AF000, 0x703AFFFF, "XZ" ],  // 112.58.240.0-112.58.255.255, XZ
        [ 0x703B0000, 0x703B3FFF, "AH" ],  // 112.59.0.0-112.59.63.255, AH
        [ 0x703B4000, 0x703B7FFF, "FJ" ],  // 112.59.64.0-112.59.127.255, FJ
        [ 0x703B8000, 0x703BAFFF, "JX" ],  // 112.59.128.0-112.59.175.255, JX
        [ 0x703BB000, 0x703BFFFF, "HA" ],  // 112.59.176.0-112.59.255.255, HA
        [ 0x703C0000, 0x703C9FFF, "GD" ],  // 112.60.0.0-112.60.159.255, GD
        [ 0x703CA000, 0x703D6FFF, "HB" ],  // 112.60.160.0-112.61.111.255, HB
        [ 0x703D7000, 0x703DB0FF, "HI" ],  // 112.61.112.0-112.61.176.255, HI
        [ 0x703DB100, 0x703DBFFF, "GD" ],  // 112.61.177.0-112.61.191.255, GD
        [ 0x703DC000, 0x703DFFFF, "SC" ],  // 112.61.192.0-112.61.255.255, SC
        [ 0x703E0000, 0x703E2FFF, "GX" ],  // 112.62.0.0-112.62.47.255, GX
        [ 0x703E3000, 0x703E5FFF, "CQ" ],  // 112.62.48.0-112.62.95.255, CQ
        [ 0x703E6000, 0x703E6FFF, "GZ" ],  // 112.62.96.0-112.62.111.255, GZ
        [ 0x703E7000, 0x703E8FFF, "YN" ],  // 112.62.112.0-112.62.143.255, YN
        [ 0x703E9000, 0x703ECFFF, "SN" ],  // 112.62.144.0-112.62.207.255, SN
        [ 0x703ED000, 0x703EEFFF, "GS" ],  // 112.62.208.0-112.62.239.255, GS
        [ 0x703EF000, 0x703EFFFF, "NX" ],  // 112.62.240.0-112.62.255.255, NX
        [ 0x703F0000, 0x703FFFFF, "QH" ],  // 112.63.0.0-112.63.255.255, QH
        [ 0x70400000, 0x7041DBFF, "SH" ],  // 112.64.0.0-112.65.219.255, SH
        [ 0x7041DC00, 0x7041DCFF, "GD" ],  // 112.65.220.0-112.65.220.255, GD
        [ 0x7041DD00, 0x7041FFFF, "SH" ],  // 112.65.221.0-112.65.255.255, SH
        [ 0x70420000, 0x7043FFFF, "HI" ],  // 112.66.0.0-112.67.255.255, HI
        [ 0x70494000, 0x704941FF, "JS" ],  // 112.73.64.0-112.73.65.255, JS
        [ 0x70494200, 0x70494BFF, "ZJ" ],  // 112.73.66.0-112.73.75.255, ZJ
        [ 0x70494C00, 0x70494CFF, "JS" ],  // 112.73.76.0-112.73.76.255, JS
        [ 0x70494D00, 0x70494EFF, "ZJ" ],  // 112.73.77.0-112.73.78.255, ZJ
        [ 0x70494F00, 0x70494FFF, "JS" ],  // 112.73.79.0-112.73.79.255, JS
        [ 0x70495000, 0x704950FF, "ZJ" ],  // 112.73.80.0-112.73.80.255, ZJ
        [ 0x70495100, 0x70497FFF, "JS" ],  // 112.73.81.0-112.73.127.255, JS
        [ 0x70498000, 0x704BFFFF, "GD" ],  // 112.73.128.0-112.75.255.255, GD
        [ 0x70500000, 0x7057FFFF, "JS" ],  // 112.80.0.0-112.87.255.255, JS
        [ 0x70580000, 0x706060FF, "GD" ],  // 112.88.0.0-112.96.96.255, GD
        [ 0x70606100, 0x706061FF, "JX" ],  // 112.96.97.0-112.96.97.255, JX
        [ 0x70606200, 0x7061FFFF, "GD" ],  // 112.96.98.0-112.97.255.255, GD
        [ 0x70620000, 0x7067FFFF, "HL" ],  // 112.98.0.0-112.103.255.255, HL
        [ 0x706D8000, 0x706DFFFF, "FJ" ],  // 112.109.128.0-112.109.255.255, FJ
        [ 0x706F0000, 0x706FFFFF, "FJ" ],  // 112.111.0.0-112.111.255.255, FJ
        [ 0x70700000, 0x7075FFFF, "YN" ],  // 112.112.0.0-112.117.255.255, YN
        [ 0x707A0000, 0x707BFFFF, "AH" ],  // 112.122.0.0-112.123.255.255, AH
        [ 0x707C0000, 0x707CFFFF, "ZJ" ],  // 112.124.0.0-112.124.255.255, ZJ
        [ 0x707D0000, 0x707EFFFF, "BJ" ],  // 112.125.0.0-112.126.255.255, BJ
        [ 0x707F0000, 0x707FFFFF, "ZJ" ],  // 112.127.0.0-112.127.255.255, ZJ
        [ 0x70800000, 0x7083FFFF, "BJ" ],  // 112.128.0.0-112.131.255.255, BJ
        [ 0x70840000, 0x7084FFFF, "AH" ],  // 112.132.0.0-112.132.255.255, AH
        [ 0x70893000, 0x708937FF, "GD" ],  // 112.137.48.0-112.137.55.255, GD
        [ 0x70C00000, 0x70C3FFFF, "SC" ],  // 112.192.0.0-112.195.255.255, SC
        [ 0x70E00000, 0x70E094FF, "SD" ],  // 112.224.0.0-112.224.148.255, SD
        [ 0x70E09500, 0x70E098FF, "HE" ],  // 112.224.149.0-112.224.152.255, HE
        [ 0x70E09900, 0x70FFFFFF, "SD" ],  // 112.224.153.0-112.255.255.255, SD
        [ 0x71000000, 0x7109FFFF, "HL" ],  // 113.0.0.0-113.9.255.255, HL
        [ 0x710BC000, 0x710BDFFF, "BJ" ],  // 113.11.192.0-113.11.223.255, BJ
        [ 0x710C0000, 0x7111FFFF, "GX" ],  // 113.12.0.0-113.17.255.255, GX
        [ 0x71120000, 0x7112FFFF, "FJ" ],  // 113.18.0.0-113.18.255.255, FJ
        [ 0x7115E800, 0x7115E8FF, "GD" ],  // 113.21.232.0-113.21.232.255, GD
        [ 0x7115E900, 0x7115EFFF, "SH" ],  // 113.21.233.0-113.21.239.255, SH
        [ 0x71180000, 0x711837FF, "SX" ],  // 113.24.0.0-113.24.55.255, SX
        [ 0x71183800, 0x711838FF, "GX" ],  // 113.24.56.0-113.24.56.255, GX
        [ 0x71183900, 0x711839FF, "JS" ],  // 113.24.57.0-113.24.57.255, JS
        [ 0x71183A00, 0x711BFFFF, "SX" ],  // 113.24.58.0-113.27.255.255, SX
        [ 0x711F0000, 0x711F1FFF, "BJ" ],  // 113.31.0.0-113.31.31.255, BJ
        [ 0x711F2000, 0x711F2FFF, "TJ" ],  // 113.31.32.0-113.31.47.255, TJ
        [ 0x711F3000, 0x711F5FFF, "BJ" ],  // 113.31.48.0-113.31.95.255, BJ
        [ 0x711F6000, 0x711F7FFF, "SH" ],  // 113.31.96.0-113.31.127.255, SH
        [ 0x711F8000, 0x711F8FFF, "BJ" ],  // 113.31.128.0-113.31.143.255, BJ
        [ 0x711F9000, 0x711F9FFF, "SH" ],  // 113.31.144.0-113.31.159.255, SH
        [ 0x711FA000, 0x711FFFFF, "BJ" ],  // 113.31.160.0-113.31.255.255, BJ
        [ 0x712C0000, 0x7133FFFF, "BJ" ],  // 113.44.0.0-113.51.255.255, BJ
        [ 0x7134A000, 0x7134BFFF, "SH" ],  // 113.52.160.0-113.52.191.255, SH
        [ 0x7134E400, 0x7134E7FF, "AH" ],  // 113.52.228.0-113.52.231.255, AH
        [ 0x71360000, 0x71361FFF, "SC" ],  // 113.54.0.0-113.54.31.255, SC
        [ 0x71362000, 0x71363FFF, "YN" ],  // 113.54.32.0-113.54.63.255, YN
        [ 0x71364000, 0x7136FFFF, "SC" ],  // 113.54.64.0-113.54.255.255, SC
        [ 0x71370000, 0x7137FFFF, "YN" ],  // 113.55.0.0-113.55.255.255, YN
        [ 0x71380000, 0x7139FFFF, "HB" ],  // 113.56.0.0-113.57.255.255, HB
        [ 0x713A0000, 0x713B7FFF, "HI" ],  // 113.58.0.0-113.59.127.255, HI
        [ 0x713BE000, 0x713BE3FF, "BJ" ],  // 113.59.224.0-113.59.227.255, BJ
        [ 0x713E0000, 0x713FFFFF, "XZ" ],  // 113.62.0.0-113.63.255.255, XZ
        [ 0x71400000, 0x7177FFFF, "GD" ],  // 113.64.0.0-113.119.255.255, GD
        [ 0x71780000, 0x7179B7FF, "SD" ],  // 113.120.0.0-113.121.183.255, SD
        [ 0x7179B800, 0x7179BFFF, "YN" ],  // 113.121.184.0-113.121.191.255, YN
        [ 0x7179C000, 0x7181FFFF, "SD" ],  // 113.121.192.0-113.129.255.255, SD
        [ 0x71826000, 0x718277FF, "BJ" ],  // 113.130.96.0-113.130.119.255, BJ
        [ 0x71840000, 0x718FFFFF, "SN" ],  // 113.132.0.0-113.143.255.255, SN
        [ 0x71C02800, 0x71C029FF, "ZJ" ],  // 113.192.40.0-113.192.41.255, ZJ
        [ 0x71C03800, 0x71C039FF, "SC" ],  // 113.192.56.0-113.192.57.255, SC
        [ 0x71C20000, 0x71C3FFFF, "JX" ],  // 113.194.0.0-113.195.255.255, JX
        [ 0x71C56400, 0x71C567FF, "SH" ],  // 113.197.100.0-113.197.103.255, SH
        [ 0x71C56800, 0x71C56BFF, "BJ" ],  // 113.197.104.0-113.197.107.255, BJ
        [ 0x71C80000, 0x71C9FFFF, "SN" ],  // 113.200.0.0-113.201.255.255, SN
        [ 0x71CA0000, 0x71CAFFFF, "SH" ],  // 113.202.0.0-113.202.255.255, SH
        [ 0x71CC0000, 0x71CFFFFF, "CQ" ],  // 113.204.0.0-113.207.255.255, CQ
        [ 0x71D06000, 0x71D1FFFF, "BJ" ],  // 113.208.96.0-113.209.255.255, BJ
        [ 0x71D40000, 0x71D43FFF, "BJ" ],  // 113.212.0.0-113.212.63.255, BJ
        [ 0x71D46400, 0x71D467FF, "BJ" ],  // 113.212.100.0-113.212.103.255, BJ
        [ 0x71D4B800, 0x71D4BFFF, "GD" ],  // 113.212.184.0-113.212.191.255, GD
        [ 0x71D50000, 0x71D57FFF, "JL" ],  // 113.213.0.0-113.213.127.255, JL
        [ 0x71D60000, 0x71D7FFFF, "ZJ" ],  // 113.214.0.0-113.215.255.255, ZJ
        [ 0x71DA0000, 0x71DFFFFF, "HN" ],  // 113.218.0.0-113.223.255.255, HN
        [ 0x71E00000, 0x71EFFFFF, "LN" ],  // 113.224.0.0-113.239.255.255, LN
        [ 0x71F00000, 0x71F7FFFF, "HN" ],  // 113.240.0.0-113.247.255.255, HN
        [ 0x71F80000, 0x71FBFFFF, "CQ" ],  // 113.248.0.0-113.251.255.255, CQ
        [ 0x721C0000, 0x721CBFFF, "SH" ],  // 114.28.0.0-114.28.191.255, SH
        [ 0x721CC000, 0x721CDFFF, "ZJ" ],  // 114.28.192.0-114.28.223.255, ZJ
        [ 0x721CE500, 0x721CE7FF, "SH" ],  // 114.28.229.0-114.28.231.255, SH
        [ 0x721CE800, 0x721CEBFF, "ZJ" ],  // 114.28.232.0-114.28.235.255, ZJ
        [ 0x721CEC00, 0x721CEFFF, "SH" ],  // 114.28.236.0-114.28.239.255, SH
        [ 0x721CF000, 0x721CF7FF, "ZJ" ],  // 114.28.240.0-114.28.247.255, ZJ
        [ 0x721CF800, 0x721CF8FF, "SH" ],  // 114.28.248.0-114.28.248.255, SH
        [ 0x721CF900, 0x721CFFFF, "ZJ" ],  // 114.28.249.0-114.28.255.255, ZJ
        [ 0x721F4000, 0x721F47FF, "GD" ],  // 114.31.64.0-114.31.71.255, GD
        [ 0x72360000, 0x7236FFFF, "BJ" ],  // 114.54.0.0-114.54.255.255, BJ
        [ 0x72370000, 0x7237FFFF, "ZJ" ],  // 114.55.0.0-114.55.255.255, ZJ
        [ 0x723C0000, 0x723FFFFF, "SH" ],  // 114.60.0.0-114.63.255.255, SH
        [ 0x72400000, 0x7241FFFF, "BJ" ],  // 114.64.0.0-114.65.255.255, BJ
        [ 0x72420000, 0x72423FFF, "ZJ" ],  // 114.66.0.0-114.66.63.255, ZJ
        [ 0x72424000, 0x724241FF, "SH" ],  // 114.66.64.0-114.66.65.255, SH
        [ 0x72424200, 0x724242FF, "BJ" ],  // 114.66.66.0-114.66.66.255, BJ
        [ 0x72424300, 0x724243FF, "GD" ],  // 114.66.67.0-114.66.67.255, GD
        [ 0x72424400, 0x72424FFF, "SH" ],  // 114.66.68.0-114.66.79.255, SH
        [ 0x72425000, 0x7242FFFF, "BJ" ],  // 114.66.80.0-114.66.255.255, BJ
        [ 0x72430000, 0x72433FFF, "GD" ],  // 114.67.0.0-114.67.63.255, GD
        [ 0x72434000, 0x72437FFF, "SH" ],  // 114.67.64.0-114.67.127.255, SH
        [ 0x72438000, 0x72439FFF, "BJ" ],  // 114.67.128.0-114.67.159.255, BJ
        [ 0x7243A000, 0x7243DFFF, "GD" ],  // 114.67.160.0-114.67.223.255, GD
        [ 0x7243E000, 0x7244FFFF, "BJ" ],  // 114.67.224.0-114.68.255.255, BJ
        [ 0x724F4000, 0x724F7FFF, "GD" ],  // 114.79.64.0-114.79.127.255, GD
        [ 0x72500000, 0x725FFFFF, "SH" ],  // 114.80.0.0-114.95.255.255, SH
        [ 0x72600000, 0x726401FF, "AH" ],  // 114.96.0.0-114.100.1.255, AH
        [ 0x72640200, 0x726402FF, "HA" ],  // 114.100.2.0-114.100.2.255, HA
        [ 0x72640300, 0x726410FF, "AH" ],  // 114.100.3.0-114.100.16.255, AH
        [ 0x72641100, 0x726411FF, "JS" ],  // 114.100.17.0-114.100.17.255, JS
        [ 0x72641200, 0x726476FF, "AH" ],  // 114.100.18.0-114.100.118.255, AH
        [ 0x72647700, 0x726477FF, "JS" ],  // 114.100.119.0-114.100.119.255, JS
        [ 0x72647800, 0x726BFFFF, "AH" ],  // 114.100.120.0-114.107.255.255, AH
        [ 0x726E0000, 0x726E0FFF, "BJ" ],  // 114.110.0.0-114.110.15.255, BJ
        [ 0x726E4000, 0x726E5FFF, "BJ" ],  // 114.110.64.0-114.110.95.255, BJ
        [ 0x726E6000, 0x726E63FF, "JS" ],  // 114.110.96.0-114.110.99.255, JS
        [ 0x726E6400, 0x726E7FFF, "BJ" ],  // 114.110.100.0-114.110.127.255, BJ
        [ 0x726F0000, 0x726F01FF, "SN" ],  // 114.111.0.0-114.111.1.255, SN
        [ 0x726F0200, 0x726F1FFF, "JL" ],  // 114.111.2.0-114.111.31.255, JL
        [ 0x726FA000, 0x726FBFFF, "BJ" ],  // 114.111.160.0-114.111.191.255, BJ
        [ 0x72700400, 0x727005FF, "BJ" ],  // 114.112.4.0-114.112.5.255, BJ
        [ 0x72700600, 0x72700BFF, "ZJ" ],  // 114.112.6.0-114.112.11.255, ZJ
        [ 0x72701000, 0x727012FF, "GD" ],  // 114.112.16.0-114.112.18.255, GD
        [ 0x72701600, 0x727016FF, "BJ" ],  // 114.112.22.0-114.112.22.255, BJ
        [ 0x72701800, 0x72701FFF, "LN" ],  // 114.112.24.0-114.112.31.255, LN
        [ 0x72702000, 0x72706FFF, "BJ" ],  // 114.112.32.0-114.112.111.255, BJ
        [ 0x72707000, 0x727073FF, "GD" ],  // 114.112.112.0-114.112.115.255, GD
        [ 0x72707400, 0x72707FFF, "BJ" ],  // 114.112.116.0-114.112.127.255, BJ
        [ 0x72708100, 0x727081FF, "BJ" ],  // 114.112.129.0-114.112.129.255, BJ
        [ 0x72708300, 0x727083FF, "BJ" ],  // 114.112.131.0-114.112.131.255, BJ
        [ 0x72708800, 0x727097FF, "BJ" ],  // 114.112.136.0-114.112.151.255, BJ
        [ 0x72709800, 0x72709FFF, "LN" ],  // 114.112.152.0-114.112.159.255, LN
        [ 0x7270A000, 0x7270DFFF, "BJ" ],  // 114.112.160.0-114.112.223.255, BJ
        [ 0x72710000, 0x727187FF, "BJ" ],  // 114.113.0.0-114.113.135.255, BJ
        [ 0x72718800, 0x72718BFF, "GD" ],  // 114.113.136.0-114.113.139.255, GD
        [ 0x72718C00, 0x72719FFF, "BJ" ],  // 114.113.140.0-114.113.159.255, BJ
        [ 0x7271A000, 0x7271BFFF, "HA" ],  // 114.113.160.0-114.113.191.255, HA
        [ 0x7271C000, 0x7271C3FF, "GD" ],  // 114.113.192.0-114.113.195.255, GD
        [ 0x7271C400, 0x7271CBFF, "ZJ" ],  // 114.113.196.0-114.113.203.255, ZJ
        [ 0x7271CC00, 0x7271CFFF, "BJ" ],  // 114.113.204.0-114.113.207.255, BJ
        [ 0x7271D000, 0x7271D7FF, "LN" ],  // 114.113.208.0-114.113.215.255, LN
        [ 0x7271D800, 0x7271DBFF, "ZJ" ],  // 114.113.216.0-114.113.219.255, ZJ
        [ 0x7271DC00, 0x7271EFFF, "BJ" ],  // 114.113.220.0-114.113.239.255, BJ
        [ 0x7271F200, 0x7271F2FF, "BJ" ],  // 114.113.242.0-114.113.242.255, BJ
        [ 0x7271F600, 0x7271FCFF, "BJ" ],  // 114.113.246.0-114.113.252.255, BJ
        [ 0x7271FF00, 0x7271FFFF, "BJ" ],  // 114.113.255.0-114.113.255.255, BJ
        [ 0x72720000, 0x72729EFF, "JS" ],  // 114.114.0.0-114.114.158.255, JS
        [ 0x72729F00, 0x72729FFF, "BJ" ],  // 114.114.159.0-114.114.159.255, BJ
        [ 0x7272A000, 0x7272FFFF, "JS" ],  // 114.114.160.0-114.114.255.255, JS
        [ 0x72730000, 0x7274FFFF, "BJ" ],  // 114.115.0.0-114.116.255.255, BJ
        [ 0x72750000, 0x72751FFF, "SH" ],  // 114.117.0.0-114.117.31.255, SH
        [ 0x72752000, 0x72757FFF, "GD" ],  // 114.117.32.0-114.117.127.255, GD
        [ 0x72758000, 0x72759FFF, "BJ" ],  // 114.117.128.0-114.117.159.255, BJ
        [ 0x7275A000, 0x7275BFFF, "SC" ],  // 114.117.160.0-114.117.191.255, SC
        [ 0x7275C000, 0x7275FFFF, "CQ" ],  // 114.117.192.0-114.117.255.255, CQ
        [ 0x72760000, 0x72767FFF, "BJ" ],  // 114.118.0.0-114.118.127.255, BJ
        [ 0x72768000, 0x72777FFF, "GD" ],  // 114.118.128.0-114.119.127.255, GD
        [ 0x7277C000, 0x7277CBFF, "GD" ],  // 114.119.192.0-114.119.203.255, GD
        [ 0x7277CC00, 0x7277CFFF, "BJ" ],  // 114.119.204.0-114.119.207.255, BJ
        [ 0x7277D000, 0x7277FFFF, "GD" ],  // 114.119.208.0-114.119.255.255, GD
        [ 0x72840000, 0x7284FFFF, "GD" ],  // 114.132.0.0-114.132.255.255, GD
        [ 0x72870000, 0x7287FFFF, "GZ" ],  // 114.135.0.0-114.135.255.255, GZ
        [ 0x728A0000, 0x728BFFFF, "GZ" ],  // 114.138.0.0-114.139.255.255, GZ
        [ 0x728D4000, 0x728D47FF, "GD" ],  // 114.141.64.0-114.141.71.255, GD
        [ 0x728D5000, 0x728D57FF, "AH" ],  // 114.141.80.0-114.141.87.255, AH
        [ 0x728D8000, 0x728DBFFF, "SH" ],  // 114.141.128.0-114.141.191.255, SH
        [ 0x72C40000, 0x72C5FFFF, "HL" ],  // 114.196.0.0-114.197.255.255, HL
        [ 0x72C6F800, 0x72C6FFFF, "GD" ],  // 114.198.248.0-114.198.255.255, GD
        [ 0x72D00000, 0x72D3FFFF, "BJ" ],  // 114.208.0.0-114.211.255.255, BJ
        [ 0x72D40000, 0x72D57FFF, "JS" ],  // 114.212.0.0-114.213.127.255, JS
        [ 0x72D58000, 0x72D5FFFF, "AH" ],  // 114.213.128.0-114.213.255.255, AH
        [ 0x72D60000, 0x72D64FFF, "SD" ],  // 114.214.0.0-114.214.79.255, SD
        [ 0x72D65000, 0x72D657FF, "JS" ],  // 114.214.80.0-114.214.87.255, JS
        [ 0x72D65800, 0x72D67FFF, "SD" ],  // 114.214.88.0-114.214.127.255, SD
        [ 0x72D68000, 0x72D6FFFF, "AH" ],  // 114.214.128.0-114.214.255.255, AH
        [ 0x72D70000, 0x72D7A7FF, "SD" ],  // 114.215.0.0-114.215.167.255, SD
        [ 0x72D7A800, 0x72D7DBFF, "ZJ" ],  // 114.215.168.0-114.215.219.255, ZJ
        [ 0x72D7DC00, 0x72D7DFFF, "SD" ],  // 114.215.220.0-114.215.223.255, SD
        [ 0x72D7E000, 0x72D7FFFF, "ZJ" ],  // 114.215.224.0-114.215.255.255, ZJ
        [ 0x72D80000, 0x72EFFFFF, "JS" ],  // 114.216.0.0-114.239.255.255, JS
        [ 0x72F00000, 0x72FFFFFF, "BJ" ],  // 114.240.0.0-114.255.255.255, BJ
        [ 0x73180000, 0x731827FF, "SX" ],  // 115.24.0.0-115.24.39.255, SX
        [ 0x73182800, 0x73183FFF, "BJ" ],  // 115.24.40.0-115.24.63.255, BJ
        [ 0x73184000, 0x73187FFF, "NM" ],  // 115.24.64.0-115.24.127.255, NM
        [ 0x73188000, 0x731887FF, "BJ" ],  // 115.24.128.0-115.24.135.255, BJ
        [ 0x73188800, 0x7318FFFF, "TJ" ],  // 115.24.136.0-115.24.255.255, TJ
        [ 0x73190000, 0x7319CFFF, "BJ" ],  // 115.25.0.0-115.25.207.255, BJ
        [ 0x7319D000, 0x7319D0FF, "ZJ" ],  // 115.25.208.0-115.25.208.255, ZJ
        [ 0x7319D100, 0x7319D2FF, "SH" ],  // 115.25.209.0-115.25.210.255, SH
        [ 0x7319D300, 0x7319FFFF, "HB" ],  // 115.25.211.0-115.25.255.255, HB
        [ 0x731A0000, 0x731A0FFF, "TJ" ],  // 115.26.0.0-115.26.15.255, TJ
        [ 0x731A1000, 0x731A1FFF, "BJ" ],  // 115.26.16.0-115.26.31.255, BJ
        [ 0x731A2000, 0x731A6FFF, "TJ" ],  // 115.26.32.0-115.26.111.255, TJ
        [ 0x731A7000, 0x731A7FFF, "BJ" ],  // 115.26.112.0-115.26.127.255, BJ
        [ 0x731A8000, 0x731ACFFF, "NM" ],  // 115.26.128.0-115.26.207.255, NM
        [ 0x731AD000, 0x731BFFFF, "BJ" ],  // 115.26.208.0-115.27.255.255, BJ
        [ 0x731C0000, 0x731D00FF, "SD" ],  // 115.28.0.0-115.29.0.255, SD
        [ 0x731D0100, 0x731D13FF, "ZJ" ],  // 115.29.1.0-115.29.19.255, ZJ
        [ 0x731D1400, 0x731D17FF, "SD" ],  // 115.29.20.0-115.29.23.255, SD
        [ 0x731D1800, 0x731D1FFF, "ZJ" ],  // 115.29.24.0-115.29.31.255, ZJ
        [ 0x731D2000, 0x731D9FFF, "SD" ],  // 115.29.32.0-115.29.159.255, SD
        [ 0x731DA000, 0x731DFFFF, "ZJ" ],  // 115.29.160.0-115.29.255.255, ZJ
        [ 0x731F4000, 0x731F43FF, "SD" ],  // 115.31.64.0-115.31.67.255, SD
        [ 0x731F4400, 0x731F47FF, "GD" ],  // 115.31.68.0-115.31.71.255, GD
        [ 0x731F4800, 0x731F4FFF, "NM" ],  // 115.31.72.0-115.31.79.255, NM
        [ 0x73200000, 0x7322FFFF, "HB" ],  // 115.32.0.0-115.34.255.255, HB
        [ 0x73230000, 0x7323FFFF, "BJ" ],  // 115.35.0.0-115.35.255.255, BJ
        [ 0x732A3800, 0x732A3BFF, "BJ" ],  // 115.42.56.0-115.42.59.255, BJ
        [ 0x732C0000, 0x732DFFFF, "GD" ],  // 115.44.0.0-115.45.255.255, GD
        [ 0x732E0000, 0x732EFFFF, "GX" ],  // 115.46.0.0-115.46.255.255, GX
        [ 0x732F0000, 0x732FFFFF, "BJ" ],  // 115.47.0.0-115.47.255.255, BJ
        [ 0x73300000, 0x733FFFFF, "HA" ],  // 115.48.0.0-115.63.255.255, HA
        [ 0x73454000, 0x73454FFF, "GD" ],  // 115.69.64.0-115.69.79.255, GD
        [ 0x73540000, 0x73543FFF, "BJ" ],  // 115.84.0.0-115.84.63.255, BJ
        [ 0x7355C000, 0x7355FFFF, "GS" ],  // 115.85.192.0-115.85.255.255, GS
        [ 0x73640000, 0x73660FFF, "BJ" ],  // 115.100.0.0-115.102.15.255, BJ
        [ 0x73661000, 0x736677FF, "LN" ],  // 115.102.16.0-115.102.119.255, LN
        [ 0x73667800, 0x7367FBFF, "BJ" ],  // 115.102.120.0-115.103.251.255, BJ
        [ 0x7367FC00, 0x7367FFFF, "ZJ" ],  // 115.103.252.0-115.103.255.255, ZJ
        [ 0x73680000, 0x7369FFFF, "BJ" ],  // 115.104.0.0-115.105.255.255, BJ
        [ 0x736A0000, 0x736BFFFF, "GD" ],  // 115.106.0.0-115.107.255.255, GD
        [ 0x73780000, 0x73787FFF, "SN" ],  // 115.120.0.0-115.120.127.255, SN
        [ 0x73788000, 0x7378FFFF, "CQ" ],  // 115.120.128.0-115.120.255.255, CQ
        [ 0x73790000, 0x737AFFFF, "HB" ],  // 115.121.0.0-115.122.255.255, HB
        [ 0x737B0000, 0x737BFFFF, "BJ" ],  // 115.123.0.0-115.123.255.255, BJ
        [ 0x737C1000, 0x737C1FFF, "ZJ" ],  // 115.124.16.0-115.124.31.255, ZJ
        [ 0x73940000, 0x7399FFFF, "JX" ],  // 115.148.0.0-115.153.255.255, JX
        [ 0x739A0000, 0x739B3FFF, "SN" ],  // 115.154.0.0-115.155.63.255, SN
        [ 0x739B4000, 0x739BA7FF, "GS" ],  // 115.155.64.0-115.155.167.255, GS
        [ 0x739BA800, 0x739BAFFF, "SN" ],  // 115.155.168.0-115.155.175.255, SN
        [ 0x739BB000, 0x739BBFFF, "GS" ],  // 115.155.176.0-115.155.191.255, GS
        [ 0x739BC000, 0x739BD7FF, "XJ" ],  // 115.155.192.0-115.155.215.255, XJ
        [ 0x739BD800, 0x739BDFFF, "SN" ],  // 115.155.216.0-115.155.223.255, SN
        [ 0x739BE000, 0x739BFFFF, "XJ" ],  // 115.155.224.0-115.155.255.255, XJ
        [ 0x739C0000, 0x739D7FFF, "HB" ],  // 115.156.0.0-115.157.127.255, HB
        [ 0x739D8000, 0x739DBFFF, "HA" ],  // 115.157.128.0-115.157.191.255, HA
        [ 0x739DC000, 0x739DDFFF, "HN" ],  // 115.157.192.0-115.157.223.255, HN
        [ 0x739DE000, 0x739DEFFF, "HB" ],  // 115.157.224.0-115.157.239.255, HB
        [ 0x739DF000, 0x739DFFFF, "HN" ],  // 115.157.240.0-115.157.255.255, HN
        [ 0x739E0000, 0x739EFFFF, "HA" ],  // 115.158.0.0-115.158.255.255, HA
        [ 0x739F0000, 0x739FE3FF, "SH" ],  // 115.159.0.0-115.159.227.255, SH
        [ 0x739FE400, 0x739FE7FF, "TJ" ],  // 115.159.228.0-115.159.231.255, TJ
        [ 0x739FE800, 0x739FEDFF, "SH" ],  // 115.159.232.0-115.159.237.255, SH
        [ 0x739FEE00, 0x739FF5FF, "TJ" ],  // 115.159.238.0-115.159.245.255, TJ
        [ 0x739FF600, 0x739FFDFF, "SH" ],  // 115.159.246.0-115.159.253.255, SH
        [ 0x739FFE00, 0x739FFFFF, "GD" ],  // 115.159.254.0-115.159.255.255, GD
        [ 0x73A64000, 0x73A65FFF, "GD" ],  // 115.166.64.0-115.166.95.255, GD
        [ 0x73A80000, 0x73A813FF, "BJ" ],  // 115.168.0.0-115.168.19.255, BJ
        [ 0x73A81400, 0x73A814FF, "GX" ],  // 115.168.20.0-115.168.20.255, GX
        [ 0x73A81500, 0x73A81BFF, "BJ" ],  // 115.168.21.0-115.168.27.255, BJ
        [ 0x73A81C00, 0x73A81CFF, "GS" ],  // 115.168.28.0-115.168.28.255, GS
        [ 0x73A81D00, 0x73A820FF, "QH" ],  // 115.168.29.0-115.168.32.255, QH
        [ 0x73A82100, 0x73A821FF, "TJ" ],  // 115.168.33.0-115.168.33.255, TJ
        [ 0x73A82200, 0x73A822FF, "HE" ],  // 115.168.34.0-115.168.34.255, HE
        [ 0x73A82300, 0x73A823FF, "SX" ],  // 115.168.35.0-115.168.35.255, SX
        [ 0x73A82400, 0x73A824FF, "NM" ],  // 115.168.36.0-115.168.36.255, NM
        [ 0x73A82500, 0x73A825FF, "LN" ],  // 115.168.37.0-115.168.37.255, LN
        [ 0x73A82600, 0x73A826FF, "JL" ],  // 115.168.38.0-115.168.38.255, JL
        [ 0x73A82700, 0x73A827FF, "HL" ],  // 115.168.39.0-115.168.39.255, HL
        [ 0x73A82800, 0x73A828FF, "AH" ],  // 115.168.40.0-115.168.40.255, AH
        [ 0x73A82900, 0x73A829FF, "SH" ],  // 115.168.41.0-115.168.41.255, SH
        [ 0x73A82A00, 0x73A82AFF, "JS" ],  // 115.168.42.0-115.168.42.255, JS
        [ 0x73A82B00, 0x73A82BFF, "ZJ" ],  // 115.168.43.0-115.168.43.255, ZJ
        [ 0x73A82C00, 0x73A82CFF, "FJ" ],  // 115.168.44.0-115.168.44.255, FJ
        [ 0x73A82D00, 0x73A82DFF, "JX" ],  // 115.168.45.0-115.168.45.255, JX
        [ 0x73A82E00, 0x73A82EFF, "SD" ],  // 115.168.46.0-115.168.46.255, SD
        [ 0x73A82F00, 0x73A82FFF, "HA" ],  // 115.168.47.0-115.168.47.255, HA
        [ 0x73A83000, 0x73A830FF, "HB" ],  // 115.168.48.0-115.168.48.255, HB
        [ 0x73A83100, 0x73A831FF, "HN" ],  // 115.168.49.0-115.168.49.255, HN
        [ 0x73A83200, 0x73A832FF, "GD" ],  // 115.168.50.0-115.168.50.255, GD
        [ 0x73A83300, 0x73A833FF, "GX" ],  // 115.168.51.0-115.168.51.255, GX
        [ 0x73A83400, 0x73A834FF, "CQ" ],  // 115.168.52.0-115.168.52.255, CQ
        [ 0x73A83500, 0x73A835FF, "SC" ],  // 115.168.53.0-115.168.53.255, SC
        [ 0x73A83600, 0x73A836FF, "HI" ],  // 115.168.54.0-115.168.54.255, HI
        [ 0x73A83700, 0x73A837FF, "GZ" ],  // 115.168.55.0-115.168.55.255, GZ
        [ 0x73A83800, 0x73A838FF, "SN" ],  // 115.168.56.0-115.168.56.255, SN
        [ 0x73A83900, 0x73A839FF, "YN" ],  // 115.168.57.0-115.168.57.255, YN
        [ 0x73A83A00, 0x73A83AFF, "XZ" ],  // 115.168.58.0-115.168.58.255, XZ
        [ 0x73A83B00, 0x73A83BFF, "GS" ],  // 115.168.59.0-115.168.59.255, GS
        [ 0x73A83C00, 0x73A83DFF, "QH" ],  // 115.168.60.0-115.168.61.255, QH
        [ 0x73A83E00, 0x73A83EFF, "XJ" ],  // 115.168.62.0-115.168.62.255, XJ
        [ 0x73A83F00, 0x73A840FF, "JS" ],  // 115.168.63.0-115.168.64.255, JS
        [ 0x73A84100, 0x73A841FF, "TJ" ],  // 115.168.65.0-115.168.65.255, TJ
        [ 0x73A84200, 0x73A842FF, "HE" ],  // 115.168.66.0-115.168.66.255, HE
        [ 0x73A84300, 0x73A843FF, "SX" ],  // 115.168.67.0-115.168.67.255, SX
        [ 0x73A84400, 0x73A844FF, "NM" ],  // 115.168.68.0-115.168.68.255, NM
        [ 0x73A84500, 0x73A845FF, "LN" ],  // 115.168.69.0-115.168.69.255, LN
        [ 0x73A84600, 0x73A846FF, "JL" ],  // 115.168.70.0-115.168.70.255, JL
        [ 0x73A84700, 0x73A847FF, "HL" ],  // 115.168.71.0-115.168.71.255, HL
        [ 0x73A84800, 0x73A848FF, "AH" ],  // 115.168.72.0-115.168.72.255, AH
        [ 0x73A84900, 0x73A849FF, "SH" ],  // 115.168.73.0-115.168.73.255, SH
        [ 0x73A84A00, 0x73A84AFF, "JS" ],  // 115.168.74.0-115.168.74.255, JS
        [ 0x73A84B00, 0x73A84BFF, "ZJ" ],  // 115.168.75.0-115.168.75.255, ZJ
        [ 0x73A84C00, 0x73A84CFF, "FJ" ],  // 115.168.76.0-115.168.76.255, FJ
        [ 0x73A84D00, 0x73A84DFF, "JX" ],  // 115.168.77.0-115.168.77.255, JX
        [ 0x73A84E00, 0x73A84EFF, "SD" ],  // 115.168.78.0-115.168.78.255, SD
        [ 0x73A84F00, 0x73A84FFF, "HA" ],  // 115.168.79.0-115.168.79.255, HA
        [ 0x73A85000, 0x73A850FF, "HB" ],  // 115.168.80.0-115.168.80.255, HB
        [ 0x73A85100, 0x73A851FF, "HN" ],  // 115.168.81.0-115.168.81.255, HN
        [ 0x73A85200, 0x73A852FF, "GD" ],  // 115.168.82.0-115.168.82.255, GD
        [ 0x73A85300, 0x73A853FF, "GX" ],  // 115.168.83.0-115.168.83.255, GX
        [ 0x73A85400, 0x73A854FF, "CQ" ],  // 115.168.84.0-115.168.84.255, CQ
        [ 0x73A85500, 0x73A855FF, "SC" ],  // 115.168.85.0-115.168.85.255, SC
        [ 0x73A85600, 0x73A856FF, "HI" ],  // 115.168.86.0-115.168.86.255, HI
        [ 0x73A85700, 0x73A857FF, "GZ" ],  // 115.168.87.0-115.168.87.255, GZ
        [ 0x73A85800, 0x73A858FF, "SN" ],  // 115.168.88.0-115.168.88.255, SN
        [ 0x73A85900, 0x73A859FF, "YN" ],  // 115.168.89.0-115.168.89.255, YN
        [ 0x73A85A00, 0x73A85AFF, "XZ" ],  // 115.168.90.0-115.168.90.255, XZ
        [ 0x73A85B00, 0x73A85BFF, "GS" ],  // 115.168.91.0-115.168.91.255, GS
        [ 0x73A85C00, 0x73A85CFF, "QH" ],  // 115.168.92.0-115.168.92.255, QH
        [ 0x73A85D00, 0x73A85DFF, "NX" ],  // 115.168.93.0-115.168.93.255, NX
        [ 0x73A85E00, 0x73A85EFF, "XJ" ],  // 115.168.94.0-115.168.94.255, XJ
        [ 0x73A85F00, 0x73A85FFF, "CQ" ],  // 115.168.95.0-115.168.95.255, CQ
        [ 0x73A86000, 0x73A8C6FF, "BJ" ],  // 115.168.96.0-115.168.198.255, BJ
        [ 0x73A8C700, 0x73A8C7FF, "SC" ],  // 115.168.199.0-115.168.199.255, SC
        [ 0x73A8C800, 0x73A8EFFF, "BJ" ],  // 115.168.200.0-115.168.239.255, BJ
        [ 0x73A8F000, 0x73A8F0FF, "SC" ],  // 115.168.240.0-115.168.240.255, SC
        [ 0x73A8F100, 0x73A8FDFF, "BJ" ],  // 115.168.241.0-115.168.253.255, BJ
        [ 0x73A8FE00, 0x73A8FEFF, "GD" ],  // 115.168.254.0-115.168.254.255, GD
        [ 0x73A8FF00, 0x73A8FFFF, "BJ" ],  // 115.168.255.0-115.168.255.255, BJ
        [ 0x73A90000, 0x73A901FF, "GD" ],  // 115.169.0.0-115.169.1.255, GD
        [ 0x73A90200, 0x73A902FF, "BJ" ],  // 115.169.2.0-115.169.2.255, BJ
        [ 0x73A90300, 0x73A906FF, "GD" ],  // 115.169.3.0-115.169.6.255, GD
        [ 0x73A90700, 0x73A908FF, "BJ" ],  // 115.169.7.0-115.169.8.255, BJ
        [ 0x73A90900, 0x73A909FF, "GD" ],  // 115.169.9.0-115.169.9.255, GD
        [ 0x73A90A00, 0x73A90FFF, "BJ" ],  // 115.169.10.0-115.169.15.255, BJ
        [ 0x73A91000, 0x73A911FF, "GD" ],  // 115.169.16.0-115.169.17.255, GD
        [ 0x73A91200, 0x73A912FF, "CQ" ],  // 115.169.18.0-115.169.18.255, CQ
        [ 0x73A91300, 0x73A913FF, "GD" ],  // 115.169.19.0-115.169.19.255, GD
        [ 0x73A91400, 0x73A914FF, "FJ" ],  // 115.169.20.0-115.169.20.255, FJ
        [ 0x73A91500, 0x73A916FF, "JS" ],  // 115.169.21.0-115.169.22.255, JS
        [ 0x73A91700, 0x73A91EFF, "BJ" ],  // 115.169.23.0-115.169.30.255, BJ
        [ 0x73A91F00, 0x73A91FFF, "HE" ],  // 115.169.31.0-115.169.31.255, HE
        [ 0x73A92000, 0x73A927FF, "GD" ],  // 115.169.32.0-115.169.39.255, GD
        [ 0x73A92800, 0x73A928FF, "BJ" ],  // 115.169.40.0-115.169.40.255, BJ
        [ 0x73A92900, 0x73A92AFF, "GD" ],  // 115.169.41.0-115.169.42.255, GD
        [ 0x73A92B00, 0x73A92DFF, "BJ" ],  // 115.169.43.0-115.169.45.255, BJ
        [ 0x73A92E00, 0x73A95EFF, "HE" ],  // 115.169.46.0-115.169.94.255, HE
        [ 0x73A95F00, 0x73A95FFF, "HB" ],  // 115.169.95.0-115.169.95.255, HB
        [ 0x73A96000, 0x73A976FF, "HE" ],  // 115.169.96.0-115.169.118.255, HE
        [ 0x73A97700, 0x73A977FF, "JS" ],  // 115.169.119.0-115.169.119.255, JS
        [ 0x73A97800, 0x73A9C1FF, "HE" ],  // 115.169.120.0-115.169.193.255, HE
        [ 0x73A9C200, 0x73A9C2FF, "GD" ],  // 115.169.194.0-115.169.194.255, GD
        [ 0x73A9C300, 0x73A9CFFF, "HE" ],  // 115.169.195.0-115.169.207.255, HE
        [ 0x73A9D000, 0x73A9F3FF, "XZ" ],  // 115.169.208.0-115.169.243.255, XZ
        [ 0x73A9F400, 0x73A9F4FF, "BJ" ],  // 115.169.244.0-115.169.244.255, BJ
        [ 0x73A9F500, 0x73A9FCFF, "XZ" ],  // 115.169.245.0-115.169.252.255, XZ
        [ 0x73A9FD00, 0x73A9FDFF, "GD" ],  // 115.169.253.0-115.169.253.255, GD
        [ 0x73A9FE00, 0x73AA00FF, "BJ" ],  // 115.169.254.0-115.170.0.255, BJ
        [ 0x73AA0100, 0x73AA05FF, "GD" ],  // 115.170.1.0-115.170.5.255, GD
        [ 0x73AA0600, 0x73AA2CFF, "BJ" ],  // 115.170.6.0-115.170.44.255, BJ
        [ 0x73AA2D00, 0x73AA2DFF, "JS" ],  // 115.170.45.0-115.170.45.255, JS
        [ 0x73AA2E00, 0x73AA74FF, "BJ" ],  // 115.170.46.0-115.170.116.255, BJ
        [ 0x73AA7500, 0x73AA76FF, "JS" ],  // 115.170.117.0-115.170.118.255, JS
        [ 0x73AA7700, 0x73AA83FF, "BJ" ],  // 115.170.119.0-115.170.131.255, BJ
        [ 0x73AA8400, 0x73AA85FF, "JS" ],  // 115.170.132.0-115.170.133.255, JS
        [ 0x73AA8600, 0x73AAA4FF, "BJ" ],  // 115.170.134.0-115.170.164.255, BJ
        [ 0x73AAA500, 0x73AAA6FF, "GD" ],  // 115.170.165.0-115.170.166.255, GD
        [ 0x73AAA700, 0x73AAA8FF, "BJ" ],  // 115.170.167.0-115.170.168.255, BJ
        [ 0x73AAA900, 0x73AAA9FF, "GD" ],  // 115.170.169.0-115.170.169.255, GD
        [ 0x73AAAA00, 0x73AAD7FF, "BJ" ],  // 115.170.170.0-115.170.215.255, BJ
        [ 0x73AAD800, 0x73AAD9FF, "SC" ],  // 115.170.216.0-115.170.217.255, SC
        [ 0x73AADA00, 0x73AADBFF, "JS" ],  // 115.170.218.0-115.170.219.255, JS
        [ 0x73AADC00, 0x73ABFFFF, "BJ" ],  // 115.170.220.0-115.171.255.255, BJ
        [ 0x73AC0000, 0x73AC1FFF, "GD" ],  // 115.172.0.0-115.172.31.255, GD
        [ 0x73AC2000, 0x73AC5FFF, "SH" ],  // 115.172.32.0-115.172.95.255, SH
        [ 0x73AC6000, 0x73AC7FFF, "GD" ],  // 115.172.96.0-115.172.127.255, GD
        [ 0x73AC8000, 0x73ACB7FF, "FJ" ],  // 115.172.128.0-115.172.183.255, FJ
        [ 0x73ACB800, 0x73ACBFFF, "GD" ],  // 115.172.184.0-115.172.191.255, GD
        [ 0x73ACC000, 0x73ACFFFF, "SH" ],  // 115.172.192.0-115.172.255.255, SH
        [ 0x73AD0000, 0x73AD1BFF, "JS" ],  // 115.173.0.0-115.173.27.255, JS
        [ 0x73AD1C00, 0x73AD1CFF, "SX" ],  // 115.173.28.0-115.173.28.255, SX
        [ 0x73AD1D00, 0x73AD1FFF, "JS" ],  // 115.173.29.0-115.173.31.255, JS
        [ 0x73AD2000, 0x73AD3FFF, "GD" ],  // 115.173.32.0-115.173.63.255, GD
        [ 0x73AD4000, 0x73AD7FFF, "CQ" ],  // 115.173.64.0-115.173.127.255, CQ
        [ 0x73AD8000, 0x73AD8CFF, "SH" ],  // 115.173.128.0-115.173.140.255, SH
        [ 0x73AD8D00, 0x73AD8DFF, "ZJ" ],  // 115.173.141.0-115.173.141.255, ZJ
        [ 0x73AD8E00, 0x73AE3FFF, "SH" ],  // 115.173.142.0-115.174.63.255, SH
        [ 0x73AE4000, 0x73AE5FFF, "GD" ],  // 115.174.64.0-115.174.95.255, GD
        [ 0x73AE6000, 0x73AEFFFF, "SH" ],  // 115.174.96.0-115.174.255.255, SH
        [ 0x73AF0000, 0x73AF7FFF, "HB" ],  // 115.175.0.0-115.175.127.255, HB
        [ 0x73AF8000, 0x73AFFFFF, "GD" ],  // 115.175.128.0-115.175.255.255, GD
        [ 0x73B40000, 0x73B4FFFF, "BJ" ],  // 115.180.0.0-115.180.255.255, BJ
        [ 0x73B50000, 0x73B51FFF, "HE" ],  // 115.181.0.0-115.181.31.255, HE
        [ 0x73B52000, 0x73B521FF, "SX" ],  // 115.181.32.0-115.181.33.255, SX
        [ 0x73B52200, 0x73B527FF, "BJ" ],  // 115.181.34.0-115.181.39.255, BJ
        [ 0x73B52800, 0x73B52FFF, "SX" ],  // 115.181.40.0-115.181.47.255, SX
        [ 0x73B53000, 0x73B537FF, "JS" ],  // 115.181.48.0-115.181.55.255, JS
        [ 0x73B53800, 0x73B53FFF, "BJ" ],  // 115.181.56.0-115.181.63.255, BJ
        [ 0x73B54000, 0x73B54FFF, "GZ" ],  // 115.181.64.0-115.181.79.255, GZ
        [ 0x73B55000, 0x73B56FFF, "GD" ],  // 115.181.80.0-115.181.111.255, GD
        [ 0x73B57000, 0x73B57FFF, "BJ" ],  // 115.181.112.0-115.181.127.255, BJ
        [ 0x73B58000, 0x73B58FFF, "SX" ],  // 115.181.128.0-115.181.143.255, SX
        [ 0x73B59000, 0x73B590FF, "GD" ],  // 115.181.144.0-115.181.144.255, GD
        [ 0x73B59100, 0x73B591FF, "SD" ],  // 115.181.145.0-115.181.145.255, SD
        [ 0x73B59200, 0x73B592FF, "GD" ],  // 115.181.146.0-115.181.146.255, GD
        [ 0x73B59300, 0x73B593FF, "SD" ],  // 115.181.147.0-115.181.147.255, SD
        [ 0x73B59400, 0x73B594FF, "GD" ],  // 115.181.148.0-115.181.148.255, GD
        [ 0x73B59500, 0x73B597FF, "SD" ],  // 115.181.149.0-115.181.151.255, SD
        [ 0x73B59800, 0x73B598FF, "BJ" ],  // 115.181.152.0-115.181.152.255, BJ
        [ 0x73B59900, 0x73B59AFF, "FJ" ],  // 115.181.153.0-115.181.154.255, FJ
        [ 0x73B59B00, 0x73B59DFF, "BJ" ],  // 115.181.155.0-115.181.157.255, BJ
        [ 0x73B59E00, 0x73B5BFFF, "HE" ],  // 115.181.158.0-115.181.191.255, HE
        [ 0x73B5C000, 0x73B5CFFF, "GD" ],  // 115.181.192.0-115.181.207.255, GD
        [ 0x73B5D000, 0x73B5D3FF, "GZ" ],  // 115.181.208.0-115.181.211.255, GZ
        [ 0x73B5D400, 0x73B5E7FF, "GD" ],  // 115.181.212.0-115.181.231.255, GD
        [ 0x73B5E800, 0x73B5EBFF, "SC" ],  // 115.181.232.0-115.181.235.255, SC
        [ 0x73B5EC00, 0x73B5EFFF, "JS" ],  // 115.181.236.0-115.181.239.255, JS
        [ 0x73B5F000, 0x73B5FFFF, "GD" ],  // 115.181.240.0-115.181.255.255, GD
        [ 0x73B60000, 0x73B7FFFF, "BJ" ],  // 115.182.0.0-115.183.255.255, BJ
        [ 0x73BB0000, 0x73BB03FF, "LN" ],  // 115.187.0.0-115.187.3.255, LN
        [ 0x73BB0400, 0x73BB07FF, "JS" ],  // 115.187.4.0-115.187.7.255, JS
        [ 0x73BB0800, 0x73BB0BFF, "SC" ],  // 115.187.8.0-115.187.11.255, SC
        [ 0x73BB0C00, 0x73BB0FFF, "SD" ],  // 115.187.12.0-115.187.15.255, SD
        [ 0x73BE0000, 0x73BFFFFF, "HB" ],  // 115.190.0.0-115.191.255.255, HB
        [ 0x73C00000, 0x73EFFFFF, "ZJ" ],  // 115.192.0.0-115.239.255.255, ZJ
        [ 0x74000800, 0x74000FFF, "GD" ],  // 116.0.8.0-116.0.15.255, GD
        [ 0x74001800, 0x74001FFF, "GD" ],  // 116.0.24.0-116.0.31.255, GD
        [ 0x74010000, 0x7401FFFF, "GX" ],  // 116.1.0.0-116.1.255.255, GX
        [ 0x74020000, 0x7403FFFF, "LN" ],  // 116.2.0.0-116.3.255.255, LN
        [ 0x74040000, 0x7407FFFF, "GD" ],  // 116.4.0.0-116.7.255.255, GD
        [ 0x74080000, 0x740869FF, "GX" ],  // 116.8.0.0-116.8.105.255, GX
        [ 0x74086A00, 0x74086AFF, "HN" ],  // 116.8.106.0-116.8.106.255, HN
        [ 0x74086B00, 0x740BFFFF, "GX" ],  // 116.8.107.0-116.11.255.255, GX
        [ 0x740D0000, 0x740D3FFF, "HI" ],  // 116.13.0.0-116.13.63.255, HI
        [ 0x740D4000, 0x740DBFFF, "GD" ],  // 116.13.64.0-116.13.191.255, GD
        [ 0x740DC000, 0x740DE3FF, "GX" ],  // 116.13.192.0-116.13.227.255, GX
        [ 0x740DE400, 0x740DFFFF, "GD" ],  // 116.13.228.0-116.13.255.255, GD
        [ 0x74100000, 0x741FFFFF, "GD" ],  // 116.16.0.0-116.31.255.255, GD
        [ 0x74320000, 0x74320FFF, "GD" ],  // 116.50.0.0-116.50.15.255, GD
        [ 0x74340000, 0x7437FFFF, "YN" ],  // 116.52.0.0-116.55.255.255, YN
        [ 0x74380000, 0x7439FFFF, "GD" ],  // 116.56.0.0-116.57.255.255, GD
        [ 0x743A8000, 0x743A8FFF, "SH" ],  // 116.58.128.0-116.58.143.255, SH
        [ 0x743AD000, 0x743ADFFF, "BJ" ],  // 116.58.208.0-116.58.223.255, BJ
        [ 0x743C0000, 0x743C73FF, "GD" ],  // 116.60.0.0-116.60.115.255, GD
        [ 0x743C7400, 0x743C77FF, "BJ" ],  // 116.60.116.0-116.60.119.255, BJ
        [ 0x743C7800, 0x743C7BFF, "GD" ],  // 116.60.120.0-116.60.123.255, GD
        [ 0x743C7C00, 0x743C7FFF, "BJ" ],  // 116.60.124.0-116.60.127.255, BJ
        [ 0x743C8000, 0x743CA7FF, "GD" ],  // 116.60.128.0-116.60.167.255, GD
        [ 0x743CA800, 0x743CBFFF, "BJ" ],  // 116.60.168.0-116.60.191.255, BJ
        [ 0x743CC000, 0x743CFFFF, "GD" ],  // 116.60.192.0-116.60.255.255, GD
        [ 0x743D0000, 0x743DFFFF, "BJ" ],  // 116.61.0.0-116.61.255.255, BJ
        [ 0x743E0000, 0x743EFFFF, "ZJ" ],  // 116.62.0.0-116.62.255.255, ZJ
        [ 0x743F0000, 0x743F1FFF, "BJ" ],  // 116.63.0.0-116.63.31.255, BJ
        [ 0x743F2000, 0x743F3FFF, "SH" ],  // 116.63.32.0-116.63.63.255, SH
        [ 0x743F4000, 0x743F5FFF, "GD" ],  // 116.63.64.0-116.63.95.255, GD
        [ 0x743F6000, 0x743F7FFF, "SH" ],  // 116.63.96.0-116.63.127.255, SH
        [ 0x743F8000, 0x743FBFFF, "GZ" ],  // 116.63.128.0-116.63.191.255, GZ
        [ 0x743FC000, 0x743FFFFF, "SH" ],  // 116.63.192.0-116.63.255.255, SH
        [ 0x74420000, 0x74427FFF, "SH" ],  // 116.66.0.0-116.66.127.255, SH
        [ 0x74448800, 0x74448BFF, "GD" ],  // 116.68.136.0-116.68.139.255, GD
        [ 0x74448C00, 0x74448FFF, "HB" ],  // 116.68.140.0-116.68.143.255, HB
        [ 0x7444B000, 0x7444B3FF, "HB" ],  // 116.68.176.0-116.68.179.255, HB
        [ 0x7444B400, 0x7444B7FF, "FJ" ],  // 116.68.180.0-116.68.183.255, FJ
        [ 0x74450000, 0x74463FFF, "BJ" ],  // 116.69.0.0-116.70.63.255, BJ
        [ 0x74464000, 0x74467FFF, "ZJ" ],  // 116.70.64.0-116.70.127.255, ZJ
        [ 0x744C0000, 0x744DFFFF, "GD" ],  // 116.76.0.0-116.77.255.255, GD
        [ 0x744E0000, 0x744EFFFF, "TJ" ],  // 116.78.0.0-116.78.255.255, TJ
        [ 0x744F0000, 0x744FFFFF, "BJ" ],  // 116.79.0.0-116.79.255.255, BJ
        [ 0x74550000, 0x7455FFFF, "GD" ],  // 116.85.0.0-116.85.255.255, GD
        [ 0x74599000, 0x74599FFF, "BJ" ],  // 116.89.144.0-116.89.159.255, BJ
        [ 0x7459F300, 0x7459F3FF, "HA" ],  // 116.89.243.0-116.89.243.255, HA
        [ 0x745A5000, 0x745A5FFF, "BJ" ],  // 116.90.80.0-116.90.95.255, BJ
        [ 0x745AB800, 0x745ABFFF, "BJ" ],  // 116.90.184.0-116.90.191.255, BJ
        [ 0x745F0000, 0x745FFFFF, "NM" ],  // 116.95.0.0-116.95.255.255, NM
        [ 0x74700000, 0x747473FF, "NM" ],  // 116.112.0.0-116.116.115.255, NM
        [ 0x74747400, 0x747474FF, "GD" ],  // 116.116.116.0-116.116.116.255, GD
        [ 0x74747500, 0x7475FFFF, "NM" ],  // 116.116.117.0-116.117.255.255, NM
        [ 0x74800000, 0x74807FFF, "BJ" ],  // 116.128.0.0-116.128.127.255, BJ
        [ 0x74808000, 0x7480BFFF, "SH" ],  // 116.128.128.0-116.128.191.255, SH
        [ 0x7480C000, 0x7480C7FF, "BJ" ],  // 116.128.192.0-116.128.199.255, BJ
        [ 0x7480C800, 0x7480DFFF, "SH" ],  // 116.128.200.0-116.128.223.255, SH
        [ 0x7480E000, 0x7480FFFF, "HN" ],  // 116.128.224.0-116.128.255.255, HN
        [ 0x74810000, 0x7481DFFF, "YN" ],  // 116.129.0.0-116.129.223.255, YN
        [ 0x7481E000, 0x7481E0FF, "NX" ],  // 116.129.224.0-116.129.224.255, NX
        [ 0x7481E100, 0x7481E1FF, "LN" ],  // 116.129.225.0-116.129.225.255, LN
        [ 0x7481E200, 0x7481F3FF, "NX" ],  // 116.129.226.0-116.129.243.255, NX
        [ 0x7481F400, 0x7481FEFF, "HN" ],  // 116.129.244.0-116.129.254.255, HN
        [ 0x7481FF00, 0x7481FFFF, "LN" ],  // 116.129.255.0-116.129.255.255, LN
        [ 0x74820000, 0x7482FFFF, "TJ" ],  // 116.130.0.0-116.130.255.255, TJ
        [ 0x74830000, 0x7485FFFF, "HE" ],  // 116.131.0.0-116.133.255.255, HE
        [ 0x74860000, 0x7486FFFF, "LN" ],  // 116.134.0.0-116.134.255.255, LN
        [ 0x74870000, 0x74873FFF, "SX" ],  // 116.135.0.0-116.135.63.255, SX
        [ 0x74874000, 0x74888AFF, "NM" ],  // 116.135.64.0-116.136.138.255, NM
        [ 0x74888B00, 0x74888CFF, "LN" ],  // 116.136.139.0-116.136.140.255, LN
        [ 0x74888D00, 0x748893FF, "NM" ],  // 116.136.141.0-116.136.147.255, NM
        [ 0x74889400, 0x748894FF, "LN" ],  // 116.136.148.0-116.136.148.255, LN
        [ 0x74889500, 0x7488FFFF, "NM" ],  // 116.136.149.0-116.136.255.255, NM
        [ 0x74890000, 0x7489FFFF, "BJ" ],  // 116.137.0.0-116.137.255.255, BJ
        [ 0x748A0000, 0x748CBFFF, "LN" ],  // 116.138.0.0-116.140.191.255, LN
        [ 0x748CC000, 0x748D02FF, "JL" ],  // 116.140.192.0-116.141.2.255, JL
        [ 0x748D0300, 0x748DFFFF, "LN" ],  // 116.141.3.0-116.141.255.255, LN
        [ 0x748E0000, 0x748EBFFF, "JL" ],  // 116.142.0.0-116.142.191.255, JL
        [ 0x748EC000, 0x7492FFFF, "LN" ],  // 116.142.192.0-116.146.255.255, LN
        [ 0x74930000, 0x7493FFFF, "JS" ],  // 116.147.0.0-116.147.255.255, JS
        [ 0x74940000, 0x7494FFFF, "ZJ" ],  // 116.148.0.0-116.148.255.255, ZJ
        [ 0x74950000, 0x7495FFFF, "AH" ],  // 116.149.0.0-116.149.255.255, AH
        [ 0x74960000, 0x7498FFFF, "SD" ],  // 116.150.0.0-116.152.255.255, SD
        [ 0x74990000, 0x7499FFFF, "JX" ],  // 116.153.0.0-116.153.255.255, JX
        [ 0x749A0000, 0x749CFFFF, "SD" ],  // 116.154.0.0-116.156.255.255, SD
        [ 0x749D0000, 0x749FFFFF, "HA" ],  // 116.157.0.0-116.159.255.255, HA
        [ 0x74A00000, 0x74A0FFFF, "LN" ],  // 116.160.0.0-116.160.255.255, LN
        [ 0x74A10000, 0x74A33FFF, "HN" ],  // 116.161.0.0-116.163.63.255, HN
        [ 0x74A34000, 0x74A3FFFF, "LN" ],  // 116.163.64.0-116.163.255.255, LN
        [ 0x74A40000, 0x74A6FFFF, "GX" ],  // 116.164.0.0-116.166.255.255, GX
        [ 0x74A70000, 0x74A7FFFF, "HI" ],  // 116.167.0.0-116.167.255.255, HI
        [ 0x74A80000, 0x74A8FFFF, "CQ" ],  // 116.168.0.0-116.168.255.255, CQ
        [ 0x74A90000, 0x74A943FF, "SC" ],  // 116.169.0.0-116.169.67.255, SC
        [ 0x74A94400, 0x74A945FF, "LN" ],  // 116.169.68.0-116.169.69.255, LN
        [ 0x74A94600, 0x74A947FF, "SC" ],  // 116.169.70.0-116.169.71.255, SC
        [ 0x74A94800, 0x74A94CFF, "LN" ],  // 116.169.72.0-116.169.76.255, LN
        [ 0x74A94D00, 0x74A95BFF, "SC" ],  // 116.169.77.0-116.169.91.255, SC
        [ 0x74A95C00, 0x74A95FFF, "LN" ],  // 116.169.92.0-116.169.95.255, LN
        [ 0x74A96000, 0x74A97FFF, "SC" ],  // 116.169.96.0-116.169.127.255, SC
        [ 0x74A98000, 0x74A9FFFF, "LN" ],  // 116.169.128.0-116.169.255.255, LN
        [ 0x74AA0000, 0x74AAFFFF, "BJ" ],  // 116.170.0.0-116.170.255.255, BJ
        [ 0x74AB0000, 0x74ABFFFF, "GZ" ],  // 116.171.0.0-116.171.255.255, GZ
        [ 0x74AC0000, 0x74AC7FFF, "NX" ],  // 116.172.0.0-116.172.127.255, NX
        [ 0x74AC8000, 0x74ACFFFF, "XZ" ],  // 116.172.128.0-116.172.255.255, XZ
        [ 0x74AD0000, 0x74AFFFFF, "SN" ],  // 116.173.0.0-116.175.255.255, SN
        [ 0x74B00000, 0x74B0BFFF, "GS" ],  // 116.176.0.0-116.176.191.255, GS
        [ 0x74B0C000, 0x74B0FFFF, "LN" ],  // 116.176.192.0-116.176.255.255, LN
        [ 0x74B10000, 0x74B1FFFF, "QH" ],  // 116.177.0.0-116.177.255.255, QH
        [ 0x74B20000, 0x74B2FFFF, "XJ" ],  // 116.178.0.0-116.178.255.255, XJ
        [ 0x74B30000, 0x74B3FFFF, "SX" ],  // 116.179.0.0-116.179.255.255, SX
        [ 0x74B40000, 0x74B5FFFF, "HE" ],  // 116.180.0.0-116.181.255.255, HE
        [ 0x74B60000, 0x74BFFFFF, "HL" ],  // 116.182.0.0-116.191.255.255, HL
        [ 0x74C00000, 0x74C0FFFF, "SH" ],  // 116.192.0.0-116.192.255.255, SH
        [ 0x74C11000, 0x74C11FFF, "BJ" ],  // 116.193.16.0-116.193.31.255, BJ
        [ 0x74C12000, 0x74C13FFF, "SH" ],  // 116.193.32.0-116.193.63.255, SH
        [ 0x74C1A400, 0x74C1A7FF, "BJ" ],  // 116.193.164.0-116.193.167.255, BJ
        [ 0x74C1B000, 0x74C1B7FF, "GD" ],  // 116.193.176.0-116.193.183.255, GD
        [ 0x74C20000, 0x74C3FFFF, "GD" ],  // 116.194.0.0-116.195.255.255, GD
        [ 0x74C40000, 0x74C407FF, "LN" ],  // 116.196.0.0-116.196.7.255, LN
        [ 0x74C40800, 0x74C40FFF, "BJ" ],  // 116.196.8.0-116.196.15.255, BJ
        [ 0x74C41000, 0x74C43FFF, "HA" ],  // 116.196.16.0-116.196.63.255, HA
        [ 0x74C44000, 0x74C47FFF, "BJ" ],  // 116.196.64.0-116.196.127.255, BJ
        [ 0x74C48000, 0x74C4AFFF, "ZJ" ],  // 116.196.128.0-116.196.175.255, ZJ
        [ 0x74C4B000, 0x74C4FFFF, "BJ" ],  // 116.196.176.0-116.196.255.255, BJ
        [ 0x74C5A000, 0x74C5A7FF, "GD" ],  // 116.197.160.0-116.197.167.255, GD
        [ 0x74C60000, 0x74C63FFF, "BJ" ],  // 116.198.0.0-116.198.63.255, BJ
        [ 0x74C64000, 0x74C68FFF, "GD" ],  // 116.198.64.0-116.198.143.255, GD
        [ 0x74C69000, 0x74C6B7FF, "SH" ],  // 116.198.144.0-116.198.183.255, SH
        [ 0x74C6B800, 0x74C6BFFF, "GD" ],  // 116.198.184.0-116.198.191.255, GD
        [ 0x74C6C000, 0x74C6FFFF, "JS" ],  // 116.198.192.0-116.198.255.255, JS
        [ 0x74C70000, 0x74C77FFF, "GD" ],  // 116.199.0.0-116.199.127.255, GD
        [ 0x74C78000, 0x74C78AFF, "HN" ],  // 116.199.128.0-116.199.138.255, HN
        [ 0x74C78B00, 0x74C79FFF, "GD" ],  // 116.199.139.0-116.199.159.255, GD
        [ 0x74CC0000, 0x74CC07BF, "GD" ],  // 116.204.0.0-116.204.7.191, GD
        [ 0x74CC07C0, 0x74CC07FF, "CQ" ],  // 116.204.7.192-116.204.7.255, CQ
        [ 0x74CC0800, 0x74CC0AFF, "GD" ],  // 116.204.8.0-116.204.10.255, GD
        [ 0x74CC0B00, 0x74CC0BFF, "CQ" ],  // 116.204.11.0-116.204.11.255, CQ
        [ 0x74CC0C00, 0x74CC3FFF, "GD" ],  // 116.204.12.0-116.204.63.255, GD
        [ 0x74CC4000, 0x74CC7FFF, "BJ" ],  // 116.204.64.0-116.204.127.255, BJ
        [ 0x74CC8500, 0x74CC85FF, "BJ" ],  // 116.204.133.0-116.204.133.255, BJ
        [ 0x74CC8700, 0x74CC87FF, "BJ" ],  // 116.204.135.0-116.204.135.255, BJ
        [ 0x74CD0000, 0x74CD0AFF, "GD" ],  // 116.205.0.0-116.205.10.255, GD
        [ 0x74CD0B00, 0x74CD0EFF, "BJ" ],  // 116.205.11.0-116.205.14.255, BJ
        [ 0x74CD0F00, 0x74CD17FF, "GD" ],  // 116.205.15.0-116.205.23.255, GD
        [ 0x74CD1800, 0x74CD1BFF, "CQ" ],  // 116.205.24.0-116.205.27.255, CQ
        [ 0x74CD1C00, 0x74CDFFFF, "GD" ],  // 116.205.28.0-116.205.255.255, GD
        [ 0x74CF0000, 0x74D3FFFF, "HB" ],  // 116.207.0.0-116.211.255.255, HB
        [ 0x74D4A000, 0x74D4AFFF, "HL" ],  // 116.212.160.0-116.212.175.255, HL
        [ 0x74D51500, 0x74D515FF, "BJ" ],  // 116.213.21.0-116.213.21.255, BJ
        [ 0x74D52C00, 0x74D52FFF, "BJ" ],  // 116.213.44.0-116.213.47.255, BJ
        [ 0x74D54000, 0x74D5EFFF, "BJ" ],  // 116.213.64.0-116.213.239.255, BJ
        [ 0x74D5F000, 0x74D5FFFF, "GD" ],  // 116.213.240.0-116.213.255.255, GD
        [ 0x74D62000, 0x74D63FFF, "SH" ],  // 116.214.32.0-116.214.63.255, SH
        [ 0x74D64000, 0x74D64FFF, "JS" ],  // 116.214.64.0-116.214.79.255, JS
        [ 0x74D66E00, 0x74D66FFF, "SH" ],  // 116.214.110.0-116.214.111.255, SH
        [ 0x74D68000, 0x74D680FF, "SH" ],  // 116.214.128.0-116.214.128.255, SH
        [ 0x74D68100, 0x74D6FFFF, "GD" ],  // 116.214.129.0-116.214.255.255, GD
        [ 0x74D70000, 0x74D74FFF, "BJ" ],  // 116.215.0.0-116.215.79.255, BJ
        [ 0x74D75000, 0x74D7FFFF, "SH" ],  // 116.215.80.0-116.215.255.255, SH
        [ 0x74D80000, 0x74D8FFFF, "BJ" ],  // 116.216.0.0-116.216.255.255, BJ
        [ 0x74D90000, 0x74D9FFFF, "LN" ],  // 116.217.0.0-116.217.255.255, LN
        [ 0x74DA0000, 0x74DA07FF, "BJ" ],  // 116.218.0.0-116.218.7.255, BJ
        [ 0x74DA0800, 0x74DA08FF, "CQ" ],  // 116.218.8.0-116.218.8.255, CQ
        [ 0x74DA0900, 0x74DAFFFF, "BJ" ],  // 116.218.9.0-116.218.255.255, BJ
        [ 0x74DB0000, 0x74DBFFFF, "LN" ],  // 116.219.0.0-116.219.255.255, LN
        [ 0x74E00000, 0x74EFFFFF, "SH" ],  // 116.224.0.0-116.239.255.255, SH
        [ 0x74F20000, 0x74F5FFFF, "BJ" ],  // 116.242.0.0-116.245.255.255, BJ
        [ 0x74F60000, 0x74F7FFFF, "SH" ],  // 116.246.0.0-116.247.255.255, SH
        [ 0x74F80000, 0x74F9FFFF, "YN" ],  // 116.248.0.0-116.249.255.255, YN
        [ 0x74FB4BFD, 0x74FB4BFD, "ZJ" ],  // 116.251.75.253-116.251.75.253, ZJ
        [ 0x74FB4BFF, 0x74FB4FFF, "ZJ" ],  // 116.251.75.255-116.251.79.255, ZJ
        [ 0x74FB5000, 0x74FB53FF, "SH" ],  // 116.251.80.0-116.251.83.255, SH
        [ 0x74FB5400, 0x74FB5FFF, "ZJ" ],  // 116.251.84.0-116.251.95.255, ZJ
        [ 0x74FB6600, 0x74FB6BFF, "ZJ" ],  // 116.251.102.0-116.251.107.255, ZJ
        [ 0x74FB6C00, 0x74FB711F, "SH" ],  // 116.251.108.0-116.251.113.31, SH
        [ 0x74FB7120, 0x74FB7FFF, "ZJ" ],  // 116.251.113.32-116.251.127.255, ZJ
        [ 0x74FC0000, 0x74FDD33E, "GX" ],  // 116.252.0.0-116.253.211.62, GX
        [ 0x74FDD33F, 0x74FDD33F, "HB" ],  // 116.253.211.63-116.253.211.63, HB
        [ 0x74FDD340, 0x74FDD341, "GX" ],  // 116.253.211.64-116.253.211.65, GX
        [ 0x74FDD342, 0x74FDD390, "GD" ],  // 116.253.211.66-116.253.211.144, GD
        [ 0x74FDD391, 0x74FDD3CE, "GX" ],  // 116.253.211.145-116.253.211.206, GX
        [ 0x74FDD3CF, 0x74FDD3CF, "HB" ],  // 116.253.211.207-116.253.211.207, HB
        [ 0x74FDD3D0, 0x74FDD3F0, "GX" ],  // 116.253.211.208-116.253.211.240, GX
        [ 0x74FDD3F1, 0x74FDD3F1, "GD" ],  // 116.253.211.241-116.253.211.241, GD
        [ 0x74FDD3F2, 0x74FDD4A9, "GX" ],  // 116.253.211.242-116.253.212.169, GX
        [ 0x74FDD4AA, 0x74FDD4FF, "HN" ],  // 116.253.212.170-116.253.212.255, HN
        [ 0x74FDD500, 0x74FDFFFF, "GX" ],  // 116.253.213.0-116.253.255.255, GX
        [ 0x74FE6800, 0x74FE6BFF, "GX" ],  // 116.254.104.0-116.254.107.255, GX
        [ 0x74FE6C00, 0x74FE6FFF, "HI" ],  // 116.254.108.0-116.254.111.255, HI
        [ 0x74FE8000, 0x74FEFFFF, "GD" ],  // 116.254.128.0-116.254.255.255, GD
        [ 0x74FF8000, 0x74FFFFFF, "HA" ],  // 116.255.128.0-116.255.255.255, HA
        [ 0x75080000, 0x750FFFFF, "TJ" ],  // 117.8.0.0-117.15.255.255, TJ
        [ 0x75150000, 0x7515FFFF, "JX" ],  // 117.21.0.0-117.21.255.255, JX
        [ 0x75160000, 0x7517FFFF, "SN" ],  // 117.22.0.0-117.23.255.255, SN
        [ 0x75180000, 0x751FFFFF, "FJ" ],  // 117.24.0.0-117.31.255.255, FJ
        [ 0x75200000, 0x7527FFFF, "SN" ],  // 117.32.0.0-117.39.255.255, SN
        [ 0x75280000, 0x752DFFFF, "JX" ],  // 117.40.0.0-117.45.255.255, JX
        [ 0x75300000, 0x75307FFF, "BJ" ],  // 117.48.0.0-117.48.127.255, BJ
        [ 0x75308000, 0x7530AFFF, "JS" ],  // 117.48.128.0-117.48.175.255, JS
        [ 0x7530B000, 0x7530BFFF, "FJ" ],  // 117.48.176.0-117.48.191.255, FJ
        [ 0x7530C000, 0x7530FFFF, "GD" ],  // 117.48.192.0-117.48.255.255, GD
        [ 0x75310000, 0x7532FFFF, "BJ" ],  // 117.49.0.0-117.50.255.255, BJ
        [ 0x75338000, 0x7533FFFF, "BJ" ],  // 117.51.128.0-117.51.255.255, BJ
        [ 0x75353000, 0x75353FFF, "BJ" ],  // 117.53.48.0-117.53.63.255, BJ
        [ 0x7535B000, 0x7535BFFF, "BJ" ],  // 117.53.176.0-117.53.191.255, BJ
        [ 0x75390000, 0x7539FFFF, "AH" ],  // 117.57.0.0-117.57.255.255, AH
        [ 0x753A0000, 0x753A7FFF, "BJ" ],  // 117.58.0.0-117.58.127.255, BJ
        [ 0x753B0000, 0x753B50FF, "CQ" ],  // 117.59.0.0-117.59.80.255, CQ
        [ 0x753B5100, 0x753B51FF, "HE" ],  // 117.59.81.0-117.59.81.255, HE
        [ 0x753B5200, 0x753B52FF, "GZ" ],  // 117.59.82.0-117.59.82.255, GZ
        [ 0x753B5300, 0x753B59FF, "CQ" ],  // 117.59.83.0-117.59.89.255, CQ
        [ 0x753B5A00, 0x753B5BFF, "GZ" ],  // 117.59.90.0-117.59.91.255, GZ
        [ 0x753B5C00, 0x753B5CFF, "YN" ],  // 117.59.92.0-117.59.92.255, YN
        [ 0x753B5D00, 0x753B70FF, "CQ" ],  // 117.59.93.0-117.59.112.255, CQ
        [ 0x753B7100, 0x753B71FF, "HA" ],  // 117.59.113.0-117.59.113.255, HA
        [ 0x753B7200, 0x753BFFFF, "CQ" ],  // 117.59.114.0-117.59.255.255, CQ
        [ 0x753C0000, 0x753CFFFF, "JS" ],  // 117.60.0.0-117.60.255.255, JS
        [ 0x753D0000, 0x753D0FFF, "SC" ],  // 117.61.0.0-117.61.15.255, SC
        [ 0x753D1000, 0x753D37FF, "BJ" ],  // 117.61.16.0-117.61.55.255, BJ
        [ 0x753D3800, 0x753D43FF, "SC" ],  // 117.61.56.0-117.61.67.255, SC
        [ 0x753D4400, 0x753D4BFF, "JS" ],  // 117.61.68.0-117.61.75.255, JS
        [ 0x753D4C00, 0x753D4FFF, "GD" ],  // 117.61.76.0-117.61.79.255, GD
        [ 0x753D5000, 0x753D53FF, "JS" ],  // 117.61.80.0-117.61.83.255, JS
        [ 0x753D5400, 0x753D77FF, "GD" ],  // 117.61.84.0-117.61.119.255, GD
        [ 0x753D7800, 0x753D7BFF, "JS" ],  // 117.61.120.0-117.61.123.255, JS
        [ 0x753D7C00, 0x753D7DFF, "GD" ],  // 117.61.124.0-117.61.125.255, GD
        [ 0x753D7E00, 0x753DAFFF, "JS" ],  // 117.61.126.0-117.61.175.255, JS
        [ 0x753DB000, 0x753DB1FF, "BJ" ],  // 117.61.176.0-117.61.177.255, BJ
        [ 0x753DB200, 0x753DB7FF, "JS" ],  // 117.61.178.0-117.61.183.255, JS
        [ 0x753DB800, 0x753DB9FF, "BJ" ],  // 117.61.184.0-117.61.185.255, BJ
        [ 0x753DBA00, 0x753DBFFF, "JS" ],  // 117.61.186.0-117.61.191.255, JS
        [ 0x753DC000, 0x753DC3FF, "BJ" ],  // 117.61.192.0-117.61.195.255, BJ
        [ 0x753DC400, 0x753FFFFF, "JS" ],  // 117.61.196.0-117.63.255.255, JS
        [ 0x75400000, 0x7547FFFF, "AH" ],  // 117.64.0.0-117.71.255.255, AH
        [ 0x75480000, 0x754841FF, "LN" ],  // 117.72.0.0-117.72.65.255, LN
        [ 0x75484200, 0x754850FF, "BJ" ],  // 117.72.66.0-117.72.80.255, BJ
        [ 0x75485100, 0x75485FFF, "LN" ],  // 117.72.81.0-117.72.95.255, LN
        [ 0x75486000, 0x7548C5FF, "BJ" ],  // 117.72.96.0-117.72.197.255, BJ
        [ 0x7548C600, 0x7548C6FF, "TJ" ],  // 117.72.198.0-117.72.198.255, TJ
        [ 0x7548C700, 0x7548FDFF, "BJ" ],  // 117.72.199.0-117.72.253.255, BJ
        [ 0x7548FE00, 0x7548FEFF, "TJ" ],  // 117.72.254.0-117.72.254.255, TJ
        [ 0x7548FF00, 0x7548FFFF, "HB" ],  // 117.72.255.0-117.72.255.255, HB
        [ 0x75490000, 0x7549E9FF, "BJ" ],  // 117.73.0.0-117.73.233.255, BJ
        [ 0x7549EA00, 0x7549EBFF, "HE" ],  // 117.73.234.0-117.73.235.255, HE
        [ 0x7549EC00, 0x7549F9FF, "BJ" ],  // 117.73.236.0-117.73.249.255, BJ
        [ 0x7549FA00, 0x7549FBFF, "TJ" ],  // 117.73.250.0-117.73.251.255, TJ
        [ 0x7549FC00, 0x7549FFFF, "SD" ],  // 117.73.252.0-117.73.255.255, SD
        [ 0x754A4000, 0x754A4FFF, "HE" ],  // 117.74.64.0-117.74.79.255, HE
        [ 0x754A5000, 0x754A5FFF, "GD" ],  // 117.74.80.0-117.74.95.255, GD
        [ 0x754A8000, 0x754AFFFF, "SH" ],  // 117.74.128.0-117.74.255.255, SH
        [ 0x754B0000, 0x754BFFFF, "YN" ],  // 117.75.0.0-117.75.255.255, YN
        [ 0x754C0000, 0x754E3FFF, "BJ" ],  // 117.76.0.0-117.78.63.255, BJ
        [ 0x754E4000, 0x754EFFFF, "GD" ],  // 117.78.64.0-117.78.255.255, GD
        [ 0x754F0000, 0x754FBFFF, "BJ" ],  // 117.79.0.0-117.79.191.255, BJ
        [ 0x754FC000, 0x754FDFFF, "HB" ],  // 117.79.192.0-117.79.223.255, HB
        [ 0x754FE000, 0x754FFFFF, "BJ" ],  // 117.79.224.0-117.79.255.255, BJ
        [ 0x75500000, 0x755FFFFF, "JS" ],  // 117.80.0.0-117.95.255.255, JS
        [ 0x75640000, 0x7565FFFF, "BJ" ],  // 117.100.0.0-117.101.255.255, BJ
        [ 0x75671000, 0x75671FFF, "SH" ],  // 117.103.16.0-117.103.31.255, SH
        [ 0x75672800, 0x75672FFF, "GD" ],  // 117.103.40.0-117.103.47.255, GD
        [ 0x75674800, 0x75674FFF, "GD" ],  // 117.103.72.0-117.103.79.255, GD
        [ 0x75678000, 0x75678FFF, "BJ" ],  // 117.103.128.0-117.103.143.255, BJ
        [ 0x7568A800, 0x7568AFFF, "GD" ],  // 117.104.168.0-117.104.175.255, GD
        [ 0x756A0000, 0x756BFFFF, "BJ" ],  // 117.106.0.0-117.107.255.255, BJ
        [ 0x75700000, 0x7577FFFF, "BJ" ],  // 117.112.0.0-117.119.255.255, BJ
        [ 0x75784000, 0x75787FFF, "LN" ],  // 117.120.64.0-117.120.127.255, LN
        [ 0x75788000, 0x7578FFFF, "FJ" ],  // 117.120.128.0-117.120.255.255, FJ
        [ 0x75790000, 0x75797FFF, "BJ" ],  // 117.121.0.0-117.121.127.255, BJ
        [ 0x75798000, 0x75798FFF, "JS" ],  // 117.121.128.0-117.121.143.255, JS
        [ 0x75799000, 0x7579BFFF, "BJ" ],  // 117.121.144.0-117.121.191.255, BJ
        [ 0x7579C000, 0x7579C7FF, "SH" ],  // 117.121.192.0-117.121.199.255, SH
        [ 0x757A8000, 0x757AFFFF, "BJ" ],  // 117.122.128.0-117.122.255.255, BJ
        [ 0x757C0000, 0x757E02FF, "BJ" ],  // 117.124.0.0-117.126.2.255, BJ
        [ 0x757E0300, 0x757E03FF, "HI" ],  // 117.126.3.0-117.126.3.255, HI
        [ 0x757E0400, 0x757E0BFF, "BJ" ],  // 117.126.4.0-117.126.11.255, BJ
        [ 0x757E0C00, 0x757E83FF, "HI" ],  // 117.126.12.0-117.126.131.255, HI
        [ 0x757E8400, 0x757E90FF, "BJ" ],  // 117.126.132.0-117.126.144.255, BJ
        [ 0x757E9100, 0x757E92FF, "HI" ],  // 117.126.145.0-117.126.146.255, HI
        [ 0x757E9300, 0x757E9FFF, "BJ" ],  // 117.126.147.0-117.126.159.255, BJ
        [ 0x757EA000, 0x757EA3FF, "HI" ],  // 117.126.160.0-117.126.163.255, HI
        [ 0x757EA400, 0x757EAFFF, "BJ" ],  // 117.126.164.0-117.126.175.255, BJ
        [ 0x757EB000, 0x757EB3FF, "HI" ],  // 117.126.176.0-117.126.179.255, HI
        [ 0x757EB400, 0x757EBFFF, "BJ" ],  // 117.126.180.0-117.126.191.255, BJ
        [ 0x757EC000, 0x757EFEFF, "HI" ],  // 117.126.192.0-117.126.254.255, HI
        [ 0x757EFF00, 0x757FFFFF, "BJ" ],  // 117.126.255.0-117.127.255.255, BJ
        [ 0x75800000, 0x7580007F, "ZJ" ],  // 117.128.0.0-117.128.0.127, ZJ
        [ 0x75800080, 0x758000BF, "GZ" ],  // 117.128.0.128-117.128.0.191, GZ
        [ 0x758000C0, 0x758000FF, "FJ" ],  // 117.128.0.192-117.128.0.255, FJ
        [ 0x75800100, 0x7582FFFF, "BJ" ],  // 117.128.1.0-117.130.255.255, BJ
        [ 0x75830000, 0x75837FFF, "SH" ],  // 117.131.0.0-117.131.127.255, SH
        [ 0x75838000, 0x7583FFFF, "TJ" ],  // 117.131.128.0-117.131.255.255, TJ
        [ 0x75840000, 0x75845FFF, "SD" ],  // 117.132.0.0-117.132.95.255, SD
        [ 0x75846000, 0x75848FFF, "LN" ],  // 117.132.96.0-117.132.143.255, LN
        [ 0x75849000, 0x7584AFFF, "HE" ],  // 117.132.144.0-117.132.175.255, HE
        [ 0x7584B000, 0x7584B6FF, "HL" ],  // 117.132.176.0-117.132.182.255, HL
        [ 0x7584B700, 0x7584BDFF, "NM" ],  // 117.132.183.0-117.132.189.255, NM
        [ 0x7584BE00, 0x7584BEFF, "BJ" ],  // 117.132.190.0-117.132.190.255, BJ
        [ 0x7584BF00, 0x7584C6FF, "GD" ],  // 117.132.191.0-117.132.198.255, GD
        [ 0x7584C700, 0x7584C7FF, "BJ" ],  // 117.132.199.0-117.132.199.255, BJ
        [ 0x7584C800, 0x7584C8FF, "NM" ],  // 117.132.200.0-117.132.200.255, NM
        [ 0x7584C900, 0x7584C9FF, "GD" ],  // 117.132.201.0-117.132.201.255, GD
        [ 0x7584CA00, 0x7584CFFF, "NM" ],  // 117.132.202.0-117.132.207.255, NM
        [ 0x7584D000, 0x758507FF, "BJ" ],  // 117.132.208.0-117.133.7.255, BJ
        [ 0x75850800, 0x75850AFF, "GD" ],  // 117.133.8.0-117.133.10.255, GD
        [ 0x75850B00, 0x75850BFF, "BJ" ],  // 117.133.11.0-117.133.11.255, BJ
        [ 0x75850C00, 0x75850DFF, "GD" ],  // 117.133.12.0-117.133.13.255, GD
        [ 0x75850E00, 0x758623FF, "BJ" ],  // 117.133.14.0-117.134.35.255, BJ
        [ 0x75862400, 0x758626FF, "GD" ],  // 117.134.36.0-117.134.38.255, GD
        [ 0x75862700, 0x758628FF, "NM" ],  // 117.134.39.0-117.134.40.255, NM
        [ 0x75862900, 0x758629FF, "BJ" ],  // 117.134.41.0-117.134.41.255, BJ
        [ 0x75862A00, 0x75862AFF, "GD" ],  // 117.134.42.0-117.134.42.255, GD
        [ 0x75862B00, 0x75862FFF, "BJ" ],  // 117.134.43.0-117.134.47.255, BJ
        [ 0x75863000, 0x7586FFFF, "HL" ],  // 117.134.48.0-117.134.255.255, HL
        [ 0x75870000, 0x7587BFFF, "SH" ],  // 117.135.0.0-117.135.191.255, SH
        [ 0x7587C000, 0x7587FFFF, "GZ" ],  // 117.135.192.0-117.135.255.255, GZ
        [ 0x75880000, 0x758800FF, "BJ" ],  // 117.136.0.0-117.136.0.255, BJ
        [ 0x75880100, 0x758801FF, "TJ" ],  // 117.136.1.0-117.136.1.255, TJ
        [ 0x75880200, 0x758802FF, "HE" ],  // 117.136.2.0-117.136.2.255, HE
        [ 0x75880300, 0x758803FF, "NM" ],  // 117.136.3.0-117.136.3.255, NM
        [ 0x75880400, 0x758804FF, "SX" ],  // 117.136.4.0-117.136.4.255, SX
        [ 0x75880500, 0x758805FF, "LN" ],  // 117.136.5.0-117.136.5.255, LN
        [ 0x75880600, 0x758806FF, "JL" ],  // 117.136.6.0-117.136.6.255, JL
        [ 0x75880700, 0x758807FF, "HL" ],  // 117.136.7.0-117.136.7.255, HL
        [ 0x75880800, 0x758808FF, "SH" ],  // 117.136.8.0-117.136.8.255, SH
        [ 0x75880900, 0x758809FF, "SD" ],  // 117.136.9.0-117.136.9.255, SD
        [ 0x75880A00, 0x75880AFF, "ZJ" ],  // 117.136.10.0-117.136.10.255, ZJ
        [ 0x75880B00, 0x75880BFF, "FJ" ],  // 117.136.11.0-117.136.11.255, FJ
        [ 0x75880C00, 0x75880CFF, "GD" ],  // 117.136.12.0-117.136.12.255, GD
        [ 0x75880D00, 0x75880DFF, "HI" ],  // 117.136.13.0-117.136.13.255, HI
        [ 0x75880E00, 0x75880EFF, "GX" ],  // 117.136.14.0-117.136.14.255, GX
        [ 0x75880F00, 0x75880FFF, "SC" ],  // 117.136.15.0-117.136.15.255, SC
        [ 0x75881000, 0x758810FF, "YN" ],  // 117.136.16.0-117.136.16.255, YN
        [ 0x75881100, 0x758811FF, "GZ" ],  // 117.136.17.0-117.136.17.255, GZ
        [ 0x75881200, 0x758812FF, "XZ" ],  // 117.136.18.0-117.136.18.255, XZ
        [ 0x75881300, 0x758813FF, "JS" ],  // 117.136.19.0-117.136.19.255, JS
        [ 0x75881400, 0x758814FF, "AH" ],  // 117.136.20.0-117.136.20.255, AH
        [ 0x75881500, 0x758815FF, "JX" ],  // 117.136.21.0-117.136.21.255, JX
        [ 0x75881600, 0x758816FF, "HA" ],  // 117.136.22.0-117.136.22.255, HA
        [ 0x75881700, 0x758817FF, "HB" ],  // 117.136.23.0-117.136.23.255, HB
        [ 0x75881800, 0x758818FF, "HN" ],  // 117.136.24.0-117.136.24.255, HN
        [ 0x75881900, 0x758819FF, "SN" ],  // 117.136.25.0-117.136.25.255, SN
        [ 0x75881A00, 0x75881AFF, "XJ" ],  // 117.136.26.0-117.136.26.255, XJ
        [ 0x75881B00, 0x75881BFF, "GS" ],  // 117.136.27.0-117.136.27.255, GS
        [ 0x75881C00, 0x75881CFF, "NX" ],  // 117.136.28.0-117.136.28.255, NX
        [ 0x75881D00, 0x75881DFF, "QH" ],  // 117.136.29.0-117.136.29.255, QH
        [ 0x75881E00, 0x75881EFF, "CQ" ],  // 117.136.30.0-117.136.30.255, CQ
        [ 0x75881F00, 0x758822FF, "GD" ],  // 117.136.31.0-117.136.34.255, GD
        [ 0x75882300, 0x758823FF, "JS" ],  // 117.136.35.0-117.136.35.255, JS
        [ 0x75882400, 0x758824FF, "HA" ],  // 117.136.36.0-117.136.36.255, HA
        [ 0x75882500, 0x758825FF, "SD" ],  // 117.136.37.0-117.136.37.255, SD
        [ 0x75882600, 0x758826FF, "BJ" ],  // 117.136.38.0-117.136.38.255, BJ
        [ 0x75882700, 0x758829FF, "GD" ],  // 117.136.39.0-117.136.41.255, GD
        [ 0x75882A00, 0x75882AFF, "BJ" ],  // 117.136.42.0-117.136.42.255, BJ
        [ 0x75882B00, 0x75882BFF, "GD" ],  // 117.136.43.0-117.136.43.255, GD
        [ 0x75882C00, 0x75882CFF, "HA" ],  // 117.136.44.0-117.136.44.255, HA
        [ 0x75882D00, 0x75882EFF, "JS" ],  // 117.136.45.0-117.136.46.255, JS
        [ 0x75882F00, 0x75882FFF, "HE" ],  // 117.136.47.0-117.136.47.255, HE
        [ 0x75883000, 0x758831FF, "JX" ],  // 117.136.48.0-117.136.49.255, JX
        [ 0x75883200, 0x758833FF, "SN" ],  // 117.136.50.0-117.136.51.255, SN
        [ 0x75883400, 0x758835FF, "HB" ],  // 117.136.52.0-117.136.53.255, HB
        [ 0x75883600, 0x758837FF, "TJ" ],  // 117.136.54.0-117.136.55.255, TJ
        [ 0x75883800, 0x758839FF, "HL" ],  // 117.136.56.0-117.136.57.255, HL
        [ 0x75883A00, 0x75883BFF, "JL" ],  // 117.136.58.0-117.136.59.255, JL
        [ 0x75883C00, 0x75883CFF, "JX" ],  // 117.136.60.0-117.136.60.255, JX
        [ 0x75883D00, 0x75883DFF, "HA" ],  // 117.136.61.0-117.136.61.255, HA
        [ 0x75883E00, 0x758841FF, "SC" ],  // 117.136.62.0-117.136.65.255, SC
        [ 0x75884200, 0x758844FF, "JS" ],  // 117.136.66.0-117.136.68.255, JS
        [ 0x75884500, 0x758846FF, "SC" ],  // 117.136.69.0-117.136.70.255, SC
        [ 0x75884700, 0x758849FF, "YN" ],  // 117.136.71.0-117.136.73.255, YN
        [ 0x75884A00, 0x75884AFF, "HB" ],  // 117.136.74.0-117.136.74.255, HB
        [ 0x75884B00, 0x75884BFF, "FJ" ],  // 117.136.75.0-117.136.75.255, FJ
        [ 0x75884C00, 0x75884CFF, "GX" ],  // 117.136.76.0-117.136.76.255, GX
        [ 0x75884D00, 0x75884EFF, "SD" ],  // 117.136.77.0-117.136.78.255, SD
        [ 0x75884F00, 0x75884FFF, "GD" ],  // 117.136.79.0-117.136.79.255, GD
        [ 0x75885000, 0x758850FF, "YN" ],  // 117.136.80.0-117.136.80.255, YN
        [ 0x75885100, 0x758851FF, "HB" ],  // 117.136.81.0-117.136.81.255, HB
        [ 0x75885200, 0x758852FF, "SC" ],  // 117.136.82.0-117.136.82.255, SC
        [ 0x75885300, 0x758853FF, "HB" ],  // 117.136.83.0-117.136.83.255, HB
        [ 0x75885400, 0x758855FF, "YN" ],  // 117.136.84.0-117.136.85.255, YN
        [ 0x75885600, 0x758857FF, "SN" ],  // 117.136.86.0-117.136.87.255, SN
        [ 0x75885800, 0x758859FF, "HN" ],  // 117.136.88.0-117.136.89.255, HN
        [ 0x75885A00, 0x75885BFF, "SX" ],  // 117.136.90.0-117.136.91.255, SX
        [ 0x75885C00, 0x75885FFF, "SD" ],  // 117.136.92.0-117.136.95.255, SD
        [ 0x75886000, 0x758860FF, "BJ" ],  // 117.136.96.0-117.136.96.255, BJ
        [ 0x75886100, 0x758863FF, "GX" ],  // 117.136.97.0-117.136.99.255, GX
        [ 0x75886400, 0x758867FF, "AH" ],  // 117.136.100.0-117.136.103.255, AH
        [ 0x75886800, 0x75886BFF, "HA" ],  // 117.136.104.0-117.136.107.255, HA
        [ 0x75886C00, 0x75886EFF, "JX" ],  // 117.136.108.0-117.136.110.255, JX
        [ 0x75886F00, 0x758873FF, "ZJ" ],  // 117.136.111.0-117.136.115.255, ZJ
        [ 0x75887400, 0x758876FF, "AH" ],  // 117.136.116.0-117.136.118.255, AH
        [ 0x75887700, 0x758878FF, "SH" ],  // 117.136.119.0-117.136.120.255, SH
        [ 0x75887900, 0x75887FFF, "JX" ],  // 117.136.121.0-117.136.127.255, JX
        [ 0x75888000, 0x758881FF, "BJ" ],  // 117.136.128.0-117.136.129.255, BJ
        [ 0x75888200, 0x758883FF, "GD" ],  // 117.136.130.0-117.136.131.255, GD
        [ 0x75888400, 0x75888BFF, "BJ" ],  // 117.136.132.0-117.136.139.255, BJ
        [ 0x75888C00, 0x75888C3F, "LN" ],  // 117.136.140.0-117.136.140.63, LN
        [ 0x75888C40, 0x75888C7F, "CQ" ],  // 117.136.140.64-117.136.140.127, CQ
        [ 0x75888C80, 0x75888CBF, "SN" ],  // 117.136.140.128-117.136.140.191, SN
        [ 0x75888CC0, 0x75888CFF, "HA" ],  // 117.136.140.192-117.136.140.255, HA
        [ 0x75888D00, 0x75888DFF, "JS" ],  // 117.136.141.0-117.136.141.255, JS
        [ 0x75888E00, 0x75888EFF, "BJ" ],  // 117.136.142.0-117.136.142.255, BJ
        [ 0x75888F00, 0x75888F7F, "SH" ],  // 117.136.143.0-117.136.143.127, SH
        [ 0x75888F80, 0x75888FCF, "GD" ],  // 117.136.143.128-117.136.143.207, GD
        [ 0x75888FD0, 0x75888FFF, "SH" ],  // 117.136.143.208-117.136.143.255, SH
        [ 0x75889000, 0x758890FF, "SC" ],  // 117.136.144.0-117.136.144.255, SC
        [ 0x75889100, 0x758891FF, "HB" ],  // 117.136.145.0-117.136.145.255, HB
        [ 0x75889200, 0x7588B1FF, "XZ" ],  // 117.136.146.0-117.136.177.255, XZ
        [ 0x7588B200, 0x7588B2FF, "BJ" ],  // 117.136.178.0-117.136.178.255, BJ
        [ 0x7588B300, 0x7588B32F, "GD" ],  // 117.136.179.0-117.136.179.47, GD
        [ 0x7588B330, 0x7588B3FF, "BJ" ],  // 117.136.179.48-117.136.179.255, BJ
        [ 0x7588B400, 0x7588B4FF, "GD" ],  // 117.136.180.0-117.136.180.255, GD
        [ 0x7588B500, 0x7588B9FF, "BJ" ],  // 117.136.181.0-117.136.185.255, BJ
        [ 0x7588BA00, 0x7588BAFF, "GD" ],  // 117.136.186.0-117.136.186.255, GD
        [ 0x7588BB00, 0x7588BFFF, "BJ" ],  // 117.136.187.0-117.136.191.255, BJ
        [ 0x7588C000, 0x7588C10F, "SN" ],  // 117.136.192.0-117.136.193.15, SN
        [ 0x7588C110, 0x7588C12F, "HA" ],  // 117.136.193.16-117.136.193.47, HA
        [ 0x7588C130, 0x7588C14F, "CQ" ],  // 117.136.193.48-117.136.193.79, CQ
        [ 0x7588C150, 0x7588C2FF, "BJ" ],  // 117.136.193.80-117.136.194.255, BJ
        [ 0x7588C300, 0x7588C3FF, "SH" ],  // 117.136.195.0-117.136.195.255, SH
        [ 0x7588C400, 0x7588C4FF, "GD" ],  // 117.136.196.0-117.136.196.255, GD
        [ 0x7588C500, 0x7588C6FF, "BJ" ],  // 117.136.197.0-117.136.198.255, BJ
        [ 0x7588C700, 0x7588C7FF, "GD" ],  // 117.136.199.0-117.136.199.255, GD
        [ 0x7588C800, 0x7588E9FF, "BJ" ],  // 117.136.200.0-117.136.233.255, BJ
        [ 0x7588EA00, 0x7588EAFF, "HA" ],  // 117.136.234.0-117.136.234.255, HA
        [ 0x7588EB00, 0x7588EEFF, "BJ" ],  // 117.136.235.0-117.136.238.255, BJ
        [ 0x7588EF00, 0x7588F0FF, "GD" ],  // 117.136.239.0-117.136.240.255, GD
        [ 0x7588F100, 0x7588FFFF, "BJ" ],  // 117.136.241.0-117.136.255.255, BJ
        [ 0x75890000, 0x758AFFFF, "NM" ],  // 117.137.0.0-117.138.255.255, NM
        [ 0x758B0000, 0x758B8952, "SC" ],  // 117.139.0.0-117.139.137.82, SC
        [ 0x758B8953, 0x758B8953, "XZ" ],  // 117.139.137.83-117.139.137.83, XZ
        [ 0x758B8954, 0x758BFFFF, "SC" ],  // 117.139.137.84-117.139.255.255, SC
        [ 0x758C0000, 0x758DFFFF, "GX" ],  // 117.140.0.0-117.141.255.255, GX
        [ 0x758E0000, 0x758E03FF, "GD" ],  // 117.142.0.0-117.142.3.255, GD
        [ 0x758E0400, 0x758E04FF, "AH" ],  // 117.142.4.0-117.142.4.255, AH
        [ 0x758E0500, 0x758E06FF, "HA" ],  // 117.142.5.0-117.142.6.255, HA
        [ 0x758E0700, 0x758E09FF, "SC" ],  // 117.142.7.0-117.142.9.255, SC
        [ 0x758E0A00, 0x758E0FFF, "JS" ],  // 117.142.10.0-117.142.15.255, JS
        [ 0x758E1000, 0x758E11FF, "ZJ" ],  // 117.142.16.0-117.142.17.255, ZJ
        [ 0x758E1200, 0x758E13FF, "GD" ],  // 117.142.18.0-117.142.19.255, GD
        [ 0x758E1400, 0x758E15FF, "YN" ],  // 117.142.20.0-117.142.21.255, YN
        [ 0x758E1600, 0x758E17FF, "HB" ],  // 117.142.22.0-117.142.23.255, HB
        [ 0x758E1800, 0x758E18FF, "FJ" ],  // 117.142.24.0-117.142.24.255, FJ
        [ 0x758E1900, 0x758E19FF, "NX" ],  // 117.142.25.0-117.142.25.255, NX
        [ 0x758E1A00, 0x758E1EFF, "GD" ],  // 117.142.26.0-117.142.30.255, GD
        [ 0x758E1F00, 0x758E23FF, "HB" ],  // 117.142.31.0-117.142.35.255, HB
        [ 0x758E2400, 0x758E24FF, "YN" ],  // 117.142.36.0-117.142.36.255, YN
        [ 0x758E2500, 0x758E26FF, "SD" ],  // 117.142.37.0-117.142.38.255, SD
        [ 0x758E2700, 0x758E2AFF, "JS" ],  // 117.142.39.0-117.142.42.255, JS
        [ 0x758E2B00, 0x758E2CFF, "SX" ],  // 117.142.43.0-117.142.44.255, SX
        [ 0x758E2D00, 0x758E2FFF, "AH" ],  // 117.142.45.0-117.142.47.255, AH
        [ 0x758E3000, 0x758E44FF, "BJ" ],  // 117.142.48.0-117.142.68.255, BJ
        [ 0x758E4500, 0x758E63FF, "GD" ],  // 117.142.69.0-117.142.99.255, GD
        [ 0x758E6400, 0x758E69FF, "GX" ],  // 117.142.100.0-117.142.105.255, GX
        [ 0x758E6A00, 0x758E6CFF, "GZ" ],  // 117.142.106.0-117.142.108.255, GZ
        [ 0x758E6D00, 0x758E6EFF, "HI" ],  // 117.142.109.0-117.142.110.255, HI
        [ 0x758E6F00, 0x758E74FF, "HE" ],  // 117.142.111.0-117.142.116.255, HE
        [ 0x758E7500, 0x758E76FF, "BJ" ],  // 117.142.117.0-117.142.118.255, BJ
        [ 0x758E7700, 0x758E82FF, "HA" ],  // 117.142.119.0-117.142.130.255, HA
        [ 0x758E8300, 0x758E87FF, "HL" ],  // 117.142.131.0-117.142.135.255, HL
        [ 0x758E8800, 0x758E92FF, "HN" ],  // 117.142.136.0-117.142.146.255, HN
        [ 0x758E9300, 0x758E99FF, "JL" ],  // 117.142.147.0-117.142.153.255, JL
        [ 0x758E9A00, 0x758EA6FF, "JS" ],  // 117.142.154.0-117.142.166.255, JS
        [ 0x758EA700, 0x758EACFF, "ZJ" ],  // 117.142.167.0-117.142.172.255, ZJ
        [ 0x758EAD00, 0x758EB0FF, "JX" ],  // 117.142.173.0-117.142.176.255, JX
        [ 0x758EB100, 0x758EB6FF, "LN" ],  // 117.142.177.0-117.142.182.255, LN
        [ 0x758EB700, 0x758EB8FF, "NM" ],  // 117.142.183.0-117.142.184.255, NM
        [ 0x758EB900, 0x758EBAFF, "NX" ],  // 117.142.185.0-117.142.186.255, NX
        [ 0x758EBB00, 0x758EBDFF, "QH" ],  // 117.142.187.0-117.142.189.255, QH
        [ 0x758EBE00, 0x758EC9FF, "SD" ],  // 117.142.190.0-117.142.201.255, SD
        [ 0x758ECA00, 0x758ECDFF, "SX" ],  // 117.142.202.0-117.142.205.255, SX
        [ 0x758ECE00, 0x758ECFFF, "SN" ],  // 117.142.206.0-117.142.207.255, SN
        [ 0x758ED000, 0x758ED7FF, "SH" ],  // 117.142.208.0-117.142.215.255, SH
        [ 0x758ED800, 0x758EDAFF, "SC" ],  // 117.142.216.0-117.142.218.255, SC
        [ 0x758EDB00, 0x758EE8FF, "TJ" ],  // 117.142.219.0-117.142.232.255, TJ
        [ 0x758EE900, 0x758EEDFF, "YN" ],  // 117.142.233.0-117.142.237.255, YN
        [ 0x758EEE00, 0x758EFFFF, "ZJ" ],  // 117.142.238.0-117.142.255.255, ZJ
        [ 0x758F0000, 0x7590FFFF, "SH" ],  // 117.143.0.0-117.144.255.255, SH
        [ 0x75910000, 0x7592FFFF, "XJ" ],  // 117.145.0.0-117.146.255.255, XJ
        [ 0x75930000, 0x7595FFFF, "ZJ" ],  // 117.147.0.0-117.149.255.255, ZJ
        [ 0x75960000, 0x759BFFFF, "HB" ],  // 117.150.0.0-117.155.255.255, HB
        [ 0x759C0000, 0x759DFFFF, "GS" ],  // 117.156.0.0-117.157.255.255, GS
        [ 0x759E0000, 0x75A0FFFF, "HA" ],  // 117.158.0.0-117.160.255.255, HA
        [ 0x75A10000, 0x75A1FFFF, "NM" ],  // 117.161.0.0-117.161.255.255, NM
        [ 0x75A20000, 0x75ABFFFF, "JX" ],  // 117.162.0.0-117.171.255.255, JX
        [ 0x75AC0000, 0x75B1FFFF, "SC" ],  // 117.172.0.0-117.177.255.255, SC
        [ 0x75B20000, 0x75B2FFFF, "JX" ],  // 117.178.0.0-117.178.255.255, JX
        [ 0x75B30000, 0x75B3FFFF, "HL" ],  // 117.179.0.0-117.179.255.255, HL
        [ 0x75B40000, 0x75B4B3FF, "BJ" ],  // 117.180.0.0-117.180.179.255, BJ
        [ 0x75B4B400, 0x75B4B5FF, "GD" ],  // 117.180.180.0-117.180.181.255, GD
        [ 0x75B4B600, 0x75B4CDFF, "BJ" ],  // 117.180.182.0-117.180.205.255, BJ
        [ 0x75B4CE00, 0x75B4D60B, "XZ" ],  // 117.180.206.0-117.180.214.11, XZ
        [ 0x75B4D60C, 0x75B4D60C, "QH" ],  // 117.180.214.12-117.180.214.12, QH
        [ 0x75B4D60D, 0x75B4D60E, "XZ" ],  // 117.180.214.13-117.180.214.14, XZ
        [ 0x75B4D60F, 0x75B4D60F, "QH" ],  // 117.180.214.15-117.180.214.15, QH
        [ 0x75B4D610, 0x75B4FFFF, "XZ" ],  // 117.180.214.16-117.180.255.255, XZ
        [ 0x75B50000, 0x75B7FFFF, "GX" ],  // 117.181.0.0-117.183.255.255, GX
        [ 0x75B80000, 0x75BAFFFF, "SH" ],  // 117.184.0.0-117.186.255.255, SH
        [ 0x75BB0000, 0x75BDFFFF, "GZ" ],  // 117.187.0.0-117.189.255.255, GZ
        [ 0x75BE0000, 0x75BFFFFF, "XJ" ],  // 117.190.0.0-117.191.255.255, XJ
        [ 0x76180000, 0x7618BFFF, "SC" ],  // 118.24.0.0-118.24.191.255, SC
        [ 0x7618C000, 0x7618FFFF, "CQ" ],  // 118.24.192.0-118.24.255.255, CQ
        [ 0x76190000, 0x7619C7FF, "SH" ],  // 118.25.0.0-118.25.199.255, SH
        [ 0x7619C800, 0x7619CFFF, "GD" ],  // 118.25.200.0-118.25.207.255, GD
        [ 0x7619D000, 0x7619EFFF, "SC" ],  // 118.25.208.0-118.25.239.255, SC
        [ 0x7619F000, 0x7619FFFF, "SH" ],  // 118.25.240.0-118.25.255.255, SH
        [ 0x761A0000, 0x761A1FFF, "BJ" ],  // 118.26.0.0-118.26.31.255, BJ
        [ 0x761A2800, 0x761A2FFF, "BJ" ],  // 118.26.40.0-118.26.47.255, BJ
        [ 0x761A3000, 0x761A37FF, "GD" ],  // 118.26.48.0-118.26.55.255, GD
        [ 0x761A3800, 0x761A67FF, "BJ" ],  // 118.26.56.0-118.26.103.255, BJ
        [ 0x761A7000, 0x761A73FF, "HB" ],  // 118.26.112.0-118.26.115.255, HB
        [ 0x761A7400, 0x761A77FF, "SD" ],  // 118.26.116.0-118.26.119.255, SD
        [ 0x761A7800, 0x761A7FFF, "GD" ],  // 118.26.120.0-118.26.127.255, GD
        [ 0x761A8000, 0x761A83FF, "BJ" ],  // 118.26.128.0-118.26.131.255, BJ
        [ 0x761A8500, 0x761A8FFF, "BJ" ],  // 118.26.133.0-118.26.143.255, BJ
        [ 0x761AA000, 0x761AAFFF, "BJ" ],  // 118.26.160.0-118.26.175.255, BJ
        [ 0x761AB400, 0x761AFFFF, "BJ" ],  // 118.26.180.0-118.26.255.255, BJ
        [ 0x761C0000, 0x761DFFFF, "TJ" ],  // 118.28.0.0-118.29.255.255, TJ
        [ 0x761E0000, 0x761E1BFF, "GD" ],  // 118.30.0.0-118.30.27.255, GD
        [ 0x761E1C00, 0x761E1FFF, "BJ" ],  // 118.30.28.0-118.30.31.255, BJ
        [ 0x761E2000, 0x761EFFFF, "GD" ],  // 118.30.32.0-118.30.255.255, GD
        [ 0x761F0000, 0x761FFFFF, "ZJ" ],  // 118.31.0.0-118.31.255.255, ZJ
        [ 0x76400000, 0x7642FFFF, "BJ" ],  // 118.64.0.0-118.66.255.255, BJ
        [ 0x76437000, 0x76437FFF, "BJ" ],  // 118.67.112.0-118.67.127.255, BJ
        [ 0x76480000, 0x7651FFFF, "SX" ],  // 118.72.0.0-118.81.255.255, SX
        [ 0x76540000, 0x765400FF, "BJ" ],  // 118.84.0.0-118.84.0.255, BJ
        [ 0x76540100, 0x765402FF, "AH" ],  // 118.84.1.0-118.84.2.255, AH
        [ 0x76540300, 0x7654BDFF, "BJ" ],  // 118.84.3.0-118.84.189.255, BJ
        [ 0x7654BE00, 0x7654BE2B, "SH" ],  // 118.84.190.0-118.84.190.43, SH
        [ 0x7654BE2C, 0x7654BE5A, "BJ" ],  // 118.84.190.44-118.84.190.90, BJ
        [ 0x7654BE5B, 0x7654BE5D, "SH" ],  // 118.84.190.91-118.84.190.93, SH
        [ 0x7654BE5E, 0x7654BE5F, "BJ" ],  // 118.84.190.94-118.84.190.95, BJ
        [ 0x7654BE60, 0x7654BE7F, "SH" ],  // 118.84.190.96-118.84.190.127, SH
        [ 0x7654BE80, 0x7654C1FF, "BJ" ],  // 118.84.190.128-118.84.193.255, BJ
        [ 0x7654C200, 0x7654C2FF, "JS" ],  // 118.84.194.0-118.84.194.255, JS
        [ 0x7654C300, 0x7654CBFF, "BJ" ],  // 118.84.195.0-118.84.203.255, BJ
        [ 0x7654CC00, 0x7654CCFF, "SH" ],  // 118.84.204.0-118.84.204.255, SH
        [ 0x7654CD00, 0x7654FCFF, "BJ" ],  // 118.84.205.0-118.84.252.255, BJ
        [ 0x7654FD00, 0x7654FDFF, "HI" ],  // 118.84.253.0-118.84.253.255, HI
        [ 0x7654FE00, 0x765562FF, "BJ" ],  // 118.84.254.0-118.85.98.255, BJ
        [ 0x76556300, 0x76556501, "ZJ" ],  // 118.85.99.0-118.85.101.1, ZJ
        [ 0x76556502, 0x7655665A, "SN" ],  // 118.85.101.2-118.85.102.90, SN
        [ 0x7655665B, 0x765566D3, "HN" ],  // 118.85.102.91-118.85.102.211, HN
        [ 0x765566D4, 0x765568FF, "GD" ],  // 118.85.102.212-118.85.104.255, GD
        [ 0x76556900, 0x765569FF, "SH" ],  // 118.85.105.0-118.85.105.255, SH
        [ 0x76556A00, 0x76557423, "BJ" ],  // 118.85.106.0-118.85.116.35, BJ
        [ 0x76557424, 0x765575BF, "GD" ],  // 118.85.116.36-118.85.117.191, GD
        [ 0x765575C0, 0x765575DF, "BJ" ],  // 118.85.117.192-118.85.117.223, BJ
        [ 0x765575E0, 0x765575E7, "GD" ],  // 118.85.117.224-118.85.117.231, GD
        [ 0x765575E8, 0x765587FF, "BJ" ],  // 118.85.117.232-118.85.135.255, BJ
        [ 0x76558800, 0x76558804, "GD" ],  // 118.85.136.0-118.85.136.4, GD
        [ 0x76558805, 0x765588FF, "BJ" ],  // 118.85.136.5-118.85.136.255, BJ
        [ 0x76558900, 0x7655C1FF, "SH" ],  // 118.85.137.0-118.85.193.255, SH
        [ 0x7655C200, 0x7655C7FF, "BJ" ],  // 118.85.194.0-118.85.199.255, BJ
        [ 0x7655C800, 0x7655CBFF, "SH" ],  // 118.85.200.0-118.85.203.255, SH
        [ 0x7655CC00, 0x7655CEFF, "BJ" ],  // 118.85.204.0-118.85.206.255, BJ
        [ 0x7655CF00, 0x7655CF7F, "SH" ],  // 118.85.207.0-118.85.207.127, SH
        [ 0x7655CF80, 0x7655CFFF, "BJ" ],  // 118.85.207.128-118.85.207.255, BJ
        [ 0x7655D000, 0x7655D5FF, "GD" ],  // 118.85.208.0-118.85.213.255, GD
        [ 0x7655D600, 0x7655D6FF, "BJ" ],  // 118.85.214.0-118.85.214.255, BJ
        [ 0x7655D700, 0x7655FFFF, "SH" ],  // 118.85.215.0-118.85.255.255, SH
        [ 0x76582000, 0x7658FFFF, "JL" ],  // 118.88.32.0-118.88.255.255, JL
        [ 0x76590000, 0x765907FF, "TJ" ],  // 118.89.0.0-118.89.7.255, TJ
        [ 0x76590800, 0x76590FFF, "SH" ],  // 118.89.8.0-118.89.15.255, SH
        [ 0x76591000, 0x765941FF, "GD" ],  // 118.89.16.0-118.89.65.255, GD
        [ 0x76594200, 0x7659D1FF, "SH" ],  // 118.89.66.0-118.89.209.255, SH
        [ 0x7659D200, 0x7659F9FF, "TJ" ],  // 118.89.210.0-118.89.249.255, TJ
        [ 0x7659FA00, 0x7659FFFF, "GD" ],  // 118.89.250.0-118.89.255.255, GD
        [ 0x765BF000, 0x765BFFFF, "ZJ" ],  // 118.91.240.0-118.91.255.255, ZJ
        [ 0x76661000, 0x76661FFF, "BJ" ],  // 118.102.16.0-118.102.31.255, BJ
        [ 0x76662000, 0x766627FF, "GD" ],  // 118.102.32.0-118.102.39.255, GD
        [ 0x7667A400, 0x7667A7FF, "SN" ],  // 118.103.164.0-118.103.167.255, SN
        [ 0x7667A800, 0x7667ABFF, "TJ" ],  // 118.103.168.0-118.103.171.255, TJ
        [ 0x7667AC00, 0x7667B3FF, "BJ" ],  // 118.103.172.0-118.103.179.255, BJ
        [ 0x76700000, 0x767675FF, "SC" ],  // 118.112.0.0-118.118.117.255, SC
        [ 0x76767600, 0x76767676, "SH" ],  // 118.118.118.0-118.118.118.118, SH
        [ 0x76767677, 0x767DFFFF, "SC" ],  // 118.118.118.119-118.125.255.255, SC
        [ 0x767E0000, 0x767E57FF, "SH" ],  // 118.126.0.0-118.126.87.255, SH
        [ 0x767E5800, 0x767E6BFF, "GD" ],  // 118.126.88.0-118.126.107.255, GD
        [ 0x767E6C00, 0x767E75FF, "SC" ],  // 118.126.108.0-118.126.117.255, SC
        [ 0x767E7600, 0x767E7FFF, "GD" ],  // 118.126.118.0-118.126.127.255, GD
        [ 0x767E8000, 0x767EFFFF, "BJ" ],  // 118.126.128.0-118.126.255.255, BJ
        [ 0x767F8000, 0x767F9FFF, "GD" ],  // 118.127.128.0-118.127.159.255, GD
        [ 0x76840000, 0x7687FFFF, "SH" ],  // 118.132.0.0-118.135.255.255, SH
        [ 0x76900000, 0x7690A3FF, "BJ" ],  // 118.144.0.0-118.144.163.255, BJ
        [ 0x7690A400, 0x7690A5FF, "CQ" ],  // 118.144.164.0-118.144.165.255, CQ
        [ 0x7690A600, 0x76911FFF, "BJ" ],  // 118.144.166.0-118.145.31.255, BJ
        [ 0x76912000, 0x7691FFFF, "HB" ],  // 118.145.32.0-118.145.255.255, HB
        [ 0x76920000, 0x7693FFFF, "BJ" ],  // 118.146.0.0-118.147.255.255, BJ
        [ 0x76B20000, 0x76B2FFFF, "ZJ" ],  // 118.178.0.0-118.178.255.255, ZJ
        [ 0x76B40000, 0x76B7FFFF, "GS" ],  // 118.180.0.0-118.183.255.255, GS
        [ 0x76B80000, 0x76B817FF, "SH" ],  // 118.184.0.0-118.184.23.255, SH
        [ 0x76B81900, 0x76B847FF, "SH" ],  // 118.184.25.0-118.184.71.255, SH
        [ 0x76B84A00, 0x76B84AFF, "SH" ],  // 118.184.74.0-118.184.74.255, SH
        [ 0x76B84C00, 0x76B866FF, "SH" ],  // 118.184.76.0-118.184.102.255, SH
        [ 0x76B86700, 0x76B867FF, "BJ" ],  // 118.184.103.0-118.184.103.255, BJ
        [ 0x76B86800, 0x76B86FFF, "SH" ],  // 118.184.104.0-118.184.111.255, SH
        [ 0x76B87400, 0x76B87FFF, "SH" ],  // 118.184.116.0-118.184.127.255, SH
        [ 0x76B88000, 0x76B8FFFF, "JS" ],  // 118.184.128.0-118.184.255.255, JS
        [ 0x76BA0000, 0x76BC8FFF, "BJ" ],  // 118.186.0.0-118.188.143.255, BJ
        [ 0x76BCA000, 0x76BCFFFF, "BJ" ],  // 118.188.160.0-118.188.255.255, BJ
        [ 0x76BE0000, 0x76BEFFFF, "SD" ],  // 118.190.0.0-118.190.255.255, SD
        [ 0x76BF0000, 0x76BF0CFF, "JS" ],  // 118.191.0.0-118.191.12.255, JS
        [ 0x76BF1000, 0x76BF17FF, "GD" ],  // 118.191.16.0-118.191.23.255, GD
        [ 0x76BF4000, 0x76BF53FF, "BJ" ],  // 118.191.64.0-118.191.83.255, BJ
        [ 0x76BF8000, 0x76BF9FFF, "BJ" ],  // 118.191.128.0-118.191.159.255, BJ
        [ 0x76BFB000, 0x76BFD0FF, "BJ" ],  // 118.191.176.0-118.191.208.255, BJ
        [ 0x76BFD800, 0x76BFDBFF, "BJ" ],  // 118.191.216.0-118.191.219.255, BJ
        [ 0x76BFDF00, 0x76BFE0FF, "BJ" ],  // 118.191.223.0-118.191.224.255, BJ
        [ 0x76BFF000, 0x76C10FFF, "BJ" ],  // 118.191.240.0-118.193.15.255, BJ
        [ 0x76C13000, 0x76C137FF, "BJ" ],  // 118.193.48.0-118.193.55.255, BJ
        [ 0x76C16000, 0x76C17FFF, "BJ" ],  // 118.193.96.0-118.193.127.255, BJ
        [ 0x76C18200, 0x76C189FF, "SH" ],  // 118.193.130.0-118.193.137.255, SH
        [ 0x76C18B00, 0x76C197FF, "SH" ],  // 118.193.139.0-118.193.151.255, SH
        [ 0x76C1A300, 0x76C1A3FF, "SH" ],  // 118.193.163.0-118.193.163.255, SH
        [ 0x76C1A800, 0x76C1AFFF, "SH" ],  // 118.193.168.0-118.193.175.255, SH
        [ 0x76C1B100, 0x76C1BBFF, "SH" ],  // 118.193.177.0-118.193.187.255, SH
        [ 0x76C1C000, 0x76C2DFFF, "BJ" ],  // 118.193.192.0-118.194.223.255, BJ
        [ 0x76C2E000, 0x76C2E3FF, "GD" ],  // 118.194.224.0-118.194.227.255, GD
        [ 0x76C2F000, 0x76C2F7FF, "BJ" ],  // 118.194.240.0-118.194.247.255, BJ
        [ 0x76C30000, 0x76C37FFF, "BJ" ],  // 118.195.0.0-118.195.127.255, BJ
        [ 0x76C38000, 0x76C3FFFF, "JS" ],  // 118.195.128.0-118.195.255.255, JS
        [ 0x76C40000, 0x76C5FFFF, "GD" ],  // 118.196.0.0-118.197.255.255, GD
        [ 0x76C60000, 0x76C7FFFF, "BJ" ],  // 118.198.0.0-118.199.255.255, BJ
        [ 0x76CA0000, 0x76CAFFFF, "LN" ],  // 118.202.0.0-118.202.255.255, LN
        [ 0x76CB0000, 0x76CBFFFF, "HL" ],  // 118.203.0.0-118.203.255.255, HL
        [ 0x76CC0000, 0x76CCFFFF, "LN" ],  // 118.204.0.0-118.204.255.255, LN
        [ 0x76CD0000, 0x76CD7FFF, "SH" ],  // 118.205.0.0-118.205.127.255, SH
        [ 0x76CD8000, 0x76CDFFFF, "CQ" ],  // 118.205.128.0-118.205.255.255, CQ
        [ 0x76CE0000, 0x76CE13FF, "JL" ],  // 118.206.0.0-118.206.19.255, JL
        [ 0x76CE1400, 0x76CE93FF, "LN" ],  // 118.206.20.0-118.206.147.255, LN
        [ 0x76CE9400, 0x76CEBFFF, "SD" ],  // 118.206.148.0-118.206.191.255, SD
        [ 0x76CEC000, 0x76CEFFFF, "HN" ],  // 118.206.192.0-118.206.255.255, HN
        [ 0x76CF0000, 0x76CFFFFF, "BJ" ],  // 118.207.0.0-118.207.255.255, BJ
        [ 0x76D40000, 0x76D4FFFF, "JX" ],  // 118.212.0.0-118.212.255.255, JX
        [ 0x76D50000, 0x76D5FFFF, "QH" ],  // 118.213.0.0-118.213.255.255, QH
        [ 0x76D7C000, 0x76D7C4FF, "TJ" ],  // 118.215.192.0-118.215.196.255, TJ
        [ 0x76D7C500, 0x76D7C9FF, "ZJ" ],  // 118.215.197.0-118.215.201.255, ZJ
        [ 0x76D7CA00, 0x76D7CEFF, "GD" ],  // 118.215.202.0-118.215.206.255, GD
        [ 0x76D7CF00, 0x76D7D3FF, "AH" ],  // 118.215.207.0-118.215.211.255, AH
        [ 0x76D7D400, 0x76D7DFFF, "GD" ],  // 118.215.212.0-118.215.223.255, GD
        [ 0x76D7E000, 0x76D7FFFF, "BJ" ],  // 118.215.224.0-118.215.255.255, BJ
        [ 0x76E00000, 0x76E001FF, "SC" ],  // 118.224.0.0-118.224.1.255, SC
        [ 0x76E00200, 0x76E5FFFF, "BJ" ],  // 118.224.2.0-118.229.255.255, BJ
        [ 0x76E60000, 0x76E67FFF, "NM" ],  // 118.230.0.0-118.230.127.255, NM
        [ 0x76E68000, 0x76E6FFFF, "HE" ],  // 118.230.128.0-118.230.255.255, HE
        [ 0x76EF0000, 0x76EFFFFF, "HN" ],  // 118.239.0.0-118.239.255.255, HN
        [ 0x76F20000, 0x76F2FFFF, "SH" ],  // 118.242.0.0-118.242.255.255, SH
        [ 0x76F40000, 0x76F4FFFF, "BJ" ],  // 118.244.0.0-118.244.255.255, BJ
        [ 0x76F50000, 0x76F51FFF, "HL" ],  // 118.245.0.0-118.245.31.255, HL
        [ 0x76F52000, 0x76F53FFF, "BJ" ],  // 118.245.32.0-118.245.63.255, BJ
        [ 0x76F54000, 0x76F547FF, "JL" ],  // 118.245.64.0-118.245.71.255, JL
        [ 0x76F54800, 0x76F57FFF, "BJ" ],  // 118.245.72.0-118.245.127.255, BJ
        [ 0x76F58000, 0x76F5FFFF, "GD" ],  // 118.245.128.0-118.245.255.255, GD
        [ 0x76F60000, 0x76F7FFFF, "BJ" ],  // 118.246.0.0-118.247.255.255, BJ
        [ 0x76F80000, 0x76FAB2FF, "HN" ],  // 118.248.0.0-118.250.178.255, HN
        [ 0x76FAB300, 0x76FAB3FF, "GD" ],  // 118.250.179.0-118.250.179.255, GD
        [ 0x76FAB400, 0x76FFFFFF, "HN" ],  // 118.250.180.0-118.255.255.255, HN
        [ 0x77000000, 0x7701FFFF, "GZ" ],  // 119.0.0.0-119.1.255.255, GZ
        [ 0x77020000, 0x77021FFF, "BJ" ],  // 119.2.0.0-119.2.31.255, BJ
        [ 0x77028000, 0x7702FFFF, "GD" ],  // 119.2.128.0-119.2.255.255, GD
        [ 0x77030000, 0x770371FF, "SH" ],  // 119.3.0.0-119.3.113.255, SH
        [ 0x77037200, 0x770372FF, "GD" ],  // 119.3.114.0-119.3.114.255, GD
        [ 0x77037300, 0x77039FFF, "SH" ],  // 119.3.115.0-119.3.159.255, SH
        [ 0x7703A000, 0x7703FFFF, "BJ" ],  // 119.3.160.0-119.3.255.255, BJ
        [ 0x77040000, 0x7707FFFF, "SC" ],  // 119.4.0.0-119.7.255.255, SC
        [ 0x770A0000, 0x770A7FFF, "BJ" ],  // 119.10.0.0-119.10.127.255, BJ
        [ 0x770F8800, 0x770F8FFF, "SH" ],  // 119.15.136.0-119.15.143.255, SH
        [ 0x77100000, 0x7710FFFF, "GD" ],  // 119.16.0.0-119.16.255.255, GD
        [ 0x7712C000, 0x7712D7FF, "BJ" ],  // 119.18.192.0-119.18.215.255, BJ
        [ 0x7712E000, 0x7712E0FF, "SH" ],  // 119.18.224.0-119.18.224.255, SH
        [ 0x7712E100, 0x7712E1FF, "BJ" ],  // 119.18.225.0-119.18.225.255, BJ
        [ 0x7712E200, 0x7712E5FF, "SH" ],  // 119.18.226.0-119.18.229.255, SH
        [ 0x7712E600, 0x7712E6FF, "BJ" ],  // 119.18.230.0-119.18.230.255, BJ
        [ 0x7712E700, 0x7712EFFF, "SH" ],  // 119.18.231.0-119.18.239.255, SH
        [ 0x7712F000, 0x7713FFFF, "GD" ],  // 119.18.240.0-119.19.255.255, GD
        [ 0x77140000, 0x7714FFFF, "HE" ],  // 119.20.0.0-119.20.255.255, HE
        [ 0x77150000, 0x771523FF, "HB" ],  // 119.21.0.0-119.21.35.255, HB
        [ 0x77152400, 0x771528FF, "HE" ],  // 119.21.36.0-119.21.40.255, HE
        [ 0x77152900, 0x77153FFF, "HB" ],  // 119.21.41.0-119.21.63.255, HB
        [ 0x77154000, 0x7716FFFF, "HE" ],  // 119.21.64.0-119.22.255.255, HE
        [ 0x77170000, 0x7717FFFF, "GD" ],  // 119.23.0.0-119.23.255.255, GD
        [ 0x771B4000, 0x771B7FFF, "LN" ],  // 119.27.64.0-119.27.127.255, LN
        [ 0x771B8000, 0x771B9FFF, "GD" ],  // 119.27.128.0-119.27.159.255, GD
        [ 0x771BA000, 0x771BBFFF, "SC" ],  // 119.27.160.0-119.27.191.255, SC
        [ 0x771BC000, 0x771BFFFF, "FJ" ],  // 119.27.192.0-119.27.255.255, FJ
        [ 0x771D0000, 0x771D1CFF, "GD" ],  // 119.29.0.0-119.29.28.255, GD
        [ 0x771D1D00, 0x771D1DFF, "BJ" ],  // 119.29.29.0-119.29.29.255, BJ
        [ 0x771D1E00, 0x771DFFFF, "GD" ],  // 119.29.30.0-119.29.255.255, GD
        [ 0x771E3000, 0x771E3FFF, "SH" ],  // 119.30.48.0-119.30.63.255, SH
        [ 0x771FC000, 0x771FDFFF, "HA" ],  // 119.31.192.0-119.31.223.255, HA
        [ 0x77200000, 0x7723FFFF, "GD" ],  // 119.32.0.0-119.35.255.255, GD
        [ 0x77240000, 0x7724FFFF, "HB" ],  // 119.36.0.0-119.36.255.255, HB
        [ 0x77250000, 0x7725BFFF, "SH" ],  // 119.37.0.0-119.37.191.255, SH
        [ 0x7725C000, 0x77267FFF, "ZJ" ],  // 119.37.192.0-119.38.127.255, ZJ
        [ 0x77268000, 0x7726BFFF, "GD" ],  // 119.38.128.0-119.38.191.255, GD
        [ 0x7726C000, 0x7726CFFF, "BJ" ],  // 119.38.192.0-119.38.207.255, BJ
        [ 0x7726D000, 0x7726DFFF, "ZJ" ],  // 119.38.208.0-119.38.223.255, ZJ
        [ 0x7726E000, 0x7726FFFF, "SH" ],  // 119.38.224.0-119.38.255.255, SH
        [ 0x77270000, 0x7727FFFF, "HN" ],  // 119.39.0.0-119.39.255.255, HN
        [ 0x77280000, 0x77283FFF, "BJ" ],  // 119.40.0.0-119.40.63.255, BJ
        [ 0x77284000, 0x77284FFF, "JS" ],  // 119.40.64.0-119.40.79.255, JS
        [ 0x77288000, 0x7728FFFF, "GD" ],  // 119.40.128.0-119.40.255.255, GD
        [ 0x77290000, 0x7729FFFF, "HI" ],  // 119.41.0.0-119.41.255.255, HI
        [ 0x772A0000, 0x772A1FFF, "GD" ],  // 119.42.0.0-119.42.31.255, GD
        [ 0x772A8000, 0x772A87FF, "GD" ],  // 119.42.128.0-119.42.135.255, GD
        [ 0x772A8800, 0x772A89FF, "SH" ],  // 119.42.136.0-119.42.137.255, SH
        [ 0x772A8A00, 0x772A8FFF, "BJ" ],  // 119.42.138.0-119.42.143.255, BJ
        [ 0x772AE000, 0x772AE3FF, "ZJ" ],  // 119.42.224.0-119.42.227.255, ZJ
        [ 0x772AE400, 0x772AE5FF, "GD" ],  // 119.42.228.0-119.42.229.255, GD
        [ 0x772AE600, 0x772AE7FF, "SH" ],  // 119.42.230.0-119.42.231.255, SH
        [ 0x772AE800, 0x772AFFFF, "ZJ" ],  // 119.42.232.0-119.42.255.255, ZJ
        [ 0x772C0000, 0x772CFFFF, "HN" ],  // 119.44.0.0-119.44.255.255, HN
        [ 0x772D0000, 0x772DFFFF, "JS" ],  // 119.45.0.0-119.45.255.255, JS
        [ 0x77300000, 0x7737FFFF, "JL" ],  // 119.48.0.0-119.55.255.255, JL
        [ 0x77390000, 0x7739FFFF, "BJ" ],  // 119.57.0.0-119.57.255.255, BJ
        [ 0x773A0000, 0x773AFFFF, "SH" ],  // 119.58.0.0-119.58.255.255, SH
        [ 0x773B8000, 0x773BFFFF, "GD" ],  // 119.59.128.0-119.59.255.255, GD
        [ 0x773C0000, 0x773CFFFF, "NX" ],  // 119.60.0.0-119.60.255.255, NX
        [ 0x773D0000, 0x773DFFFF, "BJ" ],  // 119.61.0.0-119.61.255.255, BJ
        [ 0x773E0000, 0x773EFFFF, "YN" ],  // 119.62.0.0-119.62.255.255, YN
        [ 0x773F2000, 0x773F3FFF, "GD" ],  // 119.63.32.0-119.63.63.255, GD
        [ 0x774BD000, 0x774BDFFF, "BJ" ],  // 119.75.208.0-119.75.223.255, BJ
        [ 0x774E0000, 0x774E07FF, "GD" ],  // 119.78.0.0-119.78.7.255, GD
        [ 0x774E0800, 0x774E3FFF, "BJ" ],  // 119.78.8.0-119.78.63.255, BJ
        [ 0x774E4000, 0x774E4FFF, "SH" ],  // 119.78.64.0-119.78.79.255, SH
        [ 0x774E5000, 0x774E51FF, "SC" ],  // 119.78.80.0-119.78.81.255, SC
        [ 0x774E5200, 0x774E5FFF, "BJ" ],  // 119.78.82.0-119.78.95.255, BJ
        [ 0x774E6000, 0x774E64FF, "GS" ],  // 119.78.96.0-119.78.100.255, GS
        [ 0x774E6500, 0x774E65FF, "BJ" ],  // 119.78.101.0-119.78.101.255, BJ
        [ 0x774E6600, 0x774E66FF, "GS" ],  // 119.78.102.0-119.78.102.255, GS
        [ 0x774E6700, 0x774E7FFF, "BJ" ],  // 119.78.103.0-119.78.127.255, BJ
        [ 0x774E8000, 0x774E87FF, "LN" ],  // 119.78.128.0-119.78.135.255, LN
        [ 0x774E8800, 0x774E8FFF, "BJ" ],  // 119.78.136.0-119.78.143.255, BJ
        [ 0x774E9000, 0x774E90FF, "SN" ],  // 119.78.144.0-119.78.144.255, SN
        [ 0x774E9100, 0x774E9FFF, "BJ" ],  // 119.78.145.0-119.78.159.255, BJ
        [ 0x774EA000, 0x774ECFFF, "XJ" ],  // 119.78.160.0-119.78.207.255, XJ
        [ 0x774ED000, 0x774EDFFF, "JS" ],  // 119.78.208.0-119.78.223.255, JS
        [ 0x774EE000, 0x774EFFFF, "SH" ],  // 119.78.224.0-119.78.255.255, SH
        [ 0x774F0000, 0x774FFFFF, "HB" ],  // 119.79.0.0-119.79.255.255, HB
        [ 0x77500000, 0x7750FFFF, "BJ" ],  // 119.80.0.0-119.80.255.255, BJ
        [ 0x7752D000, 0x7752DFFF, "GD" ],  // 119.82.208.0-119.82.223.255, GD
        [ 0x77540000, 0x7757FFFF, "CQ" ],  // 119.84.0.0-119.87.255.255, CQ
        [ 0x77580000, 0x77587FFF, "BJ" ],  // 119.88.0.0-119.88.127.255, BJ
        [ 0x77588000, 0x7759FFFF, "HE" ],  // 119.88.128.0-119.89.255.255, HE
        [ 0x775A0000, 0x775A3FFF, "BJ" ],  // 119.90.0.0-119.90.63.255, BJ
        [ 0x775A4000, 0x775A4BFF, "HE" ],  // 119.90.64.0-119.90.75.255, HE
        [ 0x775A4C00, 0x775A9FFF, "BJ" ],  // 119.90.76.0-119.90.159.255, BJ
        [ 0x775AA000, 0x775AFFFF, "HE" ],  // 119.90.160.0-119.90.255.255, HE
        [ 0x775B0000, 0x775BFFFF, "GD" ],  // 119.91.0.0-119.91.255.255, GD
        [ 0x77600000, 0x7767FFFF, "HB" ],  // 119.96.0.0-119.103.255.255, HB
        [ 0x776C0000, 0x776DFFFF, "LN" ],  // 119.108.0.0-119.109.255.255, LN
        [ 0x77700000, 0x7777FFFF, "LN" ],  // 119.112.0.0-119.119.255.255, LN
        [ 0x77780000, 0x7793FFFF, "GD" ],  // 119.120.0.0-119.147.255.255, GD
        [ 0x7794A000, 0x7794A3FF, "SH" ],  // 119.148.160.0-119.148.163.255, SH
        [ 0x7794A400, 0x7794AFFF, "BJ" ],  // 119.148.164.0-119.148.175.255, BJ
        [ 0x7794B000, 0x7794BFFF, "GD" ],  // 119.148.176.0-119.148.191.255, GD
        [ 0x7797C000, 0x7797FFFF, "GD" ],  // 119.151.192.0-119.151.255.255, GD
        [ 0x77A0C800, 0x77A0CFFF, "GD" ],  // 119.160.200.0-119.160.207.255, GD
        [ 0x77A17800, 0x77A19FFF, "BJ" ],  // 119.161.120.0-119.161.159.255, BJ
        [ 0x77A1A000, 0x77A1A1FF, "GD" ],  // 119.161.160.0-119.161.161.255, GD
        [ 0x77A1A200, 0x77A1FFFF, "BJ" ],  // 119.161.162.0-119.161.255.255, BJ
        [ 0x77A20000, 0x77A7FFFF, "SD" ],  // 119.162.0.0-119.167.255.255, SD
        [ 0x77B00000, 0x77BFFFFF, "SD" ],  // 119.176.0.0-119.191.255.255, SD
        [ 0x77E80000, 0x77E83FFF, "GD" ],  // 119.232.0.0-119.232.63.255, GD
        [ 0x77E84000, 0x77E8FFFF, "BJ" ],  // 119.232.64.0-119.232.255.255, BJ
        [ 0x77E90000, 0x77E97FFF, "GD" ],  // 119.233.0.0-119.233.127.255, GD
        [ 0x77E98000, 0x77E9FFFF, "FJ" ],  // 119.233.128.0-119.233.255.255, FJ
        [ 0x77EB8000, 0x77EBBFFF, "SH" ],  // 119.235.128.0-119.235.191.255, SH
        [ 0x77F80000, 0x77FBFFFF, "HE" ],  // 119.248.0.0-119.251.255.255, HE
        [ 0x77FC6000, 0x77FC67FF, "GD" ],  // 119.252.96.0-119.252.103.255, GD
        [ 0x77FCF000, 0x77FCF7FF, "SC" ],  // 119.252.240.0-119.252.247.255, SC
        [ 0x77FCF800, 0x77FCFFFF, "GD" ],  // 119.252.248.0-119.252.255.255, GD
        [ 0x77FD0000, 0x77FFFFFF, "BJ" ],  // 119.253.0.0-119.255.255.255, BJ
        [ 0x78000000, 0x780FFFFF, "HE" ],  // 120.0.0.0-120.15.255.255, HE
        [ 0x78180000, 0x7819FFFF, "GD" ],  // 120.24.0.0-120.25.255.255, GD
        [ 0x781A0000, 0x781AFFFF, "ZJ" ],  // 120.26.0.0-120.26.255.255, ZJ
        [ 0x781B0000, 0x781B7FFF, "SD" ],  // 120.27.0.0-120.27.127.255, SD
        [ 0x781B8000, 0x781BFFFF, "ZJ" ],  // 120.27.128.0-120.27.255.255, ZJ
        [ 0x781E0000, 0x781FFFFF, "GD" ],  // 120.30.0.0-120.31.255.255, GD
        [ 0x78200000, 0x782BFFFF, "FJ" ],  // 120.32.0.0-120.43.255.255, FJ
        [ 0x782C0000, 0x782C60FF, "BJ" ],  // 120.44.0.0-120.44.96.255, BJ
        [ 0x782C6100, 0x782C61FF, "JS" ],  // 120.44.97.0-120.44.97.255, JS
        [ 0x782C6200, 0x782C7BFF, "BJ" ],  // 120.44.98.0-120.44.123.255, BJ
        [ 0x782C7C00, 0x782C7DFF, "JS" ],  // 120.44.124.0-120.44.125.255, JS
        [ 0x782C7E00, 0x78305FFF, "BJ" ],  // 120.44.126.0-120.48.95.255, BJ
        [ 0x78306000, 0x783060FF, "GD" ],  // 120.48.96.0-120.48.96.255, GD
        [ 0x78306100, 0x7831FFFF, "BJ" ],  // 120.48.97.0-120.49.255.255, BJ
        [ 0x78340000, 0x7834FFFF, "HE" ],  // 120.52.0.0-120.52.255.255, HE
        [ 0x78350000, 0x7835FFFF, "BJ" ],  // 120.53.0.0-120.53.255.255, BJ
        [ 0x78360000, 0x7836FFFF, "SC" ],  // 120.54.0.0-120.54.255.255, SC
        [ 0x78370000, 0x78379FFF, "ZJ" ],  // 120.55.0.0-120.55.159.255, ZJ
        [ 0x7837A000, 0x7837ABFF, "SH" ],  // 120.55.160.0-120.55.171.255, SH
        [ 0x7837AC00, 0x7837FFFF, "ZJ" ],  // 120.55.172.0-120.55.255.255, ZJ
        [ 0x78400000, 0x78411FFF, "BJ" ],  // 120.64.0.0-120.65.31.255, BJ
        [ 0x78412000, 0x78413FFF, "GD" ],  // 120.65.32.0-120.65.63.255, GD
        [ 0x78414000, 0x784157FF, "BJ" ],  // 120.65.64.0-120.65.87.255, BJ
        [ 0x78415800, 0x78415FFF, "GD" ],  // 120.65.88.0-120.65.95.255, GD
        [ 0x78416000, 0x7841FDFF, "BJ" ],  // 120.65.96.0-120.65.253.255, BJ
        [ 0x7841FE00, 0x7841FFFF, "HB" ],  // 120.65.254.0-120.65.255.255, HB
        [ 0x78420000, 0x784349FF, "BJ" ],  // 120.66.0.0-120.67.73.255, BJ
        [ 0x78434A00, 0x78434AFF, "SD" ],  // 120.67.74.0-120.67.74.255, SD
        [ 0x78434B00, 0x784367FF, "BJ" ],  // 120.67.75.0-120.67.103.255, BJ
        [ 0x78436800, 0x784368FF, "SD" ],  // 120.67.104.0-120.67.104.255, SD
        [ 0x78436900, 0x78437FFF, "BJ" ],  // 120.67.105.0-120.67.127.255, BJ
        [ 0x78438000, 0x7843FFFF, "FJ" ],  // 120.67.128.0-120.67.255.255, FJ
        [ 0x78440000, 0x7847FFFF, "XJ" ],  // 120.68.0.0-120.71.255.255, XJ
        [ 0x78482000, 0x78483FFF, "JS" ],  // 120.72.32.0-120.72.63.255, JS
        [ 0x78488000, 0x7848FFFF, "BJ" ],  // 120.72.128.0-120.72.255.255, BJ
        [ 0x784C0000, 0x7857FFFF, "GD" ],  // 120.76.0.0-120.87.255.255, GD
        [ 0x78580800, 0x78580FFF, "GD" ],  // 120.88.8.0-120.88.15.255, GD
        [ 0x785A0000, 0x785BFFFF, "SH" ],  // 120.90.0.0-120.91.255.255, SH
        [ 0x785C0000, 0x785C7FFF, "BJ" ],  // 120.92.0.0-120.92.127.255, BJ
        [ 0x785C8000, 0x785CBFFF, "SH" ],  // 120.92.128.0-120.92.191.255, SH
        [ 0x785CC000, 0x785CD7FF, "BJ" ],  // 120.92.192.0-120.92.215.255, BJ
        [ 0x785CD800, 0x785CDBFF, "SH" ],  // 120.92.216.0-120.92.219.255, SH
        [ 0x785CDC00, 0x785CDFFF, "BJ" ],  // 120.92.220.0-120.92.223.255, BJ
        [ 0x785CE000, 0x785CEFFF, "SH" ],  // 120.92.224.0-120.92.239.255, SH
        [ 0x785CF000, 0x785CFFFF, "ZJ" ],  // 120.92.240.0-120.92.255.255, ZJ
        [ 0x785E0000, 0x785E7FFF, "SC" ],  // 120.94.0.0-120.94.127.255, SC
        [ 0x785E8000, 0x785EBFFF, "CQ" ],  // 120.94.128.0-120.94.191.255, CQ
        [ 0x785EC000, 0x785EFFFF, "SC" ],  // 120.94.192.0-120.94.255.255, SC
        [ 0x785F0000, 0x785FBFFF, "SN" ],  // 120.95.0.0-120.95.191.255, SN
        [ 0x785FC000, 0x785FFFFF, "XJ" ],  // 120.95.192.0-120.95.255.255, XJ
        [ 0x78800000, 0x78800FFF, "SN" ],  // 120.128.0.0-120.128.15.255, SN
        [ 0x78801000, 0x78805FFF, "SD" ],  // 120.128.16.0-120.128.95.255, SD
        [ 0x78806000, 0x788073FF, "ZJ" ],  // 120.128.96.0-120.128.115.255, ZJ
        [ 0x78807400, 0x788077FF, "HB" ],  // 120.128.116.0-120.128.119.255, HB
        [ 0x78807800, 0x78807FFF, "ZJ" ],  // 120.128.120.0-120.128.127.255, ZJ
        [ 0x78808000, 0x7880AFFF, "SH" ],  // 120.128.128.0-120.128.175.255, SH
        [ 0x7880B000, 0x7880BFFF, "HB" ],  // 120.128.176.0-120.128.191.255, HB
        [ 0x7880C000, 0x7880C5FF, "JS" ],  // 120.128.192.0-120.128.197.255, JS
        [ 0x7880C600, 0x7880C7FF, "HB" ],  // 120.128.198.0-120.128.199.255, HB
        [ 0x7880C800, 0x7880D9FF, "JS" ],  // 120.128.200.0-120.128.217.255, JS
        [ 0x7880DA00, 0x7880FFFF, "HB" ],  // 120.128.218.0-120.128.255.255, HB
        [ 0x78810000, 0x78813FFF, "ZJ" ],  // 120.129.0.0-120.129.63.255, ZJ
        [ 0x78814000, 0x78815FFF, "SH" ],  // 120.129.64.0-120.129.95.255, SH
        [ 0x78816000, 0x78816FFF, "ZJ" ],  // 120.129.96.0-120.129.111.255, ZJ
        [ 0x78817000, 0x78817FFF, "HB" ],  // 120.129.112.0-120.129.127.255, HB
        [ 0x78818000, 0x7881BFFF, "SD" ],  // 120.129.128.0-120.129.191.255, SD
        [ 0x7881C000, 0x7881DFFF, "HB" ],  // 120.129.192.0-120.129.223.255, HB
        [ 0x7881E000, 0x7881FFFF, "SH" ],  // 120.129.224.0-120.129.255.255, SH
        [ 0x78820000, 0x788231FF, "HB" ],  // 120.130.0.0-120.130.49.255, HB
        [ 0x78823200, 0x788233FF, "JX" ],  // 120.130.50.0-120.130.51.255, JX
        [ 0x78823400, 0x7882FFFF, "HB" ],  // 120.130.52.0-120.130.255.255, HB
        [ 0x78830000, 0x7883C7FF, "BJ" ],  // 120.131.0.0-120.131.199.255, BJ
        [ 0x7883C800, 0x7883CFFF, "LN" ],  // 120.131.200.0-120.131.207.255, LN
        [ 0x7883D000, 0x7883FFFF, "BJ" ],  // 120.131.208.0-120.131.255.255, BJ
        [ 0x78840000, 0x78841FFF, "JS" ],  // 120.132.0.0-120.132.31.255, JS
        [ 0x78842000, 0x78845FFF, "BJ" ],  // 120.132.32.0-120.132.95.255, BJ
        [ 0x78846000, 0x78846FFF, "JS" ],  // 120.132.96.0-120.132.111.255, JS
        [ 0x78847000, 0x788487FF, "GD" ],  // 120.132.112.0-120.132.135.255, GD
        [ 0x78848800, 0x78848BFF, "SH" ],  // 120.132.136.0-120.132.139.255, SH
        [ 0x78848C00, 0x7884B3FF, "GD" ],  // 120.132.140.0-120.132.179.255, GD
        [ 0x7884B400, 0x7884B4FF, "BJ" ],  // 120.132.180.0-120.132.180.255, BJ
        [ 0x7884B500, 0x7884BFFF, "GD" ],  // 120.132.181.0-120.132.191.255, GD
        [ 0x7884C000, 0x7884C1FF, "SH" ],  // 120.132.192.0-120.132.193.255, SH
        [ 0x7884C200, 0x7884DFFF, "GD" ],  // 120.132.194.0-120.132.223.255, GD
        [ 0x7884E000, 0x7884E7FF, "SH" ],  // 120.132.224.0-120.132.231.255, SH
        [ 0x7884E800, 0x7884FFFF, "GD" ],  // 120.132.232.0-120.132.255.255, GD
        [ 0x78850000, 0x78857FFF, "BJ" ],  // 120.133.0.0-120.133.127.255, BJ
        [ 0x78858000, 0x788591FF, "GD" ],  // 120.133.128.0-120.133.145.255, GD
        [ 0x78859200, 0x7885DFFF, "BJ" ],  // 120.133.146.0-120.133.223.255, BJ
        [ 0x7885E000, 0x7885E3FF, "JS" ],  // 120.133.224.0-120.133.227.255, JS
        [ 0x7885E400, 0x7885E7FF, "SH" ],  // 120.133.228.0-120.133.231.255, SH
        [ 0x7885E800, 0x7885EBFF, "BJ" ],  // 120.133.232.0-120.133.235.255, BJ
        [ 0x7885EC00, 0x7885FFFF, "SH" ],  // 120.133.236.0-120.133.255.255, SH
        [ 0x78860000, 0x78870FFF, "BJ" ],  // 120.134.0.0-120.135.15.255, BJ
        [ 0x78871000, 0x788713FF, "SH" ],  // 120.135.16.0-120.135.19.255, SH
        [ 0x78871400, 0x788714FF, "BJ" ],  // 120.135.20.0-120.135.20.255, BJ
        [ 0x78871500, 0x78873FFF, "SH" ],  // 120.135.21.0-120.135.63.255, SH
        [ 0x78874000, 0x7887FFFF, "BJ" ],  // 120.135.64.0-120.135.255.255, BJ
        [ 0x78881000, 0x788813FF, "BJ" ],  // 120.136.16.0-120.136.19.255, BJ
        [ 0x78881400, 0x788816FF, "GD" ],  // 120.136.20.0-120.136.22.255, GD
        [ 0x78881700, 0x788817FF, "SH" ],  // 120.136.23.0-120.136.23.255, SH
        [ 0x78888000, 0x7888BFFF, "SH" ],  // 120.136.128.0-120.136.191.255, SH
        [ 0x78890000, 0x78897FFF, "SH" ],  // 120.137.0.0-120.137.127.255, SH
        [ 0x788F8000, 0x788F9FFF, "GD" ],  // 120.143.128.0-120.143.159.255, GD
        [ 0x78C00000, 0x78C0BFFF, "SD" ],  // 120.192.0.0-120.192.191.255, SD
        [ 0x78C0C000, 0x78C0FFFF, "SN" ],  // 120.192.192.0-120.192.255.255, SN
        [ 0x78C10000, 0x78C13FFF, "ZJ" ],  // 120.193.0.0-120.193.63.255, ZJ
        [ 0x78C14000, 0x78C17FFF, "AH" ],  // 120.193.64.0-120.193.127.255, AH
        [ 0x78C18000, 0x78C1FFFF, "NM" ],  // 120.193.128.0-120.193.255.255, NM
        [ 0x78C20000, 0x78C2FFFF, "HA" ],  // 120.194.0.0-120.194.255.255, HA
        [ 0x78C30000, 0x78C3FFFF, "JS" ],  // 120.195.0.0-120.195.255.255, JS
        [ 0x78C40000, 0x78C6FFFF, "GD" ],  // 120.196.0.0-120.198.255.255, GD
        [ 0x78C70000, 0x78C7FFFF, "ZJ" ],  // 120.199.0.0-120.199.255.255, ZJ
        [ 0x78C80000, 0x78C9FFFF, "LN" ],  // 120.200.0.0-120.201.255.255, LN
        [ 0x78CA0000, 0x78CAFFFF, "HB" ],  // 120.202.0.0-120.202.255.255, HB
        [ 0x78CB0000, 0x78CBFFFF, "JX" ],  // 120.203.0.0-120.203.255.255, JX
        [ 0x78CC0000, 0x78CCFFFF, "SH" ],  // 120.204.0.0-120.204.255.255, SH
        [ 0x78CD0000, 0x78CDFFFF, "XJ" ],  // 120.205.0.0-120.205.255.255, XJ
        [ 0x78CE0000, 0x78CEFFFF, "JX" ],  // 120.206.0.0-120.206.255.255, JX
        [ 0x78CF0000, 0x78D0FFFF, "SX" ],  // 120.207.0.0-120.208.255.255, SX
        [ 0x78D10000, 0x78D2FFFF, "AH" ],  // 120.209.0.0-120.210.255.255, AH
        [ 0x78D30000, 0x78D3FFFF, "HE" ],  // 120.211.0.0-120.211.255.255, HE
        [ 0x78D40000, 0x78DBFFFF, "HA" ],  // 120.212.0.0-120.219.255.255, HA
        [ 0x78DC0000, 0x78E1FFFF, "SD" ],  // 120.220.0.0-120.225.255.255, SD
        [ 0x78E20000, 0x78E4FFFF, "HN" ],  // 120.226.0.0-120.228.255.255, HN
        [ 0x78E50000, 0x78F1FFFF, "GD" ],  // 120.229.0.0-120.241.255.255, GD
        [ 0x78F20000, 0x78F3FFFF, "AH" ],  // 120.242.0.0-120.243.255.255, AH
        [ 0x78F40000, 0x78FCFFFF, "BJ" ],  // 120.244.0.0-120.252.255.255, BJ
        [ 0x78FD0000, 0x78FD7FFF, "NX" ],  // 120.253.0.0-120.253.127.255, NX
        [ 0x78FD8000, 0x78FDFFFF, "SH" ],  // 120.253.128.0-120.253.255.255, SH
        [ 0x78FE0000, 0x78FFFFFF, "BJ" ],  // 120.254.0.0-120.255.255.255, BJ
        [ 0x79000800, 0x79000FFF, "GD" ],  // 121.0.8.0-121.0.15.255, GD
        [ 0x79001000, 0x79001FFF, "ZJ" ],  // 121.0.16.0-121.0.31.255, ZJ
        [ 0x79040000, 0x790403FF, "BJ" ],  // 121.4.0.0-121.4.3.255, BJ
        [ 0x79040400, 0x790404FF, "SH" ],  // 121.4.4.0-121.4.4.255, SH
        [ 0x79040500, 0x790407FF, "BJ" ],  // 121.4.5.0-121.4.7.255, BJ
        [ 0x79040800, 0x7905FFFF, "SH" ],  // 121.4.8.0-121.5.255.255, SH
        [ 0x79080000, 0x790FFFFF, "GD" ],  // 121.8.0.0-121.15.255.255, GD
        [ 0x79100000, 0x791DFFFF, "HE" ],  // 121.16.0.0-121.29.255.255, HE
        [ 0x791E0000, 0x791EFFFF, "SX" ],  // 121.30.0.0-121.30.255.255, SX
        [ 0x791F0000, 0x791FFFFF, "GX" ],  // 121.31.0.0-121.31.255.255, GX
        [ 0x79200000, 0x7923FFFF, "GD" ],  // 121.32.0.0-121.35.255.255, GD
        [ 0x79240000, 0x79247FFF, "BJ" ],  // 121.36.0.0-121.36.127.255, BJ
        [ 0x79248000, 0x7924FFFF, "SH" ],  // 121.36.128.0-121.36.255.255, SH
        [ 0x79250000, 0x79253FFF, "GD" ],  // 121.37.0.0-121.37.63.255, GD
        [ 0x79254000, 0x79257FFF, "BJ" ],  // 121.37.64.0-121.37.127.255, BJ
        [ 0x79258000, 0x7925BFFF, "SH" ],  // 121.37.128.0-121.37.191.255, SH
        [ 0x7925C000, 0x7925FFFF, "GD" ],  // 121.37.192.0-121.37.255.255, GD
        [ 0x79260000, 0x7927FFFF, "BJ" ],  // 121.38.0.0-121.39.255.255, BJ
        [ 0x79280000, 0x7929FFFF, "ZJ" ],  // 121.40.0.0-121.41.255.255, ZJ
        [ 0x792A0000, 0x792AFFFF, "SD" ],  // 121.42.0.0-121.42.255.255, SD
        [ 0x792B0000, 0x792BFFFF, "ZJ" ],  // 121.43.0.0-121.43.255.255, ZJ
        [ 0x792E0000, 0x792E3FFF, "GD" ],  // 121.46.0.0-121.46.63.255, GD
        [ 0x792E4C00, 0x792E4FFF, "HA" ],  // 121.46.76.0-121.46.79.255, HA
        [ 0x792E8000, 0x792EBFFF, "GD" ],  // 121.46.128.0-121.46.191.255, GD
        [ 0x792EC000, 0x792ECFFF, "JS" ],  // 121.46.192.0-121.46.207.255, JS
        [ 0x792ED000, 0x792EFEFF, "SH" ],  // 121.46.208.0-121.46.254.255, SH
        [ 0x792EFF00, 0x792EFFFF, "GD" ],  // 121.46.255.0-121.46.255.255, GD
        [ 0x792F0000, 0x792FFFFF, "BJ" ],  // 121.47.0.0-121.47.255.255, BJ
        [ 0x79300000, 0x7930FFFF, "SC" ],  // 121.48.0.0-121.48.255.255, SC
        [ 0x79310000, 0x79310BFF, "CQ" ],  // 121.49.0.0-121.49.11.255, CQ
        [ 0x79310C00, 0x79310FFF, "SC" ],  // 121.49.12.0-121.49.15.255, SC
        [ 0x79311000, 0x793127FF, "CQ" ],  // 121.49.16.0-121.49.39.255, CQ
        [ 0x79312800, 0x79317FFF, "SC" ],  // 121.49.40.0-121.49.127.255, SC
        [ 0x79318000, 0x7931BFFF, "YN" ],  // 121.49.128.0-121.49.191.255, YN
        [ 0x7931C000, 0x7931EFFF, "GZ" ],  // 121.49.192.0-121.49.239.255, GZ
        [ 0x7931F000, 0x7931FFFF, "SC" ],  // 121.49.240.0-121.49.255.255, SC
        [ 0x79320800, 0x79320FFF, "GD" ],  // 121.50.8.0-121.50.15.255, GD
        [ 0x79330000, 0x79331FFF, "GD" ],  // 121.51.0.0-121.51.31.255, GD
        [ 0x79332000, 0x79332FFF, "SH" ],  // 121.51.32.0-121.51.47.255, SH
        [ 0x79333000, 0x793331FF, "GD" ],  // 121.51.48.0-121.51.49.255, GD
        [ 0x79333200, 0x793332FF, "SH" ],  // 121.51.50.0-121.51.50.255, SH
        [ 0x79333300, 0x793333FF, "TJ" ],  // 121.51.51.0-121.51.51.255, TJ
        [ 0x79333400, 0x79333AFF, "SH" ],  // 121.51.52.0-121.51.58.255, SH
        [ 0x79333B00, 0x79333BFF, "GD" ],  // 121.51.59.0-121.51.59.255, GD
        [ 0x79333C00, 0x79335DFF, "SH" ],  // 121.51.60.0-121.51.93.255, SH
        [ 0x79335E00, 0x793360FF, "GD" ],  // 121.51.94.0-121.51.96.255, GD
        [ 0x79336100, 0x793361FF, "SC" ],  // 121.51.97.0-121.51.97.255, SC
        [ 0x79336200, 0x79336FFF, "GD" ],  // 121.51.98.0-121.51.111.255, GD
        [ 0x79337000, 0x793375FF, "SH" ],  // 121.51.112.0-121.51.117.255, SH
        [ 0x79337600, 0x7933CFFF, "GD" ],  // 121.51.118.0-121.51.207.255, GD
        [ 0x7933D000, 0x7933D4FF, "SH" ],  // 121.51.208.0-121.51.212.255, SH
        [ 0x7933D500, 0x7933D5FF, "GD" ],  // 121.51.213.0-121.51.213.255, GD
        [ 0x7933D600, 0x7933DDFF, "SH" ],  // 121.51.214.0-121.51.221.255, SH
        [ 0x7933DE00, 0x7933DFFF, "GD" ],  // 121.51.222.0-121.51.223.255, GD
        [ 0x7933E000, 0x7933E5FF, "TJ" ],  // 121.51.224.0-121.51.229.255, TJ
        [ 0x7933E600, 0x7933E7FF, "GD" ],  // 121.51.230.0-121.51.231.255, GD
        [ 0x7933E800, 0x7933EBFF, "TJ" ],  // 121.51.232.0-121.51.235.255, TJ
        [ 0x7933EC00, 0x7933EFFF, "GD" ],  // 121.51.236.0-121.51.239.255, GD
        [ 0x7933F000, 0x7933F9FF, "SH" ],  // 121.51.240.0-121.51.249.255, SH
        [ 0x7933FA00, 0x7933FFFF, "GD" ],  // 121.51.250.0-121.51.255.255, GD
        [ 0x7934A000, 0x7934BFFF, "BJ" ],  // 121.52.160.0-121.52.191.255, BJ
        [ 0x7934D000, 0x7934DFFF, "BJ" ],  // 121.52.208.0-121.52.223.255, BJ
        [ 0x7934E000, 0x7934FFFF, "ZJ" ],  // 121.52.224.0-121.52.255.255, ZJ
        [ 0x7936B000, 0x7936B7FF, "GD" ],  // 121.54.176.0-121.54.183.255, GD
        [ 0x79370000, 0x79373FFF, "SH" ],  // 121.55.0.0-121.55.63.255, SH
        [ 0x79380000, 0x7939FFFF, "NM" ],  // 121.56.0.0-121.57.255.255, NM
        [ 0x793A0000, 0x793A7FFF, "HI" ],  // 121.58.0.0-121.58.127.255, HI
        [ 0x793A8800, 0x793A8FFF, "GD" ],  // 121.58.136.0-121.58.143.255, GD
        [ 0x793A9000, 0x793A9FFF, "BJ" ],  // 121.58.144.0-121.58.159.255, BJ
        [ 0x793AA000, 0x793AA7FF, "GD" ],  // 121.58.160.0-121.58.167.255, GD
        [ 0x793B0000, 0x793B10FF, "BJ" ],  // 121.59.0.0-121.59.16.255, BJ
        [ 0x793B1200, 0x793B1EFF, "BJ" ],  // 121.59.18.0-121.59.30.255, BJ
        [ 0x793B2300, 0x793B63FF, "BJ" ],  // 121.59.35.0-121.59.99.255, BJ
        [ 0x793B6A00, 0x793B79FF, "BJ" ],  // 121.59.106.0-121.59.121.255, BJ
        [ 0x793B7B00, 0x793B7BFF, "BJ" ],  // 121.59.123.0-121.59.123.255, BJ
        [ 0x793B7D00, 0x793B8BFF, "BJ" ],  // 121.59.125.0-121.59.139.255, BJ
        [ 0x793B8D00, 0x793BFFFF, "BJ" ],  // 121.59.141.0-121.59.255.255, BJ
        [ 0x793C0000, 0x793FFFFF, "HB" ],  // 121.60.0.0-121.63.255.255, HB
        [ 0x79440000, 0x7944FFFF, "GD" ],  // 121.68.0.0-121.68.255.255, GD
        [ 0x79450000, 0x7946D8FF, "BJ" ],  // 121.69.0.0-121.70.216.255, BJ
        [ 0x7946D900, 0x7946D9FF, "LN" ],  // 121.70.217.0-121.70.217.255, LN
        [ 0x7946DA00, 0x7947FFFF, "BJ" ],  // 121.70.218.0-121.71.255.255, BJ
        [ 0x794C0000, 0x794DFFFF, "SH" ],  // 121.76.0.0-121.77.255.255, SH
        [ 0x794F8000, 0x794FBFFF, "BJ" ],  // 121.79.128.0-121.79.191.255, BJ
        [ 0x79590000, 0x7959FFFF, "BJ" ],  // 121.89.0.0-121.89.255.255, BJ
        [ 0x795B6800, 0x795B6FFF, "GD" ],  // 121.91.104.0-121.91.111.255, GD
        [ 0x795BB000, 0x795BBFFF, "SH" ],  // 121.91.176.0-121.91.191.255, SH
        [ 0x79648000, 0x7964BFFF, "CQ" ],  // 121.100.128.0-121.100.191.255, CQ
        [ 0x7964C000, 0x7964FFFF, "BJ" ],  // 121.100.192.0-121.100.255.255, BJ
        [ 0x79650000, 0x79653FFF, "GD" ],  // 121.101.0.0-121.101.63.255, GD
        [ 0x7965D000, 0x7965DFFF, "BJ" ],  // 121.101.208.0-121.101.223.255, BJ
        [ 0x79C00000, 0x79C04FFF, "ZJ" ],  // 121.192.0.0-121.192.79.255, ZJ
        [ 0x79C05000, 0x79C07FFF, "SH" ],  // 121.192.80.0-121.192.127.255, SH
        [ 0x79C08000, 0x79C08AFF, "JX" ],  // 121.192.128.0-121.192.138.255, JX
        [ 0x79C08B00, 0x79C09FFF, "SH" ],  // 121.192.139.0-121.192.159.255, SH
        [ 0x79C0A000, 0x79C0FFFF, "FJ" ],  // 121.192.160.0-121.192.255.255, FJ
        [ 0x79C10000, 0x79C163FF, "NM" ],  // 121.193.0.0-121.193.99.255, NM
        [ 0x79C16400, 0x79C17FFF, "BJ" ],  // 121.193.100.0-121.193.127.255, BJ
        [ 0x79C18000, 0x79C1BFFF, "TJ" ],  // 121.193.128.0-121.193.191.255, TJ
        [ 0x79C1C000, 0x79C1FFFF, "HE" ],  // 121.193.192.0-121.193.255.255, HE
        [ 0x79C20000, 0x79C3BEFF, "BJ" ],  // 121.194.0.0-121.195.190.255, BJ
        [ 0x79C3BF00, 0x79C3BFFF, "TJ" ],  // 121.195.191.0-121.195.191.255, TJ
        [ 0x79C3C000, 0x79C3FFFF, "HE" ],  // 121.195.192.0-121.195.255.255, HE
        [ 0x79C40000, 0x79C5BFFF, "ZJ" ],  // 121.196.0.0-121.197.191.255, ZJ
        [ 0x79C5C000, 0x79C5DFFF, "SH" ],  // 121.197.192.0-121.197.223.255, SH
        [ 0x79C5E000, 0x79C7FFFF, "ZJ" ],  // 121.197.224.0-121.199.255.255, ZJ
        [ 0x79C8C000, 0x79C8C7FF, "GD" ],  // 121.200.192.0-121.200.199.255, GD
        [ 0x79C90000, 0x79C94BFF, "GD" ],  // 121.201.0.0-121.201.75.255, GD
        [ 0x79C94C00, 0x79C94C7F, "HL" ],  // 121.201.76.0-121.201.76.127, HL
        [ 0x79C94C80, 0x79C9FFFF, "GD" ],  // 121.201.76.128-121.201.255.255, GD
        [ 0x79CC0000, 0x79CFFFFF, "FJ" ],  // 121.204.0.0-121.207.255.255, FJ
        [ 0x79E00000, 0x79EFFFFF, "JS" ],  // 121.224.0.0-121.239.255.255, JS
        [ 0x79F80000, 0x79F97FFF, "JS" ],  // 121.248.0.0-121.249.127.255, JS
        [ 0x79F98000, 0x79F9EFFF, "SD" ],  // 121.249.128.0-121.249.239.255, SD
        [ 0x79F9F000, 0x79F9FFFF, "JS" ],  // 121.249.240.0-121.249.255.255, JS
        [ 0x79FA0000, 0x79FA5DFF, "SD" ],  // 121.250.0.0-121.250.93.255, SD
        [ 0x79FA5E00, 0x79FA5FFF, "JS" ],  // 121.250.94.0-121.250.95.255, JS
        [ 0x79FA6000, 0x79FAFFFF, "SD" ],  // 121.250.96.0-121.250.255.255, SD
        [ 0x79FB0000, 0x79FB7FFF, "AH" ],  // 121.251.0.0-121.251.127.255, AH
        [ 0x79FB8000, 0x79FBFFFF, "SD" ],  // 121.251.128.0-121.251.255.255, SD
        [ 0x79FF0000, 0x79FFFFFF, "AH" ],  // 121.255.0.0-121.255.255.255, AH
        [ 0x7A004000, 0x7A007FFF, "HE" ],  // 122.0.64.0-122.0.127.255, HE
        [ 0x7A008000, 0x7A00FFFF, "SH" ],  // 122.0.128.0-122.0.255.255, SH
        [ 0x7A040000, 0x7A07FFFF, "SD" ],  // 122.4.0.0-122.7.255.255, SD
        [ 0x7A080000, 0x7A0800FF, "SH" ],  // 122.8.0.0-122.8.0.255, SH
        [ 0x7A080100, 0x7A0801FF, "SD" ],  // 122.8.1.0-122.8.1.255, SD
        [ 0x7A080200, 0x7A0807FF, "BJ" ],  // 122.8.2.0-122.8.7.255, BJ
        [ 0x7A080900, 0x7A080D00, "BJ" ],  // 122.8.9.0-122.8.13.0, BJ
        [ 0x7A080E00, 0x7A080E00, "BJ" ],  // 122.8.14.0-122.8.14.0, BJ
        [ 0x7A081700, 0x7A0817FF, "SH" ],  // 122.8.23.0-122.8.23.255, SH
        [ 0x7A082C00, 0x7A082CFF, "BJ" ],  // 122.8.44.0-122.8.44.255, BJ
        [ 0x7A083800, 0x7A0838FF, "BJ" ],  // 122.8.56.0-122.8.56.255, BJ
        [ 0x7A083E00, 0x7A083EFF, "BJ" ],  // 122.8.62.0-122.8.62.255, BJ
        [ 0x7A084800, 0x7A084BFF, "BJ" ],  // 122.8.72.0-122.8.75.255, BJ
        [ 0x7A085400, 0x7A0855FF, "BJ" ],  // 122.8.84.0-122.8.85.255, BJ
        [ 0x7A085900, 0x7A085AFF, "BJ" ],  // 122.8.89.0-122.8.90.255, BJ
        [ 0x7A085C00, 0x7A085FFF, "BJ" ],  // 122.8.92.0-122.8.95.255, BJ
        [ 0x7A087400, 0x7A0877FF, "BJ" ],  // 122.8.116.0-122.8.119.255, BJ
        [ 0x7A08C000, 0x7A092FFF, "BJ" ],  // 122.8.192.0-122.9.47.255, BJ
        [ 0x7A093000, 0x7A093FFF, "GD" ],  // 122.9.48.0-122.9.63.255, GD
        [ 0x7A094000, 0x7A095FFF, "SH" ],  // 122.9.64.0-122.9.95.255, SH
        [ 0x7A096000, 0x7A097FFF, "GD" ],  // 122.9.96.0-122.9.127.255, GD
        [ 0x7A098000, 0x7A09AFFF, "GZ" ],  // 122.9.128.0-122.9.175.255, GZ
        [ 0x7A09B000, 0x7A09BFFF, "SH" ],  // 122.9.176.0-122.9.191.255, SH
        [ 0x7A09C000, 0x7A09DFFF, "GD" ],  // 122.9.192.0-122.9.223.255, GD
        [ 0x7A09E000, 0x7A09EBFF, "SH" ],  // 122.9.224.0-122.9.235.255, SH
        [ 0x7A09EC00, 0x7A09EFFF, "SC" ],  // 122.9.236.0-122.9.239.255, SC
        [ 0x7A09F000, 0x7A09F3FF, "JS" ],  // 122.9.240.0-122.9.243.255, JS
        [ 0x7A09F400, 0x7A09F9FF, "SN" ],  // 122.9.244.0-122.9.249.255, SN
        [ 0x7A09FA00, 0x7A09FBFF, "ZJ" ],  // 122.9.250.0-122.9.251.255, ZJ
        [ 0x7A09FC00, 0x7A09FFFF, "HB" ],  // 122.9.252.0-122.9.255.255, HB
        [ 0x7A0A8400, 0x7A0A85FF, "BJ" ],  // 122.10.132.0-122.10.133.255, BJ
        [ 0x7A0A8800, 0x7A0A89FF, "BJ" ],  // 122.10.136.0-122.10.137.255, BJ
        [ 0x7A0AA400, 0x7A0AC3FF, "BJ" ],  // 122.10.164.0-122.10.195.255, BJ
        [ 0x7A0AC800, 0x7A0ADBFF, "BJ" ],  // 122.10.200.0-122.10.219.255, BJ
        [ 0x7A0AE400, 0x7A0AF3FF, "BJ" ],  // 122.10.228.0-122.10.243.255, BJ
        [ 0x7A0B0000, 0x7A0B1FFF, "GX" ],  // 122.11.0.0-122.11.31.255, GX
        [ 0x7A0B2000, 0x7A0B3FFF, "BJ" ],  // 122.11.32.0-122.11.63.255, BJ
        [ 0x7A0B4000, 0x7A0B7FFF, "GX" ],  // 122.11.64.0-122.11.127.255, GX
        [ 0x7A0C0000, 0x7A0CFFFF, "BJ" ],  // 122.12.0.0-122.12.255.255, BJ
        [ 0x7A0D0000, 0x7A0DFFFF, "GD" ],  // 122.13.0.0-122.13.255.255, GD
        [ 0x7A0E0000, 0x7A0E80FF, "BJ" ],  // 122.14.0.0-122.14.128.255, BJ
        [ 0x7A0E8100, 0x7A0E8AFF, "GD" ],  // 122.14.129.0-122.14.138.255, GD
        [ 0x7A0E8B00, 0x7A0E8DFF, "BJ" ],  // 122.14.139.0-122.14.141.255, BJ
        [ 0x7A0E8E00, 0x7A0E9FFF, "GD" ],  // 122.14.142.0-122.14.159.255, GD
        [ 0x7A0EA000, 0x7A0EFFFF, "BJ" ],  // 122.14.160.0-122.14.255.255, BJ
        [ 0x7A300000, 0x7A300FFF, "BJ" ],  // 122.48.0.0-122.48.15.255, BJ
        [ 0x7A301000, 0x7A301FFF, "HN" ],  // 122.48.16.0-122.48.31.255, HN
        [ 0x7A302000, 0x7A304FFF, "BJ" ],  // 122.48.32.0-122.48.79.255, BJ
        [ 0x7A305000, 0x7A305FFF, "HN" ],  // 122.48.80.0-122.48.95.255, HN
        [ 0x7A306000, 0x7A307FFF, "BJ" ],  // 122.48.96.0-122.48.127.255, BJ
        [ 0x7A308000, 0x7A308FFF, "GD" ],  // 122.48.128.0-122.48.143.255, GD
        [ 0x7A309000, 0x7A309FFF, "FJ" ],  // 122.48.144.0-122.48.159.255, FJ
        [ 0x7A30A000, 0x7A30AFFF, "BJ" ],  // 122.48.160.0-122.48.175.255, BJ
        [ 0x7A30B000, 0x7A30BFFF, "FJ" ],  // 122.48.176.0-122.48.191.255, FJ
        [ 0x7A30C000, 0x7A30FFFF, "HN" ],  // 122.48.192.0-122.48.255.255, HN
        [ 0x7A310000, 0x7A313FFF, "BJ" ],  // 122.49.0.0-122.49.63.255, BJ
        [ 0x7A330000, 0x7A33FFFF, "SH" ],  // 122.51.0.0-122.51.255.255, SH
        [ 0x7A400000, 0x7A41FFFF, "HL" ],  // 122.64.0.0-122.65.255.255, HL
        [ 0x7A420000, 0x7A44FFFF, "LN" ],  // 122.66.0.0-122.68.255.255, LN
        [ 0x7A450000, 0x7A45FFFF, "JL" ],  // 122.69.0.0-122.69.255.255, JL
        [ 0x7A460000, 0x7A4803FF, "BJ" ],  // 122.70.0.0-122.72.3.255, BJ
        [ 0x7A480400, 0x7A4805FF, "LN" ],  // 122.72.4.0-122.72.5.255, LN
        [ 0x7A480600, 0x7A4807FF, "SH" ],  // 122.72.6.0-122.72.7.255, SH
        [ 0x7A480800, 0x7A4809FF, "JS" ],  // 122.72.8.0-122.72.9.255, JS
        [ 0x7A480A00, 0x7A480BFF, "HB" ],  // 122.72.10.0-122.72.11.255, HB
        [ 0x7A480C00, 0x7A480DFF, "GD" ],  // 122.72.12.0-122.72.13.255, GD
        [ 0x7A480E00, 0x7A480FFF, "SC" ],  // 122.72.14.0-122.72.15.255, SC
        [ 0x7A481000, 0x7A4810FF, "BJ" ],  // 122.72.16.0-122.72.16.255, BJ
        [ 0x7A481100, 0x7A4811FF, "HE" ],  // 122.72.17.0-122.72.17.255, HE
        [ 0x7A481200, 0x7A4812FF, "SX" ],  // 122.72.18.0-122.72.18.255, SX
        [ 0x7A481300, 0x7A4813FF, "NM" ],  // 122.72.19.0-122.72.19.255, NM
        [ 0x7A481400, 0x7A4814FF, "JL" ],  // 122.72.20.0-122.72.20.255, JL
        [ 0x7A481500, 0x7A4815FF, "HL" ],  // 122.72.21.0-122.72.21.255, HL
        [ 0x7A481600, 0x7A4816FF, "ZJ" ],  // 122.72.22.0-122.72.22.255, ZJ
        [ 0x7A481700, 0x7A4817FF, "AH" ],  // 122.72.23.0-122.72.23.255, AH
        [ 0x7A481800, 0x7A4818FF, "FJ" ],  // 122.72.24.0-122.72.24.255, FJ
        [ 0x7A481900, 0x7A4819FF, "JX" ],  // 122.72.25.0-122.72.25.255, JX
        [ 0x7A481A00, 0x7A481AFF, "SD" ],  // 122.72.26.0-122.72.26.255, SD
        [ 0x7A481B00, 0x7A481BFF, "HA" ],  // 122.72.27.0-122.72.27.255, HA
        [ 0x7A481C00, 0x7A481CFF, "HN" ],  // 122.72.28.0-122.72.28.255, HN
        [ 0x7A481D00, 0x7A481DFF, "GX" ],  // 122.72.29.0-122.72.29.255, GX
        [ 0x7A481E00, 0x7A481EFF, "SN" ],  // 122.72.30.0-122.72.30.255, SN
        [ 0x7A481F00, 0x7A481FFF, "TJ" ],  // 122.72.31.0-122.72.31.255, TJ
        [ 0x7A482000, 0x7A4820FF, "CQ" ],  // 122.72.32.0-122.72.32.255, CQ
        [ 0x7A482100, 0x7A48217F, "YN" ],  // 122.72.33.0-122.72.33.127, YN
        [ 0x7A482180, 0x7A4821FF, "GS" ],  // 122.72.33.128-122.72.33.255, GS
        [ 0x7A482200, 0x7A4822FF, "NX" ],  // 122.72.34.0-122.72.34.255, NX
        [ 0x7A482300, 0x7A4823FF, "ZJ" ],  // 122.72.35.0-122.72.35.255, ZJ
        [ 0x7A482400, 0x7A4824FF, "FJ" ],  // 122.72.36.0-122.72.36.255, FJ
        [ 0x7A482500, 0x7A4825FF, "TJ" ],  // 122.72.37.0-122.72.37.255, TJ
        [ 0x7A482600, 0x7A4827FF, "BJ" ],  // 122.72.38.0-122.72.39.255, BJ
        [ 0x7A482800, 0x7A482AFF, "HE" ],  // 122.72.40.0-122.72.42.255, HE
        [ 0x7A482B00, 0x7A482BFF, "SX" ],  // 122.72.43.0-122.72.43.255, SX
        [ 0x7A482C00, 0x7A482FFF, "NM" ],  // 122.72.44.0-122.72.47.255, NM
        [ 0x7A483000, 0x7A4833FF, "LN" ],  // 122.72.48.0-122.72.51.255, LN
        [ 0x7A483400, 0x7A4837FF, "JL" ],  // 122.72.52.0-122.72.55.255, JL
        [ 0x7A483800, 0x7A483BFF, "HL" ],  // 122.72.56.0-122.72.59.255, HL
        [ 0x7A483C00, 0x7A483DFF, "SH" ],  // 122.72.60.0-122.72.61.255, SH
        [ 0x7A483E00, 0x7A483FFF, "AH" ],  // 122.72.62.0-122.72.63.255, AH
        [ 0x7A484000, 0x7A4843FF, "JS" ],  // 122.72.64.0-122.72.67.255, JS
        [ 0x7A484400, 0x7A4847FF, "ZJ" ],  // 122.72.68.0-122.72.71.255, ZJ
        [ 0x7A484800, 0x7A484BFF, "FJ" ],  // 122.72.72.0-122.72.75.255, FJ
        [ 0x7A484C00, 0x7A484FFF, "SD" ],  // 122.72.76.0-122.72.79.255, SD
        [ 0x7A485000, 0x7A4851FF, "JX" ],  // 122.72.80.0-122.72.81.255, JX
        [ 0x7A485200, 0x7A4853FF, "HA" ],  // 122.72.82.0-122.72.83.255, HA
        [ 0x7A485400, 0x7A4857FF, "HB" ],  // 122.72.84.0-122.72.87.255, HB
        [ 0x7A485800, 0x7A485BFF, "HN" ],  // 122.72.88.0-122.72.91.255, HN
        [ 0x7A485C00, 0x7A485FFF, "GD" ],  // 122.72.92.0-122.72.95.255, GD
        [ 0x7A486000, 0x7A4861FF, "GX" ],  // 122.72.96.0-122.72.97.255, GX
        [ 0x7A486200, 0x7A4862FF, "HI" ],  // 122.72.98.0-122.72.98.255, HI
        [ 0x7A486300, 0x7A4863FF, "CQ" ],  // 122.72.99.0-122.72.99.255, CQ
        [ 0x7A486400, 0x7A4865FF, "SC" ],  // 122.72.100.0-122.72.101.255, SC
        [ 0x7A486600, 0x7A4867FF, "YN" ],  // 122.72.102.0-122.72.103.255, YN
        [ 0x7A486800, 0x7A4869FF, "SN" ],  // 122.72.104.0-122.72.105.255, SN
        [ 0x7A486A00, 0x7A486BFF, "GS" ],  // 122.72.106.0-122.72.107.255, GS
        [ 0x7A486C00, 0x7A486CFF, "QH" ],  // 122.72.108.0-122.72.108.255, QH
        [ 0x7A486D00, 0x7A486DFF, "GZ" ],  // 122.72.109.0-122.72.109.255, GZ
        [ 0x7A486E00, 0x7A486EFF, "NX" ],  // 122.72.110.0-122.72.110.255, NX
        [ 0x7A486F00, 0x7A486FFF, "XJ" ],  // 122.72.111.0-122.72.111.255, XJ
        [ 0x7A487000, 0x7A4873FF, "BJ" ],  // 122.72.112.0-122.72.115.255, BJ
        [ 0x7A487400, 0x7A4874FF, "GX" ],  // 122.72.116.0-122.72.116.255, GX
        [ 0x7A487500, 0x7A4877FF, "BJ" ],  // 122.72.117.0-122.72.119.255, BJ
        [ 0x7A487800, 0x7A487AFF, "SH" ],  // 122.72.120.0-122.72.122.255, SH
        [ 0x7A487B00, 0x7A487BFF, "HN" ],  // 122.72.123.0-122.72.123.255, HN
        [ 0x7A487C00, 0x7A48FFFF, "GD" ],  // 122.72.124.0-122.72.255.255, GD
        [ 0x7A490000, 0x7A49FFFF, "CQ" ],  // 122.73.0.0-122.73.255.255, CQ
        [ 0x7A4A0000, 0x7A4BFFFF, "HE" ],  // 122.74.0.0-122.75.255.255, HE
        [ 0x7A4C0000, 0x7A4CFFFF, "NM" ],  // 122.76.0.0-122.76.255.255, NM
        [ 0x7A4D0000, 0x7A4DFFFF, "SN" ],  // 122.77.0.0-122.77.255.255, SN
        [ 0x7A4E0000, 0x7A4FFFFF, "HA" ],  // 122.78.0.0-122.79.255.255, HA
        [ 0x7A500000, 0x7A51FFFF, "SD" ],  // 122.80.0.0-122.81.255.255, SD
        [ 0x7A520000, 0x7A52FFFF, "HB" ],  // 122.82.0.0-122.82.255.255, HB
        [ 0x7A530000, 0x7A53FFFF, "AH" ],  // 122.83.0.0-122.83.255.255, AH
        [ 0x7A540000, 0x7A54FFFF, "SH" ],  // 122.84.0.0-122.84.255.255, SH
        [ 0x7A550000, 0x7A57FFFF, "ZJ" ],  // 122.85.0.0-122.87.255.255, ZJ
        [ 0x7A580000, 0x7A59FFFF, "JS" ],  // 122.88.0.0-122.89.255.255, JS
        [ 0x7A5A0000, 0x7A5BFFFF, "FJ" ],  // 122.90.0.0-122.91.255.255, FJ
        [ 0x7A5C0000, 0x7A5CFFFF, "AH" ],  // 122.92.0.0-122.92.255.255, AH
        [ 0x7A5D0000, 0x7A5DFFFF, "JX" ],  // 122.93.0.0-122.93.255.255, JX
        [ 0x7A5E0000, 0x7A61ADFF, "JS" ],  // 122.94.0.0-122.97.173.255, JS
        [ 0x7A61AE00, 0x7A61AFFF, "HB" ],  // 122.97.174.0-122.97.175.255, HB
        [ 0x7A61B000, 0x7A61FFFF, "JS" ],  // 122.97.176.0-122.97.255.255, JS
        [ 0x7A660000, 0x7A660FFF, "BJ" ],  // 122.102.0.0-122.102.15.255, BJ
        [ 0x7A664000, 0x7A664FFF, "JS" ],  // 122.102.64.0-122.102.79.255, JS
        [ 0x7A665000, 0x7A665FFF, "BJ" ],  // 122.102.80.0-122.102.95.255, BJ
        [ 0x7A700000, 0x7A705FFF, "BJ" ],  // 122.112.0.0-122.112.95.255, BJ
        [ 0x7A706000, 0x7A707FFF, "GD" ],  // 122.112.96.0-122.112.127.255, GD
        [ 0x7A708000, 0x7A70FFFF, "SH" ],  // 122.112.128.0-122.112.255.255, SH
        [ 0x7A710000, 0x7A71FFFF, "BJ" ],  // 122.113.0.0-122.113.255.255, BJ
        [ 0x7A720000, 0x7A72FFFF, "HA" ],  // 122.114.0.0-122.114.255.255, HA
        [ 0x7A730000, 0x7A733FFF, "BJ" ],  // 122.115.0.0-122.115.63.255, BJ
        [ 0x7A734200, 0x7A7343FF, "BJ" ],  // 122.115.66.0-122.115.67.255, BJ
        [ 0x7A734600, 0x7A734BFF, "BJ" ],  // 122.115.70.0-122.115.75.255, BJ
        [ 0x7A735000, 0x7A73FFFF, "BJ" ],  // 122.115.80.0-122.115.255.255, BJ
        [ 0x7A770000, 0x7A7749FF, "BJ" ],  // 122.119.0.0-122.119.73.255, BJ
        [ 0x7A774A00, 0x7A774AFF, "SH" ],  // 122.119.74.0-122.119.74.255, SH
        [ 0x7A774B00, 0x7A77FFFF, "BJ" ],  // 122.119.75.0-122.119.255.255, BJ
        [ 0x7A806400, 0x7A8067FF, "LN" ],  // 122.128.100.0-122.128.103.255, LN
        [ 0x7A807800, 0x7A807FFF, "GD" ],  // 122.128.120.0-122.128.127.255, GD
        [ 0x7A880000, 0x7A8FFFFF, "JL" ],  // 122.136.0.0-122.143.255.255, JL
        [ 0x7A908000, 0x7A90FFFF, "SH" ],  // 122.144.128.0-122.144.255.255, SH
        [ 0x7A98C000, 0x7A98DDFF, "SH" ],  // 122.152.192.0-122.152.221.255, SH
        [ 0x7A98DE00, 0x7A98FFFF, "GD" ],  // 122.152.222.0-122.152.255.255, GD
        [ 0x7A9C0000, 0x7A9FFFFF, "HL" ],  // 122.156.0.0-122.159.255.255, HL
        [ 0x7ABC0000, 0x7ABFFFFF, "HB" ],  // 122.188.0.0-122.191.255.255, HB
        [ 0x7AC00000, 0x7AC3FFFF, "JS" ],  // 122.192.0.0-122.195.255.255, JS
        [ 0x7AC60000, 0x7AC63FFF, "GD" ],  // 122.198.0.0-122.198.63.255, GD
        [ 0x7AC64000, 0x7AC643FF, "ZJ" ],  // 122.198.64.0-122.198.67.255, ZJ
        [ 0x7AC64400, 0x7AC67FFF, "HE" ],  // 122.198.68.0-122.198.127.255, HE
        [ 0x7AC68000, 0x7AC6FFFF, "GD" ],  // 122.198.128.0-122.198.255.255, GD
        [ 0x7AC82800, 0x7AC82BFF, "BJ" ],  // 122.200.40.0-122.200.43.255, BJ
        [ 0x7AC82C00, 0x7AC82FFF, "HN" ],  // 122.200.44.0-122.200.47.255, HN
        [ 0x7AC84000, 0x7AC87FFF, "BJ" ],  // 122.200.64.0-122.200.127.255, BJ
        [ 0x7AC93000, 0x7AC93FFF, "BJ" ],  // 122.201.48.0-122.201.63.255, BJ
        [ 0x7ACC0000, 0x7ACDFFFF, "HB" ],  // 122.204.0.0-122.205.255.255, HB
        [ 0x7ACE0000, 0x7ACEFFFF, "HA" ],  // 122.206.0.0-122.206.255.255, HA
        [ 0x7ACF0000, 0x7ACF7FFF, "HN" ],  // 122.207.0.0-122.207.127.255, HN
        [ 0x7ACF8000, 0x7ACFDFFF, "HA" ],  // 122.207.128.0-122.207.223.255, HA
        [ 0x7ACFE000, 0x7ACFFFFF, "HB" ],  // 122.207.224.0-122.207.255.255, HB
        [ 0x7AE00000, 0x7AF7FFFF, "ZJ" ],  // 122.224.0.0-122.247.255.255, ZJ
        [ 0x7AF81800, 0x7AF81FFF, "GD" ],  // 122.248.24.0-122.248.31.255, GD
        [ 0x7AF83000, 0x7AF83BFF, "JS" ],  // 122.248.48.0-122.248.59.255, JS
        [ 0x7AF83C00, 0x7AF83FFF, "JL" ],  // 122.248.60.0-122.248.63.255, JL
        [ 0x7AFF4000, 0x7AFF47FF, "GD" ],  // 122.255.64.0-122.255.71.255, GD
        [ 0x7B008000, 0x7B00BFFF, "SH" ],  // 123.0.128.0-123.0.191.255, SH
        [ 0x7B040000, 0x7B0FFFFF, "HA" ],  // 123.4.0.0-123.15.255.255, HA
        [ 0x7B318000, 0x7B3181FF, "SH" ],  // 123.49.128.0-123.49.129.255, SH
        [ 0x7B318200, 0x7B3182FF, "BJ" ],  // 123.49.130.0-123.49.130.255, BJ
        [ 0x7B318300, 0x7B3187FF, "SH" ],  // 123.49.131.0-123.49.135.255, SH
        [ 0x7B318800, 0x7B318BFF, "BJ" ],  // 123.49.136.0-123.49.139.255, BJ
        [ 0x7B318C00, 0x7B3197FF, "SH" ],  // 123.49.140.0-123.49.151.255, SH
        [ 0x7B319800, 0x7B319FFF, "BJ" ],  // 123.49.152.0-123.49.159.255, BJ
        [ 0x7B31A000, 0x7B31EFFF, "GD" ],  // 123.49.160.0-123.49.239.255, GD
        [ 0x7B31F000, 0x7B31FFFF, "SH" ],  // 123.49.240.0-123.49.255.255, SH
        [ 0x7B32A000, 0x7B32BFFF, "GD" ],  // 123.50.160.0-123.50.191.255, GD
        [ 0x7B340000, 0x7B37FFFF, "HA" ],  // 123.52.0.0-123.55.255.255, HA
        [ 0x7B380000, 0x7B39FFFF, "BJ" ],  // 123.56.0.0-123.57.255.255, BJ
        [ 0x7B3A0000, 0x7B3A0FFF, "HE" ],  // 123.58.0.0-123.58.15.255, HE
        [ 0x7B3A1000, 0x7B3A1FFF, "BJ" ],  // 123.58.16.0-123.58.31.255, BJ
        [ 0x7B3A2000, 0x7B3A5FFF, "GD" ],  // 123.58.32.0-123.58.95.255, GD
        [ 0x7B3A6000, 0x7B3A6FFF, "HE" ],  // 123.58.96.0-123.58.111.255, HE
        [ 0x7B3A7000, 0x7B3A77FF, "BJ" ],  // 123.58.112.0-123.58.119.255, BJ
        [ 0x7B3A7800, 0x7B3A7FFF, "HE" ],  // 123.58.120.0-123.58.127.255, HE
        [ 0x7B3A8000, 0x7B3ABFFF, "ZJ" ],  // 123.58.128.0-123.58.191.255, ZJ
        [ 0x7B3AE000, 0x7B3BFFFF, "BJ" ],  // 123.58.224.0-123.59.255.255, BJ
        [ 0x7B3C0000, 0x7B3CFFFF, "SH" ],  // 123.60.0.0-123.60.255.255, SH
        [ 0x7B3D0000, 0x7B3DFFFF, "GD" ],  // 123.61.0.0-123.61.255.255, GD
        [ 0x7B3E0000, 0x7B3EFFFF, "BJ" ],  // 123.62.0.0-123.62.255.255, BJ
        [ 0x7B400000, 0x7B427FFF, "GD" ],  // 123.64.0.0-123.66.127.255, GD
        [ 0x7B428000, 0x7B42FFFF, "BJ" ],  // 123.66.128.0-123.66.255.255, BJ
        [ 0x7B430000, 0x7B43FFFF, "GX" ],  // 123.67.0.0-123.67.255.255, GX
        [ 0x7B440000, 0x7B45FFFF, "HN" ],  // 123.68.0.0-123.69.255.255, HN
        [ 0x7B460000, 0x7B47FFFF, "SC" ],  // 123.70.0.0-123.71.255.255, SC
        [ 0x7B480000, 0x7B48FFFF, "JS" ],  // 123.72.0.0-123.72.255.255, JS
        [ 0x7B490000, 0x7B49FFFF, "SX" ],  // 123.73.0.0-123.73.255.255, SX
        [ 0x7B4A0000, 0x7B4A7FFF, "YN" ],  // 123.74.0.0-123.74.127.255, YN
        [ 0x7B4A8000, 0x7B4AFFFF, "ZJ" ],  // 123.74.128.0-123.74.255.255, ZJ
        [ 0x7B4B0000, 0x7B4BFFFF, "JX" ],  // 123.75.0.0-123.75.255.255, JX
        [ 0x7B4C0000, 0x7B4CFFFF, "JL" ],  // 123.76.0.0-123.76.255.255, JL
        [ 0x7B4D0000, 0x7B4DFFFF, "JS" ],  // 123.77.0.0-123.77.255.255, JS
        [ 0x7B4E0000, 0x7B4EFFFF, "JL" ],  // 123.78.0.0-123.78.255.255, JL
        [ 0x7B4F0000, 0x7B4FFFFF, "GX" ],  // 123.79.0.0-123.79.255.255, GX
        [ 0x7B500000, 0x7B50FFFF, "XJ" ],  // 123.80.0.0-123.80.255.255, XJ
        [ 0x7B510000, 0x7B51FFFF, "GS" ],  // 123.81.0.0-123.81.255.255, GS
        [ 0x7B520000, 0x7B52FFFF, "FJ" ],  // 123.82.0.0-123.82.255.255, FJ
        [ 0x7B530000, 0x7B53FFFF, "HL" ],  // 123.83.0.0-123.83.255.255, HL
        [ 0x7B540000, 0x7B54FFFF, "HN" ],  // 123.84.0.0-123.84.255.255, HN
        [ 0x7B550000, 0x7B55FFFF, "HB" ],  // 123.85.0.0-123.85.255.255, HB
        [ 0x7B560000, 0x7B57FFFF, "YN" ],  // 123.86.0.0-123.87.255.255, YN
        [ 0x7B580000, 0x7B59FFFF, "GD" ],  // 123.88.0.0-123.89.255.255, GD
        [ 0x7B5A0000, 0x7B5CFFFF, "LN" ],  // 123.90.0.0-123.92.255.255, LN
        [ 0x7B5D0000, 0x7B5DFFFF, "SD" ],  // 123.93.0.0-123.93.255.255, SD
        [ 0x7B5E0000, 0x7B5E02FF, "BJ" ],  // 123.94.0.0-123.94.2.255, BJ
        [ 0x7B5E0300, 0x7B5E03FF, "HB" ],  // 123.94.3.0-123.94.3.255, HB
        [ 0x7B5E0400, 0x7B5E04FF, "BJ" ],  // 123.94.4.0-123.94.4.255, BJ
        [ 0x7B5E0500, 0x7B5E05FF, "TJ" ],  // 123.94.5.0-123.94.5.255, TJ
        [ 0x7B5E0600, 0x7B5E06FF, "HE" ],  // 123.94.6.0-123.94.6.255, HE
        [ 0x7B5E0700, 0x7B5E07FF, "JX" ],  // 123.94.7.0-123.94.7.255, JX
        [ 0x7B5E0800, 0x7B5E08FF, "LN" ],  // 123.94.8.0-123.94.8.255, LN
        [ 0x7B5E0900, 0x7B5E09FF, "JL" ],  // 123.94.9.0-123.94.9.255, JL
        [ 0x7B5E0A00, 0x7B5E0AFF, "HL" ],  // 123.94.10.0-123.94.10.255, HL
        [ 0x7B5E0B00, 0x7B5E0BFF, "SH" ],  // 123.94.11.0-123.94.11.255, SH
        [ 0x7B5E0C00, 0x7B5E0CFF, "JS" ],  // 123.94.12.0-123.94.12.255, JS
        [ 0x7B5E0D00, 0x7B5E0DFF, "ZJ" ],  // 123.94.13.0-123.94.13.255, ZJ
        [ 0x7B5E0E00, 0x7B5E0EFF, "AH" ],  // 123.94.14.0-123.94.14.255, AH
        [ 0x7B5E0F00, 0x7B5E0FFF, "FJ" ],  // 123.94.15.0-123.94.15.255, FJ
        [ 0x7B5E1000, 0x7B5E10FF, "SD" ],  // 123.94.16.0-123.94.16.255, SD
        [ 0x7B5E1100, 0x7B5E11FF, "HA" ],  // 123.94.17.0-123.94.17.255, HA
        [ 0x7B5E1200, 0x7B5E12FF, "HB" ],  // 123.94.18.0-123.94.18.255, HB
        [ 0x7B5E1300, 0x7B5E13FF, "HN" ],  // 123.94.19.0-123.94.19.255, HN
        [ 0x7B5E1400, 0x7B5E14FF, "GD" ],  // 123.94.20.0-123.94.20.255, GD
        [ 0x7B5E1500, 0x7B5E15FF, "GX" ],  // 123.94.21.0-123.94.21.255, GX
        [ 0x7B5E1600, 0x7B5E163F, "HI" ],  // 123.94.22.0-123.94.22.63, HI
        [ 0x7B5E1640, 0x7B5E167F, "GS" ],  // 123.94.22.64-123.94.22.127, GS
        [ 0x7B5E1680, 0x7B5E16BF, "QH" ],  // 123.94.22.128-123.94.22.191, QH
        [ 0x7B5E16C0, 0x7B5E16FF, "NX" ],  // 123.94.22.192-123.94.22.255, NX
        [ 0x7B5E1700, 0x7B5E177F, "CQ" ],  // 123.94.23.0-123.94.23.127, CQ
        [ 0x7B5E1780, 0x7B5E17FF, "XJ" ],  // 123.94.23.128-123.94.23.255, XJ
        [ 0x7B5E1800, 0x7B5E18FF, "SC" ],  // 123.94.24.0-123.94.24.255, SC
        [ 0x7B5E1900, 0x7B5E19FF, "GZ" ],  // 123.94.25.0-123.94.25.255, GZ
        [ 0x7B5E1A00, 0x7B5E1AFF, "SN" ],  // 123.94.26.0-123.94.26.255, SN
        [ 0x7B5E1B00, 0x7B5EFFFF, "BJ" ],  // 123.94.27.0-123.94.255.255, BJ
        [ 0x7B5F0000, 0x7B5F7FFF, "HI" ],  // 123.95.0.0-123.95.127.255, HI
        [ 0x7B5F8000, 0x7B5FFFFF, "XJ" ],  // 123.95.128.0-123.95.255.255, XJ
        [ 0x7B600000, 0x7B61FFFF, "ZJ" ],  // 123.96.0.0-123.97.255.255, ZJ
        [ 0x7B620000, 0x7B627FFF, "GD" ],  // 123.98.0.0-123.98.127.255, GD
        [ 0x7B638000, 0x7B63FFFF, "ZJ" ],  // 123.99.128.0-123.99.255.255, ZJ
        [ 0x7B640000, 0x7B641FFF, "GD" ],  // 123.100.0.0-123.100.31.255, GD
        [ 0x7B650000, 0x7B65FFFF, "HA" ],  // 123.101.0.0-123.101.255.255, HA
        [ 0x7B670000, 0x7B6701FF, "SN" ],  // 123.103.0.0-123.103.1.255, SN
        [ 0x7B670200, 0x7B677FFF, "BJ" ],  // 123.103.2.0-123.103.127.255, BJ
        [ 0x7B6C5800, 0x7B6C58FF, "UNK" ],  // 123.108.88.0-123.108.88.255, UNK
        [ 0x7B6C5900, 0x7B6C59FF, "GD" ],  // 123.108.89.0-123.108.89.255, GD
        [ 0x7B6C8200, 0x7B6C8FFF, "BJ" ],  // 123.108.130.0-123.108.143.255, BJ
        [ 0x7B6CD000, 0x7B6CDFFF, "BJ" ],  // 123.108.208.0-123.108.223.255, BJ
        [ 0x7B700000, 0x7B7FFFFF, "BJ" ],  // 123.112.0.0-123.127.255.255, BJ
        [ 0x7B800000, 0x7B874EFF, "SD" ],  // 123.128.0.0-123.135.78.255, SD
        [ 0x7B874F00, 0x7B874FFF, "GD" ],  // 123.135.79.0-123.135.79.255, GD
        [ 0x7B875000, 0x7B87FFFF, "SD" ],  // 123.135.80.0-123.135.255.255, SD
        [ 0x7B885000, 0x7B885FFF, "SH" ],  // 123.136.80.0-123.136.95.255, SH
        [ 0x7B890000, 0x7B89FFFF, "ZJ" ],  // 123.137.0.0-123.137.255.255, ZJ
        [ 0x7B8A0000, 0x7B8AF1FF, "SN" ],  // 123.138.0.0-123.138.241.255, SN
        [ 0x7B8AF200, 0x7B8AF2FF, "GD" ],  // 123.138.242.0-123.138.242.255, GD
        [ 0x7B8AF300, 0x7B8BFFFF, "SN" ],  // 123.138.243.0-123.139.255.255, SN
        [ 0x7B900000, 0x7B93FFFF, "CQ" ],  // 123.144.0.0-123.147.255.255, CQ
        [ 0x7B940000, 0x7B94FFFF, "ZJ" ],  // 123.148.0.0-123.148.255.255, ZJ
        [ 0x7B950000, 0x7B95FFFF, "HA" ],  // 123.149.0.0-123.149.255.255, HA
        [ 0x7B960000, 0x7B97FFFF, "TJ" ],  // 123.150.0.0-123.151.255.255, TJ
        [ 0x7B980000, 0x7B9FFFFF, "ZJ" ],  // 123.152.0.0-123.159.255.255, ZJ
        [ 0x7BA00000, 0x7BA3FFFF, "HA" ],  // 123.160.0.0-123.163.255.255, HA
        [ 0x7BA40000, 0x7BA7FFFF, "HL" ],  // 123.164.0.0-123.167.255.255, HL
        [ 0x7BA80000, 0x7BABFFFF, "SD" ],  // 123.168.0.0-123.171.255.255, SD
        [ 0x7BAC0000, 0x7BADFFFF, "JL" ],  // 123.172.0.0-123.173.255.255, JL
        [ 0x7BAE0000, 0x7BAFFFFF, "SX" ],  // 123.174.0.0-123.175.255.255, SX
        [ 0x7BB03C00, 0x7BB03FFF, "BJ" ],  // 123.176.60.0-123.176.63.255, BJ
        [ 0x7BB05000, 0x7BB05FFF, "BJ" ],  // 123.176.80.0-123.176.95.255, BJ
        [ 0x7BB10000, 0x7BB1FFFF, "LN" ],  // 123.177.0.0-123.177.255.255, LN
        [ 0x7BB20000, 0x7BB3FFFF, "NM" ],  // 123.178.0.0-123.179.255.255, NM
        [ 0x7BB40000, 0x7BB7FFFF, "HE" ],  // 123.180.0.0-123.183.255.255, HE
        [ 0x7BB80000, 0x7BBFFFFF, "LN" ],  // 123.184.0.0-123.191.255.255, LN
        [ 0x7BC40000, 0x7BC43FFF, "SD" ],  // 123.196.0.0-123.196.63.255, SD
        [ 0x7BC44000, 0x7BC444FF, "FJ" ],  // 123.196.64.0-123.196.68.255, FJ
        [ 0x7BC44500, 0x7BC46FFF, "GD" ],  // 123.196.69.0-123.196.111.255, GD
        [ 0x7BC47000, 0x7BC47FFF, "BJ" ],  // 123.196.112.0-123.196.127.255, BJ
        [ 0x7BC48000, 0x7BC4FFFF, "HE" ],  // 123.196.128.0-123.196.255.255, HE
        [ 0x7BC50000, 0x7BC507FF, "GZ" ],  // 123.197.0.0-123.197.7.255, GZ
        [ 0x7BC50800, 0x7BC57FFF, "BJ" ],  // 123.197.8.0-123.197.127.255, BJ
        [ 0x7BC58000, 0x7BC5FFFF, "GD" ],  // 123.197.128.0-123.197.255.255, GD
        [ 0x7BC78000, 0x7BC7FFFF, "BJ" ],  // 123.199.128.0-123.199.255.255, BJ
        [ 0x7BCE0000, 0x7BCE60FF, "TJ" ],  // 123.206.0.0-123.206.96.255, TJ
        [ 0x7BCE6100, 0x7BCEE9FF, "SH" ],  // 123.206.97.0-123.206.233.255, SH
        [ 0x7BCEEA00, 0x7BCEEBFF, "TJ" ],  // 123.206.234.0-123.206.235.255, TJ
        [ 0x7BCEEC00, 0x7BCEF3FF, "SH" ],  // 123.206.236.0-123.206.243.255, SH
        [ 0x7BCEF400, 0x7BCEF7FF, "GD" ],  // 123.206.244.0-123.206.247.255, GD
        [ 0x7BCEF800, 0x7BCEFBFF, "SH" ],  // 123.206.248.0-123.206.251.255, SH
        [ 0x7BCEFC00, 0x7BCEFDFF, "GD" ],  // 123.206.252.0-123.206.253.255, GD
        [ 0x7BCEFE00, 0x7BCEFFFF, "TJ" ],  // 123.206.254.0-123.206.255.255, TJ
        [ 0x7BCF0000, 0x7BCF83FF, "GD" ],  // 123.207.0.0-123.207.131.255, GD
        [ 0x7BCF8400, 0x7BCF85FF, "SH" ],  // 123.207.132.0-123.207.133.255, SH
        [ 0x7BCF8600, 0x7BCFAFFF, "TJ" ],  // 123.207.134.0-123.207.175.255, TJ
        [ 0x7BCFB000, 0x7BCFCFFF, "SH" ],  // 123.207.176.0-123.207.207.255, SH
        [ 0x7BCFD000, 0x7BCFD1FF, "GD" ],  // 123.207.208.0-123.207.209.255, GD
        [ 0x7BCFD200, 0x7BCFE1FF, "SH" ],  // 123.207.210.0-123.207.225.255, SH
        [ 0x7BCFE200, 0x7BCFFFFF, "GD" ],  // 123.207.226.0-123.207.255.255, GD
        [ 0x7BE80000, 0x7BEBFFFF, "SD" ],  // 123.232.0.0-123.235.255.255, SD
        [ 0x7BF20000, 0x7BF27FFF, "GD" ],  // 123.242.0.0-123.242.127.255, GD
        [ 0x7BF2C000, 0x7BF2C3FF, "HN" ],  // 123.242.192.0-123.242.195.255, HN
        [ 0x7BF2C400, 0x7BF2C7FF, "SC" ],  // 123.242.196.0-123.242.199.255, SC
        [ 0x7BF40000, 0x7BF7FFFF, "LN" ],  // 123.244.0.0-123.247.255.255, LN
        [ 0x7BF90000, 0x7BF97FFF, "BJ" ],  // 123.249.0.0-123.249.127.255, BJ
        [ 0x7BF98000, 0x7BF9FFFF, "GD" ],  // 123.249.128.0-123.249.255.255, GD
        [ 0x7BFDF000, 0x7BFDF3FF, "SH" ],  // 123.253.240.0-123.253.243.255, SH
        [ 0x7BFE6000, 0x7BFE63FF, "YN" ],  // 123.254.96.0-123.254.99.255, YN
        [ 0x7BFE6400, 0x7BFE67FF, "BJ" ],  // 123.254.100.0-123.254.103.255, BJ
        [ 0x7C064000, 0x7C067FFF, "LN" ],  // 124.6.64.0-124.6.127.255, LN
        [ 0x7C0E0000, 0x7C0E3FFF, "SH" ],  // 124.14.0.0-124.14.63.255, SH
        [ 0x7C0E4000, 0x7C0E7FFF, "BJ" ],  // 124.14.64.0-124.14.127.255, BJ
        [ 0x7C0E8000, 0x7C0E9FFF, "SC" ],  // 124.14.128.0-124.14.159.255, SC
        [ 0x7C0EA000, 0x7C0EBFFF, "AH" ],  // 124.14.160.0-124.14.191.255, AH
        [ 0x7C0EC000, 0x7C0EDFFF, "GD" ],  // 124.14.192.0-124.14.223.255, GD
        [ 0x7C0EE000, 0x7C0EFFFF, "BJ" ],  // 124.14.224.0-124.14.255.255, BJ
        [ 0x7C0F0000, 0x7C0F3FFF, "HB" ],  // 124.15.0.0-124.15.63.255, HB
        [ 0x7C0F4000, 0x7C0F7FFF, "GD" ],  // 124.15.64.0-124.15.127.255, GD
        [ 0x7C0F8000, 0x7C0FB7FF, "FJ" ],  // 124.15.128.0-124.15.183.255, FJ
        [ 0x7C0FB800, 0x7C0FBFFF, "GD" ],  // 124.15.184.0-124.15.191.255, GD
        [ 0x7C0FC000, 0x7C0FFFFF, "SH" ],  // 124.15.192.0-124.15.255.255, SH
        [ 0x7C100000, 0x7C100003, "GD" ],  // 124.16.0.0-124.16.0.3, GD
        [ 0x7C100004, 0x7C100004, "JS" ],  // 124.16.0.4-124.16.0.4, JS
        [ 0x7C100005, 0x7C100005, "GD" ],  // 124.16.0.5-124.16.0.5, GD
        [ 0x7C100006, 0x7C100006, "JS" ],  // 124.16.0.6-124.16.0.6, JS
        [ 0x7C100007, 0x7C100BFF, "GD" ],  // 124.16.0.7-124.16.11.255, GD
        [ 0x7C100C00, 0x7C100DFF, "BJ" ],  // 124.16.12.0-124.16.13.255, BJ
        [ 0x7C100E00, 0x7C100FFF, "GD" ],  // 124.16.14.0-124.16.15.255, GD
        [ 0x7C101000, 0x7C1095FF, "BJ" ],  // 124.16.16.0-124.16.149.255, BJ
        [ 0x7C109600, 0x7C1096FF, "SD" ],  // 124.16.150.0-124.16.150.255, SD
        [ 0x7C109700, 0x7C10A4FF, "BJ" ],  // 124.16.151.0-124.16.164.255, BJ
        [ 0x7C10A500, 0x7C10A7FF, "FJ" ],  // 124.16.165.0-124.16.167.255, FJ
        [ 0x7C10A800, 0x7C10A9FF, "BJ" ],  // 124.16.168.0-124.16.169.255, BJ
        [ 0x7C10AA00, 0x7C10ABFF, "SD" ],  // 124.16.170.0-124.16.171.255, SD
        [ 0x7C10AC00, 0x7C10ACFF, "BJ" ],  // 124.16.172.0-124.16.172.255, BJ
        [ 0x7C10AD00, 0x7C10ADFF, "TJ" ],  // 124.16.173.0-124.16.173.255, TJ
        [ 0x7C10AE00, 0x7C10AFFF, "BJ" ],  // 124.16.174.0-124.16.175.255, BJ
        [ 0x7C10B000, 0x7C10B4FF, "FJ" ],  // 124.16.176.0-124.16.180.255, FJ
        [ 0x7C10B500, 0x7C10B5FF, "BJ" ],  // 124.16.181.0-124.16.181.255, BJ
        [ 0x7C10B600, 0x7C10B6FF, "JX" ],  // 124.16.182.0-124.16.182.255, JX
        [ 0x7C10B700, 0x7C10CFFF, "BJ" ],  // 124.16.183.0-124.16.207.255, BJ
        [ 0x7C10D000, 0x7C10D3FF, "FJ" ],  // 124.16.208.0-124.16.211.255, FJ
        [ 0x7C10D400, 0x7C10D4FF, "CQ" ],  // 124.16.212.0-124.16.212.255, CQ
        [ 0x7C10D500, 0x7C10D9FF, "BJ" ],  // 124.16.213.0-124.16.217.255, BJ
        [ 0x7C10DA00, 0x7C10DBFF, "HI" ],  // 124.16.218.0-124.16.219.255, HI
        [ 0x7C10DC00, 0x7C10DCFF, "JS" ],  // 124.16.220.0-124.16.220.255, JS
        [ 0x7C10DD00, 0x7C10E7FF, "BJ" ],  // 124.16.221.0-124.16.231.255, BJ
        [ 0x7C10E800, 0x7C10EBFF, "JS" ],  // 124.16.232.0-124.16.235.255, JS
        [ 0x7C10EC00, 0x7C10EFFF, "BJ" ],  // 124.16.236.0-124.16.239.255, BJ
        [ 0x7C10F000, 0x7C10F0FF, "SD" ],  // 124.16.240.0-124.16.240.255, SD
        [ 0x7C10F100, 0x7C10F1FF, "JS" ],  // 124.16.241.0-124.16.241.255, JS
        [ 0x7C10F200, 0x7C10F3FF, "SD" ],  // 124.16.242.0-124.16.243.255, SD
        [ 0x7C10F400, 0x7C1159FF, "BJ" ],  // 124.16.244.0-124.17.89.255, BJ
        [ 0x7C115A00, 0x7C115AFF, "TJ" ],  // 124.17.90.0-124.17.90.255, TJ
        [ 0x7C115B00, 0x7C115BFF, "BJ" ],  // 124.17.91.0-124.17.91.255, BJ
        [ 0x7C115C00, 0x7C115CFF, "TJ" ],  // 124.17.92.0-124.17.92.255, TJ
        [ 0x7C115D00, 0x7C11FFFF, "BJ" ],  // 124.17.93.0-124.17.255.255, BJ
        [ 0x7C140000, 0x7C143FFF, "BJ" ],  // 124.20.0.0-124.20.63.255, BJ
        [ 0x7C144000, 0x7C145FFF, "JS" ],  // 124.20.64.0-124.20.95.255, JS
        [ 0x7C146000, 0x7C146FFF, "BJ" ],  // 124.20.96.0-124.20.111.255, BJ
        [ 0x7C147000, 0x7C1500FF, "GD" ],  // 124.20.112.0-124.21.0.255, GD
        [ 0x7C150100, 0x7C1501FF, "BJ" ],  // 124.21.1.0-124.21.1.255, BJ
        [ 0x7C150200, 0x7C1504FF, "GD" ],  // 124.21.2.0-124.21.4.255, GD
        [ 0x7C150500, 0x7C150FFF, "BJ" ],  // 124.21.5.0-124.21.15.255, BJ
        [ 0x7C151000, 0x7C15BFFF, "GD" ],  // 124.21.16.0-124.21.191.255, GD
        [ 0x7C15C000, 0x7C15FFFF, "FJ" ],  // 124.21.192.0-124.21.255.255, FJ
        [ 0x7C160000, 0x7C17FFFF, "SN" ],  // 124.22.0.0-124.23.255.255, SN
        [ 0x7C1CC000, 0x7C1CFFFF, "SH" ],  // 124.28.192.0-124.28.255.255, SH
        [ 0x7C1D0000, 0x7C1D7FFF, "GD" ],  // 124.29.0.0-124.29.127.255, GD
        [ 0x7C1F0000, 0x7C1FFFFF, "XZ" ],  // 124.31.0.0-124.31.255.255, XZ
        [ 0x7C287000, 0x7C287FFF, "BJ" ],  // 124.40.112.0-124.40.127.255, BJ
        [ 0x7C288000, 0x7C28DFFF, "GD" ],  // 124.40.128.0-124.40.223.255, GD
        [ 0x7C28F000, 0x7C28F3FF, "FJ" ],  // 124.40.240.0-124.40.243.255, FJ
        [ 0x7C2A0000, 0x7C2A7FFF, "BJ" ],  // 124.42.0.0-124.42.127.255, BJ
        [ 0x7C2A8000, 0x7C2AFFFF, "GD" ],  // 124.42.128.0-124.42.255.255, GD
        [ 0x7C2F0000, 0x7C2F3FFF, "SN" ],  // 124.47.0.0-124.47.63.255, SN
        [ 0x7C400000, 0x7C41FFFF, "BJ" ],  // 124.64.0.0-124.65.255.255, BJ
        [ 0x7C420000, 0x7C427FFF, "HI" ],  // 124.66.0.0-124.66.127.255, HI
        [ 0x7C430000, 0x7C43FFFF, "NM" ],  // 124.67.0.0-124.67.255.255, NM
        [ 0x7C440000, 0x7C447FFF, "TJ" ],  // 124.68.0.0-124.68.127.255, TJ
        [ 0x7C448000, 0x7C44E2FF, "BJ" ],  // 124.68.128.0-124.68.226.255, BJ
        [ 0x7C44E300, 0x7C44E3FF, "TJ" ],  // 124.68.227.0-124.68.227.255, TJ
        [ 0x7C44E400, 0x7C44F7FF, "BJ" ],  // 124.68.228.0-124.68.247.255, BJ
        [ 0x7C44F800, 0x7C44FDFF, "TJ" ],  // 124.68.248.0-124.68.253.255, TJ
        [ 0x7C44FE00, 0x7C44FEFF, "BJ" ],  // 124.68.254.0-124.68.254.255, BJ
        [ 0x7C44FF00, 0x7C44FFFF, "TJ" ],  // 124.68.255.0-124.68.255.255, TJ
        [ 0x7C450000, 0x7C467FFF, "BJ" ],  // 124.69.0.0-124.70.127.255, BJ
        [ 0x7C468000, 0x7C46FFFF, "SH" ],  // 124.70.128.0-124.70.255.255, SH
        [ 0x7C470000, 0x7C477FFF, "GD" ],  // 124.71.0.0-124.71.127.255, GD
        [ 0x7C478000, 0x7C47CFFF, "SH" ],  // 124.71.128.0-124.71.207.255, SH
        [ 0x7C47D000, 0x7C47DFFF, "GD" ],  // 124.71.208.0-124.71.223.255, GD
        [ 0x7C47E000, 0x7C47F9FF, "BJ" ],  // 124.71.224.0-124.71.249.255, BJ
        [ 0x7C47FA00, 0x7C47FAFF, "GD" ],  // 124.71.250.0-124.71.250.255, GD
        [ 0x7C47FB00, 0x7C47FDFF, "BJ" ],  // 124.71.251.0-124.71.253.255, BJ
        [ 0x7C47FE00, 0x7C47FFFF, "GD" ],  // 124.71.254.0-124.71.255.255, GD
        [ 0x7C480000, 0x7C48FFFF, "FJ" ],  // 124.72.0.0-124.72.255.255, FJ
        [ 0x7C490000, 0x7C49FFFF, "AH" ],  // 124.73.0.0-124.73.255.255, AH
        [ 0x7C4A0000, 0x7C4FFFFF, "SH" ],  // 124.74.0.0-124.79.255.255, SH
        [ 0x7C580000, 0x7C58FFFF, "XJ" ],  // 124.88.0.0-124.88.255.255, XJ
        [ 0x7C590000, 0x7C597FFF, "SN" ],  // 124.89.0.0-124.89.127.255, SN
        [ 0x7C598000, 0x7C5BFFFF, "ZJ" ],  // 124.89.128.0-124.91.255.255, ZJ
        [ 0x7C5C0000, 0x7C5FFFFF, "LN" ],  // 124.92.0.0-124.95.255.255, LN
        [ 0x7C6C0800, 0x7C6C0FFF, "BJ" ],  // 124.108.8.0-124.108.15.255, BJ
        [ 0x7C6C2800, 0x7C6C2FFF, "BJ" ],  // 124.108.40.0-124.108.47.255, BJ
        [ 0x7C6D6000, 0x7C6D67FF, "GD" ],  // 124.109.96.0-124.109.103.255, GD
        [ 0x7C700000, 0x7C71FFFF, "AH" ],  // 124.112.0.0-124.113.255.255, AH
        [ 0x7C720000, 0x7C74FFFF, "SN" ],  // 124.114.0.0-124.116.255.255, SN
        [ 0x7C750000, 0x7C77FFFF, "XJ" ],  // 124.117.0.0-124.119.255.255, XJ
        [ 0x7C7E0000, 0x7C7FFFFF, "BJ" ],  // 124.126.0.0-124.127.255.255, BJ
        [ 0x7C800000, 0x7C87FFFF, "SD" ],  // 124.128.0.0-124.135.255.255, SD
        [ 0x7C938000, 0x7C93FFFF, "GD" ],  // 124.147.128.0-124.147.255.255, GD
        [ 0x7C968900, 0x7C9689FF, "GD" ],  // 124.150.137.0-124.150.137.255, GD
        [ 0x7C970000, 0x7C97FFFF, "SH" ],  // 124.151.0.0-124.151.255.255, SH
        [ 0x7C980000, 0x7C98FFFF, "GS" ],  // 124.152.0.0-124.152.255.255, GS
        [ 0x7CA00000, 0x7CA0FFFF, "ZJ" ],  // 124.160.0.0-124.160.255.255, ZJ
        [ 0x7CA10000, 0x7CA1FFFF, "SC" ],  // 124.161.0.0-124.161.255.255, SC
        [ 0x7CA20000, 0x7CA220FF, "CQ" ],  // 124.162.0.0-124.162.32.255, CQ
        [ 0x7CA22100, 0x7CA221FF, "GD" ],  // 124.162.33.0-124.162.33.255, GD
        [ 0x7CA22200, 0x7CA2FFFF, "CQ" ],  // 124.162.34.0-124.162.255.255, CQ
        [ 0x7CA30000, 0x7CA3D0FF, "SX" ],  // 124.163.0.0-124.163.208.255, SX
        [ 0x7CA3D100, 0x7CA3D17F, "HA" ],  // 124.163.209.0-124.163.209.127, HA
        [ 0x7CA3D180, 0x7CA7FFFF, "SX" ],  // 124.163.209.128-124.167.255.255, SX
        [ 0x7CAC0000, 0x7CAFFFFF, "GD" ],  // 124.172.0.0-124.175.255.255, GD
        [ 0x7CC00000, 0x7CC1FFFF, "BJ" ],  // 124.192.0.0-124.193.255.255, BJ
        [ 0x7CC40000, 0x7CC409FF, "TJ" ],  // 124.196.0.0-124.196.9.255, TJ
        [ 0x7CC40A00, 0x7CC40EFF, "GD" ],  // 124.196.10.0-124.196.14.255, GD
        [ 0x7CC40F00, 0x7CC410FF, "TJ" ],  // 124.196.15.0-124.196.16.255, TJ
        [ 0x7CC41100, 0x7CC414FF, "GD" ],  // 124.196.17.0-124.196.20.255, GD
        [ 0x7CC41500, 0x7CC418FF, "TJ" ],  // 124.196.21.0-124.196.24.255, TJ
        [ 0x7CC41900, 0x7CC41DFF, "GD" ],  // 124.196.25.0-124.196.29.255, GD
        [ 0x7CC41E00, 0x7CC41EFF, "TJ" ],  // 124.196.30.0-124.196.30.255, TJ
        [ 0x7CC41F00, 0x7CC421FF, "GD" ],  // 124.196.31.0-124.196.33.255, GD
        [ 0x7CC42200, 0x7CC427FF, "TJ" ],  // 124.196.34.0-124.196.39.255, TJ
        [ 0x7CC42800, 0x7CC42BFF, "GD" ],  // 124.196.40.0-124.196.43.255, GD
        [ 0x7CC42C00, 0x7CC42FFF, "TJ" ],  // 124.196.44.0-124.196.47.255, TJ
        [ 0x7CC43000, 0x7CC431FF, "GD" ],  // 124.196.48.0-124.196.49.255, GD
        [ 0x7CC43200, 0x7CC447FF, "TJ" ],  // 124.196.50.0-124.196.71.255, TJ
        [ 0x7CC44800, 0x7CC448FF, "GD" ],  // 124.196.72.0-124.196.72.255, GD
        [ 0x7CC44900, 0x7CC449FF, "TJ" ],  // 124.196.73.0-124.196.73.255, TJ
        [ 0x7CC44A00, 0x7CC44AFF, "GD" ],  // 124.196.74.0-124.196.74.255, GD
        [ 0x7CC44B00, 0x7CC44BFF, "TJ" ],  // 124.196.75.0-124.196.75.255, TJ
        [ 0x7CC44C00, 0x7CC44EFF, "GD" ],  // 124.196.76.0-124.196.78.255, GD
        [ 0x7CC44F00, 0x7CC4FFFF, "TJ" ],  // 124.196.79.0-124.196.255.255, TJ
        [ 0x7CC80000, 0x7CCB7FFF, "BJ" ],  // 124.200.0.0-124.203.127.255, BJ
        [ 0x7CCB8000, 0x7CCB83FF, "GZ" ],  // 124.203.128.0-124.203.131.255, GZ
        [ 0x7CCB8400, 0x7CCB87FF, "HN" ],  // 124.203.132.0-124.203.135.255, HN
        [ 0x7CCB8800, 0x7CCB8BFF, "SD" ],  // 124.203.136.0-124.203.139.255, SD
        [ 0x7CCB8C00, 0x7CCB9BFF, "ZJ" ],  // 124.203.140.0-124.203.155.255, ZJ
        [ 0x7CCB9C00, 0x7CCBAFFF, "HA" ],  // 124.203.156.0-124.203.175.255, HA
        [ 0x7CCBB000, 0x7CCBBFFF, "HB" ],  // 124.203.176.0-124.203.191.255, HB
        [ 0x7CCBC000, 0x7CCBCFFF, "ZJ" ],  // 124.203.192.0-124.203.207.255, ZJ
        [ 0x7CCBD000, 0x7CCBDFFF, "GD" ],  // 124.203.208.0-124.203.223.255, GD
        [ 0x7CCBE000, 0x7CCBE3FF, "HB" ],  // 124.203.224.0-124.203.227.255, HB
        [ 0x7CCBE400, 0x7CCD98BF, "BJ" ],  // 124.203.228.0-124.205.152.191, BJ
        [ 0x7CCD98C0, 0x7CCD98FF, "JS" ],  // 124.205.152.192-124.205.152.255, JS
        [ 0x7CCD9900, 0x7CCFFFFF, "BJ" ],  // 124.205.153.0-124.207.255.255, BJ
        [ 0x7CDC0000, 0x7CDFFFFF, "SH" ],  // 124.220.0.0-124.223.255.255, SH
        [ 0x7CE00000, 0x7CE0FFFF, "NX" ],  // 124.224.0.0-124.224.255.255, NX
        [ 0x7CE10000, 0x7CE1FFFF, "HI" ],  // 124.225.0.0-124.225.255.255, HI
        [ 0x7CE20000, 0x7CE3FFFF, "GX" ],  // 124.226.0.0-124.227.255.255, GX
        [ 0x7CE40000, 0x7CE9FFFF, "HN" ],  // 124.228.0.0-124.233.255.255, HN
        [ 0x7CEA0000, 0x7CEB91FF, "JL" ],  // 124.234.0.0-124.235.145.255, JL
        [ 0x7CEB9200, 0x7CEB93FF, "GD" ],  // 124.235.146.0-124.235.147.255, GD
        [ 0x7CEB9400, 0x7CEBFFFF, "JL" ],  // 124.235.148.0-124.235.255.255, JL
        [ 0x7CEC0000, 0x7CEFFFFF, "HE" ],  // 124.236.0.0-124.239.255.255, HE
        [ 0x7CF00000, 0x7CF07FFF, "GD" ],  // 124.240.0.0-124.240.127.255, GD
        [ 0x7CF08000, 0x7CF0BFFF, "HA" ],  // 124.240.128.0-124.240.191.255, HA
        [ 0x7CF20000, 0x7CF2FFFF, "BJ" ],  // 124.242.0.0-124.242.255.255, BJ
        [ 0x7CF3C000, 0x7CF3FFFF, "BJ" ],  // 124.243.192.0-124.243.255.255, BJ
        [ 0x7CF80000, 0x7CF83FFF, "BJ" ],  // 124.248.0.0-124.248.63.255, BJ
        [ 0x7CF84000, 0x7CF87FFF, "ZJ" ],  // 124.248.64.0-124.248.127.255, ZJ
        [ 0x7CF90000, 0x7CF98CFF, "JS" ],  // 124.249.0.0-124.249.140.255, JS
        [ 0x7CF98D00, 0x7CF9DFFF, "TJ" ],  // 124.249.141.0-124.249.223.255, TJ
        [ 0x7CF9E000, 0x7CF9EFFF, "ZJ" ],  // 124.249.224.0-124.249.239.255, ZJ
        [ 0x7CF9F000, 0x7CF9FFFF, "GX" ],  // 124.249.240.0-124.249.255.255, GX
        [ 0x7CFA0000, 0x7CFBFFFF, "BJ" ],  // 124.250.0.0-124.251.255.255, BJ
        [ 0x7CFE0000, 0x7CFE3FFF, "BJ" ],  // 124.254.0.0-124.254.63.255, BJ
        [ 0x7D1FC000, 0x7D1FFFFF, "GD" ],  // 125.31.192.0-125.31.255.255, GD
        [ 0x7D200000, 0x7D20FFFF, "JL" ],  // 125.32.0.0-125.32.255.255, JL
        [ 0x7D210000, 0x7D237FFF, "BJ" ],  // 125.33.0.0-125.35.127.255, BJ
        [ 0x7D238000, 0x7D27FFFF, "TJ" ],  // 125.35.128.0-125.39.255.255, TJ
        [ 0x7D280000, 0x7D2FFFFF, "HA" ],  // 125.40.0.0-125.47.255.255, HA
        [ 0x7D3A8000, 0x7D3AFFFF, "HL" ],  // 125.58.128.0-125.58.255.255, HL
        [ 0x7D3D8000, 0x7D3DFFFF, "BJ" ],  // 125.61.128.0-125.61.255.255, BJ
        [ 0x7D3E0000, 0x7D3E3FFF, "CQ" ],  // 125.62.0.0-125.62.63.255, CQ
        [ 0x7D400000, 0x7D47FFFF, "SC" ],  // 125.64.0.0-125.71.255.255, SC
        [ 0x7D480000, 0x7D48FFFF, "QH" ],  // 125.72.0.0-125.72.255.255, QH
        [ 0x7D490000, 0x7D49FFFF, "GX" ],  // 125.73.0.0-125.73.255.255, GX
        [ 0x7D4A0000, 0x7D4C7FFF, "GS" ],  // 125.74.0.0-125.76.127.255, GS
        [ 0x7D4C8000, 0x7D4CFFFF, "SN" ],  // 125.76.128.0-125.76.255.255, SN
        [ 0x7D4D0000, 0x7D4FFFFF, "FJ" ],  // 125.77.0.0-125.79.255.255, FJ
        [ 0x7D500000, 0x7D57FFFF, "CQ" ],  // 125.80.0.0-125.87.255.255, CQ
        [ 0x7D580000, 0x7D5FFFFF, "GD" ],  // 125.88.0.0-125.95.255.255, GD
        [ 0x7D600000, 0x7D627FFF, "BJ" ],  // 125.96.0.0-125.98.127.255, BJ
        [ 0x7D628000, 0x7D62FFFF, "SH" ],  // 125.98.128.0-125.98.255.255, SH
        [ 0x7D680000, 0x7D7FFFFF, "ZJ" ],  // 125.104.0.0-125.127.255.255, ZJ
        [ 0x7DA90000, 0x7DA9FFFF, "GD" ],  // 125.169.0.0-125.169.255.255, GD
        [ 0x7DAB0000, 0x7DABFFFF, "GD" ],  // 125.171.0.0-125.171.255.255, GD
        [ 0x7DD00000, 0x7DD02FFF, "BJ" ],  // 125.208.0.0-125.208.47.255, BJ
        [ 0x7DD03000, 0x7DD030FF, "ZJ" ],  // 125.208.48.0-125.208.48.255, ZJ
        [ 0x7DD03100, 0x7DD03FFF, "BJ" ],  // 125.208.49.0-125.208.63.255, BJ
        [ 0x7DD20000, 0x7DD2FFFF, "ZJ" ],  // 125.210.0.0-125.210.255.255, ZJ
        [ 0x7DD30000, 0x7DD3FFFF, "HL" ],  // 125.211.0.0-125.211.255.255, HL
        [ 0x7DD50000, 0x7DD507FF, "ZJ" ],  // 125.213.0.0-125.213.7.255, ZJ
        [ 0x7DD50800, 0x7DD50FFF, "FJ" ],  // 125.213.8.0-125.213.15.255, FJ
        [ 0x7DD51000, 0x7DD51FFF, "JX" ],  // 125.213.16.0-125.213.31.255, JX
        [ 0x7DD52000, 0x7DD52FFF, "TJ" ],  // 125.213.32.0-125.213.47.255, TJ
        [ 0x7DD53000, 0x7DD557FF, "FJ" ],  // 125.213.48.0-125.213.87.255, FJ
        [ 0x7DD55800, 0x7DD567FF, "CQ" ],  // 125.213.88.0-125.213.103.255, CQ
        [ 0x7DD56800, 0x7DD56FFF, "YN" ],  // 125.213.104.0-125.213.111.255, YN
        [ 0x7DD57000, 0x7DD57FFF, "XJ" ],  // 125.213.112.0-125.213.127.255, XJ
        [ 0x7DD66000, 0x7DD67FFF, "SC" ],  // 125.214.96.0-125.214.127.255, SC
        [ 0x7DD70000, 0x7DD73FFF, "SH" ],  // 125.215.0.0-125.215.63.255, SH
        [ 0x7DD80000, 0x7DD8FFFF, "GD" ],  // 125.216.0.0-125.216.255.255, GD
        [ 0x7DD90000, 0x7DD907FF, "GX" ],  // 125.217.0.0-125.217.7.255, GX
        [ 0x7DD90800, 0x7DD91FFF, "GD" ],  // 125.217.8.0-125.217.31.255, GD
        [ 0x7DD92000, 0x7DD93FFF, "GX" ],  // 125.217.32.0-125.217.63.255, GX
        [ 0x7DD94000, 0x7DD973FF, "HI" ],  // 125.217.64.0-125.217.115.255, HI
        [ 0x7DD97400, 0x7DD977FF, "GD" ],  // 125.217.116.0-125.217.119.255, GD
        [ 0x7DD97800, 0x7DD97FFF, "HI" ],  // 125.217.120.0-125.217.127.255, HI
        [ 0x7DD98000, 0x7DDABDFF, "GD" ],  // 125.217.128.0-125.218.189.255, GD
        [ 0x7DDABE00, 0x7DDABEFF, "GZ" ],  // 125.218.190.0-125.218.190.255, GZ
        [ 0x7DDABF00, 0x7DDAFFFF, "GD" ],  // 125.218.191.0-125.218.255.255, GD
        [ 0x7DDB0000, 0x7DDBCFFF, "HA" ],  // 125.219.0.0-125.219.207.255, HA
        [ 0x7DDBD000, 0x7DDD7FFF, "HB" ],  // 125.219.208.0-125.221.127.255, HB
        [ 0x7DDD8000, 0x7DDDFFFF, "HN" ],  // 125.221.128.0-125.221.255.255, HN
        [ 0x7DDE0000, 0x7DDEBFFF, "LN" ],  // 125.222.0.0-125.222.191.255, LN
        [ 0x7DDEC000, 0x7DDEFFFF, "JL" ],  // 125.222.192.0-125.222.255.255, JL
        [ 0x7DDF0000, 0x7DDF7FFF, "HL" ],  // 125.223.0.0-125.223.127.255, HL
        [ 0x7DDF8000, 0x7DDFFFFF, "JL" ],  // 125.223.128.0-125.223.255.255, JL
        [ 0x7DFE8000, 0x7DFEBFFF, "BJ" ],  // 125.254.128.0-125.254.191.255, BJ
        [ 0x7DFEC000, 0x7DFEFFFF, "HE" ],  // 125.254.192.0-125.254.255.255, HE
        [ 0x806C0000, 0x806C0FFF, "SD" ],  // 128.108.0.0-128.108.15.255, SD
        [ 0x806C1000, 0x806C1FFF, "ZJ" ],  // 128.108.16.0-128.108.31.255, ZJ
        [ 0x806C2000, 0x806C27FF, "FJ" ],  // 128.108.32.0-128.108.39.255, FJ
        [ 0x806C2800, 0x806C2FFF, "BJ" ],  // 128.108.40.0-128.108.47.255, BJ
        [ 0x806C3000, 0x806C37FF, "HB" ],  // 128.108.48.0-128.108.55.255, HB
        [ 0x806C3800, 0x806C47FF, "HE" ],  // 128.108.56.0-128.108.71.255, HE
        [ 0x806C4800, 0x806C59FF, "HN" ],  // 128.108.72.0-128.108.89.255, HN
        [ 0x806C5A00, 0x806C67FF, "ZJ" ],  // 128.108.90.0-128.108.103.255, ZJ
        [ 0x806C6800, 0x806C80FF, "LN" ],  // 128.108.104.0-128.108.128.255, LN
        [ 0x806C8100, 0x806CFFFF, "AH" ],  // 128.108.129.0-128.108.255.255, AH
        [ 0x811C0000, 0x811C0FFF, "CQ" ],  // 129.28.0.0-129.28.15.255, CQ
        [ 0x811C1000, 0x811C8FFF, "SC" ],  // 129.28.16.0-129.28.143.255, SC
        [ 0x811C9000, 0x811CEFFF, "CQ" ],  // 129.28.144.0-129.28.239.255, CQ
        [ 0x811CF000, 0x811CFFFF, "GD" ],  // 129.28.240.0-129.28.255.255, GD
        [ 0x81CC0000, 0x81CCFFFF, "GD" ],  // 129.204.0.0-129.204.255.255, GD
        [ 0x81D30000, 0x81D39FFF, "SH" ],  // 129.211.0.0-129.211.159.255, SH
        [ 0x81D3A000, 0x81D3FFFF, "JS" ],  // 129.211.160.0-129.211.255.255, JS
        [ 0x83E46000, 0x83E463FF, "ZJ" ],  // 131.228.96.0-131.228.99.255, ZJ
        [ 0x83FD0C00, 0x83FD0C07, "BJ" ],  // 131.253.12.0-131.253.12.7, BJ
        [ 0x83FD0C50, 0x83FD0C5F, "BJ" ],  // 131.253.12.80-131.253.12.95, BJ
        [ 0x83FD0CF0, 0x83FD0CF7, "BJ" ],  // 131.253.12.240-131.253.12.247, BJ
        [ 0x84E80000, 0x84E8FFFF, "SC" ],  // 132.232.0.0-132.232.255.255, SC
        [ 0x86AF0000, 0x86AFFFFF, "GD" ],  // 134.175.0.0-134.175.255.255, GD
        [ 0x88008300, 0x880083FF, "BJ" ],  // 136.0.131.0-136.0.131.255, BJ
        [ 0x88008500, 0x880085FF, "BJ" ],  // 136.0.133.0-136.0.133.255, BJ
        [ 0x893B3B00, 0x893B3BFF, "GD" ],  // 137.59.59.0-137.59.59.255, GD
        [ 0x893B5800, 0x893B5BFF, "JS" ],  // 137.59.88.0-137.59.91.255, JS
        [ 0x8A716800, 0x8A7168FF, "BJ" ],  // 138.113.104.0-138.113.104.255, BJ
        [ 0x8B052000, 0x8B0520FF, "BJ" ],  // 139.5.32.0-139.5.32.255, BJ
        [ 0x8B053800, 0x8B053BFF, "GZ" ],  // 139.5.56.0-139.5.59.255, GZ
        [ 0x8B053C00, 0x8B053FFF, "GD" ],  // 139.5.60.0-139.5.63.255, GD
        [ 0x8B055000, 0x8B0553FF, "TJ" ],  // 139.5.80.0-139.5.83.255, TJ
        [ 0x8B055C00, 0x8B055FFF, "BJ" ],  // 139.5.92.0-139.5.95.255, BJ
        [ 0x8B058000, 0x8B0583FF, "BJ" ],  // 139.5.128.0-139.5.131.255, BJ
        [ 0x8B05A000, 0x8B05A3FF, "ZJ" ],  // 139.5.160.0-139.5.163.255, ZJ
        [ 0x8B05C000, 0x8B05C3FF, "GD" ],  // 139.5.192.0-139.5.195.255, GD
        [ 0x8B05CC00, 0x8B05CFFF, "BJ" ],  // 139.5.204.0-139.5.207.255, BJ
        [ 0x8B05D400, 0x8B05D7FF, "GD" ],  // 139.5.212.0-139.5.215.255, GD
        [ 0x8B05F400, 0x8B05F7FF, "JS" ],  // 139.5.244.0-139.5.247.255, JS
        [ 0x8B090000, 0x8B090DFF, "GD" ],  // 139.9.0.0-139.9.13.255, GD
        [ 0x8B090E00, 0x8B090EFF, "SH" ],  // 139.9.14.0-139.9.14.255, SH
        [ 0x8B090F00, 0x8B096FFF, "GD" ],  // 139.9.15.0-139.9.111.255, GD
        [ 0x8B097000, 0x8B0977FF, "BJ" ],  // 139.9.112.0-139.9.119.255, BJ
        [ 0x8B097800, 0x8B097FFF, "SH" ],  // 139.9.120.0-139.9.127.255, SH
        [ 0x8B098000, 0x8B098FFF, "BJ" ],  // 139.9.128.0-139.9.143.255, BJ
        [ 0x8B099000, 0x8B099FFF, "GZ" ],  // 139.9.144.0-139.9.159.255, GZ
        [ 0x8B09A000, 0x8B09AFFF, "SH" ],  // 139.9.160.0-139.9.175.255, SH
        [ 0x8B09B000, 0x8B09DFFF, "GD" ],  // 139.9.176.0-139.9.223.255, GD
        [ 0x8B09E000, 0x8B09FBFF, "GZ" ],  // 139.9.224.0-139.9.251.255, GZ
        [ 0x8B09FC00, 0x8B09FFFF, "GD" ],  // 139.9.252.0-139.9.255.255, GD
        [ 0x8B810000, 0x8B81FFFF, "SD" ],  // 139.129.0.0-139.129.255.255, SD
        [ 0x8B8AEE00, 0x8B8AEE0F, "SH" ],  // 139.138.238.0-139.138.238.15, SH
        [ 0x8B940000, 0x8B94FFFF, "SN" ],  // 139.148.0.0-139.148.255.255, SN
        [ 0x8B9B0000, 0x8B9BFFFF, "SC" ],  // 139.155.0.0-139.155.255.255, SC
        [ 0x8B9F0000, 0x8B9F1FFF, "BJ" ],  // 139.159.0.0-139.159.31.255, BJ
        [ 0x8B9F2000, 0x8B9F23FF, "SH" ],  // 139.159.32.0-139.159.35.255, SH
        [ 0x8B9F2400, 0x8B9F2BFF, "BJ" ],  // 139.159.36.0-139.159.43.255, BJ
        [ 0x8B9F2F00, 0x8B9F310F, "BJ" ],  // 139.159.47.0-139.159.49.15, BJ
        [ 0x8B9F3110, 0x8B9F31FF, "SH" ],  // 139.159.49.16-139.159.49.255, SH
        [ 0x8B9F3200, 0x8B9F5FFF, "BJ" ],  // 139.159.50.0-139.159.95.255, BJ
        [ 0x8B9F6000, 0x8B9F73FF, "JS" ],  // 139.159.96.0-139.159.115.255, JS
        [ 0x8B9F7400, 0x8B9F7FFF, "BJ" ],  // 139.159.116.0-139.159.127.255, BJ
        [ 0x8B9F8000, 0x8B9FFFFF, "GD" ],  // 139.159.128.0-139.159.255.255, GD
        [ 0x8BAA0000, 0x8BAAFFFF, "QH" ],  // 139.170.0.0-139.170.255.255, QH
        [ 0x8BB00000, 0x8BB0FFFF, "BJ" ],  // 139.176.0.0-139.176.255.255, BJ
        [ 0x8BB70000, 0x8BB7FFFF, "SH" ],  // 139.183.0.0-139.183.255.255, SH
        [ 0x8BBA0000, 0x8BBAFFFF, "CQ" ],  // 139.186.0.0-139.186.255.255, CQ
        [ 0x8BBD0000, 0x8BBDFFFF, "HI" ],  // 139.189.0.0-139.189.255.255, HI
        [ 0x8BC40000, 0x8BC4FFFF, "SH" ],  // 139.196.0.0-139.196.255.255, SH
        [ 0x8BC50000, 0x8BC609FF, "BJ" ],  // 139.197.0.0-139.198.9.255, BJ
        [ 0x8BC60B00, 0x8BC63FFF, "BJ" ],  // 139.198.11.0-139.198.63.255, BJ
        [ 0x8BC64200, 0x8BC664FF, "BJ" ],  // 139.198.66.0-139.198.100.255, BJ
        [ 0x8BC66500, 0x8BC66FFF, "GD" ],  // 139.198.101.0-139.198.111.255, GD
        [ 0x8BC67000, 0x8BC670FF, "GX" ],  // 139.198.112.0-139.198.112.255, GX
        [ 0x8BC67200, 0x8BC673FF, "BJ" ],  // 139.198.114.0-139.198.115.255, BJ
        [ 0x8BC67400, 0x8BC677FF, "GD" ],  // 139.198.116.0-139.198.119.255, GD
        [ 0x8BC67A00, 0x8BC67FFF, "GD" ],  // 139.198.122.0-139.198.127.255, GD
        [ 0x8BC68000, 0x8BC6FBFF, "SH" ],  // 139.198.128.0-139.198.251.255, SH
        [ 0x8BC6FC00, 0x8BC6FCFF, "BJ" ],  // 139.198.252.0-139.198.252.255, BJ
        [ 0x8BC6FD00, 0x8BC6FEFF, "SH" ],  // 139.198.253.0-139.198.254.255, SH
        [ 0x8BC6FF00, 0x8BC6FFFF, "BJ" ],  // 139.198.255.0-139.198.255.255, BJ
        [ 0x8BC70000, 0x8BC713FF, "GD" ],  // 139.199.0.0-139.199.19.255, GD
        [ 0x8BC71400, 0x8BC727FF, "TJ" ],  // 139.199.20.0-139.199.39.255, TJ
        [ 0x8BC72800, 0x8BC72FFF, "GD" ],  // 139.199.40.0-139.199.47.255, GD
        [ 0x8BC73000, 0x8BC735FF, "SH" ],  // 139.199.48.0-139.199.53.255, SH
        [ 0x8BC73600, 0x8BC75DFF, "GD" ],  // 139.199.54.0-139.199.93.255, GD
        [ 0x8BC75E00, 0x8BC787FF, "TJ" ],  // 139.199.94.0-139.199.135.255, TJ
        [ 0x8BC78800, 0x8BC793FF, "GD" ],  // 139.199.136.0-139.199.147.255, GD
        [ 0x8BC79400, 0x8BC797FF, "SH" ],  // 139.199.148.0-139.199.151.255, SH
        [ 0x8BC79800, 0x8BC7EDFF, "GD" ],  // 139.199.152.0-139.199.237.255, GD
        [ 0x8BC7EE00, 0x8BC7EEFF, "SH" ],  // 139.199.238.0-139.199.238.255, SH
        [ 0x8BC7EF00, 0x8BC7F7FF, "GD" ],  // 139.199.239.0-139.199.247.255, GD
        [ 0x8BC7F800, 0x8BC7F9FF, "SH" ],  // 139.199.248.0-139.199.249.255, SH
        [ 0x8BC7FA00, 0x8BC7FFFF, "GD" ],  // 139.199.250.0-139.199.255.255, GD
        [ 0x8BC80000, 0x8BCFFFFF, "SC" ],  // 139.200.0.0-139.207.255.255, SC
        [ 0x8BD00000, 0x8BD7FFFF, "JL" ],  // 139.208.0.0-139.215.255.255, JL
        [ 0x8BD90000, 0x8BD97FFF, "BJ" ],  // 139.217.0.0-139.217.127.255, BJ
        [ 0x8BD98000, 0x8BD9FFFF, "SH" ],  // 139.217.128.0-139.217.255.255, SH
        [ 0x8BDB0000, 0x8BDB11FF, "BJ" ],  // 139.219.0.0-139.219.17.255, BJ
        [ 0x8BDB1200, 0x8BDB13FF, "SH" ],  // 139.219.18.0-139.219.19.255, SH
        [ 0x8BDB1400, 0x8BDB7FFF, "BJ" ],  // 139.219.20.0-139.219.127.255, BJ
        [ 0x8BDB8000, 0x8BDBFFFF, "SH" ],  // 139.219.128.0-139.219.255.255, SH
        [ 0x8BDC0000, 0x8BDC7FFF, "CQ" ],  // 139.220.0.0-139.220.127.255, CQ
        [ 0x8BDC8000, 0x8BDCBFFF, "GD" ],  // 139.220.128.0-139.220.191.255, GD
        [ 0x8BDCC000, 0x8BDCC5FF, "TJ" ],  // 139.220.192.0-139.220.197.255, TJ
        [ 0x8BDCC600, 0x8BDCC7FF, "BJ" ],  // 139.220.198.0-139.220.199.255, BJ
        [ 0x8BDCC800, 0x8BDCCAFF, "TJ" ],  // 139.220.200.0-139.220.202.255, TJ
        [ 0x8BDCCB00, 0x8BDCD1FF, "GD" ],  // 139.220.203.0-139.220.209.255, GD
        [ 0x8BDCD200, 0x8BDCD3FF, "BJ" ],  // 139.220.210.0-139.220.211.255, BJ
        [ 0x8BDCD400, 0x8BDCDFFF, "GD" ],  // 139.220.212.0-139.220.223.255, GD
        [ 0x8BDCE000, 0x8BDCE1FF, "BJ" ],  // 139.220.224.0-139.220.225.255, BJ
        [ 0x8BDCE200, 0x8BDCEFFF, "GD" ],  // 139.220.226.0-139.220.239.255, GD
        [ 0x8BDCF000, 0x8BDCF3FF, "TJ" ],  // 139.220.240.0-139.220.243.255, TJ
        [ 0x8BDCF400, 0x8BDDFFFF, "GD" ],  // 139.220.244.0-139.221.255.255, GD
        [ 0x8BE00000, 0x8BE0FFFF, "SH" ],  // 139.224.0.0-139.224.255.255, SH
        [ 0x8BE20000, 0x8BE3FFFF, "SH" ],  // 139.226.0.0-139.227.255.255, SH
        [ 0x8C4B0000, 0x8C4BFFFF, "SD" ],  // 140.75.0.0-140.75.255.255, SD
        [ 0x8C8F0000, 0x8C8F51FF, "TJ" ],  // 140.143.0.0-140.143.81.255, TJ
        [ 0x8C8F5200, 0x8C8F65FF, "SC" ],  // 140.143.82.0-140.143.101.255, SC
        [ 0x8C8F6600, 0x8C8F6DFF, "CQ" ],  // 140.143.102.0-140.143.109.255, CQ
        [ 0x8C8F6E00, 0x8C8FFFFF, "BJ" ],  // 140.143.110.0-140.143.255.255, BJ
        [ 0x8CB30000, 0x8CB3FFFF, "BJ" ],  // 140.179.0.0-140.179.255.255, BJ
        [ 0x8CCD0000, 0x8CCD1FFF, "ZJ" ],  // 140.205.0.0-140.205.31.255, ZJ
        [ 0x8CCD2000, 0x8CCD3FFF, "SH" ],  // 140.205.32.0-140.205.63.255, SH
        [ 0x8CCD4000, 0x8CCD4BFF, "ZJ" ],  // 140.205.64.0-140.205.75.255, ZJ
        [ 0x8CCD4C00, 0x8CCD4CFF, "SH" ],  // 140.205.76.0-140.205.76.255, SH
        [ 0x8CCD4D00, 0x8CCD7F7F, "ZJ" ],  // 140.205.77.0-140.205.127.127, ZJ
        [ 0x8CCD7F80, 0x8CCD7FFF, "SD" ],  // 140.205.127.128-140.205.127.255, SD
        [ 0x8CCD8000, 0x8CCFFFFF, "SH" ],  // 140.205.128.0-140.207.255.255, SH
        [ 0x8CD20000, 0x8CD20FFF, "BJ" ],  // 140.210.0.0-140.210.15.255, BJ
        [ 0x8CD21000, 0x8CD21FFF, "JS" ],  // 140.210.16.0-140.210.31.255, JS
        [ 0x8CD22000, 0x8CD27FFF, "BJ" ],  // 140.210.32.0-140.210.127.255, BJ
        [ 0x8CD28000, 0x8CD2FFFF, "GZ" ],  // 140.210.128.0-140.210.255.255, GZ
        [ 0x8CE00000, 0x8CE0FFFF, "FJ" ],  // 140.224.0.0-140.224.255.255, FJ
        [ 0x8CED0000, 0x8CEDFFFF, "FJ" ],  // 140.237.0.0-140.237.255.255, FJ
        [ 0x8CF00000, 0x8CF0FFFF, "HI" ],  // 140.240.0.0-140.240.255.255, HI
        [ 0x8CF2D800, 0x8CF2D8FF, "BJ" ],  // 140.242.216.0-140.242.216.255, BJ
        [ 0x8CF2DF00, 0x8CF2E0FF, "BJ" ],  // 140.242.223.0-140.242.224.255, BJ
        [ 0x8CF30000, 0x8CF3FFFF, "FJ" ],  // 140.243.0.0-140.243.255.255, FJ
        [ 0x8CF60000, 0x8CF6FFFF, "GZ" ],  // 140.246.0.0-140.246.255.255, GZ
        [ 0x8CF90000, 0x8CFAFFFF, "SD" ],  // 140.249.0.0-140.250.255.255, SD
        [ 0x8CFF0000, 0x8CFFFFFF, "SD" ],  // 140.255.0.0-140.255.255.255, SD
        [ 0x8D625600, 0x8D6256FF, "BJ" ],  // 141.98.86.0-141.98.86.255, BJ
        [ 0x8E460000, 0x8E46FFFF, "BJ" ],  // 142.70.0.0-142.70.255.255, BJ
        [ 0x8E560000, 0x8E56FFFF, "BJ" ],  // 142.86.0.0-142.86.255.255, BJ
        [ 0x8F400000, 0x8F40FFFF, "BJ" ],  // 143.64.0.0-143.64.255.255, BJ
        [ 0x90000000, 0x9000FFFF, "SD" ],  // 144.0.0.0-144.0.255.255, SD
        [ 0x90070000, 0x90077FFF, "HE" ],  // 144.7.0.0-144.7.127.255, HE
        [ 0x90078000, 0x9007FFFF, "SD" ],  // 144.7.128.0-144.7.255.255, SD
        [ 0x900C0000, 0x900CFFFF, "SD" ],  // 144.12.0.0-144.12.255.255, SD
        [ 0x90304000, 0x903043FF, "AH" ],  // 144.48.64.0-144.48.67.255, AH
        [ 0x90305800, 0x90305BFF, "BJ" ],  // 144.48.88.0-144.48.91.255, BJ
        [ 0x90309C00, 0x90309FFF, "BJ" ],  // 144.48.156.0-144.48.159.255, BJ
        [ 0x9030B400, 0x9030BBFF, "SH" ],  // 144.48.180.0-144.48.187.255, SH
        [ 0x9030CC00, 0x9030CFFF, "LN" ],  // 144.48.204.0-144.48.207.255, LN
        [ 0x9030D000, 0x9030D3FF, "BJ" ],  // 144.48.208.0-144.48.211.255, BJ
        [ 0x9030D400, 0x9030D7FF, "JS" ],  // 144.48.212.0-144.48.215.255, JS
        [ 0x9030DC00, 0x9030DFFF, "GD" ],  // 144.48.220.0-144.48.223.255, GD
        [ 0x9030FC00, 0x9030FFFF, "BJ" ],  // 144.48.252.0-144.48.255.255, BJ
        [ 0x90340000, 0x9034FFFF, "SD" ],  // 144.52.0.0-144.52.255.255, SD
        [ 0x907B0000, 0x907BFFFF, "SD" ],  // 144.123.0.0-144.123.255.255, SD
        [ 0x90B21E30, 0x90B21E3F, "TJ" ],  // 144.178.30.48-144.178.30.63, TJ
        [ 0x90FF0000, 0x90FFFFFF, "SD" ],  // 144.255.0.0-144.255.255.255, SD
        [ 0x9238C000, 0x9238FFFF, "JS" ],  // 146.56.192.0-146.56.255.255, JS
        [ 0x924BC400, 0x924BC401, "UNK" ],  // 146.75.196.0-146.75.196.1, UNK
        [ 0x92C43800, 0x92C43BFF, "SH" ],  // 146.196.56.0-146.196.59.255, SH
        [ 0x92C44400, 0x92C447FF, "JS" ],  // 146.196.68.0-146.196.71.255, JS
        [ 0x92C44800, 0x92C44BFF, "LN" ],  // 146.196.72.0-146.196.75.255, LN
        [ 0x92C45C00, 0x92C45FFF, "GD" ],  // 146.196.92.0-146.196.95.255, GD
        [ 0x92C47000, 0x92C473FF, "LN" ],  // 146.196.112.0-146.196.115.255, LN
        [ 0x92C47400, 0x92C477FF, "BJ" ],  // 146.196.116.0-146.196.119.255, BJ
        [ 0x92C47C00, 0x92C47FFF, "LN" ],  // 146.196.124.0-146.196.127.255, LN
        [ 0x93F36700, 0x93F3677F, "BJ" ],  // 147.243.103.0-147.243.103.127, BJ
        [ 0x94460000, 0x9446FFFF, "SC" ],  // 148.70.0.0-148.70.255.255, SC
        [ 0x95290000, 0x9529FFFF, "BJ" ],  // 149.41.0.0-149.41.255.255, BJ
        [ 0x96000000, 0x9600FFFF, "SD" ],  // 150.0.0.0-150.0.255.255, SD
        [ 0x96730000, 0x9673FFFF, "SD" ],  // 150.115.0.0-150.115.255.255, SD
        [ 0x96790000, 0x967AFFFF, "SD" ],  // 150.121.0.0-150.122.255.255, SD
        [ 0x96818800, 0x96818BFF, "TJ" ],  // 150.129.136.0-150.129.139.255, TJ
        [ 0x9681C000, 0x9681C3FF, "SH" ],  // 150.129.192.0-150.129.195.255, SH
        [ 0x9681FC00, 0x9681FFFF, "JS" ],  // 150.129.252.0-150.129.255.255, JS
        [ 0x968A0000, 0x968BFFFF, "SD" ],  // 150.138.0.0-150.139.255.255, SD
        [ 0x969E0000, 0x969EFFFF, "SH" ],  // 150.158.0.0-150.158.255.255, SH
        [ 0x96DE4000, 0x96DE40FF, "BJ" ],  // 150.222.64.0-150.222.64.255, BJ
        [ 0x96DE5800, 0x96DE59FF, "BJ" ],  // 150.222.88.0-150.222.89.255, BJ
        [ 0x96DF0000, 0x96DFFFFF, "NM" ],  // 150.223.0.0-150.223.255.255, NM
        [ 0x96F20000, 0x96F203FF, "BJ" ],  // 150.242.0.0-150.242.3.255, BJ
        [ 0x96F20400, 0x96F207FF, "SH" ],  // 150.242.4.0-150.242.7.255, SH
        [ 0x96F20800, 0x96F20BFF, "HE" ],  // 150.242.8.0-150.242.11.255, HE
        [ 0x96F21C00, 0x96F21FFF, "ZJ" ],  // 150.242.28.0-150.242.31.255, ZJ
        [ 0x96F22C00, 0x96F237FF, "BJ" ],  // 150.242.44.0-150.242.55.255, BJ
        [ 0x96F23800, 0x96F23BFF, "GD" ],  // 150.242.56.0-150.242.59.255, GD
        [ 0x96F24C00, 0x96F24FFF, "BJ" ],  // 150.242.76.0-150.242.79.255, BJ
        [ 0x96F25000, 0x96F253FF, "FJ" ],  // 150.242.80.0-150.242.83.255, FJ
        [ 0x96F25C00, 0x96F25FFF, "BJ" ],  // 150.242.92.0-150.242.95.255, BJ
        [ 0x96F26000, 0x96F263FF, "FJ" ],  // 150.242.96.0-150.242.99.255, FJ
        [ 0x96F27000, 0x96F273FF, "SH" ],  // 150.242.112.0-150.242.115.255, SH
        [ 0x96F27400, 0x96F277FF, "SD" ],  // 150.242.116.0-150.242.119.255, SD
        [ 0x96F27800, 0x96F27BFF, "BJ" ],  // 150.242.120.0-150.242.123.255, BJ
        [ 0x96F29800, 0x96F29BFF, "SD" ],  // 150.242.152.0-150.242.155.255, SD
        [ 0x96F29C00, 0x96F2ABFF, "BJ" ],  // 150.242.156.0-150.242.171.255, BJ
        [ 0x96F2B800, 0x96F2C3FF, "BJ" ],  // 150.242.184.0-150.242.195.255, BJ
        [ 0x96F2D400, 0x96F2D4FF, "BJ" ],  // 150.242.212.0-150.242.212.255, BJ
        [ 0x96F2E000, 0x96F2E3FF, "GD" ],  // 150.242.224.0-150.242.227.255, GD
        [ 0x96F2E800, 0x96F2EBFF, "TJ" ],  // 150.242.232.0-150.242.235.255, TJ
        [ 0x96F2EC00, 0x96F2EFFF, "SH" ],  // 150.242.236.0-150.242.239.255, SH
        [ 0x96F2F000, 0x96F2F3FF, "ZJ" ],  // 150.242.240.0-150.242.243.255, ZJ
        [ 0x96F2F400, 0x96F2F7FF, "JS" ],  // 150.242.244.0-150.242.247.255, JS
        [ 0x96F2F800, 0x96F2FBFF, "BJ" ],  // 150.242.248.0-150.242.251.255, BJ
        [ 0x96F80000, 0x96F8FFFF, "BJ" ],  // 150.248.0.0-150.248.255.255, BJ
        [ 0x96FF0000, 0x96FFFFFF, "HI" ],  // 150.255.0.0-150.255.255.255, HI
        [ 0x98688000, 0x986881FF, "GD" ],  // 152.104.128.0-152.104.129.255, GD
        [ 0x98688200, 0x986882FF, "BJ" ],  // 152.104.130.0-152.104.130.255, BJ
        [ 0x98688300, 0x986895FF, "GD" ],  // 152.104.131.0-152.104.149.255, GD
        [ 0x98689600, 0x986896FF, "BJ" ],  // 152.104.150.0-152.104.150.255, BJ
        [ 0x98689700, 0x9868DFFF, "GD" ],  // 152.104.151.0-152.104.223.255, GD
        [ 0x9868E000, 0x9868E3FF, "BJ" ],  // 152.104.224.0-152.104.227.255, BJ
        [ 0x9868E400, 0x9868FFFF, "GD" ],  // 152.104.228.0-152.104.255.255, GD
        [ 0x98880000, 0x98883FFF, "BJ" ],  // 152.136.0.0-152.136.63.255, BJ
        [ 0x98884000, 0x98885FFF, "TJ" ],  // 152.136.64.0-152.136.95.255, TJ
        [ 0x98886000, 0x9888FFFF, "BJ" ],  // 152.136.96.0-152.136.255.255, BJ
        [ 0x99000000, 0x9900FFFF, "HI" ],  // 153.0.0.0-153.0.255.255, HI
        [ 0x99030000, 0x9903FFFF, "JS" ],  // 153.3.0.0-153.3.255.255, JS
        [ 0x99220000, 0x9925FFFF, "JS" ],  // 153.34.0.0-153.37.255.255, JS
        [ 0x99630000, 0x9963FFFF, "JS" ],  // 153.99.0.0-153.99.255.255, JS
        [ 0x99650000, 0x9965FFFF, "JS" ],  // 153.101.0.0-153.101.255.255, JS
        [ 0x99760000, 0x9977FFFF, "SD" ],  // 153.118.0.0-153.119.255.255, SD
        [ 0x9A088000, 0x9A0887FF, "TJ" ],  // 154.8.128.0-154.8.135.255, TJ
        [ 0x9A088800, 0x9A08EFFF, "BJ" ],  // 154.8.136.0-154.8.239.255, BJ
        [ 0x9A08F000, 0x9A08FFFF, "TJ" ],  // 154.8.240.0-154.8.255.255, TJ
        [ 0x9A138000, 0x9A139BFF, "BJ" ],  // 154.19.128.0-154.19.155.255, BJ
        [ 0x9A139D00, 0x9A139FFF, "BJ" ],  // 154.19.157.0-154.19.159.255, BJ
        [ 0x9A13A000, 0x9A13A7FF, "GD" ],  // 154.19.160.0-154.19.167.255, GD
        [ 0x9A512800, 0x9A5128FF, "CQ" ],  // 154.81.40.0-154.81.40.255, CQ
        [ 0x9A512900, 0x9A5129FF, "SC" ],  // 154.81.41.0-154.81.41.255, SC
        [ 0x9A512A00, 0x9A512BFF, "SH" ],  // 154.81.42.0-154.81.43.255, SH
        [ 0x9A512C00, 0x9A512DFF, "BJ" ],  // 154.81.44.0-154.81.45.255, BJ
        [ 0x9AD91F00, 0x9AD921FF, "SH" ],  // 154.217.31.0-154.217.33.255, SH
        [ 0x9B7EB000, 0x9B7EB1FF, "SH" ],  // 155.126.176.0-155.126.177.255, SH
        [ 0x9C6BA000, 0x9C6BA0FF, "BJ" ],  // 156.107.160.0-156.107.160.255, BJ
        [ 0x9C6BB200, 0x9C6BB5FF, "SH" ],  // 156.107.178.0-156.107.181.255, SH
        [ 0x9C9A3E00, 0x9C9A3EFF, "BJ" ],  // 156.154.62.0-156.154.62.255, BJ
        [ 0x9C9A3F00, 0x9C9A3FFF, "SH" ],  // 156.154.63.0-156.154.63.255, SH
        [ 0x9D000000, 0x9D00FFFF, "JS" ],  // 157.0.0.0-157.0.255.255, JS
        [ 0x9D0A2200, 0x9D0A23FF, "SH" ],  // 157.10.34.0-157.10.35.255, SH
        [ 0x9D0A2400, 0x9D0A25FF, "GX" ],  // 157.10.36.0-157.10.37.255, GX
        [ 0x9D0A7000, 0x9D0A71FF, "JS" ],  // 157.10.112.0-157.10.113.255, JS
        [ 0x9D0A7600, 0x9D0A77FF, "BJ" ],  // 157.10.118.0-157.10.119.255, BJ
        [ 0x9D0A8200, 0x9D0A83FF, "BJ" ],  // 157.10.130.0-157.10.131.255, BJ
        [ 0x9D0ADA00, 0x9D0ADBFF, "BJ" ],  // 157.10.218.0-157.10.219.255, BJ
        [ 0x9D0ADC00, 0x9D0ADDFF, "ZJ" ],  // 157.10.220.0-157.10.221.255, ZJ
        [ 0x9D0AF600, 0x9D0AF7FF, "SH" ],  // 157.10.246.0-157.10.247.255, SH
        [ 0x9D0F4A00, 0x9D0F4BFF, "HN" ],  // 157.15.74.0-157.15.75.255, HN
        [ 0x9D0F5E00, 0x9D0F5FFF, "ZJ" ],  // 157.15.94.0-157.15.95.255, ZJ
        [ 0x9D0F6400, 0x9D0F65FF, "BJ" ],  // 157.15.100.0-157.15.101.255, BJ
        [ 0x9D0F6600, 0x9D0F67FF, "HI" ],  // 157.15.102.0-157.15.103.255, HI
        [ 0x9D0F6800, 0x9D0F69FF, "ZJ" ],  // 157.15.104.0-157.15.105.255, ZJ
        [ 0x9D120000, 0x9D12FFFF, "GD" ],  // 157.18.0.0-157.18.255.255, GD
        [ 0x9D142100, 0x9D1421FF, "HN" ],  // 157.20.33.0-157.20.33.255, HN
        [ 0x9D148800, 0x9D1489FF, "SH" ],  // 157.20.136.0-157.20.137.255, SH
        [ 0x9D14C200, 0x9D14C3FF, "GS" ],  // 157.20.194.0-157.20.195.255, GS
        [ 0x9D14F600, 0x9D14F7FF, "SC" ],  // 157.20.246.0-157.20.247.255, SC
        [ 0x9D3D0000, 0x9D3DFFFF, "GD" ],  // 157.61.0.0-157.61.255.255, GD
        [ 0x9D422A00, 0x9D422BFF, "LN" ],  // 157.66.42.0-157.66.43.255, LN
        [ 0x9D424600, 0x9D4247FF, "UNK" ],  // 157.66.70.0-157.66.71.255, UNK
        [ 0x9D425800, 0x9D425FFF, "JX" ],  // 157.66.88.0-157.66.95.255, JX
        [ 0x9D42A400, 0x9D42A5FF, "SC" ],  // 157.66.164.0-157.66.165.255, SC
        [ 0x9D42F400, 0x9D42F5FF, "ZJ" ],  // 157.66.244.0-157.66.245.255, ZJ
        [ 0x9D770000, 0x9D7703FF, "SH" ],  // 157.119.0.0-157.119.3.255, SH
        [ 0x9D770800, 0x9D7713FF, "FJ" ],  // 157.119.8.0-157.119.19.255, FJ
        [ 0x9D771C00, 0x9D771FFF, "GZ" ],  // 157.119.28.0-157.119.31.255, GZ
        [ 0x9D778400, 0x9D77A7FF, "BJ" ],  // 157.119.132.0-157.119.167.255, BJ
        [ 0x9D77AC00, 0x9D77AFFF, "BJ" ],  // 157.119.172.0-157.119.175.255, BJ
        [ 0x9D77C000, 0x9D77C3FF, "ZJ" ],  // 157.119.192.0-157.119.195.255, ZJ
        [ 0x9D77C400, 0x9D77C7FF, "FJ" ],  // 157.119.196.0-157.119.199.255, FJ
        [ 0x9D77F000, 0x9D77F3FF, "ZJ" ],  // 157.119.240.0-157.119.243.255, ZJ
        [ 0x9D77FC00, 0x9D77FFFF, "JS" ],  // 157.119.252.0-157.119.255.255, JS
        [ 0x9D7A0000, 0x9D7AFFFF, "GD" ],  // 157.122.0.0-157.122.255.255, GD
        [ 0x9D85BA00, 0x9D85BBFF, "SH" ],  // 157.133.186.0-157.133.187.255, SH
        [ 0x9D85C000, 0x9D85C7FF, "SH" ],  // 157.133.192.0-157.133.199.255, SH
        [ 0x9D940000, 0x9D94FFFF, "GD" ],  // 157.148.0.0-157.148.255.255, GD
        [ 0x9D9C0000, 0x9D9CFFFF, "GD" ],  // 157.156.0.0-157.156.255.255, GD
        [ 0x9DFF0000, 0x9DFFFFFF, "GD" ],  // 157.255.0.0-157.255.255.255, GD
        [ 0x9E323000, 0x9E3231FF, "BJ" ],  // 158.50.48.0-158.50.49.255, BJ
        [ 0x9E3C0000, 0x9E3CFFFF, "GZ" ],  // 158.60.0.0-158.60.255.255, GZ
        [ 0x9E4F0000, 0x9E4F00FF, "BJ" ],  // 158.79.0.0-158.79.0.255, BJ
        [ 0x9E4F0200, 0x9E4FFFFF, "BJ" ],  // 158.79.2.0-158.79.255.255, BJ
        [ 0x9E8CFC00, 0x9E8CFFFF, "GD" ],  // 158.140.252.0-158.140.255.255, GD
        [ 0x9F1B0000, 0x9F1B0FFF, "SH" ],  // 159.27.0.0-159.27.15.255, SH
        [ 0x9F1B1000, 0x9F1B157F, "BJ" ],  // 159.27.16.0-159.27.21.127, BJ
        [ 0x9F1B1580, 0x9F1BC1FF, "SH" ],  // 159.27.21.128-159.27.193.255, SH
        [ 0x9F1BC200, 0x9F1BC3FF, "BJ" ],  // 159.27.194.0-159.27.195.255, BJ
        [ 0x9F1BC400, 0x9F1BC4FF, "SH" ],  // 159.27.196.0-159.27.196.255, SH
        [ 0x9F1BC500, 0x9F1BC59F, "BJ" ],  // 159.27.197.0-159.27.197.159, BJ
        [ 0x9F1BC5A0, 0x9F1BFFFF, "SH" ],  // 159.27.197.160-159.27.255.255, SH
        [ 0x9F4B0000, 0x9F4BFFFF, "GD" ],  // 159.75.0.0-159.75.255.255, GD
        [ 0x9F997800, 0x9F997BFF, "SH" ],  // 159.153.120.0-159.153.123.255, SH
        [ 0x9FDDE800, 0x9FDDE8FF, "SH" ],  // 159.221.232.0-159.221.232.255, SH
        [ 0x9FE20000, 0x9FE244FF, "BJ" ],  // 159.226.0.0-159.226.68.255, BJ
        [ 0x9FE24500, 0x9FE245FF, "YN" ],  // 159.226.69.0-159.226.69.255, YN
        [ 0x9FE24600, 0x9FE246FF, "BJ" ],  // 159.226.70.0-159.226.70.255, BJ
        [ 0x9FE24700, 0x9FE24BFF, "JS" ],  // 159.226.71.0-159.226.75.255, JS
        [ 0x9FE24C00, 0x9FE2657F, "BJ" ],  // 159.226.76.0-159.226.101.127, BJ
        [ 0x9FE26580, 0x9FE265FF, "JS" ],  // 159.226.101.128-159.226.101.255, JS
        [ 0x9FE26600, 0x9FE266FF, "BJ" ],  // 159.226.102.0-159.226.102.255, BJ
        [ 0x9FE26700, 0x9FE268FF, "JS" ],  // 159.226.103.0-159.226.104.255, JS
        [ 0x9FE26900, 0x9FE269FF, "BJ" ],  // 159.226.105.0-159.226.105.255, BJ
        [ 0x9FE26A00, 0x9FE26AFF, "JS" ],  // 159.226.106.0-159.226.106.255, JS
        [ 0x9FE26B00, 0x9FE26BFF, "BJ" ],  // 159.226.107.0-159.226.107.255, BJ
        [ 0x9FE26C00, 0x9FE26C7F, "JS" ],  // 159.226.108.0-159.226.108.127, JS
        [ 0x9FE26C80, 0x9FE26CFF, "HE" ],  // 159.226.108.128-159.226.108.255, HE
        [ 0x9FE26D00, 0x9FE26DFF, "QH" ],  // 159.226.109.0-159.226.109.255, QH
        [ 0x9FE26E00, 0x9FE277FF, "BJ" ],  // 159.226.110.0-159.226.119.255, BJ
        [ 0x9FE27800, 0x9FE279FF, "JS" ],  // 159.226.120.0-159.226.121.255, JS
        [ 0x9FE27A00, 0x9FE27BFF, "JL" ],  // 159.226.122.0-159.226.123.255, JL
        [ 0x9FE27C00, 0x9FE27FFF, "HB" ],  // 159.226.124.0-159.226.127.255, HB
        [ 0x9FE28000, 0x9FE282FF, "SH" ],  // 159.226.128.0-159.226.130.255, SH
        [ 0x9FE28300, 0x9FE283FF, "BJ" ],  // 159.226.131.0-159.226.131.255, BJ
        [ 0x9FE28400, 0x9FE287FF, "XJ" ],  // 159.226.132.0-159.226.135.255, XJ
        [ 0x9FE28800, 0x9FE28AFF, "BJ" ],  // 159.226.136.0-159.226.138.255, BJ
        [ 0x9FE28B00, 0x9FE28BFF, "SN" ],  // 159.226.139.0-159.226.139.255, SN
        [ 0x9FE28C00, 0x9FE28FFF, "SC" ],  // 159.226.140.0-159.226.143.255, SC
        [ 0x9FE29000, 0x9FE290FF, "BJ" ],  // 159.226.144.0-159.226.144.255, BJ
        [ 0x9FE29100, 0x9FE292FF, "GD" ],  // 159.226.145.0-159.226.146.255, GD
        [ 0x9FE29300, 0x9FE293FF, "HN" ],  // 159.226.147.0-159.226.147.255, HN
        [ 0x9FE29400, 0x9FE295FF, "YN" ],  // 159.226.148.0-159.226.149.255, YN
        [ 0x9FE29600, 0x9FE296FF, "FJ" ],  // 159.226.150.0-159.226.150.255, FJ
        [ 0x9FE29700, 0x9FE297FF, "GZ" ],  // 159.226.151.0-159.226.151.255, GZ
        [ 0x9FE29800, 0x9FE298FF, "HN" ],  // 159.226.152.0-159.226.152.255, HN
        [ 0x9FE29900, 0x9FE29AFF, "SN" ],  // 159.226.153.0-159.226.154.255, SN
        [ 0x9FE29B00, 0x9FE29BFF, "QH" ],  // 159.226.155.0-159.226.155.255, QH
        [ 0x9FE29C00, 0x9FE29CFF, "SX" ],  // 159.226.156.0-159.226.156.255, SX
        [ 0x9FE29D00, 0x9FE29DFF, "HE" ],  // 159.226.157.0-159.226.157.255, HE
        [ 0x9FE29E00, 0x9FE29EFF, "SD" ],  // 159.226.158.0-159.226.158.255, SD
        [ 0x9FE29F00, 0x9FE29FFF, "LN" ],  // 159.226.159.0-159.226.159.255, LN
        [ 0x9FE2A000, 0x9FE2A1FF, "BJ" ],  // 159.226.160.0-159.226.161.255, BJ
        [ 0x9FE2A200, 0x9FE2A3FF, "HB" ],  // 159.226.162.0-159.226.163.255, HB
        [ 0x9FE2A400, 0x9FE2A4FF, "BJ" ],  // 159.226.164.0-159.226.164.255, BJ
        [ 0x9FE2A500, 0x9FE2A6FF, "JL" ],  // 159.226.165.0-159.226.166.255, JL
        [ 0x9FE2A700, 0x9FE2A7FF, "SC" ],  // 159.226.167.0-159.226.167.255, SC
        [ 0x9FE2A800, 0x9FE2D07F, "BJ" ],  // 159.226.168.0-159.226.208.127, BJ
        [ 0x9FE2D080, 0x9FE2D0FF, "HL" ],  // 159.226.208.128-159.226.208.255, HL
        [ 0x9FE2D100, 0x9FE2DDFF, "BJ" ],  // 159.226.209.0-159.226.221.255, BJ
        [ 0x9FE2DE00, 0x9FE2DEFF, "SH" ],  // 159.226.222.0-159.226.222.255, SH
        [ 0x9FE2DF00, 0x9FE2EDFF, "BJ" ],  // 159.226.223.0-159.226.237.255, BJ
        [ 0x9FE2EE00, 0x9FE2EEFF, "LN" ],  // 159.226.238.0-159.226.238.255, LN
        [ 0x9FE2EF00, 0x9FE2F8FF, "BJ" ],  // 159.226.239.0-159.226.248.255, BJ
        [ 0x9FE2F900, 0x9FE2F9FF, "YN" ],  // 159.226.249.0-159.226.249.255, YN
        [ 0x9FE2FA00, 0x9FE2FFFF, "BJ" ],  // 159.226.250.0-159.226.255.255, BJ
        [ 0xA0134C00, 0xA0134DFF, "SC" ],  // 160.19.76.0-160.19.77.255, SC
        [ 0xA0135200, 0xA01353FF, "SC" ],  // 160.19.82.0-160.19.83.255, SC
        [ 0xA013D000, 0xA013D3FF, "GD" ],  // 160.19.208.0-160.19.211.255, GD
        [ 0xA013D400, 0xA013D7FF, "BJ" ],  // 160.19.212.0-160.19.215.255, BJ
        [ 0xA013D800, 0xA013DBFF, "HB" ],  // 160.19.216.0-160.19.219.255, HB
        [ 0xA0141000, 0xA01411FF, "UNK" ],  // 160.20.16.0-160.20.17.255, UNK
        [ 0xA0141200, 0xA01413FF, "BJ" ],  // 160.20.18.0-160.20.19.255, BJ
        [ 0xA0143000, 0xA01433FF, "BJ" ],  // 160.20.48.0-160.20.51.255, BJ
        [ 0xA0148200, 0xA01483FF, "LN" ],  // 160.20.130.0-160.20.131.255, LN
        [ 0xA0163A00, 0xA0163BFF, "HA" ],  // 160.22.58.0-160.22.59.255, HA
        [ 0xA0165200, 0xA01653FF, "GD" ],  // 160.22.82.0-160.22.83.255, GD
        [ 0xA0169400, 0xA01695FF, "AH" ],  // 160.22.148.0-160.22.149.255, AH
        [ 0xA016BC00, 0xA016BDFF, "UNK" ],  // 160.22.188.0-160.22.189.255, UNK
        [ 0xA016E000, 0xA016E1FF, "SH" ],  // 160.22.224.0-160.22.225.255, SH
        [ 0xA016E600, 0xA016E7FF, "SC" ],  // 160.22.230.0-160.22.231.255, SC
        [ 0xA016F400, 0xA016F5FF, "AH" ],  // 160.22.244.0-160.22.245.255, AH
        [ 0xA016F600, 0xA016F7FF, "ZJ" ],  // 160.22.246.0-160.22.247.255, ZJ
        [ 0xA0190A00, 0xA0190BFF, "SH" ],  // 160.25.10.0-160.25.11.255, SH
        [ 0xA0190C00, 0xA0190DFF, "ZJ" ],  // 160.25.12.0-160.25.13.255, ZJ
        [ 0xA0191400, 0xA01915FF, "TJ" ],  // 160.25.20.0-160.25.21.255, TJ
        [ 0xA019C200, 0xA019C3FF, "JS" ],  // 160.25.194.0-160.25.195.255, JS
        [ 0xA01E2800, 0xA01E29FF, "BJ" ],  // 160.30.40.0-160.30.41.255, BJ
        [ 0xA01E9400, 0xA01E95FF, "GD" ],  // 160.30.148.0-160.30.149.255, GD
        [ 0xA01E9600, 0xA01E97FF, "BJ" ],  // 160.30.150.0-160.30.151.255, BJ
        [ 0xA01EC200, 0xA01EC3FF, "HN" ],  // 160.30.194.0-160.30.195.255, HN
        [ 0xA01EC400, 0xA01EC7FF, "BJ" ],  // 160.30.196.0-160.30.199.255, BJ
        [ 0xA01EE600, 0xA01EE7FF, "UNK" ],  // 160.30.230.0-160.30.231.255, UNK
        [ 0xA0536E00, 0xA0536EFF, "SH" ],  // 160.83.110.0-160.83.110.255, SH
        [ 0xA0BBDF00, 0xA0BBDFFF, "GD" ],  // 160.187.223.0-160.187.223.255, GD
        [ 0xA0BBFC00, 0xA0BBFFFF, "BJ" ],  // 160.187.252.0-160.187.255.255, BJ
        [ 0xA0BF0000, 0xA0BF01FF, "BJ" ],  // 160.191.0.0-160.191.1.255, BJ
        [ 0xA0BF6800, 0xA0BF69FF, "UNK" ],  // 160.191.104.0-160.191.105.255, UNK
        [ 0xA0BF6E00, 0xA0BF6FFF, "UNK" ],  // 160.191.110.0-160.191.111.255, UNK
        [ 0xA0CA3C00, 0xA0CA3EFF, "TJ" ],  // 160.202.60.0-160.202.62.255, TJ
        [ 0xA0CA3F00, 0xA0CA3FFF, "BJ" ],  // 160.202.63.0-160.202.63.255, BJ
        [ 0xA0CA9400, 0xA0CA9BFF, "TJ" ],  // 160.202.148.0-160.202.155.255, TJ
        [ 0xA0CAA800, 0xA0CAABFF, "GD" ],  // 160.202.168.0-160.202.171.255, GD
        [ 0xA0CAD400, 0xA0CAD7FF, "JS" ],  // 160.202.212.0-160.202.215.255, JS
        [ 0xA0CAD800, 0xA0CAFFFF, "SH" ],  // 160.202.216.0-160.202.255.255, SH
        [ 0xA0FA0E00, 0xA0FA0FFF, "TJ" ],  // 160.250.14.0-160.250.15.255, TJ
        [ 0xA0FA1000, 0xA0FA13FF, "UNK" ],  // 160.250.16.0-160.250.19.255, UNK
        [ 0xA0FA1800, 0xA0FA19FF, "GD" ],  // 160.250.24.0-160.250.25.255, GD
        [ 0xA0FA5400, 0xA0FA55FF, "GD" ],  // 160.250.84.0-160.250.85.255, GD
        [ 0xA0FA5A00, 0xA0FA5BFF, "SX" ],  // 160.250.90.0-160.250.91.255, SX
        [ 0xA0FA6600, 0xA0FA69FF, "HL" ],  // 160.250.102.0-160.250.105.255, HL
        [ 0xA0FA8C00, 0xA0FA8CFF, "GX" ],  // 160.250.140.0-160.250.140.255, GX
        [ 0xA0FAA000, 0xA0FAA1FF, "SD" ],  // 160.250.160.0-160.250.161.255, SD
        [ 0xA0FAAA00, 0xA0FAABFF, "FJ" ],  // 160.250.170.0-160.250.171.255, FJ
        [ 0xA0FAD600, 0xA0FAD7FF, "BJ" ],  // 160.250.214.0-160.250.215.255, BJ
        [ 0xA0FAFC00, 0xA0FAFDFF, "JS" ],  // 160.250.252.0-160.250.253.255, JS
        [ 0xA1780000, 0xA178FFFF, "BJ" ],  // 161.120.0.0-161.120.255.255, BJ
        [ 0xA17B4600, 0xA17B47FF, "SH" ],  // 161.123.70.0-161.123.71.255, SH
        [ 0xA17B5E00, 0xA17B5FFF, "SH" ],  // 161.123.94.0-161.123.95.255, SH
        [ 0xA1BD0000, 0xA1BDFFFF, "NX" ],  // 161.189.0.0-161.189.255.255, NX
        [ 0xA1CF0000, 0xA1CFFFFF, "BJ" ],  // 161.207.0.0-161.207.255.255, BJ
        [ 0xA1F81400, 0xA1F815FF, "HE" ],  // 161.248.20.0-161.248.21.255, HE
        [ 0xA1F82A00, 0xA1F82BFF, "BJ" ],  // 161.248.42.0-161.248.43.255, BJ
        [ 0xA1F85400, 0xA1F855FF, "GD" ],  // 161.248.84.0-161.248.85.255, GD
        [ 0xA1F85C00, 0xA1F85DFF, "BJ" ],  // 161.248.92.0-161.248.93.255, BJ
        [ 0xA20E0000, 0xA20E07FF, "TJ" ],  // 162.14.0.0-162.14.7.255, TJ
        [ 0xA20E0800, 0xA20E0AFF, "BJ" ],  // 162.14.8.0-162.14.10.255, BJ
        [ 0xA20E0B00, 0xA20E0FFF, "SH" ],  // 162.14.11.0-162.14.15.255, SH
        [ 0xA20E1000, 0xA20E3BFF, "BJ" ],  // 162.14.16.0-162.14.59.255, BJ
        [ 0xA20E4000, 0xA20E7FFF, "SC" ],  // 162.14.64.0-162.14.127.255, SC
        [ 0xA20E8000, 0xA20E9FFF, "SH" ],  // 162.14.128.0-162.14.159.255, SH
        [ 0xA20EA000, 0xA20EAFFF, "BJ" ],  // 162.14.160.0-162.14.175.255, BJ
        [ 0xA20EB000, 0xA20EBFFF, "TJ" ],  // 162.14.176.0-162.14.191.255, TJ
        [ 0xA20EC000, 0xA20EFFFF, "CQ" ],  // 162.14.192.0-162.14.255.255, CQ
        [ 0xA2690000, 0xA269FFFF, "BJ" ],  // 162.105.0.0-162.105.255.255, BJ
        [ 0xA3000000, 0xA300FFFF, "GD" ],  // 163.0.0.0-163.0.255.255, GD
        [ 0xA32F0400, 0xA32F07FF, "SH" ],  // 163.47.4.0-163.47.7.255, SH
        [ 0xA3350000, 0xA33503FF, "GD" ],  // 163.53.0.0-163.53.3.255, GD
        [ 0xA3350400, 0xA33507FF, "ZJ" ],  // 163.53.4.0-163.53.7.255, ZJ
        [ 0xA3350800, 0xA3350BFF, "BJ" ],  // 163.53.8.0-163.53.11.255, BJ
        [ 0xA3350C00, 0xA3350FFF, "HA" ],  // 163.53.12.0-163.53.15.255, HA
        [ 0xA3352400, 0xA3352FFF, "BJ" ],  // 163.53.36.0-163.53.47.255, BJ
        [ 0xA3353000, 0xA33533FF, "TJ" ],  // 163.53.48.0-163.53.51.255, TJ
        [ 0xA3353400, 0xA33537FF, "AH" ],  // 163.53.52.0-163.53.55.255, AH
        [ 0xA3353800, 0xA3353BFF, "HA" ],  // 163.53.56.0-163.53.59.255, HA
        [ 0xA3353C00, 0xA3353FFF, "BJ" ],  // 163.53.60.0-163.53.63.255, BJ
        [ 0xA3354000, 0xA33543FF, "TJ" ],  // 163.53.64.0-163.53.67.255, TJ
        [ 0xA3355800, 0xA3358BFF, "SH" ],  // 163.53.88.0-163.53.139.255, SH
        [ 0xA335A000, 0xA335A3FF, "TJ" ],  // 163.53.160.0-163.53.163.255, TJ
        [ 0xA335A400, 0xA335A7FF, "SH" ],  // 163.53.164.0-163.53.167.255, SH
        [ 0xA335A800, 0xA335ABFF, "JS" ],  // 163.53.168.0-163.53.171.255, JS
        [ 0xA335AC00, 0xA335AFFF, "BJ" ],  // 163.53.172.0-163.53.175.255, BJ
        [ 0xA335BC00, 0xA335BFFF, "HL" ],  // 163.53.188.0-163.53.191.255, HL
        [ 0xA335F000, 0xA335F3FF, "BJ" ],  // 163.53.240.0-163.53.243.255, BJ
        [ 0xA33D3E00, 0xA33D3FFF, "UNK" ],  // 163.61.62.0-163.61.63.255, UNK
        [ 0xA33D7100, 0xA33D71FF, "UNK" ],  // 163.61.113.0-163.61.113.255, UNK
        [ 0xA33DB200, 0xA33DB3FF, "UNK" ],  // 163.61.178.0-163.61.179.255, UNK
        [ 0xA33DCA00, 0xA33DCBFF, "UNK" ],  // 163.61.202.0-163.61.203.255, UNK
        [ 0xA33DD600, 0xA33DD7FF, "UNK" ],  // 163.61.214.0-163.61.215.255, UNK
        [ 0xA37D0000, 0xA37DFFFF, "GD" ],  // 163.125.0.0-163.125.255.255, GD
        [ 0xA38E0000, 0xA38EFFFF, "GD" ],  // 163.142.0.0-163.142.255.255, GD
        [ 0xA3B10000, 0xA3B1FFFF, "GD" ],  // 163.177.0.0-163.177.255.255, GD
        [ 0xA3B30000, 0xA3B3FFFF, "GD" ],  // 163.179.0.0-163.179.255.255, GD
        [ 0xA3CC0000, 0xA3CCFFFF, "GD" ],  // 163.204.0.0-163.204.255.255, GD
        [ 0xA3E40000, 0xA3E42FFF, "SH" ],  // 163.228.0.0-163.228.47.255, SH
        [ 0xA3E43000, 0xA3E4357F, "BJ" ],  // 163.228.48.0-163.228.53.127, BJ
        [ 0xA3E43580, 0xA3E4FFFF, "SH" ],  // 163.228.53.128-163.228.255.255, SH
        [ 0xA3F4F600, 0xA3F4F6FF, "FJ" ],  // 163.244.246.0-163.244.246.255, FJ
        [ 0xA4345000, 0xA43450FF, "BJ" ],  // 164.52.80.0-164.52.80.255, BJ
        [ 0xA66F0000, 0xA66FFFFF, "BJ" ],  // 166.111.0.0-166.111.255.255, BJ
        [ 0xA78B0000, 0xA78BFFFF, "SH" ],  // 167.139.0.0-167.139.255.255, SH
        [ 0xA7BD0000, 0xA7BDFFFF, "BJ" ],  // 167.189.0.0-167.189.255.255, BJ
        [ 0xA7DCF400, 0xA7DCF5FF, "BJ" ],  // 167.220.244.0-167.220.245.255, BJ
        [ 0xA7DCF600, 0xA7DCF7FF, "SH" ],  // 167.220.246.0-167.220.247.255, SH
        [ 0xA89F9000, 0xA89F90FF, "SH" ],  // 168.159.144.0-168.159.144.255, SH
        [ 0xA8A00000, 0xA8A0FFFF, "BJ" ],  // 168.160.0.0-168.160.255.255, BJ
        [ 0xAA210000, 0xAA2103FF, "BJ" ],  // 170.33.0.0-170.33.3.255, BJ
        [ 0xAAB30000, 0xAAB3FFFF, "BJ" ],  // 170.179.0.0-170.179.255.255, BJ
        [ 0xAB080000, 0xAB0FFFFF, "HA" ],  // 171.8.0.0-171.15.255.255, HA
        [ 0xAB166F00, 0xAB166FFF, "BJ" ],  // 171.22.111.0-171.22.111.255, BJ
        [ 0xAB220000, 0xAB23FFFF, "JX" ],  // 171.34.0.0-171.35.255.255, JX
        [ 0xAB240000, 0xAB27FFFF, "GX" ],  // 171.36.0.0-171.39.255.255, GX
        [ 0xAB280000, 0xAB2FFFFF, "HB" ],  // 171.40.0.0-171.47.255.255, HB
        [ 0xAB500000, 0xAB53FFFF, "HB" ],  // 171.80.0.0-171.83.255.255, HB
        [ 0xAB540000, 0xAB57FFFF, "BJ" ],  // 171.84.0.0-171.87.255.255, BJ
        [ 0xAB580000, 0xAB5FFFFF, "SC" ],  // 171.88.0.0-171.95.255.255, SC
        [ 0xAB680000, 0xAB6FFFFF, "GX" ],  // 171.104.0.0-171.111.255.255, GX
        [ 0xAB700000, 0xAB73FFFF, "HB" ],  // 171.112.0.0-171.115.255.255, HB
        [ 0xAB740000, 0xAB7FFFFF, "SX" ],  // 171.116.0.0-171.127.255.255, SX
        [ 0xABD00000, 0xABDFFFFF, "SC" ],  // 171.208.0.0-171.223.255.255, SC
        [ 0xAC51C000, 0xAC51FFFF, "SH" ],  // 172.81.192.0-172.81.255.255, SH
        [ 0xAC615800, 0xAC615BFF, "BJ" ],  // 172.97.88.0-172.97.91.255, BJ
        [ 0xACE13340, 0xACE1337F, "GD" ],  // 172.225.51.64-172.225.51.127, GD
        [ 0xACE13A20, 0xACE13A3F, "XJ" ],  // 172.225.58.32-172.225.58.63, XJ
        [ 0xACE13A40, 0xACE13A7F, "GD" ],  // 172.225.58.64-172.225.58.127, GD
        [ 0xACE15000, 0xACE1503F, "GD" ],  // 172.225.80.0-172.225.80.63, GD
        [ 0xACE17E00, 0xACE17E3F, "GD" ],  // 172.225.126.0-172.225.126.63, GD
        [ 0xACE1B5C0, 0xACE1B5FF, "GD" ],  // 172.225.181.192-172.225.181.255, GD
        [ 0xACE1C820, 0xACE1C82F, "XJ" ],  // 172.225.200.32-172.225.200.47, XJ
        [ 0xACE22F00, 0xACE22F1F, "GD" ],  // 172.226.47.0-172.226.47.31, GD
        [ 0xACE28A40, 0xACE28A5F, "GD" ],  // 172.226.138.64-172.226.138.95, GD
        [ 0xAD2C1A00, 0xAD2C1BFF, "BJ" ],  // 173.44.26.0-173.44.27.255, BJ
        [ 0xAF000000, 0xAF0FFFFF, "HN" ],  // 175.0.0.0-175.15.255.255, HN
        [ 0xAF100000, 0xAF17FFFF, "JL" ],  // 175.16.0.0-175.23.255.255, JL
        [ 0xAF180000, 0xAF18F9FF, "SH" ],  // 175.24.0.0-175.24.249.255, SH
        [ 0xAF18FA00, 0xAF18FBFF, "HE" ],  // 175.24.250.0-175.24.251.255, HE
        [ 0xAF18FC00, 0xAF18FFFF, "SH" ],  // 175.24.252.0-175.24.255.255, SH
        [ 0xAF190000, 0xAF19FFFF, "BJ" ],  // 175.25.0.0-175.25.255.255, BJ
        [ 0xAF1A0000, 0xAF1AFFFF, "HE" ],  // 175.26.0.0-175.26.255.255, HE
        [ 0xAF1B0000, 0xAF1B07FF, "SH" ],  // 175.27.0.0-175.27.7.255, SH
        [ 0xAF1B0800, 0xAF1B0FFF, "TJ" ],  // 175.27.8.0-175.27.15.255, TJ
        [ 0xAF1B1000, 0xAF1B17FF, "GD" ],  // 175.27.16.0-175.27.23.255, GD
        [ 0xAF1B1800, 0xAF1B1FFF, "SC" ],  // 175.27.24.0-175.27.31.255, SC
        [ 0xAF1B2000, 0xAF1B27FF, "GD" ],  // 175.27.32.0-175.27.39.255, GD
        [ 0xAF1B2800, 0xAF1B2FFF, "JS" ],  // 175.27.40.0-175.27.47.255, JS
        [ 0xAF1B3000, 0xAF1B37FF, "CQ" ],  // 175.27.48.0-175.27.55.255, CQ
        [ 0xAF1B3800, 0xAF1B47FF, "GD" ],  // 175.27.56.0-175.27.71.255, GD
        [ 0xAF1B4800, 0xAF1B7FFF, "SC" ],  // 175.27.72.0-175.27.127.255, SC
        [ 0xAF1B8000, 0xAF1BD9FF, "JS" ],  // 175.27.128.0-175.27.217.255, JS
        [ 0xAF1BDA00, 0xAF1BDBFF, "BJ" ],  // 175.27.218.0-175.27.219.255, BJ
        [ 0xAF1BDC00, 0xAF1BFFFF, "JS" ],  // 175.27.220.0-175.27.255.255, JS
        [ 0xAF1E0000, 0xAF1FFFFF, "JL" ],  // 175.30.0.0-175.31.255.255, JL
        [ 0xAF2A0000, 0xAF2CFFFF, "FJ" ],  // 175.42.0.0-175.44.255.255, FJ
        [ 0xAF2E0000, 0xAF2FFFFF, "HL" ],  // 175.46.0.0-175.47.255.255, HL
        [ 0xAF300000, 0xAF30FFFF, "JL" ],  // 175.48.0.0-175.48.255.255, JL
        [ 0xAF310000, 0xAF31FFFF, "HE" ],  // 175.49.0.0-175.49.255.255, HE
        [ 0xAF320000, 0xAF32FFFF, "XJ" ],  // 175.50.0.0-175.50.255.255, XJ
        [ 0xAF330000, 0xAF33FFFF, "GX" ],  // 175.51.0.0-175.51.255.255, GX
        [ 0xAF340000, 0xAF3FFFFF, "JL" ],  // 175.52.0.0-175.63.255.255, JL
        [ 0xAF400000, 0xAF47FFFF, "HL" ],  // 175.64.0.0-175.71.255.255, HL
        [ 0xAF480000, 0xAF57FFFF, "BJ" ],  // 175.72.0.0-175.87.255.255, BJ
        [ 0xAF580000, 0xAF581FFF, "JS" ],  // 175.88.0.0-175.88.31.255, JS
        [ 0xAF582000, 0xAF582FFF, "HL" ],  // 175.88.32.0-175.88.47.255, HL
        [ 0xAF583000, 0xAF5FFFFF, "BJ" ],  // 175.88.48.0-175.95.255.255, BJ
        [ 0xAF660000, 0xAF66AFFF, "SH" ],  // 175.102.0.0-175.102.175.255, SH
        [ 0xAF66B000, 0xAF66B5FF, "BJ" ],  // 175.102.176.0-175.102.181.255, BJ
        [ 0xAF66B600, 0xAF66B7FF, "SH" ],  // 175.102.182.0-175.102.183.255, SH
        [ 0xAF66B800, 0xAF66B8FF, "BJ" ],  // 175.102.184.0-175.102.184.255, BJ
        [ 0xAF66B900, 0xAF66BFFF, "SH" ],  // 175.102.185.0-175.102.191.255, SH
        [ 0xAF66C000, 0xAF66C3FF, "BJ" ],  // 175.102.192.0-175.102.195.255, BJ
        [ 0xAF66C400, 0xAF66FFFF, "SH" ],  // 175.102.196.0-175.102.255.255, SH
        [ 0xAF6A8000, 0xAF6AFFFF, "HA" ],  // 175.106.128.0-175.106.255.255, HA
        [ 0xAF6F9000, 0xAF6FAFFF, "GD" ],  // 175.111.144.0-175.111.175.255, GD
        [ 0xAF6FB800, 0xAF6FBBFF, "SX" ],  // 175.111.184.0-175.111.187.255, SX
        [ 0xAF920000, 0xAF97FFFF, "LN" ],  // 175.146.0.0-175.151.255.255, LN
        [ 0xAF980000, 0xAF9BFFFF, "SC" ],  // 175.152.0.0-175.155.255.255, SC
        [ 0xAF9E6000, 0xAF9E63FF, "GX" ],  // 175.158.96.0-175.158.99.255, GX
        [ 0xAFA00000, 0xAFAFFFFF, "LN" ],  // 175.160.0.0-175.175.255.255, LN
        [ 0xAFB09C00, 0xAFB09FFF, "HN" ],  // 175.176.156.0-175.176.159.255, HN
        [ 0xAFB0B000, 0xAFB0B3FF, "SH" ],  // 175.176.176.0-175.176.179.255, SH
        [ 0xAFB0BC00, 0xAFB0BFFF, "BJ" ],  // 175.176.188.0-175.176.191.255, BJ
        [ 0xAFB20000, 0xAFB2FFFF, "GD" ],  // 175.178.0.0-175.178.255.255, GD
        [ 0xAFB88000, 0xAFB8BFFF, "QH" ],  // 175.184.128.0-175.184.191.255, QH
        [ 0xAFB90000, 0xAFBBFFFF, "SH" ],  // 175.185.0.0-175.187.255.255, SH
        [ 0xAFBC0000, 0xAFBC3FFF, "LN" ],  // 175.188.0.0-175.188.63.255, LN
        [ 0xAFBC4000, 0xAFBC9FFF, "HA" ],  // 175.188.64.0-175.188.159.255, HA
        [ 0xAFBCA000, 0xAFBCBFFF, "HE" ],  // 175.188.160.0-175.188.191.255, HE
        [ 0xAFBCC000, 0xAFBCDFFF, "GD" ],  // 175.188.192.0-175.188.223.255, GD
        [ 0xAFBCE000, 0xAFBCFFFF, "JS" ],  // 175.188.224.0-175.188.255.255, JS
        [ 0xAFBD0000, 0xAFBD00FF, "HB" ],  // 175.189.0.0-175.189.0.255, HB
        [ 0xAFBD0100, 0xAFBD7FFF, "BJ" ],  // 175.189.1.0-175.189.127.255, BJ
        [ 0xAFBD8000, 0xAFBDFFFF, "HB" ],  // 175.189.128.0-175.189.255.255, HB
        [ 0xAFBE0000, 0xAFBE7FFF, "LN" ],  // 175.190.0.0-175.190.127.255, LN
        [ 0xAFBE8000, 0xAFBEFFFF, "SD" ],  // 175.190.128.0-175.190.255.255, SD
        [ 0xAFBF0000, 0xAFBF7FFF, "BJ" ],  // 175.191.0.0-175.191.127.255, BJ
        [ 0xAFBF8000, 0xAFBF9BFF, "GD" ],  // 175.191.128.0-175.191.155.255, GD
        [ 0xAFBF9C00, 0xAFBF9DFF, "BJ" ],  // 175.191.156.0-175.191.157.255, BJ
        [ 0xAFBF9E00, 0xAFBF9FFF, "GD" ],  // 175.191.158.0-175.191.159.255, GD
        [ 0xAFBFA000, 0xAFBFBFFF, "BJ" ],  // 175.191.160.0-175.191.191.255, BJ
        [ 0xAFBFC000, 0xAFBFEFFF, "SN" ],  // 175.191.192.0-175.191.239.255, SN
        [ 0xAFBFF000, 0xAFBFF7FF, "GD" ],  // 175.191.240.0-175.191.247.255, GD
        [ 0xAFBFF800, 0xAFBFFFFF, "HA" ],  // 175.191.248.0-175.191.255.255, HA
        [ 0xB0382600, 0xB03826FF, "BJ" ],  // 176.56.38.0-176.56.38.255, BJ
        [ 0xB44C0000, 0xB44C1AFF, "BJ" ],  // 180.76.0.0-180.76.26.255, BJ
        [ 0xB44C1B00, 0xB44C1BFF, "GD" ],  // 180.76.27.0-180.76.27.255, GD
        [ 0xB44C1C00, 0xB44C1CFF, "JS" ],  // 180.76.28.0-180.76.28.255, JS
        [ 0xB44C1D00, 0xB44C23FF, "BJ" ],  // 180.76.29.0-180.76.35.255, BJ
        [ 0xB44C2400, 0xB44C27FF, "JS" ],  // 180.76.36.0-180.76.39.255, JS
        [ 0xB44C2800, 0xB44CC5FF, "BJ" ],  // 180.76.40.0-180.76.197.255, BJ
        [ 0xB44CC600, 0xB44CC7FF, "SD" ],  // 180.76.198.0-180.76.199.255, SD
        [ 0xB44CC800, 0xB44CD2FF, "BJ" ],  // 180.76.200.0-180.76.210.255, BJ
        [ 0xB44CD300, 0xB44CD3FF, "JS" ],  // 180.76.211.0-180.76.211.255, JS
        [ 0xB44CD400, 0xB44CD4FF, "GD" ],  // 180.76.212.0-180.76.212.255, GD
        [ 0xB44CD500, 0xB44CD6FF, "HB" ],  // 180.76.213.0-180.76.214.255, HB
        [ 0xB44CD700, 0xB44CD7FF, "JS" ],  // 180.76.215.0-180.76.215.255, JS
        [ 0xB44CD800, 0xB44CD8FF, "GD" ],  // 180.76.216.0-180.76.216.255, GD
        [ 0xB44CD900, 0xB44FFFFF, "BJ" ],  // 180.76.217.0-180.79.255.255, BJ
        [ 0xB4540000, 0xB4543FFF, "SC" ],  // 180.84.0.0-180.84.63.255, SC
        [ 0xB4544000, 0xB45459FF, "CQ" ],  // 180.84.64.0-180.84.89.255, CQ
        [ 0xB4545A00, 0xB4547FFF, "SC" ],  // 180.84.90.0-180.84.127.255, SC
        [ 0xB4548000, 0xB4549FFF, "YN" ],  // 180.84.128.0-180.84.159.255, YN
        [ 0xB454A000, 0xB454BFFF, "SC" ],  // 180.84.160.0-180.84.191.255, SC
        [ 0xB454C000, 0xB454FFFF, "CQ" ],  // 180.84.192.0-180.84.255.255, CQ
        [ 0xB4550000, 0xB4557FFF, "SC" ],  // 180.85.0.0-180.85.127.255, SC
        [ 0xB4558000, 0xB455FFFF, "CQ" ],  // 180.85.128.0-180.85.255.255, CQ
        [ 0xB4560000, 0xB456FFFF, "BJ" ],  // 180.86.0.0-180.86.255.255, BJ
        [ 0xB4580000, 0xB4583FFF, "GD" ],  // 180.88.0.0-180.88.63.255, GD
        [ 0xB4584000, 0xB4585FFF, "FJ" ],  // 180.88.64.0-180.88.95.255, FJ
        [ 0xB4586000, 0xB458BFFF, "BJ" ],  // 180.88.96.0-180.88.191.255, BJ
        [ 0xB458C000, 0xB458FFFF, "CQ" ],  // 180.88.192.0-180.88.255.255, CQ
        [ 0xB4590000, 0xB4593FFF, "TJ" ],  // 180.89.0.0-180.89.63.255, TJ
        [ 0xB4594000, 0xB4595FFF, "BJ" ],  // 180.89.64.0-180.89.95.255, BJ
        [ 0xB4596000, 0xB4597FFF, "FJ" ],  // 180.89.96.0-180.89.127.255, FJ
        [ 0xB4598000, 0xB4599FFF, "GD" ],  // 180.89.128.0-180.89.159.255, GD
        [ 0xB459A000, 0xB459CBFF, "AH" ],  // 180.89.160.0-180.89.203.255, AH
        [ 0xB459CC00, 0xB459CCFF, "HE" ],  // 180.89.204.0-180.89.204.255, HE
        [ 0xB459CD00, 0xB459D1FF, "AH" ],  // 180.89.205.0-180.89.209.255, AH
        [ 0xB459D200, 0xB459D3FF, "HE" ],  // 180.89.210.0-180.89.211.255, HE
        [ 0xB459D400, 0xB459D8FF, "AH" ],  // 180.89.212.0-180.89.216.255, AH
        [ 0xB459D900, 0xB459DAFF, "HE" ],  // 180.89.217.0-180.89.218.255, HE
        [ 0xB459DB00, 0xB459DCFF, "AH" ],  // 180.89.219.0-180.89.220.255, AH
        [ 0xB459DD00, 0xB459DFFF, "HE" ],  // 180.89.221.0-180.89.223.255, HE
        [ 0xB459E000, 0xB459E9FF, "SN" ],  // 180.89.224.0-180.89.233.255, SN
        [ 0xB459EA00, 0xB459EAFF, "HE" ],  // 180.89.234.0-180.89.234.255, HE
        [ 0xB459EB00, 0xB459FFFF, "SN" ],  // 180.89.235.0-180.89.255.255, SN
        [ 0xB45A0000, 0xB45A00FF, "HB" ],  // 180.90.0.0-180.90.0.255, HB
        [ 0xB45A0100, 0xB45A77FF, "BJ" ],  // 180.90.1.0-180.90.119.255, BJ
        [ 0xB45A7800, 0xB45A7FFF, "HB" ],  // 180.90.120.0-180.90.127.255, HB
        [ 0xB45A8000, 0xB45AFFFF, "TJ" ],  // 180.90.128.0-180.90.255.255, TJ
        [ 0xB45B0000, 0xB45B7FFF, "SC" ],  // 180.91.0.0-180.91.127.255, SC
        [ 0xB45B8000, 0xB45BBFFF, "GD" ],  // 180.91.128.0-180.91.191.255, GD
        [ 0xB45BC000, 0xB45BC1FF, "SN" ],  // 180.91.192.0-180.91.193.255, SN
        [ 0xB45BC200, 0xB45BC7FF, "HE" ],  // 180.91.194.0-180.91.199.255, HE
        [ 0xB45BC800, 0xB45BCBFF, "SX" ],  // 180.91.200.0-180.91.203.255, SX
        [ 0xB45BCC00, 0xB45BFFFF, "HE" ],  // 180.91.204.0-180.91.255.255, HE
        [ 0xB45E3800, 0xB45E3FFF, "BJ" ],  // 180.94.56.0-180.94.63.255, BJ
        [ 0xB45E6000, 0xB45E6FFF, "BJ" ],  // 180.94.96.0-180.94.111.255, BJ
        [ 0xB45E7800, 0xB45E7BFF, "GD" ],  // 180.94.120.0-180.94.123.255, GD
        [ 0xB45E7C00, 0xB45E7FFF, "JS" ],  // 180.94.124.0-180.94.127.255, JS
        [ 0xB45F8000, 0xB45FFFFF, "GS" ],  // 180.95.128.0-180.95.255.255, GS
        [ 0xB4600000, 0xB47FFFFF, "JS" ],  // 180.96.0.0-180.127.255.255, JS
        [ 0xB4818000, 0xB482FFFF, "YN" ],  // 180.129.128.0-180.130.255.255, YN
        [ 0xB4880000, 0xB48FFFFF, "GX" ],  // 180.136.0.0-180.143.255.255, GX
        [ 0xB4941000, 0xB49417FF, "GD" ],  // 180.148.16.0-180.148.23.255, GD
        [ 0xB4949800, 0xB4949FFF, "GD" ],  // 180.148.152.0-180.148.159.255, GD
        [ 0xB494D800, 0xB494DFFF, "GD" ],  // 180.148.216.0-180.148.223.255, GD
        [ 0xB494E000, 0xB494FFFF, "BJ" ],  // 180.148.224.0-180.148.255.255, BJ
        [ 0xB4958000, 0xB4959FFF, "BJ" ],  // 180.149.128.0-180.149.159.255, BJ
        [ 0xB496A000, 0xB496AFFF, "SH" ],  // 180.150.160.0-180.150.175.255, SH
        [ 0xB496B000, 0xB496BFFF, "BJ" ],  // 180.150.176.0-180.150.191.255, BJ
        [ 0xB4980000, 0xB4AFFFFF, "SH" ],  // 180.152.0.0-180.175.255.255, SH
        [ 0xB4B27000, 0xB4B277FF, "BJ" ],  // 180.178.112.0-180.178.119.255, BJ
        [ 0xB4B2C000, 0xB4B2FFFF, "ZJ" ],  // 180.178.192.0-180.178.255.255, ZJ
        [ 0xB4B80000, 0xB4BC0FFF, "BJ" ],  // 180.184.0.0-180.188.15.255, BJ
        [ 0xB4BC1000, 0xB4BC1FFF, "ZJ" ],  // 180.188.16.0-180.188.31.255, ZJ
        [ 0xB4BC2000, 0xB4BC2FFF, "FJ" ],  // 180.188.32.0-180.188.47.255, FJ
        [ 0xB4BC3000, 0xB4BC7FFF, "BJ" ],  // 180.188.48.0-180.188.127.255, BJ
        [ 0xB4BD9400, 0xB4BD94FF, "FJ" ],  // 180.189.148.0-180.189.148.255, FJ
        [ 0xB4BD9500, 0xB4BD97FF, "GD" ],  // 180.189.149.0-180.189.151.255, GD
        [ 0xB4C8FC00, 0xB4C8FFFF, "GD" ],  // 180.200.252.0-180.200.255.255, GD
        [ 0xB4C90000, 0xB4C96FFF, "SD" ],  // 180.201.0.0-180.201.111.255, SD
        [ 0xB4C97000, 0xB4C97FFF, "JS" ],  // 180.201.112.0-180.201.127.255, JS
        [ 0xB4C98000, 0xB4C9EFFF, "SD" ],  // 180.201.128.0-180.201.239.255, SD
        [ 0xB4C9F000, 0xB4C9FFFF, "JS" ],  // 180.201.240.0-180.201.255.255, JS
        [ 0xB4CA0000, 0xB4CBFFFF, "BJ" ],  // 180.202.0.0-180.203.255.255, BJ
        [ 0xB4D00000, 0xB4D1FFFF, "JS" ],  // 180.208.0.0-180.209.255.255, JS
        [ 0xB4D2D400, 0xB4D2D7FF, "AH" ],  // 180.210.212.0-180.210.215.255, AH
        [ 0xB4D2E400, 0xB4D2FFFF, "BJ" ],  // 180.210.228.0-180.210.255.255, BJ
        [ 0xB4D40000, 0xB4D5FFFF, "TJ" ],  // 180.212.0.0-180.213.255.255, TJ
        [ 0xB4DEE000, 0xB4DEFFFF, "SC" ],  // 180.222.224.0-180.222.255.255, SC
        [ 0xB4DF0000, 0xB4DF1FFF, "LN" ],  // 180.223.0.0-180.223.31.255, LN
        [ 0xB4DF2800, 0xB4DF3FFF, "LN" ],  // 180.223.40.0-180.223.63.255, LN
        [ 0xB4DF7000, 0xB4DF71FF, "LN" ],  // 180.223.112.0-180.223.113.255, LN
        [ 0xB4DF7400, 0xB4DFC7FF, "LN" ],  // 180.223.116.0-180.223.199.255, LN
        [ 0xB4DFCC00, 0xB4DFFFFF, "LN" ],  // 180.223.204.0-180.223.255.255, LN
        [ 0xB4E90000, 0xB4E95FFF, "FJ" ],  // 180.233.0.0-180.233.95.255, FJ
        [ 0xB4E99000, 0xB4E993FF, "JS" ],  // 180.233.144.0-180.233.147.255, JS
        [ 0xB4EB4000, 0xB4EB5FFF, "SH" ],  // 180.235.64.0-180.235.95.255, SH
        [ 0xB4EB7000, 0xB4EB73FF, "LN" ],  // 180.235.112.0-180.235.115.255, LN
        [ 0xB6109000, 0xB61093FF, "HA" ],  // 182.16.144.0-182.16.147.255, HA
        [ 0xB6109400, 0xB61097FF, "JX" ],  // 182.16.148.0-182.16.151.255, JX
        [ 0xB610C000, 0xB610DFFF, "SH" ],  // 182.16.192.0-182.16.223.255, SH
        [ 0xB6120000, 0xB6127FFF, "BJ" ],  // 182.18.0.0-182.18.127.255, BJ
        [ 0xB617B800, 0xB617BFFF, "GD" ],  // 182.23.184.0-182.23.191.255, GD
        [ 0xB617C800, 0xB617CFFF, "GD" ],  // 182.23.200.0-182.23.207.255, GD
        [ 0xB6200000, 0xB629FFFF, "SD" ],  // 182.32.0.0-182.41.255.255, SD
        [ 0xB62A0000, 0xB62AFFFF, "NM" ],  // 182.42.0.0-182.42.255.255, NM
        [ 0xB62B0000, 0xB62B07FF, "HN" ],  // 182.43.0.0-182.43.7.255, HN
        [ 0xB62B0800, 0xB62C3FFF, "GZ" ],  // 182.43.8.0-182.44.63.255, GZ
        [ 0xB62C4000, 0xB62FFFFF, "SD" ],  // 182.44.64.0-182.47.255.255, SD
        [ 0xB6306000, 0xB6307FFF, "BJ" ],  // 182.48.96.0-182.48.127.255, BJ
        [ 0xB6310000, 0xB631FFFF, "ZJ" ],  // 182.49.0.0-182.49.255.255, ZJ
        [ 0xB6320000, 0xB63203FF, "BJ" ],  // 182.50.0.0-182.50.3.255, BJ
        [ 0xB6320600, 0xB6320FFF, "BJ" ],  // 182.50.6.0-182.50.15.255, BJ
        [ 0xB6327000, 0xB6327FFF, "BJ" ],  // 182.50.112.0-182.50.127.255, BJ
        [ 0xB6330000, 0xB633FFFF, "HE" ],  // 182.51.0.0-182.51.255.255, HE
        [ 0xB6360000, 0xB6367FFF, "NX" ],  // 182.54.0.0-182.54.127.255, NX
        [ 0xB636F400, 0xB636F7FF, "BJ" ],  // 182.54.244.0-182.54.247.255, BJ
        [ 0xB63D0000, 0xB63D3FFF, "GD" ],  // 182.61.0.0-182.61.63.255, GD
        [ 0xB63D4000, 0xB63D7FFF, "BJ" ],  // 182.61.64.0-182.61.127.255, BJ
        [ 0xB63D8000, 0xB63D80FF, "SD" ],  // 182.61.128.0-182.61.128.255, SD
        [ 0xB63D8100, 0xB63D81FF, "GD" ],  // 182.61.129.0-182.61.129.255, GD
        [ 0xB63D8200, 0xB63D83FF, "JS" ],  // 182.61.130.0-182.61.131.255, JS
        [ 0xB63D8400, 0xB63D9FFF, "GD" ],  // 182.61.132.0-182.61.159.255, GD
        [ 0xB63DA000, 0xB63DBFFF, "BJ" ],  // 182.61.160.0-182.61.191.255, BJ
        [ 0xB63DC000, 0xB63DC7FF, "SD" ],  // 182.61.192.0-182.61.199.255, SD
        [ 0xB63DC800, 0xB63DD7FF, "BJ" ],  // 182.61.200.0-182.61.215.255, BJ
        [ 0xB63DD800, 0xB63DF5FF, "JS" ],  // 182.61.216.0-182.61.245.255, JS
        [ 0xB63DF600, 0xB63DF9FF, "GD" ],  // 182.61.246.0-182.61.249.255, GD
        [ 0xB63DFA00, 0xB63DFD1F, "BJ" ],  // 182.61.250.0-182.61.253.31, BJ
        [ 0xB63DFD20, 0xB63DFDFF, "GD" ],  // 182.61.253.32-182.61.253.255, GD
        [ 0xB63DFE00, 0xB63DFFFF, "BJ" ],  // 182.61.254.0-182.61.255.255, BJ
        [ 0xB6500000, 0xB653FFFF, "SN" ],  // 182.80.0.0-182.83.255.255, SN
        [ 0xB6540000, 0xB657FFFF, "JX" ],  // 182.84.0.0-182.87.255.255, JX
        [ 0xB6580000, 0xB65BFFFF, "GX" ],  // 182.88.0.0-182.91.255.255, GX
        [ 0xB65C0000, 0xB65CFFFF, "BJ" ],  // 182.92.0.0-182.92.255.255, BJ
        [ 0xB6600000, 0xB66FFFFF, "JX" ],  // 182.96.0.0-182.111.255.255, JX
        [ 0xB6700000, 0xB67FFFFF, "HA" ],  // 182.112.0.0-182.127.255.255, HA
        [ 0xB6800000, 0xB697FFFF, "SC" ],  // 182.128.0.0-182.151.255.255, SC
        [ 0xB69D0000, 0xB69DFFFF, "FJ" ],  // 182.157.0.0-182.157.255.255, FJ
        [ 0xB6A04000, 0xB6A05FFF, "BJ" ],  // 182.160.64.0-182.160.95.255, BJ
        [ 0xB6AE0000, 0xB6AFDFFF, "BJ" ],  // 182.174.0.0-182.175.223.255, BJ
        [ 0xB6AFE000, 0xB6AFE0FF, "SH" ],  // 182.175.224.0-182.175.224.255, SH
        [ 0xB6AFE100, 0xB6AFEFFF, "BJ" ],  // 182.175.225.0-182.175.239.255, BJ
        [ 0xB6AFF000, 0xB6AFF3FF, "SH" ],  // 182.175.240.0-182.175.243.255, SH
        [ 0xB6AFF400, 0xB6AFFFFF, "BJ" ],  // 182.175.244.0-182.175.255.255, BJ
        [ 0xB6C80000, 0xB6CFFFFF, "LN" ],  // 182.200.0.0-182.207.255.255, LN
        [ 0xB6EC8000, 0xB6ECFFFF, "HA" ],  // 182.236.128.0-182.236.255.255, HA
        [ 0xB6ED1800, 0xB6ED1BFF, "AH" ],  // 182.237.24.0-182.237.27.255, AH
        [ 0xB6ED1C00, 0xB6ED1FFF, "HA" ],  // 182.237.28.0-182.237.31.255, HA
        [ 0xB6EE0000, 0xB6EEFFFF, "TJ" ],  // 182.238.0.0-182.238.255.255, TJ
        [ 0xB6EF0000, 0xB6EF1FFF, "HE" ],  // 182.239.0.0-182.239.31.255, HE
        [ 0xB6F00000, 0xB6F7FFFF, "YN" ],  // 182.240.0.0-182.247.255.255, YN
        [ 0xB6FE0000, 0xB6FE07FF, "GD" ],  // 182.254.0.0-182.254.7.255, GD
        [ 0xB6FE0800, 0xB6FE0FFF, "SH" ],  // 182.254.8.0-182.254.15.255, SH
        [ 0xB6FE1000, 0xB6FE16FF, "TJ" ],  // 182.254.16.0-182.254.22.255, TJ
        [ 0xB6FE1700, 0xB6FE27FF, "GD" ],  // 182.254.23.0-182.254.39.255, GD
        [ 0xB6FE2800, 0xB6FE2FFF, "SH" ],  // 182.254.40.0-182.254.47.255, SH
        [ 0xB6FE3000, 0xB6FE3FFF, "TJ" ],  // 182.254.48.0-182.254.63.255, TJ
        [ 0xB6FE4000, 0xB6FE47FF, "GD" ],  // 182.254.64.0-182.254.71.255, GD
        [ 0xB6FE4800, 0xB6FE50FF, "SH" ],  // 182.254.72.0-182.254.80.255, SH
        [ 0xB6FE5100, 0xB6FE51FF, "GD" ],  // 182.254.81.0-182.254.81.255, GD
        [ 0xB6FE5200, 0xB6FE60FF, "SH" ],  // 182.254.82.0-182.254.96.255, SH
        [ 0xB6FE6100, 0xB6FE63FF, "GD" ],  // 182.254.97.0-182.254.99.255, GD
        [ 0xB6FE6400, 0xB6FE65FF, "TJ" ],  // 182.254.100.0-182.254.101.255, TJ
        [ 0xB6FE6600, 0xB6FE6FFF, "GD" ],  // 182.254.102.0-182.254.111.255, GD
        [ 0xB6FE7000, 0xB6FE73FF, "SH" ],  // 182.254.112.0-182.254.115.255, SH
        [ 0xB6FE7400, 0xB6FE7FFF, "GD" ],  // 182.254.116.0-182.254.127.255, GD
        [ 0xB6FE8000, 0xB6FE9FFF, "SH" ],  // 182.254.128.0-182.254.159.255, SH
        [ 0xB6FEA000, 0xB6FECFFF, "GD" ],  // 182.254.160.0-182.254.207.255, GD
        [ 0xB6FED000, 0xB6FEDFFF, "SH" ],  // 182.254.208.0-182.254.223.255, SH
        [ 0xB6FEE000, 0xB6FEEFFF, "GD" ],  // 182.254.224.0-182.254.239.255, GD
        [ 0xB6FEF000, 0xB6FEF8FF, "SH" ],  // 182.254.240.0-182.254.248.255, SH
        [ 0xB6FEF900, 0xB6FEF9FF, "BJ" ],  // 182.254.249.0-182.254.249.255, BJ
        [ 0xB6FEFA00, 0xB6FEFFFF, "GD" ],  // 182.254.250.0-182.254.255.255, GD
        [ 0xB6FF3C00, 0xB6FF3FFF, "CQ" ],  // 182.255.60.0-182.255.63.255, CQ
        [ 0xB7000000, 0xB73FFFFF, "GD" ],  // 183.0.0.0-183.63.255.255, GD
        [ 0xB7400000, 0xB747FFFF, "CQ" ],  // 183.64.0.0-183.71.255.255, CQ
        [ 0xB74EA000, 0xB74EA3FF, "GS" ],  // 183.78.160.0-183.78.163.255, GS
        [ 0xB74EA400, 0xB74EA7FF, "SC" ],  // 183.78.164.0-183.78.167.255, SC
        [ 0xB74EB400, 0xB74EB7FF, "BJ" ],  // 183.78.180.0-183.78.183.255, BJ
        [ 0xB751AC00, 0xB751ACFF, "BJ" ],  // 183.81.172.0-183.81.172.255, BJ
        [ 0xB751AF00, 0xB751AFFF, "BJ" ],  // 183.81.175.0-183.81.175.255, BJ
        [ 0xB751B400, 0xB751B7FF, "BJ" ],  // 183.81.180.0-183.81.183.255, BJ
        [ 0xB7540000, 0xB755FFFF, "BJ" ],  // 183.84.0.0-183.85.255.255, BJ
        [ 0xB75B8000, 0xB75B83FF, "SH" ],  // 183.91.128.0-183.91.131.255, SH
        [ 0xB75B8800, 0xB75B8FFF, "GD" ],  // 183.91.136.0-183.91.143.255, GD
        [ 0xB75B9000, 0xB75B9FFF, "BJ" ],  // 183.91.144.0-183.91.159.255, BJ
        [ 0xB75C0000, 0xB75FFFFF, "HB" ],  // 183.92.0.0-183.95.255.255, HB
        [ 0xB7800000, 0xB79FFFFF, "ZJ" ],  // 183.128.0.0-183.159.255.255, ZJ
        [ 0xB7A00000, 0xB7A7FFFF, "AH" ],  // 183.160.0.0-183.167.255.255, AH
        [ 0xB7A80000, 0xB7A8FFFF, "HB" ],  // 183.168.0.0-183.168.255.255, HB
        [ 0xB7A90000, 0xB7A97FFF, "HN" ],  // 183.169.0.0-183.169.127.255, HN
        [ 0xB7A98000, 0xB7A99FFF, "HA" ],  // 183.169.128.0-183.169.159.255, HA
        [ 0xB7A9A000, 0xB7A9AFFF, "HB" ],  // 183.169.160.0-183.169.175.255, HB
        [ 0xB7A9B000, 0xB7AAFFFF, "HA" ],  // 183.169.176.0-183.170.255.255, HA
        [ 0xB7AC0000, 0xB7AEFFFF, "BJ" ],  // 183.172.0.0-183.174.255.255, BJ
        [ 0xB7AF0000, 0xB7AF3FFF, "NM" ],  // 183.175.0.0-183.175.63.255, NM
        [ 0xB7AF4000, 0xB7AF6FFF, "HE" ],  // 183.175.64.0-183.175.111.255, HE
        [ 0xB7AF7000, 0xB7AF7FFF, "BJ" ],  // 183.175.112.0-183.175.127.255, BJ
        [ 0xB7AF8000, 0xB7AF9FFF, "SX" ],  // 183.175.128.0-183.175.159.255, SX
        [ 0xB7AFA000, 0xB7AFFFFF, "BJ" ],  // 183.175.160.0-183.175.255.255, BJ
        [ 0xB7B60000, 0xB7B609FF, "BJ" ],  // 183.182.0.0-183.182.9.255, BJ
        [ 0xB7B60C00, 0xB7B61FFF, "BJ" ],  // 183.182.12.0-183.182.31.255, BJ
        [ 0xB7B80000, 0xB7BFFFFF, "SX" ],  // 183.184.0.0-183.191.255.255, SX
        [ 0xB7C00000, 0xB7C3FFFF, "SH" ],  // 183.192.0.0-183.195.255.255, SH
        [ 0xB7C40000, 0xB7C7FFFF, "HE" ],  // 183.196.0.0-183.199.255.255, HE
        [ 0xB7C80000, 0xB7CBFFFF, "SX" ],  // 183.200.0.0-183.203.255.255, SX
        [ 0xB7CC0000, 0xB7CDFFFF, "HA" ],  // 183.204.0.0-183.205.255.255, HA
        [ 0xB7CE0000, 0xB7D5FFFF, "JS" ],  // 183.206.0.0-183.213.255.255, JS
        [ 0xB7D60000, 0xB7D7FFFF, "HN" ],  // 183.214.0.0-183.215.255.255, HN
        [ 0xB7D80000, 0xB7DBFFFF, "JX" ],  // 183.216.0.0-183.219.255.255, JX
        [ 0xB7DC0000, 0xB7DFCFFF, "SC" ],  // 183.220.0.0-183.223.207.255, SC
        [ 0xB7DFD000, 0xB7DFD3FF, "GD" ],  // 183.223.208.0-183.223.211.255, GD
        [ 0xB7DFD400, 0xB7DFFFFF, "SC" ],  // 183.223.212.0-183.223.255.255, SC
        [ 0xB7E00000, 0xB7E1FFFF, "YN" ],  // 183.224.0.0-183.225.255.255, YN
        [ 0xB7E20000, 0xB7E7FFFF, "CQ" ],  // 183.226.0.0-183.231.255.255, CQ
        [ 0xB7E80000, 0xB7F0FFFF, "GD" ],  // 183.232.0.0-183.240.255.255, GD
        [ 0xB7F10000, 0xB7F4FFFF, "BJ" ],  // 183.241.0.0-183.244.255.255, BJ
        [ 0xB7F50000, 0xB7F9FFFF, "ZJ" ],  // 183.245.0.0-183.249.255.255, ZJ
        [ 0xB7FA0000, 0xB7FDFFFF, "FJ" ],  // 183.250.0.0-183.253.255.255, FJ
        [ 0xB7FE0000, 0xB7FFFFFF, "HI" ],  // 183.254.0.0-183.255.255.255, HI
        [ 0xB907AF00, 0xB907AFFF, "UNK" ],  // 185.7.175.0-185.7.175.255, UNK
        [ 0xB95F6400, 0xB95F65FF, "BJ" ],  // 185.95.100.0-185.95.101.255, BJ
        [ 0xB95F6600, 0xB95F67FF, "HA" ],  // 185.95.102.0-185.95.103.255, HA
        [ 0xB960F700, 0xB960F7FF, "BJ" ],  // 185.96.247.0-185.96.247.255, BJ
        [ 0xBC411000, 0xBC4113FF, "BJ" ],  // 188.65.16.0-188.65.19.255, BJ
        [ 0xBC838000, 0xBC83FFFF, "TJ" ],  // 188.131.128.0-188.131.255.255, TJ
        [ 0xBCBE0100, 0xBCBE02FF, "BJ" ],  // 188.190.1.0-188.190.2.255, BJ
        [ 0xBCD65900, 0xBCD659FF, "BJ" ],  // 188.214.89.0-188.214.89.255, BJ
        [ 0xBCF13B00, 0xBCF13BFF, "SH" ],  // 188.241.59.0-188.241.59.255, SH
        [ 0xC033BC00, 0xC033BCFF, "BJ" ],  // 192.51.188.0-192.51.188.255, BJ
        [ 0xC0372E00, 0xC0372FFF, "SH" ],  // 192.55.46.0-192.55.47.255, SH
        [ 0xC0374400, 0xC03747FF, "SH" ],  // 192.55.68.0-192.55.71.255, SH
        [ 0xC066CC00, 0xC066CFFF, "SH" ],  // 192.102.204.0-192.102.207.255, SH
        [ 0xC07C9A00, 0xC07C9AFF, "SH" ],  // 192.124.154.0-192.124.154.255, SH
        [ 0xC0891F00, 0xC0891FFF, "BJ" ],  // 192.137.31.0-192.137.31.255, BJ
        [ 0xC08C8000, 0xC08C89FF, "SH" ],  // 192.140.128.0-192.140.137.255, SH
        [ 0xC08C9C00, 0xC08CCFFF, "GD" ],  // 192.140.156.0-192.140.207.255, GD
        [ 0xC08CD000, 0xC08CD7FF, "JS" ],  // 192.140.208.0-192.140.215.255, JS
        [ 0xC0908000, 0xC090FFFF, "BJ" ],  // 192.144.128.0-192.144.255.255, BJ
        [ 0xC0ABE000, 0xC0ABE6FF, "BJ" ],  // 192.171.224.0-192.171.230.255, BJ
        [ 0xC0ABE700, 0xC0ABE7FF, "GD" ],  // 192.171.231.0-192.171.231.255, GD
        [ 0xC0FDD3A0, 0xC0FDD3BF, "BJ" ],  // 192.253.211.160-192.253.211.191, BJ
        [ 0xC120E330, 0xC120E33F, "BJ" ],  // 193.32.227.48-193.32.227.63, BJ
        [ 0xC1700000, 0xC170FFFF, "GD" ],  // 193.112.0.0-193.112.255.255, GD
        [ 0xC1770000, 0xC1771FFF, "BJ" ],  // 193.119.0.0-193.119.31.255, BJ
        [ 0xC1A90800, 0xC1A909FF, "BJ" ],  // 193.169.8.0-193.169.9.255, BJ
        [ 0xC1C03400, 0xC1C035FF, "SH" ],  // 193.192.52.0-193.192.53.255, SH
        [ 0xC1C8DEA0, 0xC1C8DEAF, "BJ" ],  // 193.200.222.160-193.200.222.175, BJ
        [ 0xC1EFAC00, 0xC1EFADFF, "SH" ],  // 193.239.172.0-193.239.173.255, SH
        [ 0xC1EFF600, 0xC1EFF7FF, "SH" ],  // 193.239.246.0-193.239.247.255, SH
        [ 0xC218EA00, 0xC218EBFF, "BJ" ],  // 194.24.234.0-194.24.235.255, BJ
        [ 0xC2326330, 0xC2326330, "BJ" ],  // 194.50.99.48-194.50.99.48, BJ
        [ 0xC2588600, 0xC25887FF, "BJ" ],  // 194.88.134.0-194.88.135.255, BJ
        [ 0xC28A8800, 0xC28A88FF, "UNK" ],  // 194.138.136.0-194.138.136.255, UNK
        [ 0xC28ACA00, 0xC28ACAFF, "BJ" ],  // 194.138.202.0-194.138.202.255, BJ
        [ 0xC28ACB00, 0xC28ACBFF, "SH" ],  // 194.138.203.0-194.138.203.255, SH
        [ 0xC28AF500, 0xC28AF5FF, "BJ" ],  // 194.138.245.0-194.138.245.255, BJ
        [ 0xC3FD6400, 0xC3FD64FF, "BJ" ],  // 195.253.100.0-195.253.100.255, BJ
        [ 0xC3FE8C00, 0xC3FE8DFF, "SH" ],  // 195.254.140.0-195.254.141.255, SH
        [ 0xC4304300, 0xC43043FF, "BJ" ],  // 196.48.67.0-196.48.67.255, BJ
        [ 0xC4384300, 0xC43843FF, "BJ" ],  // 196.56.67.0-196.56.67.255, BJ
        [ 0xC4394300, 0xC43943FF, "BJ" ],  // 196.57.67.0-196.57.67.255, BJ
        [ 0xC43A4300, 0xC43A43FF, "BJ" ],  // 196.58.67.0-196.58.67.255, BJ
        [ 0xC43F8000, 0xC43F84FF, "BJ" ],  // 196.63.128.0-196.63.132.255, BJ
        [ 0xC4C54300, 0xC4C543FF, "BJ" ],  // 196.197.67.0-196.197.67.255, BJ
        [ 0xC4C64300, 0xC4C643FF, "BJ" ],  // 196.198.67.0-196.198.67.255, BJ
        [ 0xC4C74300, 0xC4C743FF, "BJ" ],  // 196.199.67.0-196.199.67.255, BJ
        [ 0xC4F03200, 0xC4F032FF, "GD" ],  // 196.240.50.0-196.240.50.255, GD
        [ 0xC4F07200, 0xC4F072FF, "BJ" ],  // 196.240.114.0-196.240.114.255, BJ
        [ 0xC6919200, 0xC69192FF, "BJ" ],  // 198.145.146.0-198.145.146.255, BJ
        [ 0xC6AF6400, 0xC6AF67FF, "SH" ],  // 198.175.100.0-198.175.103.255, SH
        [ 0xC6D01100, 0xC6D011FF, "SH" ],  // 198.208.17.0-198.208.17.255, SH
        [ 0xC741C000, 0xC741C7FF, "SH" ],  // 199.65.192.0-199.65.199.255, SH
        [ 0xC7F49000, 0xC7F490FF, "BJ" ],  // 199.244.144.0-199.244.144.255, BJ
        [ 0xCA006400, 0xCA0065FF, "FJ" ],  // 202.0.100.0-202.0.101.255, FJ
        [ 0xCA007A00, 0xCA007BFF, "FJ" ],  // 202.0.122.0-202.0.123.255, FJ
        [ 0xCA0169C0, 0xCA0169FF, "BJ" ],  // 202.1.105.192-202.1.105.255, BJ
        [ 0xCA016E00, 0xCA0171FF, "SH" ],  // 202.1.110.0-202.1.113.255, SH
        [ 0xCA038000, 0xCA0381FF, "FJ" ],  // 202.3.128.0-202.3.129.255, FJ
        [ 0xCA048000, 0xCA049FFF, "BJ" ],  // 202.4.128.0-202.4.159.255, BJ
        [ 0xCA04FC00, 0xCA04FFFF, "BJ" ],  // 202.4.252.0-202.4.255.255, BJ
        [ 0xCA05D000, 0xCA05D3FF, "HI" ],  // 202.5.208.0-202.5.211.255, HI
        [ 0xCA05D400, 0xCA05D7FF, "GD" ],  // 202.5.212.0-202.5.215.255, GD
        [ 0xCA05D800, 0xCA05DBFF, "SH" ],  // 202.5.216.0-202.5.219.255, SH
        [ 0xCA060600, 0xCA0607FF, "FJ" ],  // 202.6.6.0-202.6.7.255, FJ
        [ 0xCA064200, 0xCA0643FF, "FJ" ],  // 202.6.66.0-202.6.67.255, FJ
        [ 0xCA064800, 0xCA0649FF, "FJ" ],  // 202.6.72.0-202.6.73.255, FJ
        [ 0xCA065700, 0xCA0659FF, "FJ" ],  // 202.6.87.0-202.6.89.255, FJ
        [ 0xCA065C00, 0xCA065DFF, "FJ" ],  // 202.6.92.0-202.6.93.255, FJ
        [ 0xCA066700, 0xCA0667FF, "FJ" ],  // 202.6.103.0-202.6.103.255, FJ
        [ 0xCA066C00, 0xCA066CFF, "FJ" ],  // 202.6.108.0-202.6.108.255, FJ
        [ 0xCA066E00, 0xCA066FFF, "FJ" ],  // 202.6.110.0-202.6.111.255, FJ
        [ 0xCA067200, 0xCA0672FF, "FJ" ],  // 202.6.114.0-202.6.114.255, FJ
        [ 0xCA06B000, 0xCA06BFFF, "GD" ],  // 202.6.176.0-202.6.191.255, GD
        [ 0xCA080000, 0xCA0800FF, "FJ" ],  // 202.8.0.0-202.8.0.255, FJ
        [ 0xCA080200, 0xCA0805FF, "FJ" ],  // 202.8.2.0-202.8.5.255, FJ
        [ 0xCA080C00, 0xCA080CFF, "FJ" ],  // 202.8.12.0-202.8.12.255, FJ
        [ 0xCA081800, 0xCA0818FF, "FJ" ],  // 202.8.24.0-202.8.24.255, FJ
        [ 0xCA084D00, 0xCA084DFF, "FJ" ],  // 202.8.77.0-202.8.77.255, FJ
        [ 0xCA088000, 0xCA089FFF, "HE" ],  // 202.8.128.0-202.8.159.255, HE
        [ 0xCA08C000, 0xCA08CFFF, "GD" ],  // 202.8.192.0-202.8.207.255, GD
        [ 0xCA092000, 0xCA0920FF, "FJ" ],  // 202.9.32.0-202.9.32.255, FJ
        [ 0xCA092200, 0xCA0923FF, "FJ" ],  // 202.9.34.0-202.9.35.255, FJ
        [ 0xCA093000, 0xCA0931FF, "FJ" ],  // 202.9.48.0-202.9.49.255, FJ
        [ 0xCA093300, 0xCA0936FF, "FJ" ],  // 202.9.51.0-202.9.54.255, FJ
        [ 0xCA093900, 0xCA093BFF, "FJ" ],  // 202.9.57.0-202.9.59.255, FJ
        [ 0xCA0A4000, 0xCA0A47FF, "BJ" ],  // 202.10.64.0-202.10.71.255, BJ
        [ 0xCA0A4900, 0xCA0A49FF, "BJ" ],  // 202.10.73.0-202.10.73.255, BJ
        [ 0xCA0A4A00, 0xCA0A4FFF, "GD" ],  // 202.10.74.0-202.10.79.255, GD
        [ 0xCA0A7000, 0xCA0A73FF, "SH" ],  // 202.10.112.0-202.10.115.255, SH
        [ 0xCA0A7400, 0xCA0A77FF, "GD" ],  // 202.10.116.0-202.10.119.255, GD
        [ 0xCA0A7800, 0xCA0A7BFF, "ZJ" ],  // 202.10.120.0-202.10.123.255, ZJ
        [ 0xCA0A7C00, 0xCA0A7FFF, "LN" ],  // 202.10.124.0-202.10.127.255, LN
        [ 0xCA0C0100, 0xCA0C02FF, "FJ" ],  // 202.12.1.0-202.12.2.255, FJ
        [ 0xCA0C1100, 0xCA0C12FF, "FJ" ],  // 202.12.17.0-202.12.18.255, FJ
        [ 0xCA0C1300, 0xCA0C13FF, "BJ" ],  // 202.12.19.0-202.12.19.255, BJ
        [ 0xCA0C4800, 0xCA0C48FF, "FJ" ],  // 202.12.72.0-202.12.72.255, FJ
        [ 0xCA0C5400, 0xCA0C55FF, "FJ" ],  // 202.12.84.0-202.12.85.255, FJ
        [ 0xCA0C6000, 0xCA0C60FF, "FJ" ],  // 202.12.96.0-202.12.96.255, FJ
        [ 0xCA0C6200, 0xCA0C63FF, "FJ" ],  // 202.12.98.0-202.12.99.255, FJ
        [ 0xCA0C6A00, 0xCA0C6AFF, "FJ" ],  // 202.12.106.0-202.12.106.255, FJ
        [ 0xCA0C6F00, 0xCA0C6FFF, "FJ" ],  // 202.12.111.0-202.12.111.255, FJ
        [ 0xCA0C7400, 0xCA0C74FF, "FJ" ],  // 202.12.116.0-202.12.116.255, FJ
        [ 0xCA0E4000, 0xCA0E41FF, "FJ" ],  // 202.14.64.0-202.14.65.255, FJ
        [ 0xCA0E4500, 0xCA0E45FF, "FJ" ],  // 202.14.69.0-202.14.69.255, FJ
        [ 0xCA0E4900, 0xCA0E4CFF, "FJ" ],  // 202.14.73.0-202.14.76.255, FJ
        [ 0xCA0E4E00, 0xCA0E4FFF, "FJ" ],  // 202.14.78.0-202.14.79.255, FJ
        [ 0xCA0E5800, 0xCA0E58FF, "FJ" ],  // 202.14.88.0-202.14.88.255, FJ
        [ 0xCA0E6100, 0xCA0E61FF, "FJ" ],  // 202.14.97.0-202.14.97.255, FJ
        [ 0xCA0E6800, 0xCA0E69FF, "FJ" ],  // 202.14.104.0-202.14.105.255, FJ
        [ 0xCA0E6C00, 0xCA0E6DFF, "FJ" ],  // 202.14.108.0-202.14.109.255, FJ
        [ 0xCA0E6F00, 0xCA0E6FFF, "FJ" ],  // 202.14.111.0-202.14.111.255, FJ
        [ 0xCA0E7200, 0xCA0E73FF, "FJ" ],  // 202.14.114.0-202.14.115.255, FJ
        [ 0xCA0E7600, 0xCA0E77FF, "FJ" ],  // 202.14.118.0-202.14.119.255, FJ
        [ 0xCA0E7C00, 0xCA0E7DFF, "FJ" ],  // 202.14.124.0-202.14.125.255, FJ
        [ 0xCA0E7F00, 0xCA0E7FFF, "FJ" ],  // 202.14.127.0-202.14.127.255, FJ
        [ 0xCA0E8100, 0xCA0E81FF, "FJ" ],  // 202.14.129.0-202.14.129.255, FJ
        [ 0xCA0E8700, 0xCA0E88FF, "FJ" ],  // 202.14.135.0-202.14.136.255, FJ
        [ 0xCA0E9500, 0xCA0E95FF, "FJ" ],  // 202.14.149.0-202.14.149.255, FJ
        [ 0xCA0E9700, 0xCA0E97FF, "FJ" ],  // 202.14.151.0-202.14.151.255, FJ
        [ 0xCA0E9D00, 0xCA0E9FFF, "FJ" ],  // 202.14.157.0-202.14.159.255, FJ
        [ 0xCA0EA900, 0xCA0EABFF, "FJ" ],  // 202.14.169.0-202.14.171.255, FJ
        [ 0xCA0EAC00, 0xCA0EAFFF, "GD" ],  // 202.14.172.0-202.14.175.255, GD
        [ 0xCA0EB000, 0xCA0EB0FF, "FJ" ],  // 202.14.176.0-202.14.176.255, FJ
        [ 0xCA0EB800, 0xCA0EB9FF, "FJ" ],  // 202.14.184.0-202.14.185.255, FJ
        [ 0xCA0ED000, 0xCA0ED1FF, "FJ" ],  // 202.14.208.0-202.14.209.255, FJ
        [ 0xCA0ED500, 0xCA0ED5FF, "FJ" ],  // 202.14.213.0-202.14.213.255, FJ
        [ 0xCA0EDB00, 0xCA0EDCFF, "FJ" ],  // 202.14.219.0-202.14.220.255, FJ
        [ 0xCA0EDE00, 0xCA0EDFFF, "FJ" ],  // 202.14.222.0-202.14.223.255, FJ
        [ 0xCA0EE100, 0xCA0EE3FF, "FJ" ],  // 202.14.225.0-202.14.227.255, FJ
        [ 0xCA0EE700, 0xCA0EE7FF, "FJ" ],  // 202.14.231.0-202.14.231.255, FJ
        [ 0xCA0EEB00, 0xCA0EEEFF, "BJ" ],  // 202.14.235.0-202.14.238.255, BJ
        [ 0xCA0EEF00, 0xCA0EEFFF, "FJ" ],  // 202.14.239.0-202.14.239.255, FJ
        [ 0xCA0EF600, 0xCA0EF6FF, "FJ" ],  // 202.14.246.0-202.14.246.255, FJ
        [ 0xCA0EFB00, 0xCA0EFBFF, "FJ" ],  // 202.14.251.0-202.14.251.255, FJ
        [ 0xCA144200, 0xCA1442FF, "FJ" ],  // 202.20.66.0-202.20.66.255, FJ
        [ 0xCA144F00, 0xCA144FFF, "FJ" ],  // 202.20.79.0-202.20.79.255, FJ
        [ 0xCA145700, 0xCA145AFF, "FJ" ],  // 202.20.87.0-202.20.90.255, FJ
        [ 0xCA145E00, 0xCA145FFF, "FJ" ],  // 202.20.94.0-202.20.95.255, FJ
        [ 0xCA147200, 0xCA1472FF, "FJ" ],  // 202.20.114.0-202.20.114.255, FJ
        [ 0xCA147500, 0xCA1475FF, "FJ" ],  // 202.20.117.0-202.20.117.255, FJ
        [ 0xCA147800, 0xCA1478FF, "FJ" ],  // 202.20.120.0-202.20.120.255, FJ
        [ 0xCA147D00, 0xCA147DFF, "FJ" ],  // 202.20.125.0-202.20.125.255, FJ
        [ 0xCA147E00, 0xCA147EFF, "SC" ],  // 202.20.126.0-202.20.126.255, SC
        [ 0xCA147F00, 0xCA147FFF, "FJ" ],  // 202.20.127.0-202.20.127.255, FJ
        [ 0xCA153000, 0xCA1533FF, "JS" ],  // 202.21.48.0-202.21.51.255, JS
        [ 0xCA153400, 0xCA1537FF, "SX" ],  // 202.21.52.0-202.21.55.255, SX
        [ 0xCA153800, 0xCA153BFF, "SD" ],  // 202.21.56.0-202.21.59.255, SD
        [ 0xCA153C00, 0xCA153FFF, "JS" ],  // 202.21.60.0-202.21.63.255, JS
        [ 0xCA158300, 0xCA1584FF, "FJ" ],  // 202.21.131.0-202.21.132.255, FJ
        [ 0xCA158D00, 0xCA158EFF, "FJ" ],  // 202.21.141.0-202.21.142.255, FJ
        [ 0xCA159300, 0xCA1594FF, "FJ" ],  // 202.21.147.0-202.21.148.255, FJ
        [ 0xCA159600, 0xCA159AFF, "FJ" ],  // 202.21.150.0-202.21.154.255, FJ
        [ 0xCA159C00, 0xCA159CFF, "FJ" ],  // 202.21.156.0-202.21.156.255, FJ
        [ 0xCA16F800, 0xCA16FFFF, "SH" ],  // 202.22.248.0-202.22.255.255, SH
        [ 0xCA1B0C00, 0xCA1B0CFF, "SD" ],  // 202.27.12.0-202.27.12.255, SD
        [ 0xCA1B0E00, 0xCA1B0EFF, "SD" ],  // 202.27.14.0-202.27.14.255, SD
        [ 0xCA1B8800, 0xCA1B89FF, "FJ" ],  // 202.27.136.0-202.27.137.255, FJ
        [ 0xCA24E200, 0xCA24E2FF, "SC" ],  // 202.36.226.0-202.36.226.255, SC
        [ 0xCA260000, 0xCA2601FF, "FJ" ],  // 202.38.0.0-202.38.1.255, FJ
        [ 0xCA260200, 0xCA2603FF, "JS" ],  // 202.38.2.0-202.38.3.255, JS
        [ 0xCA260800, 0xCA260FFF, "BJ" ],  // 202.38.8.0-202.38.15.255, BJ
        [ 0xCA263000, 0xCA263FFF, "GD" ],  // 202.38.48.0-202.38.63.255, GD
        [ 0xCA264000, 0xCA266FFF, "AH" ],  // 202.38.64.0-202.38.111.255, AH
        [ 0xCA267000, 0xCA267DFF, "BJ" ],  // 202.38.112.0-202.38.125.255, BJ
        [ 0xCA267E00, 0xCA267EFF, "GS" ],  // 202.38.126.0-202.38.126.255, GS
        [ 0xCA267F00, 0xCA2681EF, "GD" ],  // 202.38.127.0-202.38.129.239, GD
        [ 0xCA2681F0, 0xCA2681F0, "BJ" ],  // 202.38.129.240-202.38.129.240, BJ
        [ 0xCA2681F1, 0xCA2681F4, "GD" ],  // 202.38.129.241-202.38.129.244, GD
        [ 0xCA2681F5, 0xCA2681FF, "BJ" ],  // 202.38.129.245-202.38.129.255, BJ
        [ 0xCA268200, 0xCA2683FF, "FJ" ],  // 202.38.130.0-202.38.131.255, FJ
        [ 0xCA268400, 0xCA2687FF, "SH" ],  // 202.38.132.0-202.38.135.255, SH
        [ 0xCA268800, 0xCA2689FF, "FJ" ],  // 202.38.136.0-202.38.137.255, FJ
        [ 0xCA268A00, 0xCA268AFF, "BJ" ],  // 202.38.138.0-202.38.138.255, BJ
        [ 0xCA268C00, 0xCA268C6F, "BJ" ],  // 202.38.140.0-202.38.140.111, BJ
        [ 0xCA268C70, 0xCA268C77, "AH" ],  // 202.38.140.112-202.38.140.119, AH
        [ 0xCA268C78, 0xCA268DFF, "BJ" ],  // 202.38.140.120-202.38.141.255, BJ
        [ 0xCA268E00, 0xCA268FFF, "FJ" ],  // 202.38.142.0-202.38.143.255, FJ
        [ 0xCA269200, 0xCA2693FF, "BJ" ],  // 202.38.146.0-202.38.147.255, BJ
        [ 0xCA269500, 0xCA2697FF, "FJ" ],  // 202.38.149.0-202.38.151.255, FJ
        [ 0xCA269800, 0xCA2699FF, "BJ" ],  // 202.38.152.0-202.38.153.255, BJ
        [ 0xCA269A00, 0xCA269CFF, "FJ" ],  // 202.38.154.0-202.38.156.255, FJ
        [ 0xCA269E00, 0xCA269FFF, "FJ" ],  // 202.38.158.0-202.38.159.255, FJ
        [ 0xCA26A000, 0xCA26A1FF, "BJ" ],  // 202.38.160.0-202.38.161.255, BJ
        [ 0xCA26A400, 0xCA26A7FF, "JL" ],  // 202.38.164.0-202.38.167.255, JL
        [ 0xCA26A800, 0xCA26AAFF, "FJ" ],  // 202.38.168.0-202.38.170.255, FJ
        [ 0xCA26B000, 0xCA26B1FF, "BJ" ],  // 202.38.176.0-202.38.177.255, BJ
        [ 0xCA26B800, 0xCA26BFFF, "BJ" ],  // 202.38.184.0-202.38.191.255, BJ
        [ 0xCA26C000, 0xCA26FFFF, "GD" ],  // 202.38.192.0-202.38.255.255, GD
        [ 0xCA280400, 0xCA2805FF, "FJ" ],  // 202.40.4.0-202.40.5.255, FJ
        [ 0xCA280700, 0xCA2807FF, "FJ" ],  // 202.40.7.0-202.40.7.255, FJ
        [ 0xCA280F00, 0xCA280FFF, "FJ" ],  // 202.40.15.0-202.40.15.255, FJ
        [ 0xCA288700, 0xCA2888FF, "FJ" ],  // 202.40.135.0-202.40.136.255, FJ
        [ 0xCA288C00, 0xCA288CFF, "FJ" ],  // 202.40.140.0-202.40.140.255, FJ
        [ 0xCA288F00, 0xCA2891FF, "FJ" ],  // 202.40.143.0-202.40.145.255, FJ
        [ 0xCA289600, 0xCA2896FF, "FJ" ],  // 202.40.150.0-202.40.150.255, FJ
        [ 0xCA289B00, 0xCA289CFF, "FJ" ],  // 202.40.155.0-202.40.156.255, FJ
        [ 0xCA289E00, 0xCA289FFF, "FJ" ],  // 202.40.158.0-202.40.159.255, FJ
        [ 0xCA28A200, 0xCA28A2FF, "FJ" ],  // 202.40.162.0-202.40.162.255, FJ
        [ 0xCA290800, 0xCA2909FF, "FJ" ],  // 202.41.8.0-202.41.9.255, FJ
        [ 0xCA290B00, 0xCA290DFF, "FJ" ],  // 202.41.11.0-202.41.13.255, FJ
        [ 0xCA298000, 0xCA2980FF, "FJ" ],  // 202.41.128.0-202.41.128.255, FJ
        [ 0xCA298200, 0xCA2983FF, "FJ" ],  // 202.41.130.0-202.41.131.255, FJ
        [ 0xCA298E00, 0xCA298EFF, "BJ" ],  // 202.41.142.0-202.41.142.255, BJ
        [ 0xCA299800, 0xCA299FFF, "GD" ],  // 202.41.152.0-202.41.159.255, GD
        [ 0xCA29C000, 0xCA29C0FF, "FJ" ],  // 202.41.192.0-202.41.192.255, FJ
        [ 0xCA29C400, 0xCA29C7FF, "BJ" ],  // 202.41.196.0-202.41.199.255, BJ
        [ 0xCA29C800, 0xCA29CBFF, "JS" ],  // 202.41.200.0-202.41.203.255, JS
        [ 0xCA29F000, 0xCA29FFFF, "BJ" ],  // 202.41.240.0-202.41.255.255, BJ
        [ 0xCA2B4C00, 0xCA2B4FFF, "BJ" ],  // 202.43.76.0-202.43.79.255, BJ
        [ 0xCA2B9000, 0xCA2B9FFF, "BJ" ],  // 202.43.144.0-202.43.159.255, BJ
        [ 0xCA2C1000, 0xCA2C1FFF, "GD" ],  // 202.44.16.0-202.44.31.255, GD
        [ 0xCA2C3000, 0xCA2C33FF, "SC" ],  // 202.44.48.0-202.44.51.255, SC
        [ 0xCA2C4300, 0xCA2C43FF, "FJ" ],  // 202.44.67.0-202.44.67.255, FJ
        [ 0xCA2C4A00, 0xCA2C4AFF, "FJ" ],  // 202.44.74.0-202.44.74.255, FJ
        [ 0xCA2C6100, 0xCA2C61FF, "SD" ],  // 202.44.97.0-202.44.97.255, SD
        [ 0xCA2C8100, 0xCA2C81FF, "FJ" ],  // 202.44.129.0-202.44.129.255, FJ
        [ 0xCA2C8400, 0xCA2C85FF, "FJ" ],  // 202.44.132.0-202.44.133.255, FJ
        [ 0xCA2C9200, 0xCA2C93FF, "FJ" ],  // 202.44.146.0-202.44.147.255, FJ
        [ 0xCA2D0000, 0xCA2D02FF, "FJ" ],  // 202.45.0.0-202.45.2.255, FJ
        [ 0xCA2D0F00, 0xCA2D0FFF, "FJ" ],  // 202.45.15.0-202.45.15.255, FJ
        [ 0xCA2D1000, 0xCA2D1FFF, "GD" ],  // 202.45.16.0-202.45.31.255, GD
        [ 0xCA2E1000, 0xCA2E12FF, "FJ" ],  // 202.46.16.0-202.46.18.255, FJ
        [ 0xCA2E1400, 0xCA2E15FF, "FJ" ],  // 202.46.20.0-202.46.21.255, FJ
        [ 0xCA2E2100, 0xCA2E27FF, "SH" ],  // 202.46.33.0-202.46.39.255, SH
        [ 0xCA2E2900, 0xCA2E2AFF, "SH" ],  // 202.46.41.0-202.46.42.255, SH
        [ 0xCA2E2B00, 0xCA2E2BFF, "GD" ],  // 202.46.43.0-202.46.43.255, GD
        [ 0xCA2E2C00, 0xCA2E2FFF, "SH" ],  // 202.46.44.0-202.46.47.255, SH
        [ 0xCA2E3000, 0xCA2E3FFF, "GD" ],  // 202.46.48.0-202.46.63.255, GD
        [ 0xCA2E8000, 0xCA2E80FF, "FJ" ],  // 202.46.128.0-202.46.128.255, FJ
        [ 0xCA2EE000, 0xCA2EEFFF, "GD" ],  // 202.46.224.0-202.46.239.255, GD
        [ 0xCA2F5200, 0xCA2F53FF, "FJ" ],  // 202.47.82.0-202.47.83.255, FJ
        [ 0xCA2F6000, 0xCA2F63FF, "HE" ],  // 202.47.96.0-202.47.99.255, HE
        [ 0xCA2F6400, 0xCA2F67FF, "TJ" ],  // 202.47.100.0-202.47.103.255, TJ
        [ 0xCA2F6800, 0xCA2F6FFF, "BJ" ],  // 202.47.104.0-202.47.111.255, BJ
        [ 0xCA2F7E00, 0xCA2F7EFF, "FJ" ],  // 202.47.126.0-202.47.126.255, FJ
        [ 0xCA2F8000, 0xCA2F80FF, "FJ" ],  // 202.47.128.0-202.47.128.255, FJ
        [ 0xCA2F8200, 0xCA2F83FF, "FJ" ],  // 202.47.130.0-202.47.131.255, FJ
        [ 0xCA342100, 0xCA3421FF, "BJ" ],  // 202.52.33.0-202.52.33.255, BJ
        [ 0xCA342200, 0xCA3422FF, "SC" ],  // 202.52.34.0-202.52.34.255, SC
        [ 0xCA342F00, 0xCA342FFF, "BJ" ],  // 202.52.47.0-202.52.47.255, BJ
        [ 0xCA348F00, 0xCA348FFF, "HB" ],  // 202.52.143.0-202.52.143.255, HB
        [ 0xCA358C00, 0xCA358CFF, "SD" ],  // 202.53.140.0-202.53.140.255, SD
        [ 0xCA358F00, 0xCA358FFF, "SH" ],  // 202.53.143.0-202.53.143.255, SH
        [ 0xCA39C000, 0xCA39CFFF, "BJ" ],  // 202.57.192.0-202.57.207.255, BJ
        [ 0xCA39D400, 0xCA39DBFF, "SH" ],  // 202.57.212.0-202.57.219.255, SH
        [ 0xCA39F000, 0xCA39FFFF, "GD" ],  // 202.57.240.0-202.57.255.255, GD
        [ 0xCA3A0000, 0xCA3A00FF, "FJ" ],  // 202.58.0.0-202.58.0.255, FJ
        [ 0xCA3A7000, 0xCA3A73FF, "SH" ],  // 202.58.112.0-202.58.115.255, SH
        [ 0xCA3B0000, 0xCA3B00FF, "FJ" ],  // 202.59.0.0-202.59.0.255, FJ
        [ 0xCA3B0100, 0xCA3B01FF, "SD" ],  // 202.59.1.0-202.59.1.255, SD
        [ 0xCA3BD400, 0xCA3BD4FF, "SH" ],  // 202.59.212.0-202.59.212.255, SH
        [ 0xCA3BD500, 0xCA3BD5FF, "BJ" ],  // 202.59.213.0-202.59.213.255, BJ
        [ 0xCA3BD600, 0xCA3BD6FF, "SH" ],  // 202.59.214.0-202.59.214.255, SH
        [ 0xCA3BD700, 0xCA3BD7FF, "GD" ],  // 202.59.215.0-202.59.215.255, GD
        [ 0xCA3BEC00, 0xCA3BECFF, "FJ" ],  // 202.59.236.0-202.59.236.255, FJ
        [ 0xCA3BF000, 0xCA3BF0FF, "SH" ],  // 202.59.240.0-202.59.240.255, SH
        [ 0xCA3C3000, 0xCA3C37FF, "GD" ],  // 202.60.48.0-202.60.55.255, GD
        [ 0xCA3C6000, 0xCA3C67FF, "GD" ],  // 202.60.96.0-202.60.103.255, GD
        [ 0xCA3C7000, 0xCA3C7FFF, "BJ" ],  // 202.60.112.0-202.60.127.255, BJ
        [ 0xCA3C8400, 0xCA3C87FF, "JS" ],  // 202.60.132.0-202.60.135.255, JS
        [ 0xCA3C8800, 0xCA3C9FFF, "GD" ],  // 202.60.136.0-202.60.159.255, GD
        [ 0xCA3D4400, 0xCA3D47FF, "BJ" ],  // 202.61.68.0-202.61.71.255, BJ
        [ 0xCA3D4C00, 0xCA3D4FFF, "LN" ],  // 202.61.76.0-202.61.79.255, LN
        [ 0xCA3D5800, 0xCA3D5BFF, "SC" ],  // 202.61.88.0-202.61.91.255, SC
        [ 0xCA3D7B00, 0xCA3D7BFF, "SD" ],  // 202.61.123.0-202.61.123.255, SD
        [ 0xCA3D7F00, 0xCA3D7FFF, "SH" ],  // 202.61.127.0-202.61.127.255, SH
        [ 0xCA3E7000, 0xCA3E73FF, "JS" ],  // 202.62.112.0-202.62.115.255, JS
        [ 0xCA3EF800, 0xCA3EFCFF, "FJ" ],  // 202.62.248.0-202.62.252.255, FJ
        [ 0xCA3EFF00, 0xCA3EFFFF, "FJ" ],  // 202.62.255.0-202.62.255.255, FJ
        [ 0xCA3F5000, 0xCA3F50FF, "SD" ],  // 202.63.80.0-202.63.80.255, SD
        [ 0xCA3F5100, 0xCA3F53FF, "FJ" ],  // 202.63.81.0-202.63.83.255, FJ
        [ 0xCA3F5400, 0xCA3F57FF, "JS" ],  // 202.63.84.0-202.63.87.255, JS
        [ 0xCA3F5800, 0xCA3F5FFF, "GD" ],  // 202.63.88.0-202.63.95.255, GD
        [ 0xCA3FA000, 0xCA3FBFFF, "HE" ],  // 202.63.160.0-202.63.191.255, HE
        [ 0xCA3FF800, 0xCA3FFBFF, "HL" ],  // 202.63.248.0-202.63.251.255, HL
        [ 0xCA3FFD00, 0xCA3FFDFF, "SC" ],  // 202.63.253.0-202.63.253.255, SC
        [ 0xCA410000, 0xCA4107FF, "GD" ],  // 202.65.0.0-202.65.7.255, GD
        [ 0xCA410800, 0xCA4109FF, "FJ" ],  // 202.65.8.0-202.65.9.255, FJ
        [ 0xCA416000, 0xCA4163FF, "BJ" ],  // 202.65.96.0-202.65.99.255, BJ
        [ 0xCA416400, 0xCA4167FF, "ZJ" ],  // 202.65.100.0-202.65.103.255, ZJ
        [ 0xCA416800, 0xCA416FFF, "BJ" ],  // 202.65.104.0-202.65.111.255, BJ
        [ 0xCA42A800, 0xCA42ABFF, "GD" ],  // 202.66.168.0-202.66.171.255, GD
        [ 0xCA430000, 0xCA4302FF, "FJ" ],  // 202.67.0.0-202.67.2.255, FJ
        [ 0xCA430300, 0xCA4303FF, "SH" ],  // 202.67.3.0-202.67.3.255, SH
        [ 0xCA450400, 0xCA4507FF, "BJ" ],  // 202.69.4.0-202.69.7.255, BJ
        [ 0xCA451000, 0xCA451FFF, "GD" ],  // 202.69.16.0-202.69.31.255, GD
        [ 0xCA460000, 0xCA461FFF, "GD" ],  // 202.70.0.0-202.70.31.255, GD
        [ 0xCA466000, 0xCA466FFF, "GD" ],  // 202.70.96.0-202.70.111.255, GD
        [ 0xCA46C000, 0xCA46CFFF, "GD" ],  // 202.70.192.0-202.70.207.255, GD
        [ 0xCA472000, 0xCA4723FF, "FJ" ],  // 202.71.32.0-202.71.35.255, FJ
        [ 0xCA472400, 0xCA472BFF, "JS" ],  // 202.71.36.0-202.71.43.255, JS
        [ 0xCA472C00, 0xCA472FFF, "HB" ],  // 202.71.44.0-202.71.47.255, HB
        [ 0xCA482800, 0xCA482FFF, "GD" ],  // 202.72.40.0-202.72.47.255, GD
        [ 0xCA485000, 0xCA485FFF, "GD" ],  // 202.72.80.0-202.72.95.255, GD
        [ 0xCA487000, 0xCA4873FF, "ZJ" ],  // 202.72.112.0-202.72.115.255, ZJ
        [ 0xCA487400, 0xCA487FFF, "SH" ],  // 202.72.116.0-202.72.127.255, SH
        [ 0xCA498000, 0xCA4981FF, "FJ" ],  // 202.73.128.0-202.73.129.255, FJ
        [ 0xCA498200, 0xCA4982FF, "SH" ],  // 202.73.130.0-202.73.130.255, SH
        [ 0xCA498300, 0xCA4983FF, "FJ" ],  // 202.73.131.0-202.73.131.255, FJ
        [ 0xCA49F000, 0xCA49F7FF, "BJ" ],  // 202.73.240.0-202.73.247.255, BJ
        [ 0xCA49F800, 0xCA49FBFF, "ZJ" ],  // 202.73.248.0-202.73.251.255, ZJ
        [ 0xCA49FC00, 0xCA49FFFF, "BJ" ],  // 202.73.252.0-202.73.255.255, BJ
        [ 0xCA4A0800, 0xCA4A0FFF, "GD" ],  // 202.74.8.0-202.74.15.255, GD
        [ 0xCA4A2400, 0xCA4A24FF, "SD" ],  // 202.74.36.0-202.74.36.255, SD
        [ 0xCA4A2A00, 0xCA4A2AFF, "SC" ],  // 202.74.42.0-202.74.42.255, SC
        [ 0xCA4A3400, 0xCA4A34FF, "SD" ],  // 202.74.52.0-202.74.52.255, SD
        [ 0xCA4A5000, 0xCA4A5FFF, "GD" ],  // 202.74.80.0-202.74.95.255, GD
        [ 0xCA4AFE00, 0xCA4AFFFF, "FJ" ],  // 202.74.254.0-202.74.255.255, FJ
        [ 0xCA4BD000, 0xCA4BDFFF, "ZJ" ],  // 202.75.208.0-202.75.223.255, ZJ
        [ 0xCA4BFC00, 0xCA4BFFFF, "FJ" ],  // 202.75.252.0-202.75.255.255, FJ
        [ 0xCA4CF700, 0xCA4CF7FF, "SH" ],  // 202.76.247.0-202.76.247.255, SH
        [ 0xCA4CFC00, 0xCA4CFFFF, "FJ" ],  // 202.76.252.0-202.76.255.255, FJ
        [ 0xCA4D5000, 0xCA4D57FF, "GD" ],  // 202.77.80.0-202.77.87.255, GD
        [ 0xCA4D5C00, 0xCA4D5FFF, "FJ" ],  // 202.77.92.0-202.77.95.255, FJ
        [ 0xCA4E0800, 0xCA4E0FFF, "GD" ],  // 202.78.8.0-202.78.15.255, GD
        [ 0xCA4FE000, 0xCA4FE7FF, "GD" ],  // 202.79.224.0-202.79.231.255, GD
        [ 0xCA4FF800, 0xCA4FFBFF, "FJ" ],  // 202.79.248.0-202.79.251.255, FJ
        [ 0xCA50C000, 0xCA50C3FF, "BJ" ],  // 202.80.192.0-202.80.195.255, BJ
        [ 0xCA50C400, 0xCA50C7FF, "FJ" ],  // 202.80.196.0-202.80.199.255, FJ
        [ 0xCA50C800, 0xCA50CFFF, "GD" ],  // 202.80.200.0-202.80.207.255, GD
        [ 0xCA510000, 0xCA5103FF, "FJ" ],  // 202.81.0.0-202.81.3.255, FJ
        [ 0xCA51B000, 0xCA51BFFF, "SH" ],  // 202.81.176.0-202.81.191.255, SH
        [ 0xCA53FC00, 0xCA53FFFF, "FJ" ],  // 202.83.252.0-202.83.255.255, FJ
        [ 0xCA540000, 0xCA5403FF, "BJ" ],  // 202.84.0.0-202.84.3.255, BJ
        [ 0xCA540400, 0xCA5407FF, "FJ" ],  // 202.84.4.0-202.84.7.255, FJ
        [ 0xCA540800, 0xCA5409FF, "GD" ],  // 202.84.8.0-202.84.9.255, GD
        [ 0xCA540A00, 0xCA540BFF, "BJ" ],  // 202.84.10.0-202.84.11.255, BJ
        [ 0xCA540C00, 0xCA540FFF, "GD" ],  // 202.84.12.0-202.84.15.255, GD
        [ 0xCA541000, 0xCA5411FF, "BJ" ],  // 202.84.16.0-202.84.17.255, BJ
        [ 0xCA541600, 0xCA5416FF, "SC" ],  // 202.84.22.0-202.84.22.255, SC
        [ 0xCA541800, 0xCA541FFF, "GD" ],  // 202.84.24.0-202.84.31.255, GD
        [ 0xCA55D000, 0xCA55DFFF, "BJ" ],  // 202.85.208.0-202.85.223.255, BJ
        [ 0xCA56F900, 0xCA56F9FF, "FJ" ],  // 202.86.249.0-202.86.249.255, FJ
        [ 0xCA56FC00, 0xCA56FFFF, "FJ" ],  // 202.86.252.0-202.86.255.255, FJ
        [ 0xCA575000, 0xCA575FFF, "GD" ],  // 202.87.80.0-202.87.95.255, GD
        [ 0xCA582000, 0xCA5823FF, "HE" ],  // 202.88.32.0-202.88.35.255, HE
        [ 0xCA590800, 0xCA590FFF, "GD" ],  // 202.89.8.0-202.89.15.255, GD
        [ 0xCA596000, 0xCA5963FF, "SH" ],  // 202.89.96.0-202.89.99.255, SH
        [ 0xCA596C00, 0xCA596FFF, "SH" ],  // 202.89.108.0-202.89.111.255, SH
        [ 0xCA597700, 0xCA5977FF, "SD" ],  // 202.89.119.0-202.89.119.255, SD
        [ 0xCA59E800, 0xCA59EFFF, "BJ" ],  // 202.89.232.0-202.89.239.255, BJ
        [ 0xCA5A0000, 0xCA5A03FF, "GD" ],  // 202.90.0.0-202.90.3.255, GD
        [ 0xCA5A1000, 0xCA5A13FF, "LN" ],  // 202.90.16.0-202.90.19.255, LN
        [ 0xCA5A1400, 0xCA5A17FF, "JS" ],  // 202.90.20.0-202.90.23.255, JS
        [ 0xCA5A1800, 0xCA5A1BFF, "HL" ],  // 202.90.24.0-202.90.27.255, HL
        [ 0xCA5A1C00, 0xCA5A1FFF, "LN" ],  // 202.90.28.0-202.90.31.255, LN
        [ 0xCA5A2500, 0xCA5A25FF, "SC" ],  // 202.90.37.0-202.90.37.255, SC
        [ 0xCA5A6000, 0xCA5A6FFF, "SH" ],  // 202.90.96.0-202.90.111.255, SH
        [ 0xCA5A7000, 0xCA5A7FFF, "GD" ],  // 202.90.112.0-202.90.127.255, GD
        [ 0xCA5AC100, 0xCA5AC1FF, "SD" ],  // 202.90.193.0-202.90.193.255, SD
        [ 0xCA5AC400, 0xCA5AC4FF, "FJ" ],  // 202.90.196.0-202.90.196.255, FJ
        [ 0xCA5ACD00, 0xCA5ACDFF, "HB" ],  // 202.90.205.0-202.90.205.255, HB
        [ 0xCA5AE000, 0xCA5AE7FF, "BJ" ],  // 202.90.224.0-202.90.231.255, BJ
        [ 0xCA5AE800, 0xCA5AEFFF, "GD" ],  // 202.90.232.0-202.90.239.255, GD
        [ 0xCA5B0000, 0xCA5B03FF, "FJ" ],  // 202.91.0.0-202.91.3.255, FJ
        [ 0xCA5B6000, 0xCA5B6FFF, "GD" ],  // 202.91.96.0-202.91.111.255, GD
        [ 0xCA5B8000, 0xCA5B83FF, "BJ" ],  // 202.91.128.0-202.91.131.255, BJ
        [ 0xCA5BB000, 0xCA5BBFFF, "BJ" ],  // 202.91.176.0-202.91.191.255, BJ
        [ 0xCA5BE000, 0xCA5BFFFF, "ZJ" ],  // 202.91.224.0-202.91.255.255, ZJ
        [ 0xCA5C0000, 0xCA5C03FF, "JS" ],  // 202.92.0.0-202.92.3.255, JS
        [ 0xCA5C0800, 0xCA5C0FFF, "GD" ],  // 202.92.8.0-202.92.15.255, GD
        [ 0xCA5C3000, 0xCA5C3FFF, "GD" ],  // 202.92.48.0-202.92.63.255, GD
        [ 0xCA5CFC00, 0xCA5CFFFF, "FJ" ],  // 202.92.252.0-202.92.255.255, FJ
        [ 0xCA5D0000, 0xCA5D03FF, "GD" ],  // 202.93.0.0-202.93.3.255, GD
        [ 0xCA5DFC00, 0xCA5E1FFF, "BJ" ],  // 202.93.252.0-202.94.31.255, BJ
        [ 0xCA5E4A00, 0xCA5E4AFF, "FJ" ],  // 202.94.74.0-202.94.74.255, FJ
        [ 0xCA5E5100, 0xCA5E51FF, "HB" ],  // 202.94.81.0-202.94.81.255, HB
        [ 0xCA5E5C00, 0xCA5E5FFF, "FJ" ],  // 202.94.92.0-202.94.95.255, FJ
        [ 0xCA5F0000, 0xCA5F03FF, "BJ" ],  // 202.95.0.0-202.95.3.255, BJ
        [ 0xCA5FF000, 0xCA5FF7FF, "GD" ],  // 202.95.240.0-202.95.247.255, GD
        [ 0xCA5FFC00, 0xCA5FFFFF, "SH" ],  // 202.95.252.0-202.95.255.255, SH
        [ 0xCA600000, 0xCA603FFF, "BJ" ],  // 202.96.0.0-202.96.63.255, BJ
        [ 0xCA604000, 0xCA605FFF, "LN" ],  // 202.96.64.0-202.96.95.255, LN
        [ 0xCA606000, 0xCA607FFF, "ZJ" ],  // 202.96.96.0-202.96.127.255, ZJ
        [ 0xCA608000, 0xCA60BFFF, "GD" ],  // 202.96.128.0-202.96.191.255, GD
        [ 0xCA60C000, 0xCA60FFFF, "SH" ],  // 202.96.192.0-202.96.255.255, SH
        [ 0xCA610000, 0xCA6101FF, "BJ" ],  // 202.97.0.0-202.97.1.255, BJ
        [ 0xCA610200, 0xCA6102FF, "XZ" ],  // 202.97.2.0-202.97.2.255, XZ
        [ 0xCA610300, 0xCA610EFF, "BJ" ],  // 202.97.3.0-202.97.14.255, BJ
        [ 0xCA610F00, 0xCA611007, "SH" ],  // 202.97.15.0-202.97.16.7, SH
        [ 0xCA611008, 0xCA61101B, "GD" ],  // 202.97.16.8-202.97.16.27, GD
        [ 0xCA61101C, 0xCA61101C, "JS" ],  // 202.97.16.28-202.97.16.28, JS
        [ 0xCA61101D, 0xCA61101D, "GD" ],  // 202.97.16.29-202.97.16.29, GD
        [ 0xCA61101E, 0xCA611020, "JS" ],  // 202.97.16.30-202.97.16.32, JS
        [ 0xCA611021, 0xCA611021, "GD" ],  // 202.97.16.33-202.97.16.33, GD
        [ 0xCA611022, 0xCA611033, "JS" ],  // 202.97.16.34-202.97.16.51, JS
        [ 0xCA611034, 0xCA61103B, "GD" ],  // 202.97.16.52-202.97.16.59, GD
        [ 0xCA61103C, 0xCA61103F, "JS" ],  // 202.97.16.60-202.97.16.63, JS
        [ 0xCA611040, 0xCA611043, "SH" ],  // 202.97.16.64-202.97.16.67, SH
        [ 0xCA611044, 0xCA611047, "GD" ],  // 202.97.16.68-202.97.16.71, GD
        [ 0xCA611048, 0xCA611049, "JS" ],  // 202.97.16.72-202.97.16.73, JS
        [ 0xCA61104A, 0xCA61104A, "SH" ],  // 202.97.16.74-202.97.16.74, SH
        [ 0xCA61104B, 0xCA61104B, "JS" ],  // 202.97.16.75-202.97.16.75, JS
        [ 0xCA61104C, 0xCA61104F, "SH" ],  // 202.97.16.76-202.97.16.79, SH
        [ 0xCA611050, 0xCA611069, "JS" ],  // 202.97.16.80-202.97.16.105, JS
        [ 0xCA61106A, 0xCA61106B, "SC" ],  // 202.97.16.106-202.97.16.107, SC
        [ 0xCA61106C, 0xCA61106D, "JS" ],  // 202.97.16.108-202.97.16.109, JS
        [ 0xCA61106E, 0xCA61106E, "SC" ],  // 202.97.16.110-202.97.16.110, SC
        [ 0xCA61106F, 0xCA611071, "JS" ],  // 202.97.16.111-202.97.16.113, JS
        [ 0xCA611072, 0xCA611073, "SC" ],  // 202.97.16.114-202.97.16.115, SC
        [ 0xCA611074, 0xCA611075, "JS" ],  // 202.97.16.116-202.97.16.117, JS
        [ 0xCA611076, 0xCA611076, "SC" ],  // 202.97.16.118-202.97.16.118, SC
        [ 0xCA611077, 0xCA6110A1, "JS" ],  // 202.97.16.119-202.97.16.161, JS
        [ 0xCA6110A2, 0xCA6110A2, "SC" ],  // 202.97.16.162-202.97.16.162, SC
        [ 0xCA6110A3, 0xCA6110A5, "JS" ],  // 202.97.16.163-202.97.16.165, JS
        [ 0xCA6110A6, 0xCA6110A6, "SC" ],  // 202.97.16.166-202.97.16.166, SC
        [ 0xCA6110A7, 0xCA6110A9, "JS" ],  // 202.97.16.167-202.97.16.169, JS
        [ 0xCA6110AA, 0xCA6110AA, "SC" ],  // 202.97.16.170-202.97.16.170, SC
        [ 0xCA6110AB, 0xCA6110AD, "JS" ],  // 202.97.16.171-202.97.16.173, JS
        [ 0xCA6110AE, 0xCA6110AE, "SC" ],  // 202.97.16.174-202.97.16.174, SC
        [ 0xCA6110AF, 0xCA6110B1, "JS" ],  // 202.97.16.175-202.97.16.177, JS
        [ 0xCA6110B2, 0xCA6110B2, "SC" ],  // 202.97.16.178-202.97.16.178, SC
        [ 0xCA6110B3, 0xCA6110B5, "JS" ],  // 202.97.16.179-202.97.16.181, JS
        [ 0xCA6110B6, 0xCA6110B6, "SC" ],  // 202.97.16.182-202.97.16.182, SC
        [ 0xCA6110B7, 0xCA6110B9, "JS" ],  // 202.97.16.183-202.97.16.185, JS
        [ 0xCA6110BA, 0xCA6110BA, "SC" ],  // 202.97.16.186-202.97.16.186, SC
        [ 0xCA6110BB, 0xCA6110BD, "JS" ],  // 202.97.16.187-202.97.16.189, JS
        [ 0xCA6110BE, 0xCA6110BE, "SC" ],  // 202.97.16.190-202.97.16.190, SC
        [ 0xCA6110BF, 0xCA6110FF, "JS" ],  // 202.97.16.191-202.97.16.255, JS
        [ 0xCA611100, 0xCA6111FF, "GD" ],  // 202.97.17.0-202.97.17.255, GD
        [ 0xCA611200, 0xCA611203, "JS" ],  // 202.97.18.0-202.97.18.3, JS
        [ 0xCA611204, 0xCA611240, "GD" ],  // 202.97.18.4-202.97.18.64, GD
        [ 0xCA611241, 0xCA611241, "AH" ],  // 202.97.18.65-202.97.18.65, AH
        [ 0xCA611242, 0xCA611244, "GD" ],  // 202.97.18.66-202.97.18.68, GD
        [ 0xCA611245, 0xCA611245, "JS" ],  // 202.97.18.69-202.97.18.69, JS
        [ 0xCA611246, 0xCA611246, "AH" ],  // 202.97.18.70-202.97.18.70, AH
        [ 0xCA611247, 0xCA61124C, "GD" ],  // 202.97.18.71-202.97.18.76, GD
        [ 0xCA61124D, 0xCA61124D, "AH" ],  // 202.97.18.77-202.97.18.77, AH
        [ 0xCA61124E, 0xCA61124E, "JS" ],  // 202.97.18.78-202.97.18.78, JS
        [ 0xCA61124F, 0xCA611254, "GD" ],  // 202.97.18.79-202.97.18.84, GD
        [ 0xCA611255, 0xCA611255, "JS" ],  // 202.97.18.85-202.97.18.85, JS
        [ 0xCA611256, 0xCA611256, "SH" ],  // 202.97.18.86-202.97.18.86, SH
        [ 0xCA611257, 0xCA61125B, "GD" ],  // 202.97.18.87-202.97.18.91, GD
        [ 0xCA61125C, 0xCA611263, "AH" ],  // 202.97.18.92-202.97.18.99, AH
        [ 0xCA611264, 0xCA611287, "GD" ],  // 202.97.18.100-202.97.18.135, GD
        [ 0xCA611288, 0xCA61128B, "AH" ],  // 202.97.18.136-202.97.18.139, AH
        [ 0xCA61128C, 0xCA6112DF, "BJ" ],  // 202.97.18.140-202.97.18.223, BJ
        [ 0xCA6112E0, 0xCA6112E3, "AH" ],  // 202.97.18.224-202.97.18.227, AH
        [ 0xCA6112E4, 0xCA6112FF, "GD" ],  // 202.97.18.228-202.97.18.255, GD
        [ 0xCA611300, 0xCA611306, "SN" ],  // 202.97.19.0-202.97.19.6, SN
        [ 0xCA611307, 0xCA611309, "YN" ],  // 202.97.19.7-202.97.19.9, YN
        [ 0xCA61130A, 0xCA61131A, "SN" ],  // 202.97.19.10-202.97.19.26, SN
        [ 0xCA61131B, 0xCA61131E, "CQ" ],  // 202.97.19.27-202.97.19.30, CQ
        [ 0xCA61131F, 0xCA611329, "SN" ],  // 202.97.19.31-202.97.19.41, SN
        [ 0xCA61132A, 0xCA61132C, "SC" ],  // 202.97.19.42-202.97.19.44, SC
        [ 0xCA61132D, 0xCA611331, "SH" ],  // 202.97.19.45-202.97.19.49, SH
        [ 0xCA611332, 0xCA611399, "SN" ],  // 202.97.19.50-202.97.19.153, SN
        [ 0xCA61139A, 0xCA6113A1, "JS" ],  // 202.97.19.154-202.97.19.161, JS
        [ 0xCA6113A2, 0xCA6113D2, "SN" ],  // 202.97.19.162-202.97.19.210, SN
        [ 0xCA6113D3, 0xCA6113D5, "SC" ],  // 202.97.19.211-202.97.19.213, SC
        [ 0xCA6113D6, 0xCA6113D6, "SN" ],  // 202.97.19.214-202.97.19.214, SN
        [ 0xCA6113D7, 0xCA6113D9, "CQ" ],  // 202.97.19.215-202.97.19.217, CQ
        [ 0xCA6113DA, 0xCA6113DA, "SN" ],  // 202.97.19.218-202.97.19.218, SN
        [ 0xCA6113DB, 0xCA6113DD, "CQ" ],  // 202.97.19.219-202.97.19.221, CQ
        [ 0xCA6113DE, 0xCA6113F6, "SN" ],  // 202.97.19.222-202.97.19.246, SN
        [ 0xCA6113F7, 0xCA6113FF, "SH" ],  // 202.97.19.247-202.97.19.255, SH
        [ 0xCA611400, 0xCA6114FF, "BJ" ],  // 202.97.20.0-202.97.20.255, BJ
        [ 0xCA611500, 0xCA61157F, "GS" ],  // 202.97.21.0-202.97.21.127, GS
        [ 0xCA611580, 0xCA6115FF, "GX" ],  // 202.97.21.128-202.97.21.255, GX
        [ 0xCA611600, 0xCA6116FF, "JS" ],  // 202.97.22.0-202.97.22.255, JS
        [ 0xCA611700, 0xCA6117FF, "SC" ],  // 202.97.23.0-202.97.23.255, SC
        [ 0xCA611800, 0xCA6118FF, "SH" ],  // 202.97.24.0-202.97.24.255, SH
        [ 0xCA611900, 0xCA611AFF, "GD" ],  // 202.97.25.0-202.97.26.255, GD
        [ 0xCA611B00, 0xCA611BFF, "JS" ],  // 202.97.27.0-202.97.27.255, JS
        [ 0xCA611C00, 0xCA611CFF, "CQ" ],  // 202.97.28.0-202.97.28.255, CQ
        [ 0xCA611D00, 0xCA611D01, "HB" ],  // 202.97.29.0-202.97.29.1, HB
        [ 0xCA611D02, 0xCA611D02, "SC" ],  // 202.97.29.2-202.97.29.2, SC
        [ 0xCA611D03, 0xCA611D05, "HB" ],  // 202.97.29.3-202.97.29.5, HB
        [ 0xCA611D06, 0xCA611D06, "SC" ],  // 202.97.29.6-202.97.29.6, SC
        [ 0xCA611D07, 0xCA611D09, "HB" ],  // 202.97.29.7-202.97.29.9, HB
        [ 0xCA611D0A, 0xCA611D0A, "SC" ],  // 202.97.29.10-202.97.29.10, SC
        [ 0xCA611D0B, 0xCA611D0D, "HB" ],  // 202.97.29.11-202.97.29.13, HB
        [ 0xCA611D0E, 0xCA611D13, "SC" ],  // 202.97.29.14-202.97.29.19, SC
        [ 0xCA611D14, 0xCA611D15, "GD" ],  // 202.97.29.20-202.97.29.21, GD
        [ 0xCA611D16, 0xCA611D23, "BJ" ],  // 202.97.29.22-202.97.29.35, BJ
        [ 0xCA611D24, 0xCA611D25, "GD" ],  // 202.97.29.36-202.97.29.37, GD
        [ 0xCA611D26, 0xCA611D2B, "SC" ],  // 202.97.29.38-202.97.29.43, SC
        [ 0xCA611D2C, 0xCA611D2D, "GD" ],  // 202.97.29.44-202.97.29.45, GD
        [ 0xCA611D2E, 0xCA611D2F, "SC" ],  // 202.97.29.46-202.97.29.47, SC
        [ 0xCA611D30, 0xCA611D31, "GD" ],  // 202.97.29.48-202.97.29.49, GD
        [ 0xCA611D32, 0xCA611D33, "HB" ],  // 202.97.29.50-202.97.29.51, HB
        [ 0xCA611D34, 0xCA611D35, "GD" ],  // 202.97.29.52-202.97.29.53, GD
        [ 0xCA611D36, 0xCA611D37, "HB" ],  // 202.97.29.54-202.97.29.55, HB
        [ 0xCA611D38, 0xCA611D39, "GD" ],  // 202.97.29.56-202.97.29.57, GD
        [ 0xCA611D3A, 0xCA611D43, "HB" ],  // 202.97.29.58-202.97.29.67, HB
        [ 0xCA611D44, 0xCA611D45, "GD" ],  // 202.97.29.68-202.97.29.69, GD
        [ 0xCA611D46, 0xCA611D47, "HB" ],  // 202.97.29.70-202.97.29.71, HB
        [ 0xCA611D48, 0xCA611D49, "GD" ],  // 202.97.29.72-202.97.29.73, GD
        [ 0xCA611D4A, 0xCA611D4C, "JS" ],  // 202.97.29.74-202.97.29.76, JS
        [ 0xCA611D4D, 0xCA611D4D, "GD" ],  // 202.97.29.77-202.97.29.77, GD
        [ 0xCA611D4E, 0xCA611D50, "JS" ],  // 202.97.29.78-202.97.29.80, JS
        [ 0xCA611D51, 0xCA611D51, "GD" ],  // 202.97.29.81-202.97.29.81, GD
        [ 0xCA611D52, 0xCA611D54, "JS" ],  // 202.97.29.82-202.97.29.84, JS
        [ 0xCA611D55, 0xCA611D55, "GD" ],  // 202.97.29.85-202.97.29.85, GD
        [ 0xCA611D56, 0xCA611D58, "JS" ],  // 202.97.29.86-202.97.29.88, JS
        [ 0xCA611D59, 0xCA611D59, "GD" ],  // 202.97.29.89-202.97.29.89, GD
        [ 0xCA611D5A, 0xCA611D5C, "JS" ],  // 202.97.29.90-202.97.29.92, JS
        [ 0xCA611D5D, 0xCA611D5D, "SC" ],  // 202.97.29.93-202.97.29.93, SC
        [ 0xCA611D5E, 0xCA611D60, "JS" ],  // 202.97.29.94-202.97.29.96, JS
        [ 0xCA611D61, 0xCA611D61, "HB" ],  // 202.97.29.97-202.97.29.97, HB
        [ 0xCA611D62, 0xCA611D63, "JS" ],  // 202.97.29.98-202.97.29.99, JS
        [ 0xCA611D64, 0xCA611D65, "HB" ],  // 202.97.29.100-202.97.29.101, HB
        [ 0xCA611D66, 0xCA611D67, "JS" ],  // 202.97.29.102-202.97.29.103, JS
        [ 0xCA611D68, 0xCA611D69, "SH" ],  // 202.97.29.104-202.97.29.105, SH
        [ 0xCA611D6A, 0xCA611D6A, "JS" ],  // 202.97.29.106-202.97.29.106, JS
        [ 0xCA611D6B, 0xCA611D6D, "SH" ],  // 202.97.29.107-202.97.29.109, SH
        [ 0xCA611D6E, 0xCA611D6E, "JS" ],  // 202.97.29.110-202.97.29.110, JS
        [ 0xCA611D6F, 0xCA611D71, "SH" ],  // 202.97.29.111-202.97.29.113, SH
        [ 0xCA611D72, 0xCA611D72, "JS" ],  // 202.97.29.114-202.97.29.114, JS
        [ 0xCA611D73, 0xCA611D79, "SH" ],  // 202.97.29.115-202.97.29.121, SH
        [ 0xCA611D7A, 0xCA611D7A, "JS" ],  // 202.97.29.122-202.97.29.122, JS
        [ 0xCA611D7B, 0xCA611D7D, "SH" ],  // 202.97.29.123-202.97.29.125, SH
        [ 0xCA611D7E, 0xCA611D7E, "JS" ],  // 202.97.29.126-202.97.29.126, JS
        [ 0xCA611D7F, 0xCA611D81, "SH" ],  // 202.97.29.127-202.97.29.129, SH
        [ 0xCA611D82, 0xCA611D84, "YN" ],  // 202.97.29.130-202.97.29.132, YN
        [ 0xCA611D85, 0xCA611D89, "SH" ],  // 202.97.29.133-202.97.29.137, SH
        [ 0xCA611D8A, 0xCA611D8A, "GD" ],  // 202.97.29.138-202.97.29.138, GD
        [ 0xCA611D8B, 0xCA611D91, "SH" ],  // 202.97.29.139-202.97.29.145, SH
        [ 0xCA611D92, 0xCA611D92, "GD" ],  // 202.97.29.146-202.97.29.146, GD
        [ 0xCA611D93, 0xCA611D95, "SH" ],  // 202.97.29.147-202.97.29.149, SH
        [ 0xCA611D96, 0xCA611D96, "GD" ],  // 202.97.29.150-202.97.29.150, GD
        [ 0xCA611D97, 0xCA611D99, "SH" ],  // 202.97.29.151-202.97.29.153, SH
        [ 0xCA611D9A, 0xCA611D9A, "HB" ],  // 202.97.29.154-202.97.29.154, HB
        [ 0xCA611D9B, 0xCA611D9D, "SH" ],  // 202.97.29.155-202.97.29.157, SH
        [ 0xCA611D9E, 0xCA611D9E, "HB" ],  // 202.97.29.158-202.97.29.158, HB
        [ 0xCA611D9F, 0xCA611DA1, "SH" ],  // 202.97.29.159-202.97.29.161, SH
        [ 0xCA611DA2, 0xCA611DA2, "SC" ],  // 202.97.29.162-202.97.29.162, SC
        [ 0xCA611DA3, 0xCA611DA4, "HB" ],  // 202.97.29.163-202.97.29.164, HB
        [ 0xCA611DA5, 0xCA611DA5, "SH" ],  // 202.97.29.165-202.97.29.165, SH
        [ 0xCA611DA6, 0xCA611DA7, "HB" ],  // 202.97.29.166-202.97.29.167, HB
        [ 0xCA611DA8, 0xCA611DA9, "SH" ],  // 202.97.29.168-202.97.29.169, SH
        [ 0xCA611DAA, 0xCA611DAF, "SC" ],  // 202.97.29.170-202.97.29.175, SC
        [ 0xCA611DB0, 0xCA611DB1, "SH" ],  // 202.97.29.176-202.97.29.177, SH
        [ 0xCA611DB2, 0xCA611DB7, "SC" ],  // 202.97.29.178-202.97.29.183, SC
        [ 0xCA611DB8, 0xCA611DB9, "GD" ],  // 202.97.29.184-202.97.29.185, GD
        [ 0xCA611DBA, 0xCA611DEF, "SC" ],  // 202.97.29.186-202.97.29.239, SC
        [ 0xCA611DF0, 0xCA611DF1, "JS" ],  // 202.97.29.240-202.97.29.241, JS
        [ 0xCA611DF2, 0xCA611DF2, "SC" ],  // 202.97.29.242-202.97.29.242, SC
        [ 0xCA611DF3, 0xCA611DF5, "JS" ],  // 202.97.29.243-202.97.29.245, JS
        [ 0xCA611DF6, 0xCA611DF6, "SC" ],  // 202.97.29.246-202.97.29.246, SC
        [ 0xCA611DF7, 0xCA611DF9, "JS" ],  // 202.97.29.247-202.97.29.249, JS
        [ 0xCA611DFA, 0xCA611DFA, "SC" ],  // 202.97.29.250-202.97.29.250, SC
        [ 0xCA611DFB, 0xCA611DFD, "JS" ],  // 202.97.29.251-202.97.29.253, JS
        [ 0xCA611DFE, 0xCA611DFE, "SC" ],  // 202.97.29.254-202.97.29.254, SC
        [ 0xCA611DFF, 0xCA611E0F, "JS" ],  // 202.97.29.255-202.97.30.15, JS
        [ 0xCA611E10, 0xCA611E21, "SC" ],  // 202.97.30.16-202.97.30.33, SC
        [ 0xCA611E22, 0xCA611E32, "HA" ],  // 202.97.30.34-202.97.30.50, HA
        [ 0xCA611E33, 0xCA611E42, "BJ" ],  // 202.97.30.51-202.97.30.66, BJ
        [ 0xCA611E43, 0xCA611E7E, "ZJ" ],  // 202.97.30.67-202.97.30.126, ZJ
        [ 0xCA611E7F, 0xCA611E89, "BJ" ],  // 202.97.30.127-202.97.30.137, BJ
        [ 0xCA611E8A, 0xCA611EAD, "GD" ],  // 202.97.30.138-202.97.30.173, GD
        [ 0xCA611EAE, 0xCA611EAF, "GX" ],  // 202.97.30.174-202.97.30.175, GX
        [ 0xCA611EB0, 0xCA611EB2, "TJ" ],  // 202.97.30.176-202.97.30.178, TJ
        [ 0xCA611EB3, 0xCA611ED9, "BJ" ],  // 202.97.30.179-202.97.30.217, BJ
        [ 0xCA611EDA, 0xCA611EDF, "LN" ],  // 202.97.30.218-202.97.30.223, LN
        [ 0xCA611EE0, 0xCA611EF1, "BJ" ],  // 202.97.30.224-202.97.30.241, BJ
        [ 0xCA611EF2, 0xCA611EF3, "GD" ],  // 202.97.30.242-202.97.30.243, GD
        [ 0xCA611EF4, 0xCA611EF5, "SH" ],  // 202.97.30.244-202.97.30.245, SH
        [ 0xCA611EF6, 0xCA611EFB, "BJ" ],  // 202.97.30.246-202.97.30.251, BJ
        [ 0xCA611EFC, 0xCA611EFD, "GD" ],  // 202.97.30.252-202.97.30.253, GD
        [ 0xCA611EFE, 0xCA611EFF, "BJ" ],  // 202.97.30.254-202.97.30.255, BJ
        [ 0xCA611F00, 0xCA611F01, "SH" ],  // 202.97.31.0-202.97.31.1, SH
        [ 0xCA611F02, 0xCA611F03, "GD" ],  // 202.97.31.2-202.97.31.3, GD
        [ 0xCA611F04, 0xCA611F05, "BJ" ],  // 202.97.31.4-202.97.31.5, BJ
        [ 0xCA611F06, 0xCA611F07, "SN" ],  // 202.97.31.6-202.97.31.7, SN
        [ 0xCA611F08, 0xCA611F23, "BJ" ],  // 202.97.31.8-202.97.31.35, BJ
        [ 0xCA611F24, 0xCA611F27, "HB" ],  // 202.97.31.36-202.97.31.39, HB
        [ 0xCA611F28, 0xCA611F2B, "GD" ],  // 202.97.31.40-202.97.31.43, GD
        [ 0xCA611F2C, 0xCA611F3F, "BJ" ],  // 202.97.31.44-202.97.31.63, BJ
        [ 0xCA611F40, 0xCA611F43, "SC" ],  // 202.97.31.64-202.97.31.67, SC
        [ 0xCA611F44, 0xCA611F45, "GD" ],  // 202.97.31.68-202.97.31.69, GD
        [ 0xCA611F46, 0xCA611FFF, "BJ" ],  // 202.97.31.70-202.97.31.255, BJ
        [ 0xCA612000, 0xCA612167, "SH" ],  // 202.97.32.0-202.97.33.103, SH
        [ 0xCA612168, 0xCA61216B, "GD" ],  // 202.97.33.104-202.97.33.107, GD
        [ 0xCA61216C, 0xCA612173, "SH" ],  // 202.97.33.108-202.97.33.115, SH
        [ 0xCA612174, 0xCA612177, "GD" ],  // 202.97.33.116-202.97.33.119, GD
        [ 0xCA612178, 0xCA612193, "SH" ],  // 202.97.33.120-202.97.33.147, SH
        [ 0xCA612194, 0xCA612197, "JS" ],  // 202.97.33.148-202.97.33.151, JS
        [ 0xCA612198, 0xCA6121A3, "SH" ],  // 202.97.33.152-202.97.33.163, SH
        [ 0xCA6121A4, 0xCA6121AB, "GD" ],  // 202.97.33.164-202.97.33.171, GD
        [ 0xCA6121AC, 0xCA6121AF, "SH" ],  // 202.97.33.172-202.97.33.175, SH
        [ 0xCA6121B0, 0xCA6121B7, "JS" ],  // 202.97.33.176-202.97.33.183, JS
        [ 0xCA6121B8, 0xCA6121BB, "GD" ],  // 202.97.33.184-202.97.33.187, GD
        [ 0xCA6121BC, 0xCA6121BF, "SH" ],  // 202.97.33.188-202.97.33.191, SH
        [ 0xCA6121C0, 0xCA6121F3, "GD" ],  // 202.97.33.192-202.97.33.243, GD
        [ 0xCA6121F4, 0xCA6121FF, "SX" ],  // 202.97.33.244-202.97.33.255, SX
        [ 0xCA612200, 0xCA6122FF, "GD" ],  // 202.97.34.0-202.97.34.255, GD
        [ 0xCA612300, 0xCA612301, "SH" ],  // 202.97.35.0-202.97.35.1, SH
        [ 0xCA612302, 0xCA612303, "GD" ],  // 202.97.35.2-202.97.35.3, GD
        [ 0xCA612304, 0xCA612327, "SH" ],  // 202.97.35.4-202.97.35.39, SH
        [ 0xCA612328, 0xCA61232B, "SC" ],  // 202.97.35.40-202.97.35.43, SC
        [ 0xCA61232C, 0xCA61232C, "GD" ],  // 202.97.35.44-202.97.35.44, GD
        [ 0xCA61232D, 0xCA61232D, "SH" ],  // 202.97.35.45-202.97.35.45, SH
        [ 0xCA61232E, 0xCA612330, "GD" ],  // 202.97.35.46-202.97.35.48, GD
        [ 0xCA612331, 0xCA612331, "SH" ],  // 202.97.35.49-202.97.35.49, SH
        [ 0xCA612332, 0xCA612334, "GD" ],  // 202.97.35.50-202.97.35.52, GD
        [ 0xCA612335, 0xCA612335, "SH" ],  // 202.97.35.53-202.97.35.53, SH
        [ 0xCA612336, 0xCA61233C, "GD" ],  // 202.97.35.54-202.97.35.60, GD
        [ 0xCA61233D, 0xCA61233D, "SH" ],  // 202.97.35.61-202.97.35.61, SH
        [ 0xCA61233E, 0xCA612340, "GD" ],  // 202.97.35.62-202.97.35.64, GD
        [ 0xCA612341, 0xCA612341, "SH" ],  // 202.97.35.65-202.97.35.65, SH
        [ 0xCA612342, 0xCA612344, "GD" ],  // 202.97.35.66-202.97.35.68, GD
        [ 0xCA612345, 0xCA612345, "SH" ],  // 202.97.35.69-202.97.35.69, SH
        [ 0xCA612346, 0xCA612346, "HB" ],  // 202.97.35.70-202.97.35.70, HB
        [ 0xCA612347, 0xCA61234B, "GD" ],  // 202.97.35.71-202.97.35.75, GD
        [ 0xCA61234C, 0xCA61236F, "SH" ],  // 202.97.35.76-202.97.35.111, SH
        [ 0xCA612370, 0xCA612380, "GD" ],  // 202.97.35.112-202.97.35.128, GD
        [ 0xCA612381, 0xCA612381, "SH" ],  // 202.97.35.129-202.97.35.129, SH
        [ 0xCA612382, 0xCA61238F, "GD" ],  // 202.97.35.130-202.97.35.143, GD
        [ 0xCA612390, 0xCA612393, "SH" ],  // 202.97.35.144-202.97.35.147, SH
        [ 0xCA612394, 0xCA612394, "GD" ],  // 202.97.35.148-202.97.35.148, GD
        [ 0xCA612395, 0xCA612395, "JS" ],  // 202.97.35.149-202.97.35.149, JS
        [ 0xCA612396, 0xCA612399, "GD" ],  // 202.97.35.150-202.97.35.153, GD
        [ 0xCA61239A, 0xCA6123A3, "HL" ],  // 202.97.35.154-202.97.35.163, HL
        [ 0xCA6123A4, 0xCA6123A5, "HB" ],  // 202.97.35.164-202.97.35.165, HB
        [ 0xCA6123A6, 0xCA6123AD, "GD" ],  // 202.97.35.166-202.97.35.173, GD
        [ 0xCA6123AE, 0xCA6123AE, "HB" ],  // 202.97.35.174-202.97.35.174, HB
        [ 0xCA6123AF, 0xCA6123AF, "BJ" ],  // 202.97.35.175-202.97.35.175, BJ
        [ 0xCA6123B0, 0xCA6123FF, "GD" ],  // 202.97.35.176-202.97.35.255, GD
        [ 0xCA612400, 0xCA612454, "ZJ" ],  // 202.97.36.0-202.97.36.84, ZJ
        [ 0xCA612455, 0xCA612455, "GD" ],  // 202.97.36.85-202.97.36.85, GD
        [ 0xCA612456, 0xCA612458, "ZJ" ],  // 202.97.36.86-202.97.36.88, ZJ
        [ 0xCA612459, 0xCA61245F, "GD" ],  // 202.97.36.89-202.97.36.95, GD
        [ 0xCA612460, 0xCA612460, "SD" ],  // 202.97.36.96-202.97.36.96, SD
        [ 0xCA612461, 0xCA612462, "GD" ],  // 202.97.36.97-202.97.36.98, GD
        [ 0xCA612463, 0xCA612467, "SD" ],  // 202.97.36.99-202.97.36.103, SD
        [ 0xCA612468, 0xCA612469, "HB" ],  // 202.97.36.104-202.97.36.105, HB
        [ 0xCA61246A, 0xCA61246A, "SN" ],  // 202.97.36.106-202.97.36.106, SN
        [ 0xCA61246B, 0xCA61246D, "YN" ],  // 202.97.36.107-202.97.36.109, YN
        [ 0xCA61246E, 0xCA61246F, "SN" ],  // 202.97.36.110-202.97.36.111, SN
        [ 0xCA612470, 0xCA612477, "BJ" ],  // 202.97.36.112-202.97.36.119, BJ
        [ 0xCA612478, 0xCA61247D, "SC" ],  // 202.97.36.120-202.97.36.125, SC
        [ 0xCA61247E, 0xCA61247F, "ZJ" ],  // 202.97.36.126-202.97.36.127, ZJ
        [ 0xCA612480, 0xCA612487, "SC" ],  // 202.97.36.128-202.97.36.135, SC
        [ 0xCA612488, 0xCA612489, "SH" ],  // 202.97.36.136-202.97.36.137, SH
        [ 0xCA61248A, 0xCA61248A, "SC" ],  // 202.97.36.138-202.97.36.138, SC
        [ 0xCA61248B, 0xCA61248F, "HL" ],  // 202.97.36.139-202.97.36.143, HL
        [ 0xCA612490, 0xCA612494, "SN" ],  // 202.97.36.144-202.97.36.148, SN
        [ 0xCA612495, 0xCA612495, "JS" ],  // 202.97.36.149-202.97.36.149, JS
        [ 0xCA612496, 0xCA612499, "HB" ],  // 202.97.36.150-202.97.36.153, HB
        [ 0xCA61249A, 0xCA61249A, "BJ" ],  // 202.97.36.154-202.97.36.154, BJ
        [ 0xCA61249B, 0xCA61249D, "HB" ],  // 202.97.36.155-202.97.36.157, HB
        [ 0xCA61249E, 0xCA61249E, "BJ" ],  // 202.97.36.158-202.97.36.158, BJ
        [ 0xCA61249F, 0xCA6124A0, "HB" ],  // 202.97.36.159-202.97.36.160, HB
        [ 0xCA6124A1, 0xCA6124A2, "SN" ],  // 202.97.36.161-202.97.36.162, SN
        [ 0xCA6124A3, 0xCA6124A5, "ZJ" ],  // 202.97.36.163-202.97.36.165, ZJ
        [ 0xCA6124A6, 0xCA6124A6, "HB" ],  // 202.97.36.166-202.97.36.166, HB
        [ 0xCA6124A7, 0xCA6124A9, "ZJ" ],  // 202.97.36.167-202.97.36.169, ZJ
        [ 0xCA6124AA, 0xCA6124AA, "HB" ],  // 202.97.36.170-202.97.36.170, HB
        [ 0xCA6124AB, 0xCA6124AC, "ZJ" ],  // 202.97.36.171-202.97.36.172, ZJ
        [ 0xCA6124AD, 0xCA6124AD, "SN" ],  // 202.97.36.173-202.97.36.173, SN
        [ 0xCA6124AE, 0xCA6124AE, "HB" ],  // 202.97.36.174-202.97.36.174, HB
        [ 0xCA6124AF, 0xCA6124B0, "ZJ" ],  // 202.97.36.175-202.97.36.176, ZJ
        [ 0xCA6124B1, 0xCA6124B1, "HB" ],  // 202.97.36.177-202.97.36.177, HB
        [ 0xCA6124B2, 0xCA6124B2, "SC" ],  // 202.97.36.178-202.97.36.178, SC
        [ 0xCA6124B3, 0xCA6124B4, "ZJ" ],  // 202.97.36.179-202.97.36.180, ZJ
        [ 0xCA6124B5, 0xCA6124B5, "HB" ],  // 202.97.36.181-202.97.36.181, HB
        [ 0xCA6124B6, 0xCA6124B6, "SC" ],  // 202.97.36.182-202.97.36.182, SC
        [ 0xCA6124B7, 0xCA6124B8, "ZJ" ],  // 202.97.36.183-202.97.36.184, ZJ
        [ 0xCA6124B9, 0xCA6124B9, "SN" ],  // 202.97.36.185-202.97.36.185, SN
        [ 0xCA6124BA, 0xCA6124BA, "HB" ],  // 202.97.36.186-202.97.36.186, HB
        [ 0xCA6124BB, 0xCA6124BC, "ZJ" ],  // 202.97.36.187-202.97.36.188, ZJ
        [ 0xCA6124BD, 0xCA6124BD, "SC" ],  // 202.97.36.189-202.97.36.189, SC
        [ 0xCA6124BE, 0xCA6124BE, "JS" ],  // 202.97.36.190-202.97.36.190, JS
        [ 0xCA6124BF, 0xCA6124C0, "ZJ" ],  // 202.97.36.191-202.97.36.192, ZJ
        [ 0xCA6124C1, 0xCA6124C1, "AH" ],  // 202.97.36.193-202.97.36.193, AH
        [ 0xCA6124C2, 0xCA6124C5, "SC" ],  // 202.97.36.194-202.97.36.197, SC
        [ 0xCA6124C6, 0xCA6124C6, "TJ" ],  // 202.97.36.198-202.97.36.198, TJ
        [ 0xCA6124C7, 0xCA6124C7, "SC" ],  // 202.97.36.199-202.97.36.199, SC
        [ 0xCA6124C8, 0xCA6124C8, "ZJ" ],  // 202.97.36.200-202.97.36.200, ZJ
        [ 0xCA6124C9, 0xCA6124C9, "HB" ],  // 202.97.36.201-202.97.36.201, HB
        [ 0xCA6124CA, 0xCA6124CC, "ZJ" ],  // 202.97.36.202-202.97.36.204, ZJ
        [ 0xCA6124CD, 0xCA6124CD, "HB" ],  // 202.97.36.205-202.97.36.205, HB
        [ 0xCA6124CE, 0xCA6124D0, "ZJ" ],  // 202.97.36.206-202.97.36.208, ZJ
        [ 0xCA6124D1, 0xCA6124D1, "SH" ],  // 202.97.36.209-202.97.36.209, SH
        [ 0xCA6124D2, 0xCA6124D2, "SC" ],  // 202.97.36.210-202.97.36.210, SC
        [ 0xCA6124D3, 0xCA6124D4, "ZJ" ],  // 202.97.36.211-202.97.36.212, ZJ
        [ 0xCA6124D5, 0xCA6124D5, "SC" ],  // 202.97.36.213-202.97.36.213, SC
        [ 0xCA6124D6, 0xCA6124D6, "BJ" ],  // 202.97.36.214-202.97.36.214, BJ
        [ 0xCA6124D7, 0xCA6124D8, "ZJ" ],  // 202.97.36.215-202.97.36.216, ZJ
        [ 0xCA6124D9, 0xCA6124D9, "SC" ],  // 202.97.36.217-202.97.36.217, SC
        [ 0xCA6124DA, 0xCA6124DA, "BJ" ],  // 202.97.36.218-202.97.36.218, BJ
        [ 0xCA6124DB, 0xCA6124DC, "ZJ" ],  // 202.97.36.219-202.97.36.220, ZJ
        [ 0xCA6124DD, 0xCA6124DD, "GD" ],  // 202.97.36.221-202.97.36.221, GD
        [ 0xCA6124DE, 0xCA6124DE, "SC" ],  // 202.97.36.222-202.97.36.222, SC
        [ 0xCA6124DF, 0xCA6124E1, "GD" ],  // 202.97.36.223-202.97.36.225, GD
        [ 0xCA6124E2, 0xCA6124E6, "SC" ],  // 202.97.36.226-202.97.36.230, SC
        [ 0xCA6124E7, 0xCA6124E8, "ZJ" ],  // 202.97.36.231-202.97.36.232, ZJ
        [ 0xCA6124E9, 0xCA6124E9, "HB" ],  // 202.97.36.233-202.97.36.233, HB
        [ 0xCA6124EA, 0xCA6124EA, "SC" ],  // 202.97.36.234-202.97.36.234, SC
        [ 0xCA6124EB, 0xCA6124EC, "ZJ" ],  // 202.97.36.235-202.97.36.236, ZJ
        [ 0xCA6124ED, 0xCA6124F4, "SC" ],  // 202.97.36.237-202.97.36.244, SC
        [ 0xCA6124F5, 0xCA6124F6, "ZJ" ],  // 202.97.36.245-202.97.36.246, ZJ
        [ 0xCA6124F7, 0xCA6124F9, "SC" ],  // 202.97.36.247-202.97.36.249, SC
        [ 0xCA6124FA, 0xCA6124FD, "JS" ],  // 202.97.36.250-202.97.36.253, JS
        [ 0xCA6124FE, 0xCA6124FF, "SH" ],  // 202.97.36.254-202.97.36.255, SH
        [ 0xCA612500, 0xCA6125FF, "ZJ" ],  // 202.97.37.0-202.97.37.255, ZJ
        [ 0xCA612600, 0xCA612600, "GD" ],  // 202.97.38.0-202.97.38.0, GD
        [ 0xCA612601, 0xCA612601, "HL" ],  // 202.97.38.1-202.97.38.1, HL
        [ 0xCA612602, 0xCA612602, "JL" ],  // 202.97.38.2-202.97.38.2, JL
        [ 0xCA612603, 0xCA612605, "HL" ],  // 202.97.38.3-202.97.38.5, HL
        [ 0xCA612606, 0xCA612606, "JL" ],  // 202.97.38.6-202.97.38.6, JL
        [ 0xCA612607, 0xCA612609, "HL" ],  // 202.97.38.7-202.97.38.9, HL
        [ 0xCA61260A, 0xCA612613, "JL" ],  // 202.97.38.10-202.97.38.19, JL
        [ 0xCA612614, 0xCA612614, "SX" ],  // 202.97.38.20-202.97.38.20, SX
        [ 0xCA612615, 0xCA612615, "GD" ],  // 202.97.38.21-202.97.38.21, GD
        [ 0xCA612616, 0xCA612617, "SX" ],  // 202.97.38.22-202.97.38.23, SX
        [ 0xCA612618, 0xCA61261A, "HL" ],  // 202.97.38.24-202.97.38.26, HL
        [ 0xCA61261B, 0xCA61261D, "JL" ],  // 202.97.38.27-202.97.38.29, JL
        [ 0xCA61261E, 0xCA61261E, "AH" ],  // 202.97.38.30-202.97.38.30, AH
        [ 0xCA61261F, 0xCA612621, "JL" ],  // 202.97.38.31-202.97.38.33, JL
        [ 0xCA612622, 0xCA612622, "AH" ],  // 202.97.38.34-202.97.38.34, AH
        [ 0xCA612623, 0xCA612626, "JL" ],  // 202.97.38.35-202.97.38.38, JL
        [ 0xCA612627, 0xCA61263A, "HL" ],  // 202.97.38.39-202.97.38.58, HL
        [ 0xCA61263B, 0xCA61263B, "JL" ],  // 202.97.38.59-202.97.38.59, JL
        [ 0xCA61263C, 0xCA61263D, "HL" ],  // 202.97.38.60-202.97.38.61, HL
        [ 0xCA61263E, 0xCA61263E, "SX" ],  // 202.97.38.62-202.97.38.62, SX
        [ 0xCA61263F, 0xCA612640, "HL" ],  // 202.97.38.63-202.97.38.64, HL
        [ 0xCA612641, 0xCA612641, "SN" ],  // 202.97.38.65-202.97.38.65, SN
        [ 0xCA612642, 0xCA612642, "SX" ],  // 202.97.38.66-202.97.38.66, SX
        [ 0xCA612643, 0xCA61264A, "HL" ],  // 202.97.38.67-202.97.38.74, HL
        [ 0xCA61264B, 0xCA61264E, "JL" ],  // 202.97.38.75-202.97.38.78, JL
        [ 0xCA61264F, 0xCA612650, "HL" ],  // 202.97.38.79-202.97.38.80, HL
        [ 0xCA612651, 0xCA612651, "JS" ],  // 202.97.38.81-202.97.38.81, JS
        [ 0xCA612652, 0xCA612654, "HL" ],  // 202.97.38.82-202.97.38.84, HL
        [ 0xCA612655, 0xCA612655, "BJ" ],  // 202.97.38.85-202.97.38.85, BJ
        [ 0xCA612656, 0xCA612656, "XJ" ],  // 202.97.38.86-202.97.38.86, XJ
        [ 0xCA612657, 0xCA61265A, "HL" ],  // 202.97.38.87-202.97.38.90, HL
        [ 0xCA61265B, 0xCA61265C, "JL" ],  // 202.97.38.91-202.97.38.92, JL
        [ 0xCA61265D, 0xCA61266D, "HL" ],  // 202.97.38.93-202.97.38.109, HL
        [ 0xCA61266E, 0xCA61266E, "XJ" ],  // 202.97.38.110-202.97.38.110, XJ
        [ 0xCA61266F, 0xCA612671, "HL" ],  // 202.97.38.111-202.97.38.113, HL
        [ 0xCA612672, 0xCA612672, "XJ" ],  // 202.97.38.114-202.97.38.114, XJ
        [ 0xCA612673, 0xCA61267D, "HL" ],  // 202.97.38.115-202.97.38.125, HL
        [ 0xCA61267E, 0xCA61267E, "XJ" ],  // 202.97.38.126-202.97.38.126, XJ
        [ 0xCA61267F, 0xCA612685, "HL" ],  // 202.97.38.127-202.97.38.133, HL
        [ 0xCA612686, 0xCA612686, "XJ" ],  // 202.97.38.134-202.97.38.134, XJ
        [ 0xCA612687, 0xCA612695, "HL" ],  // 202.97.38.135-202.97.38.149, HL
        [ 0xCA612696, 0xCA612696, "JL" ],  // 202.97.38.150-202.97.38.150, JL
        [ 0xCA612697, 0xCA61269D, "HL" ],  // 202.97.38.151-202.97.38.157, HL
        [ 0xCA61269E, 0xCA61269E, "XJ" ],  // 202.97.38.158-202.97.38.158, XJ
        [ 0xCA61269F, 0xCA6126B0, "HL" ],  // 202.97.38.159-202.97.38.176, HL
        [ 0xCA6126B1, 0xCA6126B1, "SC" ],  // 202.97.38.177-202.97.38.177, SC
        [ 0xCA6126B2, 0xCA6126B4, "HL" ],  // 202.97.38.178-202.97.38.180, HL
        [ 0xCA6126B5, 0xCA6126B5, "GD" ],  // 202.97.38.181-202.97.38.181, GD
        [ 0xCA6126B6, 0xCA6126D1, "HL" ],  // 202.97.38.182-202.97.38.209, HL
        [ 0xCA6126D2, 0xCA6126D2, "AH" ],  // 202.97.38.210-202.97.38.210, AH
        [ 0xCA6126D3, 0xCA6126D5, "HL" ],  // 202.97.38.211-202.97.38.213, HL
        [ 0xCA6126D6, 0xCA6126D6, "AH" ],  // 202.97.38.214-202.97.38.214, AH
        [ 0xCA6126D7, 0xCA6126D8, "HL" ],  // 202.97.38.215-202.97.38.216, HL
        [ 0xCA6126D9, 0xCA6126D9, "GD" ],  // 202.97.38.217-202.97.38.217, GD
        [ 0xCA6126DA, 0xCA6126DA, "HN" ],  // 202.97.38.218-202.97.38.218, HN
        [ 0xCA6126DB, 0xCA6126DD, "HL" ],  // 202.97.38.219-202.97.38.221, HL
        [ 0xCA6126DE, 0xCA6126DE, "LN" ],  // 202.97.38.222-202.97.38.222, LN
        [ 0xCA6126DF, 0xCA6126FF, "HL" ],  // 202.97.38.223-202.97.38.255, HL
        [ 0xCA612700, 0xCA612701, "SH" ],  // 202.97.39.0-202.97.39.1, SH
        [ 0xCA612702, 0xCA612702, "SD" ],  // 202.97.39.2-202.97.39.2, SD
        [ 0xCA612703, 0xCA612705, "SH" ],  // 202.97.39.3-202.97.39.5, SH
        [ 0xCA612706, 0xCA612706, "SD" ],  // 202.97.39.6-202.97.39.6, SD
        [ 0xCA612707, 0xCA612715, "SH" ],  // 202.97.39.7-202.97.39.21, SH
        [ 0xCA612716, 0xCA612716, "SD" ],  // 202.97.39.22-202.97.39.22, SD
        [ 0xCA612717, 0xCA612721, "SH" ],  // 202.97.39.23-202.97.39.33, SH
        [ 0xCA612722, 0xCA612722, "SD" ],  // 202.97.39.34-202.97.39.34, SD
        [ 0xCA612723, 0xCA61272D, "SH" ],  // 202.97.39.35-202.97.39.45, SH
        [ 0xCA61272E, 0xCA61272E, "HA" ],  // 202.97.39.46-202.97.39.46, HA
        [ 0xCA61272F, 0xCA61273F, "SH" ],  // 202.97.39.47-202.97.39.63, SH
        [ 0xCA612740, 0xCA61277F, "JX" ],  // 202.97.39.64-202.97.39.127, JX
        [ 0xCA612780, 0xCA612799, "SH" ],  // 202.97.39.128-202.97.39.153, SH
        [ 0xCA61279A, 0xCA61279A, "AH" ],  // 202.97.39.154-202.97.39.154, AH
        [ 0xCA61279B, 0xCA6127AD, "SH" ],  // 202.97.39.155-202.97.39.173, SH
        [ 0xCA6127AE, 0xCA6127AE, "AH" ],  // 202.97.39.174-202.97.39.174, AH
        [ 0xCA6127AF, 0xCA6127B1, "SH" ],  // 202.97.39.175-202.97.39.177, SH
        [ 0xCA6127B2, 0xCA6127B2, "AH" ],  // 202.97.39.178-202.97.39.178, AH
        [ 0xCA6127B3, 0xCA6127B9, "SH" ],  // 202.97.39.179-202.97.39.185, SH
        [ 0xCA6127BA, 0xCA6127BA, "AH" ],  // 202.97.39.186-202.97.39.186, AH
        [ 0xCA6127BB, 0xCA6127BD, "SH" ],  // 202.97.39.187-202.97.39.189, SH
        [ 0xCA6127BE, 0xCA6127BE, "AH" ],  // 202.97.39.190-202.97.39.190, AH
        [ 0xCA6127BF, 0xCA6127DF, "SH" ],  // 202.97.39.191-202.97.39.223, SH
        [ 0xCA6127E0, 0xCA6127E4, "SC" ],  // 202.97.39.224-202.97.39.228, SC
        [ 0xCA6127E5, 0xCA6127E5, "SH" ],  // 202.97.39.229-202.97.39.229, SH
        [ 0xCA6127E6, 0xCA6127E6, "HL" ],  // 202.97.39.230-202.97.39.230, HL
        [ 0xCA6127E7, 0xCA6127FF, "SC" ],  // 202.97.39.231-202.97.39.255, SC
        [ 0xCA612800, 0xCA612800, "GD" ],  // 202.97.40.0-202.97.40.0, GD
        [ 0xCA612801, 0xCA612801, "SH" ],  // 202.97.40.1-202.97.40.1, SH
        [ 0xCA612802, 0xCA612802, "SD" ],  // 202.97.40.2-202.97.40.2, SD
        [ 0xCA612803, 0xCA612804, "GD" ],  // 202.97.40.3-202.97.40.4, GD
        [ 0xCA612805, 0xCA612805, "SH" ],  // 202.97.40.5-202.97.40.5, SH
        [ 0xCA612806, 0xCA612806, "SD" ],  // 202.97.40.6-202.97.40.6, SD
        [ 0xCA612807, 0xCA612808, "GD" ],  // 202.97.40.7-202.97.40.8, GD
        [ 0xCA612809, 0xCA612809, "SH" ],  // 202.97.40.9-202.97.40.9, SH
        [ 0xCA61280A, 0xCA61280A, "SD" ],  // 202.97.40.10-202.97.40.10, SD
        [ 0xCA61280B, 0xCA61280C, "GD" ],  // 202.97.40.11-202.97.40.12, GD
        [ 0xCA61280D, 0xCA61280D, "SC" ],  // 202.97.40.13-202.97.40.13, SC
        [ 0xCA61280E, 0xCA61280E, "SD" ],  // 202.97.40.14-202.97.40.14, SD
        [ 0xCA61280F, 0xCA61280F, "GD" ],  // 202.97.40.15-202.97.40.15, GD
        [ 0xCA612810, 0xCA612813, "SN" ],  // 202.97.40.16-202.97.40.19, SN
        [ 0xCA612814, 0xCA612815, "GD" ],  // 202.97.40.20-202.97.40.21, GD
        [ 0xCA612816, 0xCA612816, "GZ" ],  // 202.97.40.22-202.97.40.22, GZ
        [ 0xCA612817, 0xCA612818, "GD" ],  // 202.97.40.23-202.97.40.24, GD
        [ 0xCA612819, 0xCA612819, "SH" ],  // 202.97.40.25-202.97.40.25, SH
        [ 0xCA61281A, 0xCA61281A, "SD" ],  // 202.97.40.26-202.97.40.26, SD
        [ 0xCA61281B, 0xCA61281C, "GD" ],  // 202.97.40.27-202.97.40.28, GD
        [ 0xCA61281D, 0xCA61281D, "SH" ],  // 202.97.40.29-202.97.40.29, SH
        [ 0xCA61281E, 0xCA61281E, "SD" ],  // 202.97.40.30-202.97.40.30, SD
        [ 0xCA61281F, 0xCA612821, "GD" ],  // 202.97.40.31-202.97.40.33, GD
        [ 0xCA612822, 0xCA612822, "YN" ],  // 202.97.40.34-202.97.40.34, YN
        [ 0xCA612823, 0xCA612825, "GD" ],  // 202.97.40.35-202.97.40.37, GD
        [ 0xCA612826, 0xCA612826, "GZ" ],  // 202.97.40.38-202.97.40.38, GZ
        [ 0xCA612827, 0xCA612828, "GD" ],  // 202.97.40.39-202.97.40.40, GD
        [ 0xCA612829, 0xCA612829, "SH" ],  // 202.97.40.41-202.97.40.41, SH
        [ 0xCA61282A, 0xCA61282C, "SD" ],  // 202.97.40.42-202.97.40.44, SD
        [ 0xCA61282D, 0xCA61282D, "GD" ],  // 202.97.40.45-202.97.40.45, GD
        [ 0xCA61282E, 0xCA61282E, "HN" ],  // 202.97.40.46-202.97.40.46, HN
        [ 0xCA61282F, 0xCA612831, "GD" ],  // 202.97.40.47-202.97.40.49, GD
        [ 0xCA612832, 0xCA612832, "HB" ],  // 202.97.40.50-202.97.40.50, HB
        [ 0xCA612833, 0xCA612835, "GD" ],  // 202.97.40.51-202.97.40.53, GD
        [ 0xCA612836, 0xCA612836, "GZ" ],  // 202.97.40.54-202.97.40.54, GZ
        [ 0xCA612837, 0xCA612838, "GD" ],  // 202.97.40.55-202.97.40.56, GD
        [ 0xCA612839, 0xCA612839, "SH" ],  // 202.97.40.57-202.97.40.57, SH
        [ 0xCA61283A, 0xCA61283A, "SD" ],  // 202.97.40.58-202.97.40.58, SD
        [ 0xCA61283B, 0xCA61283D, "GD" ],  // 202.97.40.59-202.97.40.61, GD
        [ 0xCA61283E, 0xCA61283E, "YN" ],  // 202.97.40.62-202.97.40.62, YN
        [ 0xCA61283F, 0xCA612841, "GD" ],  // 202.97.40.63-202.97.40.65, GD
        [ 0xCA612842, 0xCA612842, "GZ" ],  // 202.97.40.66-202.97.40.66, GZ
        [ 0xCA612843, 0xCA612844, "SD" ],  // 202.97.40.67-202.97.40.68, SD
        [ 0xCA612845, 0xCA612845, "SH" ],  // 202.97.40.69-202.97.40.69, SH
        [ 0xCA612846, 0xCA612848, "SD" ],  // 202.97.40.70-202.97.40.72, SD
        [ 0xCA612849, 0xCA612849, "SH" ],  // 202.97.40.73-202.97.40.73, SH
        [ 0xCA61284A, 0xCA61284C, "SD" ],  // 202.97.40.74-202.97.40.76, SD
        [ 0xCA61284D, 0xCA61284D, "SH" ],  // 202.97.40.77-202.97.40.77, SH
        [ 0xCA61284E, 0xCA612850, "SD" ],  // 202.97.40.78-202.97.40.80, SD
        [ 0xCA612851, 0xCA612851, "SH" ],  // 202.97.40.81-202.97.40.81, SH
        [ 0xCA612852, 0xCA612854, "SD" ],  // 202.97.40.82-202.97.40.84, SD
        [ 0xCA612855, 0xCA612855, "SH" ],  // 202.97.40.85-202.97.40.85, SH
        [ 0xCA612856, 0xCA612857, "SD" ],  // 202.97.40.86-202.97.40.87, SD
        [ 0xCA612858, 0xCA612859, "SH" ],  // 202.97.40.88-202.97.40.89, SH
        [ 0xCA61285A, 0xCA61285B, "SD" ],  // 202.97.40.90-202.97.40.91, SD
        [ 0xCA61285C, 0xCA61285C, "JS" ],  // 202.97.40.92-202.97.40.92, JS
        [ 0xCA61285D, 0xCA61285D, "SH" ],  // 202.97.40.93-202.97.40.93, SH
        [ 0xCA61285E, 0xCA61285E, "SD" ],  // 202.97.40.94-202.97.40.94, SD
        [ 0xCA61285F, 0xCA612860, "GD" ],  // 202.97.40.95-202.97.40.96, GD
        [ 0xCA612861, 0xCA612861, "SH" ],  // 202.97.40.97-202.97.40.97, SH
        [ 0xCA612862, 0xCA612862, "SD" ],  // 202.97.40.98-202.97.40.98, SD
        [ 0xCA612863, 0xCA612864, "GD" ],  // 202.97.40.99-202.97.40.100, GD
        [ 0xCA612865, 0xCA612865, "SH" ],  // 202.97.40.101-202.97.40.101, SH
        [ 0xCA612866, 0xCA612866, "SD" ],  // 202.97.40.102-202.97.40.102, SD
        [ 0xCA612867, 0xCA612868, "GD" ],  // 202.97.40.103-202.97.40.104, GD
        [ 0xCA612869, 0xCA612869, "SC" ],  // 202.97.40.105-202.97.40.105, SC
        [ 0xCA61286A, 0xCA61286A, "GZ" ],  // 202.97.40.106-202.97.40.106, GZ
        [ 0xCA61286B, 0xCA61286D, "GD" ],  // 202.97.40.107-202.97.40.109, GD
        [ 0xCA61286E, 0xCA61286E, "GZ" ],  // 202.97.40.110-202.97.40.110, GZ
        [ 0xCA61286F, 0xCA612870, "GD" ],  // 202.97.40.111-202.97.40.112, GD
        [ 0xCA612871, 0xCA612871, "JS" ],  // 202.97.40.113-202.97.40.113, JS
        [ 0xCA612872, 0xCA612874, "GD" ],  // 202.97.40.114-202.97.40.116, GD
        [ 0xCA612875, 0xCA612875, "SC" ],  // 202.97.40.117-202.97.40.117, SC
        [ 0xCA612876, 0xCA61287B, "SD" ],  // 202.97.40.118-202.97.40.123, SD
        [ 0xCA61287C, 0xCA61287D, "SH" ],  // 202.97.40.124-202.97.40.125, SH
        [ 0xCA61287E, 0xCA61287F, "SD" ],  // 202.97.40.126-202.97.40.127, SD
        [ 0xCA612880, 0xCA612881, "SH" ],  // 202.97.40.128-202.97.40.129, SH
        [ 0xCA612882, 0xCA612882, "SD" ],  // 202.97.40.130-202.97.40.130, SD
        [ 0xCA612883, 0xCA612884, "GD" ],  // 202.97.40.131-202.97.40.132, GD
        [ 0xCA612885, 0xCA612885, "SC" ],  // 202.97.40.133-202.97.40.133, SC
        [ 0xCA612886, 0xCA612886, "SD" ],  // 202.97.40.134-202.97.40.134, SD
        [ 0xCA612887, 0xCA612888, "GD" ],  // 202.97.40.135-202.97.40.136, GD
        [ 0xCA612889, 0xCA612889, "SC" ],  // 202.97.40.137-202.97.40.137, SC
        [ 0xCA61288A, 0xCA61288A, "SD" ],  // 202.97.40.138-202.97.40.138, SD
        [ 0xCA61288B, 0xCA61288D, "GD" ],  // 202.97.40.139-202.97.40.141, GD
        [ 0xCA61288E, 0xCA61288E, "SD" ],  // 202.97.40.142-202.97.40.142, SD
        [ 0xCA61288F, 0xCA612890, "GD" ],  // 202.97.40.143-202.97.40.144, GD
        [ 0xCA612891, 0xCA612891, "SH" ],  // 202.97.40.145-202.97.40.145, SH
        [ 0xCA612892, 0xCA612892, "SD" ],  // 202.97.40.146-202.97.40.146, SD
        [ 0xCA612893, 0xCA612895, "GD" ],  // 202.97.40.147-202.97.40.149, GD
        [ 0xCA612896, 0xCA612896, "SD" ],  // 202.97.40.150-202.97.40.150, SD
        [ 0xCA612897, 0xCA612899, "GD" ],  // 202.97.40.151-202.97.40.153, GD
        [ 0xCA61289A, 0xCA61289A, "FJ" ],  // 202.97.40.154-202.97.40.154, FJ
        [ 0xCA61289B, 0xCA61289C, "GD" ],  // 202.97.40.155-202.97.40.156, GD
        [ 0xCA61289D, 0xCA61289D, "SC" ],  // 202.97.40.157-202.97.40.157, SC
        [ 0xCA61289E, 0xCA61289E, "GZ" ],  // 202.97.40.158-202.97.40.158, GZ
        [ 0xCA61289F, 0xCA6128A1, "GD" ],  // 202.97.40.159-202.97.40.161, GD
        [ 0xCA6128A2, 0xCA6128A2, "GZ" ],  // 202.97.40.162-202.97.40.162, GZ
        [ 0xCA6128A3, 0xCA6128A5, "GD" ],  // 202.97.40.163-202.97.40.165, GD
        [ 0xCA6128A6, 0xCA6128A6, "GZ" ],  // 202.97.40.166-202.97.40.166, GZ
        [ 0xCA6128A7, 0xCA6128A9, "GD" ],  // 202.97.40.167-202.97.40.169, GD
        [ 0xCA6128AA, 0xCA6128AA, "GZ" ],  // 202.97.40.170-202.97.40.170, GZ
        [ 0xCA6128AB, 0xCA6128AC, "GD" ],  // 202.97.40.171-202.97.40.172, GD
        [ 0xCA6128AD, 0xCA6128AD, "SH" ],  // 202.97.40.173-202.97.40.173, SH
        [ 0xCA6128AE, 0xCA6128AF, "SD" ],  // 202.97.40.174-202.97.40.175, SD
        [ 0xCA6128B0, 0xCA6128B1, "SH" ],  // 202.97.40.176-202.97.40.177, SH
        [ 0xCA6128B2, 0xCA6128B2, "SD" ],  // 202.97.40.178-202.97.40.178, SD
        [ 0xCA6128B3, 0xCA6128B3, "GD" ],  // 202.97.40.179-202.97.40.179, GD
        [ 0xCA6128B4, 0xCA6128B7, "SN" ],  // 202.97.40.180-202.97.40.183, SN
        [ 0xCA6128B8, 0xCA6128B8, "GD" ],  // 202.97.40.184-202.97.40.184, GD
        [ 0xCA6128B9, 0xCA6128B9, "SH" ],  // 202.97.40.185-202.97.40.185, SH
        [ 0xCA6128BA, 0xCA6128BF, "SD" ],  // 202.97.40.186-202.97.40.191, SD
        [ 0xCA6128C0, 0xCA6128C1, "SH" ],  // 202.97.40.192-202.97.40.193, SH
        [ 0xCA6128C2, 0xCA6128C2, "SD" ],  // 202.97.40.194-202.97.40.194, SD
        [ 0xCA6128C3, 0xCA6128C4, "GD" ],  // 202.97.40.195-202.97.40.196, GD
        [ 0xCA6128C5, 0xCA6128C5, "SH" ],  // 202.97.40.197-202.97.40.197, SH
        [ 0xCA6128C6, 0xCA6128C6, "SD" ],  // 202.97.40.198-202.97.40.198, SD
        [ 0xCA6128C7, 0xCA6128C8, "GD" ],  // 202.97.40.199-202.97.40.200, GD
        [ 0xCA6128C9, 0xCA6128C9, "SH" ],  // 202.97.40.201-202.97.40.201, SH
        [ 0xCA6128CA, 0xCA6128CA, "SD" ],  // 202.97.40.202-202.97.40.202, SD
        [ 0xCA6128CB, 0xCA6128CD, "GD" ],  // 202.97.40.203-202.97.40.205, GD
        [ 0xCA6128CE, 0xCA6128D0, "HE" ],  // 202.97.40.206-202.97.40.208, HE
        [ 0xCA6128D1, 0xCA6128D1, "SH" ],  // 202.97.40.209-202.97.40.209, SH
        [ 0xCA6128D2, 0xCA6128D2, "SD" ],  // 202.97.40.210-202.97.40.210, SD
        [ 0xCA6128D3, 0xCA6128D4, "GD" ],  // 202.97.40.211-202.97.40.212, GD
        [ 0xCA6128D5, 0xCA6128D5, "HE" ],  // 202.97.40.213-202.97.40.213, HE
        [ 0xCA6128D6, 0xCA6128D6, "GZ" ],  // 202.97.40.214-202.97.40.214, GZ
        [ 0xCA6128D7, 0xCA6128D8, "GD" ],  // 202.97.40.215-202.97.40.216, GD
        [ 0xCA6128D9, 0xCA6128D9, "SH" ],  // 202.97.40.217-202.97.40.217, SH
        [ 0xCA6128DA, 0xCA6128DA, "SD" ],  // 202.97.40.218-202.97.40.218, SD
        [ 0xCA6128DB, 0xCA6128DC, "GD" ],  // 202.97.40.219-202.97.40.220, GD
        [ 0xCA6128DD, 0xCA6128DD, "SH" ],  // 202.97.40.221-202.97.40.221, SH
        [ 0xCA6128DE, 0xCA6128DE, "SD" ],  // 202.97.40.222-202.97.40.222, SD
        [ 0xCA6128DF, 0xCA6128E0, "GD" ],  // 202.97.40.223-202.97.40.224, GD
        [ 0xCA6128E1, 0xCA6128E1, "TJ" ],  // 202.97.40.225-202.97.40.225, TJ
        [ 0xCA6128E2, 0xCA6128E2, "SD" ],  // 202.97.40.226-202.97.40.226, SD
        [ 0xCA6128E3, 0xCA6128E4, "GD" ],  // 202.97.40.227-202.97.40.228, GD
        [ 0xCA6128E5, 0xCA6128E5, "TJ" ],  // 202.97.40.229-202.97.40.229, TJ
        [ 0xCA6128E6, 0xCA6128E6, "SD" ],  // 202.97.40.230-202.97.40.230, SD
        [ 0xCA6128E7, 0xCA6128E8, "GD" ],  // 202.97.40.231-202.97.40.232, GD
        [ 0xCA6128E9, 0xCA6128E9, "TJ" ],  // 202.97.40.233-202.97.40.233, TJ
        [ 0xCA6128EA, 0xCA6128EC, "SD" ],  // 202.97.40.234-202.97.40.236, SD
        [ 0xCA6128ED, 0xCA6128ED, "TJ" ],  // 202.97.40.237-202.97.40.237, TJ
        [ 0xCA6128EE, 0xCA6128F0, "SD" ],  // 202.97.40.238-202.97.40.240, SD
        [ 0xCA6128F1, 0xCA6128F1, "SH" ],  // 202.97.40.241-202.97.40.241, SH
        [ 0xCA6128F2, 0xCA6128F8, "SD" ],  // 202.97.40.242-202.97.40.248, SD
        [ 0xCA6128F9, 0xCA6128F9, "SH" ],  // 202.97.40.249-202.97.40.249, SH
        [ 0xCA6128FA, 0xCA6128FC, "SD" ],  // 202.97.40.250-202.97.40.252, SD
        [ 0xCA6128FD, 0xCA6128FD, "SH" ],  // 202.97.40.253-202.97.40.253, SH
        [ 0xCA6128FE, 0xCA6128FF, "SD" ],  // 202.97.40.254-202.97.40.255, SD
        [ 0xCA612900, 0xCA612901, "TJ" ],  // 202.97.41.0-202.97.41.1, TJ
        [ 0xCA612902, 0xCA612902, "HE" ],  // 202.97.41.2-202.97.41.2, HE
        [ 0xCA612903, 0xCA612904, "BJ" ],  // 202.97.41.3-202.97.41.4, BJ
        [ 0xCA612905, 0xCA612905, "TJ" ],  // 202.97.41.5-202.97.41.5, TJ
        [ 0xCA612906, 0xCA612906, "JS" ],  // 202.97.41.6-202.97.41.6, JS
        [ 0xCA612907, 0xCA612909, "TJ" ],  // 202.97.41.7-202.97.41.9, TJ
        [ 0xCA61290A, 0xCA61290D, "NM" ],  // 202.97.41.10-202.97.41.13, NM
        [ 0xCA61290E, 0xCA61290E, "HE" ],  // 202.97.41.14-202.97.41.14, HE
        [ 0xCA61290F, 0xCA612911, "ZJ" ],  // 202.97.41.15-202.97.41.17, ZJ
        [ 0xCA612912, 0xCA612912, "HE" ],  // 202.97.41.18-202.97.41.18, HE
        [ 0xCA612913, 0xCA612914, "ZJ" ],  // 202.97.41.19-202.97.41.20, ZJ
        [ 0xCA612915, 0xCA612915, "SN" ],  // 202.97.41.21-202.97.41.21, SN
        [ 0xCA612916, 0xCA612916, "TJ" ],  // 202.97.41.22-202.97.41.22, TJ
        [ 0xCA612917, 0xCA612917, "ZJ" ],  // 202.97.41.23-202.97.41.23, ZJ
        [ 0xCA612918, 0xCA61291B, "TJ" ],  // 202.97.41.24-202.97.41.27, TJ
        [ 0xCA61291C, 0xCA61291D, "ZJ" ],  // 202.97.41.28-202.97.41.29, ZJ
        [ 0xCA61291E, 0xCA61291E, "NM" ],  // 202.97.41.30-202.97.41.30, NM
        [ 0xCA61291F, 0xCA612921, "ZJ" ],  // 202.97.41.31-202.97.41.33, ZJ
        [ 0xCA612922, 0xCA612922, "NM" ],  // 202.97.41.34-202.97.41.34, NM
        [ 0xCA612923, 0xCA612923, "ZJ" ],  // 202.97.41.35-202.97.41.35, ZJ
        [ 0xCA612924, 0xCA612927, "HE" ],  // 202.97.41.36-202.97.41.39, HE
        [ 0xCA612928, 0xCA612928, "ZJ" ],  // 202.97.41.40-202.97.41.40, ZJ
        [ 0xCA612929, 0xCA612929, "SN" ],  // 202.97.41.41-202.97.41.41, SN
        [ 0xCA61292A, 0xCA612930, "ZJ" ],  // 202.97.41.42-202.97.41.48, ZJ
        [ 0xCA612931, 0xCA612931, "TJ" ],  // 202.97.41.49-202.97.41.49, TJ
        [ 0xCA612932, 0xCA612932, "HE" ],  // 202.97.41.50-202.97.41.50, HE
        [ 0xCA612933, 0xCA612933, "ZJ" ],  // 202.97.41.51-202.97.41.51, ZJ
        [ 0xCA612934, 0xCA612937, "TJ" ],  // 202.97.41.52-202.97.41.55, TJ
        [ 0xCA612938, 0xCA612938, "ZJ" ],  // 202.97.41.56-202.97.41.56, ZJ
        [ 0xCA612939, 0xCA612939, "TJ" ],  // 202.97.41.57-202.97.41.57, TJ
        [ 0xCA61293A, 0xCA61293A, "HE" ],  // 202.97.41.58-202.97.41.58, HE
        [ 0xCA61293B, 0xCA61293B, "ZJ" ],  // 202.97.41.59-202.97.41.59, ZJ
        [ 0xCA61293C, 0xCA61293F, "HE" ],  // 202.97.41.60-202.97.41.63, HE
        [ 0xCA612940, 0xCA612940, "ZJ" ],  // 202.97.41.64-202.97.41.64, ZJ
        [ 0xCA612941, 0xCA612941, "JS" ],  // 202.97.41.65-202.97.41.65, JS
        [ 0xCA612942, 0xCA612945, "ZJ" ],  // 202.97.41.66-202.97.41.69, ZJ
        [ 0xCA612946, 0xCA612946, "FJ" ],  // 202.97.41.70-202.97.41.70, FJ
        [ 0xCA612947, 0xCA612948, "ZJ" ],  // 202.97.41.71-202.97.41.72, ZJ
        [ 0xCA612949, 0xCA612949, "JS" ],  // 202.97.41.73-202.97.41.73, JS
        [ 0xCA61294A, 0xCA61294F, "ZJ" ],  // 202.97.41.74-202.97.41.79, ZJ
        [ 0xCA612950, 0xCA612955, "JS" ],  // 202.97.41.80-202.97.41.85, JS
        [ 0xCA612956, 0xCA612959, "ZJ" ],  // 202.97.41.86-202.97.41.89, ZJ
        [ 0xCA61295A, 0xCA61295A, "AH" ],  // 202.97.41.90-202.97.41.90, AH
        [ 0xCA61295B, 0xCA61295D, "TJ" ],  // 202.97.41.91-202.97.41.93, TJ
        [ 0xCA61295E, 0xCA61295E, "FJ" ],  // 202.97.41.94-202.97.41.94, FJ
        [ 0xCA61295F, 0xCA612963, "ZJ" ],  // 202.97.41.95-202.97.41.99, ZJ
        [ 0xCA612964, 0xCA612965, "BJ" ],  // 202.97.41.100-202.97.41.101, BJ
        [ 0xCA612966, 0xCA612966, "HE" ],  // 202.97.41.102-202.97.41.102, HE
        [ 0xCA612967, 0xCA612968, "ZJ" ],  // 202.97.41.103-202.97.41.104, ZJ
        [ 0xCA612969, 0xCA612969, "SN" ],  // 202.97.41.105-202.97.41.105, SN
        [ 0xCA61296A, 0xCA61296D, "JS" ],  // 202.97.41.106-202.97.41.109, JS
        [ 0xCA61296E, 0xCA61296F, "ZJ" ],  // 202.97.41.110-202.97.41.111, ZJ
        [ 0xCA612970, 0xCA612973, "TJ" ],  // 202.97.41.112-202.97.41.115, TJ
        [ 0xCA612974, 0xCA612974, "ZJ" ],  // 202.97.41.116-202.97.41.116, ZJ
        [ 0xCA612975, 0xCA612975, "NM" ],  // 202.97.41.117-202.97.41.117, NM
        [ 0xCA612976, 0xCA612977, "ZJ" ],  // 202.97.41.118-202.97.41.119, ZJ
        [ 0xCA612978, 0xCA612978, "AH" ],  // 202.97.41.120-202.97.41.120, AH
        [ 0xCA612979, 0xCA612979, "JS" ],  // 202.97.41.121-202.97.41.121, JS
        [ 0xCA61297A, 0xCA61297B, "AH" ],  // 202.97.41.122-202.97.41.123, AH
        [ 0xCA61297C, 0xCA61297C, "ZJ" ],  // 202.97.41.124-202.97.41.124, ZJ
        [ 0xCA61297D, 0xCA61297D, "JS" ],  // 202.97.41.125-202.97.41.125, JS
        [ 0xCA61297E, 0xCA61297E, "JX" ],  // 202.97.41.126-202.97.41.126, JX
        [ 0xCA61297F, 0xCA612980, "ZJ" ],  // 202.97.41.127-202.97.41.128, ZJ
        [ 0xCA612981, 0xCA612981, "GD" ],  // 202.97.41.129-202.97.41.129, GD
        [ 0xCA612982, 0xCA612982, "JX" ],  // 202.97.41.130-202.97.41.130, JX
        [ 0xCA612983, 0xCA612984, "ZJ" ],  // 202.97.41.131-202.97.41.132, ZJ
        [ 0xCA612985, 0xCA612985, "JS" ],  // 202.97.41.133-202.97.41.133, JS
        [ 0xCA612986, 0xCA61298B, "AH" ],  // 202.97.41.134-202.97.41.139, AH
        [ 0xCA61298C, 0xCA61298E, "JX" ],  // 202.97.41.140-202.97.41.142, JX
        [ 0xCA61298F, 0xCA612991, "TJ" ],  // 202.97.41.143-202.97.41.145, TJ
        [ 0xCA612992, 0xCA612992, "FJ" ],  // 202.97.41.146-202.97.41.146, FJ
        [ 0xCA612993, 0xCA612999, "SN" ],  // 202.97.41.147-202.97.41.153, SN
        [ 0xCA61299A, 0xCA61299D, "TJ" ],  // 202.97.41.154-202.97.41.157, TJ
        [ 0xCA61299E, 0xCA61299E, "FJ" ],  // 202.97.41.158-202.97.41.158, FJ
        [ 0xCA61299F, 0xCA61299F, "ZJ" ],  // 202.97.41.159-202.97.41.159, ZJ
        [ 0xCA6129A0, 0xCA6129A7, "SN" ],  // 202.97.41.160-202.97.41.167, SN
        [ 0xCA6129A8, 0xCA6129A9, "BJ" ],  // 202.97.41.168-202.97.41.169, BJ
        [ 0xCA6129AA, 0xCA6129AB, "HE" ],  // 202.97.41.170-202.97.41.171, HE
        [ 0xCA6129AC, 0xCA6129AF, "SN" ],  // 202.97.41.172-202.97.41.175, SN
        [ 0xCA6129B0, 0xCA6129B1, "ZJ" ],  // 202.97.41.176-202.97.41.177, ZJ
        [ 0xCA6129B2, 0xCA6129B2, "NM" ],  // 202.97.41.178-202.97.41.178, NM
        [ 0xCA6129B3, 0xCA6129B4, "ZJ" ],  // 202.97.41.179-202.97.41.180, ZJ
        [ 0xCA6129B5, 0xCA6129B5, "BJ" ],  // 202.97.41.181-202.97.41.181, BJ
        [ 0xCA6129B6, 0xCA6129B6, "SD" ],  // 202.97.41.182-202.97.41.182, SD
        [ 0xCA6129B7, 0xCA6129B9, "ZJ" ],  // 202.97.41.183-202.97.41.185, ZJ
        [ 0xCA6129BA, 0xCA6129BA, "NM" ],  // 202.97.41.186-202.97.41.186, NM
        [ 0xCA6129BB, 0xCA6129BD, "ZJ" ],  // 202.97.41.187-202.97.41.189, ZJ
        [ 0xCA6129BE, 0xCA6129BE, "SD" ],  // 202.97.41.190-202.97.41.190, SD
        [ 0xCA6129BF, 0xCA6129C0, "ZJ" ],  // 202.97.41.191-202.97.41.192, ZJ
        [ 0xCA6129C1, 0xCA6129C1, "JS" ],  // 202.97.41.193-202.97.41.193, JS
        [ 0xCA6129C2, 0xCA6129C2, "JX" ],  // 202.97.41.194-202.97.41.194, JX
        [ 0xCA6129C3, 0xCA6129C4, "ZJ" ],  // 202.97.41.195-202.97.41.196, ZJ
        [ 0xCA6129C5, 0xCA6129C5, "JS" ],  // 202.97.41.197-202.97.41.197, JS
        [ 0xCA6129C6, 0xCA6129C6, "JX" ],  // 202.97.41.198-202.97.41.198, JX
        [ 0xCA6129C7, 0xCA6129C8, "ZJ" ],  // 202.97.41.199-202.97.41.200, ZJ
        [ 0xCA6129C9, 0xCA6129C9, "JS" ],  // 202.97.41.201-202.97.41.201, JS
        [ 0xCA6129CA, 0xCA6129CA, "JX" ],  // 202.97.41.202-202.97.41.202, JX
        [ 0xCA6129CB, 0xCA6129CB, "ZJ" ],  // 202.97.41.203-202.97.41.203, ZJ
        [ 0xCA6129CC, 0xCA6129CF, "JS" ],  // 202.97.41.204-202.97.41.207, JS
        [ 0xCA6129D0, 0xCA6129D0, "ZJ" ],  // 202.97.41.208-202.97.41.208, ZJ
        [ 0xCA6129D1, 0xCA6129D1, "AH" ],  // 202.97.41.209-202.97.41.209, AH
        [ 0xCA6129D2, 0xCA6129D3, "ZJ" ],  // 202.97.41.210-202.97.41.211, ZJ
        [ 0xCA6129D4, 0xCA6129DD, "JS" ],  // 202.97.41.212-202.97.41.221, JS
        [ 0xCA6129DE, 0xCA6129DE, "HE" ],  // 202.97.41.222-202.97.41.222, HE
        [ 0xCA6129DF, 0xCA6129DF, "AH" ],  // 202.97.41.223-202.97.41.223, AH
        [ 0xCA6129E0, 0xCA6129EB, "JS" ],  // 202.97.41.224-202.97.41.235, JS
        [ 0xCA6129EC, 0xCA6129EC, "ZJ" ],  // 202.97.41.236-202.97.41.236, ZJ
        [ 0xCA6129ED, 0xCA6129ED, "JS" ],  // 202.97.41.237-202.97.41.237, JS
        [ 0xCA6129EE, 0xCA6129EE, "JX" ],  // 202.97.41.238-202.97.41.238, JX
        [ 0xCA6129EF, 0xCA6129EF, "ZJ" ],  // 202.97.41.239-202.97.41.239, ZJ
        [ 0xCA6129F0, 0xCA6129F3, "HE" ],  // 202.97.41.240-202.97.41.243, HE
        [ 0xCA6129F4, 0xCA6129F4, "ZJ" ],  // 202.97.41.244-202.97.41.244, ZJ
        [ 0xCA6129F5, 0xCA6129F5, "JS" ],  // 202.97.41.245-202.97.41.245, JS
        [ 0xCA6129F6, 0xCA6129F7, "ZJ" ],  // 202.97.41.246-202.97.41.247, ZJ
        [ 0xCA6129F8, 0xCA6129F9, "JS" ],  // 202.97.41.248-202.97.41.249, JS
        [ 0xCA6129FA, 0xCA6129FF, "ZJ" ],  // 202.97.41.250-202.97.41.255, ZJ
        [ 0xCA612A00, 0xCA612AFF, "NM" ],  // 202.97.42.0-202.97.42.255, NM
        [ 0xCA612B00, 0xCA612B00, "FJ" ],  // 202.97.43.0-202.97.43.0, FJ
        [ 0xCA612B01, 0xCA612B01, "SN" ],  // 202.97.43.1-202.97.43.1, SN
        [ 0xCA612B02, 0xCA612B02, "GS" ],  // 202.97.43.2-202.97.43.2, GS
        [ 0xCA612B03, 0xCA612B05, "FJ" ],  // 202.97.43.3-202.97.43.5, FJ
        [ 0xCA612B06, 0xCA612B06, "GS" ],  // 202.97.43.6-202.97.43.6, GS
        [ 0xCA612B07, 0xCA612B09, "FJ" ],  // 202.97.43.7-202.97.43.9, FJ
        [ 0xCA612B0A, 0xCA612B0A, "SD" ],  // 202.97.43.10-202.97.43.10, SD
        [ 0xCA612B0B, 0xCA612B0D, "FJ" ],  // 202.97.43.11-202.97.43.13, FJ
        [ 0xCA612B0E, 0xCA612B0E, "SD" ],  // 202.97.43.14-202.97.43.14, SD
        [ 0xCA612B0F, 0xCA612B10, "GS" ],  // 202.97.43.15-202.97.43.16, GS
        [ 0xCA612B11, 0xCA612B11, "SH" ],  // 202.97.43.17-202.97.43.17, SH
        [ 0xCA612B12, 0xCA612B12, "AH" ],  // 202.97.43.18-202.97.43.18, AH
        [ 0xCA612B13, 0xCA612B14, "GS" ],  // 202.97.43.19-202.97.43.20, GS
        [ 0xCA612B15, 0xCA612B15, "SH" ],  // 202.97.43.21-202.97.43.21, SH
        [ 0xCA612B16, 0xCA612B16, "AH" ],  // 202.97.43.22-202.97.43.22, AH
        [ 0xCA612B17, 0xCA612B18, "GS" ],  // 202.97.43.23-202.97.43.24, GS
        [ 0xCA612B19, 0xCA612B19, "AH" ],  // 202.97.43.25-202.97.43.25, AH
        [ 0xCA612B1A, 0xCA612B1A, "YN" ],  // 202.97.43.26-202.97.43.26, YN
        [ 0xCA612B1B, 0xCA612B1C, "GS" ],  // 202.97.43.27-202.97.43.28, GS
        [ 0xCA612B1D, 0xCA612B1D, "SN" ],  // 202.97.43.29-202.97.43.29, SN
        [ 0xCA612B1E, 0xCA612B1F, "GS" ],  // 202.97.43.30-202.97.43.31, GS
        [ 0xCA612B20, 0xCA612B21, "AH" ],  // 202.97.43.32-202.97.43.33, AH
        [ 0xCA612B22, 0xCA612B22, "JS" ],  // 202.97.43.34-202.97.43.34, JS
        [ 0xCA612B23, 0xCA612B23, "AH" ],  // 202.97.43.35-202.97.43.35, AH
        [ 0xCA612B24, 0xCA612B24, "NX" ],  // 202.97.43.36-202.97.43.36, NX
        [ 0xCA612B25, 0xCA612B25, "ZJ" ],  // 202.97.43.37-202.97.43.37, ZJ
        [ 0xCA612B26, 0xCA612B26, "HN" ],  // 202.97.43.38-202.97.43.38, HN
        [ 0xCA612B27, 0xCA612B27, "NX" ],  // 202.97.43.39-202.97.43.39, NX
        [ 0xCA612B28, 0xCA612B28, "FJ" ],  // 202.97.43.40-202.97.43.40, FJ
        [ 0xCA612B29, 0xCA612B29, "HB" ],  // 202.97.43.41-202.97.43.41, HB
        [ 0xCA612B2A, 0xCA612B2A, "GD" ],  // 202.97.43.42-202.97.43.42, GD
        [ 0xCA612B2B, 0xCA612B2B, "FJ" ],  // 202.97.43.43-202.97.43.43, FJ
        [ 0xCA612B2C, 0xCA612B2D, "SN" ],  // 202.97.43.44-202.97.43.45, SN
        [ 0xCA612B2E, 0xCA612B2F, "SX" ],  // 202.97.43.46-202.97.43.47, SX
        [ 0xCA612B30, 0xCA612B33, "HB" ],  // 202.97.43.48-202.97.43.51, HB
        [ 0xCA612B34, 0xCA612B3C, "FJ" ],  // 202.97.43.52-202.97.43.60, FJ
        [ 0xCA612B3D, 0xCA612B3D, "SN" ],  // 202.97.43.61-202.97.43.61, SN
        [ 0xCA612B3E, 0xCA612B3E, "GS" ],  // 202.97.43.62-202.97.43.62, GS
        [ 0xCA612B3F, 0xCA612B40, "FJ" ],  // 202.97.43.63-202.97.43.64, FJ
        [ 0xCA612B41, 0xCA612B41, "SN" ],  // 202.97.43.65-202.97.43.65, SN
        [ 0xCA612B42, 0xCA612B42, "GD" ],  // 202.97.43.66-202.97.43.66, GD
        [ 0xCA612B43, 0xCA612B44, "FJ" ],  // 202.97.43.67-202.97.43.68, FJ
        [ 0xCA612B45, 0xCA612B45, "SN" ],  // 202.97.43.69-202.97.43.69, SN
        [ 0xCA612B46, 0xCA612B48, "GS" ],  // 202.97.43.70-202.97.43.72, GS
        [ 0xCA612B49, 0xCA612B49, "SN" ],  // 202.97.43.73-202.97.43.73, SN
        [ 0xCA612B4A, 0xCA612B4A, "XJ" ],  // 202.97.43.74-202.97.43.74, XJ
        [ 0xCA612B4B, 0xCA612B4C, "FJ" ],  // 202.97.43.75-202.97.43.76, FJ
        [ 0xCA612B4D, 0xCA612B4D, "ZJ" ],  // 202.97.43.77-202.97.43.77, ZJ
        [ 0xCA612B4E, 0xCA612B4E, "SH" ],  // 202.97.43.78-202.97.43.78, SH
        [ 0xCA612B4F, 0xCA612B50, "GS" ],  // 202.97.43.79-202.97.43.80, GS
        [ 0xCA612B51, 0xCA612B51, "ZJ" ],  // 202.97.43.81-202.97.43.81, ZJ
        [ 0xCA612B52, 0xCA612B54, "GD" ],  // 202.97.43.82-202.97.43.84, GD
        [ 0xCA612B55, 0xCA612B55, "JS" ],  // 202.97.43.85-202.97.43.85, JS
        [ 0xCA612B56, 0xCA612B56, "HB" ],  // 202.97.43.86-202.97.43.86, HB
        [ 0xCA612B57, 0xCA612B64, "FJ" ],  // 202.97.43.87-202.97.43.100, FJ
        [ 0xCA612B65, 0xCA612B65, "SN" ],  // 202.97.43.101-202.97.43.101, SN
        [ 0xCA612B66, 0xCA612B67, "GS" ],  // 202.97.43.102-202.97.43.103, GS
        [ 0xCA612B68, 0xCA612B68, "SH" ],  // 202.97.43.104-202.97.43.104, SH
        [ 0xCA612B69, 0xCA612B69, "FJ" ],  // 202.97.43.105-202.97.43.105, FJ
        [ 0xCA612B6A, 0xCA612B6A, "SN" ],  // 202.97.43.106-202.97.43.106, SN
        [ 0xCA612B6B, 0xCA612B6B, "SH" ],  // 202.97.43.107-202.97.43.107, SH
        [ 0xCA612B6C, 0xCA612B6C, "FJ" ],  // 202.97.43.108-202.97.43.108, FJ
        [ 0xCA612B6D, 0xCA612B6D, "GD" ],  // 202.97.43.109-202.97.43.109, GD
        [ 0xCA612B6E, 0xCA612B6E, "YN" ],  // 202.97.43.110-202.97.43.110, YN
        [ 0xCA612B6F, 0xCA612B71, "FJ" ],  // 202.97.43.111-202.97.43.113, FJ
        [ 0xCA612B72, 0xCA612B73, "SN" ],  // 202.97.43.114-202.97.43.115, SN
        [ 0xCA612B74, 0xCA612B74, "FJ" ],  // 202.97.43.116-202.97.43.116, FJ
        [ 0xCA612B75, 0xCA612B75, "SN" ],  // 202.97.43.117-202.97.43.117, SN
        [ 0xCA612B76, 0xCA612B76, "XJ" ],  // 202.97.43.118-202.97.43.118, XJ
        [ 0xCA612B77, 0xCA612B78, "FJ" ],  // 202.97.43.119-202.97.43.120, FJ
        [ 0xCA612B79, 0xCA612B79, "SN" ],  // 202.97.43.121-202.97.43.121, SN
        [ 0xCA612B7A, 0xCA612B7A, "GZ" ],  // 202.97.43.122-202.97.43.122, GZ
        [ 0xCA612B7B, 0xCA612B7C, "FJ" ],  // 202.97.43.123-202.97.43.124, FJ
        [ 0xCA612B7D, 0xCA612B7D, "GD" ],  // 202.97.43.125-202.97.43.125, GD
        [ 0xCA612B7E, 0xCA612B7E, "GX" ],  // 202.97.43.126-202.97.43.126, GX
        [ 0xCA612B7F, 0xCA612B80, "FJ" ],  // 202.97.43.127-202.97.43.128, FJ
        [ 0xCA612B81, 0xCA612B81, "AH" ],  // 202.97.43.129-202.97.43.129, AH
        [ 0xCA612B82, 0xCA612B83, "FJ" ],  // 202.97.43.130-202.97.43.131, FJ
        [ 0xCA612B84, 0xCA612B84, "SX" ],  // 202.97.43.132-202.97.43.132, SX
        [ 0xCA612B85, 0xCA612B85, "SN" ],  // 202.97.43.133-202.97.43.133, SN
        [ 0xCA612B86, 0xCA612B87, "SX" ],  // 202.97.43.134-202.97.43.135, SX
        [ 0xCA612B88, 0xCA612B89, "AH" ],  // 202.97.43.136-202.97.43.137, AH
        [ 0xCA612B8A, 0xCA612B8A, "JS" ],  // 202.97.43.138-202.97.43.138, JS
        [ 0xCA612B8B, 0xCA612B8B, "FJ" ],  // 202.97.43.139-202.97.43.139, FJ
        [ 0xCA612B8C, 0xCA612B8C, "GD" ],  // 202.97.43.140-202.97.43.140, GD
        [ 0xCA612B8D, 0xCA612B8D, "HB" ],  // 202.97.43.141-202.97.43.141, HB
        [ 0xCA612B8E, 0xCA612B8E, "ZJ" ],  // 202.97.43.142-202.97.43.142, ZJ
        [ 0xCA612B8F, 0xCA612B90, "GD" ],  // 202.97.43.143-202.97.43.144, GD
        [ 0xCA612B91, 0xCA612B91, "JS" ],  // 202.97.43.145-202.97.43.145, JS
        [ 0xCA612B92, 0xCA612B92, "ZJ" ],  // 202.97.43.146-202.97.43.146, ZJ
        [ 0xCA612B93, 0xCA612B94, "GD" ],  // 202.97.43.147-202.97.43.148, GD
        [ 0xCA612B95, 0xCA612B95, "SN" ],  // 202.97.43.149-202.97.43.149, SN
        [ 0xCA612B96, 0xCA612B96, "SD" ],  // 202.97.43.150-202.97.43.150, SD
        [ 0xCA612B97, 0xCA612B98, "GD" ],  // 202.97.43.151-202.97.43.152, GD
        [ 0xCA612B99, 0xCA612B99, "SN" ],  // 202.97.43.153-202.97.43.153, SN
        [ 0xCA612B9A, 0xCA612B9C, "FJ" ],  // 202.97.43.154-202.97.43.156, FJ
        [ 0xCA612B9D, 0xCA612B9D, "SN" ],  // 202.97.43.157-202.97.43.157, SN
        [ 0xCA612B9E, 0xCA612B9E, "SC" ],  // 202.97.43.158-202.97.43.158, SC
        [ 0xCA612B9F, 0xCA612BA0, "FJ" ],  // 202.97.43.159-202.97.43.160, FJ
        [ 0xCA612BA1, 0xCA612BA1, "JS" ],  // 202.97.43.161-202.97.43.161, JS
        [ 0xCA612BA2, 0xCA612BA4, "YN" ],  // 202.97.43.162-202.97.43.164, YN
        [ 0xCA612BA5, 0xCA612BA5, "SC" ],  // 202.97.43.165-202.97.43.165, SC
        [ 0xCA612BA6, 0xCA612BA8, "YN" ],  // 202.97.43.166-202.97.43.168, YN
        [ 0xCA612BA9, 0xCA612BA9, "JS" ],  // 202.97.43.169-202.97.43.169, JS
        [ 0xCA612BAA, 0xCA612BAA, "JX" ],  // 202.97.43.170-202.97.43.170, JX
        [ 0xCA612BAB, 0xCA612BAC, "GD" ],  // 202.97.43.171-202.97.43.172, GD
        [ 0xCA612BAD, 0xCA612BAD, "SC" ],  // 202.97.43.173-202.97.43.173, SC
        [ 0xCA612BAE, 0xCA612BAE, "JX" ],  // 202.97.43.174-202.97.43.174, JX
        [ 0xCA612BAF, 0xCA612BB0, "GD" ],  // 202.97.43.175-202.97.43.176, GD
        [ 0xCA612BB1, 0xCA612BB1, "ZJ" ],  // 202.97.43.177-202.97.43.177, ZJ
        [ 0xCA612BB2, 0xCA612BB2, "GS" ],  // 202.97.43.178-202.97.43.178, GS
        [ 0xCA612BB3, 0xCA612BB5, "GD" ],  // 202.97.43.179-202.97.43.181, GD
        [ 0xCA612BB6, 0xCA612BB6, "GX" ],  // 202.97.43.182-202.97.43.182, GX
        [ 0xCA612BB7, 0xCA612BB8, "GD" ],  // 202.97.43.183-202.97.43.184, GD
        [ 0xCA612BB9, 0xCA612BB9, "FJ" ],  // 202.97.43.185-202.97.43.185, FJ
        [ 0xCA612BBA, 0xCA612BBA, "SN" ],  // 202.97.43.186-202.97.43.186, SN
        [ 0xCA612BBB, 0xCA612BBC, "GD" ],  // 202.97.43.187-202.97.43.188, GD
        [ 0xCA612BBD, 0xCA612BBD, "FJ" ],  // 202.97.43.189-202.97.43.189, FJ
        [ 0xCA612BBE, 0xCA612BBE, "SN" ],  // 202.97.43.190-202.97.43.190, SN
        [ 0xCA612BBF, 0xCA612BC0, "FJ" ],  // 202.97.43.191-202.97.43.192, FJ
        [ 0xCA612BC1, 0xCA612BC1, "SN" ],  // 202.97.43.193-202.97.43.193, SN
        [ 0xCA612BC2, 0xCA612BC2, "SC" ],  // 202.97.43.194-202.97.43.194, SC
        [ 0xCA612BC3, 0xCA612BC4, "FJ" ],  // 202.97.43.195-202.97.43.196, FJ
        [ 0xCA612BC5, 0xCA612BC5, "JS" ],  // 202.97.43.197-202.97.43.197, JS
        [ 0xCA612BC6, 0xCA612BC6, "JX" ],  // 202.97.43.198-202.97.43.198, JX
        [ 0xCA612BC7, 0xCA612BC7, "GD" ],  // 202.97.43.199-202.97.43.199, GD
        [ 0xCA612BC8, 0xCA612BCE, "HB" ],  // 202.97.43.200-202.97.43.206, HB
        [ 0xCA612BCF, 0xCA612BCF, "FJ" ],  // 202.97.43.207-202.97.43.207, FJ
        [ 0xCA612BD0, 0xCA612BD7, "HB" ],  // 202.97.43.208-202.97.43.215, HB
        [ 0xCA612BD8, 0xCA612BD8, "GD" ],  // 202.97.43.216-202.97.43.216, GD
        [ 0xCA612BD9, 0xCA612BD9, "SN" ],  // 202.97.43.217-202.97.43.217, SN
        [ 0xCA612BDA, 0xCA612BDA, "GX" ],  // 202.97.43.218-202.97.43.218, GX
        [ 0xCA612BDB, 0xCA612BDC, "FJ" ],  // 202.97.43.219-202.97.43.220, FJ
        [ 0xCA612BDD, 0xCA612BDD, "SN" ],  // 202.97.43.221-202.97.43.221, SN
        [ 0xCA612BDE, 0xCA612BDE, "XJ" ],  // 202.97.43.222-202.97.43.222, XJ
        [ 0xCA612BDF, 0xCA612BE0, "FJ" ],  // 202.97.43.223-202.97.43.224, FJ
        [ 0xCA612BE1, 0xCA612BE1, "SN" ],  // 202.97.43.225-202.97.43.225, SN
        [ 0xCA612BE2, 0xCA612BE2, "XJ" ],  // 202.97.43.226-202.97.43.226, XJ
        [ 0xCA612BE3, 0xCA612BE4, "GX" ],  // 202.97.43.227-202.97.43.228, GX
        [ 0xCA612BE5, 0xCA612BE5, "SN" ],  // 202.97.43.229-202.97.43.229, SN
        [ 0xCA612BE6, 0xCA612BE6, "FJ" ],  // 202.97.43.230-202.97.43.230, FJ
        [ 0xCA612BE7, 0xCA612BE8, "GD" ],  // 202.97.43.231-202.97.43.232, GD
        [ 0xCA612BE9, 0xCA612BE9, "SN" ],  // 202.97.43.233-202.97.43.233, SN
        [ 0xCA612BEA, 0xCA612BEA, "FJ" ],  // 202.97.43.234-202.97.43.234, FJ
        [ 0xCA612BEB, 0xCA612BEC, "GD" ],  // 202.97.43.235-202.97.43.236, GD
        [ 0xCA612BED, 0xCA612BED, "SN" ],  // 202.97.43.237-202.97.43.237, SN
        [ 0xCA612BEE, 0xCA612BEE, "FJ" ],  // 202.97.43.238-202.97.43.238, FJ
        [ 0xCA612BEF, 0xCA612BF0, "GD" ],  // 202.97.43.239-202.97.43.240, GD
        [ 0xCA612BF1, 0xCA612BF1, "SN" ],  // 202.97.43.241-202.97.43.241, SN
        [ 0xCA612BF2, 0xCA612BF2, "FJ" ],  // 202.97.43.242-202.97.43.242, FJ
        [ 0xCA612BF3, 0xCA612BF4, "GD" ],  // 202.97.43.243-202.97.43.244, GD
        [ 0xCA612BF5, 0xCA612BF5, "SN" ],  // 202.97.43.245-202.97.43.245, SN
        [ 0xCA612BF6, 0xCA612BF6, "FJ" ],  // 202.97.43.246-202.97.43.246, FJ
        [ 0xCA612BF7, 0xCA612BF8, "GD" ],  // 202.97.43.247-202.97.43.248, GD
        [ 0xCA612BF9, 0xCA612BF9, "SN" ],  // 202.97.43.249-202.97.43.249, SN
        [ 0xCA612BFA, 0xCA612BFB, "SX" ],  // 202.97.43.250-202.97.43.251, SX
        [ 0xCA612BFC, 0xCA612BFF, "FJ" ],  // 202.97.43.252-202.97.43.255, FJ
        [ 0xCA612C00, 0xCA612C3F, "HB" ],  // 202.97.44.0-202.97.44.63, HB
        [ 0xCA612C40, 0xCA612C47, "SH" ],  // 202.97.44.64-202.97.44.71, SH
        [ 0xCA612C48, 0xCA612C49, "GX" ],  // 202.97.44.72-202.97.44.73, GX
        [ 0xCA612C4A, 0xCA612C4A, "GD" ],  // 202.97.44.74-202.97.44.74, GD
        [ 0xCA612C4B, 0xCA612C4B, "GX" ],  // 202.97.44.75-202.97.44.75, GX
        [ 0xCA612C4C, 0xCA612C57, "GD" ],  // 202.97.44.76-202.97.44.87, GD
        [ 0xCA612C58, 0xCA612C5A, "YN" ],  // 202.97.44.88-202.97.44.90, YN
        [ 0xCA612C5B, 0xCA612C5C, "GX" ],  // 202.97.44.91-202.97.44.92, GX
        [ 0xCA612C5D, 0xCA612C5D, "YN" ],  // 202.97.44.93-202.97.44.93, YN
        [ 0xCA612C5E, 0xCA612C5E, "XZ" ],  // 202.97.44.94-202.97.44.94, XZ
        [ 0xCA612C5F, 0xCA612C5F, "GX" ],  // 202.97.44.95-202.97.44.95, GX
        [ 0xCA612C60, 0xCA612C67, "SH" ],  // 202.97.44.96-202.97.44.103, SH
        [ 0xCA612C68, 0xCA612C69, "AH" ],  // 202.97.44.104-202.97.44.105, AH
        [ 0xCA612C6A, 0xCA612C6A, "GD" ],  // 202.97.44.106-202.97.44.106, GD
        [ 0xCA612C6B, 0xCA612C6B, "AH" ],  // 202.97.44.107-202.97.44.107, AH
        [ 0xCA612C6C, 0xCA612C6F, "SN" ],  // 202.97.44.108-202.97.44.111, SN
        [ 0xCA612C70, 0xCA612C70, "GX" ],  // 202.97.44.112-202.97.44.112, GX
        [ 0xCA612C71, 0xCA612C72, "GD" ],  // 202.97.44.113-202.97.44.114, GD
        [ 0xCA612C73, 0xCA612C73, "GX" ],  // 202.97.44.115-202.97.44.115, GX
        [ 0xCA612C74, 0xCA612C77, "GD" ],  // 202.97.44.116-202.97.44.119, GD
        [ 0xCA612C78, 0xCA612C7B, "JX" ],  // 202.97.44.120-202.97.44.123, JX
        [ 0xCA612C7C, 0xCA612C7C, "GX" ],  // 202.97.44.124-202.97.44.124, GX
        [ 0xCA612C7D, 0xCA612C7D, "SN" ],  // 202.97.44.125-202.97.44.125, SN
        [ 0xCA612C7E, 0xCA612C7F, "SX" ],  // 202.97.44.126-202.97.44.127, SX
        [ 0xCA612C80, 0xCA612C80, "GX" ],  // 202.97.44.128-202.97.44.128, GX
        [ 0xCA612C81, 0xCA612C81, "SH" ],  // 202.97.44.129-202.97.44.129, SH
        [ 0xCA612C82, 0xCA612C83, "GX" ],  // 202.97.44.130-202.97.44.131, GX
        [ 0xCA612C84, 0xCA612C87, "GD" ],  // 202.97.44.132-202.97.44.135, GD
        [ 0xCA612C88, 0xCA612C8B, "SH" ],  // 202.97.44.136-202.97.44.139, SH
        [ 0xCA612C8C, 0xCA612C8F, "GD" ],  // 202.97.44.140-202.97.44.143, GD
        [ 0xCA612C90, 0xCA612C98, "GX" ],  // 202.97.44.144-202.97.44.152, GX
        [ 0xCA612C99, 0xCA612C99, "GD" ],  // 202.97.44.153-202.97.44.153, GD
        [ 0xCA612C9A, 0xCA612C9B, "GZ" ],  // 202.97.44.154-202.97.44.155, GZ
        [ 0xCA612C9C, 0xCA612C9D, "HB" ],  // 202.97.44.156-202.97.44.157, HB
        [ 0xCA612C9E, 0xCA612C9E, "HE" ],  // 202.97.44.158-202.97.44.158, HE
        [ 0xCA612C9F, 0xCA612CA0, "GX" ],  // 202.97.44.159-202.97.44.160, GX
        [ 0xCA612CA1, 0xCA612CA1, "HA" ],  // 202.97.44.161-202.97.44.161, HA
        [ 0xCA612CA2, 0xCA612CA2, "GD" ],  // 202.97.44.162-202.97.44.162, GD
        [ 0xCA612CA3, 0xCA612CA4, "GX" ],  // 202.97.44.163-202.97.44.164, GX
        [ 0xCA612CA5, 0xCA612CA5, "SC" ],  // 202.97.44.165-202.97.44.165, SC
        [ 0xCA612CA6, 0xCA612CA6, "GZ" ],  // 202.97.44.166-202.97.44.166, GZ
        [ 0xCA612CA7, 0xCA612CA7, "GX" ],  // 202.97.44.167-202.97.44.167, GX
        [ 0xCA612CA8, 0xCA612CBB, "SH" ],  // 202.97.44.168-202.97.44.187, SH
        [ 0xCA612CBC, 0xCA612CC4, "JX" ],  // 202.97.44.188-202.97.44.196, JX
        [ 0xCA612CC5, 0xCA612CC5, "JS" ],  // 202.97.44.197-202.97.44.197, JS
        [ 0xCA612CC6, 0xCA612CC8, "JX" ],  // 202.97.44.198-202.97.44.200, JX
        [ 0xCA612CC9, 0xCA612CC9, "YN" ],  // 202.97.44.201-202.97.44.201, YN
        [ 0xCA612CCA, 0xCA612CCA, "XZ" ],  // 202.97.44.202-202.97.44.202, XZ
        [ 0xCA612CCB, 0xCA612CCF, "JX" ],  // 202.97.44.203-202.97.44.207, JX
        [ 0xCA612CD0, 0xCA612CD0, "GD" ],  // 202.97.44.208-202.97.44.208, GD
        [ 0xCA612CD1, 0xCA612CD1, "SC" ],  // 202.97.44.209-202.97.44.209, SC
        [ 0xCA612CD2, 0xCA612CD3, "GD" ],  // 202.97.44.210-202.97.44.211, GD
        [ 0xCA612CD4, 0xCA612CD4, "GX" ],  // 202.97.44.212-202.97.44.212, GX
        [ 0xCA612CD5, 0xCA612CD5, "SC" ],  // 202.97.44.213-202.97.44.213, SC
        [ 0xCA612CD6, 0xCA612CD6, "GD" ],  // 202.97.44.214-202.97.44.214, GD
        [ 0xCA612CD7, 0xCA612CD8, "GX" ],  // 202.97.44.215-202.97.44.216, GX
        [ 0xCA612CD9, 0xCA612CDA, "GD" ],  // 202.97.44.217-202.97.44.218, GD
        [ 0xCA612CDB, 0xCA612CDB, "GX" ],  // 202.97.44.219-202.97.44.219, GX
        [ 0xCA612CDC, 0xCA612CE8, "JX" ],  // 202.97.44.220-202.97.44.232, JX
        [ 0xCA612CE9, 0xCA612CE9, "JS" ],  // 202.97.44.233-202.97.44.233, JS
        [ 0xCA612CEA, 0xCA612CEA, "HE" ],  // 202.97.44.234-202.97.44.234, HE
        [ 0xCA612CEB, 0xCA612CEC, "JX" ],  // 202.97.44.235-202.97.44.236, JX
        [ 0xCA612CED, 0xCA612CED, "SN" ],  // 202.97.44.237-202.97.44.237, SN
        [ 0xCA612CEE, 0xCA612CEE, "GS" ],  // 202.97.44.238-202.97.44.238, GS
        [ 0xCA612CEF, 0xCA612CEF, "JX" ],  // 202.97.44.239-202.97.44.239, JX
        [ 0xCA612CF0, 0xCA612CF1, "JS" ],  // 202.97.44.240-202.97.44.241, JS
        [ 0xCA612CF2, 0xCA612CF2, "GS" ],  // 202.97.44.242-202.97.44.242, GS
        [ 0xCA612CF3, 0xCA612CF5, "GX" ],  // 202.97.44.243-202.97.44.245, GX
        [ 0xCA612CF6, 0xCA612CF6, "JX" ],  // 202.97.44.246-202.97.44.246, JX
        [ 0xCA612CF7, 0xCA612CF9, "GX" ],  // 202.97.44.247-202.97.44.249, GX
        [ 0xCA612CFA, 0xCA612CFB, "JX" ],  // 202.97.44.250-202.97.44.251, JX
        [ 0xCA612CFC, 0xCA612CFF, "HA" ],  // 202.97.44.252-202.97.44.255, HA
        [ 0xCA612D00, 0xCA612DFF, "GD" ],  // 202.97.45.0-202.97.45.255, GD
        [ 0xCA612E00, 0xCA612EFF, "SH" ],  // 202.97.46.0-202.97.46.255, SH
        [ 0xCA612F00, 0xCA612FFF, "GD" ],  // 202.97.47.0-202.97.47.255, GD
        [ 0xCA613000, 0xCA6130FF, "SH" ],  // 202.97.48.0-202.97.48.255, SH
        [ 0xCA613100, 0xCA613121, "SN" ],  // 202.97.49.0-202.97.49.33, SN
        [ 0xCA613122, 0xCA613124, "SH" ],  // 202.97.49.34-202.97.49.36, SH
        [ 0xCA613125, 0xCA613125, "BJ" ],  // 202.97.49.37-202.97.49.37, BJ
        [ 0xCA613126, 0xCA613126, "SD" ],  // 202.97.49.38-202.97.49.38, SD
        [ 0xCA613127, 0xCA613144, "SH" ],  // 202.97.49.39-202.97.49.68, SH
        [ 0xCA613145, 0xCA613145, "BJ" ],  // 202.97.49.69-202.97.49.69, BJ
        [ 0xCA613146, 0xCA613146, "HE" ],  // 202.97.49.70-202.97.49.70, HE
        [ 0xCA613147, 0xCA61314C, "SH" ],  // 202.97.49.71-202.97.49.76, SH
        [ 0xCA61314D, 0xCA61314D, "SD" ],  // 202.97.49.77-202.97.49.77, SD
        [ 0xCA61314E, 0xCA613178, "SH" ],  // 202.97.49.78-202.97.49.120, SH
        [ 0xCA613179, 0xCA613179, "GS" ],  // 202.97.49.121-202.97.49.121, GS
        [ 0xCA61317A, 0xCA61317C, "XZ" ],  // 202.97.49.122-202.97.49.124, XZ
        [ 0xCA61317D, 0xCA61317D, "JS" ],  // 202.97.49.125-202.97.49.125, JS
        [ 0xCA61317E, 0xCA61317E, "GD" ],  // 202.97.49.126-202.97.49.126, GD
        [ 0xCA61317F, 0xCA61318C, "SH" ],  // 202.97.49.127-202.97.49.140, SH
        [ 0xCA61318D, 0xCA61318D, "BJ" ],  // 202.97.49.141-202.97.49.141, BJ
        [ 0xCA61318E, 0xCA61318E, "SD" ],  // 202.97.49.142-202.97.49.142, SD
        [ 0xCA61318F, 0xCA613198, "SH" ],  // 202.97.49.143-202.97.49.152, SH
        [ 0xCA613199, 0xCA61319B, "GD" ],  // 202.97.49.153-202.97.49.155, GD
        [ 0xCA61319C, 0xCA6131A9, "SH" ],  // 202.97.49.156-202.97.49.169, SH
        [ 0xCA6131AA, 0xCA6131AA, "HE" ],  // 202.97.49.170-202.97.49.170, HE
        [ 0xCA6131AB, 0xCA6131AD, "SH" ],  // 202.97.49.171-202.97.49.173, SH
        [ 0xCA6131AE, 0xCA6131AE, "HE" ],  // 202.97.49.174-202.97.49.174, HE
        [ 0xCA6131AF, 0xCA6131B1, "SH" ],  // 202.97.49.175-202.97.49.177, SH
        [ 0xCA6131B2, 0xCA6131B2, "SD" ],  // 202.97.49.178-202.97.49.178, SD
        [ 0xCA6131B3, 0xCA6131B4, "SH" ],  // 202.97.49.179-202.97.49.180, SH
        [ 0xCA6131B5, 0xCA6131B5, "BJ" ],  // 202.97.49.181-202.97.49.181, BJ
        [ 0xCA6131B6, 0xCA6131B6, "SD" ],  // 202.97.49.182-202.97.49.182, SD
        [ 0xCA6131B7, 0xCA6131B8, "SH" ],  // 202.97.49.183-202.97.49.184, SH
        [ 0xCA6131B9, 0xCA6131B9, "BJ" ],  // 202.97.49.185-202.97.49.185, BJ
        [ 0xCA6131BA, 0xCA6131BA, "SD" ],  // 202.97.49.186-202.97.49.186, SD
        [ 0xCA6131BB, 0xCA6131BC, "SH" ],  // 202.97.49.187-202.97.49.188, SH
        [ 0xCA6131BD, 0xCA6131BD, "BJ" ],  // 202.97.49.189-202.97.49.189, BJ
        [ 0xCA6131BE, 0xCA6131BE, "HE" ],  // 202.97.49.190-202.97.49.190, HE
        [ 0xCA6131BF, 0xCA6131D0, "SH" ],  // 202.97.49.191-202.97.49.208, SH
        [ 0xCA6131D1, 0xCA6131D1, "JS" ],  // 202.97.49.209-202.97.49.209, JS
        [ 0xCA6131D2, 0xCA6131D2, "GD" ],  // 202.97.49.210-202.97.49.210, GD
        [ 0xCA6131D3, 0xCA6131D4, "SH" ],  // 202.97.49.211-202.97.49.212, SH
        [ 0xCA6131D5, 0xCA6131D5, "JS" ],  // 202.97.49.213-202.97.49.213, JS
        [ 0xCA6131D6, 0xCA6131D6, "GD" ],  // 202.97.49.214-202.97.49.214, GD
        [ 0xCA6131D7, 0xCA6131D8, "SH" ],  // 202.97.49.215-202.97.49.216, SH
        [ 0xCA6131D9, 0xCA6131D9, "JS" ],  // 202.97.49.217-202.97.49.217, JS
        [ 0xCA6131DA, 0xCA6131DA, "GD" ],  // 202.97.49.218-202.97.49.218, GD
        [ 0xCA6131DB, 0xCA6131DC, "SH" ],  // 202.97.49.219-202.97.49.220, SH
        [ 0xCA6131DD, 0xCA6131DD, "JS" ],  // 202.97.49.221-202.97.49.221, JS
        [ 0xCA6131DE, 0xCA6131DE, "GD" ],  // 202.97.49.222-202.97.49.222, GD
        [ 0xCA6131DF, 0xCA6131E8, "SH" ],  // 202.97.49.223-202.97.49.232, SH
        [ 0xCA6131E9, 0xCA6131E9, "JS" ],  // 202.97.49.233-202.97.49.233, JS
        [ 0xCA6131EA, 0xCA6131EB, "SH" ],  // 202.97.49.234-202.97.49.235, SH
        [ 0xCA6131EC, 0xCA6131EC, "HN" ],  // 202.97.49.236-202.97.49.236, HN
        [ 0xCA6131ED, 0xCA6131ED, "ZJ" ],  // 202.97.49.237-202.97.49.237, ZJ
        [ 0xCA6131EE, 0xCA6131F0, "HN" ],  // 202.97.49.238-202.97.49.240, HN
        [ 0xCA6131F1, 0xCA6131F1, "ZJ" ],  // 202.97.49.241-202.97.49.241, ZJ
        [ 0xCA6131F2, 0xCA6131F7, "HN" ],  // 202.97.49.242-202.97.49.247, HN
        [ 0xCA6131F8, 0xCA6131FC, "SH" ],  // 202.97.49.248-202.97.49.252, SH
        [ 0xCA6131FD, 0xCA6131FD, "HN" ],  // 202.97.49.253-202.97.49.253, HN
        [ 0xCA6131FE, 0xCA6133FF, "SH" ],  // 202.97.49.254-202.97.51.255, SH
        [ 0xCA613400, 0xCA6134FF, "BJ" ],  // 202.97.52.0-202.97.52.255, BJ
        [ 0xCA613500, 0xCA613500, "GD" ],  // 202.97.53.0-202.97.53.0, GD
        [ 0xCA613501, 0xCA613501, "FJ" ],  // 202.97.53.1-202.97.53.1, FJ
        [ 0xCA613502, 0xCA613504, "GD" ],  // 202.97.53.2-202.97.53.4, GD
        [ 0xCA613505, 0xCA613505, "FJ" ],  // 202.97.53.5-202.97.53.5, FJ
        [ 0xCA613506, 0xCA613507, "GD" ],  // 202.97.53.6-202.97.53.7, GD
        [ 0xCA613508, 0xCA61352B, "BJ" ],  // 202.97.53.8-202.97.53.43, BJ
        [ 0xCA61352C, 0xCA613531, "HB" ],  // 202.97.53.44-202.97.53.49, HB
        [ 0xCA613532, 0xCA613568, "BJ" ],  // 202.97.53.50-202.97.53.104, BJ
        [ 0xCA613569, 0xCA613569, "SH" ],  // 202.97.53.105-202.97.53.105, SH
        [ 0xCA61356A, 0xCA613573, "BJ" ],  // 202.97.53.106-202.97.53.115, BJ
        [ 0xCA613574, 0xCA613577, "SH" ],  // 202.97.53.116-202.97.53.119, SH
        [ 0xCA613578, 0xCA61357F, "BJ" ],  // 202.97.53.120-202.97.53.127, BJ
        [ 0xCA613580, 0xCA613581, "HB" ],  // 202.97.53.128-202.97.53.129, HB
        [ 0xCA613582, 0xCA613587, "BJ" ],  // 202.97.53.130-202.97.53.135, BJ
        [ 0xCA613588, 0xCA613589, "SC" ],  // 202.97.53.136-202.97.53.137, SC
        [ 0xCA61358A, 0xCA6135B7, "BJ" ],  // 202.97.53.138-202.97.53.183, BJ
        [ 0xCA6135B8, 0xCA6135B9, "SC" ],  // 202.97.53.184-202.97.53.185, SC
        [ 0xCA6135BA, 0xCA6135C6, "BJ" ],  // 202.97.53.186-202.97.53.198, BJ
        [ 0xCA6135C7, 0xCA6135C9, "JS" ],  // 202.97.53.199-202.97.53.201, JS
        [ 0xCA6135CA, 0xCA6135CE, "SX" ],  // 202.97.53.202-202.97.53.206, SX
        [ 0xCA6135CF, 0xCA6135FF, "BJ" ],  // 202.97.53.207-202.97.53.255, BJ
        [ 0xCA613600, 0xCA6136FF, "GS" ],  // 202.97.54.0-202.97.54.255, GS
        [ 0xCA613700, 0xCA613718, "FJ" ],  // 202.97.55.0-202.97.55.24, FJ
        [ 0xCA613719, 0xCA613719, "GD" ],  // 202.97.55.25-202.97.55.25, GD
        [ 0xCA61371A, 0xCA61371C, "FJ" ],  // 202.97.55.26-202.97.55.28, FJ
        [ 0xCA61371D, 0xCA61371D, "GD" ],  // 202.97.55.29-202.97.55.29, GD
        [ 0xCA61371E, 0xCA61371E, "AH" ],  // 202.97.55.30-202.97.55.30, AH
        [ 0xCA61371F, 0xCA61371F, "FJ" ],  // 202.97.55.31-202.97.55.31, FJ
        [ 0xCA613720, 0xCA613727, "SH" ],  // 202.97.55.32-202.97.55.39, SH
        [ 0xCA613728, 0xCA613728, "FJ" ],  // 202.97.55.40-202.97.55.40, FJ
        [ 0xCA613729, 0xCA613729, "SH" ],  // 202.97.55.41-202.97.55.41, SH
        [ 0xCA61372A, 0xCA61372A, "AH" ],  // 202.97.55.42-202.97.55.42, AH
        [ 0xCA61372B, 0xCA61372C, "FJ" ],  // 202.97.55.43-202.97.55.44, FJ
        [ 0xCA61372D, 0xCA61372D, "JS" ],  // 202.97.55.45-202.97.55.45, JS
        [ 0xCA61372E, 0xCA61372E, "AH" ],  // 202.97.55.46-202.97.55.46, AH
        [ 0xCA61372F, 0xCA613730, "FJ" ],  // 202.97.55.47-202.97.55.48, FJ
        [ 0xCA613731, 0xCA613731, "SH" ],  // 202.97.55.49-202.97.55.49, SH
        [ 0xCA613732, 0xCA613732, "AH" ],  // 202.97.55.50-202.97.55.50, AH
        [ 0xCA613733, 0xCA613734, "FJ" ],  // 202.97.55.51-202.97.55.52, FJ
        [ 0xCA613735, 0xCA613735, "SH" ],  // 202.97.55.53-202.97.55.53, SH
        [ 0xCA613736, 0xCA613736, "AH" ],  // 202.97.55.54-202.97.55.54, AH
        [ 0xCA613737, 0xCA613738, "FJ" ],  // 202.97.55.55-202.97.55.56, FJ
        [ 0xCA613739, 0xCA613739, "SH" ],  // 202.97.55.57-202.97.55.57, SH
        [ 0xCA61373A, 0xCA61373A, "AH" ],  // 202.97.55.58-202.97.55.58, AH
        [ 0xCA61373B, 0xCA61373C, "FJ" ],  // 202.97.55.59-202.97.55.60, FJ
        [ 0xCA61373D, 0xCA61373D, "SH" ],  // 202.97.55.61-202.97.55.61, SH
        [ 0xCA61373E, 0xCA61373E, "AH" ],  // 202.97.55.62-202.97.55.62, AH
        [ 0xCA61373F, 0xCA613740, "FJ" ],  // 202.97.55.63-202.97.55.64, FJ
        [ 0xCA613741, 0xCA613741, "SH" ],  // 202.97.55.65-202.97.55.65, SH
        [ 0xCA613742, 0xCA613742, "AH" ],  // 202.97.55.66-202.97.55.66, AH
        [ 0xCA613743, 0xCA613744, "FJ" ],  // 202.97.55.67-202.97.55.68, FJ
        [ 0xCA613745, 0xCA613745, "SH" ],  // 202.97.55.69-202.97.55.69, SH
        [ 0xCA613746, 0xCA613746, "AH" ],  // 202.97.55.70-202.97.55.70, AH
        [ 0xCA613747, 0xCA613748, "FJ" ],  // 202.97.55.71-202.97.55.72, FJ
        [ 0xCA613749, 0xCA613749, "AH" ],  // 202.97.55.73-202.97.55.73, AH
        [ 0xCA61374A, 0xCA61374A, "JX" ],  // 202.97.55.74-202.97.55.74, JX
        [ 0xCA61374B, 0xCA61374C, "FJ" ],  // 202.97.55.75-202.97.55.76, FJ
        [ 0xCA61374D, 0xCA61374D, "JS" ],  // 202.97.55.77-202.97.55.77, JS
        [ 0xCA61374E, 0xCA61374E, "JX" ],  // 202.97.55.78-202.97.55.78, JX
        [ 0xCA61374F, 0xCA613751, "FJ" ],  // 202.97.55.79-202.97.55.81, FJ
        [ 0xCA613752, 0xCA613752, "JX" ],  // 202.97.55.82-202.97.55.82, JX
        [ 0xCA613753, 0xCA613754, "FJ" ],  // 202.97.55.83-202.97.55.84, FJ
        [ 0xCA613755, 0xCA613755, "JS" ],  // 202.97.55.85-202.97.55.85, JS
        [ 0xCA613756, 0xCA613756, "JX" ],  // 202.97.55.86-202.97.55.86, JX
        [ 0xCA613757, 0xCA613759, "FJ" ],  // 202.97.55.87-202.97.55.89, FJ
        [ 0xCA61375A, 0xCA61375A, "GX" ],  // 202.97.55.90-202.97.55.90, GX
        [ 0xCA61375B, 0xCA61375C, "FJ" ],  // 202.97.55.91-202.97.55.92, FJ
        [ 0xCA61375D, 0xCA61375D, "GD" ],  // 202.97.55.93-202.97.55.93, GD
        [ 0xCA61375E, 0xCA61375E, "JX" ],  // 202.97.55.94-202.97.55.94, JX
        [ 0xCA61375F, 0xCA613761, "FJ" ],  // 202.97.55.95-202.97.55.97, FJ
        [ 0xCA613762, 0xCA613762, "JX" ],  // 202.97.55.98-202.97.55.98, JX
        [ 0xCA613763, 0xCA613765, "FJ" ],  // 202.97.55.99-202.97.55.101, FJ
        [ 0xCA613766, 0xCA613766, "JX" ],  // 202.97.55.102-202.97.55.102, JX
        [ 0xCA613767, 0xCA613769, "FJ" ],  // 202.97.55.103-202.97.55.105, FJ
        [ 0xCA61376A, 0xCA61376A, "JX" ],  // 202.97.55.106-202.97.55.106, JX
        [ 0xCA61376B, 0xCA61376D, "FJ" ],  // 202.97.55.107-202.97.55.109, FJ
        [ 0xCA61376E, 0xCA61376E, "JX" ],  // 202.97.55.110-202.97.55.110, JX
        [ 0xCA61376F, 0xCA613770, "FJ" ],  // 202.97.55.111-202.97.55.112, FJ
        [ 0xCA613771, 0xCA613771, "HB" ],  // 202.97.55.113-202.97.55.113, HB
        [ 0xCA613772, 0xCA613772, "JX" ],  // 202.97.55.114-202.97.55.114, JX
        [ 0xCA613773, 0xCA613775, "FJ" ],  // 202.97.55.115-202.97.55.117, FJ
        [ 0xCA613776, 0xCA613776, "JX" ],  // 202.97.55.118-202.97.55.118, JX
        [ 0xCA613777, 0xCA613778, "FJ" ],  // 202.97.55.119-202.97.55.120, FJ
        [ 0xCA613779, 0xCA613779, "SH" ],  // 202.97.55.121-202.97.55.121, SH
        [ 0xCA61377A, 0xCA61377A, "JX" ],  // 202.97.55.122-202.97.55.122, JX
        [ 0xCA61377B, 0xCA61377C, "FJ" ],  // 202.97.55.123-202.97.55.124, FJ
        [ 0xCA61377D, 0xCA61377D, "SH" ],  // 202.97.55.125-202.97.55.125, SH
        [ 0xCA61377E, 0xCA61377E, "JX" ],  // 202.97.55.126-202.97.55.126, JX
        [ 0xCA61377F, 0xCA613780, "FJ" ],  // 202.97.55.127-202.97.55.128, FJ
        [ 0xCA613781, 0xCA613781, "SH" ],  // 202.97.55.129-202.97.55.129, SH
        [ 0xCA613782, 0xCA613782, "JX" ],  // 202.97.55.130-202.97.55.130, JX
        [ 0xCA613783, 0xCA613784, "FJ" ],  // 202.97.55.131-202.97.55.132, FJ
        [ 0xCA613785, 0xCA613785, "SH" ],  // 202.97.55.133-202.97.55.133, SH
        [ 0xCA613786, 0xCA613786, "JX" ],  // 202.97.55.134-202.97.55.134, JX
        [ 0xCA613787, 0xCA613788, "FJ" ],  // 202.97.55.135-202.97.55.136, FJ
        [ 0xCA613789, 0xCA613789, "SH" ],  // 202.97.55.137-202.97.55.137, SH
        [ 0xCA61378A, 0xCA61378A, "JX" ],  // 202.97.55.138-202.97.55.138, JX
        [ 0xCA61378B, 0xCA61378C, "FJ" ],  // 202.97.55.139-202.97.55.140, FJ
        [ 0xCA61378D, 0xCA61378D, "SH" ],  // 202.97.55.141-202.97.55.141, SH
        [ 0xCA61378E, 0xCA61378E, "JX" ],  // 202.97.55.142-202.97.55.142, JX
        [ 0xCA61378F, 0xCA613790, "FJ" ],  // 202.97.55.143-202.97.55.144, FJ
        [ 0xCA613791, 0xCA613791, "SC" ],  // 202.97.55.145-202.97.55.145, SC
        [ 0xCA613792, 0xCA613792, "AH" ],  // 202.97.55.146-202.97.55.146, AH
        [ 0xCA613793, 0xCA613794, "FJ" ],  // 202.97.55.147-202.97.55.148, FJ
        [ 0xCA613795, 0xCA613795, "SC" ],  // 202.97.55.149-202.97.55.149, SC
        [ 0xCA613796, 0xCA613796, "AH" ],  // 202.97.55.150-202.97.55.150, AH
        [ 0xCA613797, 0xCA613798, "FJ" ],  // 202.97.55.151-202.97.55.152, FJ
        [ 0xCA613799, 0xCA613799, "GD" ],  // 202.97.55.153-202.97.55.153, GD
        [ 0xCA61379A, 0xCA61379A, "AH" ],  // 202.97.55.154-202.97.55.154, AH
        [ 0xCA61379B, 0xCA61379C, "GD" ],  // 202.97.55.155-202.97.55.156, GD
        [ 0xCA61379D, 0xCA61379D, "SC" ],  // 202.97.55.157-202.97.55.157, SC
        [ 0xCA61379E, 0xCA61379E, "AH" ],  // 202.97.55.158-202.97.55.158, AH
        [ 0xCA61379F, 0xCA6137A0, "FJ" ],  // 202.97.55.159-202.97.55.160, FJ
        [ 0xCA6137A1, 0xCA6137A1, "SC" ],  // 202.97.55.161-202.97.55.161, SC
        [ 0xCA6137A2, 0xCA6137A4, "FJ" ],  // 202.97.55.162-202.97.55.164, FJ
        [ 0xCA6137A5, 0xCA6137A5, "SC" ],  // 202.97.55.165-202.97.55.165, SC
        [ 0xCA6137A6, 0xCA6137A6, "AH" ],  // 202.97.55.166-202.97.55.166, AH
        [ 0xCA6137A7, 0xCA6137A8, "FJ" ],  // 202.97.55.167-202.97.55.168, FJ
        [ 0xCA6137A9, 0xCA6137A9, "SC" ],  // 202.97.55.169-202.97.55.169, SC
        [ 0xCA6137AA, 0xCA6137AA, "AH" ],  // 202.97.55.170-202.97.55.170, AH
        [ 0xCA6137AB, 0xCA6137AC, "FJ" ],  // 202.97.55.171-202.97.55.172, FJ
        [ 0xCA6137AD, 0xCA6137AD, "SC" ],  // 202.97.55.173-202.97.55.173, SC
        [ 0xCA6137AE, 0xCA6137AE, "AH" ],  // 202.97.55.174-202.97.55.174, AH
        [ 0xCA6137AF, 0xCA6137B0, "FJ" ],  // 202.97.55.175-202.97.55.176, FJ
        [ 0xCA6137B1, 0xCA6137B1, "SN" ],  // 202.97.55.177-202.97.55.177, SN
        [ 0xCA6137B2, 0xCA6137B2, "AH" ],  // 202.97.55.178-202.97.55.178, AH
        [ 0xCA6137B3, 0xCA6137B4, "FJ" ],  // 202.97.55.179-202.97.55.180, FJ
        [ 0xCA6137B5, 0xCA6137B5, "SN" ],  // 202.97.55.181-202.97.55.181, SN
        [ 0xCA6137B6, 0xCA6137B6, "AH" ],  // 202.97.55.182-202.97.55.182, AH
        [ 0xCA6137B7, 0xCA6137B8, "FJ" ],  // 202.97.55.183-202.97.55.184, FJ
        [ 0xCA6137B9, 0xCA6137B9, "SN" ],  // 202.97.55.185-202.97.55.185, SN
        [ 0xCA6137BA, 0xCA6137BA, "AH" ],  // 202.97.55.186-202.97.55.186, AH
        [ 0xCA6137BB, 0xCA6137BC, "FJ" ],  // 202.97.55.187-202.97.55.188, FJ
        [ 0xCA6137BD, 0xCA6137BD, "SN" ],  // 202.97.55.189-202.97.55.189, SN
        [ 0xCA6137BE, 0xCA6137BE, "AH" ],  // 202.97.55.190-202.97.55.190, AH
        [ 0xCA6137BF, 0xCA6137C0, "FJ" ],  // 202.97.55.191-202.97.55.192, FJ
        [ 0xCA6137C1, 0xCA6137C1, "GD" ],  // 202.97.55.193-202.97.55.193, GD
        [ 0xCA6137C2, 0xCA6137C2, "AH" ],  // 202.97.55.194-202.97.55.194, AH
        [ 0xCA6137C3, 0xCA6137C4, "FJ" ],  // 202.97.55.195-202.97.55.196, FJ
        [ 0xCA6137C5, 0xCA6137C5, "GD" ],  // 202.97.55.197-202.97.55.197, GD
        [ 0xCA6137C6, 0xCA6137C6, "AH" ],  // 202.97.55.198-202.97.55.198, AH
        [ 0xCA6137C7, 0xCA6137C8, "FJ" ],  // 202.97.55.199-202.97.55.200, FJ
        [ 0xCA6137C9, 0xCA6137C9, "GD" ],  // 202.97.55.201-202.97.55.201, GD
        [ 0xCA6137CA, 0xCA6137CA, "AH" ],  // 202.97.55.202-202.97.55.202, AH
        [ 0xCA6137CB, 0xCA6137CD, "FJ" ],  // 202.97.55.203-202.97.55.205, FJ
        [ 0xCA6137CE, 0xCA6137CE, "AH" ],  // 202.97.55.206-202.97.55.206, AH
        [ 0xCA6137CF, 0xCA6137D0, "FJ" ],  // 202.97.55.207-202.97.55.208, FJ
        [ 0xCA6137D1, 0xCA6137D1, "GD" ],  // 202.97.55.209-202.97.55.209, GD
        [ 0xCA6137D2, 0xCA6137D2, "AH" ],  // 202.97.55.210-202.97.55.210, AH
        [ 0xCA6137D3, 0xCA6137D4, "FJ" ],  // 202.97.55.211-202.97.55.212, FJ
        [ 0xCA6137D5, 0xCA6137D5, "GD" ],  // 202.97.55.213-202.97.55.213, GD
        [ 0xCA6137D6, 0xCA6137D6, "AH" ],  // 202.97.55.214-202.97.55.214, AH
        [ 0xCA6137D7, 0xCA6137D9, "FJ" ],  // 202.97.55.215-202.97.55.217, FJ
        [ 0xCA6137DA, 0xCA6137DA, "AH" ],  // 202.97.55.218-202.97.55.218, AH
        [ 0xCA6137DB, 0xCA6137DC, "FJ" ],  // 202.97.55.219-202.97.55.220, FJ
        [ 0xCA6137DD, 0xCA6137DD, "GD" ],  // 202.97.55.221-202.97.55.221, GD
        [ 0xCA6137DE, 0xCA6137DE, "AH" ],  // 202.97.55.222-202.97.55.222, AH
        [ 0xCA6137DF, 0xCA6137FF, "FJ" ],  // 202.97.55.223-202.97.55.255, FJ
        [ 0xCA613800, 0xCA613801, "ZJ" ],  // 202.97.56.0-202.97.56.1, ZJ
        [ 0xCA613802, 0xCA613802, "GD" ],  // 202.97.56.2-202.97.56.2, GD
        [ 0xCA613803, 0xCA613805, "GX" ],  // 202.97.56.3-202.97.56.5, GX
        [ 0xCA613806, 0xCA613806, "GD" ],  // 202.97.56.6-202.97.56.6, GD
        [ 0xCA613807, 0xCA613809, "GX" ],  // 202.97.56.7-202.97.56.9, GX
        [ 0xCA61380A, 0xCA61380A, "GD" ],  // 202.97.56.10-202.97.56.10, GD
        [ 0xCA61380B, 0xCA61380C, "GX" ],  // 202.97.56.11-202.97.56.12, GX
        [ 0xCA61380D, 0xCA61380D, "SC" ],  // 202.97.56.13-202.97.56.13, SC
        [ 0xCA61380E, 0xCA61380E, "GD" ],  // 202.97.56.14-202.97.56.14, GD
        [ 0xCA61380F, 0xCA613810, "GX" ],  // 202.97.56.15-202.97.56.16, GX
        [ 0xCA613811, 0xCA613811, "SN" ],  // 202.97.56.17-202.97.56.17, SN
        [ 0xCA613812, 0xCA613812, "HN" ],  // 202.97.56.18-202.97.56.18, HN
        [ 0xCA613813, 0xCA613814, "GX" ],  // 202.97.56.19-202.97.56.20, GX
        [ 0xCA613815, 0xCA613815, "SN" ],  // 202.97.56.21-202.97.56.21, SN
        [ 0xCA613816, 0xCA613816, "HN" ],  // 202.97.56.22-202.97.56.22, HN
        [ 0xCA613817, 0xCA613818, "GX" ],  // 202.97.56.23-202.97.56.24, GX
        [ 0xCA613819, 0xCA613819, "SN" ],  // 202.97.56.25-202.97.56.25, SN
        [ 0xCA61381A, 0xCA61381A, "ZJ" ],  // 202.97.56.26-202.97.56.26, ZJ
        [ 0xCA61381B, 0xCA61381D, "GX" ],  // 202.97.56.27-202.97.56.29, GX
        [ 0xCA61381E, 0xCA61381E, "GD" ],  // 202.97.56.30-202.97.56.30, GD
        [ 0xCA61381F, 0xCA613820, "GX" ],  // 202.97.56.31-202.97.56.32, GX
        [ 0xCA613821, 0xCA613821, "ZJ" ],  // 202.97.56.33-202.97.56.33, ZJ
        [ 0xCA613822, 0xCA613822, "HN" ],  // 202.97.56.34-202.97.56.34, HN
        [ 0xCA613823, 0xCA613823, "GX" ],  // 202.97.56.35-202.97.56.35, GX
        [ 0xCA613824, 0xCA613824, "HN" ],  // 202.97.56.36-202.97.56.36, HN
        [ 0xCA613825, 0xCA613825, "ZJ" ],  // 202.97.56.37-202.97.56.37, ZJ
        [ 0xCA613826, 0xCA613828, "GX" ],  // 202.97.56.38-202.97.56.40, GX
        [ 0xCA613829, 0xCA613829, "ZJ" ],  // 202.97.56.41-202.97.56.41, ZJ
        [ 0xCA61382A, 0xCA61382A, "HN" ],  // 202.97.56.42-202.97.56.42, HN
        [ 0xCA61382B, 0xCA61382C, "GX" ],  // 202.97.56.43-202.97.56.44, GX
        [ 0xCA61382D, 0xCA61382D, "ZJ" ],  // 202.97.56.45-202.97.56.45, ZJ
        [ 0xCA61382E, 0xCA613830, "GX" ],  // 202.97.56.46-202.97.56.48, GX
        [ 0xCA613831, 0xCA613831, "SN" ],  // 202.97.56.49-202.97.56.49, SN
        [ 0xCA613832, 0xCA613832, "HN" ],  // 202.97.56.50-202.97.56.50, HN
        [ 0xCA613833, 0xCA613834, "GX" ],  // 202.97.56.51-202.97.56.52, GX
        [ 0xCA613835, 0xCA613835, "SN" ],  // 202.97.56.53-202.97.56.53, SN
        [ 0xCA613836, 0xCA613836, "HN" ],  // 202.97.56.54-202.97.56.54, HN
        [ 0xCA613837, 0xCA613838, "GX" ],  // 202.97.56.55-202.97.56.56, GX
        [ 0xCA613839, 0xCA613839, "SN" ],  // 202.97.56.57-202.97.56.57, SN
        [ 0xCA61383A, 0xCA61383A, "HN" ],  // 202.97.56.58-202.97.56.58, HN
        [ 0xCA61383B, 0xCA61383C, "GX" ],  // 202.97.56.59-202.97.56.60, GX
        [ 0xCA61383D, 0xCA61383D, "SN" ],  // 202.97.56.61-202.97.56.61, SN
        [ 0xCA61383E, 0xCA61383E, "HN" ],  // 202.97.56.62-202.97.56.62, HN
        [ 0xCA61383F, 0xCA613840, "GX" ],  // 202.97.56.63-202.97.56.64, GX
        [ 0xCA613841, 0xCA613841, "JS" ],  // 202.97.56.65-202.97.56.65, JS
        [ 0xCA613842, 0xCA613842, "HN" ],  // 202.97.56.66-202.97.56.66, HN
        [ 0xCA613843, 0xCA613844, "GX" ],  // 202.97.56.67-202.97.56.68, GX
        [ 0xCA613845, 0xCA613845, "AH" ],  // 202.97.56.69-202.97.56.69, AH
        [ 0xCA613846, 0xCA613846, "HN" ],  // 202.97.56.70-202.97.56.70, HN
        [ 0xCA613847, 0xCA613849, "GX" ],  // 202.97.56.71-202.97.56.73, GX
        [ 0xCA61384A, 0xCA61384A, "HN" ],  // 202.97.56.74-202.97.56.74, HN
        [ 0xCA61384B, 0xCA61384C, "GX" ],  // 202.97.56.75-202.97.56.76, GX
        [ 0xCA61384D, 0xCA61384D, "JS" ],  // 202.97.56.77-202.97.56.77, JS
        [ 0xCA61384E, 0xCA61384E, "HN" ],  // 202.97.56.78-202.97.56.78, HN
        [ 0xCA61384F, 0xCA613850, "GX" ],  // 202.97.56.79-202.97.56.80, GX
        [ 0xCA613851, 0xCA613851, "AH" ],  // 202.97.56.81-202.97.56.81, AH
        [ 0xCA613852, 0xCA613852, "HN" ],  // 202.97.56.82-202.97.56.82, HN
        [ 0xCA613853, 0xCA613854, "GX" ],  // 202.97.56.83-202.97.56.84, GX
        [ 0xCA613855, 0xCA613855, "JS" ],  // 202.97.56.85-202.97.56.85, JS
        [ 0xCA613856, 0xCA613856, "HN" ],  // 202.97.56.86-202.97.56.86, HN
        [ 0xCA613857, 0xCA613858, "GX" ],  // 202.97.56.87-202.97.56.88, GX
        [ 0xCA613859, 0xCA613859, "JS" ],  // 202.97.56.89-202.97.56.89, JS
        [ 0xCA61385A, 0xCA61385A, "HN" ],  // 202.97.56.90-202.97.56.90, HN
        [ 0xCA61385B, 0xCA61385D, "GX" ],  // 202.97.56.91-202.97.56.93, GX
        [ 0xCA61385E, 0xCA61385E, "HN" ],  // 202.97.56.94-202.97.56.94, HN
        [ 0xCA61385F, 0xCA613860, "GX" ],  // 202.97.56.95-202.97.56.96, GX
        [ 0xCA613861, 0xCA613861, "GD" ],  // 202.97.56.97-202.97.56.97, GD
        [ 0xCA613862, 0xCA613862, "HN" ],  // 202.97.56.98-202.97.56.98, HN
        [ 0xCA613863, 0xCA613864, "GX" ],  // 202.97.56.99-202.97.56.100, GX
        [ 0xCA613865, 0xCA613865, "GD" ],  // 202.97.56.101-202.97.56.101, GD
        [ 0xCA613866, 0xCA613866, "HN" ],  // 202.97.56.102-202.97.56.102, HN
        [ 0xCA613867, 0xCA613868, "GX" ],  // 202.97.56.103-202.97.56.104, GX
        [ 0xCA613869, 0xCA613869, "HB" ],  // 202.97.56.105-202.97.56.105, HB
        [ 0xCA61386A, 0xCA61386A, "HN" ],  // 202.97.56.106-202.97.56.106, HN
        [ 0xCA61386B, 0xCA61386C, "GX" ],  // 202.97.56.107-202.97.56.108, GX
        [ 0xCA61386D, 0xCA61386D, "GD" ],  // 202.97.56.109-202.97.56.109, GD
        [ 0xCA61386E, 0xCA61386E, "HN" ],  // 202.97.56.110-202.97.56.110, HN
        [ 0xCA61386F, 0xCA613870, "GX" ],  // 202.97.56.111-202.97.56.112, GX
        [ 0xCA613871, 0xCA613871, "GD" ],  // 202.97.56.113-202.97.56.113, GD
        [ 0xCA613872, 0xCA613874, "GX" ],  // 202.97.56.114-202.97.56.116, GX
        [ 0xCA613875, 0xCA613875, "GD" ],  // 202.97.56.117-202.97.56.117, GD
        [ 0xCA613876, 0xCA613878, "GX" ],  // 202.97.56.118-202.97.56.120, GX
        [ 0xCA613879, 0xCA613879, "GD" ],  // 202.97.56.121-202.97.56.121, GD
        [ 0xCA61387A, 0xCA613880, "ZJ" ],  // 202.97.56.122-202.97.56.128, ZJ
        [ 0xCA613881, 0xCA613881, "HB" ],  // 202.97.56.129-202.97.56.129, HB
        [ 0xCA613882, 0xCA613884, "HL" ],  // 202.97.56.130-202.97.56.132, HL
        [ 0xCA613885, 0xCA613885, "HB" ],  // 202.97.56.133-202.97.56.133, HB
        [ 0xCA613886, 0xCA613888, "HL" ],  // 202.97.56.134-202.97.56.136, HL
        [ 0xCA613889, 0xCA613889, "HB" ],  // 202.97.56.137-202.97.56.137, HB
        [ 0xCA61388A, 0xCA61388C, "HL" ],  // 202.97.56.138-202.97.56.140, HL
        [ 0xCA61388D, 0xCA61388D, "HB" ],  // 202.97.56.141-202.97.56.141, HB
        [ 0xCA61388E, 0xCA613898, "GX" ],  // 202.97.56.142-202.97.56.152, GX
        [ 0xCA613899, 0xCA613899, "GD" ],  // 202.97.56.153-202.97.56.153, GD
        [ 0xCA61389A, 0xCA61389A, "ZJ" ],  // 202.97.56.154-202.97.56.154, ZJ
        [ 0xCA61389B, 0xCA61389C, "HL" ],  // 202.97.56.155-202.97.56.156, HL
        [ 0xCA61389D, 0xCA61389D, "HB" ],  // 202.97.56.157-202.97.56.157, HB
        [ 0xCA61389E, 0xCA61389E, "HE" ],  // 202.97.56.158-202.97.56.158, HE
        [ 0xCA61389F, 0xCA6138A0, "HL" ],  // 202.97.56.159-202.97.56.160, HL
        [ 0xCA6138A1, 0xCA6138A1, "ZJ" ],  // 202.97.56.161-202.97.56.161, ZJ
        [ 0xCA6138A2, 0xCA6138A2, "JL" ],  // 202.97.56.162-202.97.56.162, JL
        [ 0xCA6138A3, 0xCA6138A3, "ZJ" ],  // 202.97.56.163-202.97.56.163, ZJ
        [ 0xCA6138A4, 0xCA6138A4, "JL" ],  // 202.97.56.164-202.97.56.164, JL
        [ 0xCA6138A5, 0xCA6138A5, "TJ" ],  // 202.97.56.165-202.97.56.165, TJ
        [ 0xCA6138A6, 0xCA6138A6, "HN" ],  // 202.97.56.166-202.97.56.166, HN
        [ 0xCA6138A7, 0xCA6138A9, "JL" ],  // 202.97.56.167-202.97.56.169, JL
        [ 0xCA6138AA, 0xCA6138AA, "HL" ],  // 202.97.56.170-202.97.56.170, HL
        [ 0xCA6138AB, 0xCA6138AC, "JL" ],  // 202.97.56.171-202.97.56.172, JL
        [ 0xCA6138AD, 0xCA6138AD, "GX" ],  // 202.97.56.173-202.97.56.173, GX
        [ 0xCA6138AE, 0xCA6138AE, "HN" ],  // 202.97.56.174-202.97.56.174, HN
        [ 0xCA6138AF, 0xCA6138B4, "JL" ],  // 202.97.56.175-202.97.56.180, JL
        [ 0xCA6138B5, 0xCA6138B5, "GX" ],  // 202.97.56.181-202.97.56.181, GX
        [ 0xCA6138B6, 0xCA6138B8, "JL" ],  // 202.97.56.182-202.97.56.184, JL
        [ 0xCA6138B9, 0xCA6138B9, "GD" ],  // 202.97.56.185-202.97.56.185, GD
        [ 0xCA6138BA, 0xCA6138BA, "ZJ" ],  // 202.97.56.186-202.97.56.186, ZJ
        [ 0xCA6138BB, 0xCA6138BC, "JL" ],  // 202.97.56.187-202.97.56.188, JL
        [ 0xCA6138BD, 0xCA6138BD, "SN" ],  // 202.97.56.189-202.97.56.189, SN
        [ 0xCA6138BE, 0xCA6138BF, "GX" ],  // 202.97.56.190-202.97.56.191, GX
        [ 0xCA6138C0, 0xCA6138C1, "SC" ],  // 202.97.56.192-202.97.56.193, SC
        [ 0xCA6138C2, 0xCA6138C4, "JL" ],  // 202.97.56.194-202.97.56.196, JL
        [ 0xCA6138C5, 0xCA6138C5, "SC" ],  // 202.97.56.197-202.97.56.197, SC
        [ 0xCA6138C6, 0xCA6138C8, "JL" ],  // 202.97.56.198-202.97.56.200, JL
        [ 0xCA6138C9, 0xCA6138C9, "SC" ],  // 202.97.56.201-202.97.56.201, SC
        [ 0xCA6138CA, 0xCA6138CC, "JL" ],  // 202.97.56.202-202.97.56.204, JL
        [ 0xCA6138CD, 0xCA6138CD, "SC" ],  // 202.97.56.205-202.97.56.205, SC
        [ 0xCA6138CE, 0xCA6138D0, "JL" ],  // 202.97.56.206-202.97.56.208, JL
        [ 0xCA6138D1, 0xCA6138D1, "SC" ],  // 202.97.56.209-202.97.56.209, SC
        [ 0xCA6138D2, 0xCA6138D2, "HN" ],  // 202.97.56.210-202.97.56.210, HN
        [ 0xCA6138D3, 0xCA6138D4, "JL" ],  // 202.97.56.211-202.97.56.212, JL
        [ 0xCA6138D5, 0xCA6138D5, "SC" ],  // 202.97.56.213-202.97.56.213, SC
        [ 0xCA6138D6, 0xCA6138D6, "HN" ],  // 202.97.56.214-202.97.56.214, HN
        [ 0xCA6138D7, 0xCA6138D8, "JL" ],  // 202.97.56.215-202.97.56.216, JL
        [ 0xCA6138D9, 0xCA6138D9, "GD" ],  // 202.97.56.217-202.97.56.217, GD
        [ 0xCA6138DA, 0xCA6138DA, "HN" ],  // 202.97.56.218-202.97.56.218, HN
        [ 0xCA6138DB, 0xCA6138DC, "JL" ],  // 202.97.56.219-202.97.56.220, JL
        [ 0xCA6138DD, 0xCA6138DD, "SC" ],  // 202.97.56.221-202.97.56.221, SC
        [ 0xCA6138DE, 0xCA6138DF, "JL" ],  // 202.97.56.222-202.97.56.223, JL
        [ 0xCA6138E0, 0xCA6138E0, "HE" ],  // 202.97.56.224-202.97.56.224, HE
        [ 0xCA6138E1, 0xCA6138E1, "HB" ],  // 202.97.56.225-202.97.56.225, HB
        [ 0xCA6138E2, 0xCA6138E2, "ZJ" ],  // 202.97.56.226-202.97.56.226, ZJ
        [ 0xCA6138E3, 0xCA6138E4, "HE" ],  // 202.97.56.227-202.97.56.228, HE
        [ 0xCA6138E5, 0xCA6138E5, "HB" ],  // 202.97.56.229-202.97.56.229, HB
        [ 0xCA6138E6, 0xCA6138E6, "GX" ],  // 202.97.56.230-202.97.56.230, GX
        [ 0xCA6138E7, 0xCA6138E8, "HE" ],  // 202.97.56.231-202.97.56.232, HE
        [ 0xCA6138E9, 0xCA6138E9, "HB" ],  // 202.97.56.233-202.97.56.233, HB
        [ 0xCA6138EA, 0xCA6138EA, "GX" ],  // 202.97.56.234-202.97.56.234, GX
        [ 0xCA6138EB, 0xCA6138EC, "HE" ],  // 202.97.56.235-202.97.56.236, HE
        [ 0xCA6138ED, 0xCA6138ED, "HB" ],  // 202.97.56.237-202.97.56.237, HB
        [ 0xCA6138EE, 0xCA6138EE, "GX" ],  // 202.97.56.238-202.97.56.238, GX
        [ 0xCA6138EF, 0xCA6138F0, "HE" ],  // 202.97.56.239-202.97.56.240, HE
        [ 0xCA6138F1, 0xCA6138F1, "TJ" ],  // 202.97.56.241-202.97.56.241, TJ
        [ 0xCA6138F2, 0xCA6138F2, "HN" ],  // 202.97.56.242-202.97.56.242, HN
        [ 0xCA6138F3, 0xCA6138F4, "HE" ],  // 202.97.56.243-202.97.56.244, HE
        [ 0xCA6138F5, 0xCA6138F5, "HB" ],  // 202.97.56.245-202.97.56.245, HB
        [ 0xCA6138F6, 0xCA6138F7, "GX" ],  // 202.97.56.246-202.97.56.247, GX
        [ 0xCA6138F8, 0xCA6138F9, "HB" ],  // 202.97.56.248-202.97.56.249, HB
        [ 0xCA6138FA, 0xCA6138FB, "GX" ],  // 202.97.56.250-202.97.56.251, GX
        [ 0xCA6138FC, 0xCA6138FD, "HB" ],  // 202.97.56.252-202.97.56.253, HB
        [ 0xCA6138FE, 0xCA6138FF, "GX" ],  // 202.97.56.254-202.97.56.255, GX
        [ 0xCA613900, 0xCA6139FF, "BJ" ],  // 202.97.57.0-202.97.57.255, BJ
        [ 0xCA613A00, 0xCA613AFF, "GD" ],  // 202.97.58.0-202.97.58.255, GD
        [ 0xCA613B00, 0xCA613BFF, "AH" ],  // 202.97.59.0-202.97.59.255, AH
        [ 0xCA613C00, 0xCA613C01, "SC" ],  // 202.97.60.0-202.97.60.1, SC
        [ 0xCA613C02, 0xCA613C02, "SH" ],  // 202.97.60.2-202.97.60.2, SH
        [ 0xCA613C03, 0xCA613C05, "SC" ],  // 202.97.60.3-202.97.60.5, SC
        [ 0xCA613C06, 0xCA613C06, "SH" ],  // 202.97.60.6-202.97.60.6, SH
        [ 0xCA613C07, 0xCA613C07, "SC" ],  // 202.97.60.7-202.97.60.7, SC
        [ 0xCA613C08, 0xCA613C0F, "SH" ],  // 202.97.60.8-202.97.60.15, SH
        [ 0xCA613C10, 0xCA613C1F, "GD" ],  // 202.97.60.16-202.97.60.31, GD
        [ 0xCA613C20, 0xCA613C27, "SH" ],  // 202.97.60.32-202.97.60.39, SH
        [ 0xCA613C28, 0xCA613C37, "GD" ],  // 202.97.60.40-202.97.60.55, GD
        [ 0xCA613C38, 0xCA613C3B, "SH" ],  // 202.97.60.56-202.97.60.59, SH
        [ 0xCA613C3C, 0xCA613C41, "GD" ],  // 202.97.60.60-202.97.60.65, GD
        [ 0xCA613C42, 0xCA613C43, "LN" ],  // 202.97.60.66-202.97.60.67, LN
        [ 0xCA613C44, 0xCA613C45, "GD" ],  // 202.97.60.68-202.97.60.69, GD
        [ 0xCA613C46, 0xCA613C47, "LN" ],  // 202.97.60.70-202.97.60.71, LN
        [ 0xCA613C48, 0xCA613C49, "SH" ],  // 202.97.60.72-202.97.60.73, SH
        [ 0xCA613C4A, 0xCA613C4A, "GD" ],  // 202.97.60.74-202.97.60.74, GD
        [ 0xCA613C4B, 0xCA613C4B, "SH" ],  // 202.97.60.75-202.97.60.75, SH
        [ 0xCA613C4C, 0xCA613C5B, "GD" ],  // 202.97.60.76-202.97.60.91, GD
        [ 0xCA613C5C, 0xCA613C63, "SH" ],  // 202.97.60.92-202.97.60.99, SH
        [ 0xCA613C64, 0xCA613C77, "JS" ],  // 202.97.60.100-202.97.60.119, JS
        [ 0xCA613C78, 0xCA613C80, "GD" ],  // 202.97.60.120-202.97.60.128, GD
        [ 0xCA613C81, 0xCA613C81, "BJ" ],  // 202.97.60.129-202.97.60.129, BJ
        [ 0xCA613C82, 0xCA613C82, "SH" ],  // 202.97.60.130-202.97.60.130, SH
        [ 0xCA613C83, 0xCA613C83, "GD" ],  // 202.97.60.131-202.97.60.131, GD
        [ 0xCA613C84, 0xCA613C85, "SC" ],  // 202.97.60.132-202.97.60.133, SC
        [ 0xCA613C86, 0xCA613C86, "SH" ],  // 202.97.60.134-202.97.60.134, SH
        [ 0xCA613C87, 0xCA613C8B, "SC" ],  // 202.97.60.135-202.97.60.139, SC
        [ 0xCA613C8C, 0xCA613C93, "GD" ],  // 202.97.60.140-202.97.60.147, GD
        [ 0xCA613C94, 0xCA613C9B, "FJ" ],  // 202.97.60.148-202.97.60.155, FJ
        [ 0xCA613C9C, 0xCA613C9F, "GD" ],  // 202.97.60.156-202.97.60.159, GD
        [ 0xCA613CA0, 0xCA613CA1, "SN" ],  // 202.97.60.160-202.97.60.161, SN
        [ 0xCA613CA2, 0xCA613CA2, "SH" ],  // 202.97.60.162-202.97.60.162, SH
        [ 0xCA613CA3, 0xCA613CA7, "SN" ],  // 202.97.60.163-202.97.60.167, SN
        [ 0xCA613CA8, 0xCA613CB9, "GD" ],  // 202.97.60.168-202.97.60.185, GD
        [ 0xCA613CBA, 0xCA613CBA, "SH" ],  // 202.97.60.186-202.97.60.186, SH
        [ 0xCA613CBB, 0xCA613CC7, "GD" ],  // 202.97.60.187-202.97.60.199, GD
        [ 0xCA613CC8, 0xCA613CCB, "HB" ],  // 202.97.60.200-202.97.60.203, HB
        [ 0xCA613CCC, 0xCA613CD3, "GD" ],  // 202.97.60.204-202.97.60.211, GD
        [ 0xCA613CD4, 0xCA613CD4, "SH" ],  // 202.97.60.212-202.97.60.212, SH
        [ 0xCA613CD5, 0xCA613CD5, "GD" ],  // 202.97.60.213-202.97.60.213, GD
        [ 0xCA613CD6, 0xCA613CD7, "SH" ],  // 202.97.60.214-202.97.60.215, SH
        [ 0xCA613CD8, 0xCA613CDB, "GD" ],  // 202.97.60.216-202.97.60.219, GD
        [ 0xCA613CDC, 0xCA613CDC, "SH" ],  // 202.97.60.220-202.97.60.220, SH
        [ 0xCA613CDD, 0xCA613CDD, "GD" ],  // 202.97.60.221-202.97.60.221, GD
        [ 0xCA613CDE, 0xCA613CDF, "SH" ],  // 202.97.60.222-202.97.60.223, SH
        [ 0xCA613CE0, 0xCA613CEB, "GD" ],  // 202.97.60.224-202.97.60.235, GD
        [ 0xCA613CEC, 0xCA613CEC, "SH" ],  // 202.97.60.236-202.97.60.236, SH
        [ 0xCA613CED, 0xCA613CED, "GD" ],  // 202.97.60.237-202.97.60.237, GD
        [ 0xCA613CEE, 0xCA613CEF, "SH" ],  // 202.97.60.238-202.97.60.239, SH
        [ 0xCA613CF0, 0xCA613CF1, "GD" ],  // 202.97.60.240-202.97.60.241, GD
        [ 0xCA613CF2, 0xCA613CF3, "SH" ],  // 202.97.60.242-202.97.60.243, SH
        [ 0xCA613CF4, 0xCA613CF5, "GD" ],  // 202.97.60.244-202.97.60.245, GD
        [ 0xCA613CF6, 0xCA613CF8, "SH" ],  // 202.97.60.246-202.97.60.248, SH
        [ 0xCA613CF9, 0xCA613CF9, "GD" ],  // 202.97.60.249-202.97.60.249, GD
        [ 0xCA613CFA, 0xCA613CFC, "SH" ],  // 202.97.60.250-202.97.60.252, SH
        [ 0xCA613CFD, 0xCA613CFD, "GD" ],  // 202.97.60.253-202.97.60.253, GD
        [ 0xCA613CFE, 0xCA613D01, "SH" ],  // 202.97.60.254-202.97.61.1, SH
        [ 0xCA613D02, 0xCA613D02, "BJ" ],  // 202.97.61.2-202.97.61.2, BJ
        [ 0xCA613D03, 0xCA613D11, "SH" ],  // 202.97.61.3-202.97.61.17, SH
        [ 0xCA613D12, 0xCA613D12, "BJ" ],  // 202.97.61.18-202.97.61.18, BJ
        [ 0xCA613D13, 0xCA613D14, "SH" ],  // 202.97.61.19-202.97.61.20, SH
        [ 0xCA613D15, 0xCA613D15, "GD" ],  // 202.97.61.21-202.97.61.21, GD
        [ 0xCA613D16, 0xCA613D16, "BJ" ],  // 202.97.61.22-202.97.61.22, BJ
        [ 0xCA613D17, 0xCA613D18, "SH" ],  // 202.97.61.23-202.97.61.24, SH
        [ 0xCA613D19, 0xCA613D19, "GD" ],  // 202.97.61.25-202.97.61.25, GD
        [ 0xCA613D1A, 0xCA613D1A, "BJ" ],  // 202.97.61.26-202.97.61.26, BJ
        [ 0xCA613D1B, 0xCA613D1D, "GD" ],  // 202.97.61.27-202.97.61.29, GD
        [ 0xCA613D1E, 0xCA613D1E, "BJ" ],  // 202.97.61.30-202.97.61.30, BJ
        [ 0xCA613D1F, 0xCA613D1F, "SH" ],  // 202.97.61.31-202.97.61.31, SH
        [ 0xCA613D20, 0xCA613D21, "GD" ],  // 202.97.61.32-202.97.61.33, GD
        [ 0xCA613D22, 0xCA613D24, "SH" ],  // 202.97.61.34-202.97.61.36, SH
        [ 0xCA613D25, 0xCA613D25, "GD" ],  // 202.97.61.37-202.97.61.37, GD
        [ 0xCA613D26, 0xCA613D2F, "SH" ],  // 202.97.61.38-202.97.61.47, SH
        [ 0xCA613D30, 0xCA613D38, "GD" ],  // 202.97.61.48-202.97.61.56, GD
        [ 0xCA613D39, 0xCA613D39, "SH" ],  // 202.97.61.57-202.97.61.57, SH
        [ 0xCA613D3A, 0xCA613D3C, "GD" ],  // 202.97.61.58-202.97.61.60, GD
        [ 0xCA613D3D, 0xCA613D3F, "SH" ],  // 202.97.61.61-202.97.61.63, SH
        [ 0xCA613D40, 0xCA613D7F, "BJ" ],  // 202.97.61.64-202.97.61.127, BJ
        [ 0xCA613D80, 0xCA613D81, "SH" ],  // 202.97.61.128-202.97.61.129, SH
        [ 0xCA613D82, 0xCA613D82, "BJ" ],  // 202.97.61.130-202.97.61.130, BJ
        [ 0xCA613D83, 0xCA613D83, "SH" ],  // 202.97.61.131-202.97.61.131, SH
        [ 0xCA613D84, 0xCA613D87, "BJ" ],  // 202.97.61.132-202.97.61.135, BJ
        [ 0xCA613D88, 0xCA613D89, "SH" ],  // 202.97.61.136-202.97.61.137, SH
        [ 0xCA613D8A, 0xCA613D8A, "BJ" ],  // 202.97.61.138-202.97.61.138, BJ
        [ 0xCA613D8B, 0xCA613DAC, "SH" ],  // 202.97.61.139-202.97.61.172, SH
        [ 0xCA613DAD, 0xCA613DAF, "GD" ],  // 202.97.61.173-202.97.61.175, GD
        [ 0xCA613DB0, 0xCA613DB1, "HB" ],  // 202.97.61.176-202.97.61.177, HB
        [ 0xCA613DB2, 0xCA613DB7, "JX" ],  // 202.97.61.178-202.97.61.183, JX
        [ 0xCA613DB8, 0xCA613DB9, "SH" ],  // 202.97.61.184-202.97.61.185, SH
        [ 0xCA613DBA, 0xCA613DBF, "BJ" ],  // 202.97.61.186-202.97.61.191, BJ
        [ 0xCA613DC0, 0xCA613DD3, "SH" ],  // 202.97.61.192-202.97.61.211, SH
        [ 0xCA613DD4, 0xCA613DD5, "HB" ],  // 202.97.61.212-202.97.61.213, HB
        [ 0xCA613DD6, 0xCA613DD7, "HA" ],  // 202.97.61.214-202.97.61.215, HA
        [ 0xCA613DD8, 0xCA613E0F, "GD" ],  // 202.97.61.216-202.97.62.15, GD
        [ 0xCA613E10, 0xCA613E17, "BJ" ],  // 202.97.62.16-202.97.62.23, BJ
        [ 0xCA613E18, 0xCA613E1B, "SH" ],  // 202.97.62.24-202.97.62.27, SH
        [ 0xCA613E1C, 0xCA613E3B, "GD" ],  // 202.97.62.28-202.97.62.59, GD
        [ 0xCA613E3C, 0xCA613E3F, "SH" ],  // 202.97.62.60-202.97.62.63, SH
        [ 0xCA613E40, 0xCA613E40, "GD" ],  // 202.97.62.64-202.97.62.64, GD
        [ 0xCA613E41, 0xCA613E41, "BJ" ],  // 202.97.62.65-202.97.62.65, BJ
        [ 0xCA613E42, 0xCA613E42, "GD" ],  // 202.97.62.66-202.97.62.66, GD
        [ 0xCA613E43, 0xCA613E46, "BJ" ],  // 202.97.62.67-202.97.62.70, BJ
        [ 0xCA613E47, 0xCA613E47, "GD" ],  // 202.97.62.71-202.97.62.71, GD
        [ 0xCA613E48, 0xCA613E75, "SH" ],  // 202.97.62.72-202.97.62.117, SH
        [ 0xCA613E76, 0xCA613E76, "GD" ],  // 202.97.62.118-202.97.62.118, GD
        [ 0xCA613E77, 0xCA613E7B, "SH" ],  // 202.97.62.119-202.97.62.123, SH
        [ 0xCA613E7C, 0xCA613E8A, "BJ" ],  // 202.97.62.124-202.97.62.138, BJ
        [ 0xCA613E8B, 0xCA613E8B, "GD" ],  // 202.97.62.139-202.97.62.139, GD
        [ 0xCA613E8C, 0xCA613E93, "SN" ],  // 202.97.62.140-202.97.62.147, SN
        [ 0xCA613E94, 0xCA613E9B, "SH" ],  // 202.97.62.148-202.97.62.155, SH
        [ 0xCA613E9C, 0xCA613EA3, "GD" ],  // 202.97.62.156-202.97.62.163, GD
        [ 0xCA613EA4, 0xCA613EBB, "BJ" ],  // 202.97.62.164-202.97.62.187, BJ
        [ 0xCA613EBC, 0xCA613EC3, "GD" ],  // 202.97.62.188-202.97.62.195, GD
        [ 0xCA613EC4, 0xCA613EFF, "BJ" ],  // 202.97.62.196-202.97.62.255, BJ
        [ 0xCA613F00, 0xCA613F3F, "SN" ],  // 202.97.63.0-202.97.63.63, SN
        [ 0xCA613F40, 0xCA613F6F, "GD" ],  // 202.97.63.64-202.97.63.111, GD
        [ 0xCA613F70, 0xCA613F77, "SH" ],  // 202.97.63.112-202.97.63.119, SH
        [ 0xCA613F78, 0xCA613F7F, "GD" ],  // 202.97.63.120-202.97.63.127, GD
        [ 0xCA613F80, 0xCA613F9B, "SH" ],  // 202.97.63.128-202.97.63.155, SH
        [ 0xCA613F9C, 0xCA613F9D, "GD" ],  // 202.97.63.156-202.97.63.157, GD
        [ 0xCA613F9E, 0xCA613F9E, "SH" ],  // 202.97.63.158-202.97.63.158, SH
        [ 0xCA613F9F, 0xCA613F9F, "GD" ],  // 202.97.63.159-202.97.63.159, GD
        [ 0xCA613FA0, 0xCA613FA7, "SH" ],  // 202.97.63.160-202.97.63.167, SH
        [ 0xCA613FA8, 0xCA614004, "GD" ],  // 202.97.63.168-202.97.64.4, GD
        [ 0xCA614005, 0xCA614005, "HB" ],  // 202.97.64.5-202.97.64.5, HB
        [ 0xCA614006, 0xCA614008, "GD" ],  // 202.97.64.6-202.97.64.8, GD
        [ 0xCA614009, 0xCA614009, "HB" ],  // 202.97.64.9-202.97.64.9, HB
        [ 0xCA61400A, 0xCA61400C, "GD" ],  // 202.97.64.10-202.97.64.12, GD
        [ 0xCA61400D, 0xCA61400D, "HB" ],  // 202.97.64.13-202.97.64.13, HB
        [ 0xCA61400E, 0xCA61402C, "GD" ],  // 202.97.64.14-202.97.64.44, GD
        [ 0xCA61402D, 0xCA61402D, "HB" ],  // 202.97.64.45-202.97.64.45, HB
        [ 0xCA61402E, 0xCA614038, "GD" ],  // 202.97.64.46-202.97.64.56, GD
        [ 0xCA614039, 0xCA614039, "FJ" ],  // 202.97.64.57-202.97.64.57, FJ
        [ 0xCA61403A, 0xCA61403A, "HB" ],  // 202.97.64.58-202.97.64.58, HB
        [ 0xCA61403B, 0xCA614061, "GD" ],  // 202.97.64.59-202.97.64.97, GD
        [ 0xCA614062, 0xCA614062, "HB" ],  // 202.97.64.98-202.97.64.98, HB
        [ 0xCA614063, 0xCA614069, "GD" ],  // 202.97.64.99-202.97.64.105, GD
        [ 0xCA61406A, 0xCA61406A, "HB" ],  // 202.97.64.106-202.97.64.106, HB
        [ 0xCA61406B, 0xCA61406D, "GD" ],  // 202.97.64.107-202.97.64.109, GD
        [ 0xCA61406E, 0xCA61406E, "JX" ],  // 202.97.64.110-202.97.64.110, JX
        [ 0xCA61406F, 0xCA614080, "GD" ],  // 202.97.64.111-202.97.64.128, GD
        [ 0xCA614081, 0xCA614081, "SC" ],  // 202.97.64.129-202.97.64.129, SC
        [ 0xCA614082, 0xCA614084, "GD" ],  // 202.97.64.130-202.97.64.132, GD
        [ 0xCA614085, 0xCA614085, "SC" ],  // 202.97.64.133-202.97.64.133, SC
        [ 0xCA614086, 0xCA614087, "GD" ],  // 202.97.64.134-202.97.64.135, GD
        [ 0xCA614088, 0xCA614088, "JS" ],  // 202.97.64.136-202.97.64.136, JS
        [ 0xCA614089, 0xCA614089, "SC" ],  // 202.97.64.137-202.97.64.137, SC
        [ 0xCA61408A, 0xCA61408C, "GD" ],  // 202.97.64.138-202.97.64.140, GD
        [ 0xCA61408D, 0xCA61408D, "SC" ],  // 202.97.64.141-202.97.64.141, SC
        [ 0xCA61408E, 0xCA614090, "GD" ],  // 202.97.64.142-202.97.64.144, GD
        [ 0xCA614091, 0xCA614091, "SC" ],  // 202.97.64.145-202.97.64.145, SC
        [ 0xCA614092, 0xCA614092, "HB" ],  // 202.97.64.146-202.97.64.146, HB
        [ 0xCA614093, 0xCA614098, "GD" ],  // 202.97.64.147-202.97.64.152, GD
        [ 0xCA614099, 0xCA614099, "SC" ],  // 202.97.64.153-202.97.64.153, SC
        [ 0xCA61409A, 0xCA61409C, "GD" ],  // 202.97.64.154-202.97.64.156, GD
        [ 0xCA61409D, 0xCA61409D, "SC" ],  // 202.97.64.157-202.97.64.157, SC
        [ 0xCA61409E, 0xCA6140A0, "GD" ],  // 202.97.64.158-202.97.64.160, GD
        [ 0xCA6140A1, 0xCA6140A1, "JS" ],  // 202.97.64.161-202.97.64.161, JS
        [ 0xCA6140A2, 0xCA6140A4, "GD" ],  // 202.97.64.162-202.97.64.164, GD
        [ 0xCA6140A5, 0xCA6140A5, "JS" ],  // 202.97.64.165-202.97.64.165, JS
        [ 0xCA6140A6, 0xCA6140A8, "GD" ],  // 202.97.64.166-202.97.64.168, GD
        [ 0xCA6140A9, 0xCA6140A9, "SH" ],  // 202.97.64.169-202.97.64.169, SH
        [ 0xCA6140AA, 0xCA6140AC, "GD" ],  // 202.97.64.170-202.97.64.172, GD
        [ 0xCA6140AD, 0xCA6140AD, "SH" ],  // 202.97.64.173-202.97.64.173, SH
        [ 0xCA6140AE, 0xCA6140B0, "GD" ],  // 202.97.64.174-202.97.64.176, GD
        [ 0xCA6140B1, 0xCA6140B1, "FJ" ],  // 202.97.64.177-202.97.64.177, FJ
        [ 0xCA6140B2, 0xCA6140B2, "HB" ],  // 202.97.64.178-202.97.64.178, HB
        [ 0xCA6140B3, 0xCA6140C0, "GD" ],  // 202.97.64.179-202.97.64.192, GD
        [ 0xCA6140C1, 0xCA6140C5, "HB" ],  // 202.97.64.193-202.97.64.197, HB
        [ 0xCA6140C6, 0xCA6140C8, "GD" ],  // 202.97.64.198-202.97.64.200, GD
        [ 0xCA6140C9, 0xCA6140C9, "HB" ],  // 202.97.64.201-202.97.64.201, HB
        [ 0xCA6140CA, 0xCA6140CC, "GD" ],  // 202.97.64.202-202.97.64.204, GD
        [ 0xCA6140CD, 0xCA6140CD, "HB" ],  // 202.97.64.205-202.97.64.205, HB
        [ 0xCA6140CE, 0xCA6140D0, "GD" ],  // 202.97.64.206-202.97.64.208, GD
        [ 0xCA6140D1, 0xCA6140D2, "HB" ],  // 202.97.64.209-202.97.64.210, HB
        [ 0xCA6140D3, 0xCA6140F0, "GD" ],  // 202.97.64.211-202.97.64.240, GD
        [ 0xCA6140F1, 0xCA6140F1, "HB" ],  // 202.97.64.241-202.97.64.241, HB
        [ 0xCA6140F2, 0xCA6140F4, "GD" ],  // 202.97.64.242-202.97.64.244, GD
        [ 0xCA6140F5, 0xCA6140F5, "HB" ],  // 202.97.64.245-202.97.64.245, HB
        [ 0xCA6140F6, 0xCA6140F7, "GD" ],  // 202.97.64.246-202.97.64.247, GD
        [ 0xCA6140F8, 0xCA6140F8, "NM" ],  // 202.97.64.248-202.97.64.248, NM
        [ 0xCA6140F9, 0xCA6140F9, "HB" ],  // 202.97.64.249-202.97.64.249, HB
        [ 0xCA6140FA, 0xCA6140FF, "SC" ],  // 202.97.64.250-202.97.64.255, SC
        [ 0xCA614100, 0xCA6141FF, "JX" ],  // 202.97.65.0-202.97.65.255, JX
        [ 0xCA614200, 0xCA614204, "GX" ],  // 202.97.66.0-202.97.66.4, GX
        [ 0xCA614205, 0xCA614205, "JS" ],  // 202.97.66.5-202.97.66.5, JS
        [ 0xCA614206, 0xCA614206, "SC" ],  // 202.97.66.6-202.97.66.6, SC
        [ 0xCA614207, 0xCA614209, "GX" ],  // 202.97.66.7-202.97.66.9, GX
        [ 0xCA61420A, 0xCA61420A, "SC" ],  // 202.97.66.10-202.97.66.10, SC
        [ 0xCA61420B, 0xCA61420C, "GX" ],  // 202.97.66.11-202.97.66.12, GX
        [ 0xCA61420D, 0xCA61420D, "JS" ],  // 202.97.66.13-202.97.66.13, JS
        [ 0xCA61420E, 0xCA61420E, "SC" ],  // 202.97.66.14-202.97.66.14, SC
        [ 0xCA61420F, 0xCA614211, "GX" ],  // 202.97.66.15-202.97.66.17, GX
        [ 0xCA614212, 0xCA614212, "SC" ],  // 202.97.66.18-202.97.66.18, SC
        [ 0xCA614213, 0xCA614217, "GX" ],  // 202.97.66.19-202.97.66.23, GX
        [ 0xCA614218, 0xCA614219, "FJ" ],  // 202.97.66.24-202.97.66.25, FJ
        [ 0xCA61421A, 0xCA61421A, "GD" ],  // 202.97.66.26-202.97.66.26, GD
        [ 0xCA61421B, 0xCA614221, "FJ" ],  // 202.97.66.27-202.97.66.33, FJ
        [ 0xCA614222, 0xCA614222, "GD" ],  // 202.97.66.34-202.97.66.34, GD
        [ 0xCA614223, 0xCA6142FF, "FJ" ],  // 202.97.66.35-202.97.66.255, FJ
        [ 0xCA614300, 0xCA6143FF, "HA" ],  // 202.97.67.0-202.97.67.255, HA
        [ 0xCA614400, 0xCA6144FF, "ZJ" ],  // 202.97.68.0-202.97.68.255, ZJ
        [ 0xCA614500, 0xCA6145FF, "GZ" ],  // 202.97.69.0-202.97.69.255, GZ
        [ 0xCA614600, 0xCA6146FF, "SC" ],  // 202.97.70.0-202.97.70.255, SC
        [ 0xCA614700, 0xCA6147FF, "ZJ" ],  // 202.97.71.0-202.97.71.255, ZJ
        [ 0xCA614800, 0xCA614812, "XJ" ],  // 202.97.72.0-202.97.72.18, XJ
        [ 0xCA614813, 0xCA614815, "SX" ],  // 202.97.72.19-202.97.72.21, SX
        [ 0xCA614816, 0xCA614818, "XJ" ],  // 202.97.72.22-202.97.72.24, XJ
        [ 0xCA614819, 0xCA614819, "SN" ],  // 202.97.72.25-202.97.72.25, SN
        [ 0xCA61481A, 0xCA61481A, "XJ" ],  // 202.97.72.26-202.97.72.26, XJ
        [ 0xCA61481B, 0xCA61481C, "SX" ],  // 202.97.72.27-202.97.72.28, SX
        [ 0xCA61481D, 0xCA61481D, "SN" ],  // 202.97.72.29-202.97.72.29, SN
        [ 0xCA61481E, 0xCA61481E, "XJ" ],  // 202.97.72.30-202.97.72.30, XJ
        [ 0xCA61481F, 0xCA614820, "SX" ],  // 202.97.72.31-202.97.72.32, SX
        [ 0xCA614821, 0xCA614821, "SN" ],  // 202.97.72.33-202.97.72.33, SN
        [ 0xCA614822, 0xCA614822, "XJ" ],  // 202.97.72.34-202.97.72.34, XJ
        [ 0xCA614823, 0xCA614825, "SX" ],  // 202.97.72.35-202.97.72.37, SX
        [ 0xCA614826, 0xCA614826, "JL" ],  // 202.97.72.38-202.97.72.38, JL
        [ 0xCA614827, 0xCA614828, "SX" ],  // 202.97.72.39-202.97.72.40, SX
        [ 0xCA614829, 0xCA614829, "SN" ],  // 202.97.72.41-202.97.72.41, SN
        [ 0xCA61482A, 0xCA61482A, "XJ" ],  // 202.97.72.42-202.97.72.42, XJ
        [ 0xCA61482B, 0xCA61482C, "SX" ],  // 202.97.72.43-202.97.72.44, SX
        [ 0xCA61482D, 0xCA61482D, "SN" ],  // 202.97.72.45-202.97.72.45, SN
        [ 0xCA61482E, 0xCA61482F, "JL" ],  // 202.97.72.46-202.97.72.47, JL
        [ 0xCA614830, 0xCA614830, "SX" ],  // 202.97.72.48-202.97.72.48, SX
        [ 0xCA614831, 0xCA614831, "SN" ],  // 202.97.72.49-202.97.72.49, SN
        [ 0xCA614832, 0xCA614832, "XJ" ],  // 202.97.72.50-202.97.72.50, XJ
        [ 0xCA614833, 0xCA614834, "SX" ],  // 202.97.72.51-202.97.72.52, SX
        [ 0xCA614835, 0xCA614835, "SN" ],  // 202.97.72.53-202.97.72.53, SN
        [ 0xCA614836, 0xCA614836, "XJ" ],  // 202.97.72.54-202.97.72.54, XJ
        [ 0xCA614837, 0xCA614844, "SX" ],  // 202.97.72.55-202.97.72.68, SX
        [ 0xCA614845, 0xCA614845, "SN" ],  // 202.97.72.69-202.97.72.69, SN
        [ 0xCA614846, 0xCA614846, "XJ" ],  // 202.97.72.70-202.97.72.70, XJ
        [ 0xCA614847, 0xCA614847, "SX" ],  // 202.97.72.71-202.97.72.71, SX
        [ 0xCA614848, 0xCA614853, "XJ" ],  // 202.97.72.72-202.97.72.83, XJ
        [ 0xCA614854, 0xCA614855, "SX" ],  // 202.97.72.84-202.97.72.85, SX
        [ 0xCA614856, 0xCA614856, "XJ" ],  // 202.97.72.86-202.97.72.86, XJ
        [ 0xCA614857, 0xCA614859, "SX" ],  // 202.97.72.87-202.97.72.89, SX
        [ 0xCA61485A, 0xCA61485A, "XJ" ],  // 202.97.72.90-202.97.72.90, XJ
        [ 0xCA61485B, 0xCA61485D, "SX" ],  // 202.97.72.91-202.97.72.93, SX
        [ 0xCA61485E, 0xCA61485E, "XJ" ],  // 202.97.72.94-202.97.72.94, XJ
        [ 0xCA61485F, 0xCA614860, "SX" ],  // 202.97.72.95-202.97.72.96, SX
        [ 0xCA614861, 0xCA614861, "SN" ],  // 202.97.72.97-202.97.72.97, SN
        [ 0xCA614862, 0xCA614862, "XJ" ],  // 202.97.72.98-202.97.72.98, XJ
        [ 0xCA614863, 0xCA614864, "SX" ],  // 202.97.72.99-202.97.72.100, SX
        [ 0xCA614865, 0xCA614865, "SN" ],  // 202.97.72.101-202.97.72.101, SN
        [ 0xCA614866, 0xCA614868, "SX" ],  // 202.97.72.102-202.97.72.104, SX
        [ 0xCA614869, 0xCA614869, "SN" ],  // 202.97.72.105-202.97.72.105, SN
        [ 0xCA61486A, 0xCA61486C, "SX" ],  // 202.97.72.106-202.97.72.108, SX
        [ 0xCA61486D, 0xCA61486D, "SN" ],  // 202.97.72.109-202.97.72.109, SN
        [ 0xCA61486E, 0xCA61486E, "XJ" ],  // 202.97.72.110-202.97.72.110, XJ
        [ 0xCA61486F, 0xCA614870, "SX" ],  // 202.97.72.111-202.97.72.112, SX
        [ 0xCA614871, 0xCA614871, "SN" ],  // 202.97.72.113-202.97.72.113, SN
        [ 0xCA614872, 0xCA614872, "XJ" ],  // 202.97.72.114-202.97.72.114, XJ
        [ 0xCA614873, 0xCA614874, "SX" ],  // 202.97.72.115-202.97.72.116, SX
        [ 0xCA614875, 0xCA614875, "SN" ],  // 202.97.72.117-202.97.72.117, SN
        [ 0xCA614876, 0xCA614878, "SX" ],  // 202.97.72.118-202.97.72.120, SX
        [ 0xCA614879, 0xCA614879, "SN" ],  // 202.97.72.121-202.97.72.121, SN
        [ 0xCA61487A, 0xCA61487C, "SX" ],  // 202.97.72.122-202.97.72.124, SX
        [ 0xCA61487D, 0xCA61487D, "SN" ],  // 202.97.72.125-202.97.72.125, SN
        [ 0xCA61487E, 0xCA614880, "SX" ],  // 202.97.72.126-202.97.72.128, SX
        [ 0xCA614881, 0xCA614881, "SN" ],  // 202.97.72.129-202.97.72.129, SN
        [ 0xCA614882, 0xCA614884, "SX" ],  // 202.97.72.130-202.97.72.132, SX
        [ 0xCA614885, 0xCA614885, "SN" ],  // 202.97.72.133-202.97.72.133, SN
        [ 0xCA614886, 0xCA614886, "XJ" ],  // 202.97.72.134-202.97.72.134, XJ
        [ 0xCA614887, 0xCA614888, "SX" ],  // 202.97.72.135-202.97.72.136, SX
        [ 0xCA614889, 0xCA614889, "SN" ],  // 202.97.72.137-202.97.72.137, SN
        [ 0xCA61488A, 0xCA61488C, "SX" ],  // 202.97.72.138-202.97.72.140, SX
        [ 0xCA61488D, 0xCA61488D, "SN" ],  // 202.97.72.141-202.97.72.141, SN
        [ 0xCA61488E, 0xCA61488E, "XJ" ],  // 202.97.72.142-202.97.72.142, XJ
        [ 0xCA61488F, 0xCA614890, "SX" ],  // 202.97.72.143-202.97.72.144, SX
        [ 0xCA614891, 0xCA614891, "SN" ],  // 202.97.72.145-202.97.72.145, SN
        [ 0xCA614892, 0xCA614894, "SX" ],  // 202.97.72.146-202.97.72.148, SX
        [ 0xCA614895, 0xCA614895, "SN" ],  // 202.97.72.149-202.97.72.149, SN
        [ 0xCA614896, 0xCA614898, "SX" ],  // 202.97.72.150-202.97.72.152, SX
        [ 0xCA614899, 0xCA614899, "SN" ],  // 202.97.72.153-202.97.72.153, SN
        [ 0xCA61489A, 0xCA61489C, "SX" ],  // 202.97.72.154-202.97.72.156, SX
        [ 0xCA61489D, 0xCA61489D, "SN" ],  // 202.97.72.157-202.97.72.157, SN
        [ 0xCA61489E, 0xCA61489E, "XJ" ],  // 202.97.72.158-202.97.72.158, XJ
        [ 0xCA61489F, 0xCA6148A0, "SX" ],  // 202.97.72.159-202.97.72.160, SX
        [ 0xCA6148A1, 0xCA6148A1, "SN" ],  // 202.97.72.161-202.97.72.161, SN
        [ 0xCA6148A2, 0xCA6148A2, "XJ" ],  // 202.97.72.162-202.97.72.162, XJ
        [ 0xCA6148A3, 0xCA6148A4, "SX" ],  // 202.97.72.163-202.97.72.164, SX
        [ 0xCA6148A5, 0xCA6148A5, "SN" ],  // 202.97.72.165-202.97.72.165, SN
        [ 0xCA6148A6, 0xCA6148A8, "SX" ],  // 202.97.72.166-202.97.72.168, SX
        [ 0xCA6148A9, 0xCA6148A9, "SN" ],  // 202.97.72.169-202.97.72.169, SN
        [ 0xCA6148AA, 0xCA6148AC, "SX" ],  // 202.97.72.170-202.97.72.172, SX
        [ 0xCA6148AD, 0xCA6148AD, "SN" ],  // 202.97.72.173-202.97.72.173, SN
        [ 0xCA6148AE, 0xCA6148AE, "XJ" ],  // 202.97.72.174-202.97.72.174, XJ
        [ 0xCA6148AF, 0xCA6148B0, "SX" ],  // 202.97.72.175-202.97.72.176, SX
        [ 0xCA6148B1, 0xCA6148B1, "SN" ],  // 202.97.72.177-202.97.72.177, SN
        [ 0xCA6148B2, 0xCA6148B2, "XJ" ],  // 202.97.72.178-202.97.72.178, XJ
        [ 0xCA6148B3, 0xCA6148B4, "SX" ],  // 202.97.72.179-202.97.72.180, SX
        [ 0xCA6148B5, 0xCA6148B5, "SN" ],  // 202.97.72.181-202.97.72.181, SN
        [ 0xCA6148B6, 0xCA6148BC, "SX" ],  // 202.97.72.182-202.97.72.188, SX
        [ 0xCA6148BD, 0xCA6148BD, "SN" ],  // 202.97.72.189-202.97.72.189, SN
        [ 0xCA6148BE, 0xCA6148C1, "SX" ],  // 202.97.72.190-202.97.72.193, SX
        [ 0xCA6148C2, 0xCA6148C2, "GS" ],  // 202.97.72.194-202.97.72.194, GS
        [ 0xCA6148C3, 0xCA6148C5, "SX" ],  // 202.97.72.195-202.97.72.197, SX
        [ 0xCA6148C6, 0xCA6148C6, "GS" ],  // 202.97.72.198-202.97.72.198, GS
        [ 0xCA6148C7, 0xCA6148C8, "SX" ],  // 202.97.72.199-202.97.72.200, SX
        [ 0xCA6148C9, 0xCA6148C9, "SN" ],  // 202.97.72.201-202.97.72.201, SN
        [ 0xCA6148CA, 0xCA6148CC, "SX" ],  // 202.97.72.202-202.97.72.204, SX
        [ 0xCA6148CD, 0xCA6148CD, "SN" ],  // 202.97.72.205-202.97.72.205, SN
        [ 0xCA6148CE, 0xCA6148D0, "SX" ],  // 202.97.72.206-202.97.72.208, SX
        [ 0xCA6148D1, 0xCA6148D1, "SN" ],  // 202.97.72.209-202.97.72.209, SN
        [ 0xCA6148D2, 0xCA6148D4, "SX" ],  // 202.97.72.210-202.97.72.212, SX
        [ 0xCA6148D5, 0xCA6148D5, "SN" ],  // 202.97.72.213-202.97.72.213, SN
        [ 0xCA6148D6, 0xCA6148D9, "SX" ],  // 202.97.72.214-202.97.72.217, SX
        [ 0xCA6148DA, 0xCA6148DB, "JL" ],  // 202.97.72.218-202.97.72.219, JL
        [ 0xCA6148DC, 0xCA6148DD, "SX" ],  // 202.97.72.220-202.97.72.221, SX
        [ 0xCA6148DE, 0xCA6148DE, "JL" ],  // 202.97.72.222-202.97.72.222, JL
        [ 0xCA6148DF, 0xCA614920, "SX" ],  // 202.97.72.223-202.97.73.32, SX
        [ 0xCA614921, 0xCA614921, "GD" ],  // 202.97.73.33-202.97.73.33, GD
        [ 0xCA614922, 0xCA614922, "SX" ],  // 202.97.73.34-202.97.73.34, SX
        [ 0xCA614923, 0xCA614923, "GD" ],  // 202.97.73.35-202.97.73.35, GD
        [ 0xCA614924, 0xCA614936, "ZJ" ],  // 202.97.73.36-202.97.73.54, ZJ
        [ 0xCA614937, 0xCA614937, "GD" ],  // 202.97.73.55-202.97.73.55, GD
        [ 0xCA614938, 0xCA614938, "SN" ],  // 202.97.73.56-202.97.73.56, SN
        [ 0xCA614939, 0xCA61493C, "SX" ],  // 202.97.73.57-202.97.73.60, SX
        [ 0xCA61493D, 0xCA614940, "ZJ" ],  // 202.97.73.61-202.97.73.64, ZJ
        [ 0xCA614941, 0xCA614941, "JS" ],  // 202.97.73.65-202.97.73.65, JS
        [ 0xCA614942, 0xCA614942, "CQ" ],  // 202.97.73.66-202.97.73.66, CQ
        [ 0xCA614943, 0xCA614944, "SX" ],  // 202.97.73.67-202.97.73.68, SX
        [ 0xCA614945, 0xCA614945, "AH" ],  // 202.97.73.69-202.97.73.69, AH
        [ 0xCA614946, 0xCA614946, "CQ" ],  // 202.97.73.70-202.97.73.70, CQ
        [ 0xCA614947, 0xCA614948, "SX" ],  // 202.97.73.71-202.97.73.72, SX
        [ 0xCA614949, 0xCA614949, "GD" ],  // 202.97.73.73-202.97.73.73, GD
        [ 0xCA61494A, 0xCA61494A, "CQ" ],  // 202.97.73.74-202.97.73.74, CQ
        [ 0xCA61494B, 0xCA61494D, "SX" ],  // 202.97.73.75-202.97.73.77, SX
        [ 0xCA61494E, 0xCA61494E, "CQ" ],  // 202.97.73.78-202.97.73.78, CQ
        [ 0xCA61494F, 0xCA61494F, "GD" ],  // 202.97.73.79-202.97.73.79, GD
        [ 0xCA614950, 0xCA614950, "JS" ],  // 202.97.73.80-202.97.73.80, JS
        [ 0xCA614951, 0xCA614951, "AH" ],  // 202.97.73.81-202.97.73.81, AH
        [ 0xCA614952, 0xCA614953, "CQ" ],  // 202.97.73.82-202.97.73.83, CQ
        [ 0xCA614954, 0xCA614954, "SX" ],  // 202.97.73.84-202.97.73.84, SX
        [ 0xCA614955, 0xCA614955, "LN" ],  // 202.97.73.85-202.97.73.85, LN
        [ 0xCA614956, 0xCA614956, "BJ" ],  // 202.97.73.86-202.97.73.86, BJ
        [ 0xCA614957, 0xCA614958, "SX" ],  // 202.97.73.87-202.97.73.88, SX
        [ 0xCA614959, 0xCA614959, "JS" ],  // 202.97.73.89-202.97.73.89, JS
        [ 0xCA61495A, 0xCA61495A, "CQ" ],  // 202.97.73.90-202.97.73.90, CQ
        [ 0xCA61495B, 0xCA61495D, "SX" ],  // 202.97.73.91-202.97.73.93, SX
        [ 0xCA61495E, 0xCA61495E, "CQ" ],  // 202.97.73.94-202.97.73.94, CQ
        [ 0xCA61495F, 0xCA61495F, "GD" ],  // 202.97.73.95-202.97.73.95, GD
        [ 0xCA614960, 0xCA614960, "SX" ],  // 202.97.73.96-202.97.73.96, SX
        [ 0xCA614961, 0xCA614961, "GD" ],  // 202.97.73.97-202.97.73.97, GD
        [ 0xCA614962, 0xCA614962, "CQ" ],  // 202.97.73.98-202.97.73.98, CQ
        [ 0xCA614963, 0xCA614964, "SX" ],  // 202.97.73.99-202.97.73.100, SX
        [ 0xCA614965, 0xCA614965, "GD" ],  // 202.97.73.101-202.97.73.101, GD
        [ 0xCA614966, 0xCA614966, "CQ" ],  // 202.97.73.102-202.97.73.102, CQ
        [ 0xCA614967, 0xCA61496B, "SX" ],  // 202.97.73.103-202.97.73.107, SX
        [ 0xCA61496C, 0xCA61496D, "GD" ],  // 202.97.73.108-202.97.73.109, GD
        [ 0xCA61496E, 0xCA61496E, "CQ" ],  // 202.97.73.110-202.97.73.110, CQ
        [ 0xCA61496F, 0xCA61496F, "SX" ],  // 202.97.73.111-202.97.73.111, SX
        [ 0xCA614970, 0xCA614971, "GD" ],  // 202.97.73.112-202.97.73.113, GD
        [ 0xCA614972, 0xCA614972, "CQ" ],  // 202.97.73.114-202.97.73.114, CQ
        [ 0xCA614973, 0xCA614974, "SX" ],  // 202.97.73.115-202.97.73.116, SX
        [ 0xCA614975, 0xCA614975, "GD" ],  // 202.97.73.117-202.97.73.117, GD
        [ 0xCA614976, 0xCA614977, "CQ" ],  // 202.97.73.118-202.97.73.119, CQ
        [ 0xCA614978, 0xCA614978, "SH" ],  // 202.97.73.120-202.97.73.120, SH
        [ 0xCA614979, 0xCA614979, "GD" ],  // 202.97.73.121-202.97.73.121, GD
        [ 0xCA61497A, 0xCA61497A, "CQ" ],  // 202.97.73.122-202.97.73.122, CQ
        [ 0xCA61497B, 0xCA61497C, "SX" ],  // 202.97.73.123-202.97.73.124, SX
        [ 0xCA61497D, 0xCA61497D, "GD" ],  // 202.97.73.125-202.97.73.125, GD
        [ 0xCA61497E, 0xCA61497E, "CQ" ],  // 202.97.73.126-202.97.73.126, CQ
        [ 0xCA61497F, 0xCA61497F, "SX" ],  // 202.97.73.127-202.97.73.127, SX
        [ 0xCA614980, 0xCA614996, "ZJ" ],  // 202.97.73.128-202.97.73.150, ZJ
        [ 0xCA614997, 0xCA614997, "CQ" ],  // 202.97.73.151-202.97.73.151, CQ
        [ 0xCA614998, 0xCA614999, "SX" ],  // 202.97.73.152-202.97.73.153, SX
        [ 0xCA61499A, 0xCA61499A, "ZJ" ],  // 202.97.73.154-202.97.73.154, ZJ
        [ 0xCA61499B, 0xCA61499B, "SX" ],  // 202.97.73.155-202.97.73.155, SX
        [ 0xCA61499C, 0xCA61499D, "GD" ],  // 202.97.73.156-202.97.73.157, GD
        [ 0xCA61499E, 0xCA61499E, "ZJ" ],  // 202.97.73.158-202.97.73.158, ZJ
        [ 0xCA61499F, 0xCA6149A1, "SX" ],  // 202.97.73.159-202.97.73.161, SX
        [ 0xCA6149A2, 0xCA6149A2, "HA" ],  // 202.97.73.162-202.97.73.162, HA
        [ 0xCA6149A3, 0xCA6149A5, "SN" ],  // 202.97.73.163-202.97.73.165, SN
        [ 0xCA6149A6, 0xCA6149A6, "HA" ],  // 202.97.73.166-202.97.73.166, HA
        [ 0xCA6149A7, 0xCA6149A9, "SX" ],  // 202.97.73.167-202.97.73.169, SX
        [ 0xCA6149AA, 0xCA6149AA, "HA" ],  // 202.97.73.170-202.97.73.170, HA
        [ 0xCA6149AB, 0xCA6149AC, "SX" ],  // 202.97.73.171-202.97.73.172, SX
        [ 0xCA6149AD, 0xCA6149AD, "GD" ],  // 202.97.73.173-202.97.73.173, GD
        [ 0xCA6149AE, 0xCA6149AE, "BJ" ],  // 202.97.73.174-202.97.73.174, BJ
        [ 0xCA6149AF, 0xCA6149AF, "GD" ],  // 202.97.73.175-202.97.73.175, GD
        [ 0xCA6149B0, 0xCA6149B1, "SX" ],  // 202.97.73.176-202.97.73.177, SX
        [ 0xCA6149B2, 0xCA6149B2, "ZJ" ],  // 202.97.73.178-202.97.73.178, ZJ
        [ 0xCA6149B3, 0xCA6149B3, "SX" ],  // 202.97.73.179-202.97.73.179, SX
        [ 0xCA6149B4, 0xCA6149B4, "ZJ" ],  // 202.97.73.180-202.97.73.180, ZJ
        [ 0xCA6149B5, 0xCA6149B5, "GD" ],  // 202.97.73.181-202.97.73.181, GD
        [ 0xCA6149B6, 0xCA6149B6, "ZJ" ],  // 202.97.73.182-202.97.73.182, ZJ
        [ 0xCA6149B7, 0xCA6149B7, "SX" ],  // 202.97.73.183-202.97.73.183, SX
        [ 0xCA6149B8, 0xCA6149B8, "SN" ],  // 202.97.73.184-202.97.73.184, SN
        [ 0xCA6149B9, 0xCA6149BA, "GD" ],  // 202.97.73.185-202.97.73.186, GD
        [ 0xCA6149BB, 0xCA6149BB, "SX" ],  // 202.97.73.187-202.97.73.187, SX
        [ 0xCA6149BC, 0xCA6149BD, "SH" ],  // 202.97.73.188-202.97.73.189, SH
        [ 0xCA6149BE, 0xCA6149BE, "SX" ],  // 202.97.73.190-202.97.73.190, SX
        [ 0xCA6149BF, 0xCA6149BF, "CQ" ],  // 202.97.73.191-202.97.73.191, CQ
        [ 0xCA6149C0, 0xCA6149C0, "SX" ],  // 202.97.73.192-202.97.73.192, SX
        [ 0xCA6149C1, 0xCA6149C1, "SH" ],  // 202.97.73.193-202.97.73.193, SH
        [ 0xCA6149C2, 0xCA6149C2, "SX" ],  // 202.97.73.194-202.97.73.194, SX
        [ 0xCA6149C3, 0xCA6149C3, "SN" ],  // 202.97.73.195-202.97.73.195, SN
        [ 0xCA6149C4, 0xCA6149C4, "SX" ],  // 202.97.73.196-202.97.73.196, SX
        [ 0xCA6149C5, 0xCA6149C5, "GD" ],  // 202.97.73.197-202.97.73.197, GD
        [ 0xCA6149C6, 0xCA6149C7, "SX" ],  // 202.97.73.198-202.97.73.199, SX
        [ 0xCA6149C8, 0xCA6149C9, "GD" ],  // 202.97.73.200-202.97.73.201, GD
        [ 0xCA6149CA, 0xCA6149CA, "BJ" ],  // 202.97.73.202-202.97.73.202, BJ
        [ 0xCA6149CB, 0xCA6149CB, "SH" ],  // 202.97.73.203-202.97.73.203, SH
        [ 0xCA6149CC, 0xCA6149CC, "SN" ],  // 202.97.73.204-202.97.73.204, SN
        [ 0xCA6149CD, 0xCA6149CD, "GD" ],  // 202.97.73.205-202.97.73.205, GD
        [ 0xCA6149CE, 0xCA6149CE, "GX" ],  // 202.97.73.206-202.97.73.206, GX
        [ 0xCA6149CF, 0xCA6149D0, "SX" ],  // 202.97.73.207-202.97.73.208, SX
        [ 0xCA6149D1, 0xCA6149D1, "GD" ],  // 202.97.73.209-202.97.73.209, GD
        [ 0xCA6149D2, 0xCA6149D4, "SX" ],  // 202.97.73.210-202.97.73.212, SX
        [ 0xCA6149D5, 0xCA6149D6, "SN" ],  // 202.97.73.213-202.97.73.214, SN
        [ 0xCA6149D7, 0xCA6149D8, "SX" ],  // 202.97.73.215-202.97.73.216, SX
        [ 0xCA6149D9, 0xCA6149D9, "SN" ],  // 202.97.73.217-202.97.73.217, SN
        [ 0xCA6149DA, 0xCA6149DB, "SX" ],  // 202.97.73.218-202.97.73.219, SX
        [ 0xCA6149DC, 0xCA6149DC, "CQ" ],  // 202.97.73.220-202.97.73.220, CQ
        [ 0xCA6149DD, 0xCA6149DD, "SN" ],  // 202.97.73.221-202.97.73.221, SN
        [ 0xCA6149DE, 0xCA6149DF, "SX" ],  // 202.97.73.222-202.97.73.223, SX
        [ 0xCA6149E0, 0xCA6149E0, "GX" ],  // 202.97.73.224-202.97.73.224, GX
        [ 0xCA6149E1, 0xCA6149EE, "SX" ],  // 202.97.73.225-202.97.73.238, SX
        [ 0xCA6149EF, 0xCA6149EF, "GD" ],  // 202.97.73.239-202.97.73.239, GD
        [ 0xCA6149F0, 0xCA6149F0, "SX" ],  // 202.97.73.240-202.97.73.240, SX
        [ 0xCA6149F1, 0xCA6149F1, "SN" ],  // 202.97.73.241-202.97.73.241, SN
        [ 0xCA6149F2, 0xCA6149F4, "SX" ],  // 202.97.73.242-202.97.73.244, SX
        [ 0xCA6149F5, 0xCA6149F5, "SN" ],  // 202.97.73.245-202.97.73.245, SN
        [ 0xCA6149F6, 0xCA6149F8, "SX" ],  // 202.97.73.246-202.97.73.248, SX
        [ 0xCA6149F9, 0xCA6149F9, "SN" ],  // 202.97.73.249-202.97.73.249, SN
        [ 0xCA6149FA, 0xCA6149FC, "SX" ],  // 202.97.73.250-202.97.73.252, SX
        [ 0xCA6149FD, 0xCA6149FD, "SN" ],  // 202.97.73.253-202.97.73.253, SN
        [ 0xCA6149FE, 0xCA6149FE, "SX" ],  // 202.97.73.254-202.97.73.254, SX
        [ 0xCA6149FF, 0xCA6149FF, "SN" ],  // 202.97.73.255-202.97.73.255, SN
        [ 0xCA614A00, 0xCA614AFF, "GX" ],  // 202.97.74.0-202.97.74.255, GX
        [ 0xCA614B00, 0xCA614BFF, "JX" ],  // 202.97.75.0-202.97.75.255, JX
        [ 0xCA614C00, 0xCA614C01, "HB" ],  // 202.97.76.0-202.97.76.1, HB
        [ 0xCA614C02, 0xCA614C04, "YN" ],  // 202.97.76.2-202.97.76.4, YN
        [ 0xCA614C05, 0xCA614C05, "HB" ],  // 202.97.76.5-202.97.76.5, HB
        [ 0xCA614C06, 0xCA614C08, "YN" ],  // 202.97.76.6-202.97.76.8, YN
        [ 0xCA614C09, 0xCA614C09, "HB" ],  // 202.97.76.9-202.97.76.9, HB
        [ 0xCA614C0A, 0xCA614C0B, "YN" ],  // 202.97.76.10-202.97.76.11, YN
        [ 0xCA614C0C, 0xCA614C0D, "HB" ],  // 202.97.76.12-202.97.76.13, HB
        [ 0xCA614C0E, 0xCA614C0F, "YN" ],  // 202.97.76.14-202.97.76.15, YN
        [ 0xCA614C10, 0xCA614C11, "GD" ],  // 202.97.76.16-202.97.76.17, GD
        [ 0xCA614C12, 0xCA614C14, "YN" ],  // 202.97.76.18-202.97.76.20, YN
        [ 0xCA614C15, 0xCA614C15, "GD" ],  // 202.97.76.21-202.97.76.21, GD
        [ 0xCA614C16, 0xCA614C18, "YN" ],  // 202.97.76.22-202.97.76.24, YN
        [ 0xCA614C19, 0xCA614C19, "GD" ],  // 202.97.76.25-202.97.76.25, GD
        [ 0xCA614C1A, 0xCA614C1C, "YN" ],  // 202.97.76.26-202.97.76.28, YN
        [ 0xCA614C1D, 0xCA614C1D, "GD" ],  // 202.97.76.29-202.97.76.29, GD
        [ 0xCA614C1E, 0xCA614C20, "YN" ],  // 202.97.76.30-202.97.76.32, YN
        [ 0xCA614C21, 0xCA614C21, "SC" ],  // 202.97.76.33-202.97.76.33, SC
        [ 0xCA614C22, 0xCA614C24, "YN" ],  // 202.97.76.34-202.97.76.36, YN
        [ 0xCA614C25, 0xCA614C25, "SC" ],  // 202.97.76.37-202.97.76.37, SC
        [ 0xCA614C26, 0xCA614C27, "YN" ],  // 202.97.76.38-202.97.76.39, YN
        [ 0xCA614C28, 0xCA614C29, "SC" ],  // 202.97.76.40-202.97.76.41, SC
        [ 0xCA614C2A, 0xCA614C2C, "YN" ],  // 202.97.76.42-202.97.76.44, YN
        [ 0xCA614C2D, 0xCA614C2D, "SC" ],  // 202.97.76.45-202.97.76.45, SC
        [ 0xCA614C2E, 0xCA614C2F, "YN" ],  // 202.97.76.46-202.97.76.47, YN
        [ 0xCA614C30, 0xCA614C31, "SN" ],  // 202.97.76.48-202.97.76.49, SN
        [ 0xCA614C32, 0xCA614C33, "YN" ],  // 202.97.76.50-202.97.76.51, YN
        [ 0xCA614C34, 0xCA614C34, "SN" ],  // 202.97.76.52-202.97.76.52, SN
        [ 0xCA614C35, 0xCA614C35, "HB" ],  // 202.97.76.53-202.97.76.53, HB
        [ 0xCA614C36, 0xCA614C37, "YN" ],  // 202.97.76.54-202.97.76.55, YN
        [ 0xCA614C38, 0xCA614C39, "HB" ],  // 202.97.76.56-202.97.76.57, HB
        [ 0xCA614C3A, 0xCA614C3B, "YN" ],  // 202.97.76.58-202.97.76.59, YN
        [ 0xCA614C3C, 0xCA614C3D, "HB" ],  // 202.97.76.60-202.97.76.61, HB
        [ 0xCA614C3E, 0xCA614C3F, "YN" ],  // 202.97.76.62-202.97.76.63, YN
        [ 0xCA614C40, 0xCA614C41, "JS" ],  // 202.97.76.64-202.97.76.65, JS
        [ 0xCA614C42, 0xCA614C43, "YN" ],  // 202.97.76.66-202.97.76.67, YN
        [ 0xCA614C44, 0xCA614C45, "JS" ],  // 202.97.76.68-202.97.76.69, JS
        [ 0xCA614C46, 0xCA614C48, "YN" ],  // 202.97.76.70-202.97.76.72, YN
        [ 0xCA614C49, 0xCA614C49, "JS" ],  // 202.97.76.73-202.97.76.73, JS
        [ 0xCA614C4A, 0xCA614C4B, "YN" ],  // 202.97.76.74-202.97.76.75, YN
        [ 0xCA614C4C, 0xCA614C4D, "JS" ],  // 202.97.76.76-202.97.76.77, JS
        [ 0xCA614C4E, 0xCA614C4F, "YN" ],  // 202.97.76.78-202.97.76.79, YN
        [ 0xCA614C50, 0xCA614C51, "SC" ],  // 202.97.76.80-202.97.76.81, SC
        [ 0xCA614C52, 0xCA614C54, "YN" ],  // 202.97.76.82-202.97.76.84, YN
        [ 0xCA614C55, 0xCA614C55, "SC" ],  // 202.97.76.85-202.97.76.85, SC
        [ 0xCA614C56, 0xCA614C5C, "YN" ],  // 202.97.76.86-202.97.76.92, YN
        [ 0xCA614C5D, 0xCA614C5D, "SC" ],  // 202.97.76.93-202.97.76.93, SC
        [ 0xCA614C5E, 0xCA614C60, "YN" ],  // 202.97.76.94-202.97.76.96, YN
        [ 0xCA614C61, 0xCA614C61, "JS" ],  // 202.97.76.97-202.97.76.97, JS
        [ 0xCA614C62, 0xCA614C64, "YN" ],  // 202.97.76.98-202.97.76.100, YN
        [ 0xCA614C65, 0xCA614C65, "JS" ],  // 202.97.76.101-202.97.76.101, JS
        [ 0xCA614C66, 0xCA614C6C, "YN" ],  // 202.97.76.102-202.97.76.108, YN
        [ 0xCA614C6D, 0xCA614C6D, "JS" ],  // 202.97.76.109-202.97.76.109, JS
        [ 0xCA614C6E, 0xCA614C70, "YN" ],  // 202.97.76.110-202.97.76.112, YN
        [ 0xCA614C71, 0xCA614C71, "ZJ" ],  // 202.97.76.113-202.97.76.113, ZJ
        [ 0xCA614C72, 0xCA614C73, "YN" ],  // 202.97.76.114-202.97.76.115, YN
        [ 0xCA614C74, 0xCA614C75, "ZJ" ],  // 202.97.76.116-202.97.76.117, ZJ
        [ 0xCA614C76, 0xCA614C78, "YN" ],  // 202.97.76.118-202.97.76.120, YN
        [ 0xCA614C79, 0xCA614C79, "ZJ" ],  // 202.97.76.121-202.97.76.121, ZJ
        [ 0xCA614C7A, 0xCA614C7C, "YN" ],  // 202.97.76.122-202.97.76.124, YN
        [ 0xCA614C7D, 0xCA614C7D, "ZJ" ],  // 202.97.76.125-202.97.76.125, ZJ
        [ 0xCA614C7E, 0xCA614C80, "YN" ],  // 202.97.76.126-202.97.76.128, YN
        [ 0xCA614C81, 0xCA614C81, "ZJ" ],  // 202.97.76.129-202.97.76.129, ZJ
        [ 0xCA614C82, 0xCA614C84, "YN" ],  // 202.97.76.130-202.97.76.132, YN
        [ 0xCA614C85, 0xCA614C85, "ZJ" ],  // 202.97.76.133-202.97.76.133, ZJ
        [ 0xCA614C86, 0xCA614C87, "YN" ],  // 202.97.76.134-202.97.76.135, YN
        [ 0xCA614C88, 0xCA614C89, "ZJ" ],  // 202.97.76.136-202.97.76.137, ZJ
        [ 0xCA614C8A, 0xCA614C8B, "YN" ],  // 202.97.76.138-202.97.76.139, YN
        [ 0xCA614C8C, 0xCA614C8D, "ZJ" ],  // 202.97.76.140-202.97.76.141, ZJ
        [ 0xCA614C8E, 0xCA614C90, "YN" ],  // 202.97.76.142-202.97.76.144, YN
        [ 0xCA614C91, 0xCA614C91, "ZJ" ],  // 202.97.76.145-202.97.76.145, ZJ
        [ 0xCA614C92, 0xCA614C94, "YN" ],  // 202.97.76.146-202.97.76.148, YN
        [ 0xCA614C95, 0xCA614C95, "ZJ" ],  // 202.97.76.149-202.97.76.149, ZJ
        [ 0xCA614C96, 0xCA614C98, "YN" ],  // 202.97.76.150-202.97.76.152, YN
        [ 0xCA614C99, 0xCA614C99, "ZJ" ],  // 202.97.76.153-202.97.76.153, ZJ
        [ 0xCA614C9A, 0xCA614C9C, "YN" ],  // 202.97.76.154-202.97.76.156, YN
        [ 0xCA614C9D, 0xCA614C9D, "ZJ" ],  // 202.97.76.157-202.97.76.157, ZJ
        [ 0xCA614C9E, 0xCA614CB0, "YN" ],  // 202.97.76.158-202.97.76.176, YN
        [ 0xCA614CB1, 0xCA614CB1, "GD" ],  // 202.97.76.177-202.97.76.177, GD
        [ 0xCA614CB2, 0xCA614CB4, "YN" ],  // 202.97.76.178-202.97.76.180, YN
        [ 0xCA614CB5, 0xCA614CB5, "GD" ],  // 202.97.76.181-202.97.76.181, GD
        [ 0xCA614CB6, 0xCA614CB8, "YN" ],  // 202.97.76.182-202.97.76.184, YN
        [ 0xCA614CB9, 0xCA614CB9, "GD" ],  // 202.97.76.185-202.97.76.185, GD
        [ 0xCA614CBA, 0xCA614CBC, "YN" ],  // 202.97.76.186-202.97.76.188, YN
        [ 0xCA614CBD, 0xCA614CBD, "GD" ],  // 202.97.76.189-202.97.76.189, GD
        [ 0xCA614CBE, 0xCA614CC7, "YN" ],  // 202.97.76.190-202.97.76.199, YN
        [ 0xCA614CC8, 0xCA614CCD, "SN" ],  // 202.97.76.200-202.97.76.205, SN
        [ 0xCA614CCE, 0xCA614CCF, "YN" ],  // 202.97.76.206-202.97.76.207, YN
        [ 0xCA614CD0, 0xCA614CD1, "ZJ" ],  // 202.97.76.208-202.97.76.209, ZJ
        [ 0xCA614CD2, 0xCA614CD4, "YN" ],  // 202.97.76.210-202.97.76.212, YN
        [ 0xCA614CD5, 0xCA614CD5, "ZJ" ],  // 202.97.76.213-202.97.76.213, ZJ
        [ 0xCA614CD6, 0xCA614CD7, "YN" ],  // 202.97.76.214-202.97.76.215, YN
        [ 0xCA614CD8, 0xCA614CD9, "GD" ],  // 202.97.76.216-202.97.76.217, GD
        [ 0xCA614CDA, 0xCA614CDC, "YN" ],  // 202.97.76.218-202.97.76.220, YN
        [ 0xCA614CDD, 0xCA614CDD, "GD" ],  // 202.97.76.221-202.97.76.221, GD
        [ 0xCA614CDE, 0xCA614CE0, "YN" ],  // 202.97.76.222-202.97.76.224, YN
        [ 0xCA614CE1, 0xCA614CE1, "GD" ],  // 202.97.76.225-202.97.76.225, GD
        [ 0xCA614CE2, 0xCA614CE4, "YN" ],  // 202.97.76.226-202.97.76.228, YN
        [ 0xCA614CE5, 0xCA614CE5, "GD" ],  // 202.97.76.229-202.97.76.229, GD
        [ 0xCA614CE6, 0xCA614CFF, "YN" ],  // 202.97.76.230-202.97.76.255, YN
        [ 0xCA614D00, 0xCA614DFF, "GD" ],  // 202.97.77.0-202.97.77.255, GD
        [ 0xCA614E00, 0xCA614E0C, "BJ" ],  // 202.97.78.0-202.97.78.12, BJ
        [ 0xCA614E0D, 0xCA614E0D, "SN" ],  // 202.97.78.13-202.97.78.13, SN
        [ 0xCA614E0E, 0xCA614E10, "BJ" ],  // 202.97.78.14-202.97.78.16, BJ
        [ 0xCA614E11, 0xCA614E11, "SN" ],  // 202.97.78.17-202.97.78.17, SN
        [ 0xCA614E12, 0xCA614E12, "ZJ" ],  // 202.97.78.18-202.97.78.18, ZJ
        [ 0xCA614E13, 0xCA614E13, "BJ" ],  // 202.97.78.19-202.97.78.19, BJ
        [ 0xCA614E14, 0xCA614E15, "SN" ],  // 202.97.78.20-202.97.78.21, SN
        [ 0xCA614E16, 0xCA614E16, "ZJ" ],  // 202.97.78.22-202.97.78.22, ZJ
        [ 0xCA614E17, 0xCA614E19, "SN" ],  // 202.97.78.23-202.97.78.25, SN
        [ 0xCA614E1A, 0xCA614E1C, "ZJ" ],  // 202.97.78.26-202.97.78.28, ZJ
        [ 0xCA614E1D, 0xCA614E20, "BJ" ],  // 202.97.78.29-202.97.78.32, BJ
        [ 0xCA614E21, 0xCA614E21, "SN" ],  // 202.97.78.33-202.97.78.33, SN
        [ 0xCA614E22, 0xCA614E22, "SC" ],  // 202.97.78.34-202.97.78.34, SC
        [ 0xCA614E23, 0xCA614E38, "BJ" ],  // 202.97.78.35-202.97.78.56, BJ
        [ 0xCA614E39, 0xCA614E39, "SN" ],  // 202.97.78.57-202.97.78.57, SN
        [ 0xCA614E3A, 0xCA614E3A, "SC" ],  // 202.97.78.58-202.97.78.58, SC
        [ 0xCA614E3B, 0xCA614E3C, "BJ" ],  // 202.97.78.59-202.97.78.60, BJ
        [ 0xCA614E3D, 0xCA614E3D, "SN" ],  // 202.97.78.61-202.97.78.61, SN
        [ 0xCA614E3E, 0xCA614E3E, "SC" ],  // 202.97.78.62-202.97.78.62, SC
        [ 0xCA614E3F, 0xCA614E40, "BJ" ],  // 202.97.78.63-202.97.78.64, BJ
        [ 0xCA614E41, 0xCA614E41, "JS" ],  // 202.97.78.65-202.97.78.65, JS
        [ 0xCA614E42, 0xCA614E42, "SN" ],  // 202.97.78.66-202.97.78.66, SN
        [ 0xCA614E43, 0xCA614E45, "BJ" ],  // 202.97.78.67-202.97.78.69, BJ
        [ 0xCA614E46, 0xCA614E46, "SN" ],  // 202.97.78.70-202.97.78.70, SN
        [ 0xCA614E47, 0xCA614E54, "BJ" ],  // 202.97.78.71-202.97.78.84, BJ
        [ 0xCA614E55, 0xCA614E55, "JS" ],  // 202.97.78.85-202.97.78.85, JS
        [ 0xCA614E56, 0xCA614E5C, "BJ" ],  // 202.97.78.86-202.97.78.92, BJ
        [ 0xCA614E5D, 0xCA614E5D, "JS" ],  // 202.97.78.93-202.97.78.93, JS
        [ 0xCA614E5E, 0xCA614E5E, "SN" ],  // 202.97.78.94-202.97.78.94, SN
        [ 0xCA614E5F, 0xCA614E60, "BJ" ],  // 202.97.78.95-202.97.78.96, BJ
        [ 0xCA614E61, 0xCA614E61, "GD" ],  // 202.97.78.97-202.97.78.97, GD
        [ 0xCA614E62, 0xCA614E62, "SN" ],  // 202.97.78.98-202.97.78.98, SN
        [ 0xCA614E63, 0xCA614E64, "BJ" ],  // 202.97.78.99-202.97.78.100, BJ
        [ 0xCA614E65, 0xCA614E65, "GD" ],  // 202.97.78.101-202.97.78.101, GD
        [ 0xCA614E66, 0xCA614E66, "SN" ],  // 202.97.78.102-202.97.78.102, SN
        [ 0xCA614E67, 0xCA614E68, "BJ" ],  // 202.97.78.103-202.97.78.104, BJ
        [ 0xCA614E69, 0xCA614E69, "GD" ],  // 202.97.78.105-202.97.78.105, GD
        [ 0xCA614E6A, 0xCA614E6A, "SN" ],  // 202.97.78.106-202.97.78.106, SN
        [ 0xCA614E6B, 0xCA614E6C, "BJ" ],  // 202.97.78.107-202.97.78.108, BJ
        [ 0xCA614E6D, 0xCA614E6D, "GD" ],  // 202.97.78.109-202.97.78.109, GD
        [ 0xCA614E6E, 0xCA614E6E, "SN" ],  // 202.97.78.110-202.97.78.110, SN
        [ 0xCA614E6F, 0xCA614E70, "BJ" ],  // 202.97.78.111-202.97.78.112, BJ
        [ 0xCA614E71, 0xCA614E71, "GD" ],  // 202.97.78.113-202.97.78.113, GD
        [ 0xCA614E72, 0xCA614E72, "SN" ],  // 202.97.78.114-202.97.78.114, SN
        [ 0xCA614E73, 0xCA614E74, "BJ" ],  // 202.97.78.115-202.97.78.116, BJ
        [ 0xCA614E75, 0xCA614E75, "GD" ],  // 202.97.78.117-202.97.78.117, GD
        [ 0xCA614E76, 0xCA614E76, "SN" ],  // 202.97.78.118-202.97.78.118, SN
        [ 0xCA614E77, 0xCA614E78, "BJ" ],  // 202.97.78.119-202.97.78.120, BJ
        [ 0xCA614E79, 0xCA614E79, "GD" ],  // 202.97.78.121-202.97.78.121, GD
        [ 0xCA614E7A, 0xCA614E7A, "SN" ],  // 202.97.78.122-202.97.78.122, SN
        [ 0xCA614E7B, 0xCA614E7C, "BJ" ],  // 202.97.78.123-202.97.78.124, BJ
        [ 0xCA614E7D, 0xCA614E7D, "GD" ],  // 202.97.78.125-202.97.78.125, GD
        [ 0xCA614E7E, 0xCA614E7E, "SN" ],  // 202.97.78.126-202.97.78.126, SN
        [ 0xCA614E7F, 0xCA614E80, "BJ" ],  // 202.97.78.127-202.97.78.128, BJ
        [ 0xCA614E81, 0xCA614E81, "SN" ],  // 202.97.78.129-202.97.78.129, SN
        [ 0xCA614E82, 0xCA614E82, "HB" ],  // 202.97.78.130-202.97.78.130, HB
        [ 0xCA614E83, 0xCA614E84, "BJ" ],  // 202.97.78.131-202.97.78.132, BJ
        [ 0xCA614E85, 0xCA614E85, "SN" ],  // 202.97.78.133-202.97.78.133, SN
        [ 0xCA614E86, 0xCA614E86, "HB" ],  // 202.97.78.134-202.97.78.134, HB
        [ 0xCA614E87, 0xCA614E88, "BJ" ],  // 202.97.78.135-202.97.78.136, BJ
        [ 0xCA614E89, 0xCA614E89, "SN" ],  // 202.97.78.137-202.97.78.137, SN
        [ 0xCA614E8A, 0xCA614E8A, "HB" ],  // 202.97.78.138-202.97.78.138, HB
        [ 0xCA614E8B, 0xCA614E8C, "BJ" ],  // 202.97.78.139-202.97.78.140, BJ
        [ 0xCA614E8D, 0xCA614E8D, "SN" ],  // 202.97.78.141-202.97.78.141, SN
        [ 0xCA614E8E, 0xCA614E8E, "HB" ],  // 202.97.78.142-202.97.78.142, HB
        [ 0xCA614E8F, 0xCA614E90, "BJ" ],  // 202.97.78.143-202.97.78.144, BJ
        [ 0xCA614E91, 0xCA614E91, "SN" ],  // 202.97.78.145-202.97.78.145, SN
        [ 0xCA614E92, 0xCA614E92, "HB" ],  // 202.97.78.146-202.97.78.146, HB
        [ 0xCA614E93, 0xCA614E9C, "BJ" ],  // 202.97.78.147-202.97.78.156, BJ
        [ 0xCA614E9D, 0xCA614E9D, "SN" ],  // 202.97.78.157-202.97.78.157, SN
        [ 0xCA614E9E, 0xCA614E9E, "HB" ],  // 202.97.78.158-202.97.78.158, HB
        [ 0xCA614E9F, 0xCA614EA0, "BJ" ],  // 202.97.78.159-202.97.78.160, BJ
        [ 0xCA614EA1, 0xCA614EA1, "SN" ],  // 202.97.78.161-202.97.78.161, SN
        [ 0xCA614EA2, 0xCA614EA2, "SC" ],  // 202.97.78.162-202.97.78.162, SC
        [ 0xCA614EA3, 0xCA614EA8, "BJ" ],  // 202.97.78.163-202.97.78.168, BJ
        [ 0xCA614EA9, 0xCA614EA9, "SN" ],  // 202.97.78.169-202.97.78.169, SN
        [ 0xCA614EAA, 0xCA614EAA, "SC" ],  // 202.97.78.170-202.97.78.170, SC
        [ 0xCA614EAB, 0xCA614EAC, "BJ" ],  // 202.97.78.171-202.97.78.172, BJ
        [ 0xCA614EAD, 0xCA614EAD, "SN" ],  // 202.97.78.173-202.97.78.173, SN
        [ 0xCA614EAE, 0xCA614EAE, "SC" ],  // 202.97.78.174-202.97.78.174, SC
        [ 0xCA614EAF, 0xCA614EB0, "BJ" ],  // 202.97.78.175-202.97.78.176, BJ
        [ 0xCA614EB1, 0xCA614EB1, "SN" ],  // 202.97.78.177-202.97.78.177, SN
        [ 0xCA614EB2, 0xCA614EB2, "ZJ" ],  // 202.97.78.178-202.97.78.178, ZJ
        [ 0xCA614EB3, 0xCA614EB4, "BJ" ],  // 202.97.78.179-202.97.78.180, BJ
        [ 0xCA614EB5, 0xCA614EB5, "SN" ],  // 202.97.78.181-202.97.78.181, SN
        [ 0xCA614EB6, 0xCA614EB8, "BJ" ],  // 202.97.78.182-202.97.78.184, BJ
        [ 0xCA614EB9, 0xCA614EB9, "SN" ],  // 202.97.78.185-202.97.78.185, SN
        [ 0xCA614EBA, 0xCA614EBA, "ZJ" ],  // 202.97.78.186-202.97.78.186, ZJ
        [ 0xCA614EBB, 0xCA614EBC, "BJ" ],  // 202.97.78.187-202.97.78.188, BJ
        [ 0xCA614EBD, 0xCA614EBD, "SN" ],  // 202.97.78.189-202.97.78.189, SN
        [ 0xCA614EBE, 0xCA614EBE, "ZJ" ],  // 202.97.78.190-202.97.78.190, ZJ
        [ 0xCA614EBF, 0xCA614EC8, "BJ" ],  // 202.97.78.191-202.97.78.200, BJ
        [ 0xCA614EC9, 0xCA614EC9, "SN" ],  // 202.97.78.201-202.97.78.201, SN
        [ 0xCA614ECA, 0xCA614ECA, "SC" ],  // 202.97.78.202-202.97.78.202, SC
        [ 0xCA614ECB, 0xCA614ECC, "BJ" ],  // 202.97.78.203-202.97.78.204, BJ
        [ 0xCA614ECD, 0xCA614ECD, "SN" ],  // 202.97.78.205-202.97.78.205, SN
        [ 0xCA614ECE, 0xCA614EE0, "BJ" ],  // 202.97.78.206-202.97.78.224, BJ
        [ 0xCA614EE1, 0xCA614EE1, "SN" ],  // 202.97.78.225-202.97.78.225, SN
        [ 0xCA614EE2, 0xCA614EE2, "AH" ],  // 202.97.78.226-202.97.78.226, AH
        [ 0xCA614EE3, 0xCA614EE8, "BJ" ],  // 202.97.78.227-202.97.78.232, BJ
        [ 0xCA614EE9, 0xCA614EE9, "SN" ],  // 202.97.78.233-202.97.78.233, SN
        [ 0xCA614EEA, 0xCA614EEA, "AH" ],  // 202.97.78.234-202.97.78.234, AH
        [ 0xCA614EEB, 0xCA614EED, "BJ" ],  // 202.97.78.235-202.97.78.237, BJ
        [ 0xCA614EEE, 0xCA614EEE, "HB" ],  // 202.97.78.238-202.97.78.238, HB
        [ 0xCA614EEF, 0xCA614EF0, "BJ" ],  // 202.97.78.239-202.97.78.240, BJ
        [ 0xCA614EF1, 0xCA614EF1, "SN" ],  // 202.97.78.241-202.97.78.241, SN
        [ 0xCA614EF2, 0xCA614EF2, "JX" ],  // 202.97.78.242-202.97.78.242, JX
        [ 0xCA614EF3, 0xCA614EF8, "BJ" ],  // 202.97.78.243-202.97.78.248, BJ
        [ 0xCA614EF9, 0xCA614EF9, "SN" ],  // 202.97.78.249-202.97.78.249, SN
        [ 0xCA614EFA, 0xCA614EFA, "JX" ],  // 202.97.78.250-202.97.78.250, JX
        [ 0xCA614EFB, 0xCA614EFC, "BJ" ],  // 202.97.78.251-202.97.78.252, BJ
        [ 0xCA614EFD, 0xCA614EFD, "SN" ],  // 202.97.78.253-202.97.78.253, SN
        [ 0xCA614EFE, 0xCA614FFF, "TJ" ],  // 202.97.78.254-202.97.79.255, TJ
        [ 0xCA615000, 0xCA6150FF, "HA" ],  // 202.97.80.0-202.97.80.255, HA
        [ 0xCA615100, 0xCA6151FF, "LN" ],  // 202.97.81.0-202.97.81.255, LN
        [ 0xCA615200, 0xCA615201, "SH" ],  // 202.97.82.0-202.97.82.1, SH
        [ 0xCA615202, 0xCA615202, "ZJ" ],  // 202.97.82.2-202.97.82.2, ZJ
        [ 0xCA615203, 0xCA61520D, "SH" ],  // 202.97.82.3-202.97.82.13, SH
        [ 0xCA61520E, 0xCA61520E, "BJ" ],  // 202.97.82.14-202.97.82.14, BJ
        [ 0xCA61520F, 0xCA61520F, "SH" ],  // 202.97.82.15-202.97.82.15, SH
        [ 0xCA615210, 0xCA615210, "GS" ],  // 202.97.82.16-202.97.82.16, GS
        [ 0xCA615211, 0xCA615211, "SH" ],  // 202.97.82.17-202.97.82.17, SH
        [ 0xCA615212, 0xCA615212, "ZJ" ],  // 202.97.82.18-202.97.82.18, ZJ
        [ 0xCA615213, 0xCA615214, "GS" ],  // 202.97.82.19-202.97.82.20, GS
        [ 0xCA615215, 0xCA615215, "SH" ],  // 202.97.82.21-202.97.82.21, SH
        [ 0xCA615216, 0xCA615216, "ZJ" ],  // 202.97.82.22-202.97.82.22, ZJ
        [ 0xCA615217, 0xCA615220, "GS" ],  // 202.97.82.23-202.97.82.32, GS
        [ 0xCA615221, 0xCA615222, "SH" ],  // 202.97.82.33-202.97.82.34, SH
        [ 0xCA615223, 0xCA615224, "GS" ],  // 202.97.82.35-202.97.82.36, GS
        [ 0xCA615225, 0xCA615226, "SH" ],  // 202.97.82.37-202.97.82.38, SH
        [ 0xCA615227, 0xCA615228, "GS" ],  // 202.97.82.39-202.97.82.40, GS
        [ 0xCA615229, 0xCA615229, "SH" ],  // 202.97.82.41-202.97.82.41, SH
        [ 0xCA61522A, 0xCA61522A, "JS" ],  // 202.97.82.42-202.97.82.42, JS
        [ 0xCA61522B, 0xCA615230, "GS" ],  // 202.97.82.43-202.97.82.48, GS
        [ 0xCA615231, 0xCA615231, "SH" ],  // 202.97.82.49-202.97.82.49, SH
        [ 0xCA615232, 0xCA615232, "FJ" ],  // 202.97.82.50-202.97.82.50, FJ
        [ 0xCA615233, 0xCA615234, "GS" ],  // 202.97.82.51-202.97.82.52, GS
        [ 0xCA615235, 0xCA615235, "SH" ],  // 202.97.82.53-202.97.82.53, SH
        [ 0xCA615236, 0xCA615236, "FJ" ],  // 202.97.82.54-202.97.82.54, FJ
        [ 0xCA615237, 0xCA615238, "GS" ],  // 202.97.82.55-202.97.82.56, GS
        [ 0xCA615239, 0xCA615239, "SH" ],  // 202.97.82.57-202.97.82.57, SH
        [ 0xCA61523A, 0xCA61523A, "BJ" ],  // 202.97.82.58-202.97.82.58, BJ
        [ 0xCA61523B, 0xCA61523C, "GS" ],  // 202.97.82.59-202.97.82.60, GS
        [ 0xCA61523D, 0xCA61523D, "SH" ],  // 202.97.82.61-202.97.82.61, SH
        [ 0xCA61523E, 0xCA615240, "GS" ],  // 202.97.82.62-202.97.82.64, GS
        [ 0xCA615241, 0xCA615241, "SH" ],  // 202.97.82.65-202.97.82.65, SH
        [ 0xCA615242, 0xCA615242, "FJ" ],  // 202.97.82.66-202.97.82.66, FJ
        [ 0xCA615243, 0xCA615244, "GS" ],  // 202.97.82.67-202.97.82.68, GS
        [ 0xCA615245, 0xCA615245, "SH" ],  // 202.97.82.69-202.97.82.69, SH
        [ 0xCA615246, 0xCA615246, "FJ" ],  // 202.97.82.70-202.97.82.70, FJ
        [ 0xCA615247, 0xCA615248, "GS" ],  // 202.97.82.71-202.97.82.72, GS
        [ 0xCA615249, 0xCA615249, "SH" ],  // 202.97.82.73-202.97.82.73, SH
        [ 0xCA61524A, 0xCA61524C, "GS" ],  // 202.97.82.74-202.97.82.76, GS
        [ 0xCA61524D, 0xCA61524D, "SH" ],  // 202.97.82.77-202.97.82.77, SH
        [ 0xCA61524E, 0xCA61524E, "FJ" ],  // 202.97.82.78-202.97.82.78, FJ
        [ 0xCA61524F, 0xCA615250, "GS" ],  // 202.97.82.79-202.97.82.80, GS
        [ 0xCA615251, 0xCA615251, "SH" ],  // 202.97.82.81-202.97.82.81, SH
        [ 0xCA615252, 0xCA615252, "GD" ],  // 202.97.82.82-202.97.82.82, GD
        [ 0xCA615253, 0xCA615254, "GS" ],  // 202.97.82.83-202.97.82.84, GS
        [ 0xCA615255, 0xCA615255, "SH" ],  // 202.97.82.85-202.97.82.85, SH
        [ 0xCA615256, 0xCA615256, "GD" ],  // 202.97.82.86-202.97.82.86, GD
        [ 0xCA615257, 0xCA615258, "GS" ],  // 202.97.82.87-202.97.82.88, GS
        [ 0xCA615259, 0xCA615259, "SH" ],  // 202.97.82.89-202.97.82.89, SH
        [ 0xCA61525A, 0xCA61525A, "GD" ],  // 202.97.82.90-202.97.82.90, GD
        [ 0xCA61525B, 0xCA615260, "GS" ],  // 202.97.82.91-202.97.82.96, GS
        [ 0xCA615261, 0xCA615262, "SH" ],  // 202.97.82.97-202.97.82.98, SH
        [ 0xCA615263, 0xCA615264, "GS" ],  // 202.97.82.99-202.97.82.100, GS
        [ 0xCA615265, 0xCA615266, "SH" ],  // 202.97.82.101-202.97.82.102, SH
        [ 0xCA615267, 0xCA615268, "GS" ],  // 202.97.82.103-202.97.82.104, GS
        [ 0xCA615269, 0xCA61526A, "SH" ],  // 202.97.82.105-202.97.82.106, SH
        [ 0xCA61526B, 0xCA61526C, "GS" ],  // 202.97.82.107-202.97.82.108, GS
        [ 0xCA61526D, 0xCA61526E, "SH" ],  // 202.97.82.109-202.97.82.110, SH
        [ 0xCA61526F, 0xCA615270, "GS" ],  // 202.97.82.111-202.97.82.112, GS
        [ 0xCA615271, 0xCA615271, "SH" ],  // 202.97.82.113-202.97.82.113, SH
        [ 0xCA615272, 0xCA615272, "JX" ],  // 202.97.82.114-202.97.82.114, JX
        [ 0xCA615273, 0xCA615274, "GS" ],  // 202.97.82.115-202.97.82.116, GS
        [ 0xCA615275, 0xCA615275, "SH" ],  // 202.97.82.117-202.97.82.117, SH
        [ 0xCA615276, 0xCA615276, "JX" ],  // 202.97.82.118-202.97.82.118, JX
        [ 0xCA615277, 0xCA615278, "GS" ],  // 202.97.82.119-202.97.82.120, GS
        [ 0xCA615279, 0xCA615279, "SH" ],  // 202.97.82.121-202.97.82.121, SH
        [ 0xCA61527A, 0xCA61527A, "JX" ],  // 202.97.82.122-202.97.82.122, JX
        [ 0xCA61527B, 0xCA61527B, "GS" ],  // 202.97.82.123-202.97.82.123, GS
        [ 0xCA61527C, 0xCA61527F, "JX" ],  // 202.97.82.124-202.97.82.127, JX
        [ 0xCA615280, 0xCA615280, "GS" ],  // 202.97.82.128-202.97.82.128, GS
        [ 0xCA615281, 0xCA615281, "SH" ],  // 202.97.82.129-202.97.82.129, SH
        [ 0xCA615282, 0xCA615282, "AH" ],  // 202.97.82.130-202.97.82.130, AH
        [ 0xCA615283, 0xCA615284, "GS" ],  // 202.97.82.131-202.97.82.132, GS
        [ 0xCA615285, 0xCA615285, "SH" ],  // 202.97.82.133-202.97.82.133, SH
        [ 0xCA615286, 0xCA615286, "AH" ],  // 202.97.82.134-202.97.82.134, AH
        [ 0xCA615287, 0xCA615288, "GS" ],  // 202.97.82.135-202.97.82.136, GS
        [ 0xCA615289, 0xCA615289, "SH" ],  // 202.97.82.137-202.97.82.137, SH
        [ 0xCA61528A, 0xCA61528A, "AH" ],  // 202.97.82.138-202.97.82.138, AH
        [ 0xCA61528B, 0xCA61528C, "GS" ],  // 202.97.82.139-202.97.82.140, GS
        [ 0xCA61528D, 0xCA61528D, "SH" ],  // 202.97.82.141-202.97.82.141, SH
        [ 0xCA61528E, 0xCA61528E, "AH" ],  // 202.97.82.142-202.97.82.142, AH
        [ 0xCA61528F, 0xCA615290, "GS" ],  // 202.97.82.143-202.97.82.144, GS
        [ 0xCA615291, 0xCA615291, "JS" ],  // 202.97.82.145-202.97.82.145, JS
        [ 0xCA615292, 0xCA615292, "AH" ],  // 202.97.82.146-202.97.82.146, AH
        [ 0xCA615293, 0xCA615294, "GS" ],  // 202.97.82.147-202.97.82.148, GS
        [ 0xCA615295, 0xCA615295, "SH" ],  // 202.97.82.149-202.97.82.149, SH
        [ 0xCA615296, 0xCA615296, "GD" ],  // 202.97.82.150-202.97.82.150, GD
        [ 0xCA615297, 0xCA615299, "GS" ],  // 202.97.82.151-202.97.82.153, GS
        [ 0xCA61529A, 0xCA61529A, "AH" ],  // 202.97.82.154-202.97.82.154, AH
        [ 0xCA61529B, 0xCA6152A1, "GS" ],  // 202.97.82.155-202.97.82.161, GS
        [ 0xCA6152A2, 0xCA6152A2, "AH" ],  // 202.97.82.162-202.97.82.162, AH
        [ 0xCA6152A3, 0xCA6152A5, "GS" ],  // 202.97.82.163-202.97.82.165, GS
        [ 0xCA6152A6, 0xCA6152A6, "AH" ],  // 202.97.82.166-202.97.82.166, AH
        [ 0xCA6152A7, 0xCA6152A9, "GS" ],  // 202.97.82.167-202.97.82.169, GS
        [ 0xCA6152AA, 0xCA6152AA, "AH" ],  // 202.97.82.170-202.97.82.170, AH
        [ 0xCA6152AB, 0xCA6152AD, "GS" ],  // 202.97.82.171-202.97.82.173, GS
        [ 0xCA6152AE, 0xCA6152AE, "AH" ],  // 202.97.82.174-202.97.82.174, AH
        [ 0xCA6152AF, 0xCA6152B0, "GS" ],  // 202.97.82.175-202.97.82.176, GS
        [ 0xCA6152B1, 0xCA6152B1, "AH" ],  // 202.97.82.177-202.97.82.177, AH
        [ 0xCA6152B2, 0xCA6152B8, "GS" ],  // 202.97.82.178-202.97.82.184, GS
        [ 0xCA6152B9, 0xCA6152B9, "JS" ],  // 202.97.82.185-202.97.82.185, JS
        [ 0xCA6152BA, 0xCA6152C0, "GS" ],  // 202.97.82.186-202.97.82.192, GS
        [ 0xCA6152C1, 0xCA6152C1, "JS" ],  // 202.97.82.193-202.97.82.193, JS
        [ 0xCA6152C2, 0xCA6152C2, "HN" ],  // 202.97.82.194-202.97.82.194, HN
        [ 0xCA6152C3, 0xCA6152C9, "GS" ],  // 202.97.82.195-202.97.82.201, GS
        [ 0xCA6152CA, 0xCA6152CA, "HN" ],  // 202.97.82.202-202.97.82.202, HN
        [ 0xCA6152CB, 0xCA6152D1, "GS" ],  // 202.97.82.203-202.97.82.209, GS
        [ 0xCA6152D2, 0xCA6152D2, "HN" ],  // 202.97.82.210-202.97.82.210, HN
        [ 0xCA6152D3, 0xCA6152D9, "GS" ],  // 202.97.82.211-202.97.82.217, GS
        [ 0xCA6152DA, 0xCA6152DA, "HN" ],  // 202.97.82.218-202.97.82.218, HN
        [ 0xCA6152DB, 0xCA6152E1, "GS" ],  // 202.97.82.219-202.97.82.225, GS
        [ 0xCA6152E2, 0xCA6152E2, "HE" ],  // 202.97.82.226-202.97.82.226, HE
        [ 0xCA6152E3, 0xCA6152E8, "GS" ],  // 202.97.82.227-202.97.82.232, GS
        [ 0xCA6152E9, 0xCA6152E9, "JS" ],  // 202.97.82.233-202.97.82.233, JS
        [ 0xCA6152EA, 0xCA6152F1, "GS" ],  // 202.97.82.234-202.97.82.241, GS
        [ 0xCA6152F2, 0xCA6152F2, "GX" ],  // 202.97.82.242-202.97.82.242, GX
        [ 0xCA6152F3, 0xCA6152F3, "GS" ],  // 202.97.82.243-202.97.82.243, GS
        [ 0xCA6152F4, 0xCA6152FB, "GX" ],  // 202.97.82.244-202.97.82.251, GX
        [ 0xCA6152FC, 0xCA6152FD, "GS" ],  // 202.97.82.252-202.97.82.253, GS
        [ 0xCA6152FE, 0xCA6152FE, "GX" ],  // 202.97.82.254-202.97.82.254, GX
        [ 0xCA6152FF, 0xCA6152FF, "GS" ],  // 202.97.82.255-202.97.82.255, GS
        [ 0xCA615300, 0xCA6153FF, "CQ" ],  // 202.97.83.0-202.97.83.255, CQ
        [ 0xCA615400, 0xCA615481, "SH" ],  // 202.97.84.0-202.97.84.129, SH
        [ 0xCA615482, 0xCA615482, "AH" ],  // 202.97.84.130-202.97.84.130, AH
        [ 0xCA615483, 0xCA615484, "JS" ],  // 202.97.84.131-202.97.84.132, JS
        [ 0xCA615485, 0xCA615485, "SH" ],  // 202.97.84.133-202.97.84.133, SH
        [ 0xCA615486, 0xCA615486, "AH" ],  // 202.97.84.134-202.97.84.134, AH
        [ 0xCA615487, 0xCA615488, "JS" ],  // 202.97.84.135-202.97.84.136, JS
        [ 0xCA615489, 0xCA615489, "SH" ],  // 202.97.84.137-202.97.84.137, SH
        [ 0xCA61548A, 0xCA61548A, "AH" ],  // 202.97.84.138-202.97.84.138, AH
        [ 0xCA61548B, 0xCA61548C, "JS" ],  // 202.97.84.139-202.97.84.140, JS
        [ 0xCA61548D, 0xCA61548D, "SH" ],  // 202.97.84.141-202.97.84.141, SH
        [ 0xCA61548E, 0xCA61548E, "AH" ],  // 202.97.84.142-202.97.84.142, AH
        [ 0xCA61548F, 0xCA615490, "JS" ],  // 202.97.84.143-202.97.84.144, JS
        [ 0xCA615491, 0xCA615491, "SH" ],  // 202.97.84.145-202.97.84.145, SH
        [ 0xCA615492, 0xCA615492, "CQ" ],  // 202.97.84.146-202.97.84.146, CQ
        [ 0xCA615493, 0xCA615494, "JS" ],  // 202.97.84.147-202.97.84.148, JS
        [ 0xCA615495, 0xCA615495, "SH" ],  // 202.97.84.149-202.97.84.149, SH
        [ 0xCA615496, 0xCA615496, "CQ" ],  // 202.97.84.150-202.97.84.150, CQ
        [ 0xCA615497, 0xCA615499, "JS" ],  // 202.97.84.151-202.97.84.153, JS
        [ 0xCA61549A, 0xCA61549A, "CQ" ],  // 202.97.84.154-202.97.84.154, CQ
        [ 0xCA61549B, 0xCA61549C, "JS" ],  // 202.97.84.155-202.97.84.156, JS
        [ 0xCA61549D, 0xCA61549D, "SH" ],  // 202.97.84.157-202.97.84.157, SH
        [ 0xCA61549E, 0xCA61549E, "CQ" ],  // 202.97.84.158-202.97.84.158, CQ
        [ 0xCA61549F, 0xCA6154A1, "JS" ],  // 202.97.84.159-202.97.84.161, JS
        [ 0xCA6154A2, 0xCA6154A2, "JX" ],  // 202.97.84.162-202.97.84.162, JX
        [ 0xCA6154A3, 0xCA6154A4, "JS" ],  // 202.97.84.163-202.97.84.164, JS
        [ 0xCA6154A5, 0xCA6154A5, "SH" ],  // 202.97.84.165-202.97.84.165, SH
        [ 0xCA6154A6, 0xCA6154A6, "JX" ],  // 202.97.84.166-202.97.84.166, JX
        [ 0xCA6154A7, 0xCA6154A8, "JS" ],  // 202.97.84.167-202.97.84.168, JS
        [ 0xCA6154A9, 0xCA6154A9, "SH" ],  // 202.97.84.169-202.97.84.169, SH
        [ 0xCA6154AA, 0xCA6154AA, "JX" ],  // 202.97.84.170-202.97.84.170, JX
        [ 0xCA6154AB, 0xCA6154AC, "JS" ],  // 202.97.84.171-202.97.84.172, JS
        [ 0xCA6154AD, 0xCA6154AD, "SH" ],  // 202.97.84.173-202.97.84.173, SH
        [ 0xCA6154AE, 0xCA6154AE, "JX" ],  // 202.97.84.174-202.97.84.174, JX
        [ 0xCA6154AF, 0xCA6154B0, "JS" ],  // 202.97.84.175-202.97.84.176, JS
        [ 0xCA6154B1, 0xCA6154B1, "SH" ],  // 202.97.84.177-202.97.84.177, SH
        [ 0xCA6154B2, 0xCA6154B2, "GX" ],  // 202.97.84.178-202.97.84.178, GX
        [ 0xCA6154B3, 0xCA6154B4, "JS" ],  // 202.97.84.179-202.97.84.180, JS
        [ 0xCA6154B5, 0xCA6154B5, "SH" ],  // 202.97.84.181-202.97.84.181, SH
        [ 0xCA6154B6, 0xCA6154B6, "GX" ],  // 202.97.84.182-202.97.84.182, GX
        [ 0xCA6154B7, 0xCA6154B8, "JS" ],  // 202.97.84.183-202.97.84.184, JS
        [ 0xCA6154B9, 0xCA6154B9, "SH" ],  // 202.97.84.185-202.97.84.185, SH
        [ 0xCA6154BA, 0xCA6154BA, "GX" ],  // 202.97.84.186-202.97.84.186, GX
        [ 0xCA6154BB, 0xCA6154BC, "JS" ],  // 202.97.84.187-202.97.84.188, JS
        [ 0xCA6154BD, 0xCA6154BD, "SH" ],  // 202.97.84.189-202.97.84.189, SH
        [ 0xCA6154BE, 0xCA6154BE, "GX" ],  // 202.97.84.190-202.97.84.190, GX
        [ 0xCA6154BF, 0xCA6154C0, "JS" ],  // 202.97.84.191-202.97.84.192, JS
        [ 0xCA6154C1, 0xCA6154C1, "SH" ],  // 202.97.84.193-202.97.84.193, SH
        [ 0xCA6154C2, 0xCA6154C4, "JS" ],  // 202.97.84.194-202.97.84.196, JS
        [ 0xCA6154C5, 0xCA6154C5, "SH" ],  // 202.97.84.197-202.97.84.197, SH
        [ 0xCA6154C6, 0xCA6154C6, "HE" ],  // 202.97.84.198-202.97.84.198, HE
        [ 0xCA6154C7, 0xCA6154CC, "JS" ],  // 202.97.84.199-202.97.84.204, JS
        [ 0xCA6154CD, 0xCA6154CD, "SH" ],  // 202.97.84.205-202.97.84.205, SH
        [ 0xCA6154CE, 0xCA6154D9, "JS" ],  // 202.97.84.206-202.97.84.217, JS
        [ 0xCA6154DA, 0xCA6154DA, "YN" ],  // 202.97.84.218-202.97.84.218, YN
        [ 0xCA6154DB, 0xCA6154DC, "JS" ],  // 202.97.84.219-202.97.84.220, JS
        [ 0xCA6154DD, 0xCA6154DD, "ZJ" ],  // 202.97.84.221-202.97.84.221, ZJ
        [ 0xCA6154DE, 0xCA6154E0, "JS" ],  // 202.97.84.222-202.97.84.224, JS
        [ 0xCA6154E1, 0xCA6154E1, "HB" ],  // 202.97.84.225-202.97.84.225, HB
        [ 0xCA6154E2, 0xCA6154E2, "SH" ],  // 202.97.84.226-202.97.84.226, SH
        [ 0xCA6154E3, 0xCA6154E4, "JS" ],  // 202.97.84.227-202.97.84.228, JS
        [ 0xCA6154E5, 0xCA6154E5, "HB" ],  // 202.97.84.229-202.97.84.229, HB
        [ 0xCA6154E6, 0xCA6154E6, "SH" ],  // 202.97.84.230-202.97.84.230, SH
        [ 0xCA6154E7, 0xCA6154E8, "JS" ],  // 202.97.84.231-202.97.84.232, JS
        [ 0xCA6154E9, 0xCA6154E9, "HB" ],  // 202.97.84.233-202.97.84.233, HB
        [ 0xCA6154EA, 0xCA6154EA, "SH" ],  // 202.97.84.234-202.97.84.234, SH
        [ 0xCA6154EB, 0xCA6154EC, "JS" ],  // 202.97.84.235-202.97.84.236, JS
        [ 0xCA6154ED, 0xCA6154ED, "HB" ],  // 202.97.84.237-202.97.84.237, HB
        [ 0xCA6154EE, 0xCA6154EE, "SH" ],  // 202.97.84.238-202.97.84.238, SH
        [ 0xCA6154EF, 0xCA6154F0, "JS" ],  // 202.97.84.239-202.97.84.240, JS
        [ 0xCA6154F1, 0xCA6154F1, "HB" ],  // 202.97.84.241-202.97.84.241, HB
        [ 0xCA6154F2, 0xCA6154F2, "SH" ],  // 202.97.84.242-202.97.84.242, SH
        [ 0xCA6154F3, 0xCA6154F4, "JS" ],  // 202.97.84.243-202.97.84.244, JS
        [ 0xCA6154F5, 0xCA6154F5, "HB" ],  // 202.97.84.245-202.97.84.245, HB
        [ 0xCA6154F6, 0xCA6154F6, "SH" ],  // 202.97.84.246-202.97.84.246, SH
        [ 0xCA6154F7, 0xCA6154F8, "JS" ],  // 202.97.84.247-202.97.84.248, JS
        [ 0xCA6154F9, 0xCA6154F9, "HB" ],  // 202.97.84.249-202.97.84.249, HB
        [ 0xCA6154FA, 0xCA6154FA, "SH" ],  // 202.97.84.250-202.97.84.250, SH
        [ 0xCA6154FB, 0xCA6154FC, "JS" ],  // 202.97.84.251-202.97.84.252, JS
        [ 0xCA6154FD, 0xCA6154FD, "HB" ],  // 202.97.84.253-202.97.84.253, HB
        [ 0xCA6154FE, 0xCA6154FE, "SH" ],  // 202.97.84.254-202.97.84.254, SH
        [ 0xCA6154FF, 0xCA615502, "JS" ],  // 202.97.84.255-202.97.85.2, JS
        [ 0xCA615503, 0xCA615505, "BJ" ],  // 202.97.85.3-202.97.85.5, BJ
        [ 0xCA615506, 0xCA615506, "JS" ],  // 202.97.85.6-202.97.85.6, JS
        [ 0xCA615507, 0xCA615509, "BJ" ],  // 202.97.85.7-202.97.85.9, BJ
        [ 0xCA61550A, 0xCA61550A, "JS" ],  // 202.97.85.10-202.97.85.10, JS
        [ 0xCA61550B, 0xCA61550D, "BJ" ],  // 202.97.85.11-202.97.85.13, BJ
        [ 0xCA61550E, 0xCA61550E, "JS" ],  // 202.97.85.14-202.97.85.14, JS
        [ 0xCA61550F, 0xCA615511, "BJ" ],  // 202.97.85.15-202.97.85.17, BJ
        [ 0xCA615512, 0xCA615512, "XJ" ],  // 202.97.85.18-202.97.85.18, XJ
        [ 0xCA615513, 0xCA615515, "BJ" ],  // 202.97.85.19-202.97.85.21, BJ
        [ 0xCA615516, 0xCA615516, "XJ" ],  // 202.97.85.22-202.97.85.22, XJ
        [ 0xCA615517, 0xCA615519, "BJ" ],  // 202.97.85.23-202.97.85.25, BJ
        [ 0xCA61551A, 0xCA61551A, "XJ" ],  // 202.97.85.26-202.97.85.26, XJ
        [ 0xCA61551B, 0xCA615521, "BJ" ],  // 202.97.85.27-202.97.85.33, BJ
        [ 0xCA615522, 0xCA615522, "XJ" ],  // 202.97.85.34-202.97.85.34, XJ
        [ 0xCA615523, 0xCA615531, "BJ"